*FW4150.S-----------------------EDITION C02--04/01/08 11:02--CAMELON------------
	TTL	set_firmware_program
		SECTION ?fw_ss4150
	XDEF	fw_ss4150_start
	XDEF	fw_ss4150_end
*
* Description
* ===========
* This file contains the firmware program for the SS4150 set. This data is
* accessed via a PASCAL pointer in handlers.pas. The first 3 bytes of the 
* data below were added and are defined as below. The information in the
* this 3 byte header is contained here in order to avoid confusion when
* installing new firmware loads. The data size and version is maintained
* in these three bytes and therefore unique to this firware version.
*
* See DS.25 in SMS bularo "Set Firmware Download" for more information
* on the SX200 download tool.
*
* The SOURCE CODE FOR THE REFORMAT TOOL is stored in SMS BULARO and the
* file is called 'srec_to_sx200.c'.  That program converts the s-record
* format of the set firmware code to a format usable to the sx200 (the
* code in this file).
*
* Firmware code is released from set firmware group and compiled by
* Configuration Management who then run the reformat tool to generate
* this assembly language version.
*
*********************** FILE DATA FORMAT ************************
*   HEADER 3 bytes
*     byte1  software version (see MTS22 - Send Maintenance Data)
*                             (see NOTE below )
*     byte2  number of 66 byte lines to follow (high byte)
*     byte3  number of 66 byte lines to follow (low  byte)
*
*   FIRMWARE CODE 66 bytes per line (64 data + 2 address)
* The remaining bytes are the actual code to be downloaded to 
* the set firmware.
*****************************************************************
*
* Maintenance Notes:
* ==================
* If your installing a new firmware version for the same set type/file
* name then you only have to update the data and header in this file.
* You do not have to update any other file. The 3-byte header info will
* tell the rest of the sx200 program about this data (size and version).
*
* If your installing firmware for a different set type that requires 
* different firmware then a new version of this file with a different name
* would have to be created. Also you must edit the files init.s, osinit.s
* and main.mak, sx200.mak files. Those file would have to be updated to
* include the new file name and pointers to the new firmware code.
* It is the  SECTION ?FW_SS4090   statement at the top of this
* file that acts as the label for locating this code. For example if you
* created a new file called fw4125.s then that statement would be
*   SECTION ?FW_SS4125  and dealt with in the make and init files.
*
* There must be enough room is the SECTION definition in sx200.mak and
* main.mak to handle the size of this firmware code without running
* into the next section.
*
* You must XDEF in OSINIT.C a pointer in this SECTION to this data .
* The current SW version is calculated in INIT.PAS from this data.
* The first byte of this file is the version of the firmware and is put
* in automatically by the srec_to_sx200.c reformat tool. It is extracted
* from the firmware data itself usually at byte number 16.
* Also the number of 64 bytes of code lines for writing to the set is
* automatically generated and placed in bytes 2 and 3 of the header.
*
*
*       NOTES: There are 2 information in the BYTE of the firmware rev:
*              - BIT6 to BIT8 = firmware stream (A .. H)
*              - BIT1 to BIT5 = firmware revision number (0 .. 31)
*
*              For example, firmware rev BYTE = $4A  equivalent to C.10
*
*              stream = C    revision number = 10
*               ___|___     _______|_______ 
*              /       \   /               \
*              B8  B7  B6  B5  B4  B3  B2  B1
*               0   1   0   0   1   0   1   0  = $4A
*
*
* ************************************************************************
* HISTORY:
* Firmware code is released from Carl Heyendal and Kent Tran.
* A01 May 25/98 p.16315 Created   Steve Riding
*               version A01 Main 4.1 from Carl Heyendal
* A02 Jun 08/98 S Riding version A03 Main 27-may-98, supports ss4125,pkm
* A03 Jun 17/98 S Riding version B00 Main 5.0, supports ss4125,pkm,aim
* A04 Jul 09/98 S Riding version B02 Main 5.1, fixes sms bularo p.16477
* A05 Jul 14/98 S Riding version B03 Main 5.2 p.16431 p.16455 p.16466 p.16529
* A06 Jul 20/98 S Riding version B04 Main 5.3 p.16569 p.16576
* A07 Aug 18/98 S.R. ver B05 Main 5.4 p.16427 p.16567 p.16582 p.16625 p.16605
* A08 Aug 28/98 S Riding version B06 Main 5.5 p.16458 p.16629 p.16676
* A09 Sep 04/98 S Riding version B07 Main 5.6 p.16705 p.16721
* A10 Sep 12/98 S Riding version B08 Main 5.7 p.16707 p.16727
* A11 Sep 21/98 S Riding version B09 Main 5.8 p.16727 p.16750
* A12 Oct 22/98 E Eder version B10 Main 5.9 sx: p.35108
* A13 Oct 31/98 E. E. Ver 5.10, B11
* A14 Dec 10/98 E. E. Ver 5.11
* A15 Jan 06/99 E. E. Ver 5.12 - no fixes for bularo
* A16 Jan 06/99 E.E.  Ver 5.13 - no fixes for bularo
* A17 Jan 28/99 S Riding Ver 5.13 - enhanced comment section, 'srec_to_sx200.c'
* B01 Jun 11/99 E.E. ver 6.3 bularo fix p.17077
* B02 Sep 07/99 E.E. Ver 6.4 bularo fix p.17280
*
* CUT AND PASTE THIS OUTPUT INTO THE FIRMWARE DOWNLOAD FILE FOR THE SX200.
* VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
* This file was generated from the reformat program 'srec_to_sx200.c'.
* The following data is the firmware code for the SS4000 series sets.
* The code originates from the firmware design team and has been 
* reformatted to a more suitable format for the sx200. When a set
* firmware download has been requested by the user the sx200 writes
* this code to the set. The reformat tool takes the non-contiguous
* S-record file and converts it to this assembly language format.
*
* Conversion of version byte to 'MAIN version' goes like this.
* B.8 bit maps to 001 01000
*           stream--- -----release
* Main 5.7: 1+4=5 (stream+4) and 8-1=7 (release-1)
*
* F/W revision (extracted from this data): "MAIN 6.4  ", "C.5"
*
*
fw_ss4150_start:
  DC.B $45,$01,$78  * Header: version + num lines to follow (hi byte,lo byte)
  DC.B $80,$00,$20,$31,$4D,$41,$49,$4E,$20,$36,$2E,$34,$20,$20,$00,$45,$43
  DC.B $6F,$70,$79,$72,$69,$67,$68,$74,$28,$63,$29,$20,$31,$39,$39,$37,$2C
  DC.B $20,$4D,$69,$74,$65,$6C,$20,$43,$6F,$72,$70,$6F,$72,$61,$74,$69,$6F
  DC.B $6E,$00,$0F,$C6,$08,$0F,$8E,$00,$FF,$BD,$83,$24,$86,$36,$97         *1
  DC.B $80,$40,$3C,$86,$9E,$B7,$14,$00,$BD,$83,$24,$BD,$B2,$5C,$B6,$14,$30
  DC.B $84,$DF,$B7,$14,$30,$8A,$20,$B7,$14,$30,$B7,$18,$40,$BD,$83,$24,$BD
  DC.B $82,$9E,$86,$01,$B7,$3C,$BB,$F7,$22,$7E,$BD,$83,$02,$BD,$81,$BA,$BD
  DC.B $81,$65,$BD,$83,$24,$BD,$83,$24,$FE,$3C,$D8,$EE,$00,$AD,$00         *2
  DC.B $80,$80,$86,$01,$B7,$22,$7D,$FE,$3C,$D8,$EE,$02,$AD,$00,$BD,$D2,$07
  DC.B $FE,$3C,$D8,$EE,$04,$AD,$00,$36,$37,$C6,$0F,$86,$01,$18,$CE,$D1,$40
  DC.B $BD,$86,$5D,$33,$32,$BD,$A1,$61,$36,$37,$C6,$24,$86,$0A,$18,$CE,$DA
  DC.B $DE,$BD,$86,$5D,$33,$32,$36,$37,$C6,$10,$86,$01,$18,$CE,$D2         *3
  DC.B $80,$C0,$32,$BD,$86,$5D,$33,$32,$36,$37,$C6,$26,$86,$1E,$18,$CE,$BC
  DC.B $C9,$BD,$86,$5D,$33,$32,$FC,$22,$88,$26,$05,$BD,$81,$3D,$20,$F6,$18
  DC.B $3C,$18,$CE,$22,$88,$BD,$83,$83,$18,$38,$1F,$04,$20,$05,$BD,$84,$8E
  DC.B $20,$E2,$FF,$22,$86,$E6,$02,$27,$07,$C1,$27,$25,$08,$7E,$81         *4
  DC.B $81,$00,$64,$1A,$EE,$06,$26,$10,$E6,$03,$C1,$27,$24,$F2,$58,$18,$CE
  DC.B $81,$55,$18,$3A,$18,$EE,$00,$18,$AD,$00,$FE,$22,$86,$27,$B7,$A6,$04
  DC.B $2B,$B3,$0F,$7C,$3C,$BB,$CC,$00,$00,$FD,$22,$86,$BD,$84,$8E,$36,$07
  DC.B $7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$7E,$80,$D5,$B6,$22,$7F         *5
  DC.B $81,$40,$CE,$3C,$BC,$16,$58,$3A,$EE,$00,$AD,$00,$4C,$81,$06,$26,$02
  DC.B $86,$00,$B7,$22,$7F,$39,$81,$63,$CD,$F4,$A1,$25,$B2,$B1,$A1,$4D,$A1
  DC.B $4D,$A1,$57,$39,$00,$BD,$83,$B6,$BD,$83,$DF,$BD,$83,$F5,$BD,$83,$3C
  DC.B $BD,$85,$61,$18,$CE,$3C,$BC,$CE,$BB,$E3,$CD,$EF,$00,$FE,$3C         *6
  DC.B $81,$80,$D8,$EE,$06,$CD,$EF,$02,$CE,$BC,$55,$CD,$EF,$04,$FE,$3C,$D8
  DC.B $EE,$08,$CD,$EF,$06,$B6,$3C,$C8,$81,$00,$27,$05,$CE,$81,$63,$20,$03
  DC.B $CE,$AA,$73,$CD,$EF,$08,$81,$00,$27,$09,$81,$02,$27,$05,$CE,$81,$63
  DC.B $20,$03,$CE,$CD,$E7,$CD,$EF,$0A,$39,$BD,$81,$E5,$8D,$4C,$BD         *7
  DC.B $81,$C0,$82,$AA,$BD,$A8,$A3,$BD,$D8,$73,$BD,$D5,$1C,$BD,$82,$16,$BD
  DC.B $CA,$75,$7F,$3C,$BB,$0E,$BD,$83,$24,$BD,$DA,$87,$BD,$BF,$A4,$BD,$BE
  DC.B $56,$BD,$87,$9F,$39,$36,$15,$00,$40,$15,$26,$80,$12,$00,$80,$04,$86
  DC.B $03,$20,$12,$12,$00,$04,$0C,$12,$00,$02,$04,$86,$01,$20,$06         *8
  DC.B $82,$00,$86,$02,$20,$02,$86,$00,$B7,$3C,$C8,$32,$39,$86,$80,$97,$22
  DC.B $86,$FF,$97,$23,$97,$25,$39,$36,$37,$C6,$80,$86,$4A,$BD,$D6,$C4,$33
  DC.B $32,$36,$37,$C6,$80,$86,$1E,$BD,$D6,$C4,$33,$32,$36,$37,$C6,$00,$86
  DC.B $1E,$BD,$D6,$C4,$33,$32,$36,$37,$C6,$42,$86,$28,$BD,$D6,$C4         *9
  DC.B $82,$40,$33,$32,$36,$37,$C6,$58,$86,$1E,$BD,$D6,$C4,$33,$32,$36,$37
  DC.B $C6,$05,$86,$16,$BD,$D6,$C4,$33,$32,$36,$37,$C6,$2E,$86,$42,$BD,$D6
  DC.B $C4,$33,$32,$BD,$CA,$2E,$36,$37,$C6,$17,$86,$2A,$BD,$D6,$C4,$33,$32
  DC.B $36,$37,$C6,$E6,$86,$0C,$BD,$D6,$C4,$33,$32,$36,$37,$C6,$00         *a
  DC.B $82,$80,$86,$0A,$BD,$D6,$C4,$33,$32,$36,$37,$C6,$01,$86,$00,$BD,$D6
  DC.B $C4,$33,$32,$36,$37,$C6,$82,$86,$1C,$BD,$D6,$C4,$33,$32,$39,$CE,$20
  DC.B $00,$6F,$00,$08,$8C,$80,$00,$26,$F8,$39,$B6,$3C,$C8,$81,$03,$27,$06
  DC.B $86,$08,$97,$26,$20,$03,$7F,$00,$26,$86,$FB,$97,$09,$86,$3B         *b
  DC.B $82,$C0,$97,$08,$86,$58,$97,$28,$39,$3C,$CE,$00,$00,$FF,$22,$84,$38
  DC.B $BD,$83,$24,$BC,$22,$84,$26,$F8,$39,$87,$53,$87,$53,$87,$53,$87,$53
  DC.B $87,$53,$87,$53,$87,$53,$87,$53,$87,$53,$86,$F2,$87,$53,$87,$53,$87
  DC.B $53,$87,$53,$CE,$A7,$87,$53,$87,$53,$87,$56,$87,$59,$87,$53         *c
  DC.B $83,$00,$00,$00,$86,$7E,$36,$CE,$82,$D8,$18,$CE,$7F,$C4,$EC,$00,$27
  DC.B $12,$18,$ED,$01,$32,$36,$18,$A7,$00,$18,$08,$18,$08,$18,$08,$08,$08
  DC.B $20,$EA,$32,$39,$37,$36,$CC,$55,$AA,$97,$3A,$D7,$3A,$32,$33,$39,$36
  DC.B $07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$39,$CC,$00,$00,$FD         *d
  DC.B $83,$40,$22,$88,$FD,$22,$8A,$FD,$22,$8C,$FD,$22,$8E,$FD,$3B,$7F,$39
  DC.B $0F,$7C,$3C,$BB,$1E,$04,$40,$03,$7E,$E8,$00,$18,$3C,$18,$EE,$02,$27
  DC.B $0A,$CD,$EF,$00,$18,$38,$CD,$EF,$02,$20,$08,$18,$38,$CD,$EF,$00,$CD
  DC.B $EF,$02,$6F,$00,$6F,$01,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF         *e
  DC.B $83,$80,$06,$32,$39,$0F,$7C,$3C,$BB,$CD,$EE,$00,$27,$1E,$1E,$04,$40
  DC.B $03,$7E,$E8,$00,$36,$A6,$04,$84,$7F,$A7,$04,$32,$3C,$EE,$00,$CD,$EF
  DC.B $00,$26,$03,$CD,$EF,$02,$38,$8C,$00,$00,$36,$07,$7A,$3C,$BB,$26,$02
  DC.B $84,$EF,$06,$32,$39,$C6,$0F,$F7,$22,$80,$CC,$00,$8A,$FD,$22         *f
  DC.B $83,$C0,$82,$CE,$22,$98,$FF,$22,$96,$3C,$32,$33,$F3,$22,$82,$ED,$00
  DC.B $37,$36,$38,$7A,$22,$80,$26,$F3,$8F,$6F,$00,$6F,$01,$6F,$04,$39,$C6
  DC.B $23,$F7,$22,$80,$CC,$00,$6E,$FD,$22,$82,$CE,$2B,$3D,$FF,$2B,$3B,$3C
  DC.B $32,$33,$20,$D5,$C6,$18,$F7,$22,$80,$CC,$00,$08,$FD,$22,$82         *10
  DC.B $84,$00,$CE,$3A,$B7,$FF,$3A,$B5,$3C,$32,$33,$20,$BF,$36,$18,$3C,$0F
  DC.B $7C,$3C,$BB,$FE,$22,$96,$27,$0B,$1A,$EE,$00,$18,$FF,$22,$96,$86,$41
  DC.B $A7,$04,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$18,$38,$32,$39
  DC.B $36,$18,$3C,$0F,$7C,$3C,$BB,$FE,$2B,$3B,$27,$0B,$1A,$EE,$00         *11
  DC.B $84,$40,$18,$FF,$2B,$3B,$86,$42,$A7,$04,$36,$07,$7A,$3C,$BB,$26,$02
  DC.B $84,$EF,$06,$32,$18,$38,$32,$39,$36,$18,$3C,$0F,$7C,$3C,$BB,$FE,$3A
  DC.B $B5,$26,$11,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$0F,$7C,$3C
  DC.B $BB,$20,$EA,$1A,$EE,$00,$18,$FF,$3A,$B5,$86,$44,$A7,$04,$36         *12
  DC.B $84,$80,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$18,$38,$32,$39,$37
  DC.B $36,$18,$3C,$0F,$7C,$3C,$BB,$8C,$00,$00,$26,$03,$7E,$85,$26,$A6,$04
  DC.B $85,$40,$27,$F7,$18,$FE,$22,$88,$27,$10,$18,$CE,$22,$88,$CD,$AC,$00
  DC.B $27,$1D,$18,$EE,$00,$27,$02,$20,$F4,$18,$FE,$22,$8C,$27,$18         *13
  DC.B $84,$C0,$18,$CE,$22,$8C,$CD,$AC,$00,$27,$07,$18,$EE,$00,$27,$0A,$20
  DC.B $F4,$A6,$04,$8A,$20,$A7,$04,$20,$4E,$A6,$04,$84,$07,$A7,$04,$81,$01
  DC.B $26,$12,$18,$CE,$22,$98,$CC,$08,$A0,$BD,$85,$36,$27,$38,$18,$CE,$22
  DC.B $96,$20,$2A,$81,$02,$26,$12,$18,$CE,$2B,$3D,$CC,$0F,$78,$BD         *14
  DC.B $85,$00,$85,$36,$27,$22,$18,$CE,$2B,$3B,$20,$14,$81,$04,$26,$18,$18
  DC.B $CE,$3A,$B7,$CC,$00,$C8,$BD,$85,$36,$27,$0C,$18,$CE,$3A,$B5,$18,$EC
  DC.B $00,$ED,$00,$CD,$EF,$00,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32
  DC.B $18,$38,$32,$33,$39,$3C,$18,$3C,$36,$37,$37,$36,$8F,$18,$3C         *15
  DC.B $85,$40,$18,$30,$18,$A3,$00,$18,$38,$18,$38,$2B,$0F,$18,$3C,$18,$30
  DC.B $CD,$A3,$00,$18,$38,$2A,$04,$86,$01,$20,$01,$4F,$33,$32,$18,$38,$38
  DC.B $39,$86,$27,$C6,$08,$CE,$3B,$83,$18,$CE,$3B,$83,$FF,$3B,$81,$6F,$00
  DC.B $6F,$01,$4A,$27,$0C,$3A,$CD,$EF,$02,$1A,$EF,$00,$3C,$18,$38         *16
  DC.B $85,$80,$20,$F1,$6F,$02,$6F,$03,$39,$18,$3C,$0F,$7C,$3C,$BB,$FE,$3B
  DC.B $81,$26,$11,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$0F,$7C,$3C
  DC.B $BB,$20,$EA,$1A,$EE,$02,$18,$FF,$3B,$81,$18,$6F,$00,$18,$6F,$01,$36
  DC.B $07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$18,$38,$39,$3C,$18         *17
  DC.B $85,$C0,$3C,$0F,$7C,$3C,$BB,$8C,$00,$00,$26,$04,$8D,$6F,$26,$37,$3C
  DC.B $1A,$EE,$02,$EE,$00,$27,$0E,$1A,$EF,$02,$18,$8C,$00,$00,$27,$12,$CD
  DC.B $EF,$00,$20,$0D,$18,$8C,$00,$00,$27,$03,$CD,$EF,$00,$18,$FF,$3B,$7F
  DC.B $38,$18,$FE,$3B,$81,$27,$03,$CD,$EF,$00,$1A,$EF,$02,$6F,$00         *18
  DC.B $86,$00,$6F,$01,$FF,$3B,$81,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06
  DC.B $32,$18,$38,$38,$39,$0F,$7C,$3C,$BB,$18,$3C,$18,$FE,$3B,$7F,$1A,$EF
  DC.B $02,$27,$03,$CD,$EF,$00,$FF,$3B,$7F,$6F,$00,$6F,$01,$18,$38,$36,$07
  DC.B $7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$39,$0F,$7C,$3C,$BB,$36         *19
  DC.B $86,$40,$FE,$3B,$7F,$27,$09,$A6,$04,$11,$27,$06,$EE,$02,$20,$F5,$86
  DC.B $01,$32,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$39,$0F,$7C,$3C
  DC.B $BB,$3C,$BD,$85,$87,$E7,$04,$A7,$05,$1A,$EF,$06,$8D,$A6,$38,$36,$07
  DC.B $7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$39,$36,$8D,$BD,$26,$06         *1a
  DC.B $86,$80,$A7,$05,$1A,$EF,$06,$4F,$32,$39,$37,$36,$3C,$18,$3C,$0F,$7C
  DC.B $3C,$BB,$CC,$00,$00,$FD,$22,$8C,$FD,$22,$8E,$FD,$2B,$38,$18,$CE,$22
  DC.B $88,$FE,$22,$88,$27,$1C,$A6,$04,$84,$07,$81,$02,$26,$0D,$EC,$00,$18
  DC.B $ED,$00,$26,$09,$18,$FF,$22,$8A,$20,$07,$3C,$18,$38,$EE,$00         *1b
  DC.B $86,$C0,$20,$E2,$18,$8C,$22,$88,$26,$0E,$18,$CE,$00,$00,$18,$FF,$22
  DC.B $88,$18,$FF,$22,$8A,$20,$08,$FC,$22,$88,$26,$03,$FD,$22,$8A,$BD,$83
  DC.B $DF,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$18,$38,$38,$32,$33
  DC.B $39,$7C,$3C,$BB,$86,$80,$97,$23,$DC,$0E,$C3,$92,$7C,$DD,$16         *1c
  DC.B $87,$00,$FE,$22,$84,$08,$FF,$22,$84,$B6,$22,$7D,$27,$43,$FE,$3B,$7F
  DC.B $27,$36,$6A,$05,$27,$04,$EE,$02,$20,$F6,$3C,$BD,$84,$57,$18,$38,$6F
  DC.B $02,$18,$E6,$04,$E7,$03,$18,$EC,$06,$ED,$06,$18,$3C,$18,$CE,$22,$88
  DC.B $BD,$83,$4F,$18,$38,$18,$3C,$38,$18,$EE,$02,$18,$3C,$BD,$85         *1d
  DC.B $87,$40,$BE,$38,$8C,$00,$00,$20,$C8,$7D,$3C,$CB,$2B,$03,$7C,$3C,$CB
  DC.B $7A,$3C,$BB,$3B,$7E,$E8,$00,$7E,$E8,$00,$7E,$E8,$00,$BD,$87,$9F,$7F
  DC.B $18,$C1,$C6,$80,$F7,$18,$C3,$CC,$0D,$00,$FD,$18,$C0,$C6,$03,$F7,$18
  DC.B $C3,$C6,$81,$F7,$18,$C2,$5F,$4F,$FD,$21,$06,$BD,$89,$B0,$5F         *1e
  DC.B $87,$80,$4F,$FD,$20,$00,$C6,$80,$F7,$3C,$CB,$CE,$18,$80,$1F,$46,$20
  DC.B $04,$C6,$0D,$20,$02,$C6,$08,$F7,$18,$C1,$C6,$01,$F7,$18,$C4,$39,$CE
  DC.B $14,$00,$1C,$20,$10,$1D,$20,$10,$39,$BD,$87,$5C,$CC,$00,$01,$FD,$21
  DC.B $0C,$CE,$18,$80,$1C,$44,$02,$39,$CC,$00,$01,$FD,$21,$0A,$BD         *1f
  DC.B $87,$C0,$87,$C3,$39,$30,$8F,$C3,$FF,$F7,$8F,$35,$C6,$12,$E7,$02,$C6
  DC.B $80,$E7,$03,$C6,$03,$E7,$04,$5C,$E7,$05,$FC,$21,$0A,$83,$00,$01,$26
  DC.B $06,$C6,$01,$E7,$06,$20,$02,$6F,$06,$BD,$A1,$AA,$30,$6F,$07,$20,$1C
  DC.B $E6,$07,$4F,$ED,$00,$8F,$C3,$00,$02,$30,$E3,$00,$8F,$E6,$00         *20
  DC.B $88,$00,$BD,$89,$E6,$83,$00,$00,$27,$19,$30,$6C,$08,$6C,$07,$E6,$07
  DC.B $C1,$05,$25,$DE,$BD,$A1,$AF,$CE,$18,$80,$1C,$41,$02,$20,$0B,$BD,$8A
  DC.B $29,$30,$E6,$08,$6A,$08,$5D,$26,$F5,$30,$C6,$09,$3A,$35,$39,$34,$FC
  DC.B $21,$0C,$27,$24,$F6,$18,$C2,$30,$E7,$00,$C4,$06,$27,$0F,$C1         *21
  DC.B $88,$40,$02,$27,$06,$C1,$06,$27,$0C,$20,$0D,$BD,$89,$2A,$20,$08,$BD
  DC.B $88,$5B,$20,$03,$BD,$89,$75,$BD,$8A,$F8,$31,$39,$3C,$3C,$F6,$18,$C6
  DC.B $30,$E7,$03,$C5,$02,$27,$57,$FC,$21,$08,$27,$08,$BD,$A0,$F4,$5F,$4F
  DC.B $FD,$21,$08,$30,$1F,$03,$20,$29,$C6,$0D,$F7,$18,$C1,$C6,$06         *22
  DC.B $88,$80,$F7,$18,$C2,$C6,$81,$F7,$18,$C2,$5F,$4F,$FD,$21,$06,$BD,$89
  DC.B $B0,$5F,$4F,$FD,$20,$00,$30,$1F,$03,$10,$03,$7E,$89,$27,$7F,$3C,$CB
  DC.B $20,$1A,$C6,$80,$F7,$18,$C3,$CC,$0D,$00,$FD,$18,$C0,$C6,$03,$F7,$18
  DC.B $C3,$C6,$80,$F7,$3C,$CB,$C6,$08,$F7,$18,$C1,$20,$69,$1F,$03         *23
  DC.B $88,$C0,$01,$65,$1F,$03,$10,$61,$1F,$03,$20,$5D,$F6,$3C,$CB,$C1,$06
  DC.B $23,$51,$C1,$28,$24,$4D,$C6,$80,$F7,$18,$C3,$CC,$D5,$00,$FD,$18,$C0
  DC.B $C6,$02,$F7,$18,$C3,$BD,$89,$B0,$CC,$00,$01,$FD,$20,$00,$7D,$3C,$C8
  DC.B $26,$05,$CC,$DC,$2A,$20,$03,$CC,$DC,$54,$30,$ED,$00,$C6,$2A         *24
  DC.B $89,$00,$E7,$02,$20,$10,$1A,$EE,$00,$18,$08,$1A,$EF,$00,$18,$09,$18
  DC.B $E6,$00,$BD,$89,$E6,$30,$E6,$02,$6A,$02,$5D,$26,$E8,$CE,$18,$80,$1C
  DC.B $41,$02,$C6,$80,$F7,$3C,$CB,$38,$38,$39,$34,$C6,$10,$30,$E7,$00,$BD
  DC.B $89,$C2,$83,$00,$00,$27,$33,$CE,$18,$80,$1D,$41,$02,$FC,$20         *25
  DC.B $89,$40,$00,$83,$00,$01,$26,$2D,$C6,$80,$F7,$18,$C3,$CC,$0D,$00,$FD
  DC.B $18,$C0,$C6,$03,$F7,$18,$C3,$5F,$4F,$FD,$20,$00,$20,$16,$BD,$89,$C2
  DC.B $83,$00,$00,$26,$0E,$BD,$8A,$29,$F7,$18,$C0,$30,$E6,$00,$6A,$00,$5D
  DC.B $26,$EA,$31,$39,$CE,$18,$80,$1F,$45,$1E,$10,$FC,$21,$08,$27         *26
  DC.B $89,$80,$0B,$BD,$A0,$F4,$5F,$4F,$FD,$21,$08,$BD,$87,$5C,$39,$CE,$18
  DC.B $80,$1C,$44,$02,$39,$5F,$4F,$FD,$21,$0C,$FC,$21,$08,$27,$11,$BD,$A1
  DC.B $AA,$FC,$21,$08,$BD,$A0,$F4,$5F,$4F,$FD,$21,$08,$BD,$A1,$AF,$39,$BD
  DC.B $A1,$AA,$5F,$4F,$FD,$21,$04,$7F,$21,$03,$7F,$21,$02,$BD,$A1         *27
  DC.B $89,$C0,$AF,$39,$3C,$5F,$4F,$30,$ED,$00,$BD,$A1,$AA,$FC,$21,$04,$26
  DC.B $0E,$F6,$21,$03,$F1,$21,$02,$26,$06,$CC,$00,$01,$30,$ED,$00,$BD,$A1
  DC.B $AF,$30,$EC,$00,$38,$39,$37,$3C,$CC,$00,$01,$30,$ED,$00,$BD,$A1,$AA
  DC.B $FC,$21,$04,$83,$00,$01,$26,$07,$5F,$4F,$30,$ED,$00,$20,$20         *28
  DC.B $8A,$00,$F6,$21,$03,$7C,$21,$03,$4F,$C3,$20,$02,$18,$8F,$30,$E6,$02
  DC.B $18,$E7,$00,$F6,$21,$03,$F1,$21,$02,$26,$06,$CC,$00,$01,$FD,$21,$04
  DC.B $BD,$A1,$AF,$30,$EC,$00,$38,$31,$39,$34,$BD,$A1,$AA,$5F,$4F,$FD,$21
  DC.B $04,$F6,$21,$02,$7C,$21,$02,$4F,$C3,$20,$02,$8F,$E6,$00,$30         *29
  DC.B $8A,$40,$E7,$00,$BD,$A1,$AF,$30,$E6,$00,$31,$39,$37,$36,$3C,$3C,$30
  DC.B $EE,$08,$EC,$00,$30,$ED,$02,$1A,$EE,$02,$18,$E6,$01,$CB,$02,$E7,$01
  DC.B $6F,$00,$EC,$04,$A3,$02,$83,$00,$02,$2D,$19,$E6,$01,$4F,$E3,$02,$83
  DC.B $00,$01,$A3,$04,$22,$0D,$18,$E6,$00,$C1,$03,$26,$06,$E6,$01         *2a
  DC.B $8A,$80,$C1,$03,$24,$03,$5F,$20,$6C,$1A,$EE,$08,$E6,$01,$4F,$18,$E3
  DC.B $00,$18,$ED,$00,$C6,$12,$BD,$89,$E6,$83,$00,$00,$27,$54,$30,$6C,$00
  DC.B $C6,$80,$BD,$89,$E6,$83,$00,$00,$27,$3F,$30,$6C,$00,$E6,$01,$CB,$01
  DC.B $BD,$89,$E6,$83,$00,$00,$27,$30,$30,$6C,$00,$20,$1A,$1A,$EE         *2b
  DC.B $8A,$C0,$02,$18,$08,$1A,$EF,$02,$18,$09,$18,$E6,$00,$BD,$89,$E6,$83
  DC.B $00,$00,$27,$16,$30,$6C,$00,$6A,$01,$6D,$01,$26,$E2,$CE,$18,$80,$1C
  DC.B $41,$02,$20,$0D,$20,$03,$BD,$8A,$29,$30,$E6,$00,$6A,$00,$5D,$26,$F5
  DC.B $C6,$01,$4F,$38,$38,$38,$39,$3C,$34,$FC,$21,$0C,$26,$03,$7E         *2c
  DC.B $8B,$00,$8C,$0B,$CE,$18,$80,$1F,$41,$01,$F6,$20,$2C,$CE,$18,$80,$1D
  DC.B $44,$02,$FC,$21,$06,$27,$11,$1A,$83,$00,$01,$27,$1E,$1A,$83,$00,$02
  DC.B $26,$03,$7E,$8B,$CB,$20,$10,$F6,$18,$C0,$C1,$12,$26,$09,$CC,$00,$01
  DC.B $FD,$21,$06,$7F,$22,$6A,$7E,$8C,$01,$F6,$18,$C0,$30,$E7,$02         *2d
  DC.B $8B,$40,$B6,$22,$6A,$16,$4F,$C3,$21,$0E,$18,$8F,$E6,$02,$18,$E7,$00
  DC.B $7D,$22,$6A,$26,$0A,$F6,$21,$0E,$C1,$83,$27,$03,$7E,$8B,$FC,$7C,$22
  DC.B $6A,$F6,$22,$6A,$C1,$04,$26,$61,$F6,$21,$10,$C1,$04,$26,$14,$F6,$21
  DC.B $0F,$C1,$03,$26,$0D,$F6,$21,$11,$C1,$01,$26,$06,$BD,$87,$C3         *2e
  DC.B $8B,$80,$5F,$20,$42,$F6,$21,$0F,$C1,$64,$22,$72,$C1,$03,$25,$6E,$BD
  DC.B $A1,$14,$FD,$21,$08,$27,$66,$FE,$21,$08,$C6,$D2,$E7,$08,$F6,$21,$10
  DC.B $FE,$21,$08,$E7,$09,$F6,$21,$11,$FE,$21,$08,$E7,$0A,$86,$03,$B7,$22
  DC.B $68,$F6,$21,$0F,$C0,$03,$F7,$22,$69,$26,$07,$16,$BD,$8C,$0E         *2f
  DC.B $8B,$C0,$5F,$20,$02,$C6,$02,$4F,$FD,$21,$06,$20,$36,$F6,$18,$C0,$B6
  DC.B $22,$68,$30,$ED,$01,$7C,$22,$68,$18,$FE,$21,$08,$E6,$01,$4F,$ED,$00
  DC.B $18,$8F,$C3,$00,$08,$E3,$00,$18,$8F,$E6,$02,$18,$E7,$00,$7A,$22,$69
  DC.B $7D,$22,$69,$26,$0B,$F6,$22,$68,$BD,$8C,$0E,$5F,$4F,$FD,$21         *30
  DC.B $8C,$00,$06,$CE,$18,$80,$1F,$45,$01,$03,$7E,$8B,$0B,$38,$31,$39,$37
  DC.B $18,$FE,$21,$08,$30,$E6,$00,$18,$E7,$05,$FE,$21,$08,$C6,$02,$E7,$03
  DC.B $FE,$21,$08,$5C,$E7,$02,$FC,$21,$08,$BD,$A0,$D0,$5F,$4F,$FD,$21,$08
  DC.B $31,$39,$37,$36,$3C,$34,$CC,$00,$01,$30,$ED,$01,$1A,$EE,$03         *31
  DC.B $8C,$40,$18,$8F,$C3,$00,$08,$FD,$21,$24,$EE,$03,$E6,$05,$4F,$F3,$21
  DC.B $24,$83,$00,$01,$FD,$21,$26,$6D,$05,$27,$03,$7E,$8D,$21,$7E,$8D,$2C
  DC.B $18,$FE,$21,$24,$18,$E6,$00,$30,$E7,$00,$18,$08,$18,$FF,$21,$24,$18
  DC.B $09,$18,$E6,$00,$C1,$C7,$24,$0E,$C1,$19,$27,$12,$C1,$1A,$27         *32
  DC.B $8C,$80,$25,$C1,$C0,$27,$38,$20,$74,$27,$40,$C1,$CF,$27,$4E,$20,$6C
  DC.B $CE,$21,$24,$3C,$FE,$21,$26,$3C,$30,$EE,$07,$E6,$03,$BD,$8D,$AB,$38
  DC.B $38,$30,$ED,$01,$20,$69,$CE,$21,$24,$3C,$FE,$21,$26,$3C,$30,$EE,$07
  DC.B $E6,$03,$BD,$8D,$30,$38,$38,$30,$ED,$01,$20,$52,$EE,$03,$E6         *33
  DC.B $8C,$C0,$03,$37,$C6,$20,$BD,$91,$53,$20,$45,$EE,$03,$E6,$03,$BD,$90
  DC.B $70,$FC,$21,$26,$C3,$00,$01,$FD,$21,$24,$20,$34,$CE,$21,$24,$3C,$FE
  DC.B $21,$26,$3C,$30,$EE,$07,$E6,$03,$BD,$91,$21,$38,$38,$30,$ED,$01,$FC
  DC.B $21,$26,$C3,$00,$01,$FD,$21,$24,$20,$14,$FC,$21,$26,$C3,$00         *34
  DC.B $8D,$00,$01,$FD,$21,$24,$E6,$00,$37,$EE,$03,$E6,$03,$BD,$91,$AA,$31
  DC.B $30,$EC,$01,$26,$0D,$E6,$00,$37,$EE,$03,$E6,$03,$BD,$91,$AA,$31,$20
  DC.B $0B,$FC,$21,$24,$B3,$21,$26,$22,$03,$7E,$8C,$60,$38,$38,$31,$39,$37
  DC.B $3C,$3C,$34,$30,$EE,$0A,$EC,$00,$30,$ED,$03,$C3,$00,$01,$A3         *35
  DC.B $8D,$40,$08,$23,$03,$5F,$20,$36,$EE,$03,$E6,$00,$C4,$0F,$30,$E7,$02
  DC.B $C1,$06,$24,$07,$C1,$08,$23,$03,$5F,$20,$22,$E6,$05,$37,$E6,$02,$BD
  DC.B $8D,$81,$31,$30,$ED,$00,$1A,$EE,$03,$EE,$00,$18,$E6,$01,$E7,$00,$30
  DC.B $EE,$0A,$EC,$00,$C3,$00,$02,$ED,$00,$C6,$01,$4F,$38,$38,$38         *36
  DC.B $8D,$80,$39,$37,$30,$E6,$03,$C1,$04,$26,$11,$E6,$00,$4F,$83,$00,$06
  DC.B $CE,$00,$05,$BD,$A6,$E4,$C3,$21,$28,$20,$0F,$E6,$00,$4F,$83,$00,$06
  DC.B $CE,$00,$05,$BD,$A6,$E4,$C3,$21,$37,$31,$39,$37,$30,$8F,$C3,$FF,$F5
  DC.B $8F,$35,$EE,$10,$EC,$00,$30,$ED,$09,$C3,$00,$01,$A3,$0E,$23         *37
  DC.B $8D,$C0,$03,$5F,$20,$25,$1A,$EE,$09,$18,$E6,$00,$54,$54,$54,$54,$E7
  DC.B $06,$18,$E6,$01,$E7,$05,$27,$08,$C1,$30,$23,$07,$C1,$FD,$27,$03,$5F
  DC.B $20,$07,$E6,$06,$C1,$08,$23,$04,$5F,$7E,$8E,$6D,$EE,$10,$EC,$00,$C3
  DC.B $00,$02,$ED,$00,$30,$E6,$06,$C1,$01,$22,$0D,$E7,$01,$E6,$05         *38
  DC.B $8E,$00,$E7,$00,$E6,$0B,$BD,$8E,$B8,$20,$23,$E6,$0B,$E7,$00,$E6,$06
  DC.B $BD,$8D,$81,$30,$ED,$02,$EE,$02,$6D,$00,$27,$50,$30,$EE,$02,$EC,$01
  DC.B $26,$0A,$30,$E6,$06,$E7,$00,$E6,$0B,$BD,$8F,$77,$30,$E6,$05,$C1,$FD
  DC.B $26,$24,$C6,$01,$E7,$04,$20,$16,$E6,$0B,$E7,$00,$E6,$04,$BD         *39
  DC.B $8E,$40,$8E,$76,$30,$ED,$07,$1A,$EE,$07,$E6,$06,$18,$E7,$00,$6C,$04
  DC.B $E6,$04,$C1,$30,$23,$E4,$20,$14,$E6,$0B,$E7,$00,$E6,$05,$BD,$8E,$76
  DC.B $30,$ED,$07,$1A,$EE,$07,$E6,$06,$18,$E7,$00,$C6,$01,$4F,$30,$8F,$C3
  DC.B $00,$0C,$8F,$35,$39,$37,$30,$E6,$03,$C1,$04,$26,$0B,$E6,$00         *3a
  DC.B $8E,$80,$4F,$83,$00,$01,$C3,$21,$46,$20,$09,$E6,$00,$4F,$83,$00,$01
  DC.B $C3,$21,$76,$31,$39,$37,$30,$E6,$03,$C1,$04,$26,$0D,$E6,$00,$4F,$83
  DC.B $00,$01,$05,$C3,$DC,$7E,$8F,$20,$0B,$E6,$00,$4F,$83,$00,$01,$05,$C3
  DC.B $DC,$8A,$8F,$EC,$00,$31,$39,$37,$3C,$3C,$3C,$34,$30,$E6,$07         *3b
  DC.B $8E,$C0,$C1,$04,$26,$05,$CC,$21,$A6,$20,$03,$CC,$21,$AC,$ED,$00,$E6
  DC.B $0A,$C1,$FD,$26,$3F,$6D,$0B,$26,$04,$6F,$04,$20,$04,$C6,$FF,$E7,$04
  DC.B $C6,$01,$E7,$02,$20,$25,$E6,$07,$37,$E6,$02,$BD,$8E,$94,$31,$30,$ED
  DC.B $05,$1A,$EE,$05,$E6,$04,$18,$E7,$00,$1A,$EE,$00,$18,$08,$1A         *3c
  DC.B $8F,$00,$EF,$00,$18,$09,$E6,$04,$18,$E7,$00,$6C,$02,$E6,$02,$C1,$06
  DC.B $23,$D5,$20,$5E,$E6,$07,$37,$E6,$0A,$4F,$83,$00,$01,$47,$56,$47,$56
  DC.B $47,$56,$CB,$01,$BD,$8E,$94,$31,$30,$ED,$05,$A6,$0A,$80,$01,$84,$07
  DC.B $C6,$01,$BD,$A6,$DC,$30,$E7,$03,$E6,$0A,$4F,$83,$00,$01,$47         *3d
  DC.B $8F,$40,$56,$47,$56,$47,$56,$E3,$00,$ED,$00,$EE,$00,$E6,$00,$30,$E7
  DC.B $04,$6D,$0B,$26,$07,$E6,$03,$53,$E4,$04,$20,$04,$E6,$04,$EA,$03,$E7
  DC.B $04,$1A,$EE,$05,$E6,$04,$18,$E7,$00,$1A,$EE,$00,$E6,$04,$18,$E7,$00
  DC.B $30,$C6,$08,$3A,$35,$39,$37,$3C,$34,$30,$E6,$03,$37,$E6,$06         *3e
  DC.B $8F,$80,$BD,$8D,$81,$31,$30,$ED,$01,$EE,$01,$EC,$03,$83,$00,$01,$26
  DC.B $0A,$E6,$00,$54,$54,$54,$54,$4F,$05,$20,$09,$30,$EE,$01,$E6,$00,$C4
  DC.B $0F,$4F,$05,$30,$E7,$00,$E6,$03,$58,$58,$58,$58,$EA,$06,$37,$E6,$00
  DC.B $37,$CC,$A1,$43,$BD,$A0,$5E,$38,$30,$EE,$01,$CC,$00,$01,$ED         *3f
  DC.B $8F,$C0,$01,$38,$38,$39,$37,$36,$30,$8F,$C3,$FF,$F4,$8F,$35,$1A,$EE
  DC.B $0C,$18,$A6,$03,$84,$0F,$A7,$06,$18,$E6,$03,$54,$54,$54,$54,$E7,$05
  DC.B $5F,$4F,$ED,$02,$E6,$05,$E7,$00,$E6,$06,$BD,$8D,$81,$30,$ED,$0A,$EE
  DC.B $0A,$5F,$4F,$ED,$01,$30,$EE,$0A,$EC,$03,$26,$07,$C6,$01,$30         *40
  DC.B $90,$00,$E7,$04,$20,$03,$30,$6F,$04,$E6,$05,$E7,$00,$C6,$01,$BD,$8E
  DC.B $76,$30,$ED,$08,$C6,$01,$E7,$07,$20,$26,$1A,$EE,$08,$18,$08,$1A,$EF
  DC.B $08,$18,$09,$18,$E6,$00,$E1,$06,$26,$13,$E6,$04,$E7,$01,$E6,$07,$E7
  DC.B $00,$E6,$05,$BD,$8E,$B8,$CC,$00,$01,$30,$ED,$02,$6C,$07,$E6         *41
  DC.B $90,$40,$07,$C1,$30,$23,$D4,$EC,$02,$83,$00,$01,$26,$1E,$EE,$0A,$EC
  DC.B $03,$83,$00,$01,$26,$03,$5F,$20,$05,$30,$EE,$0A,$C6,$01,$4F,$ED,$03
  DC.B $30,$E6,$06,$E7,$00,$E6,$05,$BD,$8F,$77,$30,$C6,$0E,$3A,$35,$39,$37
  DC.B $3C,$3C,$3C,$34,$30,$E6,$07,$C1,$04,$26,$05,$CC,$21,$14,$20         *42
  DC.B $90,$80,$03,$CC,$21,$1A,$ED,$01,$6F,$00,$20,$0C,$E6,$00,$4F,$E3,$01
  DC.B $8F,$5F,$E7,$00,$30,$6C,$00,$E6,$00,$C1,$06,$25,$EE,$E6,$07,$37,$C6
  DC.B $01,$BD,$8E,$76,$31,$30,$ED,$03,$E6,$07,$37,$C6,$06,$BD,$8D,$81,$31
  DC.B $30,$ED,$05,$6F,$00,$20,$1A,$EE,$05,$5F,$E7,$00,$30,$EE,$05         *43
  DC.B $90,$C0,$4F,$ED,$01,$30,$EE,$05,$ED,$03,$30,$EC,$05,$C3,$00,$05,$ED
  DC.B $05,$6C,$00,$E6,$00,$C1,$03,$25,$E0,$6F,$00,$20,$10,$1A,$EE,$03,$18
  DC.B $08,$1A,$EF,$03,$18,$09,$5F,$18,$E7,$00,$6C,$00,$E6,$00,$C1,$30,$25
  DC.B $EA,$E6,$07,$37,$C6,$1E,$37,$CC,$94,$7C,$BD,$9B,$88,$38,$30         *44
  DC.B $91,$00,$E6,$07,$BD,$94,$4D,$30,$E6,$07,$37,$C6,$0A,$BD,$94,$50,$31
  DC.B $5F,$37,$C6,$FD,$37,$30,$E6,$09,$BD,$8E,$B8,$38,$30,$C6,$08,$3A,$35
  DC.B $39,$37,$3C,$30,$EE,$07,$EC,$00,$30,$ED,$00,$A3,$05,$23,$03,$5F,$20
  DC.B $1D,$E6,$02,$37,$EE,$00,$E6,$00,$C4,$1F,$37,$CC,$94,$7C,$BD         *45
  DC.B $91,$40,$9B,$88,$38,$30,$EE,$07,$EC,$00,$C3,$00,$01,$ED,$00,$C6,$01
  DC.B $4F,$38,$31,$39,$37,$3C,$BD,$A1,$14,$30,$ED,$00,$27,$4A,$EE,$00,$C6
  DC.B $C1,$E7,$08,$30,$EE,$00,$C6,$9D,$E7,$09,$30,$1A,$EE,$00,$E6,$02,$18
  DC.B $E7,$0A,$E6,$05,$C1,$04,$26,$06,$EE,$00,$C6,$10,$20,$04,$EE         *46
  DC.B $91,$80,$00,$C6,$20,$E7,$0B,$30,$EE,$00,$C6,$04,$E7,$05,$30,$EE,$00
  DC.B $C6,$02,$E7,$03,$30,$1A,$EE,$00,$E6,$05,$18,$E7,$02,$EE,$00,$1C,$04
  DC.B $80,$30,$EC,$00,$BD,$A0,$D0,$38,$31,$39,$37,$3C,$BD,$A1,$14,$30,$ED
  DC.B $00,$27,$2E,$EE,$00,$C6,$C2,$E7,$08,$30,$1A,$EE,$00,$E6,$05         *47
  DC.B $91,$C0,$18,$E7,$09,$EE,$00,$C6,$02,$E7,$05,$30,$EE,$00,$E7,$03,$30
  DC.B $1A,$EE,$00,$E6,$02,$18,$E7,$02,$EE,$00,$1C,$04,$80,$30,$EC,$00,$BD
  DC.B $A0,$D0,$38,$31,$39,$34,$FC,$21,$12,$26,$03,$7E,$92,$B1,$FC,$21,$20
  DC.B $27,$0E,$1A,$83,$00,$01,$27,$20,$1A,$83,$00,$02,$27,$41,$20         *48
  DC.B $92,$00,$67,$F6,$14,$10,$54,$54,$54,$54,$C1,$0A,$26,$5C,$C6,$04,$F7
  DC.B $22,$6B,$CC,$00,$01,$FD,$21,$20,$20,$4F,$F6,$14,$10,$54,$54,$54,$54
  DC.B $C1,$0A,$27,$07,$C6,$04,$F7,$22,$6B,$20,$3D,$7A,$22,$6B,$7D,$22,$6B
  DC.B $26,$35,$CC,$00,$02,$FD,$21,$20,$C6,$04,$BD,$90,$70,$20,$28         *49
  DC.B $92,$40,$F6,$14,$10,$54,$54,$54,$54,$C1,$0A,$26,$13,$C6,$04,$BD,$92
  DC.B $B3,$30,$E7,$00,$27,$13,$37,$C6,$04,$BD,$94,$14,$31,$20,$0A,$5F,$4F
  DC.B $FD,$21,$20,$C6,$04,$BD,$9C,$30,$FC,$21,$22,$27,$08,$1A,$83,$00,$02
  DC.B $27,$18,$20,$3C,$F6,$14,$10,$C4,$0F,$C1,$0A,$26,$33,$CC,$00         *4a
  DC.B $92,$80,$02,$FD,$21,$22,$C6,$05,$BD,$90,$70,$20,$26,$F6,$14,$10,$C4
  DC.B $0F,$C1,$0A,$26,$13,$C6,$05,$BD,$92,$B3,$30,$E7,$00,$27,$13,$37,$C6
  DC.B $05,$BD,$94,$14,$31,$20,$0A,$5F,$4F,$FD,$21,$22,$C6,$05,$BD,$9C,$30
  DC.B $31,$39,$37,$30,$8F,$C3,$FF,$EA,$8F,$35,$6F,$15,$6F,$10,$8F         *4b
  DC.B $92,$C0,$C3,$00,$0A,$30,$ED,$04,$E6,$16,$C1,$04,$26,$0A,$CC,$21,$14
  DC.B $ED,$08,$CC,$DC,$7E,$20,$08,$CC,$21,$1A,$ED,$08,$CC,$DC,$8A,$ED,$02
  DC.B $6F,$14,$20,$23,$1A,$EE,$02,$18,$08,$18,$08,$1A,$EF,$02,$18,$09,$18
  DC.B $09,$CD,$EE,$00,$E6,$00,$30,$1A,$EE,$04,$18,$08,$1A,$EF,$04         *4c
  DC.B $93,$00,$18,$09,$18,$E7,$00,$6C,$14,$E6,$14,$C1,$06,$25,$D7,$6F,$14
  DC.B $7E,$93,$E7,$E6,$14,$4F,$ED,$00,$8F,$C3,$00,$0A,$30,$E3,$00,$18,$8F
  DC.B $EE,$08,$18,$E6,$00,$E8,$00,$26,$03,$7E,$93,$DD,$30,$6C,$10,$E6,$10
  DC.B $C1,$01,$27,$03,$7E,$93,$D7,$6F,$13,$C6,$01,$E7,$12,$7E,$93         *4d
  DC.B $93,$40,$CE,$E6,$14,$4F,$ED,$00,$8F,$C3,$00,$0A,$30,$E3,$00,$8F,$E6
  DC.B $00,$30,$E4,$12,$1A,$EE,$08,$18,$A6,$00,$A4,$12,$A7,$01,$E8,$01,$27
  DC.B $68,$E6,$14,$58,$58,$58,$EB,$13,$CB,$01,$E7,$15,$E6,$14,$4F,$ED,$00
  DC.B $8F,$C3,$00,$0A,$30,$E3,$00,$8F,$E6,$00,$30,$E7,$11,$EC,$08         *4e
  DC.B $93,$80,$ED,$06,$E6,$14,$4F,$ED,$00,$8F,$C3,$00,$0A,$30,$E3,$00,$8F
  DC.B $E6,$00,$30,$E4,$12,$27,$0D,$1C,$15,$40,$18,$E6,$00,$EA,$12,$18,$E7
  DC.B $00,$20,$09,$E6,$12,$53,$EE,$08,$E4,$00,$E7,$00,$30,$E6,$14,$4F,$ED
  DC.B $00,$8F,$C3,$00,$0A,$30,$E3,$00,$18,$8F,$EE,$08,$18,$E6,$00         *4f
  DC.B $93,$C0,$E8,$00,$27,$05,$30,$6C,$10,$20,$0E,$30,$68,$12,$6C,$13,$E6
  DC.B $13,$C1,$08,$24,$03,$7E,$93,$41,$E6,$10,$C1,$01,$22,$13,$30,$EC,$08
  DC.B $C3,$00,$01,$ED,$08,$6C,$14,$E6,$14,$C1,$06,$24,$03,$7E,$93,$12,$E6
  DC.B $10,$C1,$01,$23,$08,$EE,$06,$5F,$E7,$00,$30,$6F,$15,$6D,$15         *50
  DC.B $94,$00,$27,$08,$1A,$EE,$06,$E6,$11,$18,$E7,$00,$E6,$15,$30,$8F,$C3
  DC.B $00,$17,$8F,$35,$39,$37,$3C,$BD,$A1,$14,$30,$ED,$00,$27,$2C,$EE,$00
  DC.B $C6,$02,$E7,$08,$30,$1A,$EE,$00,$A6,$05,$18,$A7,$09,$EE,$00,$E7,$05
  DC.B $30,$EE,$00,$E7,$03,$30,$1A,$EE,$00,$E6,$02,$18,$E7,$02,$EE         *51
  DC.B $94,$40,$00,$1C,$04,$80,$30,$EC,$00,$BD,$A0,$D0,$38,$31,$39,$37,$31
  DC.B $39,$37,$3C,$30,$E6,$05,$C1,$04,$26,$11,$E6,$02,$58,$58,$58,$58,$B6
  DC.B $22,$6C,$84,$0F,$A7,$00,$EA,$00,$20,$07,$F6,$22,$6C,$C4,$F0,$EA,$02
  DC.B $E7,$01,$F7,$14,$10,$F7,$22,$6C,$38,$31,$39,$37,$30,$E6,$00         *52
  DC.B $94,$80,$C1,$04,$27,$04,$C1,$05,$26,$09,$E6,$00,$37,$C6,$08,$BD,$91
  DC.B $53,$31,$31,$39,$5F,$4F,$FD,$21,$12,$C6,$04,$BD,$9C,$30,$C6,$05,$BD
  DC.B $9C,$30,$39,$CC,$00,$01,$FD,$21,$12,$5F,$FD,$21,$20,$FD,$21,$22,$C6
  DC.B $04,$37,$C6,$0A,$BD,$94,$50,$31,$C6,$05,$37,$C6,$0A,$BD,$94         *53
  DC.B $94,$C0,$50,$31,$39,$37,$36,$3C,$3C,$30,$1A,$EE,$04,$18,$E6,$07,$E7
  DC.B $03,$18,$1D,$04,$80,$EE,$04,$E6,$06,$54,$54,$C1,$1F,$26,$06,$BD,$96
  DC.B $03,$7E,$95,$C8,$30,$EE,$04,$E6,$06,$54,$54,$BD,$9E,$3C,$30,$E7,$02
  DC.B $C1,$FF,$27,$EC,$E6,$02,$BD,$9D,$B8,$30,$ED,$00,$27,$E2,$EE         *54
  DC.B $95,$00,$04,$E6,$05,$C1,$02,$24,$03,$7E,$95,$A2,$30,$E6,$03,$4F,$C4
  DC.B $EF,$83,$00,$63,$27,$68,$E6,$03,$4F,$C4,$EF,$83,$00,$2F,$27,$5E,$EE
  DC.B $00,$EC,$0B,$27,$51,$30,$E6,$03,$37,$EC,$00,$BD,$99,$4C,$31,$30,$E7
  DC.B $03,$C1,$87,$27,$71,$1D,$03,$E0,$1E,$03,$01,$2A,$1E,$03,$10         *55
  DC.B $95,$40,$20,$E6,$03,$37,$EC,$00,$BD,$9A,$96,$31,$30,$E7,$03,$C1,$8B
  DC.B $27,$56,$EE,$04,$3C,$30,$E6,$04,$BD,$9E,$8B,$38,$30,$1D,$03,$0E,$20
  DC.B $46,$C6,$93,$E7,$03,$20,$40,$EE,$04,$E6,$05,$C1,$02,$27,$38,$C6,$93
  DC.B $30,$E7,$03,$20,$31,$C6,$93,$30,$E7,$03,$20,$2A,$E6,$03,$4F         *56
  DC.B $95,$80,$C4,$EF,$83,$00,$2F,$27,$06,$E6,$03,$C1,$63,$26,$0F,$EE,$04
  DC.B $E6,$05,$C1,$02,$27,$12,$C6,$93,$30,$E7,$03,$20,$0B,$C6,$93,$E7,$03
  DC.B $20,$05,$C6,$93,$30,$E7,$03,$30,$E6,$03,$37,$EC,$00,$BD,$96,$6C,$31
  DC.B $30,$EE,$00,$EC,$0B,$83,$00,$01,$27,$07,$EC,$0B,$83,$00,$02         *57
  DC.B $95,$C0,$26,$06,$30,$EC,$00,$BD,$96,$33,$30,$C6,$06,$3A,$35,$39,$3C
  DC.B $34,$30,$6F,$00,$20,$25,$E6,$00,$86,$25,$3D,$C3,$21,$B2,$ED,$01,$EE
  DC.B $01,$6D,$05,$27,$12,$EC,$0B,$26,$0E,$E6,$06,$C1,$1E,$26,$08,$30,$EC
  DC.B $01,$BD,$9F,$19,$20,$09,$30,$6C,$00,$E6,$00,$C1,$04,$25,$D5         *58
  DC.B $96,$00,$38,$31,$39,$3C,$34,$5F,$4F,$30,$ED,$01,$6F,$00,$20,$19,$E6
  DC.B $00,$86,$25,$3D,$C3,$21,$B2,$ED,$01,$EE,$01,$E6,$06,$C1,$1F,$26,$04
  DC.B $C6,$1E,$E7,$06,$30,$6C,$00,$E6,$00,$C1,$04,$25,$E1,$BD,$95,$CE,$38
  DC.B $31,$39,$37,$36,$20,$1B,$30,$EE,$00,$E6,$04,$37,$30,$EC,$01         *59
  DC.B $96,$40,$BD,$9A,$BE,$31,$30,$EE,$00,$6C,$04,$E6,$04,$C4,$07,$30,$EE
  DC.B $00,$E7,$04,$30,$EE,$00,$3C,$18,$38,$E6,$00,$18,$E1,$04,$27,$0B,$30
  DC.B $EC,$00,$BD,$98,$F0,$83,$00,$00,$26,$CD,$38,$39,$37,$36,$3C,$3C,$34
  DC.B $C6,$0E,$30,$E7,$04,$6A,$04,$E6,$04,$4F,$C3,$DC,$96,$8F,$E6         *5a
  DC.B $96,$80,$00,$30,$E1,$09,$27,$04,$6D,$04,$26,$EC,$E6,$04,$86,$14,$3D
  DC.B $C3,$DC,$A4,$18,$8F,$EE,$05,$EC,$0B,$05,$05,$30,$ED,$02,$18,$8F,$E3
  DC.B $02,$8F,$EC,$02,$83,$00,$01,$BD,$A7,$2F,$00,$09,$00,$E3,$00,$16,$00
  DC.B $2E,$00,$52,$00,$AB,$00,$76,$00,$93,$00,$9F,$00,$E3,$00,$B9         *5b
  DC.B $96,$C0,$30,$EC,$05,$BD,$9F,$19,$30,$EC,$05,$BD,$9F,$D6,$C6,$2F,$37
  DC.B $30,$EC,$06,$BD,$97,$B3,$31,$20,$46,$30,$EC,$05,$BD,$9F,$D6,$30,$EC
  DC.B $05,$BD,$9F,$64,$30,$EC,$05,$BD,$9C,$E5,$C6,$63,$37,$30,$EC,$06,$BD
  DC.B $97,$B3,$31,$30,$EC,$05,$BD,$9E,$75,$20,$22,$30,$EC,$05,$BD         *5c
  DC.B $97,$00,$9F,$D6,$30,$EC,$05,$BD,$9F,$64,$30,$EC,$05,$BD,$9C,$E5,$C6
  DC.B $73,$37,$30,$EC,$06,$BD,$97,$B3,$31,$30,$EC,$05,$BD,$9E,$75,$20,$6D
  DC.B $30,$EE,$05,$E6,$06,$C1,$1E,$26,$0C,$C6,$01,$37,$30,$EC,$06,$BD,$97
  DC.B $EF,$31,$20,$58,$30,$EC,$05,$BD,$9F,$44,$20,$50,$C6,$11,$37         *5d
  DC.B $97,$40,$30,$EC,$06,$BD,$97,$EF,$31,$20,$44,$C6,$09,$37,$30,$EC,$06
  DC.B $BD,$97,$EF,$31,$20,$38,$30,$EC,$05,$BD,$9B,$07,$30,$EC,$05,$BD,$9F
  DC.B $19,$20,$2A,$30,$EC,$05,$BD,$9F,$06,$30,$EC,$05,$BD,$9C,$E5,$30,$EC
  DC.B $05,$BD,$9F,$64,$30,$EC,$05,$BD,$9F,$D6,$30,$EC,$05,$BD,$9E         *5e
  DC.B $97,$80,$75,$30,$EE,$05,$E6,$06,$C1,$1E,$27,$03,$BD,$95,$CE,$30,$E6
  DC.B $04,$86,$14,$3D,$C3,$DC,$A4,$18,$8F,$1A,$EF,$02,$1A,$EE,$05,$18,$EC
  DC.B $0B,$05,$05,$ED,$00,$E3,$02,$8F,$EC,$00,$18,$ED,$0B,$30,$C6,$07,$3A
  DC.B $35,$39,$37,$36,$3C,$BD,$A1,$14,$30,$ED,$00,$27,$2E,$EE,$00         *5f
  DC.B $97,$C0,$C6,$01,$E7,$06,$30,$E6,$06,$C1,$2F,$26,$05,$EE,$00,$1C,$06
  DC.B $02,$30,$1A,$EE,$00,$E6,$06,$18,$E7,$07,$EE,$00,$C6,$02,$E7,$05,$30
  DC.B $EE,$00,$3C,$30,$EE,$04,$E6,$06,$BD,$9E,$C0,$38,$38,$38,$39,$37,$36
  DC.B $3C,$BD,$A1,$14,$30,$ED,$00,$27,$29,$EE,$00,$C6,$01,$E7,$06         *60
  DC.B $98,$00,$30,$EE,$02,$E6,$01,$86,$20,$3D,$30,$EA,$06,$EE,$00,$E7,$07
  DC.B $30,$EE,$00,$C6,$02,$E7,$05,$30,$EE,$00,$3C,$30,$EE,$04,$E6,$06,$BD
  DC.B $9E,$C0,$38,$38,$38,$39,$37,$36,$3C,$3C,$30,$EE,$04,$1D,$04,$80,$30
  DC.B $EE,$04,$E6,$02,$BD,$9D,$B8,$30,$ED,$02,$27,$3D,$EE,$02,$EC         *61
  DC.B $98,$40,$0B,$27,$37,$30,$EE,$04,$1C,$04,$80,$30,$EE,$04,$C6,$03,$E7
  DC.B $06,$30,$EE,$04,$E6,$05,$CB,$02,$E7,$05,$30,$1A,$EE,$02,$18,$E6,$00
  DC.B $4F,$C3,$00,$01,$C4,$07,$4F,$ED,$00,$18,$E6,$02,$A3,$00,$26,$0C,$EE
  DC.B $04,$3C,$30,$EC,$04,$BD,$9F,$77,$38,$20,$6E,$EE,$02,$3C,$18         *62
  DC.B $98,$80,$38,$E6,$00,$4F,$05,$30,$ED,$00,$18,$8F,$C3,$00,$0D,$E3,$00
  DC.B $18,$8F,$EC,$04,$18,$ED,$00,$EC,$02,$BD,$98,$F0,$83,$00,$00,$27,$3C
  DC.B $30,$EE,$02,$EC,$0B,$83,$00,$01,$27,$07,$EC,$0B,$83,$00,$02,$26,$2B
  DC.B $30,$EE,$02,$E6,$00,$37,$30,$EC,$03,$BD,$9A,$BE,$31,$30,$EE         *63
  DC.B $98,$C0,$02,$E6,$00,$CB,$01,$C4,$07,$E7,$04,$30,$EE,$02,$3C,$18,$38
  DC.B $E6,$00,$18,$E1,$02,$26,$06,$30,$EC,$02,$BD,$9F,$19,$30,$EE,$02,$6C
  DC.B $00,$E6,$00,$C4,$07,$30,$EE,$02,$E7,$00,$30,$C6,$06,$3A,$35,$39,$37
  DC.B $36,$3C,$3C,$3C,$30,$EE,$06,$3C,$18,$38,$E6,$04,$18,$E1,$02         *64
  DC.B $99,$00,$24,$22,$18,$3C,$38,$E6,$04,$4F,$C3,$00,$08,$30,$ED,$02,$18
  DC.B $E6,$02,$4F,$ED,$00,$EC,$02,$A3,$00,$83,$00,$03,$2D,$03,$5F,$20,$24
  DC.B $C6,$01,$20,$20,$30,$1A,$EE,$06,$18,$3C,$38,$E6,$04,$4F,$30,$ED,$02
  DC.B $18,$E6,$02,$ED,$00,$EC,$02,$A3,$00,$83,$00,$03,$2D,$03,$5F         *65
  DC.B $99,$40,$20,$02,$C6,$01,$4F,$ED,$04,$38,$38,$38,$38,$39,$37,$36,$3C
  DC.B $3C,$3C,$3C,$30,$E6,$0C,$54,$54,$54,$54,$54,$E7,$07,$EE,$08,$3C,$18
  DC.B $38,$E6,$00,$18,$E1,$02,$26,$03,$7E,$9A,$7E,$30,$EC,$08,$BD,$9F,$06
  DC.B $30,$EE,$08,$3C,$18,$38,$E6,$00,$18,$E1,$02,$24,$16,$18,$E6         *66
  DC.B $99,$80,$00,$30,$E1,$07,$25,$06,$E6,$07,$CB,$08,$E7,$07,$EE,$08,$E6
  DC.B $00,$CB,$08,$20,$05,$30,$EE,$08,$E6,$00,$30,$E7,$06,$1A,$EE,$08,$E6
  DC.B $06,$4F,$ED,$02,$18,$E6,$02,$ED,$00,$EC,$02,$A3,$00,$83,$00,$03,$2F
  DC.B $07,$18,$E6,$02,$CB,$03,$E7,$06,$E6,$07,$E1,$06,$23,$03,$7E         *67
  DC.B $99,$C0,$9A,$77,$EE,$08,$A6,$02,$11,$22,$F6,$20,$3B,$1A,$EE,$08,$18
  DC.B $E6,$02,$C4,$07,$4F,$05,$ED,$02,$18,$8F,$C3,$00,$0D,$E3,$02,$8F,$EC
  DC.B $00,$BD,$A0,$F4,$30,$EE,$08,$E6,$02,$6C,$02,$C4,$07,$30,$1A,$EE,$08
  DC.B $4F,$05,$ED,$02,$18,$8F,$C3,$00,$0D,$E3,$02,$8F,$5F,$4F,$ED         *68
  DC.B $9A,$00,$00,$30,$EE,$08,$E7,$03,$30,$1A,$EE,$08,$18,$E6,$02,$E1,$07
  DC.B $26,$BA,$18,$E6,$02,$C4,$07,$18,$E7,$02,$EE,$08,$3C,$18,$38,$E6,$02
  DC.B $18,$E1,$00,$27,$39,$30,$EC,$08,$BD,$9F,$19,$20,$31,$EC,$08,$BD,$9F
  DC.B $A4,$30,$ED,$04,$27,$55,$EE,$08,$3C,$18,$38,$E6,$00,$4F,$05         *69
  DC.B $9A,$40,$30,$ED,$02,$18,$8F,$C3,$00,$0D,$E3,$02,$18,$8F,$EC,$04,$18
  DC.B $ED,$00,$EE,$08,$6C,$00,$E6,$00,$C4,$07,$30,$EE,$08,$E7,$00,$30,$1A
  DC.B $EE,$08,$18,$E6,$00,$4F,$C3,$00,$01,$C4,$07,$4F,$ED,$02,$18,$E6,$02
  DC.B $A3,$02,$26,$B8,$20,$15,$C6,$87,$30,$E7,$0C,$20,$0E,$30,$EE         *6a
  DC.B $9A,$80,$08,$E6,$00,$30,$E1,$07,$27,$04,$C6,$87,$E7,$0C,$E6,$0C,$30
  DC.B $8F,$C3,$00,$0A,$8F,$35,$39,$37,$36,$34,$30,$E6,$05,$54,$E7,$00,$EE
  DC.B $01,$A6,$01,$11,$26,$0D,$6C,$01,$E6,$01,$C4,$07,$30,$EE,$01,$E7,$01
  DC.B $20,$05,$C6,$8B,$30,$E7,$05,$30,$E6,$05,$38,$31,$39,$37,$36         *6b
  DC.B $9A,$C0,$3C,$3C,$30,$1A,$EE,$04,$E6,$08,$4F,$05,$ED,$00,$18,$8F,$C3
  DC.B $00,$0D,$E3,$00,$8F,$EC,$00,$30,$ED,$02,$27,$26,$EC,$04,$BD,$9F,$64
  DC.B $30,$EE,$04,$E6,$01,$86,$20,$3D,$30,$A6,$08,$48,$A7,$01,$EA,$01,$EE
  DC.B $02,$E7,$07,$30,$EE,$02,$3C,$30,$EE,$06,$E6,$06,$BD,$9E,$C0         *6c
  DC.B $9B,$00,$38,$30,$C6,$06,$3A,$35,$39,$37,$36,$3C,$3C,$3C,$34,$30,$EE
  DC.B $07,$E6,$02,$30,$E7,$06,$BD,$D0,$9B,$20,$44,$1A,$EE,$07,$E6,$06,$4F
  DC.B $05,$ED,$02,$18,$8F,$C3,$00,$0D,$E3,$02,$8F,$EC,$00,$30,$ED,$04,$EE
  DC.B $07,$E6,$01,$86,$20,$3D,$30,$A6,$06,$48,$A7,$03,$EA,$03,$EE         *6d
  DC.B $9B,$40,$04,$E7,$07,$30,$E6,$06,$CB,$01,$C4,$07,$E7,$06,$EC,$07,$BD
  DC.B $9F,$64,$30,$EE,$04,$3C,$30,$EE,$09,$E6,$06,$BD,$9E,$C0,$38,$30,$1A
  DC.B $EE,$07,$E6,$06,$C4,$07,$18,$E1,$00,$27,$13,$E6,$06,$4F,$ED,$02,$18
  DC.B $E6,$02,$ED,$00,$EC,$02,$A3,$00,$83,$00,$03,$26,$9C,$EE,$07         *6e
  DC.B $9B,$80,$6C,$03,$30,$C6,$09,$3A,$35,$39,$37,$36,$3C,$3C,$34,$30,$E6
  DC.B $0A,$BD,$9C,$30,$30,$E6,$0A,$BD,$9D,$F2,$30,$ED,$03,$27,$39,$1A,$EE
  DC.B $03,$EC,$05,$18,$ED,$07,$1A,$EE,$03,$E6,$09,$18,$E7,$06,$E6,$0A,$BD
  DC.B $9C,$5D,$30,$EE,$03,$ED,$09,$30,$EC,$03,$BD,$9C,$E5,$30,$EE         *6f
  DC.B $9B,$C0,$03,$5F,$4F,$ED,$0B,$30,$EC,$03,$BD,$9F,$D6,$30,$EE,$03,$E6
  DC.B $06,$C1,$1F,$26,$05,$BD,$95,$CE,$20,$51,$30,$EE,$03,$E6,$06,$C1,$1E
  DC.B $27,$0B,$30,$EC,$03,$BD,$9F,$19,$BD,$95,$CE,$20,$3D,$30,$6F,$00,$20
  DC.B $27,$E6,$00,$86,$25,$3D,$C3,$21,$B2,$ED,$01,$1A,$EE,$01,$18         *70
  DC.B $9C,$00,$6D,$05,$27,$13,$18,$E6,$05,$E1,$0A,$27,$0C,$18,$E6,$06,$C1
  DC.B $1E,$26,$05,$18,$EC,$0B,$27,$08,$6C,$00,$E6,$00,$C1,$04,$25,$D3,$E6
  DC.B $00,$C1,$04,$26,$05,$EC,$03,$BD,$9F,$19,$30,$C6,$07,$3A,$35,$39,$37
  DC.B $3C,$30,$E6,$02,$BD,$9D,$F2,$30,$ED,$00,$27,$1D,$EC,$00,$BD         *71
  DC.B $9C,$40,$9F,$06,$30,$EC,$00,$BD,$9F,$64,$30,$EC,$00,$BD,$9C,$E5,$30
  DC.B $EE,$00,$5F,$4F,$ED,$0B,$30,$EE,$00,$E7,$05,$38,$31,$39,$37,$3C,$30
  DC.B $6F,$00,$6F,$01,$E6,$02,$C1,$05,$24,$0A,$C1,$03,$27,$0E,$C1,$04,$27
  DC.B $11,$20,$25,$27,$14,$C1,$06,$27,$18,$20,$1D,$C6,$01,$E7,$00         *72
  DC.B $9C,$80,$5C,$20,$14,$5A,$E7,$00,$C6,$05,$20,$0D,$C6,$04,$E7,$00,$C6
  DC.B $06,$20,$05,$5C,$E7,$00,$C6,$08,$E7,$01,$EC,$00,$38,$31,$39,$37,$3C
  DC.B $30,$E6,$02,$E7,$00,$4F,$83,$00,$01,$BD,$A7,$2F,$00,$08,$00,$31,$00
  DC.B $15,$00,$15,$00,$1C,$00,$23,$00,$1C,$00,$23,$00,$2A,$00,$2A         *73
  DC.B $9C,$C0,$30,$C6,$03,$30,$E7,$01,$20,$18,$C6,$04,$30,$E7,$01,$20,$11
  DC.B $C6,$05,$30,$E7,$01,$20,$0A,$C6,$06,$30,$E7,$01,$20,$03,$30,$6F,$01
  DC.B $E6,$01,$38,$31,$39,$37,$36,$30,$EC,$00,$BD,$9F,$EE,$30,$EE,$00,$5F
  DC.B $E7,$00,$30,$EE,$00,$E7,$01,$30,$EE,$00,$E7,$02,$30,$EE,$00         *74
  DC.B $9D,$00,$E7,$04,$30,$EE,$00,$E7,$03,$38,$39,$37,$36,$3C,$34,$30,$EE
  DC.B $03,$E6,$03,$BD,$9C,$9E,$30,$E7,$00,$27,$65,$E6,$00,$BD,$9D,$B8,$30
  DC.B $ED,$01,$27,$5B,$EE,$01,$EC,$1D,$27,$55,$30,$EE,$01,$5F,$4F,$ED,$1D
  DC.B $30,$EE,$01,$EC,$0B,$27,$1C,$E6,$03,$C1,$03,$25,$0B,$C6,$C3         *75
  DC.B $9D,$40,$37,$30,$EC,$02,$BD,$96,$6C,$20,$35,$C6,$A3,$37,$30,$EC,$02
  DC.B $BD,$96,$6C,$20,$2A,$30,$EE,$01,$E6,$03,$6C,$03,$C1,$0A,$24,$0B,$C6
  DC.B $A3,$37,$30,$EC,$02,$BD,$96,$6C,$20,$14,$30,$E6,$00,$C1,$03,$26,$05
  DC.B $7E,$80,$36,$20,$09,$C6,$C3,$37,$EC,$01,$BD,$96,$6C,$31,$38         *76
  DC.B $9D,$80,$38,$31,$39,$37,$36,$3C,$34,$30,$EE,$03,$E6,$03,$BD,$9C,$9E
  DC.B $30,$E7,$00,$27,$20,$E6,$00,$BD,$9D,$B8,$30,$ED,$01,$27,$16,$EE,$01
  DC.B $EC,$23,$83,$00,$01,$26,$0D,$5F,$4F,$ED,$23,$5C,$37,$30,$EC,$02,$BD
  DC.B $97,$EF,$31,$38,$38,$31,$39,$37,$3C,$34,$5F,$4F,$30,$ED,$01         *77
  DC.B $9D,$C0,$6D,$03,$27,$29,$6F,$00,$20,$15,$E6,$00,$86,$25,$3D,$C3,$21
  DC.B $B2,$ED,$01,$EE,$01,$E6,$05,$30,$E1,$03,$27,$08,$6C,$00,$E6,$00,$C1
  DC.B $04,$25,$E5,$E6,$00,$C1,$04,$26,$04,$5F,$4F,$ED,$01,$EC,$01,$38,$38
  DC.B $39,$37,$3C,$34,$5F,$4F,$30,$ED,$01,$6D,$03,$27,$39,$6F,$00         *78
  DC.B $9E,$00,$20,$25,$E6,$00,$86,$25,$3D,$C3,$21,$B2,$ED,$01,$1A,$EE,$01
  DC.B $18,$E6,$05,$E1,$03,$27,$05,$18,$6D,$05,$26,$0A,$1A,$EE,$01,$E6,$03
  DC.B $18,$E7,$05,$20,$08,$6C,$00,$E6,$00,$C1,$04,$25,$D5,$E6,$00,$C1,$04
  DC.B $26,$04,$5F,$4F,$ED,$01,$EC,$01,$38,$38,$39,$37,$3C,$34,$30         *79
  DC.B $9E,$40,$6F,$00,$20,$1A,$E6,$00,$86,$25,$3D,$C3,$21,$B2,$ED,$01,$EE
  DC.B $01,$6D,$05,$27,$07,$E6,$06,$30,$E1,$03,$27,$09,$30,$6C,$00,$E6,$00
  DC.B $C1,$04,$25,$E0,$E6,$00,$C1,$04,$26,$04,$C6,$FF,$20,$04,$EE,$01,$E6
  DC.B $05,$38,$38,$39,$37,$36,$30,$EE,$00,$EC,$07,$27,$0B,$3C,$18         *7a
  DC.B $9E,$80,$38,$18,$EE,$07,$E6,$05,$18,$AD,$00,$38,$39,$37,$30,$EE,$03
  DC.B $E6,$05,$C1,$02,$22,$05,$1D,$04,$80,$20,$24,$30,$1A,$EE,$03,$E6,$00
  DC.B $18,$E7,$03,$EE,$03,$E6,$05,$C0,$02,$E7,$05,$30,$EE,$03,$C6,$02,$E7
  DC.B $02,$30,$EE,$03,$1C,$04,$80,$30,$EC,$03,$BD,$A0,$D0,$31,$39         *7b
  DC.B $9E,$C0,$37,$34,$30,$EE,$04,$C6,$01,$E7,$03,$30,$1A,$EE,$04,$18,$E6
  DC.B $06,$C4,$03,$A6,$01,$48,$48,$A7,$00,$EA,$00,$18,$E7,$06,$EE,$04,$C6
  DC.B $02,$E7,$02,$30,$EC,$04,$BD,$A0,$D0,$38,$39,$37,$36,$30,$EE,$00,$E6
  DC.B $02,$C1,$01,$26,$08,$30,$EC,$00,$BD,$94,$C3,$20,$06,$30,$EC         *7c
  DC.B $9F,$00,$00,$BD,$98,$26,$38,$39,$37,$36,$30,$EE,$00,$E6,$09,$BD,$A0
  DC.B $8F,$30,$EE,$00,$5F,$4F,$ED,$1D,$38,$39,$37,$36,$30,$EE,$00,$E6,$06
  DC.B $C1,$1F,$26,$02,$01,$01,$30,$EE,$00,$EC,$1D,$26,$15,$E6,$09,$37,$C6
  DC.B $18,$37,$CC,$A1,$2F,$BD,$A0,$5E,$38,$30,$EE,$00,$CC,$00,$01         *7d
  DC.B $9F,$40,$ED,$1D,$38,$39,$37,$36,$30,$EE,$00,$EC,$23,$26,$15,$CC,$00
  DC.B $01,$ED,$23,$30,$EE,$00,$E6,$0A,$37,$C6,$04,$37,$CC,$A1,$39,$BD,$A0
  DC.B $5E,$38,$38,$39,$37,$36,$30,$EE,$00,$5F,$4F,$ED,$23,$30,$EE,$00,$E6
  DC.B $0A,$BD,$A0,$8F,$38,$39,$37,$36,$30,$1A,$EE,$00,$18,$EC,$1F         *7e
  DC.B $9F,$80,$26,$07,$EC,$04,$18,$ED,$1F,$20,$0B,$EE,$00,$1A,$EE,$21,$30
  DC.B $EC,$04,$18,$ED,$00,$1A,$EE,$00,$EC,$04,$18,$ED,$21,$EE,$04,$5F,$4F
  DC.B $ED,$00,$38,$39,$37,$36,$3C,$30,$EE,$02,$EC,$1F,$26,$04,$5F,$4F,$20
  DC.B $21,$30,$1A,$EE,$02,$18,$EC,$1F,$ED,$00,$EE,$00,$EC,$00,$18         *7f
  DC.B $9F,$C0,$ED,$1F,$30,$EE,$02,$EC,$1F,$83,$00,$00,$26,$04,$5F,$4F,$ED
  DC.B $21,$30,$EC,$00,$38,$38,$39,$37,$36,$30,$EC,$00,$BD,$9F,$EE,$30,$EE
  DC.B $00,$E6,$05,$C1,$03,$26,$05,$C6,$03,$BD,$A0,$B1,$38,$39,$37,$36,$3C
  DC.B $3C,$34,$30,$6F,$04,$20,$45,$1A,$EE,$05,$E6,$04,$4F,$05,$ED         *80
  DC.B $A0,$00,$00,$18,$8F,$C3,$00,$0D,$E3,$00,$8F,$EC,$00,$27,$2D,$30,$1A
  DC.B $EE,$05,$E6,$04,$4F,$05,$ED,$00,$18,$8F,$C3,$00,$0D,$E3,$00,$8F,$EC
  DC.B $00,$BD,$A0,$F4,$30,$1A,$EE,$05,$E6,$04,$4F,$05,$ED,$00,$18,$8F,$C3
  DC.B $00,$0D,$E3,$00,$8F,$5F,$4F,$ED,$00,$30,$6C,$04,$E6,$04,$C1         *81
  DC.B $A0,$40,$08,$25,$B5,$20,$05,$EC,$02,$BD,$A0,$F4,$30,$EC,$05,$BD,$9F
  DC.B $A4,$30,$ED,$02,$83,$00,$00,$26,$ED,$30,$C6,$07,$3A,$35,$39,$37,$36
  DC.B $BD,$A1,$AA,$30,$E6,$05,$F7,$22,$6D,$E6,$04,$F7,$22,$6E,$EC,$00,$FD
  DC.B $22,$46,$37,$36,$3C,$18,$3C,$F6,$22,$6D,$B6,$22,$6E,$18,$FE         *82
  DC.B $A0,$80,$22,$46,$BD,$86,$5D,$18,$38,$38,$32,$33,$BD,$A1,$AF,$38,$39
  DC.B $37,$BD,$A1,$AA,$30,$E6,$00,$F7,$22,$6F,$37,$36,$3C,$18,$3C,$F6,$22
  DC.B $6F,$CE,$00,$00,$BD,$85,$BE,$18,$38,$38,$32,$33,$BD,$A1,$AF,$31,$39
  DC.B $37,$BD,$A1,$AA,$30,$E6,$00,$F7,$22,$70,$37,$36,$3C,$18,$3C         *83
  DC.B $A0,$C0,$F6,$22,$70,$BD,$86,$88,$18,$38,$38,$32,$33,$BD,$A1,$AF,$31
  DC.B $39,$37,$36,$BD,$A1,$AA,$30,$EC,$00,$FD,$22,$48,$37,$36,$3C,$18,$3C
  DC.B $18,$CE,$22,$88,$FE,$22,$48,$BD,$83,$4F,$18,$38,$38,$32,$33,$BD,$A1
  DC.B $AF,$38,$39,$37,$36,$BD,$A1,$AA,$30,$EC,$00,$FD,$22,$4A,$37         *84
  DC.B $A1,$00,$36,$3C,$18,$3C,$FE,$22,$4A,$BD,$84,$8E,$18,$38,$38,$32,$33
  DC.B $BD,$A1,$AF,$38,$39,$3C,$BD,$A1,$AA,$BD,$84,$31,$8F,$BD,$A1,$AF,$38
  DC.B $39,$FC,$22,$4C,$39,$FF,$22,$4E,$FC,$22,$4E,$BD,$9E,$EB,$39,$FF,$22
  DC.B $50,$FC,$22,$50,$BD,$9D,$09,$39,$FF,$22,$52,$FC,$22,$52,$BD         *85
  DC.B $A1,$40,$9D,$83,$39,$FF,$22,$54,$FC,$22,$54,$BD,$8F,$C4,$39,$FF,$22
  DC.B $56,$FC,$22,$56,$BD,$8C,$33,$39,$FF,$22,$58,$FC,$22,$58,$BD,$A1,$B3
  DC.B $39,$C6,$03,$37,$5F,$37,$CC,$A1,$6E,$BD,$9B,$88,$38,$39,$37,$BD,$BF
  DC.B $79,$31,$39,$36,$BD,$D3,$FC,$B7,$22,$71,$32,$F6,$22,$71,$39         *86
  DC.B $A1,$80,$37,$30,$E6,$00,$F7,$22,$72,$36,$B6,$22,$72,$BD,$C0,$2E,$32
  DC.B $31,$39,$FF,$22,$5A,$18,$FF,$22,$5C,$FE,$22,$5A,$3C,$FC,$22,$5C,$BD
  DC.B $8A,$4A,$38,$FD,$22,$5E,$FC,$22,$5E,$39,$0F,$7C,$3C,$BB,$39,$BD,$83
  DC.B $30,$39,$37,$36,$3C,$34,$CC,$00,$01,$30,$ED,$01,$1A,$EE,$03         *87
  DC.B $A1,$C0,$18,$8F,$C3,$00,$08,$FD,$22,$62,$EE,$03,$E6,$05,$4F,$F3,$22
  DC.B $62,$83,$00,$01,$FD,$22,$64,$6D,$05,$27,$03,$7E,$A2,$A3,$7E,$A2,$AE
  DC.B $18,$FE,$22,$62,$18,$E6,$00,$30,$E7,$00,$18,$08,$18,$FF,$22,$62,$18
  DC.B $09,$18,$E6,$00,$C1,$C7,$24,$16,$C1,$33,$24,$0A,$C1,$24,$27         *88
  DC.B $A2,$00,$3A,$C1,$26,$27,$16,$20,$06,$27,$22,$C1,$C0,$27,$3E,$20,$7A
  DC.B $27,$41,$C1,$CF,$27,$4B,$C1,$D0,$27,$60,$20,$6E,$CE,$22,$62,$3C,$FC
  DC.B $22,$64,$BD,$A2,$B2,$38,$30,$ED,$01,$20,$6C,$CE,$22,$62,$3C,$FC,$22
  DC.B $64,$BD,$A4,$02,$38,$30,$ED,$01,$20,$5C,$CE,$22,$62,$3C,$FC         *89
  DC.B $A2,$40,$22,$64,$BD,$A4,$3A,$38,$30,$ED,$01,$20,$4C,$C6,$20,$BD,$A4
  DC.B $C4,$20,$45,$BD,$A4,$63,$FC,$22,$64,$C3,$00,$01,$FD,$22,$62,$20,$37
  DC.B $CE,$22,$62,$3C,$FC,$22,$64,$BD,$A4,$8B,$38,$30,$ED,$01,$FC,$22,$64
  DC.B $C3,$00,$01,$FD,$22,$62,$20,$1E,$CE,$22,$62,$3C,$FC,$22,$64         *8a
  DC.B $A2,$80,$BD,$A3,$0C,$38,$30,$ED,$01,$20,$0E,$FC,$22,$64,$C3,$00,$01
  DC.B $FD,$22,$62,$E6,$00,$BD,$A5,$0D,$30,$EC,$01,$26,$07,$E6,$00,$BD,$A5
  DC.B $0D,$20,$0B,$FC,$22,$62,$B3,$22,$64,$22,$03,$7E,$A1,$E0,$38,$38,$31
  DC.B $39,$37,$36,$3C,$30,$EE,$06,$EC,$00,$30,$ED,$00,$C3,$00,$01         *8b
  DC.B $A2,$C0,$A3,$02,$23,$03,$5F,$20,$41,$EE,$06,$EC,$00,$C3,$00,$02,$ED
  DC.B $00,$7D,$22,$77,$26,$31,$C6,$01,$F7,$22,$77,$30,$1A,$EE,$00,$18,$08
  DC.B $1A,$EF,$00,$18,$09,$18,$E6,$00,$F7,$22,$78,$1A,$EE,$00,$18,$08,$1A
  DC.B $EF,$00,$18,$09,$18,$E6,$00,$F7,$22,$7A,$C4,$7F,$F7,$22,$7B         *8c
  DC.B $A3,$00,$7F,$22,$79,$BD,$A6,$44,$C6,$01,$4F,$38,$38,$39,$37,$36,$3C
  DC.B $3C,$34,$30,$EE,$09,$EC,$00,$30,$ED,$03,$6F,$00,$C3,$00,$01,$A3,$05
  DC.B $23,$04,$5F,$7E,$A3,$FC,$EE,$09,$EC,$00,$C3,$00,$02,$ED,$00,$30,$1A
  DC.B $EE,$03,$18,$08,$1A,$EF,$03,$18,$09,$18,$E6,$00,$E7,$02,$1A         *8d
  DC.B $A3,$40,$EE,$03,$18,$08,$1A,$EF,$03,$18,$09,$18,$A6,$00,$A7,$01,$1A
  DC.B $EE,$03,$18,$08,$1A,$EF,$03,$18,$09,$18,$A6,$00,$A7,$00,$C1,$03,$26
  DC.B $50,$E6,$01,$C1,$03,$26,$50,$E6,$00,$C1,$02,$26,$46,$E6,$00,$4F,$E3
  DC.B $03,$83,$00,$01,$A3,$05,$22,$3A,$1A,$EE,$03,$18,$08,$1A,$EF         *8e
  DC.B $A3,$80,$03,$18,$09,$18,$E6,$00,$4F,$C3,$00,$02,$05,$CE,$00,$05,$BD
  DC.B $A6,$FD,$F7,$22,$75,$30,$EE,$03,$E6,$00,$4F,$C3,$00,$02,$05,$CE,$00
  DC.B $05,$BD,$A6,$FD,$F7,$22,$74,$30,$EE,$09,$EC,$00,$C3,$00,$03,$ED,$00
  DC.B $20,$47,$5F,$4F,$20,$46,$E6,$01,$C1,$04,$26,$22,$6D,$00,$26         *8f
  DC.B $A3,$C0,$1A,$E6,$00,$4F,$E3,$03,$83,$00,$01,$A3,$05,$22,$0E,$C6,$01
  DC.B $F7,$22,$76,$EC,$09,$C3,$00,$02,$ED,$09,$20,$1F,$5F,$4F,$20,$1E,$E6
  DC.B $01,$C1,$05,$26,$05,$7F,$22,$76,$20,$10,$E6,$01,$C1,$06,$26,$0A,$C6
  DC.B $04,$F7,$22,$75,$C6,$1E,$F7,$22,$74,$C6,$01,$4F,$38,$38,$38         *90
  DC.B $A4,$00,$31,$39,$37,$36,$3C,$30,$EE,$06,$EC,$00,$30,$ED,$00,$C3,$00
  DC.B $01,$A3,$02,$22,$10,$EE,$00,$E6,$00,$C4,$1E,$C1,$16,$26,$06,$E6,$01
  DC.B $C1,$0D,$27,$03,$5F,$20,$0F,$7F,$22,$77,$30,$EE,$06,$EC,$00,$C3,$00
  DC.B $02,$ED,$00,$C6,$01,$4F,$38,$38,$39,$37,$36,$3C,$30,$EE,$06         *91
  DC.B $A4,$40,$EC,$00,$30,$ED,$00,$A3,$02,$23,$03,$5F,$20,$13,$EE,$00,$E6
  DC.B $00,$BD,$A1,$80,$30,$EE,$06,$EC,$00,$C3,$00,$01,$ED,$00,$C6,$01,$4F
  DC.B $38,$38,$39,$C6,$01,$F7,$22,$76,$C6,$1E,$F7,$22,$74,$86,$04,$B7,$22
  DC.B $75,$7F,$22,$77,$B6,$14,$30,$84,$E8,$8A,$05,$B7,$14,$30,$86         *92
  DC.B $A4,$80,$06,$36,$37,$CC,$A6,$1D,$BD,$9B,$88,$38,$39,$37,$36,$3C,$30
  DC.B $EE,$06,$EC,$00,$30,$ED,$00,$A3,$02,$23,$03,$5F,$20,$23,$C6,$06,$37
  DC.B $EE,$00,$E6,$00,$C4,$1F,$37,$CC,$A6,$1D,$BD,$9B,$88,$38,$CC,$00,$01
  DC.B $FD,$22,$60,$30,$EE,$06,$EC,$00,$C3,$00,$01,$ED,$00,$C6,$01         *93
  DC.B $A4,$C0,$4F,$38,$38,$39,$37,$3C,$BD,$A1,$14,$30,$ED,$00,$27,$3C,$EE
  DC.B $00,$C6,$C1,$E7,$08,$30,$EE,$00,$C6,$9E,$E7,$09,$30,$1A,$EE,$00,$E6
  DC.B $02,$18,$E7,$0A,$EE,$00,$5F,$E7,$0B,$30,$EE,$00,$C6,$04,$E7,$05,$30
  DC.B $EE,$00,$C6,$02,$E7,$03,$30,$EE,$00,$C6,$06,$E7,$02,$30,$EE         *94
  DC.B $A5,$00,$00,$1C,$04,$80,$30,$EC,$00,$BD,$A0,$D0,$38,$31,$39,$37,$3C
  DC.B $BD,$A1,$14,$30,$ED,$00,$27,$2D,$EE,$00,$C6,$C2,$E7,$08,$30,$1A,$EE
  DC.B $00,$E6,$02,$18,$E7,$09,$EE,$00,$C6,$02,$E7,$05,$30,$EE,$00,$E7,$03
  DC.B $30,$EE,$00,$C6,$06,$E7,$02,$30,$EE,$00,$1C,$04,$80,$30,$EC         *95
  DC.B $A5,$40,$00,$BD,$A0,$D0,$38,$31,$39,$34,$FC,$22,$60,$27,$2A,$BD,$A1
  DC.B $74,$30,$E7,$00,$F6,$22,$66,$C1,$01,$27,$0A,$C1,$02,$27,$1B,$C1,$03
  DC.B $27,$3C,$20,$75,$6D,$00,$26,$7B,$C6,$02,$F7,$22,$66,$5F,$BD,$A5,$E5
  DC.B $30,$E6,$00,$F7,$22,$73,$20,$6A,$6D,$00,$27,$66,$7D,$22,$76         *96
  DC.B $A5,$80,$27,$0A,$C6,$03,$F7,$22,$66,$7F,$22,$67,$20,$0A,$C6,$40,$BD
  DC.B $A5,$E5,$C6,$01,$F7,$22,$66,$30,$E6,$00,$F7,$22,$73,$20,$45,$6D,$00
  DC.B $27,$14,$7C,$22,$67,$F6,$22,$67,$F1,$22,$74,$23,$09,$C6,$40,$BD,$A5
  DC.B $E5,$C6,$01,$20,$18,$6D,$00,$26,$29,$F6,$22,$67,$F1,$22,$75         *97
  DC.B $A5,$C0,$23,$0A,$C6,$16,$BD,$A5,$E5,$C6,$56,$BD,$A5,$E5,$C6,$02,$F7
  DC.B $22,$66,$30,$E6,$00,$F7,$22,$73,$20,$0A,$C6,$01,$F7,$22,$66,$E6,$00
  DC.B $F7,$22,$73,$31,$39,$37,$3C,$BD,$A1,$14,$30,$ED,$00,$27,$2B,$EE,$00
  DC.B $C6,$02,$E7,$08,$30,$1A,$EE,$00,$A6,$02,$18,$A7,$09,$EE,$00         *98
  DC.B $A6,$00,$E7,$05,$30,$EE,$00,$E7,$03,$30,$EE,$00,$C6,$06,$E7,$02,$30
  DC.B $EE,$00,$1C,$04,$80,$30,$EC,$00,$BD,$A0,$D0,$38,$31,$39,$37,$C6,$08
  DC.B $BD,$A4,$C4,$BD,$A1,$74,$53,$F7,$22,$73,$31,$39,$5F,$4F,$FD,$22,$60
  DC.B $C6,$06,$BD,$9C,$30,$39,$F6,$1C,$00,$C4,$0F,$C1,$02,$26,$03         *99
  DC.B $A6,$40,$BD,$A4,$63,$39,$3C,$3C,$7D,$22,$77,$26,$11,$C6,$1A,$BD,$A0
  DC.B $8F,$7F,$22,$79,$F6,$14,$30,$C4,$E8,$CA,$05,$20,$7A,$CE,$22,$7A,$1E
  DC.B $00,$80,$13,$7A,$22,$7B,$7D,$22,$7B,$26,$0B,$7F,$22,$79,$F6,$22,$7A
  DC.B $C4,$7F,$F7,$22,$7B,$B6,$22,$79,$81,$08,$27,$3E,$7C,$22,$79         *9a
  DC.B $A6,$80,$16,$CE,$00,$80,$BD,$A7,$22,$30,$ED,$02,$F6,$22,$78,$4F,$ED
  DC.B $00,$E4,$03,$A4,$02,$83,$00,$00,$27,$09,$F6,$14,$30,$C4,$E8,$CA,$01
  DC.B $20,$07,$F6,$14,$30,$C4,$E8,$CA,$05,$F7,$14,$30,$C6,$1A,$37,$C6,$08
  DC.B $37,$CC,$A6,$44,$BD,$A0,$5E,$38,$20,$1E,$CE,$22,$7A,$1E,$00         *9b
  DC.B $A6,$C0,$80,$0D,$C6,$1A,$37,$C6,$08,$37,$CC,$A6,$44,$BD,$A0,$5E,$38
  DC.B $F6,$14,$30,$C4,$E8,$CA,$05,$F7,$14,$30,$38,$38,$39,$4D,$27,$04,$58
  DC.B $4A,$26,$FC,$39,$3C,$30,$37,$36,$A6,$00,$3D,$E7,$00,$A6,$01,$33,$3D
  DC.B $EB,$00,$E7,$00,$A6,$01,$33,$3D,$AB,$00,$38,$39,$8F,$4D,$2C         *9c
  DC.B $A7,$00,$13,$43,$53,$8F,$08,$4D,$2C,$06,$43,$53,$02,$08,$8F,$39,$02
  DC.B $09,$8F,$43,$53,$39,$8F,$4D,$2C,$07,$43,$53,$02,$8F,$43,$53,$39,$02
  DC.B $8F,$39,$4F,$8F,$8C,$00,$00,$2F,$05,$47,$56,$09,$26,$FB,$39,$30,$1A
  DC.B $EE,$00,$CD,$A3,$00,$24,$0A,$05,$E3,$00,$18,$8F,$18,$EC,$04         *9d
  DC.B $A7,$40,$20,$03,$18,$EC,$02,$E3,$00,$ED,$00,$39,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$18,$1C,$1E,$1F,$1E,$1C,$18,$00,$03,$07,$0F,$1F,$0F,$07
  DC.B $03,$00,$00,$00,$1E,$1E,$1E,$1E,$00,$00,$0A,$15,$19,$19,$15,$13,$13
  DC.B $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00         *9e
  DC.B $A7,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$08,$04,$00,$12,$12
  DC.B $12,$0D,$00,$08,$14,$00,$18,$08,$08,$1C,$00,$04,$0A,$00,$0E,$11,$11
  DC.B $0E,$00,$0A,$00,$0E,$11,$1F,$10,$0E,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$00,$00,$00,$FF,$FF,$00,$00,$00,$00,$04,$00,$1F,$00,$04         *9f
  DC.B $A7,$C0,$00,$00,$06,$09,$08,$1C,$08,$1D,$1A,$00,$00,$11,$0A,$04,$0A
  DC.B $11,$00,$00,$00,$00,$00,$06,$06,$00,$00,$00,$00,$0A,$00,$0C,$04,$04
  DC.B $0E,$00,$00,$0A,$00,$12,$12,$12,$0D,$00,$1E,$21,$AA,$82,$92,$AA,$BA
  DC.B $44,$00,$00,$7C,$44,$54,$48,$44,$FE,$AA,$55,$AA,$55,$AA,$55         *a0
  DC.B $A8,$00,$AA,$55,$00,$04,$15,$0E,$15,$04,$00,$00,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$08,$14,$14,$08,$00,$00,$00,$00,$04,$02,$0E,$01,$0F,$11
  DC.B $0F,$00,$04,$08,$0E,$11,$1F,$10,$0E,$00,$04,$02,$0E,$11,$1F,$10,$0E
  DC.B $00,$04,$0A,$0E,$11,$1F,$10,$0E,$00,$04,$0A,$00,$12,$12,$12         *a1
  DC.B $A8,$40,$0D,$00,$00,$0E,$11,$10,$11,$0E,$04,$0E,$0A,$00,$0E,$01,$0F
  DC.B $11,$0F,$00,$0A,$00,$0E,$11,$11,$11,$0E,$00,$AB,$3A,$AB,$1F,$AB,$24
  DC.B $A9,$4A,$A9,$A4,$AC,$2E,$AB,$DC,$AA,$16,$AC,$24,$A8,$FE,$A8,$DB,$AC
  DC.B $B6,$AC,$19,$AC,$51,$37,$36,$30,$F6,$14,$20,$17,$C4,$03,$84         *a2
  DC.B $A8,$80,$FC,$6D,$00,$27,$07,$C1,$03,$27,$0B,$5C,$20,$04,$5D,$27,$05
  DC.B $5A,$1B,$B7,$14,$20,$33,$32,$39,$3C,$CE,$18,$01,$1F,$00,$03,$FC,$A7
  DC.B $00,$38,$39,$3C,$36,$BD,$A9,$39,$B6,$3C,$C8,$81,$00,$26,$0B,$CE,$A8
  DC.B $5A,$FF,$3C,$D8,$BD,$AB,$5D,$20,$09,$CE,$B0,$0B,$FF,$3C,$D8         *a3
  DC.B $A8,$C0,$BD,$B0,$5F,$32,$38,$39,$3C,$CE,$18,$00,$1F,$01,$03,$FC,$A7
  DC.B $00,$38,$39,$36,$8D,$F1,$86,$C0,$8D,$BE,$32,$39,$36,$37,$3C,$18,$3C
  DC.B $C6,$80,$BD,$AA,$DE,$BD,$BF,$1F,$27,$0E,$16,$CE,$AD,$04,$58,$3A,$EC
  DC.B $00,$CE,$AE,$CF,$BD,$AD,$10,$18,$38,$38,$33,$32,$39,$36,$37         *a4
  DC.B $A9,$00,$3C,$18,$3C,$C6,$80,$BD,$AA,$F0,$BD,$BF,$1F,$27,$0E,$16,$CE
  DC.B $AD,$04,$58,$3A,$EC,$00,$CE,$AD,$FC,$BD,$AD,$10,$18,$38,$38,$33,$32
  DC.B $39,$37,$36,$36,$86,$50,$5A,$3D,$37,$36,$18,$30,$8F,$18,$E3,$00,$8F
  DC.B $31,$31,$33,$5A,$3A,$32,$33,$39,$18,$CE,$A8,$5A,$18,$FF,$3C         *a5
  DC.B $A9,$40,$D0,$18,$CE,$51,$3C,$18,$FF,$3C,$D2,$39,$36,$37,$3C,$18,$3C
  DC.B $86,$03,$C6,$00,$BD,$AC,$0D,$86,$22,$BD,$A8,$97,$18,$FE,$3C,$D0,$18
  DC.B $8C,$A8,$5A,$26,$0B,$18,$CE,$A7,$4A,$C6,$00,$86,$1C,$FD,$3C,$CC,$FC
  DC.B $3C,$CC,$37,$16,$32,$BD,$AB,$14,$86,$B0,$BD,$A8,$97,$C6,$03         *a6
  DC.B $A9,$80,$BD,$A9,$FC,$18,$8C,$A8,$5A,$24,$0C,$5A,$26,$F4,$FC,$3C,$CC
  DC.B $C3,$00,$18,$FD,$3C,$CC,$18,$FF,$3C,$D0,$86,$B3,$BD,$A8,$97,$18,$38
  DC.B $38,$33,$32,$39,$36,$37,$3C,$18,$3C,$B6,$51,$3C,$85,$10,$26,$46,$86
  DC.B $03,$C6,$00,$BD,$AC,$0D,$86,$22,$BD,$A8,$97,$18,$FE,$3C,$D2         *a7
  DC.B $A9,$C0,$18,$8C,$51,$3C,$26,$0E,$18,$CE,$50,$A4,$C6,$00,$86,$1C,$C3
  DC.B $01,$10,$FD,$3C,$CE,$FC,$3C,$CE,$37,$16,$32,$BD,$AB,$14,$86,$B0,$BD
  DC.B $A8,$97,$8D,$18,$FC,$3C,$CE,$C3,$00,$08,$FD,$3C,$CE,$18,$FF,$3C,$D2
  DC.B $86,$B3,$BD,$A8,$97,$18,$38,$38,$33,$32,$39,$37,$36,$3C,$C6         *a8
  DC.B $AA,$00,$08,$18,$A6,$00,$CE,$18,$00,$1F,$01,$03,$FC,$A7,$00,$18,$08
  DC.B $5A,$26,$EF,$38,$32,$33,$39,$36,$37,$3C,$18,$3C,$18,$CE,$AD,$04,$86
  DC.B $00,$BD,$BF,$1F,$27,$29,$BD,$AA,$CE,$27,$39,$C6,$40,$BD,$AA,$F0,$BD
  DC.B $AA,$BE,$26,$0D,$36,$CE,$AD,$FC,$18,$EC,$00,$BD,$AD,$10,$32         *a9
  DC.B $AA,$40,$20,$22,$36,$CE,$AE,$CF,$18,$EC,$00,$BD,$AD,$10,$32,$20,$15
  DC.B $BD,$AA,$CE,$26,$10,$36,$CE,$AD,$FC,$18,$EC,$00,$BD,$AD,$88,$32,$C6
  DC.B $40,$BD,$AA,$DE,$18,$08,$18,$08,$4C,$81,$06,$26,$B4,$18,$38,$38,$33
  DC.B $32,$39,$36,$37,$3C,$18,$3C,$18,$CE,$AD,$04,$B6,$3C,$E3,$16         *aa
  DC.B $AA,$80,$58,$18,$3A,$BD,$BF,$1F,$27,$C7,$BD,$AA,$BE,$26,$1E,$C6,$40
  DC.B $BD,$AA,$F0,$CE,$AD,$FC,$18,$EC,$00,$BD,$AD,$10,$20,$0E,$CE,$AD,$FC
  DC.B $18,$EC,$00,$BD,$AD,$88,$C6,$40,$BD,$AA,$DE,$F6,$3C,$E3,$5C,$C1,$06
  DC.B $26,$02,$C6,$00,$F7,$3C,$E3,$18,$38,$38,$33,$32,$39,$3C,$37         *ab
  DC.B $AA,$C0,$36,$CE,$3C,$DA,$16,$3A,$86,$80,$A5,$00,$32,$33,$38,$39,$3C
  DC.B $37,$36,$CE,$3C,$DA,$16,$3A,$86,$40,$A5,$00,$32,$33,$38,$39,$3C,$37
  DC.B $36,$37,$16,$32,$CE,$3C,$DA,$3A,$AA,$00,$A7,$00,$32,$33,$38,$39,$3C
  DC.B $37,$36,$37,$16,$32,$CE,$3C,$DA,$3A,$43,$A4,$00,$A7,$00,$32         *ac
  DC.B $AB,$00,$33,$38,$39,$3C,$86,$C5,$BD,$A8,$97,$CE,$18,$00,$1F,$01,$03
  DC.B $FC,$A6,$00,$38,$39,$36,$BD,$AC,$0D,$86,$24,$BD,$A8,$97,$32,$39,$CE
  DC.B $AF,$A2,$20,$08,$CE,$AF,$B7,$20,$03,$CE,$AF,$CC,$86,$24,$C6,$11,$BD
  DC.B $AB,$FB,$39,$C6,$10,$BD,$AB,$FB,$39,$86,$31,$CE,$80,$02,$8D         *ad
  DC.B $AB,$40,$F3,$86,$3F,$CE,$E8,$04,$8D,$EC,$86,$7A,$CE,$80,$0E,$8D,$E5
  DC.B $39,$CE,$AF,$F6,$20,$03,$CE,$AF,$E1,$86,$D4,$8D,$D8,$39,$86,$FE,$94
  DC.B $08,$97,$08,$86,$01,$9A,$08,$97,$08,$B6,$14,$20,$84,$FC,$8A,$02,$B7
  DC.B $14,$20,$86,$9C,$BD,$A8,$97,$86,$81,$BD,$A8,$97,$86,$00,$C6         *ae
  DC.B $AB,$80,$00,$BD,$AC,$0D,$86,$42,$BD,$A8,$97,$86,$28,$5F,$BD,$AC,$0D
  DC.B $86,$43,$BD,$A8,$97,$86,$03,$5F,$BD,$AC,$0D,$86,$22,$BD,$A8,$97,$CE
  DC.B $3C,$DA,$86,$40,$A7,$00,$A7,$01,$A7,$02,$A7,$03,$A7,$04,$A7,$05,$86
  DC.B $00,$C6,$10,$BD,$AC,$0D,$86,$40,$BD,$A8,$97,$86,$28,$5F,$BD         *af
  DC.B $AB,$C0,$AC,$0D,$86,$41,$BD,$A8,$97,$8D,$01,$39,$37,$36,$3C,$CC,$00
  DC.B $00,$BD,$AB,$14,$CE,$1F,$FF,$8D,$1A,$38,$32,$33,$39,$36,$37,$3C,$18
  DC.B $3C,$CC,$00,$00,$BD,$AB,$14,$CE,$0F,$FF,$8D,$06,$18,$38,$38,$33,$32
  DC.B $39,$5F,$17,$BD,$A8,$D2,$09,$26,$F9,$39,$36,$BD,$AB,$14,$A6         *b0
  DC.B $AC,$00,$00,$27,$08,$08,$80,$20,$BD,$A8,$D2,$20,$F4,$32,$39,$37,$36
  DC.B $BD,$A8,$C6,$17,$BD,$A8,$C6,$32,$33,$39,$36,$86,$A7,$BD,$A8,$97,$32
  DC.B $8D,$14,$32,$39,$36,$86,$A0,$BD,$A8,$97,$32,$8D,$09,$39,$36,$86,$9C
  DC.B $BD,$A8,$97,$32,$39,$37,$36,$4A,$5A,$36,$17,$BD,$A8,$C6,$32         *b1
  DC.B $AC,$40,$48,$BD,$A8,$C6,$86,$21,$BD,$A8,$97,$86,$9F,$BD,$A8,$97,$32
  DC.B $33,$39,$3C,$18,$3C,$37,$36,$18,$8F,$CC,$00,$00,$FD,$3C,$E0,$18,$6D
  DC.B $00,$27,$34,$7D,$3C,$E2,$26,$04,$86,$00,$20,$06,$A6,$00,$2B,$02,$80
  DC.B $20,$36,$3C,$CE,$10,$00,$3C,$30,$FC,$3C,$E0,$E3,$00,$36,$17         *b2
  DC.B $AC,$80,$BD,$A8,$C6,$32,$BD,$A8,$C6,$86,$24,$BD,$A8,$97,$38,$38,$32
  DC.B $BD,$A8,$C6,$86,$C4,$BD,$A8,$97,$08,$18,$08,$FC,$3C,$E0,$C3,$00,$01
  DC.B $FD,$3C,$E0,$1A,$83,$01,$40,$26,$B5,$B6,$3C,$E2,$43,$B7,$3C,$E2,$32
  DC.B $33,$18,$38,$38,$39,$3C,$18,$3C,$36,$37,$18,$8F,$CC,$00,$10         *b3
  DC.B $AC,$C0,$BD,$AB,$14,$86,$B0,$BD,$A8,$97,$CC,$01,$40,$FD,$3C,$E0,$A6
  DC.B $00,$2B,$02,$80,$20,$18,$6D,$00,$27,$07,$7D,$3C,$E2,$26,$02,$86,$00
  DC.B $3C,$CE,$18,$00,$1F,$01,$03,$FC,$A7,$00,$38,$08,$18,$08,$FC,$3C,$E0
  DC.B $83,$00,$01,$FD,$3C,$E0,$26,$D5,$86,$B3,$BD,$A8,$97,$33,$32         *b4
  DC.B $AD,$00,$18,$38,$38,$39,$04,$88,$04,$95,$04,$A2,$07,$08,$07,$15,$07
  DC.B $22,$3C,$18,$3C,$37,$36,$FD,$3C,$D6,$18,$CE,$18,$00,$FC,$3C,$D6,$36
  DC.B $37,$32,$33,$BD,$AB,$14,$FC,$3C,$D6,$C3,$00,$28,$FD,$3C,$D6,$E6,$00
  DC.B $27,$4F,$08,$86,$C5,$BD,$A8,$97,$18,$1F,$01,$03,$FB,$18,$A6         *b5
  DC.B $AD,$40,$00,$84,$38,$AA,$00,$36,$86,$B0,$BD,$A8,$97,$32,$18,$1F,$01
  DC.B $03,$FB,$18,$A7,$00,$5A,$08,$A6,$00,$08,$18,$1F,$01,$03,$FB,$18,$A7
  DC.B $00,$5A,$C1,$01,$26,$F0,$86,$B3,$BD,$A8,$97,$86,$C5,$BD,$A8,$97,$18
  DC.B $1F,$01,$03,$FB,$18,$A6,$00,$84,$07,$AA,$00,$BD,$A8,$D2,$08         *b6
  DC.B $AD,$80,$20,$9A,$32,$33,$18,$38,$38,$39,$3C,$18,$3C,$37,$36,$FD,$3C
  DC.B $D6,$18,$CE,$18,$00,$FC,$3C,$D6,$36,$37,$32,$33,$BD,$AB,$14,$FC,$3C
  DC.B $D6,$C3,$00,$28,$FD,$3C,$D6,$E6,$00,$27,$4B,$08,$86,$C5,$BD,$A8,$97
  DC.B $86,$38,$18,$1F,$01,$03,$FB,$18,$A4,$00,$36,$86,$B0,$BD,$A8         *b7
  DC.B $AD,$C0,$97,$32,$18,$1F,$01,$03,$FB,$18,$A7,$00,$5A,$08,$86,$00,$08
  DC.B $18,$1F,$01,$03,$FB,$18,$A7,$00,$5A,$C1,$01,$26,$F2,$86,$B3,$BD,$A8
  DC.B $97,$86,$C5,$BD,$A8,$97,$86,$07,$18,$1F,$01,$03,$FB,$18,$A4,$00,$BD
  DC.B $A8,$D2,$08,$20,$9E,$32,$33,$18,$38,$38,$39,$0E,$00,$3F,$3F         *b8
  DC.B $AE,$00,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$00,$0E,$01,$00,$00
  DC.B $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$0E,$02,$00,$00,$00,$00
  DC.B $00,$00,$00,$00,$00,$00,$00,$00,$18,$0E,$02,$00,$00,$00,$00,$00,$00
  DC.B $00,$00,$00,$00,$00,$00,$18,$0E,$02,$00,$00,$00,$00,$00,$00         *b9
  DC.B $AE,$40,$00,$00,$00,$00,$00,$00,$18,$0E,$02,$00,$00,$00,$00,$00,$00
  DC.B $00,$00,$00,$00,$00,$00,$18,$0E,$02,$00,$00,$00,$00,$00,$00,$00,$00
  DC.B $00,$00,$00,$00,$18,$0E,$02,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  DC.B $00,$00,$18,$0E,$02,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00         *ba
  DC.B $AE,$80,$00,$00,$18,$0E,$02,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  DC.B $00,$00,$18,$0E,$02,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  DC.B $18,$0E,$03,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$38,$0E
  DC.B $01,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$30,$0E         *bb
  DC.B $AE,$C0,$00,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$20,$00
  DC.B $0E,$00,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$00,$0E,$01
  DC.B $3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$30,$0E,$03,$3F,$3F
  DC.B $3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$38,$0E,$03,$3F,$3F         *bc
  DC.B $AF,$00,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$38,$0E,$03,$3F,$3F
  DC.B $3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$38,$0E,$03,$3F,$3F,$3F,$3F
  DC.B $3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$38,$0E,$03,$3F,$3F,$3F,$3F,$3F,$3F
  DC.B $3F,$3F,$3F,$3F,$3F,$3F,$38,$0E,$03,$3F,$3F,$3F,$3F,$3F,$3F         *bd
  DC.B $AF,$40,$3F,$3F,$3F,$3F,$3F,$3F,$38,$0E,$03,$3F,$3F,$3F,$3F,$3F,$3F
  DC.B $3F,$3F,$3F,$3F,$3F,$3F,$38,$0E,$03,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F
  DC.B $3F,$3F,$3F,$3F,$38,$0E,$03,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F
  DC.B $3F,$3F,$38,$0E,$03,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F         *be
  DC.B $AF,$80,$3F,$3F,$38,$0E,$01,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F
  DC.B $3F,$3F,$30,$0E,$00,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F
  DC.B $20,$00,$57,$61,$69,$74,$69,$6E,$67,$20,$66,$6F,$72,$20,$53,$59,$4E
  DC.B $43,$20,$20,$20,$20,$00,$57,$61,$69,$74,$69,$6E,$67,$20,$66         *bf
  DC.B $AF,$C0,$6F,$72,$20,$43,$4F,$4D,$4D,$20,$20,$20,$20,$00,$4C,$6F,$61
  DC.B $64,$69,$6E,$67,$2E,$2E,$2E,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
  DC.B $00,$47,$6F,$6F,$64,$20,$46,$4C,$41,$53,$48,$20,$20,$20,$20,$20,$20
  DC.B $20,$20,$20,$20,$00,$44,$6F,$77,$6E,$6C,$6F,$61,$64,$20,$52         *c0
  DC.B $B0,$00,$65,$71,$75,$69,$72,$65,$64,$20,$20,$20,$00,$B0,$A4,$B0,$C5
  DC.B $B0,$D5,$B0,$E5,$B0,$E6,$B1,$7D,$B1,$2D,$B0,$E5,$B1,$35,$B0,$E5,$B0
  DC.B $E5,$B2,$11,$B1,$35,$B1,$88,$10,$E1,$11,$EE,$12,$EF,$13,$F5,$14,$85
  DC.B $15,$FD,$16,$EC,$17,$EB,$DB,$A5,$DB,$A1,$A5,$A1,$6F,$F4,$00         *c1
  DC.B $B0,$40,$01,$02,$03,$04,$05,$06,$07,$3C,$CE,$18,$00,$1E,$00,$80,$FC
  DC.B $A7,$00,$38,$39,$3C,$CE,$18,$00,$1E,$00,$80,$FC,$A7,$01,$38,$39,$36
  DC.B $86,$FE,$94,$08,$97,$08,$86,$01,$9A,$08,$97,$08,$B6,$14,$20,$84,$FC
  DC.B $8A,$01,$B7,$14,$20,$86,$38,$CE,$18,$00,$A7,$00,$BD,$B2,$5C         *c2
  DC.B $B0,$80,$86,$38,$CE,$18,$00,$A7,$00,$86,$1E,$BD,$CA,$71,$86,$38,$CE
  DC.B $18,$00,$A7,$00,$86,$1E,$BD,$CA,$71,$86,$06,$BD,$B0,$47,$86,$0C,$BD
  DC.B $B0,$47,$32,$39,$3C,$36,$86,$80,$BD,$B0,$47,$CE,$80,$02,$BD,$B2,$4D
  DC.B $CE,$E8,$04,$BD,$B2,$4D,$86,$C0,$BD,$B0,$47,$CE,$80,$17,$BD         *c3
  DC.B $B0,$C0,$B2,$4D,$32,$38,$39,$3C,$36,$86,$C0,$BD,$B0,$47,$CE,$AF,$A2
  DC.B $BD,$B2,$4D,$32,$38,$39,$3C,$36,$86,$C0,$BD,$B0,$47,$CE,$AF,$B7,$BD
  DC.B $B2,$4D,$32,$38,$39,$39,$18,$3C,$36,$37,$7D,$3C,$E8,$26,$39,$B6,$51
  DC.B $3C,$85,$10,$26,$32,$18,$FE,$3C,$E5,$27,$06,$18,$8C,$50,$E4         *c4
  DC.B $B1,$00,$26,$0A,$18,$CE,$50,$A4,$FD,$3C,$E5,$7F,$3C,$E7,$C6,$08,$86
  DC.B $40,$BA,$3C,$E7,$BD,$B0,$47,$18,$A6,$00,$BD,$B0,$53,$18,$08,$7C,$3C
  DC.B $E7,$5A,$26,$F2,$18,$FF,$3C,$E5,$33,$32,$18,$38,$39,$36,$86,$01,$BD
  DC.B $B0,$47,$32,$39,$36,$37,$5A,$4A,$27,$02,$CB,$40,$17,$8A,$80         *c5
  DC.B $B1,$40,$BD,$B0,$47,$86,$0E,$BD,$B0,$47,$86,$01,$B7,$3C,$E8,$33,$32
  DC.B $39,$37,$36,$F6,$3C,$C8,$C1,$00,$26,$05,$BD,$A8,$76,$20,$1C,$30,$F6
  DC.B $14,$20,$17,$C4,$03,$84,$FC,$6D,$00,$27,$06,$5D,$27,$0C,$5A,$20,$05
  DC.B $C1,$03,$27,$05,$5C,$1B,$B7,$14,$20,$33,$32,$39,$36,$86,$0C         *c6
  DC.B $B1,$80,$BD,$B0,$47,$7F,$3C,$E8,$32,$39,$3C,$18,$3C,$37,$36,$7D,$3C
  DC.B $E8,$26,$45,$18,$8F,$5F,$86,$02,$BD,$B0,$47,$18,$6D,$00,$27,$09,$7D
  DC.B $3C,$E4,$26,$04,$86,$20,$20,$09,$A6,$00,$81,$20,$27,$03,$BD,$B1,$DD
  DC.B $BD,$B0,$53,$5C,$C1,$14,$26,$10,$37,$36,$86,$C0,$BD,$B0,$47         *c7
  DC.B $B1,$C0,$C6,$3D,$3A,$18,$3A,$32,$33,$20,$D1,$08,$18,$08,$C1,$28,$26
  DC.B $CA,$B6,$3C,$E4,$43,$B7,$3C,$E4,$32,$33,$18,$38,$38,$39,$3C,$37,$81
  DC.B $1F,$22,$19,$81,$18,$25,$15,$80,$18,$16,$58,$CE,$B0,$37,$3A,$7D,$3C
  DC.B $E4,$27,$04,$A6,$01,$20,$16,$A6,$00,$20,$12,$C6,$08,$CE,$B0         *c8
  DC.B $B2,$00,$27,$A1,$00,$27,$07,$08,$08,$5A,$26,$F7,$20,$02,$A6,$01,$33
  DC.B $38,$39,$3C,$37,$36,$3C,$86,$02,$BD,$B0,$47,$C6,$14,$A6,$00,$81,$20
  DC.B $27,$03,$BD,$B1,$DD,$BD,$B0,$53,$08,$5A,$26,$F0,$38,$8F,$C3,$00,$50
  DC.B $8F,$86,$C0,$BD,$B0,$47,$C6,$14,$A6,$00,$81,$20,$27,$03,$BD         *c9
  DC.B $B2,$40,$B1,$DD,$BD,$B0,$53,$08,$5A,$26,$F0,$32,$33,$38,$39,$3C,$36
  DC.B $A6,$00,$27,$06,$08,$BD,$B0,$53,$20,$F6,$32,$38,$39,$36,$37,$C6,$05
  DC.B $86,$FF,$BD,$CA,$71,$5A,$26,$F8,$33,$32,$39,$B2,$75,$B2,$81,$B2,$8D
  DC.B $B2,$99,$B2,$A5,$3C,$FD,$3E,$3D,$3F,$7D,$3F,$7E,$3F,$AB,$3F         *ca
  DC.B $B2,$80,$B1,$3F,$B7,$40,$F7,$42,$37,$42,$38,$42,$65,$42,$6B,$42,$71
  DC.B $43,$B1,$44,$F1,$44,$F2,$45,$1F,$45,$25,$45,$2B,$46,$6B,$47,$AB,$47
  DC.B $AC,$47,$D9,$47,$DF,$47,$E5,$49,$25,$4A,$65,$4A,$66,$4A,$93,$4A,$99
  DC.B $A6,$05,$C6,$08,$3A,$FF,$3C,$E9,$16,$3A,$FF,$3C,$EB,$7F,$3C         *cb
  DC.B $B2,$C0,$F0,$FE,$3C,$E9,$BC,$3C,$EB,$24,$3B,$BD,$B9,$53,$B7,$51,$43
  DC.B $4D,$27,$2C,$81,$34,$22,$07,$18,$CE,$B3,$3C,$4A,$20,$0C,$80,$C0,$2B
  DC.B $1D,$81,$12,$22,$19,$18,$CE,$B3,$A4,$48,$16,$18,$3A,$18,$EE,$00,$18
  DC.B $3C,$18,$AD,$00,$18,$38,$7D,$3C,$F1,$26,$2A,$20,$C0,$BD,$BA         *cc
  DC.B $B3,$00,$1F,$7F,$3C,$F1,$7D,$3C,$FA,$27,$1D,$7F,$3C,$FA,$7F,$3C,$FC
  DC.B $7D,$3C,$FB,$26,$12,$36,$37,$C6,$00,$86,$08,$18,$CE,$B3,$27,$BD,$86
  DC.B $5D,$33,$32,$7C,$3C,$FB,$39,$7F,$3C,$FB,$BD,$BC,$F9,$18,$FE,$3C,$F4
  DC.B $18,$EE,$08,$FE,$3C,$D8,$EE,$0E,$AD,$00,$39,$B3,$CB,$B3,$DC         *cd
  DC.B $B3,$40,$B3,$D7,$B3,$F4,$B4,$09,$B4,$0E,$B4,$13,$B4,$18,$B4,$76,$B4
  DC.B $C4,$B5,$32,$B5,$37,$B2,$FE,$B5,$5B,$B5,$5F,$B5,$63,$B5,$91,$B5,$F4
  DC.B $B6,$3F,$B6,$F0,$B6,$FF,$B7,$32,$B2,$FE,$B7,$A3,$D8,$B5,$D9,$5F,$B2
  DC.B $FE,$B2,$FE,$B2,$FE,$B2,$FE,$B2,$FE,$B2,$FE,$B2,$FE,$B7,$AD         *ce
  DC.B $B3,$80,$B2,$FE,$C0,$06,$B2,$FE,$C1,$E5,$C0,$85,$B7,$D0,$B2,$FE,$B7
  DC.B $D7,$B7,$FA,$B8,$0A,$B8,$3A,$B8,$4A,$B2,$FE,$B8,$5D,$B2,$FE,$B2,$FE
  DC.B $C0,$4C,$C2,$23,$B8,$9A,$B2,$FE,$B2,$FE,$B8,$A3,$B2,$FE,$B8,$E0,$B2
  DC.B $FE,$B9,$4A,$B2,$FE,$B2,$FE,$B2,$FE,$B2,$FE,$B2,$FE,$B2,$FE         *cf
  DC.B $B3,$C0,$B2,$FE,$B9,$50,$B9,$5F,$B2,$FE,$BF,$8B,$39,$7A,$3C,$FA,$BD
  DC.B $BA,$71,$BD,$B9,$53,$8D,$0E,$39,$86,$08,$B7,$3C,$F0,$7A,$3C,$FA,$BD
  DC.B $BA,$71,$86,$01,$37,$C4,$07,$36,$33,$BD,$BA,$9D,$33,$5D,$2B,$03,$BD
  DC.B $BB,$22,$39,$7A,$3C,$FA,$BD,$B9,$53,$16,$BD,$BB,$32,$BD,$B9         *d0
  DC.B $B4,$00,$53,$A7,$00,$BD,$B9,$53,$A7,$01,$39,$CE,$BA,$33,$20,$0D,$CE
  DC.B $BA,$3D,$20,$08,$CE,$BA,$31,$20,$03,$CE,$BA,$37,$7A,$3C,$FA,$3C,$BD
  DC.B $BA,$71,$BD,$B9,$53,$38,$3C,$36,$8C,$BA,$33,$27,$05,$8C,$BA,$3D,$26
  DC.B $03,$BD,$B9,$53,$C4,$07,$33,$38,$27,$25,$37,$3C,$3C,$37,$30         *d1
  DC.B $B4,$40,$36,$37,$CC,$B4,$5B,$ED,$03,$33,$32,$CE,$B4,$54,$3C,$30,$EE
  DC.B $03,$3C,$7E,$BB,$4E,$A7,$00,$33,$4F,$7E,$BB,$47,$BD,$BB,$47,$32,$39
  DC.B $3C,$37,$C6,$05,$37,$BD,$BA,$8C,$30,$E6,$01,$EE,$02,$8D,$CC,$33,$5A
  DC.B $26,$F1,$33,$38,$39,$7A,$3C,$FA,$BD,$BA,$71,$F7,$51,$4B,$BD         *d2
  DC.B $B4,$80,$B9,$53,$16,$BD,$B9,$53,$37,$36,$F7,$3C,$EE,$86,$01,$B7,$3C
  DC.B $EF,$F6,$51,$4B,$86,$28,$CE,$B4,$D7,$BD,$BA,$FB,$32,$33,$5C,$4A,$26
  DC.B $E5,$F6,$51,$4B,$C5,$80,$26,$1B,$C5,$07,$26,$14,$17,$C6,$05,$1B,$16
  DC.B $37,$BD,$BB,$22,$33,$17,$84,$38,$C4,$07,$5A,$26,$F1,$20,$03         *d3
  DC.B $B4,$C0,$BD,$BB,$22,$39,$7A,$3C,$FA,$BD,$BA,$71,$BD,$B9,$53,$37,$CE
  DC.B $B4,$D7,$BD,$BA,$FB,$7E,$B3,$EC,$BD,$BB,$4E,$36,$C6,$20,$BD,$BB,$83
  DC.B $BD,$BB,$47,$32,$6F,$00,$08,$4A,$26,$FA,$39,$34,$34,$34,$34,$3C,$30
  DC.B $A7,$04,$B6,$3C,$EE,$16,$80,$03,$A7,$05,$2B,$02,$8D,$24,$EC         *d4
  DC.B $B5,$00,$00,$83,$00,$28,$ED,$02,$38,$08,$3C,$09,$8F,$30,$6D,$05,$27
  DC.B $02,$2B,$07,$EC,$02,$8F,$08,$8F,$ED,$02,$6A,$04,$26,$E9,$38,$31,$31
  DC.B $31,$31,$39,$3C,$FE,$3C,$F2,$EE,$08,$C1,$03,$2F,$01,$08,$6F,$00,$38
  DC.B $39,$86,$08,$B7,$3C,$F0,$7A,$3C,$FA,$BD,$BA,$71,$BD,$B9,$53         *d5
  DC.B $B5,$40,$CE,$B5,$46,$7E,$BA,$FB,$BD,$BB,$47,$F6,$3C,$F0,$26,$0A,$C6
  DC.B $F7,$36,$3C,$BD,$BB,$9B,$38,$32,$5F,$7E,$BB,$8D,$86,$C0,$20,$05,$86
  DC.B $80,$20,$01,$4F,$7A,$3C,$FA,$36,$BD,$BA,$71,$32,$C5,$07,$27,$0B,$4D
  DC.B $27,$0C,$54,$54,$54,$C4,$03,$1B,$20,$04,$8D,$07,$20,$04,$EE         *d6
  DC.B $B5,$80,$04,$A7,$00,$39,$C6,$05,$BD,$BA,$8C,$EE,$04,$A7,$00,$5A,$26
  DC.B $F6,$39,$7A,$3C,$FA,$BD,$B9,$53,$16,$84,$07,$54,$54,$54,$8F,$BD,$B9
  DC.B $53,$16,$BD,$B9,$53,$8F,$C4,$07,$27,$49,$36,$3C,$BD,$BA,$8C,$33,$32
  DC.B $37,$C6,$01,$FD,$3C,$EE,$BD,$BB,$4E,$32,$B7,$3C,$EE,$33,$C4         *d7
  DC.B $B5,$C0,$07,$27,$27,$3C,$BD,$BA,$8C,$BD,$BB,$4E,$32,$33,$37,$36,$3C
  DC.B $37,$36,$C6,$28,$BD,$BB,$A9,$38,$8F,$C3,$01,$40,$38,$3C,$8F,$C3,$01
  DC.B $40,$37,$36,$C6,$28,$BD,$BB,$A9,$38,$39,$C6,$05,$37,$8D,$D4,$33,$5A
  DC.B $26,$F9,$39,$7A,$3C,$FA,$BD,$B9,$53,$16,$C5,$07,$27,$2D,$37         *d8
  DC.B $B6,$00,$BD,$BA,$8C,$C6,$01,$86,$08,$36,$F7,$3C,$EE,$86,$01,$B7,$3C
  DC.B $EF,$86,$28,$BD,$B4,$D7,$32,$5C,$4A,$26,$ED,$33,$CE,$01,$01,$FF,$3C
  DC.B $EE,$BD,$BB,$22,$FE,$3C,$D8,$EE,$0C,$AD,$00,$39,$37,$18,$30,$C6,$05
  DC.B $18,$EB,$00,$37,$8D,$C8,$33,$C4,$07,$5A,$26,$F4,$33,$39,$BD         *d9
  DC.B $B6,$40,$BA,$71,$C5,$07,$27,$35,$EE,$06,$E7,$00,$C4,$07,$37,$17,$BD
  DC.B $BA,$64,$BA,$3C,$F8,$B7,$3C,$F8,$FC,$3C,$EE,$ED,$01,$BD,$B9,$53,$08
  DC.B $08,$08,$A7,$00,$08,$BD,$B9,$53,$33,$8D,$11,$BD,$B9,$53,$A7,$00,$08
  DC.B $16,$BD,$B9,$53,$A7,$00,$08,$5A,$26,$F7,$39,$3C,$37,$C6,$02         *da
  DC.B $B6,$80,$3D,$17,$33,$5A,$CB,$1C,$18,$CE,$B6,$8F,$BD,$86,$5D,$38,$39
  DC.B $36,$3C,$A6,$03,$80,$1C,$4C,$16,$BD,$BA,$64,$B5,$3C,$F8,$27,$4E,$43
  DC.B $B4,$3C,$F8,$B7,$3C,$F8,$BD,$BA,$8C,$EE,$06,$EC,$01,$FD,$3C,$EE,$A6
  DC.B $04,$C6,$05,$3A,$7F,$3C,$F0,$4D,$27,$10,$4A,$36,$A6,$00,$08         *db
  DC.B $B6,$C0,$3C,$CE,$BA,$E1,$BD,$BA,$BC,$38,$32,$20,$ED,$FE,$3C,$F2,$EE
  DC.B $06,$E6,$03,$E0,$04,$23,$06,$CE,$BA,$E1,$BD,$BA,$B1,$BD,$BC,$F9,$18
  DC.B $FE,$3C,$F4,$18,$EE,$08,$FE,$3C,$D8,$EE,$0E,$AD,$00,$38,$32,$39,$7A
  DC.B $3C,$FA,$BD,$B9,$53,$B7,$3C,$F9,$86,$01,$BD,$BD,$4F,$39,$BD         *dc
  DC.B $B7,$00,$B9,$53,$81,$80,$25,$03,$7E,$B3,$CA,$F6,$50,$9F,$CA,$20,$F7
  DC.B $50,$9F,$BD,$BE,$44,$3C,$86,$0C,$C6,$20,$BD,$BB,$83,$38,$BD,$B9,$53
  DC.B $C6,$0C,$36,$BD,$B9,$53,$5D,$27,$04,$A7,$00,$08,$5A,$32,$4A,$26,$F1
  DC.B $39,$7A,$3C,$FA,$BD,$B9,$53,$16,$44,$44,$44,$37,$BD,$BE,$39         *dd
  DC.B $B7,$40,$C6,$80,$E7,$00,$33,$BD,$B7,$85,$36,$37,$86,$20,$BD,$BA,$E1
  DC.B $33,$32,$81,$03,$27,$04,$81,$06,$26,$16,$36,$B6,$3C,$EF,$36,$86,$27
  DC.B $B7,$3C,$EF,$37,$86,$35,$BD,$BA,$E1,$33,$32,$B7,$3C,$EF,$32,$7C,$3C
  DC.B $EF,$BD,$BA,$8C,$8F,$BD,$B9,$53,$C6,$0C,$8F,$C4,$07,$8F,$7E         *de
  DC.B $B7,$80,$BA,$9D,$44,$44,$44,$37,$36,$C6,$03,$81,$03,$23,$03,$80,$03
  DC.B $5C,$F7,$3C,$EE,$4A,$36,$48,$48,$16,$48,$1B,$33,$1B,$4C,$B7,$3C,$EF
  DC.B $32,$33,$39,$7A,$3C,$FA,$BD,$BA,$71,$FF,$3C,$F4,$39,$BD,$B9,$53,$36
  DC.B $16,$BD,$BB,$32,$33,$18,$CE,$51,$45,$86,$04,$18,$A7,$01,$18         *df
  DC.B $B7,$C0,$E7,$02,$EE,$00,$CD,$EF,$03,$86,$04,$18,$A7,$00,$BD,$BE,$E6
  DC.B $39,$BD,$B9,$53,$BD,$CB,$FA,$39,$7A,$3C,$FA,$BD,$BA,$71,$B6,$3C,$EF
  DC.B $4A,$27,$03,$B7,$3C,$EF,$37,$CE,$BA,$F7,$C4,$07,$27,$03,$CE,$BA,$E1
  DC.B $86,$20,$AD,$00,$33,$BD,$B3,$ED,$39,$BD,$B9,$53,$84,$07,$BD         *e0
  DC.B $B8,$00,$BA,$64,$43,$B4,$3C,$F8,$B7,$3C,$F8,$39,$7A,$3C,$FA,$BD,$B9
  DC.B $53,$16,$BD,$BA,$8C,$37,$CC,$01,$01,$FD,$3C,$EE,$86,$28,$BD,$B4,$D7
  DC.B $CC,$02,$01,$FD,$3C,$EE,$86,$28,$BD,$B4,$D7,$32,$36,$8D,$CE,$CC,$01
  DC.B $01,$FD,$3C,$EE,$33,$BD,$BB,$22,$39,$7A,$3C,$FA,$BD,$B9,$53         *e1
  DC.B $B8,$40,$B7,$3C,$F9,$BD,$B9,$53,$BD,$BD,$4F,$39,$BD,$B9,$53,$BD,$B9
  DC.B $53,$BD,$B9,$53,$BD,$B9,$53,$BD,$B9,$53,$BD,$B9,$53,$39,$BD,$B9,$53
  DC.B $B1,$51,$41,$25,$31,$B1,$51,$42,$22,$2C,$16,$BD,$B9,$53,$81,$08,$26
  DC.B $24,$BD,$B9,$53,$81,$08,$26,$1D,$CE,$50,$A4,$F0,$51,$41,$3D         *e2
  DC.B $B8,$80,$3A,$C6,$08,$BD,$B9,$53,$A7,$00,$08,$5A,$26,$F7,$B6,$51,$3C
  DC.B $8A,$20,$B7,$51,$3C,$20,$03,$BD,$BA,$1F,$39,$86,$20,$B7,$22,$7E,$BD
  DC.B $BF,$2F,$39,$37,$36,$3C,$BD,$B9,$53,$BD,$B9,$53,$BD,$B9,$53,$36,$BD
  DC.B $B9,$53,$16,$32,$8F,$81,$10,$26,$07,$17,$BD,$D7,$ED,$16,$20         *e3
  DC.B $B8,$C0,$02,$E6,$00,$86,$00,$18,$CE,$51,$45,$18,$A7,$01,$18,$E7,$02
  DC.B $A6,$01,$18,$A7,$03,$86,$03,$18,$A7,$00,$BD,$BE,$E6,$38,$32,$33,$39
  DC.B $37,$36,$3C,$18,$3C,$CE,$51,$45,$86,$C6,$A7,$01,$8D,$65,$A7,$02,$81
  DC.B $0B,$26,$07,$BD,$CD,$8E,$E7,$03,$20,$3A,$81,$08,$26,$07,$B6         *e4
  DC.B $B9,$00,$80,$0D,$A7,$03,$20,$2F,$81,$0D,$26,$27,$3C,$18,$CE,$E8,$04
  DC.B $CE,$B9,$42,$6D,$00,$27,$0C,$18,$A6,$00,$A1,$00,$26,$0D,$08,$18,$08
  DC.B $20,$F0,$38,$18,$A6,$03,$A7,$03,$20,$0B,$38,$86,$00,$A7,$03,$20,$04
  DC.B $86,$FF,$A7,$03,$86,$03,$A7,$00,$BD,$BE,$E6,$18,$38,$38,$32         *e5
  DC.B $B9,$40,$33,$39,$42,$4F,$4F,$54,$20,$34,$2E,$00,$0F,$C6,$18,$7E,$80
  DC.B $36,$8D,$01,$39,$3C,$FE,$3C,$E9,$A6,$00,$08,$FF,$3C,$E9,$38,$39,$8D
  DC.B $F2,$36,$8D,$EF,$4A,$16,$CE,$B9,$71,$58,$3A,$32,$EE,$00,$AD,$00,$39
  DC.B $B9,$7D,$B9,$7E,$B9,$A4,$B9,$C9,$B9,$CA,$B9,$D4,$39,$8D,$D3         *e6
  DC.B $B9,$80,$36,$8D,$D0,$36,$8D,$CD,$16,$32,$8F,$33,$C0,$02,$81,$10,$26
  DC.B $0B,$8D,$C1,$36,$8F,$17,$33,$BD,$D6,$C4,$20,$08,$8D,$B6,$A7,$00,$08
  DC.B $5A,$26,$F8,$39,$16,$8D,$AC,$C1,$02,$26,$05,$BD,$CC,$75,$20,$0C,$C1
  DC.B $03,$26,$09,$8D,$9D,$16,$8D,$9A,$BD,$D5,$8A,$39,$8D,$94,$36         *e7
  DC.B $B9,$C0,$8D,$91,$16,$32,$18,$8F,$18,$6E,$00,$39,$81,$01,$26,$05,$86
  DC.B $01,$B7,$51,$44,$39,$3C,$18,$3C,$4D,$26,$2B,$FE,$3C,$D8,$EE,$0C,$AD
  DC.B $00,$86,$01,$97,$80,$C6,$18,$CE,$E8,$04,$18,$CE,$BA,$19,$18,$6D,$00
  DC.B $27,$0F,$A6,$00,$18,$A1,$00,$26,$05,$08,$18,$08,$20,$EF,$7E         *e8
  DC.B $BA,$00,$E0,$02,$7E,$E8,$02,$81,$02,$26,$05,$BD,$CC,$F0,$20,$07,$81
  DC.B $01,$26,$03,$7F,$51,$44,$18,$38,$38,$39,$42,$4F,$4F,$54,$20,$00,$37
  DC.B $36,$F6,$51,$43,$86,$C2,$BD,$BE,$D4,$86,$01,$B7,$3C,$F1,$32,$33,$39
  DC.B $A6,$00,$5D,$0D,$20,$08,$3C,$3A,$09,$A6,$00,$38,$5D,$0C,$27         *e9
  DC.B $BA,$40,$17,$5A,$36,$3C,$17,$25,$02,$4F,$09,$08,$36,$3C,$09,$25,$02
  DC.B $08,$08,$BD,$BB,$A9,$33,$38,$32,$3A,$39,$BD,$B9,$53,$16,$BD,$B9,$53
  DC.B $37,$16,$32,$39,$37,$C6,$01,$4D,$27,$04,$58,$4A,$20,$FA,$17,$33,$39
  DC.B $BD,$B9,$53,$16,$85,$40,$26,$0E,$BD,$B9,$53,$B7,$3C,$EE,$BD         *ea
  DC.B $BA,$80,$B9,$53,$B7,$3C,$EF,$20,$05,$37,$BD,$BB,$2A,$33,$37,$C4,$07
  DC.B $27,$0A,$58,$CE,$B2,$69,$3A,$EE,$00,$FF,$3C,$F2,$33,$39,$27,$05,$CE
  DC.B $BA,$E1,$20,$03,$CE,$BA,$F7,$36,$BD,$B9,$53,$8D,$0B,$32,$4A,$26,$F6
  DC.B $86,$20,$8D,$03,$26,$FA,$39,$5D,$27,$13,$5A,$81,$C0,$27,$0F         *eb
  DC.B $BA,$C0,$81,$C1,$27,$14,$22,$08,$37,$3C,$AD,$00,$8D,$45,$38,$33,$39
  DC.B $B6,$3C,$F0,$8A,$08,$B7,$3C,$F0,$39,$B6,$3C,$F0,$84,$F7,$B7,$3C,$F0
  DC.B $39,$16,$8D,$6A,$E1,$00,$07,$36,$E7,$00,$8D,$5B,$E6,$00,$C4,$F7,$FA
  DC.B $3C,$F0,$32,$E7,$00,$39,$CE,$BA,$E1,$5F,$C4,$07,$26,$10,$C6         *ec
  DC.B $BB,$00,$05,$3C,$8D,$88,$38,$3C,$37,$AD,$00,$33,$38,$5A,$26,$F3,$39
  DC.B $6E,$00,$FC,$3C,$EE,$5C,$C1,$28,$23,$05,$84,$07,$4C,$C6,$01,$FD,$3C
  DC.B $EE,$39,$8D,$0E,$FC,$3C,$EE,$ED,$00,$39,$8D,$06,$EC,$00,$FD,$3C,$EE
  DC.B $39,$BD,$BA,$8C,$54,$54,$54,$C4,$03,$5A,$58,$EE,$0A,$3A,$39         *ed
  DC.B $BB,$40,$FE,$3C,$F4,$EE,$02,$20,$0C,$FE,$3C,$F2,$EE,$02,$20,$05,$FE
  DC.B $3C,$F2,$EE,$00,$37,$36,$18,$3C,$4F,$F6,$3C,$EE,$5A,$05,$05,$05,$05
  DC.B $37,$36,$18,$30,$8F,$18,$E3,$00,$8F,$31,$31,$58,$58,$37,$36,$18,$30
  DC.B $8F,$18,$E3,$00,$8F,$31,$31,$F6,$3C,$EF,$5A,$3A,$18,$38,$32         *ee
  DC.B $BB,$80,$33,$39,$5F,$4D,$27,$06,$E7,$00,$08,$4A,$26,$FA,$39,$4D,$27
  DC.B $0A,$37,$EA,$00,$E7,$00,$08,$33,$4A,$26,$F6,$39,$4D,$27,$0A,$37,$E4
  DC.B $00,$E7,$00,$08,$33,$4A,$26,$F6,$39,$5D,$27,$31,$3C,$37,$8F,$30,$A3
  DC.B $05,$33,$38,$27,$27,$25,$12,$3A,$3C,$30,$EE,$04,$5A,$3A,$A6         *ef
  DC.B $BB,$C0,$00,$38,$09,$A7,$00,$5D,$26,$F1,$20,$13,$17,$5F,$36,$3C,$30
  DC.B $EE,$05,$3A,$A6,$00,$38,$A7,$00,$08,$5C,$32,$4A,$26,$EF,$38,$31,$31
  DC.B $6E,$00,$39,$37,$36,$B6,$50,$9F,$85,$20,$27,$0E,$84,$97,$B7,$50,$9F
  DC.B $CE,$4A,$9F,$FF,$50,$A2,$7F,$50,$A0,$85,$08,$26,$54,$C6,$30         *f0
  DC.B $BC,$00,$FE,$50,$A2,$B6,$50,$A0,$AB,$00,$08,$5A,$26,$FA,$B7,$50,$A0
  DC.B $FF,$50,$A2,$8C,$50,$9F,$26,$3B,$F6,$50,$9F,$C5,$40,$26,$07,$B7,$50
  DC.B $A1,$CA,$40,$20,$21,$B1,$50,$A1,$26,$04,$C4,$EF,$20,$18,$CE,$51,$45
  DC.B $86,$C6,$A7,$01,$86,$09,$A7,$02,$86,$02,$A7,$03,$86,$03,$A7         *f1
  DC.B $BC,$40,$00,$BD,$BE,$E6,$CA,$18,$F7,$50,$9F,$CE,$4A,$9F,$FF,$50,$A2
  DC.B $7F,$50,$A0,$32,$33,$39,$37,$36,$B6,$51,$3C,$85,$20,$27,$10,$84,$D7
  DC.B $84,$BF,$B7,$51,$3C,$CE,$50,$A4,$FF,$51,$3F,$7F,$51,$3D,$85,$08,$26
  DC.B $54,$C6,$08,$FE,$51,$3F,$B6,$51,$3D,$AB,$00,$08,$5A,$26,$FA         *f2
  DC.B $BC,$80,$B7,$51,$3D,$FF,$51,$3F,$8C,$51,$3C,$26,$3B,$F6,$51,$3C,$C5
  DC.B $40,$26,$07,$B7,$51,$3E,$CA,$40,$20,$21,$B1,$51,$3E,$26,$04,$C4,$EF
  DC.B $20,$18,$CE,$51,$45,$86,$C6,$A7,$01,$86,$0C,$A7,$02,$86,$02,$A7,$03
  DC.B $86,$03,$A7,$00,$BD,$BE,$E6,$CA,$18,$F7,$51,$3C,$CE,$50,$A4         *f3
  DC.B $BC,$C0,$FF,$51,$3F,$7F,$51,$3D,$32,$33,$39,$18,$3C,$3C,$36,$37,$36
  DC.B $37,$C6,$26,$86,$1E,$18,$CE,$BC,$C9,$BD,$86,$5D,$33,$32,$7D,$3C,$FC
  DC.B $26,$11,$FE,$3C,$F4,$EC,$02,$EE,$00,$18,$FE,$3C,$D8,$18,$EE,$1A,$18
  DC.B $AD,$00,$33,$32,$38,$18,$38,$39,$3C,$18,$3C,$FE,$3C,$F4,$EC         *f4
  DC.B $BD,$00,$02,$EE,$00,$18,$FE,$3C,$D8,$18,$EE,$16,$18,$AD,$00,$FE,$3C
  DC.B $F4,$3C,$18,$38,$EE,$04,$E6,$00,$C5,$80,$26,$0C,$18,$FE,$3C,$D8,$18
  DC.B $EE,$0A,$18,$AD,$00,$20,$24,$17,$C4,$03,$5A,$58,$18,$EE,$0A,$18,$3A
  DC.B $85,$40,$26,$0C,$18,$EC,$00,$FE,$3C,$D8,$EE,$10,$AD,$00,$20         *f5
  DC.B $BD,$40,$0A,$18,$EC,$00,$FE,$3C,$D8,$EE,$16,$AD,$00,$18,$38,$38,$39
  DC.B $F6,$3C,$F9,$54,$54,$54,$37,$36,$BD,$B9,$53,$16,$32,$C1,$FF,$27,$48
  DC.B $C1,$FE,$26,$13,$F6,$3C,$F9,$C5,$07,$26,$08,$18,$CE,$BD,$B7,$8D,$3D
  DC.B $20,$35,$8D,$42,$20,$31,$C1,$FD,$26,$14,$F6,$3C,$F9,$C5,$07         *f6
  DC.B $BD,$80,$26,$08,$18,$CE,$BD,$DD,$8D,$26,$20,$1E,$BD,$BD,$DD,$20,$19
  DC.B $C1,$80,$24,$15,$36,$17,$8F,$32,$F6,$3C,$F9,$C5,$07,$26,$08,$18,$CE
  DC.B $BD,$C4,$8D,$0A,$20,$02,$8D,$1C,$4C,$33,$5A,$26,$A8,$39,$C6,$05,$18
  DC.B $AD,$00,$5A,$26,$FA,$39,$37,$3C,$8D,$7E,$C6,$80,$E7,$00,$8D         *f7
  DC.B $BD,$C0,$2B,$38,$33,$39,$37,$18,$3C,$3C,$8D,$6F,$C6,$80,$18,$30,$18
  DC.B $EA,$00,$E7,$00,$18,$E6,$00,$8D,$36,$38,$18,$38,$33,$39,$37,$3C,$8D
  DC.B $58,$E6,$00,$C4,$7F,$E7,$00,$8D,$03,$38,$33,$39,$37,$36,$36,$BD,$B7
  DC.B $85,$C6,$0D,$86,$20,$37,$36,$BD,$BA,$E1,$32,$33,$7C,$3C,$EF         *f8
  DC.B $BE,$00,$5A,$26,$F3,$33,$C1,$03,$26,$03,$BD,$BA,$E1,$32,$33,$39,$37
  DC.B $36,$3C,$BD,$B7,$85,$36,$37,$86,$20,$BD,$BA,$E1,$33,$32,$7C,$3C,$EF
  DC.B $17,$8D,$21,$C6,$0C,$A6,$00,$08,$37,$3C,$BD,$BA,$E1,$38,$33,$7C,$3C
  DC.B $EF,$5A,$26,$F0,$38,$32,$33,$39,$37,$BD,$BA,$8C,$EE,$08,$16         *f9
  DC.B $BE,$40,$5A,$3A,$33,$39,$37,$36,$C6,$0C,$3D,$C3,$4A,$9F,$8F,$32,$33
  DC.B $39,$BD,$B7,$85,$7E,$BB,$4E,$3C,$37,$36,$CE,$B2,$6B,$EE,$00,$FF,$3C
  DC.B $F4,$86,$01,$B7,$3C,$FC,$86,$01,$C6,$05,$BD,$BA,$8C,$EE,$0A,$A7,$00
  DC.B $08,$A7,$00,$08,$A7,$00,$08,$A7,$00,$08,$A7,$00,$08,$A7,$00         *fa
  DC.B $BE,$80,$08,$5A,$26,$E6,$CE,$3C,$FD,$8D,$3D,$CE,$3F,$B7,$8D,$38,$CE
  DC.B $42,$71,$8D,$33,$CE,$45,$2B,$8D,$2E,$CE,$47,$E5,$8D,$29,$86,$18,$B7
  DC.B $51,$3C,$B7,$50,$9F,$B6,$3C,$C8,$81,$00,$27,$0C,$86,$07,$B7,$51,$42
  DC.B $86,$00,$B7,$51,$41,$20,$0A,$86,$B4,$B7,$51,$42,$86,$A2,$B7         *fb
  DC.B $BE,$C0,$51,$41,$32,$33,$38,$39,$18,$CE,$01,$3F,$86,$20,$A7,$00,$08
  DC.B $18,$09,$26,$F9,$39,$18,$CE,$51,$45,$18,$A7,$01,$18,$E7,$02,$86,$02
  DC.B $18,$A7,$00,$8D,$01,$39,$37,$36,$3C,$BD,$84,$31,$27,$2D,$A6,$04,$8A
  DC.B $10,$A7,$04,$86,$03,$C6,$02,$ED,$02,$18,$CE,$51,$45,$18,$A6         *fc
  DC.B $BF,$00,$00,$A7,$05,$3C,$18,$E6,$01,$E7,$08,$08,$18,$08,$4A,$26,$F5
  DC.B $38,$18,$3C,$18,$CE,$22,$88,$BD,$83,$4F,$18,$38,$38,$32,$33,$39,$3C
  DC.B $37,$FE,$3C,$F4,$EE,$08,$16,$3A,$E6,$00,$C5,$80,$33,$38,$39,$3C,$36
  DC.B $37,$BD,$84,$31,$27,$3E,$86,$C1,$F6,$3C,$C8,$C1,$00,$27,$08         *fd
  DC.B $BF,$40,$C1,$02,$27,$08,$C6,$99,$20,$06,$C6,$9B,$20,$02,$C6,$9A,$ED
  DC.B $08,$B6,$22,$7E,$C6,$00,$ED,$0A,$86,$04,$A7,$05,$A6,$04,$8A,$10,$A7
  DC.B $04,$86,$03,$C6,$02,$ED,$02,$18,$3C,$18,$CE,$22,$88,$BD,$83,$4F,$18
  DC.B $38,$7F,$22,$7E,$33,$32,$38,$39,$36,$BD,$BF,$2F,$BD,$D5,$F7         *fe
  DC.B $BF,$80,$BD,$D6,$0C,$BD,$87,$B9,$BD,$DA,$F6,$32,$39,$3C,$18,$3C,$37
  DC.B $CE,$3C,$E9,$18,$FE,$3C,$EB,$BD,$A1,$91,$5D,$26,$03,$BD,$BA,$1F,$33
  DC.B $18,$38,$38,$39,$CE,$51,$4C,$6F,$00,$08,$8C,$51,$64,$26,$F8,$86,$30
  DC.B $B7,$51,$5F,$86,$40,$B7,$51,$5D,$86,$06,$B7,$51,$54,$B7,$51         *ff
  DC.B $BF,$C0,$55,$B7,$51,$52,$86,$03,$B7,$51,$53,$B6,$14,$20,$8A,$C0,$B7
  DC.B $14,$20,$B6,$14,$30,$CA,$40,$B7,$14,$30,$18,$CE,$E8,$00,$18,$A6,$09
  DC.B $81,$34,$25,$17,$22,$1A,$18,$A6,$0B,$81,$30,$27,$0E,$18,$A6,$0C,$81
  DC.B $20,$26,$0C,$18,$A6,$0B,$81,$32,$22,$05,$7F,$51,$63,$20,$05         *100
  DC.B $C0,$00,$86,$01,$B7,$51,$63,$39,$37,$36,$3C,$BD,$B9,$53,$85,$80,$27
  DC.B $05,$BD,$C0,$2E,$20,$15,$84,$77,$16,$58,$58,$58,$58,$44,$44,$44,$44
  DC.B $36,$30,$EA,$00,$86,$14,$BD,$D6,$C4,$32,$38,$32,$33,$39,$37,$36,$3C
  DC.B $84,$77,$16,$58,$58,$58,$58,$44,$44,$44,$44,$36,$30,$EA,$00         *101
  DC.B $C0,$40,$CA,$80,$86,$00,$BD,$D6,$F9,$32,$38,$32,$33,$39,$BD,$B9,$53
  DC.B $16,$C4,$0E,$C1,$00,$26,$05,$BD,$C5,$60,$20,$F1,$C1,$02,$26,$05,$BD
  DC.B $C5,$BC,$20,$E8,$C1,$04,$26,$05,$BD,$C6,$2D,$20,$DF,$C1,$06,$26,$05
  DC.B $BD,$C6,$58,$20,$D6,$C1,$08,$26,$05,$BD,$C6,$8C,$20,$CD,$81         *102
  DC.B $C0,$80,$0D,$27,$01,$00,$39,$37,$36,$BD,$B9,$53,$16,$54,$54,$54,$54
  DC.B $F7,$51,$50,$84,$0F,$B7,$51,$52,$BD,$B9,$53,$16,$54,$54,$54,$54,$F7
  DC.B $51,$55,$84,$0F,$B7,$51,$54,$32,$33,$39,$37,$36,$7F,$51,$4C,$B6,$51
  DC.B $56,$85,$80,$26,$62,$85,$04,$27,$0C,$8A,$88,$84,$FB,$B7,$51         *103
  DC.B $C0,$C0,$56,$BD,$C4,$3E,$20,$52,$86,$3C,$BD,$D7,$ED,$84,$E0,$81,$40
  DC.B $26,$47,$86,$1C,$BD,$D7,$ED,$85,$01,$27,$02,$20,$17,$BD,$CD,$D3,$27
  DC.B $0B,$BD,$CA,$2E,$F6,$51,$54,$BD,$C9,$1A,$20,$19,$B6,$51,$5E,$85,$40
  DC.B $26,$05,$BD,$CA,$2E,$20,$05,$86,$01,$BD,$C8,$FC,$F6,$51,$4F         *104
  DC.B $C1,$00,$86,$3A,$BD,$D6,$C4,$36,$37,$C6,$25,$86,$20,$18,$CE,$CB,$06
  DC.B $BD,$86,$5D,$33,$32,$4F,$BD,$CA,$C3,$32,$33,$39,$3C,$37,$36,$B6,$51
  DC.B $56,$85,$08,$27,$0D,$F6,$51,$5F,$C5,$30,$27,$11,$4F,$BD,$CB,$71,$20
  DC.B $0E,$85,$80,$26,$07,$F6,$51,$5F,$C5,$30,$26,$03,$7E,$C1,$E1         *105
  DC.B $C1,$40,$C6,$01,$F7,$51,$4C,$F6,$51,$5E,$C5,$40,$27,$04,$4F,$BD,$CB
  DC.B $12,$86,$3A,$BD,$D7,$ED,$B7,$51,$4F,$BD,$CA,$49,$F6,$51,$4D,$CE,$CD
  DC.B $A3,$58,$3A,$E6,$00,$36,$86,$46,$BD,$D6,$C4,$32,$E6,$01,$36,$86,$48
  DC.B $BD,$D6,$C4,$32,$C6,$4D,$86,$20,$B5,$51,$5F,$27,$02,$C4,$F7         *106
  DC.B $C1,$80,$86,$10,$B5,$51,$5F,$27,$22,$C4,$FB,$37,$7D,$51,$62,$26,$0E
  DC.B $36,$37,$C6,$2E,$86,$42,$BD,$D6,$C4,$33,$32,$33,$20,$0C,$36,$37,$C6
  DC.B $2A,$86,$42,$BD,$D6,$C4,$33,$32,$33,$86,$3C,$BD,$D6,$C4,$86,$1C,$BD
  DC.B $D7,$ED,$85,$01,$27,$0D,$36,$37,$C6,$5C,$86,$3A,$BD,$D6,$C4         *107
  DC.B $C1,$C0,$33,$32,$20,$1D,$BD,$CD,$D3,$26,$0D,$F6,$51,$54,$58,$CB,$58
  DC.B $86,$3A,$BD,$D6,$C4,$20,$06,$F6,$51,$54,$BD,$C9,$48,$86,$01,$BD,$CA
  DC.B $C3,$32,$33,$38,$39,$36,$BD,$B9,$53,$B7,$51,$57,$BD,$B9,$53,$B7,$51
  DC.B $58,$7D,$51,$57,$27,$2A,$7D,$51,$58,$27,$25,$B6,$51,$56,$85         *108
  DC.B $C2,$00,$08,$27,$0C,$36,$4F,$BD,$CB,$71,$32,$7F,$51,$5B,$7F,$51,$59
  DC.B $B6,$51,$56,$8A,$80,$B7,$51,$56,$85,$02,$26,$06,$BD,$DB,$D7,$BD,$C4
  DC.B $3E,$32,$39,$36,$BD,$B9,$53,$B7,$51,$57,$BD,$B9,$53,$B7,$51,$58,$7D
  DC.B $51,$57,$27,$28,$7D,$51,$58,$27,$23,$7D,$51,$4C,$27,$0A,$B6         *109
  DC.B $C2,$40,$51,$56,$8A,$04,$B7,$51,$56,$20,$14,$B6,$51,$56,$84,$FB,$8A
  DC.B $88,$B7,$51,$56,$85,$02,$26,$06,$BD,$DB,$D7,$BD,$C4,$3E,$32,$39,$37
  DC.B $8D,$0B,$CE,$CD,$97,$58,$3A,$EE,$00,$AD,$00,$33,$39,$36,$C6,$05,$B6
  DC.B $51,$51,$27,$0A,$81,$02,$27,$24,$5A,$81,$01,$27,$1F,$00,$C0         *10a
  DC.B $C2,$80,$02,$86,$60,$B5,$51,$5E,$27,$02,$20,$13,$5A,$86,$20,$B5,$51
  DC.B $5D,$27,$02,$20,$09,$5A,$86,$80,$B5,$51,$56,$26,$01,$5F,$32,$39,$37
  DC.B $36,$4D,$27,$0E,$B6,$51,$50,$84,$0F,$81,$0F,$27,$1F,$7C,$51,$50,$20
  DC.B $0A,$B6,$51,$50,$84,$0F,$27,$13,$7A,$51,$50,$86,$40,$BA,$51         *10b
  DC.B $C2,$C0,$56,$B7,$51,$56,$F6,$51,$50,$86,$07,$BD,$BE,$D4,$32,$33,$39
  DC.B $37,$36,$F6,$51,$54,$8D,$5D,$F7,$51,$54,$86,$08,$BD,$BE,$D4,$32,$33
  DC.B $39,$37,$36,$F6,$51,$52,$8D,$4B,$F7,$51,$52,$86,$09,$BD,$BE,$D4,$32
  DC.B $33,$39,$37,$36,$F6,$51,$55,$8D,$39,$F7,$51,$55,$86,$0A,$BD         *10c
  DC.B $C3,$00,$BE,$D4,$32,$33,$39,$37,$36,$F6,$51,$53,$C4,$0F,$4D,$27,$12
  DC.B $7D,$51,$62,$26,$06,$C1,$08,$27,$18,$20,$04,$C1,$06,$27,$12,$5C,$20
  DC.B $04,$5D,$27,$0C,$5A,$F7,$51,$53,$58,$CB,$6A,$86,$3A,$BD,$D6,$C4,$32
  DC.B $33,$39,$36,$4D,$2B,$0B,$27,$02,$20,$10,$C4,$0F,$27,$0C,$5A         *10d
  DC.B $C3,$40,$20,$07,$C4,$0F,$C1,$0C,$27,$03,$5C,$8D,$02,$32,$39,$37,$36
  DC.B $BD,$CD,$D3,$27,$05,$BD,$C9,$1A,$20,$08,$58,$CB,$64,$86,$3A,$BD,$D6
  DC.B $C4,$32,$33,$39,$37,$36,$3C,$18,$3C,$BD,$CA,$49,$C6,$32,$86,$01,$B5
  DC.B $51,$50,$27,$02,$C6,$19,$36,$86,$4C,$BD,$D6,$C4,$32,$F6,$51         *10e
  DC.B $C3,$80,$50,$C4,$0E,$CE,$CD,$C3,$3A,$E6,$00,$36,$86,$46,$BD,$D6,$C4
  DC.B $32,$E6,$01,$36,$86,$48,$BD,$D6,$C4,$32,$36,$37,$C6,$00,$86,$4A,$BD
  DC.B $D6,$C4,$33,$32,$B6,$51,$56,$85,$08,$27,$7C,$86,$1E,$BD,$D7,$ED,$8A
  DC.B $01,$16,$36,$86,$1E,$BD,$D6,$C4,$32,$BD,$CD,$D3,$27,$2D,$86         *10f
  DC.B $C3,$C0,$16,$BD,$D7,$ED,$84,$CF,$8A,$20,$16,$36,$86,$16,$BD,$D6,$C4
  DC.B $32,$F6,$51,$52,$37,$86,$0F,$18,$30,$18,$A0,$00,$16,$4F,$05,$05,$05
  DC.B $05,$05,$8A,$20,$CA,$00,$BD,$D7,$27,$33,$20,$2E,$86,$16,$BD,$D7,$ED
  DC.B $84,$CF,$F6,$51,$52,$C4,$0F,$C1,$0C,$26,$04,$8A,$00,$20,$12         *110
  DC.B $C4,$00,$C1,$05,$22,$04,$8A,$30,$20,$0A,$C1,$08,$23,$04,$8A,$10,$20
  DC.B $02,$8A,$20,$16,$36,$86,$16,$BD,$D6,$C4,$32,$36,$37,$C6,$73,$86,$3C
  DC.B $BD,$D6,$C4,$33,$32,$20,$11,$36,$37,$C6,$63,$86,$3C,$BD,$D6,$C4,$33
  DC.B $32,$F6,$51,$52,$BD,$C3,$4D,$18,$38,$38,$32,$33,$39,$37,$36         *111
  DC.B $C4,$40,$B6,$51,$56,$85,$80,$26,$03,$7E,$C5,$4C,$8A,$02,$B7,$51,$56
  DC.B $7D,$51,$5B,$26,$5C,$BD,$DB,$EA,$7D,$51,$58,$2A,$23,$86,$20,$B5,$51
  DC.B $56,$27,$2A,$4F,$BD,$CB,$71,$86,$DF,$B4,$51,$56,$B7,$51,$56,$B6,$51
  DC.B $51,$81,$01,$26,$06,$F6,$51,$55,$BD,$C3,$4D,$7E,$C5,$4C,$7D         *112
  DC.B $C4,$80,$51,$59,$27,$09,$86,$3C,$BD,$D7,$ED,$16,$7E,$C5,$19,$86,$01
  DC.B $BD,$CB,$71,$36,$B6,$51,$56,$8A,$20,$B7,$51,$56,$32,$86,$08,$B7,$51
  DC.B $5B,$B6,$51,$58,$B7,$51,$59,$B6,$51,$57,$B7,$51,$5A,$BD,$DB,$EA,$BD
  DC.B $DB,$EE,$7A,$51,$5B,$86,$3C,$BD,$D7,$ED,$16,$B6,$51,$5A,$48         *113
  DC.B $C4,$C0,$B7,$51,$5A,$24,$35,$B6,$51,$56,$85,$40,$27,$11,$86,$01,$BD
  DC.B $CB,$71,$36,$B6,$51,$56,$84,$BF,$B7,$51,$56,$32,$20,$14,$B6,$51,$56
  DC.B $85,$08,$27,$09,$BD,$C3,$64,$86,$3C,$BD,$D7,$ED,$16,$C5,$02,$27,$47
  DC.B $C4,$F5,$86,$3C,$BD,$D6,$C4,$20,$3E,$B6,$51,$56,$85,$08,$27         *114
  DC.B $C5,$00,$18,$36,$37,$C6,$0C,$86,$3C,$BD,$D6,$C4,$33,$32,$36,$37,$C6
  DC.B $21,$86,$3C,$BD,$D6,$C4,$33,$32,$20,$1F,$C5,$02,$26,$1B,$B6,$51,$56
  DC.B $85,$08,$27,$0D,$36,$37,$C6,$21,$86,$3C,$BD,$D6,$C4,$33,$32,$20,$07
  DC.B $CA,$0A,$86,$3C,$BD,$D6,$C4,$7A,$51,$59,$36,$37,$C6,$19,$86         *115
  DC.B $C5,$40,$08,$18,$CE,$C4,$3E,$BD,$86,$5D,$33,$32,$20,$11,$7F,$51,$59
  DC.B $7F,$51,$5B,$86,$DD,$B4,$51,$56,$B7,$51,$56,$BD,$DB,$FB,$32,$33,$39
  DC.B $37,$85,$80,$27,$13,$F6,$51,$5D,$85,$01,$27,$04,$CA,$80,$20,$02,$C4
  DC.B $7F,$F7,$51,$5D,$BD,$C7,$E6,$85,$40,$27,$10,$F6,$51,$5D,$85         *116
  DC.B $C5,$80,$01,$27,$04,$CA,$40,$20,$02,$C4,$BF,$F7,$51,$5D,$85,$20,$27
  DC.B $13,$F6,$51,$5D,$85,$01,$27,$04,$CA,$20,$20,$02,$C4,$DF,$F7,$51,$5D
  DC.B $BD,$C8,$0A,$85,$10,$27,$13,$F6,$51,$5D,$85,$01,$27,$04,$CA,$10,$20
  DC.B $02,$C4,$EF,$F7,$51,$5D,$BD,$C8,$A5,$33,$39,$37,$85,$80,$27         *117
  DC.B $C5,$C0,$13,$F6,$51,$5E,$85,$01,$27,$04,$CA,$80,$20,$02,$C4,$7F,$F7
  DC.B $51,$5E,$BD,$C8,$FB,$85,$40,$27,$13,$F6,$51,$5E,$85,$01,$27,$04,$CA
  DC.B $40,$20,$02,$C4,$BF,$F7,$51,$5E,$BD,$C8,$FC,$85,$20,$27,$25,$F6,$51
  DC.B $5E,$85,$01,$27,$16,$7D,$51,$4C,$26,$0D,$7D,$51,$51,$26,$08         *118
  DC.B $C6,$00,$37,$F6,$51,$54,$BD,$C3,$4D,$33,$CA,$20,$20,$02,$C4,$DF,$F7
  DC.B $51,$5E,$BD,$CA,$C3,$85,$10,$27,$13,$F6,$51,$5E,$85,$01,$27,$04,$CA
  DC.B $10,$20,$02,$C4,$EF,$F7,$51,$5E,$BD,$CB,$12,$33,$39,$37,$85,$20,$27
  DC.B $10,$F6,$51,$5F,$85,$01,$27,$04,$CA,$20,$20,$02,$C4,$DF,$F7         *119
  DC.B $C6,$40,$51,$5F,$85,$10,$27,$10,$F6,$51,$5F,$85,$01,$27,$04,$CA,$10
  DC.B $20,$02,$C4,$EF,$F7,$51,$5F,$33,$39,$37,$36,$85,$10,$27,$2B,$F6,$51
  DC.B $60,$85,$01,$27,$1B,$CA,$10,$F7,$51,$60,$86,$01,$BD,$CB,$71,$86,$3C
  DC.B $BD,$D7,$ED,$84,$FD,$16,$36,$86,$3C,$BD,$D6,$C4,$32,$20,$09         *11a
  DC.B $C6,$80,$C4,$EF,$F7,$51,$60,$4F,$BD,$CB,$71,$32,$33,$39,$37,$85,$40
  DC.B $27,$3C,$F6,$51,$61,$85,$01,$27,$25,$CA,$40,$F7,$51,$61,$36,$B6,$14
  DC.B $20,$84,$3F,$B7,$14,$20,$86,$06,$BD,$D8,$36,$85,$40,$32,$26,$1D,$36
  DC.B $37,$C6,$0F,$86,$06,$BD,$D6,$F9,$33,$32,$20,$10,$C4,$BF,$F7         *11b
  DC.B $C6,$C0,$51,$61,$F6,$14,$20,$CA,$C0,$F7,$14,$20,$BD,$C7,$09,$85,$10
  DC.B $27,$19,$F6,$51,$61,$85,$01,$27,$0A,$CA,$10,$F7,$51,$61,$BD,$C7,$09
  DC.B $20,$08,$C4,$EF,$F7,$51,$61,$BD,$C7,$09,$85,$20,$27,$19,$F6,$51,$61
  DC.B $85,$01,$27,$0A,$CA,$20,$F7,$51,$61,$BD,$C7,$66,$20,$08,$C4         *11c
  DC.B $C7,$00,$DF,$F7,$51,$61,$BD,$C7,$66,$33,$39,$37,$36,$18,$3C,$36,$86
  DC.B $06,$BD,$D8,$36,$16,$32,$18,$CE,$51,$61,$18,$1F,$00,$40,$2A,$85,$01
  DC.B $27,$14,$18,$8F,$CC,$51,$02,$BD,$D7,$27,$18,$8F,$C5,$08,$27,$31,$C4
  DC.B $F7,$CA,$03,$20,$24,$18,$8F,$CC,$D7,$E2,$BD,$D7,$27,$18,$8F         *11d
  DC.B $C7,$40,$C5,$08,$26,$1D,$CA,$0B,$20,$12,$18,$8F,$CC,$D7,$E2,$BD,$D7
  DC.B $27,$18,$8F,$C5,$08,$27,$0B,$C4,$F7,$CA,$03,$36,$86,$06,$BD,$D6,$F9
  DC.B $32,$18,$38,$32,$33,$39,$37,$36,$36,$86,$06,$BD,$D8,$36,$16,$32,$18
  DC.B $CE,$51,$61,$18,$1F,$00,$40,$44,$85,$01,$27,$21,$B6,$14,$30         *11e
  DC.B $C7,$80,$84,$BF,$B7,$14,$30,$86,$1C,$BD,$D7,$ED,$84,$FD,$37,$16,$86
  DC.B $1C,$BD,$D6,$C4,$33,$C5,$04,$27,$4B,$C4,$FB,$CA,$03,$20,$3E,$B6,$14
  DC.B $30,$8A,$40,$B7,$14,$30,$86,$1C,$BD,$D7,$ED,$8A,$02,$37,$16,$86,$1C
  DC.B $BD,$D6,$C4,$33,$C5,$04,$26,$2A,$CA,$07,$20,$1F,$B6,$14,$30         *11f
  DC.B $C7,$C0,$8A,$40,$B7,$14,$30,$86,$1C,$BD,$D7,$ED,$84,$FD,$37,$16,$86
  DC.B $1C,$BD,$D6,$C4,$33,$C5,$04,$27,$0B,$C4,$FB,$CA,$03,$36,$86,$06,$BD
  DC.B $D6,$F9,$32,$32,$33,$39,$37,$36,$36,$86,$1C,$BD,$D7,$ED,$16,$32,$85
  DC.B $01,$27,$08,$C5,$10,$26,$0F,$CA,$10,$20,$06,$C5,$10,$27,$07         *120
  DC.B $C8,$00,$C4,$EF,$86,$1C,$BD,$D6,$C4,$32,$33,$39,$37,$36,$36,$86,$1C
  DC.B $BD,$D7,$ED,$16,$32,$85,$01,$26,$38,$C4,$FE,$86,$1C,$BD,$D6,$C4,$7D
  DC.B $51,$4C,$27,$1F,$BD,$CD,$D3,$26,$0D,$F6,$51,$54,$58,$CB,$58,$86,$3A
  DC.B $BD,$D6,$C4,$20,$06,$F6,$51,$54,$BD,$C9,$48,$86,$01,$BD,$CA         *121
  DC.B $C8,$40,$C3,$20,$5F,$7D,$51,$51,$26,$5A,$F6,$51,$54,$BD,$C3,$4D,$20
  DC.B $52,$CA,$01,$86,$1C,$BD,$D6,$C4,$7D,$51,$4C,$27,$11,$C6,$5F,$86,$3A
  DC.B $BD,$D6,$C4,$F6,$14,$30,$CA,$40,$F7,$14,$30,$20,$0E,$BD,$CA,$49,$36
  DC.B $37,$C6,$21,$86,$3C,$BD,$D6,$C4,$33,$32,$B6,$51,$5D,$85,$40         *122
  DC.B $C8,$80,$27,$09,$86,$03,$B7,$51,$53,$C6,$70,$20,$08,$F6,$51,$53,$C4
  DC.B $0F,$58,$CB,$6A,$7D,$51,$4C,$26,$07,$86,$3A,$BD,$D6,$C4,$20,$03,$F7
  DC.B $51,$4F,$32,$33,$39,$37,$36,$36,$86,$1C,$BD,$D7,$ED,$16,$32,$85,$01
  DC.B $26,$14,$17,$84,$0C,$81,$08,$26,$2A,$C4,$F3,$C5,$03,$26,$00         *123
  DC.B $C8,$C0,$86,$1C,$BD,$D6,$C4,$20,$1D,$8D,$1E,$17,$84,$0C,$81,$08,$27
  DC.B $14,$C4,$F3,$CA,$08,$86,$1C,$BD,$D6,$C4,$36,$37,$C6,$30,$86,$40,$BD
  DC.B $D6,$C4,$33,$32,$32,$33,$39,$37,$36,$86,$2A,$BD,$D7,$ED,$16,$C4,$EF
  DC.B $36,$86,$2A,$BD,$D6,$C4,$32,$32,$33,$39,$39,$36,$37,$7D,$51         *124
  DC.B $C9,$00,$4C,$26,$14,$85,$01,$27,$08,$F6,$51,$56,$C4,$7F,$F7,$51,$56
  DC.B $BD,$CD,$D3,$26,$03,$BD,$C9,$6D,$33,$32,$39,$36,$18,$3C,$37,$7D,$51
  DC.B $62,$26,$04,$C6,$70,$20,$02,$C6,$6E,$86,$3A,$BD,$D6,$C4,$86,$0F,$18
  DC.B $30,$18,$A0,$00,$16,$4F,$05,$05,$05,$05,$05,$8A,$20,$CA,$00         *125
  DC.B $C9,$40,$BD,$D7,$27,$33,$18,$38,$32,$39,$36,$18,$3C,$37,$C6,$6C,$86
  DC.B $3A,$BD,$D6,$C4,$86,$14,$18,$30,$18,$A0,$00,$16,$4F,$05,$05,$05,$05
  DC.B $05,$8A,$20,$CA,$00,$BD,$D7,$27,$33,$18,$38,$32,$39,$36,$37,$85,$01
  DC.B $27,$53,$86,$3A,$BD,$D7,$ED,$36,$BD,$CA,$49,$36,$37,$C6,$81         *126
  DC.B $C9,$80,$86,$3C,$BD,$D6,$C4,$33,$32,$33,$86,$3A,$BD,$D6,$C4,$36,$37
  DC.B $C6,$0C,$86,$3C,$BD,$D6,$C4,$33,$32,$86,$5A,$BD,$CA,$71,$86,$3A,$BD
  DC.B $D7,$ED,$16,$CA,$80,$86,$3A,$BD,$D6,$C4,$8D,$2A,$36,$37,$C6,$81,$86
  DC.B $3C,$BD,$D6,$C4,$33,$32,$86,$3A,$BD,$D7,$ED,$16,$C4,$7F,$86         *127
  DC.B $C9,$C0,$3A,$BD,$D6,$C4,$20,$0D,$86,$3C,$BD,$D7,$ED,$84,$E0,$81,$80
  DC.B $26,$02,$8D,$5B,$33,$32,$39,$18,$3C,$36,$18,$CE,$E0,$00,$86,$54,$BD
  DC.B $D7,$8E,$18,$CE,$10,$00,$86,$56,$BD,$D7,$8E,$18,$CE,$15,$96,$86,$58
  DC.B $BD,$D7,$8E,$18,$CE,$F7,$C7,$86,$5A,$BD,$D7,$8E,$18,$CE,$08         *128
  DC.B $CA,$00,$1A,$86,$50,$BD,$D7,$8E,$18,$CE,$04,$EE,$86,$44,$BD,$D7,$8E
  DC.B $18,$CE,$0B,$73,$86,$52,$BD,$D7,$8E,$18,$CE,$00,$70,$86,$46,$BD,$D7
  DC.B $8E,$18,$CE,$00,$01,$86,$4A,$BD,$D7,$8E,$32,$18,$38,$39,$37,$8D,$18
  DC.B $36,$37,$C6,$30,$86,$40,$BD,$D6,$C4,$33,$32,$36,$37,$C6,$21         *129
  DC.B $CA,$40,$86,$3C,$BD,$D6,$C4,$33,$32,$33,$39,$36,$36,$37,$C6,$0C,$86
  DC.B $3C,$BD,$D6,$C4,$33,$32,$36,$37,$C6,$0D,$86,$3C,$BD,$D6,$C4,$33,$32
  DC.B $86,$36,$8D,$0D,$36,$37,$C6,$0C,$86,$3C,$BD,$D6,$C4,$33,$32,$32,$39
  DC.B $4A,$26,$FD,$39,$36,$36,$37,$C6,$20,$86,$06,$BD,$D6,$F9,$33         *12a
  DC.B $CA,$80,$32,$36,$37,$C6,$00,$86,$06,$BD,$D6,$F9,$33,$32,$36,$37,$C6
  DC.B $03,$86,$06,$BD,$D6,$F9,$33,$32,$B6,$3C,$C8,$81,$03,$26,$0D,$36,$37
  DC.B $C6,$0F,$86,$08,$BD,$D6,$F9,$33,$32,$20,$16,$36,$37,$C6,$4F,$86,$08
  DC.B $BD,$D6,$F9,$33,$32,$36,$37,$C6,$00,$86,$0C,$BD,$D6,$F9,$33         *12b
  DC.B $CA,$C0,$32,$32,$39,$37,$36,$16,$85,$01,$27,$17,$86,$1C,$BD,$D7,$ED
  DC.B $16,$CA,$82,$86,$1C,$BD,$D6,$C4,$F6,$14,$30,$C4,$BF,$F7,$14,$30,$20
  DC.B $22,$B6,$51,$5E,$85,$20,$26,$1B,$B6,$51,$61,$85,$20,$26,$14,$B6,$51
  DC.B $56,$85,$08,$26,$05,$7D,$51,$4C,$26,$08,$F6,$14,$30,$CA,$40         *12c
  DC.B $CB,$00,$F7,$14,$30,$32,$33,$39,$F6,$51,$5E,$C4,$10,$27,$04,$86,$01
  DC.B $8D,$01,$39,$37,$36,$18,$3C,$36,$86,$1C,$BD,$D7,$ED,$16,$32,$85,$01
  DC.B $27,$2E,$BD,$C8,$E7,$18,$8F,$7D,$51,$62,$26,$0A,$7D,$51,$63,$27,$05
  DC.B $CC,$51,$02,$20,$03,$CC,$51,$02,$BD,$D7,$27,$18,$8F,$17,$84         *12d
  DC.B $CB,$40,$0C,$81,$0C,$27,$27,$C4,$F3,$CA,$0C,$86,$1C,$BD,$D6,$C4,$20
  DC.B $1C,$18,$8F,$CC,$D7,$E2,$BD,$D7,$27,$18,$8F,$17,$84,$0C,$81,$0C,$26
  DC.B $0B,$C4,$F3,$C5,$03,$26,$00,$86,$1C,$BD,$D6,$C4,$18,$38,$32,$33,$39
  DC.B $37,$36,$85,$01,$27,$12,$86,$01,$BD,$CA,$C3,$BD,$C3,$64,$86         *12e
  DC.B $CB,$80,$80,$BA,$51,$56,$B7,$51,$56,$20,$6E,$4F,$BD,$CA,$C3,$B6,$51
  DC.B $56,$84,$5F,$B7,$51,$56,$86,$1E,$BD,$D7,$ED,$85,$01,$26,$29,$86,$3C
  DC.B $BD,$D7,$ED,$16,$84,$E0,$81,$60,$27,$0F,$C5,$08,$27,$49,$C4,$F5,$36
  DC.B $86,$3C,$BD,$D6,$C4,$32,$20,$3E,$7D,$51,$4C,$26,$36,$BD,$CA         *12f
  DC.B $CB,$C0,$2E,$4F,$BD,$CA,$C3,$20,$30,$36,$4F,$BD,$CA,$C3,$32,$84,$FE
  DC.B $16,$36,$86,$1E,$BD,$D6,$C4,$32,$B6,$51,$56,$84,$F3,$B7,$51,$56,$7D
  DC.B $51,$4C,$26,$10,$BD,$CA,$49,$36,$37,$C6,$21,$86,$3C,$BD,$D6,$C4,$33
  DC.B $32,$20,$03,$BD,$C1,$1B,$32,$33,$39,$37,$36,$84,$03,$B1,$51         *130
  DC.B $CC,$00,$51,$27,$6F,$4D,$26,$35,$F6,$51,$51,$C4,$03,$27,$65,$C1,$01
  DC.B $27,$16,$C1,$02,$27,$01,$00,$86,$7F,$B4,$51,$56,$B7,$51,$56,$BD,$DB
  DC.B $FB,$7F,$51,$59,$7F,$51,$5B,$7F,$51,$51,$7D,$51,$4C,$26,$43,$B6,$51
  DC.B $5D,$85,$20,$26,$3C,$BD,$CA,$2E,$20,$37,$84,$03,$81,$01,$26         *131
  DC.B $CC,$40,$0E,$B7,$51,$51,$BD,$CA,$2E,$F6,$51,$55,$BD,$C3,$4D,$20,$23
  DC.B $81,$02,$26,$1F,$B7,$51,$51,$86,$76,$B7,$51,$57,$86,$08,$B7,$51,$58
  DC.B $86,$80,$BA,$51,$56,$B7,$51,$56,$85,$02,$26,$06,$BD,$DB,$D7,$BD,$C4
  DC.B $3E,$32,$33,$39,$81,$01,$26,$66,$BD,$B9,$53,$84,$03,$CE,$CC         *132
  DC.B $CC,$80,$E8,$18,$CE,$CC,$EC,$16,$3A,$18,$3A,$86,$1E,$BD,$D7,$ED,$84
  DC.B $C9,$AA,$00,$16,$36,$86,$1E,$BD,$D6,$C4,$32,$F6,$3C,$C8,$C1,$03,$27
  DC.B $0E,$18,$E6,$00,$CA,$47,$36,$86,$08,$BD,$D6,$F9,$32,$20,$0C,$18,$E6
  DC.B $00,$CA,$07,$36,$86,$08,$BD,$D6,$F9,$32,$85,$20,$26,$10,$7F         *133
  DC.B $CC,$C0,$51,$62,$36,$37,$C6,$05,$86,$16,$BD,$D6,$C4,$33,$32,$20,$10
  DC.B $86,$01,$B7,$51,$62,$36,$37,$C6,$06,$86,$16,$BD,$D6,$C4,$33,$32,$39
  DC.B $36,$B6,$51,$56,$85,$80,$32,$39,$10,$00,$36,$26,$08,$00,$18,$10,$36
  DC.B $36,$37,$C6,$58,$86,$1E,$BD,$D6,$C4,$33,$32,$36,$37,$C6,$05         *134
  DC.B $CD,$00,$86,$16,$BD,$D6,$C4,$33,$32,$B6,$3C,$C8,$81,$03,$26,$0D,$36
  DC.B $37,$C6,$0F,$86,$08,$BD,$D6,$F9,$33,$32,$20,$16,$36,$37,$C6,$4F,$86
  DC.B $08,$BD,$D6,$F9,$33,$32,$36,$37,$C6,$00,$86,$0C,$BD,$D6,$F9,$33,$32
  DC.B $7F,$51,$62,$32,$39,$36,$37,$B7,$18,$40,$B6,$14,$30,$84,$DF         *135
  DC.B $CD,$40,$B7,$14,$30,$8A,$20,$B7,$14,$30,$BD,$B2,$5C,$BD,$B2,$5C,$CC
  DC.B $80,$00,$BD,$D7,$27,$86,$5A,$BD,$CA,$71,$CC,$FF,$FE,$BD,$D7,$27,$86
  DC.B $5A,$BD,$CA,$71,$CC,$21,$40,$BD,$D7,$27,$86,$5A,$BD,$CA,$71,$CC,$D7
  DC.B $E2,$BD,$D7,$27,$86,$5A,$BD,$CA,$71,$CC,$01,$6C,$BD,$D7,$27         *136
  DC.B $CD,$80,$86,$5A,$BD,$CA,$71,$CC,$00,$26,$BD,$D7,$27,$33,$32,$39,$36
  DC.B $86,$1C,$BD,$D7,$ED,$16,$32,$39,$B1,$50,$C2,$E1,$C3,$05,$C2,$CF,$C2
  DC.B $F3,$C2,$9F,$59,$9B,$59,$AB,$59,$BD,$63,$9B,$63,$AB,$63,$BD,$6D,$9B
  DC.B $6D,$AB,$6D,$BD,$79,$9B,$79,$AB,$79,$BD,$59,$D1,$63,$D1,$6D         *137
  DC.B $CD,$C0,$D1,$79,$D1,$16,$12,$14,$0D,$12,$0C,$11,$0B,$0A,$08,$07,$05
  DC.B $06,$05,$06,$04,$36,$B6,$3C,$C8,$81,$00,$26,$09,$BD,$D6,$1E,$27,$05
  DC.B $86,$01,$20,$01,$4F,$32,$39,$36,$B6,$14,$30,$85,$40,$27,$03,$BD,$CD
  DC.B $36,$32,$39,$0F,$7C,$3C,$BB,$CC,$00,$00,$FD,$22,$86,$A6,$04         *138
  DC.B $CE,$00,$85,$40,$26,$0E,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32
  DC.B $7E,$CE,$A6,$18,$FE,$2B,$38,$26,$12,$FC,$22,$8C,$26,$0D,$36,$07,$7A
  DC.B $3C,$BB,$26,$02,$84,$EF,$06,$32,$20,$2E,$18,$3C,$18,$CE,$22,$8C,$BD
  DC.B $83,$4F,$18,$38,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32         *139
  DC.B $CE,$40,$20,$64,$18,$3C,$18,$CE,$22,$8C,$BD,$83,$83,$18,$38,$27,$57
  DC.B $1F,$04,$20,$05,$BD,$84,$8E,$20,$EA,$A6,$04,$8A,$80,$A7,$04,$FF,$2B
  DC.B $38,$86,$29,$BD,$D7,$ED,$84,$10,$27,$29,$0F,$7C,$3C,$BB,$A6,$05,$C6
  DC.B $06,$3A,$BD,$D0,$CA,$B7,$51,$7A,$27,$05,$FF,$51,$7B,$20,$06         *13a
  DC.B $CE,$80,$CE,$00,$00,$FF,$51,$7B,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF
  DC.B $06,$32,$20,$13,$B6,$51,$79,$8A,$01,$B7,$51,$79,$36,$37,$C6,$64,$86
  DC.B $06,$BD,$D6,$C4,$33,$32,$39,$7C,$3C,$BB,$BD,$88,$2F,$86,$0F,$BD,$D7
  DC.B $ED,$F6,$22,$7D,$26,$03,$7E,$D0,$87,$B7,$51,$64,$26,$03,$7E         *13b
  DC.B $CE,$C0,$D0,$87,$85,$08,$27,$36,$B6,$51,$64,$84,$F7,$B7,$51,$64,$FE
  DC.B $51,$7B,$26,$11,$86,$0C,$BD,$D7,$ED,$84,$F7,$16,$36,$86,$0C,$BD,$D6
  DC.B $C4,$32,$20,$70,$B6,$51,$7A,$BD,$D0,$CA,$B7,$51,$7A,$27,$05,$FF,$51
  DC.B $7B,$20,$60,$CE,$00,$00,$FF,$51,$7B,$20,$58,$85,$20,$27,$03         *13c
  DC.B $CF,$00,$7E,$CF,$62,$85,$01,$26,$50,$85,$42,$27,$03,$7E,$CF,$C4,$85
  DC.B $80,$26,$03,$7E,$CF,$62,$B6,$51,$64,$84,$7F,$B7,$51,$64,$36,$37,$C6
  DC.B $60,$86,$06,$BD,$D6,$C4,$33,$32,$B6,$51,$79,$85,$01,$26,$03,$7E,$CF
  DC.B $8D,$84,$FE,$B7,$51,$79,$FE,$2B,$38,$27,$18,$A6,$05,$C6,$06         *13d
  DC.B $CF,$40,$3A,$BD,$D0,$CA,$B7,$51,$7A,$27,$05,$FF,$51,$7B,$20,$06,$CE
  DC.B $00,$00,$FF,$51,$7B,$7E,$D0,$87,$B6,$51,$64,$84,$FE,$B7,$51,$64,$7E
  DC.B $CF,$B3,$85,$20,$27,$27,$B6,$51,$64,$84,$DF,$B7,$51,$64,$FE,$2B,$38
  DC.B $27,$0F,$A6,$07,$85,$01,$27,$09,$CC,$00,$00,$FD,$2B,$38,$BD         *13e
  DC.B $CF,$80,$84,$8E,$CC,$00,$00,$FD,$2B,$38,$BD,$CE,$42,$20,$C7,$B6,$51
  DC.B $64,$85,$04,$27,$C0,$84,$FB,$B7,$51,$64,$FE,$2B,$38,$27,$0F,$A6,$07
  DC.B $85,$01,$27,$09,$CC,$00,$00,$FD,$2B,$38,$BD,$84,$8E,$CC,$00,$00,$FD
  DC.B $2B,$38,$86,$05,$BD,$D7,$ED,$86,$09,$BD,$D7,$ED,$84,$03,$26         *13f
  DC.B $CF,$C0,$F2,$7E,$D0,$76,$B6,$51,$64,$84,$BD,$B7,$51,$64,$5F,$FE,$22
  DC.B $94,$26,$31,$BD,$84,$0B,$27,$DC,$C6,$13,$86,$09,$BD,$D7,$ED,$85,$03
  DC.B $27,$0E,$84,$30,$81,$10,$27,$0E,$86,$05,$BD,$D7,$ED,$5A,$26,$E9,$BD
  DC.B $84,$8E,$7E,$D0,$87,$FF,$22,$92,$C6,$06,$3A,$FF,$22,$94,$7F         *140
  DC.B $D0,$00,$51,$65,$5F,$86,$09,$BD,$D7,$ED,$85,$03,$27,$2E,$85,$20,$26
  DC.B $30,$86,$05,$BD,$D7,$ED,$A7,$00,$08,$5C,$C1,$0F,$25,$16,$B6,$3C,$C8
  DC.B $81,$00,$27,$04,$81,$02,$26,$0B,$BD,$D6,$1E,$27,$06,$3C,$BD,$8A,$F8
  DC.B $38,$5F,$7C,$51,$65,$27,$3C,$20,$C9,$FF,$22,$94,$7E,$D0,$87         *141
  DC.B $D0,$40,$16,$B6,$51,$64,$84,$EF,$B7,$51,$64,$86,$05,$BD,$D7,$ED,$C4
  DC.B $30,$C1,$30,$27,$22,$A7,$00,$F6,$51,$65,$5C,$27,$18,$FE,$22,$92,$E7
  DC.B $05,$86,$01,$C6,$02,$ED,$02,$18,$3C,$18,$CE,$22,$88,$BD,$83,$4F,$18
  DC.B $38,$20,$0A,$20,$00,$FE,$22,$92,$27,$03,$BD,$84,$8E,$CC,$00         *142
  DC.B $D0,$80,$00,$FD,$22,$94,$FD,$22,$92,$B6,$51,$64,$84,$EF,$B7,$51,$64
  DC.B $27,$03,$7E,$CE,$FC,$BD,$89,$8D,$7A,$3C,$BB,$3B,$3C,$36,$37,$FE,$2B
  DC.B $38,$27,$0D,$CC,$00,$00,$FD,$2B,$38,$1F,$07,$01,$03,$BD,$84,$8E,$18
  DC.B $3C,$18,$CE,$22,$8C,$BD,$83,$83,$18,$38,$27,$09,$1F,$07,$01         *143
  DC.B $D0,$C0,$EF,$BD,$84,$8E,$20,$EA,$33,$32,$38,$39,$37,$18,$3C,$36,$4D
  DC.B $27,$6A,$8C,$00,$00,$27,$65,$18,$30,$86,$09,$BD,$D7,$ED,$84,$0C,$81
  DC.B $00,$27,$58,$81,$04,$27,$54,$81,$08,$26,$04,$86,$13,$20,$04,$86,$0F
  DC.B $20,$00,$E6,$00,$08,$18,$6A,$00,$27,$1B,$36,$86,$04,$BD,$D6         *144
  DC.B $D1,$00,$C4,$32,$4A,$26,$EE,$86,$0C,$BD,$D7,$ED,$8A,$08,$16,$36,$86
  DC.B $0C,$BD,$D6,$C4,$32,$20,$25,$37,$36,$36,$37,$C6,$70,$86,$06,$BD,$D6
  DC.B $C4,$33,$32,$32,$33,$36,$86,$04,$BD,$D6,$C4,$32,$86,$0C,$BD,$D7,$ED
  DC.B $84,$F7,$16,$36,$86,$0C,$BD,$D6,$C4,$32,$32,$18,$38,$33,$39         *145
  DC.B $D1,$40,$37,$36,$86,$29,$BD,$D7,$ED,$84,$80,$26,$2C,$86,$3C,$BD,$D7
  DC.B $ED,$85,$08,$26,$0A,$8A,$08,$16,$36,$86,$3C,$BD,$D6,$C4,$32,$7A,$51
  DC.B $66,$26,$31,$BD,$D1,$E4,$8D,$3E,$27,$05,$C6,$10,$7E,$80,$36,$C6,$10
  DC.B $F7,$22,$7E,$BD,$BF,$2F,$86,$08,$B7,$51,$66,$BD,$CC,$E0,$26         *146
  DC.B $D1,$80,$13,$86,$3C,$BD,$D7,$ED,$85,$08,$27,$0A,$84,$F7,$16,$36,$86
  DC.B $3C,$BD,$D6,$C4,$32,$36,$37,$C6,$0F,$86,$01,$18,$CE,$D1,$40,$BD,$86
  DC.B $5D,$33,$32,$32,$33,$39,$37,$36,$3C,$FE,$22,$84,$C6,$0A,$3A,$FF,$51
  DC.B $68,$5F,$37,$36,$36,$37,$C6,$0A,$86,$22,$BD,$D6,$C4,$33,$32         *147
  DC.B $D1,$C0,$32,$33,$86,$26,$BD,$CA,$71,$86,$29,$BD,$D7,$ED,$84,$80,$26
  DC.B $03,$5F,$20,$03,$5C,$27,$0A,$FE,$51,$68,$BC,$22,$84,$26,$D5,$C6,$01
  DC.B $38,$32,$33,$39,$37,$36,$37,$C6,$32,$86,$28,$BD,$D6,$C4,$33,$32,$C6
  DC.B $F0,$86,$26,$BD,$CA,$71,$5A,$26,$F8,$36,$37,$C6,$30,$86,$28         *148
  DC.B $D2,$00,$BD,$D6,$C4,$33,$32,$33,$39,$BD,$83,$24,$8D,$D8,$8D,$98,$27
  DC.B $05,$BD,$DB,$14,$20,$F2,$36,$37,$C6,$40,$86,$28,$BD,$D6,$C4,$33,$32
  DC.B $B6,$3C,$C8,$81,$03,$26,$03,$15,$08,$01,$8D,$B8,$BD,$D1,$A6,$26,$D6
  DC.B $39,$18,$3C,$3C,$37,$36,$BD,$83,$24,$36,$37,$C6,$10,$86,$01         *149
  DC.B $D2,$40,$18,$CE,$D2,$32,$BD,$86,$5D,$33,$32,$BD,$91,$E5,$BD,$A5,$47
  DC.B $BD,$D4,$1B,$2A,$03,$7E,$D2,$EB,$BD,$D3,$BF,$BD,$D2,$F4,$BD,$D3,$31
  DC.B $BD,$D5,$A3,$B1,$51,$82,$27,$EC,$F6,$51,$82,$C1,$00,$27,$0C,$C4,$BF
  DC.B $F7,$51,$83,$C6,$00,$F7,$51,$82,$20,$08,$B7,$51,$82,$8A,$40         *14a
  DC.B $D2,$80,$B7,$51,$83,$B6,$51,$83,$16,$84,$BF,$80,$19,$2B,$0A,$81,$0B
  DC.B $22,$06,$17,$BD,$D4,$F1,$20,$54,$7D,$51,$44,$26,$21,$4F,$36,$18,$30
  DC.B $17,$84,$BF,$80,$10,$27,$09,$18,$6A,$00,$4A,$27,$03,$32,$20,$0D,$32
  DC.B $C6,$40,$F5,$51,$83,$27,$33,$BD,$C2,$5F,$20,$2E,$B6,$51,$83         *14b
  DC.B $D2,$C0,$84,$BF,$81,$25,$25,$1D,$81,$2B,$24,$21,$80,$25,$C6,$40,$F5
  DC.B $51,$83,$26,$09,$FE,$3C,$D8,$EE,$12,$AD,$00,$20,$07,$FE,$3C,$D8,$EE
  DC.B $14,$AD,$00,$F6,$51,$83,$86,$02,$BD,$BE,$D4,$BD,$D3,$8A,$32,$33,$38
  DC.B $18,$38,$39,$36,$37,$B6,$3C,$C8,$81,$03,$27,$12,$15,$00,$38         *14c
  DC.B $D3,$00,$14,$00,$48,$86,$0A,$BD,$CA,$71,$B6,$18,$40,$84,$80,$20,$04
  DC.B $96,$00,$84,$02,$B1,$51,$9B,$27,$16,$B7,$51,$9B,$4D,$26,$09,$C6,$02
  DC.B $86,$D7,$BD,$BE,$D4,$20,$07,$C6,$03,$86,$D7,$BD,$BE,$D4,$33,$32,$39
  DC.B $37,$36,$7D,$51,$97,$2B,$08,$7A,$51,$97,$26,$03,$7A,$51,$97         *14d
  DC.B $D3,$40,$B6,$3C,$C8,$81,$03,$27,$12,$15,$00,$38,$14,$00,$50,$86,$0A
  DC.B $BD,$CA,$71,$B6,$18,$40,$84,$80,$20,$04,$96,$00,$84,$04,$B1,$51,$9A
  DC.B $27,$25,$B7,$51,$9A,$4D,$27,$08,$B6,$51,$98,$B7,$51,$97,$20,$17,$7D
  DC.B $51,$97,$2B,$12,$B6,$51,$98,$B0,$51,$97,$B1,$51,$99,$25,$07         *14e
  DC.B $D3,$80,$C6,$3F,$86,$02,$BD,$BE,$D4,$32,$33,$39,$36,$37,$7D,$51,$96
  DC.B $27,$05,$7A,$51,$96,$20,$26,$BD,$D4,$CE,$25,$21,$BD,$D4,$DD,$85,$40
  DC.B $26,$0B,$BD,$C0,$AA,$16,$86,$02,$BD,$BE,$D4,$20,$0A,$84,$BF,$80,$19
  DC.B $B7,$51,$4D,$BD,$C1,$1B,$86,$02,$B7,$51,$96,$33,$32,$39,$36         *14f
  DC.B $D3,$C0,$37,$15,$00,$80,$14,$26,$80,$86,$0A,$BD,$CA,$71,$B6,$18,$40
  DC.B $84,$80,$B1,$51,$7D,$26,$07,$86,$05,$B7,$51,$9C,$20,$19,$7A,$51,$9C
  DC.B $26,$14,$C6,$05,$F7,$51,$9C,$B7,$51,$7D,$C6,$00,$4D,$26,$02,$CA,$40
  DC.B $86,$02,$BD,$BE,$D4,$15,$26,$80,$33,$32,$39,$B6,$3C,$C8,$81         *150
  DC.B $D4,$00,$03,$27,$12,$15,$00,$38,$14,$00,$58,$86,$0A,$BD,$CA,$71,$B6
  DC.B $18,$40,$84,$80,$20,$05,$96,$00,$43,$84,$08,$39,$86,$01,$B7,$51,$7E
  DC.B $86,$01,$BD,$D4,$38,$2B,$10,$48,$85,$80,$27,$F6,$7D,$51,$7E,$26,$05
  DC.B $BD,$D4,$8E,$20,$01,$4F,$39,$37,$36,$18,$3C,$F6,$51,$A1,$53         *151
  DC.B $D4,$40,$D4,$00,$D7,$00,$F6,$3C,$C8,$C1,$03,$27,$03,$14,$00,$40,$36
  DC.B $86,$0A,$BD,$CA,$71,$32,$B5,$18,$40,$27,$10,$B7,$51,$80,$D6,$00,$F4
  DC.B $51,$A1,$F7,$51,$7F,$7A,$51,$7E,$2B,$1F,$F6,$51,$A1,$D4,$00,$FB,$51
  DC.B $A2,$F1,$51,$A3,$27,$11,$37,$F6,$51,$A1,$53,$D4,$00,$18,$30         *152
  DC.B $D4,$80,$18,$EA,$00,$D7,$00,$33,$20,$C6,$5F,$18,$38,$32,$33,$39,$3C
  DC.B $37,$F6,$3C,$C8,$C1,$00,$27,$05,$CE,$D6,$3A,$20,$0C,$12,$00,$02,$05
  DC.B $CE,$D6,$22,$20,$03,$CE,$D6,$2E,$F6,$51,$7F,$54,$54,$B6,$3C,$C8,$81
  DC.B $03,$26,$01,$54,$3A,$EE,$00,$F6,$51,$80,$BD,$D4,$C4,$3A,$A6         *153
  DC.B $D4,$C0,$00,$33,$38,$39,$36,$86,$FF,$4C,$54,$24,$FC,$16,$32,$39,$36
  DC.B $B6,$51,$95,$B1,$51,$94,$27,$03,$0C,$20,$01,$0D,$32,$39,$3C,$37,$CE
  DC.B $51,$84,$F6,$51,$95,$3A,$A6,$00,$5C,$C4,$0F,$F7,$51,$95,$33,$38,$39
  DC.B $37,$3C,$CE,$51,$84,$F6,$51,$94,$3A,$A7,$00,$5C,$C4,$0F,$F1         *154
  DC.B $D5,$00,$51,$95,$27,$05,$F7,$51,$94,$20,$06,$BD,$D5,$12,$BD,$C0,$AA
  DC.B $38,$33,$39,$7F,$51,$94,$7F,$51,$95,$7F,$51,$96,$39,$7F,$51,$82,$7F
  DC.B $51,$81,$86,$80,$B7,$51,$97,$86,$14,$B7,$51,$99,$86,$28,$B7,$51,$98
  DC.B $BD,$D5,$64,$86,$14,$B7,$51,$9E,$14,$00,$40,$B6,$3C,$C8,$81         *155
  DC.B $D5,$40,$03,$27,$11,$86,$38,$B7,$51,$A1,$86,$08,$B7,$51,$A2,$86,$30
  DC.B $B7,$51,$A3,$20,$0F,$86,$70,$B7,$51,$A1,$86,$10,$B7,$51,$A2,$86,$60
  DC.B $B7,$51,$A3,$39,$B6,$3C,$C8,$81,$03,$27,$12,$15,$00,$38,$14,$00,$48
  DC.B $86,$0A,$BD,$CA,$71,$B6,$18,$40,$84,$80,$20,$04,$96,$00,$84         *156
  DC.B $D5,$80,$02,$B7,$51,$9A,$86,$80,$B7,$51,$97,$39,$36,$86,$0A,$3D,$CE
  DC.B $00,$19,$02,$8F,$F7,$51,$99,$32,$C6,$0A,$3D,$CE,$00,$19,$02,$8F,$F7
  DC.B $51,$98,$39,$36,$B6,$51,$9D,$81,$01,$27,$33,$13,$00,$01,$07,$86,$14
  DC.B $B7,$51,$9E,$20,$3F,$7A,$51,$9E,$26,$3A,$B6,$3C,$C8,$81,$00         *157
  DC.B $D5,$C0,$26,$08,$BD,$CD,$36,$BD,$87,$A9,$20,$07,$81,$02,$26,$03,$BD
  DC.B $87,$A9,$BD,$94,$A3,$BD,$A6,$37,$86,$01,$B7,$51,$9D,$20,$17,$13,$00
  DC.B $01,$13,$86,$00,$B7,$51,$9D,$86,$14,$B7,$51,$9E,$BD,$89,$94,$BD,$94
  DC.B $93,$BD,$A6,$2C,$32,$39,$36,$37,$7D,$51,$9B,$26,$04,$C6,$02         *158
  DC.B $D6,$00,$20,$02,$C6,$03,$86,$D7,$BD,$BE,$D4,$33,$32,$39,$36,$B6,$51
  DC.B $7D,$43,$B7,$51,$7D,$86,$01,$B7,$51,$9C,$BD,$D3,$BF,$32,$39,$7D,$51
  DC.B $9D,$39,$D6,$46,$D6,$4D,$D6,$54,$D6,$5B,$D6,$62,$D6,$69,$D6,$70,$D6
  DC.B $77,$D6,$7E,$D6,$85,$D6,$8C,$D6,$93,$D6,$9A,$D6,$A1,$D6,$A8         *159
  DC.B $D6,$40,$D6,$AF,$D6,$B6,$D6,$BD,$1F,$1E,$1D,$1C,$1B,$1A,$19,$10,$11
  DC.B $24,$23,$22,$21,$20,$FF,$16,$0F,$0D,$09,$05,$01,$2B,$25,$28,$0E,$0A
  DC.B $06,$02,$2C,$26,$29,$13,$0B,$07,$03,$2D,$27,$2A,$12,$0C,$08,$04,$1F
  DC.B $1E,$1D,$1C,$1B,$1A,$19,$10,$11,$24,$23,$22,$21,$20,$FF,$16         *15a
  DC.B $D6,$80,$0F,$0D,$09,$05,$01,$2B,$2C,$2D,$0E,$0A,$06,$02,$25,$26,$27
  DC.B $13,$0B,$07,$03,$28,$29,$2A,$12,$0C,$08,$04,$1F,$1E,$1D,$1C,$1B,$1A
  DC.B $19,$10,$11,$24,$23,$22,$21,$20,$FF,$14,$0F,$0D,$09,$05,$01,$25,$18
  DC.B $16,$0E,$0A,$06,$02,$26,$FF,$15,$13,$0B,$07,$03,$27,$FF,$17         *15b
  DC.B $D6,$C0,$12,$0C,$08,$04,$36,$0F,$7C,$3C,$BB,$15,$08,$02,$32,$37,$16
  DC.B $3C,$CE,$51,$A4,$3A,$E6,$00,$38,$D7,$2A,$BD,$D8,$6E,$33,$3C,$CE,$51
  DC.B $A4,$3A,$E6,$00,$38,$D7,$2A,$BD,$D8,$6E,$14,$08,$02,$36,$07,$7A,$3C
  DC.B $BB,$26,$02,$84,$EF,$06,$32,$39,$36,$0F,$7C,$3C,$BB,$15,$28         *15c
  DC.B $D7,$00,$08,$15,$00,$38,$14,$00,$78,$32,$37,$16,$D7,$2A,$BD,$D8,$6E
  DC.B $33,$D7,$2A,$BD,$D8,$6E,$15,$00,$38,$14,$28,$08,$36,$07,$7A,$3C,$BB
  DC.B $26,$02,$84,$EF,$06,$32,$39,$36,$0F,$7C,$3C,$BB,$15,$28,$08,$15,$00
  DC.B $40,$97,$2A,$BD,$D8,$6E,$D7,$2A,$BD,$D8,$6E,$86,$FF,$14,$00         *15d
  DC.B $D7,$40,$40,$97,$2A,$BD,$D8,$6E,$14,$28,$08,$36,$07,$7A,$3C,$BB,$26
  DC.B $02,$84,$EF,$06,$32,$32,$39,$36,$0F,$7C,$3C,$BB,$15,$00,$38,$14,$00
  DC.B $70,$32,$37,$16,$3C,$CE,$51,$A4,$3A,$E6,$00,$38,$D7,$2A,$BD,$D8,$6E
  DC.B $33,$3C,$CE,$51,$A4,$3A,$E6,$00,$38,$D7,$2A,$BD,$D8,$6E,$15         *15e
  DC.B $D7,$80,$00,$38,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$39,$36
  DC.B $37,$C6,$80,$86,$3E,$BD,$D6,$C4,$33,$32,$18,$3C,$36,$0F,$7C,$3C,$BB
  DC.B $15,$08,$02,$33,$CA,$80,$3C,$CE,$51,$A4,$3A,$E6,$00,$38,$D7,$2A,$BD
  DC.B $D8,$6E,$18,$38,$18,$8F,$36,$3C,$CE,$51,$A4,$3A,$E6,$00,$38         *15f
  DC.B $D7,$C0,$D7,$2A,$BD,$D8,$6E,$33,$3C,$CE,$51,$A4,$3A,$E6,$00,$38,$D7
  DC.B $2A,$BD,$D8,$6E,$14,$08,$02,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06
  DC.B $32,$36,$37,$C6,$00,$86,$3E,$BD,$D6,$C4,$33,$32,$39,$37,$0F,$7C,$3C
  DC.B $BB,$15,$08,$02,$8A,$01,$16,$3C,$CE,$51,$A4,$3A,$E6,$00,$38         *160
  DC.B $D8,$00,$D7,$2A,$BD,$D8,$6E,$C6,$5C,$D7,$28,$15,$09,$08,$C6,$FF,$D7
  DC.B $2A,$BD,$D8,$6E,$96,$2A,$16,$3C,$CE,$51,$A4,$3A,$E6,$00,$38,$17,$14
  DC.B $08,$02,$C6,$58,$D7,$28,$14,$09,$08,$36,$07,$7A,$3C,$BB,$26,$02,$84
  DC.B $EF,$06,$32,$33,$39,$37,$0F,$7C,$3C,$BB,$15,$28,$08,$15,$00         *161
  DC.B $D8,$40,$38,$14,$00,$78,$8A,$80,$16,$D7,$2A,$8D,$23,$15,$09,$08,$C6
  DC.B $FF,$D7,$2A,$8D,$1A,$96,$2A,$16,$17,$15,$00,$38,$14,$09,$08,$14,$28
  DC.B $08,$36,$07,$7A,$3C,$BB,$26,$02,$84,$EF,$06,$32,$33,$39,$13,$29,$80
  DC.B $FC,$39,$36,$37,$3C,$CE,$51,$A4,$CC,$00,$00,$37,$0C,$56,$49         *162
  DC.B $D8,$80,$56,$49,$56,$49,$56,$49,$56,$49,$56,$49,$56,$49,$56,$49,$A7
  DC.B $00,$08,$33,$C1,$FF,$27,$03,$5C,$20,$E3,$38,$33,$32,$39,$CE,$52,$B4
  DC.B $86,$55,$A7,$00,$86,$AA,$A7,$02,$86,$29,$A7,$04,$86,$92,$A7,$06,$86
  DC.B $22,$A7,$10,$39,$37,$36,$3C,$BD,$B9,$53,$44,$44,$44,$44,$B7         *163
  DC.B $D8,$C0,$52,$C7,$16,$BD,$B9,$53,$4D,$27,$50,$81,$0E,$23,$14,$81,$FD
  DC.B $26,$02,$20,$0E,$81,$FE,$26,$04,$86,$0F,$20,$06,$81,$FF,$26,$3A,$86
  DC.B $10,$C1,$0A,$24,$34,$81,$10,$26,$08,$F7,$52,$C9,$BD,$CC,$E0,$26,$28
  DC.B $0D,$F6,$52,$C7,$27,$04,$5A,$26,$0A,$0C,$16,$BD,$D9,$85,$F6         *164
  DC.B $D9,$00,$52,$C7,$20,$13,$F6,$52,$C7,$BD,$DB,$CD,$6D,$00,$27,$0B,$8D
  DC.B $20,$27,$02,$20,$03,$BD,$DB,$9B,$8D,$1E,$38,$32,$33,$39,$36,$86,$80
  DC.B $43,$A4,$01,$A7,$01,$32,$39,$36,$86,$80,$AA,$01,$A7,$01,$32,$39,$36
  DC.B $86,$80,$A5,$01,$32,$39,$18,$3C,$3C,$36,$37,$18,$30,$CE,$52         *165
  DC.B $D9,$40,$A4,$81,$FD,$27,$09,$18,$E6,$01,$5A,$3A,$C6,$01,$20,$02,$C6
  DC.B $10,$18,$A6,$00,$A7,$00,$08,$5A,$26,$F7,$33,$32,$38,$18,$38,$39,$37
  DC.B $36,$3C,$BD,$B9,$53,$16,$BD,$B9,$53,$C4,$0F,$C1,$06,$25,$0B,$C1,$0A
  DC.B $24,$07,$BD,$DB,$CD,$A7,$00,$20,$07,$C6,$1A,$86,$C2,$BD,$BE         *166
  DC.B $D9,$80,$D4,$38,$32,$33,$39,$3C,$37,$36,$07,$C1,$FD,$27,$6E,$C1,$0C
  DC.B $22,$0D,$85,$01,$27,$05,$BD,$DA,$49,$20,$6D,$8D,$6F,$20,$69,$C1,$0F
  DC.B $26,$0E,$85,$01,$27,$05,$BD,$DA,$FE,$20,$5C,$BD,$DB,$09,$20,$57,$C1
  DC.B $10,$26,$0E,$85,$01,$27,$05,$14,$08,$20,$20,$4A,$15,$08,$20         *167
  DC.B $D9,$C0,$20,$45,$C1,$0D,$26,$19,$85,$01,$27,$0A,$B6,$14,$30,$8A,$80
  DC.B $B7,$14,$30,$20,$33,$86,$80,$43,$B4,$14,$30,$B7,$14,$30,$20,$28,$C1
  DC.B $0E,$26,$24,$85,$01,$27,$0A,$B6,$14,$30,$8A,$08,$B7,$14,$30,$20,$16
  DC.B $B6,$14,$30,$84,$F7,$B7,$14,$30,$20,$0C,$85,$01,$27,$05,$BD         *168
  DC.B $DA,$00,$DA,$BA,$20,$03,$BD,$DA,$95,$32,$33,$38,$39,$37,$36,$18,$3C
  DC.B $17,$81,$08,$22,$18,$4A,$BD,$BA,$64,$16,$86,$24,$BD,$D7,$ED,$36,$18
  DC.B $30,$18,$EA,$00,$32,$86,$24,$BD,$D6,$C4,$20,$18,$80,$09,$BD,$BA,$64
  DC.B $16,$86,$26,$BD,$D7,$ED,$36,$18,$30,$53,$18,$E4,$00,$32,$86         *169
  DC.B $DA,$40,$26,$BD,$D6,$C4,$18,$38,$32,$33,$39,$37,$36,$18,$3C,$17,$81
  DC.B $08,$22,$19,$4A,$BD,$BA,$64,$16,$86,$24,$BD,$D7,$ED,$36,$18,$30,$53
  DC.B $18,$E4,$00,$32,$86,$24,$BD,$D6,$C4,$20,$17,$80,$09,$BD,$BA,$64,$16
  DC.B $86,$26,$BD,$D7,$ED,$36,$18,$30,$18,$EA,$00,$32,$86,$26,$BD         *16a
  DC.B $DA,$80,$D6,$C4,$18,$38,$32,$33,$39,$37,$BD,$D8,$9D,$BD,$DA,$BA,$C6
  DC.B $0F,$F7,$52,$C8,$33,$39,$36,$37,$C6,$FF,$86,$24,$BD,$D6,$C4,$33,$32
  DC.B $36,$37,$C6,$00,$86,$26,$BD,$D6,$C4,$33,$32,$15,$08,$20,$8D,$59,$86
  DC.B $88,$43,$B4,$14,$30,$B7,$14,$30,$39,$36,$37,$C6,$00,$86,$24         *16b
  DC.B $DA,$C0,$BD,$D6,$C4,$33,$32,$36,$37,$C6,$0F,$86,$26,$BD,$D6,$C4,$33
  DC.B $32,$14,$08,$20,$8D,$29,$86,$88,$BA,$14,$30,$B7,$14,$30,$39,$7D,$52
  DC.B $CA,$26,$12,$36,$37,$C6,$24,$86,$0A,$18,$CE,$DA,$DE,$BD,$86,$5D,$33
  DC.B $32,$BD,$DB,$14,$39,$36,$86,$01,$B7,$52,$CA,$32,$39,$37,$F6         *16c
  DC.B $DB,$00,$14,$20,$CA,$08,$F7,$14,$20,$33,$39,$37,$F6,$14,$20,$C4,$F7
  DC.B $F7,$14,$20,$33,$39,$37,$F6,$52,$C8,$0D,$BD,$D9,$85,$C1,$01,$23,$04
  DC.B $C0,$02,$20,$09,$5D,$27,$04,$C6,$0E,$20,$02,$C6,$0F,$0C,$BD,$D9,$85
  DC.B $F7,$52,$C8,$C6,$10,$13,$08,$20,$06,$0C,$BD,$D9,$85,$20,$04         *16d
  DC.B $DB,$40,$0D,$BD,$D9,$85,$33,$39,$37,$36,$3C,$18,$3C,$E6,$03,$C0,$0F
  DC.B $F7,$52,$C6,$8D,$79,$BD,$D9,$1D,$8D,$39,$18,$CE,$52,$A4,$4F,$18,$E6
  DC.B $00,$C4,$0F,$F1,$52,$C6,$26,$05,$36,$4C,$8D,$0E,$32,$18,$08,$4C,$81
  DC.B $10,$26,$EA,$18,$38,$38,$32,$33,$39,$37,$C6,$40,$E5,$01,$27         *16e
  DC.B $DB,$80,$03,$0C,$20,$01,$0D,$16,$BD,$D9,$85,$BD,$D9,$30,$26,$02,$8D
  DC.B $0B,$33,$39,$37,$C6,$40,$E8,$01,$E7,$01,$33,$39,$18,$3C,$36,$37,$3C
  DC.B $8F,$38,$83,$52,$B4,$54,$CB,$02,$86,$40,$A5,$01,$26,$07,$A6,$00,$84
  DC.B $0F,$48,$20,$07,$A6,$00,$84,$F0,$44,$44,$44,$CB,$0F,$18,$CE         *16f
  DC.B $DB,$C0,$DB,$46,$BD,$86,$5D,$BD,$D9,$27,$33,$32,$18,$38,$39,$37,$CE
  DC.B $52,$B4,$C0,$02,$58,$3A,$33,$39,$3C,$37,$CE,$52,$A4,$C6,$10,$5A,$3A
  DC.B $E6,$00,$F7,$52,$C9,$6F,$00,$33,$38,$39,$14,$08,$20,$39,$13,$08,$20
  DC.B $05,$15,$08,$20,$20,$03,$14,$08,$20,$39,$3C,$36,$37,$C6,$10         *170
  DC.B $DC,$00,$B6,$52,$C9,$27,$07,$81,$01,$26,$09,$0C,$20,$01,$0D,$BD,$D9
  DC.B $85,$20,$0C,$16,$BD,$DB,$CD,$BD,$D9,$30,$26,$03,$BD,$DB,$9B,$86,$10
  DC.B $F6,$52,$C9,$BD,$D9,$37,$33,$32,$38,$39,$28,$01,$24,$4D,$54,$4C,$34
  DC.B $31,$35,$30,$5C,$5C,$5C,$5C,$4D,$69,$74,$65,$6C,$20,$53,$53         *171
  DC.B $DC,$40,$34,$31,$35,$30,$20,$52,$53,$32,$33,$32,$20,$50,$68,$6F,$6E
  DC.B $65,$39,$45,$29,$FF,$28,$01,$24,$4D,$54,$4C,$34,$31,$32,$35,$5C,$5C
  DC.B $5C,$5C,$4D,$69,$74,$65,$6C,$20,$53,$53,$34,$31,$32,$35,$20,$52,$53
  DC.B $32,$33,$32,$20,$50,$68,$6F,$6E,$65,$41,$32,$29,$FF,$14,$40         *172
  DC.B $DC,$80,$14,$50,$14,$60,$14,$70,$14,$80,$14,$90,$14,$A0,$14,$B0,$14
  DC.B $C0,$14,$D0,$14,$E0,$14,$F0,$93,$63,$2F,$3F,$A3,$C3,$87,$8B,$15,$05
  DC.B $11,$09,$01,$00,$00,$00,$00,$08,$00,$00,$00,$01,$00,$00,$00,$01,$00
  DC.B $00,$00,$01,$00,$00,$00,$01,$00,$01,$00,$09,$00,$00,$00,$01         *173
  DC.B $DC,$C0,$00,$00,$00,$01,$00,$00,$00,$01,$00,$00,$00,$01,$00,$00,$00
  DC.B $02,$00,$01,$00,$02,$00,$01,$00,$02,$00,$01,$00,$02,$00,$01,$00,$02
  DC.B $00,$00,$00,$03,$00,$01,$00,$03,$00,$02,$00,$03,$00,$03,$00,$03,$00
  DC.B $04,$00,$03,$00,$00,$00,$01,$00,$01,$00,$04,$00,$02,$00,$04         *174
  DC.B $DD,$00,$00,$03,$00,$08,$00,$04,$00,$08,$00,$00,$00,$01,$00,$00,$00
  DC.B $01,$00,$00,$00,$01,$00,$03,$00,$08,$00,$04,$00,$08,$00,$00,$00,$08
  DC.B $00,$00,$00,$01,$00,$00,$00,$01,$00,$00,$00,$01,$00,$00,$00,$01,$00
  DC.B $00,$00,$08,$00,$02,$00,$07,$00,$02,$00,$08,$00,$04,$00,$07         *175
  DC.B $DD,$40,$00,$04,$00,$08,$00,$00,$00,$08,$00,$03,$00,$06,$00,$04,$00
  DC.B $06,$00,$03,$00,$06,$00,$04,$00,$06,$00,$00,$00,$08,$00,$03,$00,$08
  DC.B $00,$04,$00,$08,$00,$03,$00,$08,$00,$04,$00,$08,$00,$00,$00,$08,$00
  DC.B $01,$00,$06,$00,$02,$00,$06,$00,$01,$00,$06,$00,$02,$00,$06         *176
  DC.B $DD,$80,$00,$00,$00,$08,$00,$01,$00,$04,$00,$02,$00,$04,$00,$01,$00
  DC.B $04,$00,$02,$00,$04,$00,$00,$00,$08,$00,$01,$00,$08,$00,$02,$00,$08
  DC.B $00,$01,$00,$08,$00,$02,$00,$08,$00,$00,$00,$08,$00,$01,$00,$05,$00
  DC.B $01,$00,$05,$00,$03,$00,$05,$00,$03,$00,$05,$FF,$FF,$FF,$FF         *177
  DC.B $E7,$C0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$6B,$FB         *178
*
******************************************
*      Summary (from reformat tool)       
*      ----------------------------       
*  F/W revision: "MAIN 6.4  ", "C.5"
*
*  Device type detected : Not Available
*  bytes for loading    : 24064 dec
*  lines for loading    : 0x178
*  lowest code address  : 0x8000
*  highest code address : 0xddbf
*  sum range start addr : 0x8000
*  sum range   end addr : 0xe7fd
*  sum                  : 0x72b2
*
*  check sum = 0xDEAD - 0x72b2 = 0x6bfb
******************************************
fw_ss4150_end:
	END
