*FW4150HR2.S--------------------EDITION B20--04/01/08 11:02--CAMELON------------
	TTL	set_firmware_program
		SECTION ?fw_ss4150hr2
        XDEF    fw_ss4150hr2_start
        XDEF    fw_ss4150hr2_end
*************************************************************************
*       HISTORY
*
*  A02  14/12/99 E.E. Submitted file recieved from Craig French.
*  A03  22/12/99 E.E. Submitted file recieved from C.F. - no associated
*                     dpars
*  A04  19/01/00 E.E. File copied from Mantis webpage - bularo fixes 
*                     p.17864 and p.17869
*  A05  28/01/00 E.E. Downloaded from mantis webpage - bularo fixes
*                     p.17864 & p.17869
*  A06  07/03/00 E.E. Downloaded from mantis webpage - bularo fixes
*                     p.17889, p.17883, p.17892, p.17886
*  A07  20/04/00 E.E. 
*  A08  17/05/00 E.E. 
*  A09  17/05/00 E.E. Downloaded from mantis webpage - p.18022,p.18036
*
*  G1010
*  B02  25/05/00 E.E. Added changes from B01 to A09 to create B02
*  B03  31/05/00 E.E. Added changes from A10 to create B03
*  B05  07/07/00 E.E. Downloaded from Mantis webpage - p.18178, p.18036
*  B06  26/07/00 E.E.
*  B07  08/08/00 E.E. p.18347,p.18318,p.18294,p.18235,p.18106,p.18328,
*                     p.18082,p.18171,p.18293 - bularo fixes from Mantis
*                     webpage
*  B08  31/08/00 C.S. New version provided by Craig French Aug 31, 2000 to 
* 		      build on L36.0.5
*  B09  06/09/00 E.E. p.18364,p.18030,p.18369 bularo fixes from Mantis 
*  		      webpage
*  B10  07/09/00 E.E. new version by Craig French
*  B12  17/01/01 E.E. new main8.16 - fix for p.18420
*  B14  14/05/01 E.E. new main8.18 - check release notice
*  B15  21/05/01 E.E. Section def in wrong case.
*  B16  04/06/01 E.E. new main8.19 check release notice
*  B17  20/11/01 E.E. P.18926 fix from Ted Houghton
*
*************************************************************************
*
* Description
* ===========
* This file contains the firmware program for the SS4150 set. This data is
* accessed via a PASCAL pointer in handlers.pas. The first 3 bytes of the
* data below were added and are defined as below. The information in the
* this 3 byte header is contained here in order to avoid confusion when
* installing new firmware loads. The data size and version is maintained
* in these three bytes and therefore unique to this firware version.
*
* See DS.25 in SMS bularo 'Set Firmware Download' for more information
* on the SX200 download tool.
*
* This file is released from set firmware group and then compiled by
* Configuration Management into a SX200 load
*
* The tool used in the set firmware group is known as mantisfw.c 
*
*********************** FILE DATA FORMAT ************************
*   HEADER 3 bytes
*     byte1  software version (see MTS22 - Send Maintenance Data)
*                             (see NOTE below )
*     byte2  number of 66 byte lines to follow (high byte)
*     byte3  number of 66 byte lines to follow (low  byte)
*
*   FIRMWARE CODE 66 bytes per line (64 data + 2 or 4 addressing)
*   the choice between 16 (2 byte) or 32 (4 byte) bit addressing
*   is made when calling the mantisfw program.
* The remaining bytes are the actual code to be downloaded to 
* the set firmware.
*****************************************************************
*
* Maintenance Notes:
* ==================
* If your installing a new firmware version for the same set type/file
* name then you only have to update the data and header in this file.
* You do not have to update any other file. The 3-byte header info will
* tell the rest of the sx200 program about this data (size and version).
*
* If your installing firmware for a different set type that requires 
* different firmware then a new version of this file with a different name
* would have to be created. Also you must edit the files init.s, osinit.s
* and main.mak, sx200.mak files. Those file would have to be updated to
* include the new file name and pointers to the new firmware code.
* It is the  SECTION ?FW_SS4090   statement at the top of this
* file that acts as the label for locating this code. For example if you
* created a new file called fw4125.s then that statement would be
*   SECTION ?FW_SS4125  and dealt with in the make and init files.
*
* There must be enough room is the SECTION definition in sx200.mak and
* main.mak to handle the size of this firmware code without running
* into the next section.
*
* You must XDEF in OSINIT.C a pointer in this SECTION to this data .
* The current SW version is calculated in INIT.PAS from this data.
* The first byte of this file is the version of the firmware and is put
* in automatically by the srec_to_sx200.c reformat tool. It is extracted
* from the firmware data itself usually at byte number 16.
* Also the number of 64 bytes of code lines for writing to the set is
* automatically generated and placed in bytes 2 and 3 of the header.
*
*
*       NOTES: There are 2 information in the BYTE of the firmware rev:
*              - BIT6 to BIT8 = firmware stream (A .. H)
*              - BIT1 to BIT5 = firmware revision number (0 .. 31)
*
*              For example, firmware rev BYTE = $4A  equivalent to C.10
*
*              stream = C    revision number = 10
*               ___|___     _______|_______ 
*              /       \   /               \
*              B8  B7  B6  B5  B4  B3  B2  B1
*               0   1   0   0   1   0   1   0  = $4A
*
*
*************************************************************************
fw_ss4150hr2_start:
  DC.B $95,$01,$F0  * Header: version + num lines to follow (hi byte,lo byte)
  DC.B $0,$4,$0,$60,$5A,$0,$0,$0,$F8,$7B,$0,$0,$83,$EE,$2B,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$11,$8,$0,$60,$0,$0,$0,$0,$E2,$3,$0,$0
  DC.B $1,$20,$3,$49,$8,$80,$3,$48,$1,$88,$1,$31,$1,$80,$70,$47,$88
  DC.B $29,$0,$40,$D8,$27,$0,$40,$0,$20,$3,$49,$8,$80,$3,$48         *1
  DC.B $40,$4,$0,$60,$1,$88,$1,$31,$1,$80,$70,$47,$88,$29,$0,$40,$D8,$27,$0
  DC.B $40,$B,$49,$4A,$68,$92,$9,$92,$1,$83,$6,$9B,$E,$1A,$43,$4A,$60
  DC.B $21,$28,$0,$DA,$20,$20,$3A,$28,$0,$DD,$3B,$20,$1F,$38,$40,$10,$4
  DC.B $49,$48,$80,$4,$48,$1,$88,$1,$31,$1,$80,$70,$47,$0,$0         *2
  DC.B $80,$4,$0,$60,$FC,$5,$1,$0,$88,$29,$0,$40,$D8,$27,$0,$40,$0,$B5,$1
  DC.B $1C,$5,$4A,$11,$80,$5,$49,$A,$88,$1,$32,$A,$80,$4,$49,$89,$68
  DC.B $FF,$F7,$D0,$FD,$8,$BC,$18,$47,$88,$29,$0,$40,$D8,$27,$0,$40,$70
  DC.B $29,$0,$40,$3,$49,$48,$81,$3,$48,$1,$88,$1,$31,$1,$80         *3
  DC.B $C0,$4,$0,$60,$70,$47,$0,$0,$88,$29,$0,$40,$D8,$27,$0,$40,$90,$B4,$2
  DC.B $1C,$1A,$49,$CB,$1D,$F9,$33,$CF,$1D,$FF,$37,$7A,$37,$18,$48,$80,$31
  DC.B $0,$2A,$13,$D0,$CA,$6B,$2,$60,$A,$6C,$42,$60,$DA,$6B,$82,$60,$CA
  DC.B $69,$2,$61,$7A,$6A,$42,$61,$12,$48,$C8,$61,$12,$48,$C8,$63         *4
  DC.B $0,$5,$0,$60,$12,$48,$8,$64,$12,$48,$D8,$63,$12,$48,$13,$E0,$0,$22,$0
  DC.B $E0,$1,$32,$94,$0,$4,$59,$0,$2C,$1,$D1,$6,$2A,$F8,$DB,$6,$2A
  DC.B $9,$DA,$2,$68,$CA,$63,$42,$68,$A,$64,$82,$68,$DA,$63,$2,$69,$CA
  DC.B $61,$40,$69,$78,$62,$90,$BC,$70,$47,$0,$0,$AC,$1,$1,$0         *5
  DC.B $40,$5,$0,$60,$70,$29,$0,$40,$51,$4,$0,$60,$21,$4,$0,$60,$39,$4,$0
  DC.B $60,$8D,$4,$0,$60,$28,$A,$1,$0,$0,$20,$B,$49,$8,$60,$B,$49
  DC.B $8,$60,$B,$49,$8,$60,$B,$49,$8,$60,$B,$49,$8,$60,$B,$49,$8
  DC.B $60,$B,$4A,$B,$49,$A,$60,$8,$73,$48,$75,$88,$61,$A,$48         *6
  DC.B $80,$5,$0,$60,$88,$60,$8,$1D,$8,$61,$70,$47,$34,$28,$0,$40,$38,$28,$0
  DC.B $40,$3C,$28,$0,$40,$40,$28,$0,$40,$44,$28,$0,$40,$48,$28,$0,$40
  DC.B $4C,$3D,$0,$60,$DC,$27,$0,$40,$94,$29,$0,$40,$B0,$B4,$3,$6,$1B
  DC.B $E,$38,$48,$81,$69,$1,$31,$81,$61,$5,$7B,$1,$27,$0,$22         *7
  DC.B $C0,$5,$0,$60,$0,$2D,$E,$D0,$7C,$7,$1,$1D,$1,$2D,$25,$D0,$2,$2D,$21
  DC.B $D1,$45,$7D,$0,$2D,$39,$D1,$B,$70,$47,$75,$C1,$89,$1,$31,$C1,$81
  DC.B $43,$E0,$2D,$4D,$44,$7D,$2B,$55,$63,$1C,$43,$75,$43,$7D,$2,$2B,$10
  DC.B $DD,$83,$68,$1C,$88,$A1,$42,$C,$D1,$7,$73,$42,$75,$7,$75         *8
  DC.B $0,$6,$0,$60,$19,$88,$49,$8,$C1,$75,$C0,$7D,$40,$0,$C1,$18,$40,$39,$C9
  DC.B $8F,$5,$31,$19,$52,$B0,$BC,$70,$47,$47,$7D,$CB,$55,$7B,$1C,$43,$75
  DC.B $43,$7D,$2,$2B,$F6,$D1,$3,$69,$1B,$88,$C3,$81,$42,$75,$C3,$89,$63
  DC.B $84,$C7,$89,$1,$23,$9B,$3,$9F,$42,$1,$DB,$1,$23,$0,$E0         *9
  DC.B $40,$6,$0,$60,$0,$23,$83,$75,$4A,$70,$2,$21,$20,$E0,$49,$19,$20,$39,$C9
  DC.B $7F,$9,$2,$19,$43,$21,$84,$81,$7D,$0,$29,$5,$D1,$41,$7D,$2,$29
  DC.B $2,$DA,$1,$31,$41,$75,$0,$E0,$42,$75,$1,$7D,$4B,$0,$84,$68,$E3
  DC.B $5A,$84,$69,$A3,$42,$CD,$D1,$C3,$7D,$99,$42,$5,$DA,$1,$31         *a
  DC.B $80,$6,$0,$60,$1,$75,$7,$73,$42,$75,$B0,$BC,$70,$47,$3,$21,$1,$73,$B0
  DC.B $BC,$70,$47,$0,$0,$DC,$27,$0,$40,$94,$29,$0,$40,$2,$49,$A,$68
  DC.B $10,$78,$1,$32,$A,$60,$70,$47,$DC,$27,$0,$40,$F3,$B5,$81,$B0,$1
  DC.B $98,$44,$1C,$F,$1C,$1C,$48,$4,$60,$0,$20,$0,$F0,$42,$F8         *b
  DC.B $C0,$6,$0,$60,$20,$1C,$1A,$4D,$E9,$1D,$79,$31,$A,$6E,$5C,$21,$FF,$F7,$BC
  DC.B $FC,$17,$49,$8,$60,$0,$20,$17,$49,$0,$91,$8,$60,$16,$49,$8,$60
  DC.B $1,$20,$0,$F0,$2F,$F8,$15,$48,$A,$23,$0,$22,$41,$21,$6C,$6C,$FF
  DC.B $F7,$AE,$FC,$0,$24,$8,$E0,$BB,$88,$FA,$88,$39,$7A,$38,$68         *c
  DC.B $0,$7,$0,$60,$6E,$6C,$FF,$F7,$A9,$FC,$1,$34,$C,$37,$1,$98,$84,$42,$F3
  DC.B $DB,$0,$99,$8,$68,$20,$30,$A,$49,$9,$68,$FF,$F7,$93,$FC,$1,$B0
  DC.B $FC,$BC,$8,$BC,$18,$47,$0,$0,$24,$1,$1,$0,$AC,$1,$1,$0,$10
  DC.B $1,$1,$0,$14,$1,$1,$0,$18,$1,$1,$0,$E8,$58,$0,$0         *d
  DC.B $40,$7,$0,$60,$C8,$3A,$0,$60,$F0,$B5,$7,$1C,$81,$B0,$B,$4E,$33,$68,$B
  DC.B $4D,$2A,$68,$B,$4C,$21,$68,$B,$48,$0,$90,$0,$78,$0,$F0,$14,$F8
  DC.B $38,$1C,$21,$1C,$2A,$1C,$33,$1C,$0,$F0,$1E,$F8,$0,$98,$7,$70,$1
  DC.B $B0,$F0,$BC,$8,$BC,$18,$47,$88,$0,$1,$0,$84,$0,$1,$0         *e
  DC.B $80,$7,$0,$60,$80,$0,$1,$0,$F8,$27,$0,$40,$90,$B4,$1F,$1C,$C,$23,$43
  DC.B $43,$4,$4C,$E1,$50,$43,$0,$18,$18,$80,$0,$0,$19,$42,$60,$87,$60
  DC.B $90,$BC,$70,$47,$D0,$29,$0,$40,$90,$B4,$1F,$1C,$C,$23,$43,$43,$6
  DC.B $4C,$E3,$58,$B,$60,$43,$0,$18,$18,$80,$0,$0,$19,$41,$68         *f
  DC.B $C0,$7,$0,$60,$11,$60,$80,$68,$38,$60,$90,$BC,$70,$47,$0,$0,$D0,$29,$0
  DC.B $40,$80,$B4,$0,$27,$D,$49,$0,$28,$5,$D1,$8,$68,$82,$68,$2,$62
  DC.B $8,$68,$87,$60,$8,$E0,$A,$68,$93,$68,$3,$40,$8,$D0,$13,$62,$8
  DC.B $68,$82,$68,$9A,$43,$82,$60,$8,$68,$C7,$60,$80,$BC,$70,$47         *10
  DC.B $0,$8,$0,$60,$13,$1C,$52,$69,$A,$60,$D8,$60,$80,$BC,$70,$47,$14,$1,$1
  DC.B $0,$F0,$B5,$81,$B0,$42,$48,$43,$49,$1,$60,$43,$48,$4,$1C,$43,$4F
  DC.B $F9,$1D,$79,$31,$C9,$6D,$FF,$F7,$D,$FC,$22,$1C,$40,$49,$41,$48,$41
  DC.B $4C,$23,$68,$FF,$F7,$A,$FC,$40,$4A,$41,$49,$41,$48,$23,$68         *11
  DC.B $40,$8,$0,$60,$FF,$F7,$4,$FC,$40,$4A,$41,$49,$41,$48,$23,$68,$5,$1C,$FF
  DC.B $F7,$FD,$FB,$40,$4A,$16,$1C,$40,$48,$0,$90,$40,$49,$B,$68,$0,$21
  DC.B $FF,$F7,$F4,$FB,$3,$23,$1B,$2,$F8,$18,$0,$6B,$FF,$F7,$E8,$FB,$4
  DC.B $1C,$F8,$1D,$F9,$30,$0,$6A,$FF,$F7,$E2,$FB,$38,$49,$A,$68         *12
  DC.B $80,$8,$0,$60,$38,$4B,$1A,$40,$0,$7,$0,$F,$C0,$1,$10,$43,$8,$60,$36
  DC.B $A0,$3B,$49,$8,$60,$3B,$48,$3A,$21,$0,$F0,$8C,$F8,$0,$20,$FF,$F7
  DC.B $51,$FF,$0,$98,$82,$19,$1,$20,$11,$1C,$2B,$1C,$FF,$F7,$6C,$FF,$35
  DC.B $48,$36,$49,$8,$60,$9,$20,$35,$49,$8,$80,$A,$20,$35,$49         *13
  DC.B $C0,$8,$0,$60,$8,$70,$1,$20,$34,$49,$8,$70,$99,$2C,$18,$D0,$17,$20,$0
  DC.B $3,$41,$68,$32,$4B,$19,$40,$41,$60,$1,$68,$19,$40,$1,$60,$1,$20
  DC.B $FF,$F7,$30,$FF,$80,$20,$2E,$49,$8,$80,$5,$23,$DB,$1,$F8,$18,$41
  DC.B $69,$1,$20,$FF,$F7,$A6,$FB,$0,$20,$FF,$F7,$23,$FF,$9B,$2C         *14
  DC.B $0,$9,$0,$60,$9,$D1,$28,$48,$9,$21,$0,$F0,$55,$F8,$27,$48,$27,$49,$8
  DC.B $60,$2,$20,$27,$49,$8,$80,$1,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0
  DC.B $8,$80,$0,$E0,$64,$0,$0,$1,$88,$1,$0,$0,$AC,$1,$1,$0,$0
  DC.B $55,$0,$60,$2C,$9,$1,$0,$B4,$3A,$0,$60,$70,$29,$0,$0         *15
  DC.B $40,$9,$0,$60,$88,$56,$0,$60,$0,$0,$0,$40,$30,$1,$0,$0,$0,$0,$0
  DC.B $60,$0,$7E,$0,$40,$0,$2F,$0,$0,$70,$29,$0,$40,$B8,$3A,$0,$60
  DC.B $3C,$0,$1,$0,$7F,$F8,$FF,$FF,$42,$4F,$4F,$54,$20,$38,$2E,$36,$20
  DC.B $20,$20,$4D,$41,$49,$4E,$20,$38,$2E,$32,$30,$0,$0,$0,$0         *16
  DC.B $80,$9,$0,$60,$30,$0,$1,$0,$70,$38,$0,$60,$4,$38,$0,$60,$34,$0,$1
  DC.B $0,$38,$0,$1,$0,$D8,$0,$1,$0,$DC,$0,$1,$0,$FF,$FF,$FF,$EF
  DC.B $68,$0,$1,$0,$40,$3A,$0,$60,$C8,$3C,$0,$60,$9C,$0,$1,$0,$D8
  DC.B $28,$0,$40,$80,$B4,$6,$4A,$6,$E0,$0,$23,$C3,$5E,$9B,$0         *17
  DC.B $C0,$9,$0,$60,$47,$68,$D7,$50,$8,$30,$1,$39,$0,$29,$F6,$D1,$80,$BC,$70
  DC.B $47,$AC,$1,$1,$0,$80,$B5,$F,$4F,$7A,$6B,$51,$1E,$79,$63,$0,$2A
  DC.B $D,$D1,$1,$1C,$0,$20,$FF,$F7,$2D,$FB,$1,$23,$B8,$63,$D8,$42,$0
  DC.B $D1,$FE,$E7,$78,$6C,$1,$30,$78,$64,$7,$20,$78,$63,$B9,$6B         *18
  DC.B $0,$A,$0,$60,$8,$A,$1,$D3,$1,$20,$0,$E0,$0,$20,$49,$0,$B9,$63,$80
  DC.B $BC,$8,$BC,$18,$47,$0,$28,$0,$40,$F3,$B5,$1,$25,$0,$24,$0,$26
  DC.B $7,$1C,$7,$E0,$38,$1C,$FF,$F7,$D5,$FF,$0,$28,$0,$D0,$2C,$43,$6D
  DC.B $0,$1,$36,$1,$99,$8E,$42,$F4,$DB,$20,$1C,$FC,$BC,$8,$BC         *19
  DC.B $40,$A,$0,$60,$18,$47,$F0,$B4,$2,$20,$81,$B0,$1A,$4A,$1B,$49,$1B,$4F,$1
  DC.B $26,$4,$1C,$0,$D5,$1,$34,$64,$10,$43,$0,$D4,$52,$CE,$52,$1,$30
  DC.B $B8,$42,$F5,$DD,$1,$20,$16,$4A,$16,$49,$FF,$27,$39,$37,$43,$0,$D3
  DC.B $52,$5C,$1C,$CC,$52,$1,$30,$B8,$42,$F8,$DD,$0,$21,$0,$20         *1a
  DC.B $80,$A,$0,$60,$11,$4C,$12,$4F,$12,$4D,$0,$95,$82,$0,$A1,$50,$43,$0,$FD
  DC.B $5E,$33,$1C,$AB,$40,$59,$18,$4B,$1E,$0,$9D,$AB,$50,$1,$30,$4,$28
  DC.B $F2,$DB,$1,$39,$B,$48,$81,$60,$10,$31,$C1,$60,$1,$B0,$F0,$BC,$70
  DC.B $47,$0,$0,$A4,$46,$0,$40,$88,$4B,$0,$40,$71,$2,$0,$0         *1b
  DC.B $C0,$A,$0,$60,$C0,$41,$0,$40,$32,$44,$0,$40,$A0,$41,$0,$40,$0,$28,$0
  DC.B $40,$B0,$41,$0,$40,$0,$28,$0,$40,$F0,$B4,$14,$4C,$14,$4A,$15,$4F
  DC.B $15,$4B,$40,$0,$1D,$5A,$4E,$0,$9E,$5B,$AD,$19,$10,$5E,$46,$0,$9D
  DC.B $53,$1,$28,$6,$D0,$41,$0,$51,$5E,$4D,$0,$79,$5F,$81,$42         *1c
  DC.B $0,$B,$0,$60,$0,$D1,$61,$5F,$1,$28,$EC,$D1,$19,$1C,$2,$23,$CA,$5E,$7D
  DC.B $23,$1B,$1,$9A,$42,$7,$D1,$9,$4A,$43,$0,$CF,$5E,$7F,$10,$CF,$52
  DC.B $1,$30,$90,$42,$F8,$DD,$F0,$BC,$70,$47,$0,$0,$32,$44,$0,$40,$A4
  DC.B $46,$0,$40,$C0,$41,$0,$40,$88,$4B,$0,$40,$71,$2,$0,$0         *1d
  DC.B $40,$B,$0,$60,$F0,$B5,$C7,$1D,$FF,$37,$33,$37,$78,$0,$84,$B0,$27,$4E,$31
  DC.B $5A,$1,$31,$31,$52,$26,$4D,$2C,$5E,$1,$2C,$42,$D0,$60,$0,$25,$49
  DC.B $9,$5E,$B9,$42,$1,$D1,$24,$49,$9,$5E,$38,$1C,$FF,$F7,$B4,$FF,$60
  DC.B $0,$1F,$49,$A,$5E,$0,$92,$51,$0,$1E,$4A,$53,$5E,$3,$93         *1e
  DC.B $80,$B,$0,$60,$A3,$42,$2,$D1,$1C,$4E,$75,$5E,$0,$E0,$3,$9D,$7A,$0,$2
  DC.B $92,$16,$4E,$B2,$5E,$6B,$0,$1,$93,$F3,$5E,$9A,$42,$1A,$DD,$15,$4A
  DC.B $3,$9B,$A3,$42,$2,$D1,$14,$4E,$77,$52,$0,$E0,$57,$52,$11,$5E,$B9
  DC.B $42,$3,$D1,$15,$52,$10,$4E,$31,$5E,$1,$E0,$E,$4E,$35,$52         *1f
  DC.B $C0,$B,$0,$60,$1,$9B,$B,$48,$C4,$52,$0,$9A,$2,$9B,$C2,$52,$28,$1C,$FF
  DC.B $F7,$83,$FF,$2F,$1C,$78,$0,$6,$49,$F,$5E,$78,$0,$C,$5E,$1,$2C
  DC.B $C6,$D1,$4,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$88,$4B,$0,$40,$A4
  DC.B $46,$0,$40,$C0,$41,$0,$40,$32,$44,$0,$40,$F0,$B5,$1,$24         *20
  DC.B $0,$C,$0,$60,$7,$1C,$D,$4E,$D,$4D,$38,$1C,$FF,$F7,$E4,$FE,$0,$28,$2
  DC.B $D0,$60,$0,$34,$5E,$1,$E0,$60,$0,$2C,$5E,$FF,$23,$39,$33,$9C,$42
  DC.B $F1,$DD,$E0,$1F,$FF,$38,$33,$38,$7,$1C,$FF,$F7,$89,$FF,$38,$1C,$F0
  DC.B $BC,$8,$BC,$18,$47,$0,$0,$32,$44,$0,$40,$C0,$41,$0,$40         *21
  DC.B $40,$C,$0,$60,$F3,$B5,$0,$24,$84,$B0,$FF,$F7,$FC,$FE,$38,$48,$38,$4F,$E3
  DC.B $43,$38,$63,$98,$42,$4,$D0,$37,$49,$3,$91,$37,$4A,$2,$92,$55,$E0
  DC.B $FE,$E7,$8E,$42,$F,$DA,$5,$99,$30,$1C,$FF,$F7,$EB,$F9,$B8,$6C,$1
  DC.B $30,$B8,$64,$20,$1C,$39,$6B,$E,$54,$F8,$68,$1,$34,$84,$42         *22
  DC.B $80,$C,$0,$60,$44,$D1,$0,$24,$42,$E0,$E,$20,$F1,$1F,$FA,$39,$FF,$F7,$4
  DC.B $FA,$5,$1C,$E,$21,$69,$43,$F0,$1F,$F7,$38,$41,$1A,$0,$91,$68,$0
  DC.B $3,$99,$9,$5E,$4,$98,$FF,$F7,$B7,$FE,$0,$99,$40,$18,$A9,$0,$2
  DC.B $9A,$51,$58,$40,$18,$25,$1A,$26,$1C,$0,$2D,$1,$DA,$F8,$68         *23
  DC.B $C0,$C,$0,$60,$2D,$18,$0,$20,$17,$E0,$38,$6B,$40,$5D,$5,$99,$FF,$F7,$BA
  DC.B $F9,$B8,$6C,$1,$30,$29,$1C,$B8,$64,$38,$6B,$42,$5C,$31,$1C,$42,$54
  DC.B $F8,$68,$1,$35,$1,$36,$86,$42,$0,$D1,$0,$26,$85,$42,$0,$D1,$0
  DC.B $25,$1,$98,$1,$30,$1,$90,$0,$99,$88,$42,$E3,$DB,$0,$99         *24
  DC.B $0,$D,$0,$60,$64,$18,$F8,$68,$84,$42,$1,$DB,$F8,$68,$24,$1A,$4,$98,$FF
  DC.B $F7,$75,$FF,$FF,$21,$1,$31,$6,$1C,$88,$42,$3,$D0,$7,$48,$0,$88
  DC.B $4,$28,$9E,$D0,$4,$B0,$FC,$BC,$8,$BC,$18,$47,$10,$3C,$0,$40,$0
  DC.B $28,$0,$40,$0,$28,$0,$40,$A0,$41,$0,$40,$D8,$28,$0,$40         *25
  DC.B $40,$D,$0,$60,$0,$20,$70,$47,$17,$21,$9,$3,$88,$68,$40,$C,$F,$D2,$48
  DC.B $68,$8,$4B,$18,$40,$48,$60,$8,$68,$18,$40,$8,$60,$88,$68,$80,$14
  DC.B $0,$7,$0,$F,$4A,$68,$DB,$43,$1A,$43,$4A,$60,$70,$47,$F,$20,$70
  DC.B $47,$0,$0,$FF,$FF,$FD,$FF,$17,$21,$9,$3,$48,$68,$7,$4B         *26
  DC.B $80,$D,$0,$60,$18,$40,$48,$60,$8,$68,$18,$40,$8,$60,$88,$68,$80,$14,$0
  DC.B $7,$0,$F,$4A,$68,$DB,$43,$1A,$43,$4A,$60,$70,$47,$FF,$FF,$FD,$FF
  DC.B $80,$B5,$7,$1C,$0,$D5,$1,$30,$40,$10,$E,$21,$8,$1A,$17,$21,$9
  DC.B $3,$89,$68,$89,$11,$C9,$7,$C9,$F,$1,$22,$51,$1A,$89,$0         *27
  DC.B $C0,$D,$0,$60,$40,$1A,$4,$49,$9,$68,$FF,$F7,$3D,$F9,$3,$48,$7,$70,$80
  DC.B $BC,$8,$BC,$18,$47,$98,$3A,$0,$60,$A8,$1,$1,$0,$B0,$B4,$10,$4A
  DC.B $15,$78,$C7,$0,$F,$48,$C4,$59,$F0,$23,$9D,$43,$24,$7,$24,$F,$24
  DC.B $1,$24,$6,$24,$E,$2B,$1C,$23,$43,$13,$70,$38,$18,$40,$68         *28
  DC.B $0,$E,$0,$60,$10,$71,$7,$29,$5,$D0,$8,$29,$7,$D1,$10,$78,$40,$8,$40
  DC.B $0,$2,$E0,$10,$78,$1,$23,$18,$43,$10,$70,$B0,$BC,$70,$47,$0,$0
  DC.B $4,$80,$1,$E0,$D4,$95,$0,$0,$0,$B5,$0,$28,$9,$D1,$8,$49,$9
  DC.B $68,$8A,$6,$D2,$F,$1,$2A,$7,$D0,$9,$5,$C9,$F,$1,$29         *29
  DC.B $40,$E,$0,$60,$3,$D0,$4,$49,$9,$68,$FF,$F7,$FD,$F8,$8,$BC,$18,$47,$0
  DC.B $0,$40,$0,$1,$0,$A8,$3A,$0,$60,$90,$B5,$42,$48,$0,$68,$FF,$F7
  DC.B $EF,$F8,$41,$4F,$38,$78,$0,$28,$10,$D0,$40,$4B,$9C,$78,$0,$22,$3F
  DC.B $49,$40,$48,$2,$2C,$32,$D0,$C1,$2C,$16,$D0,$C6,$2C,$8,$D0         *2a
  DC.B $80,$E,$0,$60,$D7,$2C,$3,$D1,$43,$7A,$0,$2B,$17,$D0,$42,$72,$90,$BC,$8
  DC.B $BC,$18,$47,$D8,$78,$8,$28,$3,$D0,$D,$28,$F7,$D1,$87,$20,$0,$E0
  DC.B $95,$20,$18,$71,$90,$BC,$8,$BC,$18,$47,$19,$79,$18,$1C,$1,$23,$19
  DC.B $43,$1,$71,$90,$BC,$8,$BC,$18,$47,$2F,$4A,$12,$68,$93,$D         *2b
  DC.B $C0,$E,$0,$60,$E4,$D2,$43,$68,$5B,$8,$5B,$0,$43,$60,$52,$D,$1,$D3,$1
  DC.B $22,$3E,$E0,$C8,$68,$FF,$F7,$B4,$F8,$90,$BC,$8,$BC,$18,$47,$DB,$78
  DC.B $65,$2B,$37,$D0,$13,$DC,$27,$2B,$D,$D0,$6,$DC,$0,$2B,$2C,$D0,$25
  DC.B $2B,$8,$D0,$26,$2B,$C9,$D1,$5,$E0,$28,$2B,$3,$D0,$29,$2B         *2c
  DC.B $0,$F,$0,$60,$1,$D0,$2A,$2B,$C2,$D1,$0,$21,$D8,$1F,$1D,$38,$25,$E0,$69
  DC.B $2B,$20,$D0,$6,$DC,$66,$2B,$1D,$D0,$67,$2B,$1B,$D0,$68,$2B,$B5,$D1
  DC.B $18,$E0,$6A,$2B,$16,$D0,$80,$2B,$6,$D0,$C0,$2B,$AE,$D1,$13,$48,$1
  DC.B $68,$13,$4B,$19,$40,$1,$60,$3A,$70,$12,$48,$1,$78,$20,$23         *2d
  DC.B $40,$F,$0,$60,$59,$40,$1,$70,$90,$BC,$8,$BC,$18,$47,$3,$68,$0,$2B,$9D
  DC.B $D0,$2,$60,$BE,$E7,$1,$21,$D8,$1F,$5D,$38,$2,$F0,$5F,$F9,$90,$BC
  DC.B $8,$BC,$18,$47,$88,$3A,$0,$60,$C4,$0,$1,$0,$EC,$5,$1,$0,$2C
  DC.B $2,$1,$0,$4C,$28,$0,$40,$40,$0,$1,$0,$A0,$0,$1,$0         *2e
  DC.B $80,$F,$0,$60,$FF,$FF,$FB,$FF,$DB,$0,$1,$0,$F0,$B5,$1B,$48,$0,$68,$81
  DC.B $7A,$8,$18,$C0,$7A,$9,$28,$28,$D1,$18,$4E,$F5,$1D,$FF,$35,$7A,$35
  DC.B $A8,$6F,$FF,$F7,$4D,$F8,$A8,$6F,$FF,$F7,$4A,$F8,$F4,$1D,$79,$34,$13
  DC.B $4F,$5,$28,$3,$D1,$78,$68,$40,$8,$40,$0,$7,$E0,$4,$28         *2f
  DC.B $C0,$F,$0,$60,$9,$D1,$A8,$6F,$FF,$F7,$3C,$F8,$1,$23,$78,$68,$18,$43,$78
  DC.B $60,$0,$20,$E1,$68,$4,$E0,$5,$23,$DB,$1,$F0,$18,$1,$69,$D0,$20
  DC.B $FF,$F7,$30,$F8,$F0,$BC,$8,$BC,$18,$47,$6,$48,$0,$68,$FF,$F7,$27
  DC.B $F8,$F0,$BC,$8,$BC,$18,$47,$44,$29,$0,$40,$AC,$1,$1,$0         *30
  DC.B $0,$10,$0,$60,$4C,$28,$0,$40,$90,$3A,$0,$60,$0,$B5,$17,$28,$11,$D0,$6
  DC.B $DC,$14,$28,$E,$D0,$15,$28,$C,$D0,$16,$28,$E,$D1,$9,$E0,$19,$28
  DC.B $5,$D0,$2D,$28,$5,$D0,$D2,$28,$7,$D1,$0,$F0,$13,$F8,$8,$BC,$18
  DC.B $47,$1,$F0,$D1,$F8,$8,$BC,$18,$47,$1,$C,$2,$D3,$1,$23         *31
  DC.B $40,$10,$0,$60,$DB,$3,$58,$40,$2,$49,$9,$68,$FE,$F7,$FC,$FF,$8,$BC,$18
  DC.B $47,$94,$3A,$0,$60,$F0,$B5,$0,$24,$0,$25,$82,$B0,$22,$48,$1,$90
  DC.B $80,$6F,$FE,$F7,$ED,$FF,$21,$4E,$F0,$70,$F0,$78,$20,$4F,$3,$28,$C
  DC.B $D1,$1,$98,$80,$6F,$FE,$F7,$E3,$FF,$1C,$49,$8,$71,$6,$1C         *32
  DC.B $80,$10,$0,$60,$1,$98,$C0,$6F,$FE,$F7,$DC,$FF,$B0,$42,$4,$D2,$39,$69,$19
  DC.B $48,$FE,$F7,$D8,$FF,$24,$E0,$F0,$1C,$14,$49,$88,$70,$70,$1D,$0,$90
  DC.B $1B,$E0,$5,$2C,$2,$DA,$11,$49,$8,$5D,$3,$E0,$1,$98,$80,$6F,$FE
  DC.B $F7,$C6,$FF,$B9,$69,$6,$1C,$FE,$F7,$C4,$FF,$8,$E0,$5,$2D         *33
  DC.B $C0,$10,$0,$60,$E4,$D0,$1,$20,$3,$DF,$B9,$69,$30,$1C,$FE,$F7,$BB,$FF,$1
  DC.B $35,$1,$23,$D8,$42,$F3,$D0,$0,$25,$1,$34,$0,$98,$A0,$42,$E0,$DC
  DC.B $2,$B0,$F0,$BC,$8,$BC,$18,$47,$2C,$3,$1,$0,$56,$28,$0,$40,$2C
  DC.B $4,$1,$0,$D2,$80,$0,$0,$F0,$B5,$0,$24,$7,$1C,$9,$4E         *34
  DC.B $0,$11,$0,$60,$9,$4D,$31,$5D,$1,$29,$2,$D1,$0,$2F,$0,$D1,$0,$21,$7
  DC.B $A0,$6A,$6C,$FE,$F7,$99,$FF,$1,$34,$5,$2C,$F2,$DB,$F0,$BC,$8,$BC
  DC.B $18,$47,$0,$0,$4,$3B,$0,$60,$2C,$4,$1,$0,$25,$63,$0,$0,$F0
  DC.B $B5,$40,$4F,$B8,$69,$0,$28,$A,$D1,$3F,$48,$0,$68,$FE,$F7         *35
  DC.B $40,$11,$0,$60,$7F,$FF,$0,$28,$34,$D0,$3D,$48,$0,$68,$FE,$F7,$79,$FF,$B8
  DC.B $61,$3B,$48,$C0,$69,$FE,$F7,$74,$FF,$1,$23,$5,$1C,$D8,$42,$27,$D0
  DC.B $FA,$7B,$0,$24,$0,$2A,$1E,$D0,$36,$49,$37,$48,$1,$2A,$22,$D0,$2
  DC.B $2A,$1D,$D1,$BB,$69,$DA,$79,$2E,$1C,$55,$1C,$DD,$71,$BB,$69         *36
  DC.B $80,$11,$0,$60,$D2,$18,$D6,$72,$3A,$7C,$1,$3A,$12,$6,$12,$E,$3A,$74,$F
  DC.B $D1,$BA,$69,$3,$68,$0,$20,$FE,$F7,$59,$FF,$BC,$61,$2B,$48,$1,$78
  DC.B $1,$31,$1,$70,$28,$E0,$12,$2D,$2,$D1,$1,$23,$FB,$73,$7C,$75,$F0
  DC.B $BC,$8,$BC,$18,$47,$26,$4E,$7A,$7D,$B5,$54,$13,$1C,$0,$2A         *37
  DC.B $C0,$11,$0,$60,$2,$D1,$32,$78,$83,$2A,$17,$D1,$5A,$1C,$7A,$75,$7A,$7D,$4
  DC.B $2A,$EE,$D1,$B3,$78,$32,$1C,$4,$2B,$9,$D1,$53,$78,$3,$2B,$6,$D1
  DC.B $D3,$78,$1,$2B,$3,$D1,$1,$20,$FF,$F7,$86,$FF,$4,$E0,$53,$78,$46
  DC.B $2B,$1,$DC,$3,$2B,$3,$DA,$FC,$73,$F0,$BC,$8,$BC,$18,$47         *38
  DC.B $0,$12,$0,$60,$1,$23,$BD,$69,$2B,$71,$D2,$23,$BD,$69,$EB,$72,$93,$78,$BD
  DC.B $69,$2B,$73,$D3,$78,$BD,$69,$6B,$73,$3,$23,$BD,$69,$EB,$71,$52,$78
  DC.B $3,$3A,$12,$6,$12,$E,$3A,$74,$B2,$D0,$2,$20,$F8,$73,$F0,$BC,$8
  DC.B $BC,$18,$47,$4C,$28,$0,$40,$FC,$3A,$0,$60,$F4,$3A,$0,$60         *39
  DC.B $40,$12,$0,$60,$2C,$4,$1,$0,$C8,$3B,$0,$40,$EC,$3A,$0,$60,$F6,$28,$0
  DC.B $40,$5D,$28,$0,$40,$F0,$B5,$6A,$48,$0,$23,$C0,$5E,$69,$49,$C9,$5E
  DC.B $88,$42,$1,$D0,$FF,$F7,$64,$FF,$17,$22,$12,$3,$90,$68,$C0,$9,$1
  DC.B $D2,$1,$20,$0,$E0,$0,$20,$0,$6,$0,$E,$62,$4F,$7B,$7F         *3a
  DC.B $80,$12,$0,$60,$62,$49,$0,$24,$62,$4D,$83,$42,$4C,$D0,$2B,$68,$5B,$6,$1B
  DC.B $F,$6,$2B,$1,$D0,$5,$2B,$44,$D1,$BB,$7F,$1,$2B,$1D,$D1,$0,$28
  DC.B $1B,$D1,$BC,$77,$56,$68,$5B,$3,$9E,$43,$56,$60,$16,$68,$1,$23,$5B
  DC.B $3,$9E,$43,$16,$60,$57,$4E,$36,$78,$43,$1F,$33,$40,$55,$4E         *3b
  DC.B $C0,$12,$0,$60,$33,$70,$55,$4E,$36,$68,$1,$23,$9B,$3,$9E,$43,$33,$1C,$52
  DC.B $4E,$33,$60,$E,$78,$80,$23,$9E,$43,$E,$70,$BB,$7F,$0,$2B,$20,$D1
  DC.B $0,$28,$1E,$D0,$1,$23,$BB,$77,$56,$68,$5B,$3,$9E,$43,$56,$60,$16
  DC.B $68,$1,$23,$5B,$3,$33,$43,$13,$60,$46,$4A,$16,$78,$4,$23         *3c
  DC.B $0,$13,$0,$60,$33,$43,$13,$70,$44,$4A,$1,$23,$9B,$3,$16,$68,$33,$43,$13
  DC.B $60,$A,$78,$80,$23,$1A,$43,$A,$70,$A,$7B,$92,$8,$52,$8,$0,$D3
  DC.B $78,$77,$78,$77,$A,$7B,$92,$8,$52,$8,$0,$D3,$78,$77,$38,$7A,$2
  DC.B $28,$1E,$DD,$39,$48,$0,$68,$39,$4A,$12,$68,$80,$1A,$7D,$23         *3d
  DC.B $40,$13,$0,$60,$1B,$1,$98,$42,$0,$D9,$3C,$72,$38,$7A,$3,$28,$14,$D0,$4
  DC.B $28,$19,$D0,$5,$28,$D,$D1,$8,$78,$40,$9,$40,$8,$9,$D2,$38,$7F
  DC.B $41,$1C,$39,$77,$5,$28,$4,$DD,$8,$21,$1,$20,$FF,$F7,$36,$FD,$3C
  DC.B $72,$F0,$BC,$8,$BC,$18,$47,$7,$21,$3,$20,$FF,$F7,$2E,$FD         *3e
  DC.B $80,$13,$0,$60,$3C,$77,$4,$20,$38,$E0,$38,$7F,$1,$30,$0,$6,$0,$E,$38
  DC.B $77,$2,$28,$EE,$DD,$3C,$77,$23,$4E,$29,$E0,$23,$4A,$11,$5C,$F2,$29
  DC.B $1E,$D1,$1,$30,$38,$77,$28,$68,$40,$6,$0,$F,$5,$28,$2,$D1,$38
  DC.B $7F,$2,$30,$38,$77,$38,$7F,$11,$1C,$12,$18,$52,$78,$9,$5C         *3f
  DC.B $C0,$13,$0,$60,$1A,$A0,$73,$6C,$FE,$F7,$42,$FE,$38,$7F,$1,$30,$38,$77,$28
  DC.B $68,$40,$6,$0,$F,$6,$28,$7,$D1,$38,$7F,$2,$30,$38,$77,$3,$E0
  DC.B $14,$A0,$72,$6C,$FE,$F7,$30,$FE,$38,$7F,$1,$30,$38,$77,$38,$7F,$32
  DC.B $28,$D2,$DB,$3C,$77,$5,$20,$38,$72,$F0,$BC,$8,$BC,$18,$47         *40
  DC.B $0,$14,$0,$60,$64,$0,$1,$0,$66,$0,$1,$0,$4C,$28,$0,$40,$0,$80,$1
  DC.B $E0,$3C,$0,$1,$0,$14,$80,$1,$E0,$14,$60,$0,$E0,$50,$0,$1,$0
  DC.B $FC,$27,$0,$40,$2C,$4,$1,$0,$9,$3B,$0,$60,$25,$63,$25,$63,$0
  DC.B $0,$0,$0,$25,$63,$0,$0,$4,$48,$19,$21,$9,$3,$8,$60         *41
  DC.B $40,$14,$0,$60,$3,$48,$0,$68,$D,$21,$4,$DF,$70,$47,$0,$0,$0,$10,$27
  DC.B $80,$B8,$28,$0,$40,$0,$B5,$A,$1C,$1,$1C,$0,$20,$0,$F0,$A,$F8
  DC.B $8,$BC,$18,$47,$0,$B5,$A,$1C,$1,$1C,$1,$20,$0,$F0,$2,$F8,$8
  DC.B $BC,$18,$47,$90,$B5,$49,$7,$49,$F,$12,$4F,$7,$23,$DB,$1         *42
  DC.B $80,$14,$0,$60,$3C,$68,$9C,$43,$23,$1C,$4C,$7,$64,$F,$E4,$1,$1C,$43,$52
  DC.B $7,$52,$F,$7,$23,$9B,$2,$9C,$43,$23,$1C,$54,$7,$64,$F,$A4,$2
  DC.B $23,$43,$3B,$60,$DB,$7,$1F,$F,$80,$23,$3B,$43,$19,$43,$12,$1,$A
  DC.B $43,$5,$49,$4B,$6F,$0,$21,$FE,$F7,$C8,$FD,$90,$BC,$8,$BC         *43
  DC.B $C0,$14,$0,$60,$18,$47,$0,$0,$FC,$5,$1,$0,$AC,$1,$1,$0,$80,$B5,$7
  DC.B $6,$3F,$E,$9,$6,$9,$E,$38,$1C,$6,$4A,$12,$68,$FE,$F7,$B4,$FD
  DC.B $5,$48,$0,$2F,$1,$D0,$5,$49,$0,$E0,$5,$49,$41,$67,$80,$BC,$8
  DC.B $BC,$18,$47,$9C,$3A,$0,$60,$AC,$2,$1,$0,$71,$3,$0,$40         *44
  DC.B $0,$15,$0,$60,$44,$94,$0,$0,$F0,$B5,$0,$6,$0,$E,$82,$B0,$6A,$4C,$6B
  DC.B $49,$1,$91,$CF,$1D,$79,$37,$6A,$4D,$1,$28,$5B,$D1,$0,$20,$20,$80
  DC.B $68,$4C,$20,$68,$41,$A,$1,$D2,$81,$A,$73,$D3,$2,$23,$29,$68,$19
  DC.B $43,$0,$3,$C0,$E,$40,$0,$29,$60,$63,$4E,$30,$5C,$1,$99         *45
  DC.B $40,$15,$0,$60,$CD,$1D,$F9,$35,$E9,$6E,$FE,$F7,$7D,$FD,$20,$68,$0,$3,$C0
  DC.B $E,$40,$0,$80,$19,$40,$78,$29,$6F,$FE,$F7,$74,$FD,$FF,$23,$1,$33
  DC.B $20,$68,$18,$40,$59,$49,$0,$91,$9,$D0,$0,$99,$8,$68,$0,$7,$C0
  DC.B $F,$0,$23,$1,$22,$4,$21,$7E,$68,$FE,$F7,$6D,$FD,$20,$68         *46
  DC.B $80,$15,$0,$60,$81,$5,$C9,$F,$1,$29,$68,$D1,$2,$21,$1,$40,$50,$48,$22
  DC.B $D0,$1,$68,$1,$20,$FE,$F7,$56,$FD,$1,$99,$89,$6E,$0,$20,$FE,$F7
  DC.B $51,$FD,$26,$20,$79,$69,$FE,$F7,$4D,$FD,$20,$68,$80,$D,$3,$D3,$48
  DC.B $48,$0,$68,$40,$8,$3,$D3,$47,$48,$0,$68,$0,$28,$4,$D0         *47
  DC.B $C0,$15,$0,$60,$3F,$68,$0,$23,$0,$22,$0,$21,$33,$E0,$3F,$68,$0,$23,$0
  DC.B $22,$1,$21,$2E,$E0,$56,$E0,$1,$68,$1,$20,$FE,$F7,$33,$FD,$1,$20
  DC.B $A9,$68,$FE,$F7,$2F,$FD,$20,$68,$C0,$9,$15,$D3,$0,$99,$8,$68,$0
  DC.B $5,$0,$F,$40,$0,$F9,$69,$24,$30,$FE,$F7,$23,$FD,$0,$23         *48
  DC.B $0,$16,$0,$60,$1,$22,$2,$21,$4,$20,$3D,$68,$FE,$F7,$24,$FD,$F8,$6B,$FE
  DC.B $F7,$17,$FD,$0,$E0,$4C,$E0,$F,$E0,$0,$99,$8,$68,$0,$5,$0,$F
  DC.B $40,$0,$79,$69,$24,$30,$FE,$F7,$D,$FD,$3F,$68,$0,$23,$0,$22,$2
  DC.B $21,$4,$20,$FE,$F7,$12,$FD,$2,$22,$20,$68,$2,$40,$17,$21         *49
  DC.B $40,$16,$0,$60,$9,$3,$0,$2A,$A,$D0,$80,$9,$8,$D3,$48,$68,$23,$4B,$18
  DC.B $40,$48,$60,$8,$68,$DB,$43,$18,$43,$6,$E0,$7,$E0,$48,$68,$1F,$4B
  DC.B $18,$40,$48,$60,$8,$68,$18,$40,$8,$60,$21,$E0,$0,$20,$A9,$68,$FE
  DC.B $F7,$E8,$FC,$3F,$68,$0,$23,$1,$22,$2,$21,$0,$20,$FE,$F7         *4a
  DC.B $80,$16,$0,$60,$ED,$FC,$15,$E0,$38,$6C,$FE,$F7,$DB,$FC,$2,$23,$DB,$43,$28
  DC.B $68,$18,$40,$28,$60,$0,$23,$1,$22,$2,$21,$0,$20,$3D,$68,$FE,$F7
  DC.B $D9,$FC,$19,$20,$40,$1,$20,$80,$1,$20,$F9,$68,$FE,$F7,$CA,$FC,$2
  DC.B $B0,$F0,$BC,$8,$BC,$18,$47,$40,$1,$1,$0,$AC,$1,$1,$0         *4b
  DC.B $C0,$16,$0,$60,$3C,$0,$1,$0,$40,$0,$1,$0,$7C,$96,$0,$0,$44,$0,$1
  DC.B $0,$BC,$3A,$0,$60,$50,$28,$0,$40,$4C,$28,$0,$40,$FF,$FF,$FF,$FB
  DC.B $F1,$B5,$3,$20,$88,$B0,$0,$90,$1,$90,$0,$20,$2,$90,$3,$90,$4
  DC.B $90,$FA,$48,$0,$68,$80,$7,$C0,$F,$1,$28,$3,$D1,$8,$B0         *4c
  DC.B $0,$17,$0,$60,$F8,$BC,$8,$BC,$18,$47,$F6,$4D,$28,$68,$0,$7,$C0,$F,$F5
  DC.B $49,$7,$91,$89,$6E,$FE,$F7,$96,$FC,$28,$68,$C1,$7,$C9,$F,$F2,$4C
  DC.B $F2,$4F,$9,$D1,$40,$9,$7,$D2,$20,$68,$0,$7,$C0,$F,$0,$23,$0
  DC.B $22,$7E,$68,$FE,$F7,$90,$FC,$28,$68,$81,$9,$5A,$D3,$41,$9         *4d
  DC.B $40,$17,$0,$60,$1E,$D3,$C0,$9,$F,$D3,$20,$68,$0,$7,$C0,$F,$0,$23,$1
  DC.B $22,$2,$21,$7E,$68,$FE,$F7,$80,$FC,$30,$20,$39,$6A,$FE,$F7,$72,$FC
  DC.B $1,$20,$0,$90,$C,$E0,$20,$68,$0,$7,$C0,$F,$0,$23,$0,$22,$2
  DC.B $21,$7E,$68,$FE,$F7,$70,$FC,$30,$20,$B9,$69,$FE,$F7,$62,$FC         *4e
  DC.B $80,$17,$0,$60,$28,$68,$C1,$9,$1A,$D3,$C0,$B,$2,$D3,$20,$68,$0,$6,$1
  DC.B $E0,$20,$68,$0,$5,$0,$F,$40,$0,$F9,$69,$24,$30,$FE,$F7,$52,$FC
  DC.B $20,$68,$0,$7,$C0,$F,$0,$23,$1,$22,$2,$21,$3E,$68,$1,$30,$FE
  DC.B $F7,$52,$FC,$1,$20,$1,$90,$0,$90,$18,$E0,$C0,$B,$2,$D3         *4f
  DC.B $C0,$17,$0,$60,$20,$68,$0,$6,$1,$E0,$20,$68,$0,$5,$0,$F,$40,$0,$79
  DC.B $69,$24,$30,$FE,$F7,$37,$FC,$20,$68,$0,$7,$C0,$F,$0,$23,$0,$22
  DC.B $2,$21,$3E,$68,$1,$30,$FE,$F7,$37,$FC,$0,$20,$1,$90,$1,$20,$4
  DC.B $90,$2,$90,$2,$21,$28,$68,$1,$40,$BD,$4A,$6,$92,$1C,$D0         *50
  DC.B $0,$18,$0,$60,$80,$D,$C,$D3,$6,$9A,$10,$68,$40,$8,$8,$D2,$20,$68,$0
  DC.B $7,$C0,$F,$0,$23,$0,$22,$0,$21,$3E,$68,$1,$30,$7,$E0,$20,$68
  DC.B $0,$7,$C0,$F,$0,$23,$0,$22,$1,$21,$3E,$68,$1,$30,$FE,$F7,$13
  DC.B $FC,$1,$20,$4,$90,$0,$20,$1,$90,$28,$68,$41,$8,$22,$D3         *51
  DC.B $40,$18,$0,$60,$80,$D,$3,$D3,$6,$9A,$10,$68,$40,$8,$3,$D3,$A9,$48,$0
  DC.B $68,$0,$28,$7,$D0,$20,$68,$0,$7,$C0,$F,$0,$23,$0,$22,$5,$21
  DC.B $7E,$68,$6,$E0,$20,$68,$0,$7,$C0,$F,$0,$23,$0,$22,$1,$21,$7E
  DC.B $68,$FE,$F7,$F1,$FB,$30,$20,$B9,$69,$FE,$F7,$E3,$FB,$1,$20         *52
  DC.B $80,$18,$0,$60,$4,$90,$0,$20,$1,$90,$2,$22,$29,$68,$A,$40,$17,$20,$0
  DC.B $3,$99,$4B,$5,$93,$0,$2A,$11,$D0,$89,$9,$F,$D3,$41,$68,$97,$4B
  DC.B $19,$40,$41,$60,$1,$68,$DB,$43,$19,$43,$1,$60,$5,$9B,$18,$68,$40
  DC.B $8,$1,$D3,$5,$20,$D,$E0,$4,$20,$B,$E0,$41,$68,$8F,$4B         *53
  DC.B $C0,$18,$0,$60,$19,$40,$41,$60,$1,$68,$19,$40,$1,$60,$5,$9B,$18,$68,$40
  DC.B $8,$F0,$D3,$7,$20,$7,$99,$9,$6E,$FE,$F7,$B4,$FB,$28,$68,$41,$B
  DC.B $3F,$D3,$0,$B,$16,$D3,$20,$68,$0,$5,$0,$F,$40,$0,$F9,$69,$24
  DC.B $30,$FE,$F7,$A7,$FB,$20,$68,$0,$7,$C0,$F,$2,$21,$8,$1A         *54
  DC.B $0,$19,$0,$60,$1,$23,$1,$22,$3E,$68,$FE,$F7,$A7,$FB,$1,$20,$3,$90,$2
  DC.B $90,$1,$90,$6,$E0,$1,$23,$1,$22,$2,$21,$0,$20,$3E,$68,$FE,$F7
  DC.B $9B,$FB,$28,$68,$C0,$A,$11,$D3,$20,$68,$0,$7,$C0,$F,$2,$21,$8
  DC.B $1A,$1,$23,$1,$22,$7E,$68,$FE,$F7,$8E,$FB,$30,$20,$39,$6A         *55
  DC.B $40,$19,$0,$60,$FE,$F7,$80,$FB,$1,$20,$3,$90,$1,$90,$A,$E0,$20,$68,$0
  DC.B $7,$C0,$F,$2,$21,$8,$1A,$1,$23,$1,$22,$0,$21,$7E,$68,$FE,$F7
  DC.B $7B,$FB,$3,$98,$0,$28,$45,$D1,$1,$20,$3,$90,$1,$98,$0,$28,$20
  DC.B $D0,$1,$28,$1E,$D1,$20,$68,$0,$7,$C0,$F,$2,$21,$8,$1A         *56
  DC.B $80,$19,$0,$60,$1,$23,$0,$22,$3,$21,$3E,$68,$FE,$F7,$66,$FB,$20,$68,$0
  DC.B $7,$C0,$F,$2,$21,$8,$1A,$1,$23,$0,$22,$3,$21,$7E,$68,$FE,$F7
  DC.B $5B,$FB,$33,$20,$79,$69,$FE,$F7,$4D,$FB,$2D,$20,$B9,$69,$FE,$F7,$49
  DC.B $FB,$1F,$E0,$20,$68,$0,$7,$C0,$F,$2,$21,$8,$1A,$1,$23         *57
  DC.B $C0,$19,$0,$60,$1,$22,$3,$21,$3E,$68,$FE,$F7,$47,$FB,$20,$68,$0,$7,$C0
  DC.B $F,$2,$21,$8,$1A,$1,$23,$1,$22,$3,$21,$7E,$68,$FE,$F7,$3C,$FB
  DC.B $33,$20,$F9,$69,$FE,$F7,$2E,$FB,$2D,$20,$39,$6A,$FE,$F7,$2A,$FB,$0
  DC.B $20,$0,$90,$0,$98,$1,$28,$F,$D1,$28,$68,$C1,$9,$C,$D3         *58
  DC.B $0,$1A,$0,$60,$81,$9,$A,$D3,$40,$9,$8,$D3,$3D,$48,$0,$88,$7,$28,$4
  DC.B $D1,$2,$20,$0,$90,$1,$20,$0,$F0,$A5,$F8,$78,$6C,$39,$4E,$B1,$68
  DC.B $88,$42,$5,$D1,$0,$98,$2,$28,$2,$D0,$0,$20,$0,$F0,$9A,$F8,$0
  DC.B $98,$3,$28,$3,$D0,$0,$98,$80,$0,$30,$58,$78,$64,$28,$68         *59
  DC.B $40,$1A,$0,$60,$80,$8,$A,$D3,$8,$98,$1,$28,$7,$D1,$20,$68,$0,$2,$0
  DC.B $17,$40,$0,$79,$69,$30,$30,$FE,$F7,$F5,$FA,$28,$68,$81,$8,$15,$D3
  DC.B $8,$99,$0,$29,$12,$D1,$C0,$8,$8,$D3,$30,$20,$79,$69,$FE,$F7,$E9
  DC.B $FA,$20,$68,$24,$4B,$18,$40,$20,$60,$7,$E0,$20,$68,$0,$2         *5a
  DC.B $80,$1A,$0,$60,$0,$17,$40,$0,$79,$69,$30,$30,$FE,$F7,$DC,$FA,$28,$68,$41
  DC.B $8,$5,$D2,$80,$8,$3,$D2,$1,$20,$F9,$6F,$FE,$F7,$D3,$FA,$2,$98
  DC.B $1A,$4F,$0,$28,$7,$D1,$5,$9B,$58,$68,$80,$B,$3,$D2,$0,$20,$B9
  DC.B $68,$FE,$F7,$C7,$FA,$4,$98,$15,$49,$9,$68,$FE,$F7,$C2,$FA         *5b
  DC.B $C0,$1A,$0,$60,$3,$98,$14,$49,$9,$68,$FE,$F7,$BD,$FA,$3,$98,$0,$28,$27
  DC.B $D1,$79,$68,$FE,$F7,$B7,$FA,$5,$9B,$18,$68,$1D,$E0,$3C,$0,$1,$0
  DC.B $40,$0,$1,$0,$AC,$1,$1,$0,$44,$0,$1,$0,$2C,$2,$1,$0,$50
  DC.B $28,$0,$40,$4C,$28,$0,$40,$FC,$5,$1,$0,$FF,$FF,$FF,$FB         *5c
  DC.B $0,$1B,$0,$60,$D8,$28,$0,$40,$3C,$3B,$0,$60,$FF,$FF,$F,$FF,$AC,$2,$1
  DC.B $0,$BC,$3A,$0,$60,$C0,$3A,$0,$60,$6,$4B,$18,$40,$5,$9B,$18,$60
  DC.B $2,$98,$0,$28,$3,$D0,$1,$20,$B9,$68,$FE,$F7,$8B,$FA,$8,$B0,$E6
  DC.B $E5,$0,$0,$FF,$FF,$FE,$FF,$0,$B5,$8,$4B,$1B,$68,$0,$2B         *5d
  DC.B $40,$1B,$0,$60,$2,$D0,$8,$23,$DB,$43,$1,$E0,$0,$23,$DB,$43,$1A,$40,$49
  DC.B $0,$3,$4B,$1B,$68,$FE,$F7,$7A,$FA,$8,$BC,$18,$47,$6C,$28,$0,$40
  DC.B $D8,$3A,$0,$60,$80,$B5,$B,$49,$8,$60,$B,$4F,$0,$21,$0,$20,$3A
  DC.B $6F,$FE,$F7,$69,$FA,$9,$49,$9,$68,$C9,$7,$9,$F,$8,$43         *5e
  DC.B $80,$1B,$0,$60,$0,$21,$2,$1C,$0,$20,$7B,$6F,$FE,$F7,$60,$FA,$80,$BC,$8
  DC.B $BC,$18,$47,$0,$0,$6C,$28,$0,$40,$AC,$1,$1,$0,$FC,$5,$1,$0
  DC.B $F0,$B4,$0,$21,$1D,$4F,$1E,$4C,$0,$29,$1,$D0,$1D,$4F,$3F,$21,$20
  DC.B $1C,$27,$E0,$F0,$23,$2B,$40,$E0,$2B,$13,$D0,$F0,$2B,$1E,$D1         *5f
  DC.B $C0,$1B,$0,$60,$2B,$7,$1B,$F,$42,$78,$FF,$2A,$3,$D1,$A,$1C,$1,$E0,$3A
  DC.B $70,$1,$37,$5D,$1E,$2E,$6,$36,$E,$1D,$1C,$33,$1C,$0,$2D,$F6,$D1
  DC.B $1,$30,$E,$E0,$0,$29,$5,$D0,$2A,$7,$12,$F,$1,$25,$95,$40,$2A
  DC.B $6,$12,$E,$43,$78,$13,$43,$3B,$70,$1,$30,$0,$E0,$3D,$70         *60
  DC.B $0,$1C,$0,$60,$1,$37,$1,$30,$5,$78,$FF,$2D,$D4,$D1,$48,$1C,$28,$40,$3
  DC.B $1C,$8,$1C,$19,$1C,$0,$28,$C7,$D0,$F0,$BC,$70,$47,$48,$51,$0,$40
  DC.B $78,$3C,$0,$60,$84,$50,$0,$40,$0,$20,$1,$21,$49,$7,$5,$4A,$8B
  DC.B $78,$9B,$7,$9B,$F,$3,$2B,$2,$D0,$1,$30,$90,$42,$F7,$DB         *61
  DC.B $40,$1C,$0,$60,$70,$47,$0,$0,$88,$13,$0,$0,$80,$B4,$0,$20,$1,$21,$49
  DC.B $7,$5,$4A,$8F,$78,$8,$23,$3B,$40,$8,$2B,$2,$D0,$1,$30,$90,$42
  DC.B $F7,$DB,$80,$BC,$70,$47,$0,$0,$88,$13,$0,$0,$F0,$B5,$27,$4F,$B8
  DC.B $6A,$FE,$F7,$E5,$F9,$0,$26,$1,$24,$64,$7,$26,$70,$B8,$6A         *62
  DC.B $80,$1C,$0,$60,$FE,$F7,$DE,$F9,$26,$70,$B8,$6A,$FE,$F7,$DA,$F9,$24,$25,$A5
  DC.B $70,$B8,$6A,$FE,$F7,$D5,$F9,$B0,$20,$A0,$70,$FF,$F7,$D5,$FF,$0,$24
  DC.B $EE,$6,$0,$20,$30,$70,$FF,$F7,$CF,$FF,$1,$23,$1B,$3,$1,$34,$9C
  DC.B $42,$F6,$D3,$B2,$24,$B4,$70,$B8,$6A,$FE,$F7,$C1,$F9,$B8,$6A         *63
  DC.B $C0,$1C,$0,$60,$FE,$F7,$BE,$F9,$0,$20,$30,$70,$B8,$6A,$FE,$F7,$B9,$F9,$10
  DC.B $20,$30,$70,$B8,$6A,$FE,$F7,$B4,$F9,$B5,$70,$B8,$6A,$FE,$F7,$B0,$F9
  DC.B $B0,$20,$B0,$70,$FF,$F7,$B0,$FF,$0,$25,$0,$20,$30,$70,$FF,$F7,$AB
  DC.B $FF,$1,$23,$5B,$2,$1,$35,$9D,$42,$F6,$D3,$B4,$70,$B8,$6A         *64
  DC.B $0,$1D,$0,$60,$FE,$F7,$9E,$F9,$F0,$BC,$8,$BC,$18,$47,$0,$0,$2C,$3,$1
  DC.B $0,$0,$B5,$4,$48,$0,$21,$42,$6B,$0,$20,$FE,$F7,$95,$F9,$8,$BC
  DC.B $18,$47,$0,$0,$2C,$3,$1,$0,$B0,$B5,$5,$6,$2D,$E,$C,$6,$24
  DC.B $E,$D,$4F,$B8,$6A,$FE,$F7,$83,$F9,$50,$20,$60,$43,$40,$19         *65
  DC.B $40,$1D,$0,$60,$1,$23,$1B,$3,$C0,$18,$5D,$4,$28,$70,$4,$1C,$B8,$6A,$FE
  DC.B $F7,$77,$F9,$20,$12,$28,$70,$B8,$6A,$FE,$F7,$72,$F9,$24,$20,$A8,$70
  DC.B $B0,$BC,$8,$BC,$18,$47,$0,$0,$2C,$3,$1,$0,$B0,$B5,$5,$6,$2D
  DC.B $E,$C,$6,$24,$E,$A,$4F,$B8,$6A,$FE,$F7,$61,$F9,$28,$1C         *66
  DC.B $80,$1D,$0,$60,$1,$25,$6D,$7,$28,$70,$B8,$6A,$FE,$F7,$5A,$F9,$60,$0,$28
  DC.B $70,$B8,$6A,$FE,$F7,$55,$F9,$21,$20,$A8,$70,$B0,$BC,$8,$BC,$18,$47
  DC.B $2C,$3,$1,$0,$B0,$B5,$0,$6,$0,$E,$80,$38,$4,$6,$24,$E,$C
  DC.B $4F,$B8,$6A,$FE,$F7,$44,$F9,$E0,$0,$7,$23,$9B,$2,$C0,$18         *67
  DC.B $C0,$1D,$0,$60,$1,$24,$64,$7,$20,$70,$5,$1C,$B8,$6A,$FE,$F7,$39,$F9,$28
  DC.B $12,$20,$70,$B8,$6A,$FE,$F7,$34,$F9,$24,$20,$A0,$70,$B0,$BC,$8,$BC
  DC.B $18,$47,$0,$0,$2C,$3,$1,$0,$F0,$B5,$0,$20,$29,$49,$8,$70,$D
  DC.B $20,$40,$3,$1,$68,$3E,$23,$DB,$43,$19,$40,$A,$23,$19,$43         *68
  DC.B $0,$1E,$0,$60,$1,$60,$25,$4C,$E0,$1D,$79,$30,$1,$6F,$8,$20,$FE,$F7,$1A
  DC.B $F9,$FF,$F7,$C6,$FE,$E5,$1D,$FF,$35,$7A,$35,$A8,$6A,$FE,$F7,$10,$F9
  DC.B $9C,$20,$1,$27,$7F,$7,$B8,$70,$28,$6B,$FE,$F7,$9,$F9,$A,$22,$FF
  DC.B $21,$6,$B4,$3,$23,$1B,$2,$E0,$18,$5,$23,$4,$22,$4,$21         *69
  DC.B $40,$1E,$0,$60,$84,$6B,$28,$20,$FE,$F7,$4,$F9,$80,$20,$2,$B0,$FF,$F7,$AA
  DC.B $FF,$B0,$20,$B8,$70,$FF,$F7,$F8,$FE,$0,$24,$0,$27,$E0,$0,$F,$49
  DC.B $46,$18,$F0,$5D,$1,$21,$49,$7,$8,$70,$FF,$F7,$ED,$FE,$1,$37,$8
  DC.B $2F,$F6,$DB,$1,$34,$23,$2C,$EF,$DB,$B2,$20,$7,$7,$B8,$70         *6a
  DC.B $80,$1E,$0,$60,$A8,$6A,$FE,$F7,$DD,$F8,$0,$21,$0,$20,$FF,$F7,$4D,$FF,$F0
  DC.B $BC,$8,$BC,$18,$47,$7C,$0,$1,$0,$AC,$1,$1,$0,$48,$3B,$0,$60
  DC.B $0,$B5,$1,$38,$80,$0,$3,$49,$8,$58,$3,$49,$0,$F0,$56,$F8,$8
  DC.B $BC,$18,$47,$60,$3C,$0,$60,$48,$51,$0,$40,$0,$B5,$1,$38         *6b
  DC.B $C0,$1E,$0,$60,$80,$0,$3,$49,$8,$58,$0,$21,$0,$F0,$48,$F8,$8,$BC,$18
  DC.B $47,$60,$3C,$0,$60,$0,$B5,$1,$38,$80,$0,$3,$49,$8,$58,$3,$49
  DC.B $0,$F0,$3C,$F8,$8,$BC,$18,$47,$60,$3C,$0,$60,$84,$50,$0,$40,$90
  DC.B $B5,$4,$6,$24,$E,$8,$4F,$B8,$6A,$FE,$F7,$A1,$F8,$20,$1C         *6c
  DC.B $0,$1F,$0,$60,$1,$24,$64,$7,$20,$70,$B8,$6A,$FE,$F7,$9A,$F8,$C0,$20,$A0
  DC.B $70,$90,$BC,$8,$BC,$18,$47,$0,$0,$2C,$3,$1,$0,$B0,$B5,$7,$1C
  DC.B $D,$4C,$A0,$6A,$FE,$F7,$8C,$F8,$38,$1C,$1,$27,$7F,$7,$0,$28,$6
  DC.B $D0,$9F,$25,$1,$28,$6,$D0,$2,$28,$A,$D1,$A7,$20,$3,$E0         *6d
  DC.B $40,$1F,$0,$60,$9C,$20,$B8,$70,$5,$E0,$A0,$20,$B8,$70,$A0,$6A,$FE,$F7,$78
  DC.B $F8,$BD,$70,$B0,$BC,$8,$BC,$18,$47,$2C,$3,$1,$0,$F0,$B5,$7,$1C
  DC.B $0,$20,$82,$B0,$0,$90,$C,$1C,$E,$1C,$2B,$49,$1,$91,$4B,$E0,$0
  DC.B $2C,$2,$D0,$30,$78,$1,$36,$0,$E0,$0,$20,$5,$6,$2D,$E         *6e
  DC.B $80,$1F,$0,$60,$38,$1C,$1,$37,$0,$F0,$4A,$F8,$38,$23,$18,$40,$28,$43,$1
  DC.B $99,$89,$6B,$FE,$F7,$57,$F8,$1,$99,$88,$6A,$FE,$F7,$51,$F8,$B0,$21
  DC.B $1,$20,$40,$7,$81,$70,$1,$25,$E,$E0,$FF,$F7,$4D,$FE,$0,$2C,$2
  DC.B $D0,$30,$78,$1,$36,$0,$E0,$0,$20,$1,$21,$49,$7,$8,$70         *6f
  DC.B $C0,$1F,$0,$60,$68,$1C,$5,$6,$2D,$E,$1,$37,$D,$2D,$EE,$DB,$FF,$F7,$3C
  DC.B $FE,$B2,$20,$1,$7,$88,$70,$0,$2C,$2,$D0,$30,$78,$1,$36,$0,$E0
  DC.B $0,$20,$5,$6,$2D,$E,$38,$1C,$1,$37,$0,$F0,$17,$F8,$40,$7,$40
  DC.B $F,$28,$43,$1,$99,$89,$6B,$FE,$F7,$24,$F8,$0,$98,$1,$30         *70
  DC.B $0,$20,$0,$60,$0,$6,$0,$E,$0,$90,$1A,$37,$0,$98,$E,$28,$B0,$DB,$2
  DC.B $B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$2C,$3,$1,$0,$B0,$B5,$7,$1C
  DC.B $10,$4C,$A0,$6A,$FE,$F7,$C,$F8,$1,$25,$6D,$7,$2F,$70,$A0,$6A,$FE
  DC.B $F7,$6,$F8,$38,$12,$28,$70,$A0,$6A,$FE,$F7,$1,$F8,$24,$20         *71
  DC.B $40,$20,$0,$60,$A8,$70,$A0,$6A,$FD,$F7,$FC,$FF,$C5,$20,$A8,$70,$A0,$6A,$FD
  DC.B $F7,$F7,$FF,$2F,$78,$A0,$6A,$FD,$F7,$F3,$FF,$38,$1C,$B0,$BC,$8,$BC
  DC.B $18,$47,$0,$0,$2C,$3,$1,$0,$FF,$B5,$7,$1C,$82,$B0,$4C,$4C,$20
  DC.B $68,$4C,$49,$1,$91,$CD,$1D,$79,$35,$0,$28,$8,$D1,$4A,$48         *72
  DC.B $80,$20,$0,$60,$2,$70,$0,$23,$C0,$56,$10,$21,$2A,$6E,$FD,$F7,$DD,$FF,$20
  DC.B $60,$46,$49,$0,$91,$8,$68,$46,$4E,$46,$4C,$0,$28,$2D,$D1,$38,$1C
  DC.B $45,$49,$8,$70,$3,$99,$45,$48,$1,$70,$3,$99,$4F,$43,$27,$60,$5
  DC.B $99,$43,$4F,$39,$70,$0,$23,$C0,$56,$1,$21,$2A,$6E,$FD,$F7         *73
  DC.B $C0,$20,$0,$60,$C3,$FF,$40,$49,$8,$60,$0,$23,$F8,$56,$21,$68,$2A,$6E,$FD
  DC.B $F7,$BB,$FF,$0,$99,$0,$23,$8,$60,$F9,$56,$23,$68,$59,$43,$A,$1C
  DC.B $20,$21,$33,$68,$FD,$F7,$B2,$FF,$20,$68,$C1,$8,$0,$23,$F8,$56,$2A
  DC.B $6E,$FD,$F7,$A9,$FF,$34,$49,$8,$60,$7,$23,$DB,$1,$1,$99         *74
  DC.B $0,$21,$0,$60,$C8,$18,$40,$69,$FD,$F7,$9C,$FF,$E0,$6A,$0,$28,$11,$D1,$B
  DC.B $98,$60,$86,$32,$23,$E0,$5E,$1,$30,$80,$0,$E9,$6D,$FD,$F7,$92,$FF
  DC.B $32,$23,$E1,$5E,$1,$31,$8A,$0,$E0,$62,$0,$21,$33,$68,$FD,$F7,$8D
  DC.B $FF,$A0,$68,$0,$28,$1B,$D1,$21,$4F,$0,$23,$F8,$56,$0,$28         *75
  DC.B $40,$21,$0,$60,$16,$DD,$C,$21,$2A,$6E,$1,$30,$FD,$F7,$7E,$FF,$A0,$60,$0
  DC.B $20,$1,$22,$FE,$21,$6,$E0,$43,$0,$A5,$68,$5D,$19,$69,$70,$A5,$68
  DC.B $EA,$54,$1,$30,$0,$23,$FD,$56,$6,$23,$6B,$43,$83,$42,$F2,$DC,$0
  DC.B $20,$16,$4F,$16,$49,$5,$24,$A,$68,$16,$49,$B,$23,$43,$43         *76
  DC.B $80,$21,$0,$60,$5B,$18,$85,$0,$ED,$19,$2B,$63,$1A,$72,$5C,$72,$1,$30,$4
  DC.B $28,$F4,$DB,$1,$F0,$79,$F9,$2,$B0,$4,$B0,$F0,$BC,$8,$BC,$18,$47
  DC.B $F4,$0,$1,$0,$AC,$1,$1,$0,$EF,$0,$1,$0,$8,$1,$1,$0,$B8
  DC.B $3A,$0,$60,$70,$28,$0,$40,$EC,$0,$1,$0,$ED,$0,$1,$0         *77
  DC.B $C0,$21,$0,$60,$F0,$0,$1,$0,$FC,$0,$1,$0,$C,$1,$1,$0,$F8,$28,$0
  DC.B $40,$BC,$28,$0,$40,$24,$52,$0,$40,$F0,$B5,$7,$1C,$16,$4C,$0,$20
  DC.B $6,$E0,$21,$78,$8F,$42,$5,$D0,$1,$30,$0,$6,$0,$E,$8,$34,$5
  DC.B $28,$F6,$D3,$5,$28,$15,$D0,$20,$68,$0,$5,$0,$F,$1,$38         *78
  DC.B $0,$22,$0,$60,$5,$6,$2D,$E,$D,$4E,$F0,$1D,$FF,$30,$7A,$30,$C0,$6F,$FD
  DC.B $F7,$17,$FF,$A8,$42,$9,$D2,$5,$23,$DB,$1,$F1,$18,$9,$69,$38,$1C
  DC.B $FD,$F7,$10,$FF,$F0,$BC,$8,$BC,$18,$47,$60,$68,$FD,$F7,$8,$FF,$F0
  DC.B $BC,$8,$BC,$18,$47,$0,$0,$F4,$3C,$0,$60,$AC,$1,$1,$0         *79
  DC.B $40,$22,$0,$60,$80,$B4,$81,$6,$4A,$F,$A,$49,$4A,$60,$12,$1,$9,$4B,$1B
  DC.B $68,$9F,$58,$D2,$18,$F,$60,$53,$68,$8B,$60,$43,$7,$5B,$F,$1,$3B
  DC.B $0,$6,$C0,$F,$8,$61,$4B,$61,$D3,$60,$80,$BC,$70,$47,$0,$0,$C
  DC.B $52,$0,$40,$F4,$0,$1,$0,$80,$B4,$B,$6,$1B,$E,$12,$6         *7a
  DC.B $80,$22,$0,$60,$12,$E,$81,$6,$4F,$F,$7,$49,$1,$3B,$1,$3A,$8A,$60,$88
  DC.B $C1,$8,$39,$42,$7,$52,$F,$1,$3A,$0,$6,$C0,$F,$8,$61,$4A,$61
  DC.B $80,$BC,$70,$47,$C,$52,$0,$40,$70,$47,$70,$47,$90,$B4,$14,$48,$2
  DC.B $69,$14,$49,$1,$2A,$8,$D1,$42,$68,$13,$1,$A,$68,$9F,$18         *7b
  DC.B $C0,$22,$0,$60,$7F,$68,$87,$60,$D2,$58,$2,$60,$A,$E0,$82,$68,$43,$68,$1B
  DC.B $1,$F,$68,$DB,$19,$5A,$60,$42,$68,$3,$68,$12,$1,$F,$68,$BB,$50
  DC.B $42,$68,$13,$1,$A,$68,$99,$18,$8F,$68,$40,$69,$6,$4C,$27,$54,$D2
  DC.B $58,$6,$4B,$1A,$54,$49,$68,$5,$4A,$11,$54,$90,$BC,$70,$47         *7c
  DC.B $0,$23,$0,$60,$C,$52,$0,$40,$F4,$0,$1,$0,$82,$28,$0,$40,$8A,$28,$0
  DC.B $40,$92,$28,$0,$40,$80,$B4,$C,$49,$1,$23,$4A,$69,$DA,$42,$5,$D1
  DC.B $0,$22,$2,$60,$9,$4A,$0,$23,$D2,$56,$2,$E0,$2,$60,$4A,$69,$1
  DC.B $32,$42,$60,$8A,$68,$6,$4F,$0,$23,$FB,$56,$5A,$43,$9,$68         *7d
  DC.B $40,$23,$0,$60,$51,$18,$81,$60,$80,$BC,$70,$47,$C,$52,$0,$40,$F0,$0,$1
  DC.B $0,$EC,$0,$1,$0,$F0,$B5,$7,$6,$3F,$E,$83,$B0,$68,$46,$FF,$F7
  DC.B $D9,$FF,$0,$98,$10,$4C,$11,$4A,$1,$25,$15,$E0,$2,$99,$6,$1C,$23
  DC.B $68,$5E,$43,$8B,$19,$D9,$10,$16,$68,$89,$19,$5E,$7,$76,$F         *7e
  DC.B $80,$23,$0,$60,$2B,$1C,$B3,$40,$0,$2F,$2,$D0,$E,$78,$33,$43,$2,$E0,$E
  DC.B $78,$DB,$43,$33,$40,$B,$70,$1,$30,$1,$99,$81,$42,$E6,$DC,$3,$B0
  DC.B $F0,$BC,$8,$BC,$18,$47,$0,$0,$70,$28,$0,$40,$C,$1,$1,$0,$B0
  DC.B $B5,$7,$6,$3F,$E,$C,$6,$24,$E,$83,$B0,$68,$46,$FF,$F7         *7f
  DC.B $C0,$23,$0,$60,$A9,$FF,$0,$98,$10,$4A,$11,$49,$7,$E0,$3,$1C,$15,$68,$6B
  DC.B $43,$2,$9D,$5B,$19,$D,$68,$EF,$54,$1,$30,$1,$9B,$83,$42,$F4,$DC
  DC.B $20,$1C,$B,$49,$9,$6D,$FD,$F7,$2D,$FE,$A,$48,$0,$23,$C0,$56,$42
  DC.B $1E,$9,$49,$8,$68,$82,$42,$1,$D9,$1,$30,$8,$60,$3,$B0         *80
  DC.B $0,$24,$0,$60,$B0,$BC,$8,$BC,$18,$47,$0,$0,$70,$28,$0,$40,$8,$1,$1
  DC.B $0,$AC,$4,$1,$0,$EC,$0,$1,$0,$C,$52,$0,$40,$F0,$B5,$81,$B0
  DC.B $23,$4E,$F5,$1D,$FF,$35,$7A,$35,$A8,$6F,$FD,$F7,$9,$FE,$0,$AB,$18
  DC.B $70,$0,$98,$80,$6,$41,$F,$1E,$48,$0,$23,$C0,$56,$1E,$4C         *81
  DC.B $40,$24,$0,$60,$81,$42,$6,$DA,$0,$98,$40,$7,$40,$F,$1C,$49,$C9,$56,$88
  DC.B $42,$4,$DD,$4,$20,$21,$69,$FD,$F7,$F5,$FD,$24,$E0,$80,$23,$DB,$43
  DC.B $0,$98,$18,$40,$0,$90,$A8,$6F,$FD,$F7,$EA,$FD,$7,$1C,$A8,$6F,$FD
  DC.B $F7,$E6,$FD,$1,$1C,$EC,$D0,$11,$48,$0,$23,$C0,$56,$1,$30         *82
  DC.B $80,$24,$0,$60,$88,$42,$E6,$DB,$0,$2F,$E4,$D0,$E,$48,$C0,$56,$87,$42,$E0
  DC.B $DC,$7,$23,$DB,$1,$F4,$18,$0,$98,$E3,$6C,$3A,$1C,$FD,$F7,$D6,$FD
  DC.B $E0,$6B,$FD,$F7,$CD,$FD,$1,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$AC
  DC.B $1,$1,$0,$EF,$0,$1,$0,$2C,$4,$1,$0,$F0,$0,$1,$0         *83
  DC.B $C0,$24,$0,$60,$EC,$0,$1,$0,$ED,$0,$1,$0,$80,$B4,$0,$6,$0,$E,$9
  DC.B $6,$9,$E,$8,$4A,$52,$69,$8,$4B,$1B,$68,$5A,$43,$7,$4F,$0,$23
  DC.B $FB,$56,$59,$43,$51,$18,$8,$18,$5,$49,$9,$68,$8,$5C,$80,$BC,$70
  DC.B $47,$0,$0,$C,$52,$0,$40,$70,$28,$0,$40,$EC,$0,$1,$0         *84
  DC.B $0,$25,$0,$60,$8,$1,$1,$0,$80,$B4,$0,$6,$0,$E,$9,$6,$9,$E,$C
  DC.B $4A,$52,$69,$C,$4B,$1B,$68,$5A,$43,$B,$4F,$0,$23,$FB,$56,$59,$43
  DC.B $51,$18,$8,$18,$C1,$10,$9,$4A,$12,$68,$51,$5C,$42,$7,$52,$F,$1
  DC.B $20,$3,$1C,$93,$40,$19,$40,$0,$D1,$0,$20,$80,$BC,$70,$47         *85
  DC.B $40,$25,$0,$60,$C,$52,$0,$40,$70,$28,$0,$40,$EC,$0,$1,$0,$C,$1,$1
  DC.B $0,$0,$B5,$3,$20,$0,$F0,$14,$F8,$8,$BC,$18,$47,$0,$B5,$2,$20
  DC.B $0,$F0,$E,$F8,$8,$BC,$18,$47,$0,$B5,$1,$20,$0,$F0,$8,$F8,$8
  DC.B $BC,$18,$47,$0,$B5,$0,$20,$0,$F0,$2,$F8,$8,$BC,$18,$47         *86
  DC.B $80,$25,$0,$60,$F0,$B5,$4,$1C,$87,$B0,$35,$48,$6,$90,$80,$6F,$FD,$F7,$58
  DC.B $FD,$45,$1E,$33,$4F,$38,$68,$0,$90,$41,$19,$32,$4A,$0,$23,$D2,$56
  DC.B $2,$3A,$91,$42,$0,$D9,$15,$1A,$61,$8,$2,$D3,$0,$26,$1,$22,$2
  DC.B $E0,$0,$22,$D2,$43,$2E,$1C,$1,$92,$2,$21,$21,$40,$2A,$4C         *87
  DC.B $C0,$25,$0,$60,$6,$D0,$6,$98,$80,$6F,$FD,$F7,$3B,$FD,$3,$90,$0,$20,$B
  DC.B $E0,$80,$19,$B9,$68,$62,$6C,$FD,$F7,$37,$FD,$3,$90,$38,$68,$B9,$68
  DC.B $80,$19,$22,$6C,$FD,$F7,$30,$FD,$2,$90,$38,$68,$80,$19,$0,$26,$38
  DC.B $60,$1E,$4A,$5,$92,$1,$9A,$50,$1E,$4,$90,$1A,$E0,$38,$68         *88
  DC.B $0,$26,$0,$60,$B9,$68,$1,$9A,$80,$18,$22,$6C,$FD,$F7,$1E,$FD,$81,$B0,$0
  DC.B $90,$38,$68,$B9,$68,$2,$9A,$80,$18,$62,$6C,$FD,$F7,$15,$FD,$0,$99
  DC.B $1,$B0,$5,$9A,$92,$6C,$FD,$F7,$F,$FD,$4,$98,$39,$68,$40,$18,$38
  DC.B $60,$1,$36,$AE,$42,$E2,$DB,$3,$98,$2,$99,$5,$9A,$92,$6C         *89
  DC.B $40,$26,$0,$60,$FD,$F7,$2,$FD,$0,$98,$40,$19,$1,$30,$38,$60,$E0,$6B,$FD
  DC.B $F7,$F7,$FC,$7,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$2C,$3,$1,$0
  DC.B $C,$52,$0,$40,$EC,$0,$1,$0,$2C,$5,$1,$0,$AC,$4,$1,$0,$F0
  DC.B $B5,$82,$B0,$29,$48,$1,$90,$C4,$1D,$FF,$34,$7A,$34,$A0,$6F         *8a
  DC.B $80,$26,$0,$60,$FD,$F7,$DE,$FC,$7,$1C,$A0,$6F,$FD,$F7,$DA,$FC,$1,$1C,$24
  DC.B $48,$13,$D0,$0,$2F,$11,$D0,$7A,$1E,$17,$6,$3F,$E,$1,$39,$9,$6
  DC.B $9,$E,$C9,$19,$A,$6,$12,$E,$0,$92,$1E,$49,$0,$23,$C9,$56,$8F
  DC.B $42,$2,$DA,$0,$9A,$8A,$42,$7,$DB,$1,$69,$9,$20,$FD,$F7         *8b
  DC.B $C0,$26,$0,$60,$C1,$FC,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$17,$4E,$17,$4C,$14
  DC.B $E0,$0,$20,$A7,$60,$0,$25,$20,$60,$7,$E0,$0,$21,$20,$20,$B2,$6C
  DC.B $FD,$F7,$B2,$FC,$68,$1C,$5,$6,$2D,$E,$11,$48,$0,$23,$C0,$56,$85
  DC.B $42,$F2,$DB,$78,$1C,$7,$6,$3F,$E,$0,$98,$87,$42,$E7,$DD         *8c
  DC.B $0,$27,$0,$60,$0,$20,$20,$60,$7,$23,$DB,$1,$1,$98,$C0,$18,$C0,$6B,$FD
  DC.B $F7,$97,$FC,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$AC,$1,$1,$0
  DC.B $2C,$4,$1,$0,$ED,$0,$1,$0,$AC,$4,$1,$0,$C,$52,$0,$40,$EC
  DC.B $0,$1,$0,$F0,$B5,$82,$B0,$17,$48,$1,$90,$FF,$30,$81,$30         *8d
  DC.B $40,$27,$0,$60,$80,$6F,$FD,$F7,$7D,$FC,$4,$1C,$14,$48,$0,$90,$0,$68,$6
  DC.B $6,$36,$E,$21,$18,$12,$4A,$0,$23,$D2,$56,$91,$42,$2,$D9,$10,$1A
  DC.B $4,$6,$24,$E,$0,$27,$F,$4D,$7,$E0,$0,$21,$20,$20,$AA,$6C,$FD
  DC.B $F7,$6A,$FC,$78,$1C,$7,$6,$3F,$E,$A7,$42,$F5,$DB,$0,$98         *8e
  DC.B $80,$27,$0,$60,$6,$60,$7,$23,$DB,$1,$1,$98,$C0,$18,$C0,$6B,$FD,$F7,$58
  DC.B $FC,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$AC,$1,$1,$0,$C,$52,$0,$40
  DC.B $EC,$0,$1,$0,$AC,$4,$1,$0,$0,$B5,$1,$20,$0,$F0,$8,$F8,$8
  DC.B $BC,$18,$47,$0,$B5,$0,$20,$0,$F0,$2,$F8,$8,$BC,$18,$47         *8f
  DC.B $C0,$27,$0,$60,$F1,$B5,$81,$B0,$16,$48,$0,$90,$FF,$30,$81,$30,$80,$6F,$FD
  DC.B $F7,$37,$FC,$4,$1C,$13,$4D,$28,$68,$1,$19,$13,$4A,$0,$23,$D2,$56
  DC.B $91,$42,$2,$D9,$10,$1A,$4,$6,$24,$E,$0,$27,$F,$4E,$9,$E0,$1
  DC.B $98,$31,$6D,$FD,$F7,$26,$FC,$28,$68,$1,$30,$28,$60,$78,$1C         *90
  DC.B $0,$28,$0,$60,$7,$6,$3F,$E,$A7,$42,$F3,$DB,$7,$23,$DB,$1,$0,$98,$C0
  DC.B $18,$C0,$6B,$FD,$F7,$15,$FC,$1,$B0,$F8,$BC,$8,$BC,$18,$47,$0,$0
  DC.B $AC,$1,$1,$0,$C,$52,$0,$40,$EC,$0,$1,$0,$AC,$4,$1,$0,$1
  DC.B $21,$4,$48,$40,$68,$0,$1,$3,$4A,$12,$68,$80,$18,$81,$60         *91
  DC.B $40,$28,$0,$60,$70,$47,$0,$0,$C,$52,$0,$40,$F4,$0,$1,$0,$0,$21,$4
  DC.B $48,$40,$68,$0,$1,$3,$4A,$12,$68,$80,$18,$81,$60,$70,$47,$0,$0
  DC.B $C,$52,$0,$40,$F4,$0,$1,$0,$90,$B5,$0,$20,$0,$F0,$A,$F9,$0
  DC.B $20,$FD,$27,$9,$49,$A,$4A,$6,$23,$4C,$69,$63,$43,$1B,$18         *92
  DC.B $80,$28,$0,$60,$5B,$0,$94,$68,$1B,$19,$5F,$70,$1,$30,$6,$28,$F4,$DB,$48
  DC.B $69,$0,$F0,$E6,$FA,$90,$BC,$8,$BC,$18,$47,$0,$0,$C,$52,$0,$40
  DC.B $70,$28,$0,$40,$90,$B5,$81,$B0,$21,$4C,$E0,$1D,$FF,$30,$7A,$30,$80
  DC.B $6F,$FD,$F7,$C5,$FB,$0,$AB,$18,$70,$0,$98,$80,$6,$40,$F         *93
  DC.B $C0,$28,$0,$60,$1C,$49,$0,$23,$C9,$56,$88,$42,$9,$DA,$0,$99,$49,$7,$49
  DC.B $F,$19,$4A,$D2,$56,$91,$42,$2,$DC,$0,$99,$49,$7,$7,$D1,$5,$23
  DC.B $DB,$1,$E0,$18,$1,$69,$2C,$20,$FD,$F7,$AC,$FB,$1C,$E0,$0,$27,$1
  DC.B $1,$12,$48,$2,$68,$57,$50,$0,$99,$89,$6,$49,$F,$9,$1         *94
  DC.B $0,$29,$0,$60,$0,$68,$8,$18,$47,$60,$7,$23,$DB,$1,$E1,$18,$0,$98,$89
  DC.B $6C,$FD,$F7,$98,$FB,$A,$48,$7,$61,$1,$20,$0,$F0,$B3,$F8,$0,$98
  DC.B $40,$7,$40,$F,$0,$F0,$E,$F8,$1,$B0,$90,$BC,$8,$BC,$18,$47,$AC
  DC.B $1,$1,$0,$EF,$0,$1,$0,$F0,$0,$1,$0,$F4,$0,$1,$0         *95
  DC.B $40,$29,$0,$60,$C,$52,$0,$40,$F0,$B5,$6,$6,$36,$E,$0,$27,$81,$B0,$11
  DC.B $49,$0,$91,$11,$4C,$E0,$19,$20,$30,$0,$7F,$B0,$42,$12,$D1,$4,$21
  DC.B $B,$20,$78,$43,$0,$19,$41,$70,$81,$78,$1,$31,$81,$70,$B8,$0,$5
  DC.B $19,$E8,$6A,$0,$28,$5,$D0,$0,$99,$9,$68,$FD,$F7,$62,$FB         *96
  DC.B $80,$29,$0,$60,$0,$20,$E8,$62,$1,$37,$4,$2F,$E4,$DB,$1,$B0,$F0,$BC,$8
  DC.B $BC,$18,$47,$0,$0,$F0,$3A,$0,$60,$24,$52,$0,$40,$0,$B5,$81,$B0
  DC.B $6,$48,$80,$6F,$FD,$F7,$4C,$FB,$0,$AB,$18,$70,$0,$98,$40,$7,$40
  DC.B $F,$FF,$F7,$C7,$FF,$1,$B0,$8,$BC,$18,$47,$2C,$3,$1,$0         *97
  DC.B $C0,$29,$0,$60,$F0,$B5,$83,$B0,$2C,$4E,$F7,$1D,$FF,$37,$7A,$37,$B8,$6F,$FD
  DC.B $F7,$37,$FB,$4,$1C,$B8,$6F,$FD,$F7,$33,$FB,$5,$1C,$B8,$6F,$FD,$F7
  DC.B $2F,$FB,$1,$1C,$38,$20,$20,$40,$C0,$8,$0,$6,$0,$16,$62,$7,$52
  DC.B $F,$12,$6,$12,$16,$0,$2D,$3,$D0,$0,$29,$1,$D0,$0,$28         *98
  DC.B $0,$2A,$0,$60,$A,$D1,$5,$23,$DB,$1,$F0,$18,$1,$69,$11,$20,$FD,$F7,$1A
  DC.B $FB,$3,$B0,$F0,$BC,$8,$BC,$18,$47,$18,$4C,$63,$69,$1B,$6,$1B,$E
  DC.B $0,$93,$1,$39,$A1,$60,$0,$21,$0,$27,$1,$38,$21,$60,$2,$90,$50
  DC.B $1E,$1,$90,$1,$3D,$13,$E0,$2,$98,$60,$61,$38,$1C,$29,$1C         *99
  DC.B $40,$2A,$0,$60,$FF,$F7,$42,$FD,$6,$1C,$38,$1C,$29,$1C,$FF,$F7,$5B,$FD,$1
  DC.B $1C,$1,$98,$60,$61,$30,$1C,$FF,$F7,$AB,$FC,$78,$1C,$7,$6,$3F,$E
  DC.B $7,$48,$0,$23,$C0,$56,$87,$42,$E6,$DB,$0,$9B,$63,$61,$3,$B0,$F0
  DC.B $BC,$8,$BC,$18,$47,$0,$0,$AC,$1,$1,$0,$C,$52,$0,$40         *9a
  DC.B $80,$2A,$0,$60,$EC,$0,$1,$0,$F0,$B5,$82,$B0,$1D,$49,$0,$28,$3,$D0,$0
  DC.B $23,$C8,$56,$2,$38,$1,$E0,$0,$23,$C8,$56,$0,$6,$0,$E,$0,$90
  DC.B $0,$24,$18,$48,$1,$90,$3,$23,$1B,$2,$C6,$18,$16,$4F,$14,$E0,$0
  DC.B $20,$BC,$60,$0,$25,$38,$60,$7,$E0,$0,$21,$20,$20,$B2,$6C         *9b
  DC.B $C0,$2A,$0,$60,$FD,$F7,$C2,$FA,$68,$1C,$5,$6,$2D,$E,$10,$48,$0,$23,$C0
  DC.B $56,$85,$42,$F2,$DB,$60,$1C,$4,$6,$24,$E,$0,$98,$84,$42,$E7,$DB
  DC.B $0,$20,$38,$60,$B8,$60,$38,$61,$7,$23,$DB,$1,$1,$98,$C0,$18,$C0
  DC.B $6B,$FD,$F7,$A5,$FA,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0         *9c
  DC.B $0,$2B,$0,$60,$ED,$0,$1,$0,$AC,$1,$1,$0,$C,$52,$0,$40,$EC,$0,$1
  DC.B $0,$F0,$B5,$0,$24,$86,$B0,$56,$4A,$5,$92,$D,$E0,$B,$20,$60,$43
  DC.B $5,$9A,$80,$18,$1,$79,$0,$29,$3,$D1,$81,$78,$C0,$78,$81,$42,$4
  DC.B $D0,$60,$1C,$4,$6,$24,$E,$4,$2C,$EF,$DB,$4D,$48,$5,$23         *9d
  DC.B $40,$2B,$0,$60,$DB,$1,$C5,$18,$4,$2C,$4E,$D0,$38,$23,$DB,$43,$0,$99,$19
  DC.B $40,$49,$4A,$4,$92,$52,$68,$52,$7,$52,$F,$D2,$0,$11,$43,$0,$91
  DC.B $C9,$8,$C9,$0,$4,$9A,$52,$69,$1,$32,$52,$7,$52,$F,$11,$43,$0
  DC.B $91,$80,$23,$DB,$43,$19,$40,$4,$9A,$12,$69,$D2,$7,$12,$E         *9e
  DC.B $80,$2B,$0,$60,$11,$43,$0,$91,$5B,$10,$19,$40,$0,$91,$C6,$1D,$FF,$36,$7A
  DC.B $36,$B0,$6F,$FD,$F7,$55,$FA,$3,$90,$B0,$6F,$FD,$F7,$51,$FA,$2,$90
  DC.B $B0,$6F,$FD,$F7,$4D,$FA,$1,$90,$34,$48,$0,$68,$FD,$F7,$48,$FA,$7
  DC.B $1C,$1,$20,$F8,$72,$0,$A9,$9,$78,$39,$73,$4,$99,$89,$68         *9f
  DC.B $C0,$2B,$0,$60,$9,$18,$79,$73,$4,$99,$9,$68,$9,$18,$B9,$73,$3,$99,$F9
  DC.B $73,$78,$71,$5,$20,$F8,$71,$0,$20,$B8,$72,$F0,$6F,$FD,$F7,$30,$FA
  DC.B $1,$99,$88,$42,$7,$D2,$13,$20,$29,$69,$FD,$F7,$2B,$FA,$6,$B0,$F0
  DC.B $BC,$8,$BC,$18,$47,$0,$25,$10,$E0,$1,$99,$8D,$42,$4,$DA         *a0
  DC.B $0,$2C,$0,$60,$B0,$6F,$FD,$F7,$1D,$FA,$2,$1C,$0,$E0,$20,$22,$F8,$79,$41
  DC.B $1C,$F9,$71,$C0,$19,$C2,$72,$68,$1C,$5,$6,$2D,$E,$3,$99,$8D,$42
  DC.B $EB,$DB,$5,$E0,$B0,$6F,$FD,$F7,$B,$FA,$68,$1C,$5,$6,$2D,$E,$1
  DC.B $99,$8D,$42,$F6,$DB,$A0,$0,$5,$9A,$80,$18,$C7,$62,$2,$98         *a1
  DC.B $40,$2C,$0,$60,$83,$0,$18,$18,$B,$21,$61,$43,$5,$9A,$50,$54,$3,$20,$5
  DC.B $9A,$89,$18,$48,$70,$88,$78,$1,$30,$88,$70,$4,$99,$48,$69,$5,$9A
  DC.B $11,$19,$1,$30,$20,$31,$8,$77,$6,$B0,$F0,$BC,$8,$BC,$18,$47,$24
  DC.B $52,$0,$40,$AC,$1,$1,$0,$C,$52,$0,$40,$F4,$3A,$0,$60         *a2
  DC.B $80,$2C,$0,$60,$0,$B5,$5,$48,$80,$6F,$FD,$F7,$DB,$F9,$1,$22,$1,$1C,$14
  DC.B $20,$0,$F0,$84,$FA,$8,$BC,$18,$47,$2C,$3,$1,$0,$F0,$B5,$84,$B0
  DC.B $35,$49,$3,$91,$C8,$1D,$FF,$30,$7A,$30,$2,$90,$80,$6F,$FD,$F7,$C7
  DC.B $F9,$5,$1C,$2,$98,$80,$6F,$FD,$F7,$C2,$F9,$4,$1C,$2F,$4E         *a3
  DC.B $C0,$2C,$0,$60,$FD,$2D,$5,$DC,$2,$98,$C0,$6F,$FD,$F7,$BA,$F9,$A0,$42,$3
  DC.B $D2,$15,$20,$31,$69,$FD,$F7,$B6,$F9,$A8,$0,$1,$90,$28,$49,$0,$91
  DC.B $C9,$6A,$F,$58,$0,$2F,$6,$D0,$31,$6D,$38,$1C,$FD,$F7,$AA,$F9,$A0
  DC.B $42,$0,$DA,$0,$27,$0,$2F,$12,$D1,$3,$99,$80,$31,$C9,$6D         *a4
  DC.B $0,$2D,$0,$60,$60,$1C,$FD,$F7,$9F,$F9,$1,$99,$0,$9A,$D2,$6A,$50,$50,$FB
  DC.B $43,$98,$42,$4,$D1,$15,$20,$31,$69,$FD,$F7,$94,$F9,$27,$E0,$7,$1C
  DC.B $0,$26,$6,$E0,$2,$98,$80,$6F,$FD,$F7,$8A,$F9,$38,$70,$1,$36,$1
  DC.B $37,$A6,$42,$F6,$DB,$0,$20,$38,$70,$0,$27,$11,$4C,$12,$E0         *a5
  DC.B $40,$2D,$0,$60,$0,$20,$6,$22,$7A,$43,$E,$49,$89,$68,$13,$18,$5B,$0,$5B
  DC.B $18,$5B,$78,$AB,$42,$3,$D1,$38,$1C,$0,$F0,$82,$F8,$2,$E0,$1,$30
  DC.B $6,$28,$F2,$DB,$1,$37,$0,$23,$E0,$56,$87,$42,$E8,$DB,$4,$B0,$F0
  DC.B $BC,$8,$BC,$18,$47,$0,$0,$AC,$1,$1,$0,$2C,$4,$1,$0         *a6
  DC.B $80,$2D,$0,$60,$70,$28,$0,$40,$F0,$0,$1,$0,$F0,$B5,$83,$B0,$21,$48,$2
  DC.B $90,$C4,$1D,$FF,$34,$7A,$34,$A0,$6F,$FD,$F7,$52,$F9,$F8,$23,$6,$1C
  DC.B $18,$40,$C5,$8,$28,$1C,$0,$F0,$87,$FA,$1B,$4F,$78,$69,$0,$90,$70
  DC.B $7,$40,$F,$41,$1E,$FF,$20,$6,$23,$79,$61,$59,$43,$49,$19         *a7
  DC.B $C0,$2D,$0,$60,$49,$0,$16,$4A,$92,$68,$89,$18,$20,$39,$C8,$77,$A0,$6F,$FD
  DC.B $F7,$37,$F9,$5,$1C,$3,$23,$1B,$2,$2,$98,$C1,$18,$1,$91,$8A,$6C
  DC.B $0,$21,$20,$20,$FD,$F7,$30,$F9,$0,$26,$AE,$42,$3,$DA,$A0,$6F,$FD
  DC.B $F7,$26,$F9,$0,$E0,$20,$20,$1,$99,$8A,$6C,$0,$21,$FD,$F7         *a8
  DC.B $0,$2E,$0,$60,$23,$F9,$1,$36,$C,$2E,$F0,$DB,$0,$98,$78,$61,$3,$B0,$F0
  DC.B $BC,$8,$BC,$18,$47,$AC,$1,$1,$0,$C,$52,$0,$40,$70,$28,$0,$40
  DC.B $80,$B5,$D,$48,$80,$6F,$FD,$F7,$B,$F9,$FD,$27,$41,$7,$49,$F,$4A
  DC.B $0,$52,$18,$52,$0,$F8,$23,$18,$40,$C0,$8,$10,$18,$40,$0         *a9
  DC.B $40,$2E,$0,$60,$6,$4A,$92,$68,$80,$18,$20,$38,$C7,$74,$48,$1E,$0,$F0,$8
  DC.B $F8,$80,$BC,$8,$BC,$18,$47,$0,$0,$2C,$3,$1,$0,$70,$28,$0,$40
  DC.B $F0,$B5,$85,$B0,$27,$49,$4,$91,$49,$69,$0,$91,$4,$99,$0,$27,$48
  DC.B $61,$6,$21,$41,$43,$3,$91,$23,$48,$2,$90,$23,$4C,$24,$4E         *aa
  DC.B $80,$2E,$0,$60,$4,$98,$40,$69,$6,$23,$58,$43,$C0,$19,$40,$0,$A1,$68,$40
  DC.B $18,$45,$78,$78,$1C,$1,$90,$0,$F0,$F,$FA,$FD,$2D,$14,$D0,$FE,$2D
  DC.B $1C,$D0,$FF,$2D,$24,$D0,$A8,$0,$E1,$6A,$F,$58,$0,$21,$20,$20,$B2
  DC.B $6C,$FD,$F7,$C9,$F8,$0,$2F,$0,$D1,$16,$A7,$0,$25,$38,$78         *ab
  DC.B $C0,$2E,$0,$60,$0,$28,$D,$D0,$1,$37,$C,$E0,$0,$20,$3,$99,$C9,$19,$49
  DC.B $0,$A2,$68,$50,$54,$2,$98,$0,$68,$0,$21,$4,$DF,$0,$27,$E5,$E7
  DC.B $20,$20,$0,$21,$B2,$6C,$FD,$F7,$AF,$F8,$1,$35,$C,$2D,$E6,$DB,$1
  DC.B $9F,$6,$2F,$C4,$DB,$0,$98,$4,$99,$48,$61,$5,$B0,$F0,$BC         *ac
  DC.B $0,$2F,$0,$60,$8,$BC,$18,$47,$C,$52,$0,$40,$BC,$28,$0,$40,$70,$28,$0
  DC.B $40,$AC,$4,$1,$0,$20,$0,$0,$0,$80,$B5,$B,$48,$40,$69,$1,$23
  DC.B $D8,$42,$5,$D1,$9,$48,$1,$69,$18,$20,$FD,$F7,$8B,$F8,$1,$E0,$7
  DC.B $49,$8,$70,$7,$4F,$1,$21,$38,$68,$4,$DF,$0,$21,$38,$68         *ad
  DC.B $40,$2F,$0,$60,$4,$DF,$80,$BC,$8,$BC,$18,$47,$C,$52,$0,$40,$2C,$4,$1
  DC.B $0,$4,$1,$1,$0,$BC,$28,$0,$40,$0,$B5,$82,$B0,$1E,$48,$80,$6F
  DC.B $FD,$F7,$6E,$F8,$0,$AB,$18,$70,$0,$98,$80,$6,$40,$F,$1B,$49,$2
  DC.B $1,$48,$60,$1A,$4B,$1B,$68,$D2,$18,$D2,$68,$1,$9B,$DB,$8         *ae
  DC.B $80,$2F,$0,$60,$DB,$0,$1,$32,$52,$7,$52,$F,$1A,$43,$1,$92,$38,$23,$DB
  DC.B $43,$1A,$40,$C0,$0,$10,$43,$1,$90,$40,$23,$DB,$43,$18,$40,$1,$90
  DC.B $80,$23,$DB,$43,$18,$40,$1,$90,$4,$22,$E,$48,$82,$70,$1,$AA,$12
  DC.B $78,$C2,$70,$8A,$68,$1,$32,$2,$71,$9,$68,$1,$31,$41,$71         *af
  DC.B $C0,$2F,$0,$60,$0,$20,$9,$49,$8,$70,$9,$48,$1,$23,$5B,$2,$1,$68,$19
  DC.B $43,$1,$60,$2,$B0,$8,$BC,$18,$47,$2C,$3,$1,$0,$C,$52,$0,$40
  DC.B $F4,$0,$1,$0,$EC,$5,$1,$0,$C4,$0,$1,$0,$BC,$0,$1,$0,$F0
  DC.B $B5,$82,$B0,$31,$48,$1,$90,$C4,$1D,$FF,$34,$7A,$34,$A0,$6F         *b0
  DC.B $0,$30,$0,$60,$FD,$F7,$1E,$F8,$0,$AB,$18,$70,$0,$98,$80,$6,$41,$F,$2C
  DC.B $48,$0,$23,$C0,$56,$2B,$4F,$81,$42,$27,$DA,$0,$98,$40,$7,$40,$F
  DC.B $29,$49,$C9,$56,$88,$42,$20,$DC,$40,$23,$0,$98,$18,$40,$FE,$1D,$F9
  DC.B $36,$0,$28,$26,$D1,$E0,$6F,$FD,$F7,$2,$F8,$2,$28,$14,$D3         *b1
  DC.B $40,$30,$0,$60,$A0,$6F,$FC,$F7,$FD,$FF,$5,$1C,$A0,$6F,$FC,$F7,$F9,$FF,$1
  DC.B $1C,$B,$D0,$1E,$48,$0,$23,$C0,$56,$1,$30,$88,$42,$5,$DB,$0,$2D
  DC.B $3,$D0,$1B,$48,$C0,$56,$85,$42,$7,$DD,$2A,$20,$39,$69,$FC,$F7,$E9
  DC.B $FF,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$98,$F3,$6C,$2A,$1C         *b2
  DC.B $80,$30,$0,$60,$FC,$F7,$E4,$FF,$0,$98,$0,$6,$C0,$F,$12,$4F,$38,$61,$38
  DC.B $68,$0,$28,$B,$D9,$44,$1E,$3C,$60,$3,$23,$1B,$2,$1,$98,$C0,$18
  DC.B $0,$21,$82,$6C,$20,$20,$FC,$F7,$CF,$FF,$3C,$60,$F0,$6B,$FC,$F7,$C7
  DC.B $FF,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$AC,$1,$1,$0         *b3
  DC.B $C0,$30,$0,$60,$EF,$0,$1,$0,$2C,$4,$1,$0,$F0,$0,$1,$0,$EC,$0,$1
  DC.B $0,$ED,$0,$1,$0,$C,$52,$0,$40,$90,$B5,$8,$4C,$A0,$6F,$FC,$F7
  DC.B $AF,$FF,$7,$1C,$A0,$6F,$FC,$F7,$AB,$FF,$2,$1C,$2D,$20,$39,$1C,$0
  DC.B $F0,$54,$F8,$90,$BC,$8,$BC,$18,$47,$0,$0,$2C,$3,$1,$0         *b4
  DC.B $0,$31,$0,$60,$F7,$B5,$4,$6,$24,$E,$84,$B0,$0,$94,$0,$21,$1D,$4F,$3
  DC.B $97,$1D,$4F,$2,$97,$1,$26,$1D,$4A,$1,$92,$26,$E0,$0,$20,$18,$E0
  DC.B $3,$9F,$3C,$68,$F,$1C,$67,$43,$0,$9C,$5C,$43,$3B,$19,$1B,$18,$2
  DC.B $9F,$3F,$68,$FA,$54,$DF,$10,$1,$9A,$12,$68,$D4,$5D,$5D,$7         *b5
  DC.B $40,$31,$0,$60,$6D,$F,$33,$1C,$AB,$40,$DB,$43,$23,$40,$D3,$55,$1,$30,$0
  DC.B $6,$0,$E,$F,$4A,$0,$23,$D3,$56,$98,$42,$3,$DA,$6,$9A,$12,$5C
  DC.B $0,$2A,$DD,$D1,$48,$1C,$1,$6,$9,$E,$A,$48,$0,$23,$C0,$56,$81
  DC.B $42,$D3,$DB,$8,$48,$0,$68,$1,$21,$4,$DF,$4,$B0,$FE,$BC         *b6
  DC.B $80,$31,$0,$60,$8,$BC,$18,$47,$70,$28,$0,$40,$8,$1,$1,$0,$C,$1,$1
  DC.B $0,$EC,$0,$1,$0,$F0,$0,$1,$0,$BC,$28,$0,$40,$F0,$B5,$F8,$23
  DC.B $B,$40,$DD,$8,$AB,$18,$1,$3B,$82,$B0,$19,$4F,$6,$2B,$9,$DD,$1
  DC.B $23,$DB,$3,$18,$43,$5,$23,$DB,$1,$F9,$18,$9,$69,$FC,$F7         *b7
  DC.B $C0,$31,$0,$60,$41,$FF,$20,$E0,$48,$7,$40,$F,$1,$38,$4,$6,$24,$E,$6
  DC.B $20,$60,$43,$80,$18,$0,$27,$46,$1E,$E,$48,$1,$90,$E,$4A,$0,$92
  DC.B $C,$E0,$1,$98,$80,$6F,$FC,$F7,$2B,$FF,$F1,$19,$49,$0,$0,$9A,$92
  DC.B $68,$89,$18,$48,$70,$78,$1C,$7,$6,$3F,$E,$AF,$42,$F0,$DB         *b8
  DC.B $0,$32,$0,$60,$20,$1C,$FF,$F7,$2D,$FE,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$0
  DC.B $0,$AC,$1,$1,$0,$2C,$3,$1,$0,$70,$28,$0,$40,$B0,$B4,$21,$4A
  DC.B $12,$68,$52,$6,$12,$F,$6,$2A,$39,$D1,$1F,$4C,$22,$78,$6,$23,$5A
  DC.B $43,$12,$18,$53,$0,$1D,$4F,$BA,$68,$9B,$18,$20,$3B,$9D,$7F         *b9
  DC.B $40,$32,$0,$60,$0,$2D,$2C,$D0,$0,$29,$2,$D0,$2,$20,$98,$77,$23,$E0,$0
  DC.B $21,$17,$4D,$0,$23,$ED,$56,$1C,$E0,$6,$23,$4B,$43,$1B,$18,$5B,$0
  DC.B $9B,$18,$20,$3B,$9B,$7F,$2,$2B,$10,$D1,$1,$25,$6,$23,$59,$43,$9
  DC.B $18,$49,$0,$89,$18,$20,$39,$8D,$77,$21,$78,$59,$43,$8,$18         *ba
  DC.B $80,$32,$0,$60,$40,$0,$B9,$68,$40,$18,$20,$38,$85,$77,$4,$E0,$1,$31,$9
  DC.B $6,$9,$E,$A9,$42,$E0,$DB,$7,$48,$0,$68,$0,$21,$4,$DF,$B0,$BC
  DC.B $70,$47,$0,$0,$3C,$0,$1,$0,$4,$1,$1,$0,$70,$28,$0,$40,$F0
  DC.B $0,$1,$0,$BC,$28,$0,$40,$B0,$B5,$1,$25,$47,$1E,$E,$4C         *bb
  DC.B $C0,$32,$0,$60,$3,$20,$25,$61,$39,$1C,$FC,$F7,$E7,$FE,$D,$23,$59,$43,$2
  DC.B $30,$A0,$60,$21,$60,$6,$23,$60,$69,$58,$43,$C0,$19,$40,$0,$7,$49
  DC.B $89,$68,$A,$5C,$0,$2A,$4,$D1,$D,$54,$5,$48,$0,$68,$0,$21,$4
  DC.B $DF,$B0,$BC,$8,$BC,$18,$47,$C,$52,$0,$40,$70,$28,$0,$40         *bc
  DC.B $0,$33,$0,$60,$BC,$28,$0,$40,$F0,$B5,$81,$B0,$26,$48,$0,$90,$C7,$1D,$FF
  DC.B $37,$7A,$37,$B8,$6F,$FC,$F7,$94,$FE,$4,$1C,$B8,$6F,$FC,$F7,$90,$FE
  DC.B $6,$1C,$B8,$6F,$FC,$F7,$8C,$FE,$5,$1C,$1F,$48,$0,$68,$40,$6,$0
  DC.B $F,$6,$28,$1,$D0,$7,$2C,$E,$DC,$6,$28,$3,$D1,$B4,$2C         *bd
  DC.B $40,$33,$0,$60,$A,$DC,$A2,$2C,$8,$DB,$8,$2E,$6,$D1,$8,$2D,$4,$D1,$F8
  DC.B $6F,$FC,$F7,$76,$FE,$8,$28,$7,$D2,$0,$98,$FF,$30,$FF,$30,$82,$30
  DC.B $1,$69,$30,$20,$FC,$F7,$6E,$FE,$10,$4E,$3,$21,$30,$68,$4,$DF,$8
  DC.B $20,$5,$DF,$39,$6C,$20,$1C,$FC,$F7,$64,$FE,$0,$24,$8,$E0         *be
  DC.B $80,$33,$0,$60,$B8,$6F,$FC,$F7,$5D,$FE,$B9,$6B,$FC,$F7,$5C,$FE,$60,$1C,$4
  DC.B $6,$24,$E,$AC,$42,$F4,$DB,$4,$21,$30,$68,$4,$DF,$1,$B0,$F0,$BC
  DC.B $8,$BC,$18,$47,$AC,$1,$1,$0,$3C,$0,$1,$0,$BC,$28,$0,$40,$F0
  DC.B $B5,$16,$48,$0,$68,$40,$6,$0,$F,$6,$28,$1B,$D1,$0,$27         *bf
  DC.B $C0,$33,$0,$60,$13,$4E,$14,$4D,$14,$4C,$30,$78,$6,$23,$58,$43,$C0,$19,$40
  DC.B $0,$A9,$68,$8,$5C,$E1,$5D,$81,$42,$A,$D0,$E0,$55,$E0,$5D,$0,$28
  DC.B $C,$D0,$1,$28,$E,$D0,$2,$28,$2,$D1,$78,$1C,$FE,$F7,$72,$FD,$1
  DC.B $37,$6,$2F,$E7,$DB,$F0,$BC,$8,$BC,$18,$47,$78,$1C,$FE,$F7         *c0
  DC.B $0,$34,$0,$60,$5D,$FD,$F5,$E7,$78,$1C,$FE,$F7,$4B,$FD,$F1,$E7,$3C,$0,$1
  DC.B $0,$4,$1,$1,$0,$70,$28,$0,$40,$7C,$28,$0,$40,$F0,$B5,$0,$27
  DC.B $82,$B0,$15,$4E,$15,$48,$1,$90,$15,$48,$0,$90,$15,$4C,$1D,$E0,$B
  DC.B $20,$78,$43,$0,$19,$41,$79,$0,$29,$14,$D0,$82,$79,$C1,$79         *c1
  DC.B $40,$34,$0,$60,$8A,$42,$10,$D0,$1,$31,$C1,$71,$B8,$0,$5,$19,$EA,$6A,$1
  DC.B $98,$3,$68,$1,$20,$31,$1C,$FC,$F7,$F9,$FD,$0,$20,$E8,$62,$0,$98
  DC.B $0,$68,$0,$21,$4,$DF,$78,$1C,$7,$6,$3F,$E,$4,$2F,$DF,$DB,$2
  DC.B $B0,$F0,$BC,$8,$BC,$18,$47,$E8,$3B,$0,$40,$EC,$3A,$0,$60         *c2
  DC.B $80,$34,$0,$60,$A4,$28,$0,$40,$24,$52,$0,$40,$B0,$B4,$0,$20,$0,$21,$16
  DC.B $4A,$11,$71,$16,$49,$9,$68,$49,$6,$B,$F,$20,$21,$6,$2B,$6,$D0
  DC.B $A,$1C,$11,$49,$9,$79,$52,$1A,$11,$4F,$12,$4B,$6,$E0,$20,$20,$11
  DC.B $71,$F5,$E7,$44,$1A,$3C,$54,$1A,$54,$1,$30,$80,$28,$F9,$DB         *c3
  DC.B $C0,$34,$0,$60,$0,$20,$D,$4A,$D1,$1F,$19,$39,$C,$18,$65,$78,$C,$5C,$3D
  DC.B $55,$10,$28,$3,$D2,$14,$18,$64,$78,$15,$5C,$5C,$55,$2,$30,$20,$28
  DC.B $F2,$D3,$B0,$BC,$70,$47,$0,$0,$70,$28,$0,$40,$3C,$0,$1,$0,$E4
  DC.B $52,$0,$40,$64,$52,$0,$40,$3C,$3D,$0,$60,$F0,$B5,$2,$6         *c4
  DC.B $0,$35,$0,$60,$12,$E,$86,$B0,$0,$92,$84,$B0,$57,$4D,$58,$48,$9,$90,$0
  DC.B $68,$40,$6,$0,$F,$6,$28,$1,$D0,$1,$20,$0,$E0,$0,$20,$0,$90
  DC.B $0,$21,$3,$91,$52,$49,$8,$91,$52,$4A,$7,$92,$52,$48,$6,$90,$52
  DC.B $4A,$5,$92,$6F,$E0,$0,$98,$0,$28,$4,$D1,$3,$99,$5,$9A         *c5
  DC.B $40,$35,$0,$60,$52,$6B,$FC,$F7,$81,$FD,$4E,$48,$1,$78,$6,$98,$0,$68,$41
  DC.B $43,$3,$9A,$4C,$48,$0,$23,$C3,$56,$5A,$43,$8F,$18,$8,$99,$9,$68
  DC.B $C9,$19,$2,$91,$F9,$10,$7,$9A,$12,$68,$89,$18,$1,$91,$0,$26,$47
  DC.B $E0,$78,$7,$40,$F,$1,$21,$81,$40,$1,$98,$0,$78,$8,$40         *c6
  DC.B $80,$35,$0,$60,$1,$D0,$1,$21,$0,$E0,$0,$21,$2,$98,$0,$78,$18,$28,$2
  DC.B $DB,$1F,$28,$0,$DC,$1,$21,$4,$9A,$0,$2A,$1,$D1,$1,$22,$0,$E0
  DC.B $0,$22,$11,$40,$8,$D0,$1,$A,$4,$D3,$6,$98,$0,$79,$20,$21,$8
  DC.B $1A,$5,$E0,$34,$49,$2,$E0,$1,$A,$1,$D2,$33,$49,$8,$5C         *c7
  DC.B $C0,$35,$0,$60,$4,$6,$24,$E,$0,$98,$0,$28,$9,$D0,$28,$78,$84,$42,$B
  DC.B $D0,$2C,$70,$3,$99,$5,$9A,$52,$6B,$30,$1C,$FC,$F7,$35,$FD,$5,$9A
  DC.B $91,$6B,$20,$1C,$FC,$F7,$2E,$FD,$2,$98,$1,$30,$2,$90,$1,$35,$1
  DC.B $37,$78,$7,$2,$D1,$1,$98,$1,$30,$1,$90,$70,$1C,$6,$6         *c8
  DC.B $0,$36,$0,$60,$36,$E,$20,$48,$0,$23,$C0,$56,$86,$42,$B2,$DB,$3,$99,$48
  DC.B $1C,$1,$6,$9,$E,$3,$91,$3,$99,$1D,$48,$0,$23,$C0,$56,$81,$42
  DC.B $89,$DB,$17,$48,$7,$78,$DB,$43,$9F,$42,$0,$D1,$0,$27,$19,$48,$C0
  DC.B $5D,$5,$9A,$D1,$6B,$FC,$F7,$5,$FD,$17,$4D,$E9,$5D,$17,$4C         *c9
  DC.B $40,$36,$0,$60,$E0,$5D,$5,$9A,$52,$6B,$FC,$F7,$FF,$FC,$9,$98,$0,$68,$40
  DC.B $6,$0,$F,$6,$28,$3,$D1,$E9,$5D,$E0,$5D,$FE,$F7,$87,$FB,$A,$B0
  DC.B $F0,$BC,$8,$BC,$18,$47,$0,$0,$64,$53,$0,$40,$3C,$0,$1,$0,$8
  DC.B $1,$1,$0,$C,$1,$1,$0,$70,$28,$0,$40,$2C,$3,$1,$0         *ca
  DC.B $80,$36,$0,$60,$4,$1,$1,$0,$EC,$0,$1,$0,$64,$52,$0,$40,$E4,$52,$0
  DC.B $40,$ED,$0,$1,$0,$82,$28,$0,$40,$92,$28,$0,$40,$8A,$28,$0,$40
  DC.B $F0,$B5,$4A,$4E,$4A,$4D,$4B,$4C,$4B,$4F,$38,$88,$2,$28,$46,$D0,$4
  DC.B $28,$73,$D0,$5,$28,$18,$D0,$7,$28,$F6,$D1,$20,$68,$C1,$9         *cb
  DC.B $C0,$36,$0,$60,$F3,$D2,$81,$9,$F1,$D2,$41,$9,$EF,$D2,$81,$8,$ED,$D2,$40
  DC.B $8,$EB,$D2,$C,$23,$F8,$5E,$0,$28,$E7,$D0,$A,$23,$F8,$5E,$B,$28
  DC.B $62,$DD,$0,$21,$B9,$81,$79,$81,$DF,$E7,$B8,$88,$1,$30,$B8,$80,$3A
  DC.B $49,$3B,$48,$1,$80,$0,$23,$C0,$5E,$89,$6,$48,$84,$20,$23         *cc
  DC.B $0,$37,$0,$60,$C8,$5E,$0,$28,$D,$D1,$37,$48,$37,$49,$8,$80,$0,$21,$37
  DC.B $48,$1,$80,$7,$20,$38,$80,$1,$20,$31,$68,$FC,$F7,$93,$FC,$0,$21
  DC.B $B9,$80,$B8,$88,$C8,$28,$C0,$DD,$0,$21,$B9,$80,$2,$20,$38,$80,$F8
  DC.B $88,$5,$28,$0,$DD,$39,$80,$1,$30,$F8,$80,$B5,$E7,$3,$20         *cd
  DC.B $40,$37,$0,$60,$C0,$3,$41,$68,$F0,$23,$DB,$43,$19,$40,$40,$23,$19,$43,$41
  DC.B $60,$11,$20,$0,$3,$1,$6A,$20,$23,$DB,$43,$19,$40,$1,$62,$1,$6A
  DC.B $4,$23,$19,$43,$1,$62,$D,$20,$40,$3,$1,$68,$20,$4B,$19,$40,$40
  DC.B $23,$19,$43,$1,$60,$17,$21,$9,$3,$48,$68,$1D,$4B,$18,$40         *ce
  DC.B $80,$37,$0,$60,$48,$60,$8,$68,$18,$40,$8,$60,$1,$20,$3,$DF,$17,$21,$9
  DC.B $3,$8,$68,$1,$23,$9B,$5,$18,$43,$8,$60,$0,$E0,$8,$E0,$78,$88
  DC.B $0,$28,$2,$D0,$4,$20,$1,$E0,$D,$E0,$8,$20,$38,$80,$7C,$E7,$FC
  DC.B $F7,$D2,$FE,$0,$21,$B9,$81,$F,$49,$10,$48,$2A,$68,$FC,$F7         *cf
  DC.B $C0,$37,$0,$60,$43,$FC,$5,$20,$F2,$E7,$1,$30,$78,$81,$6E,$E7,$E0,$3A,$0
  DC.B $60,$DC,$3A,$0,$60,$40,$0,$1,$0,$D8,$28,$0,$40,$8,$60,$0,$0
  DC.B $6C,$1,$1,$0,$E1,$BD,$FF,$FF,$B0,$A,$1,$0,$AE,$A,$1,$0,$3F
  DC.B $FC,$FF,$FF,$FF,$FF,$BF,$FF,$AD,$5,$0,$60,$9D,$6,$0,$60         *d0
  DC.B $0,$38,$0,$60,$11,$8,$0,$60,$9,$6,$0,$40,$F4,$1,$C8,$0,$54,$0,$0
  DC.B $0,$95,$5,$0,$40,$F4,$1,$FA,$0,$54,$0,$0,$0,$3D,$4,$0,$40
  DC.B $F4,$1,$2C,$1,$54,$0,$0,$0,$4D,$5,$0,$40,$F4,$1,$5E,$1,$54
  DC.B $0,$0,$0,$11,$7,$0,$40,$F4,$1,$90,$1,$54,$0,$0,$0         *d1
  DC.B $40,$38,$0,$60,$11,$7,$0,$40,$2C,$1,$F4,$1,$54,$0,$0,$0,$19,$93,$0
  DC.B $0,$40,$0,$20,$3,$54,$0,$0,$0,$51,$6,$0,$40,$90,$1,$96,$0
  DC.B $54,$0,$0,$0,$A1,$36,$0,$60,$90,$1,$64,$0,$54,$0,$0,$0,$48
  DC.B $0,$0,$0,$45,$D,$0,$60,$23,$0,$0,$0,$E1,$16,$0,$60         *d2
  DC.B $80,$38,$0,$60,$22,$0,$0,$0,$5,$15,$0,$60,$19,$0,$0,$0,$CD,$14,$0
  DC.B $60,$A2,$0,$0,$0,$59,$E,$0,$60,$9F,$0,$0,$0,$89,$F,$0,$60
  DC.B $A4,$0,$0,$0,$9,$10,$0,$60,$C,$0,$0,$0,$AD,$6,$0,$60,$10
  DC.B $0,$0,$0,$D1,$7,$0,$60,$16,$0,$0,$0,$5D,$20,$0,$40         *d3
  DC.B $C0,$38,$0,$60,$78,$0,$0,$0,$ED,$B,$0,$40,$79,$0,$0,$0,$75,$E,$0
  DC.B $40,$7E,$0,$0,$0,$A5,$19,$0,$40,$7F,$0,$0,$0,$BD,$19,$0,$40
  DC.B $81,$0,$0,$0,$61,$A,$0,$40,$84,$0,$0,$0,$81,$A,$0,$40,$89
  DC.B $0,$0,$0,$35,$E,$0,$40,$8B,$0,$0,$0,$85,$3,$0,$40         *d4
  DC.B $0,$39,$0,$60,$8F,$0,$0,$0,$89,$17,$0,$40,$91,$0,$0,$0,$25,$F,$0
  DC.B $40,$92,$0,$0,$0,$45,$F,$0,$40,$A2,$0,$0,$0,$CD,$19,$0,$40
  DC.B $A3,$0,$0,$0,$8D,$1A,$0,$40,$9,$0,$0,$0,$9,$2,$0,$40,$7
  DC.B $0,$0,$0,$1,$3,$0,$40,$A7,$0,$0,$0,$B5,$3,$0,$40         *d5
  DC.B $40,$39,$0,$60,$D1,$0,$0,$0,$AB,$22,$0,$60,$CE,$0,$0,$0,$69,$20,$0
  DC.B $60,$F2,$0,$0,$0,$41,$22,$0,$60,$F3,$0,$0,$0,$79,$22,$0,$60
  DC.B $CF,$0,$0,$0,$A9,$22,$0,$60,$EF,$0,$0,$0,$AD,$22,$0,$60,$D4
  DC.B $0,$0,$0,$55,$23,$0,$60,$D2,$0,$0,$0,$B1,$23,$0,$60         *d6
  DC.B $80,$39,$0,$60,$D8,$0,$0,$0,$1D,$24,$0,$60,$F0,$0,$0,$0,$5,$25,$0
  DC.B $60,$F1,$0,$0,$0,$C9,$24,$0,$60,$D9,$0,$0,$0,$51,$25,$0,$60
  DC.B $DA,$0,$0,$0,$5D,$25,$0,$60,$DB,$0,$0,$0,$69,$25,$0,$60,$DC
  DC.B $0,$0,$0,$75,$25,$0,$60,$DD,$0,$0,$0,$71,$26,$0,$60         *d7
  DC.B $C0,$39,$0,$60,$DE,$0,$0,$0,$35,$27,$0,$60,$DF,$0,$0,$0,$A9,$27,$0
  DC.B $60,$E2,$0,$0,$0,$31,$28,$0,$60,$E3,$0,$0,$0,$4D,$28,$0,$60
  DC.B $EB,$0,$0,$0,$A5,$28,$0,$60,$E6,$0,$0,$0,$11,$2B,$0,$60,$E7
  DC.B $0,$0,$0,$19,$2F,$0,$60,$E8,$0,$0,$0,$59,$2F,$0,$60         *d8
  DC.B $0,$3A,$0,$60,$E9,$0,$0,$0,$F1,$2F,$0,$60,$EE,$0,$0,$0,$1,$31,$0
  DC.B $60,$ED,$0,$0,$0,$5,$33,$0,$60,$EA,$0,$0,$0,$9D,$29,$0,$60
  DC.B $98,$0,$0,$0,$39,$14,$0,$60,$E4,$0,$0,$0,$C1,$29,$0,$60,$42
  DC.B $0,$0,$0,$29,$E,$0,$60,$53,$0,$0,$0,$9,$4,$0,$40         *d9
  DC.B $40,$3A,$0,$60,$6A,$0,$0,$0,$29,$1C,$0,$60,$6B,$0,$0,$0,$E9,$1D,$0
  DC.B $60,$6C,$0,$0,$0,$6D,$1C,$0,$60,$6D,$0,$0,$0,$29,$1D,$0,$60
  DC.B $6E,$0,$0,$0,$F1,$1E,$0,$60,$6F,$0,$0,$0,$1D,$1F,$0,$60,$70
  DC.B $0,$0,$0,$A5,$1D,$0,$60,$3C,$0,$0,$0,$A1,$D,$0,$60         *da
  DC.B $80,$3A,$0,$60,$1D,$0,$0,$0,$39,$1B,$0,$60,$39,$2B,$0,$0,$C5,$2D,$0
  DC.B $0,$3D,$33,$0,$0,$65,$31,$0,$0,$91,$90,$0,$0,$F9,$67,$0,$0
  DC.B $AD,$71,$0,$0,$F1,$12,$0,$0,$3D,$8F,$0,$0,$44,$94,$0,$0,$E1
  DC.B $C,$0,$0,$65,$1E,$0,$0,$31,$1E,$0,$0,$59,$6F,$0,$0         *db
  DC.B $C0,$3A,$0,$60,$89,$6F,$0,$0,$D4,$86,$0,$0,$8,$3,$0,$0,$C9,$1F,$0
  DC.B $40,$59,$E,$0,$60,$65,$14,$0,$60,$75,$93,$0,$0,$41,$C,$0,$60
  DC.B $CD,$4,$0,$60,$FD,$34,$0,$60,$1D,$34,$0,$60,$F9,$0,$0,$40,$E1
  DC.B $1,$0,$40,$BF,$0,$0,$40,$79,$D,$0,$60,$B5,$1,$0,$40         *dc
  DC.B $0,$3B,$0,$60,$55,$12,$0,$60,$12,$80,$3,$4,$1,$28,$1,$24,$4D,$54,$4C
  DC.B $34,$31,$F2,$35,$30,$32,$35,$5C,$5C,$5C,$5C,$4D,$69,$74,$65,$6C,$20
  DC.B $53,$53,$34,$31,$F2,$35,$30,$32,$35,$20,$52,$53,$32,$33,$32,$20,$50
  DC.B $68,$6F,$6E,$65,$F2,$39,$45,$41,$32,$29,$0,$C4,$75,$0,$0         *dd
  DC.B $40,$3B,$0,$60,$C0,$80,$0,$0,$2D,$9,$1,$0,$FF,$FF,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$18,$1C,$1E,$1F,$1E,$1C,$18,$0,$3,$7,$F,$1F,$F,$7,$3,$0
  DC.B $0,$0,$1E,$1E,$1E,$1E,$0,$0,$A,$15,$19,$19,$15,$13,$13,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *de
  DC.B $80,$3B,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$8,$4,$0,$12,$12,$12,$D
  DC.B $0,$8,$14,$0,$18,$8,$8,$1C,$0,$4,$A,$0,$E,$11,$11,$E,$0
  DC.B $A,$0,$E,$11,$1F,$10,$E,$0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$0
  DC.B $0,$0,$FF,$FF,$0,$0,$0,$0,$4,$0,$1F,$0,$4,$0,$0         *df
  DC.B $C0,$3B,$0,$60,$6,$9,$8,$1C,$8,$1D,$1A,$0,$0,$11,$A,$4,$A,$11,$0
  DC.B $0,$0,$0,$0,$6,$6,$0,$0,$0,$0,$A,$0,$C,$4,$4,$E,$0
  DC.B $0,$A,$0,$12,$12,$12,$D,$0,$1E,$21,$AA,$82,$92,$AA,$BA,$44,$0
  DC.B $0,$7C,$44,$54,$48,$44,$FE,$AA,$55,$AA,$55,$AA,$55,$AA,$55         *e0
  DC.B $0,$3C,$0,$60,$0,$4,$15,$E,$15,$4,$0,$0,$FF,$FF,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$8,$14,$14,$8,$0,$0,$0,$0,$4,$2,$E,$1,$F,$11,$F,$0
  DC.B $4,$8,$E,$11,$1F,$10,$E,$0,$4,$2,$E,$11,$1F,$10,$E,$0,$4
  DC.B $A,$E,$11,$1F,$10,$E,$0,$4,$A,$0,$12,$12,$12,$D,$0         *e1
  DC.B $40,$3C,$0,$60,$0,$E,$11,$10,$11,$E,$4,$E,$A,$0,$E,$1,$F,$11,$F
  DC.B $0,$A,$0,$E,$11,$11,$11,$E,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $88,$4,$0,$0,$95,$4,$0,$0,$A2,$4,$0,$0,$8,$7,$0,$0,$15
  DC.B $7,$0,$0,$22,$7,$0,$0,$0,$FC,$3F,$0,$1,$FC,$FF,$30         *e2
  DC.B $80,$3C,$0,$60,$E0,$2,$FC,$FF,$E5,$18,$E0,$2,$FC,$FF,$E5,$18,$E0,$2,$FC
  DC.B $FF,$E5,$18,$E0,$2,$FC,$FF,$E5,$18,$E0,$2,$FC,$FF,$E5,$18,$E0,$2
  DC.B $FC,$FF,$E5,$18,$E0,$2,$FC,$FF,$E5,$18,$E0,$2,$FC,$FF,$E5,$18,$E0
  DC.B $2,$FC,$FF,$E5,$18,$3,$FC,$FF,$38,$1,$FC,$3F,$30,$0,$FC         *e3
  DC.B $C0,$3C,$0,$60,$3F,$20,$FF,$0,$31,$1E,$0,$0,$1F,$10,$0,$80,$80,$80,$1E
  DC.B $11,$16,$25,$26,$27,$1D,$24,$F,$28,$29,$2A,$1C,$23,$D,$E,$13,$12
  DC.B $1B,$22,$9,$A,$B,$C,$1A,$21,$5,$6,$7,$8,$19,$20,$1,$2,$3
  DC.B $4,$0,$0,$14,$2,$0,$0,$81,$2C,$0,$60,$15,$3,$0,$0         *e4
  DC.B $0,$3D,$0,$60,$9D,$2C,$0,$60,$16,$3,$0,$0,$89,$2D,$0,$60,$17,$22,$0
  DC.B $0,$21,$2E,$0,$60,$2D,$4,$0,$0,$D9,$30,$0,$60,$11,$EE,$10,$E1
  DC.B $12,$EF,$13,$F5,$14,$86,$15,$FD,$16,$EC,$17,$EB,$18,$DB,$19,$DB,$1A
  DC.B $DF,$1B,$6F,$1C,$0,$1D,$2,$1E,$4,$1F,$6,$18,$A5,$19,$A2         *e5
  DC.B $40,$3D,$0,$60,$1A,$A2,$1B,$DF,$1C,$1,$1D,$3,$1E,$5,$1F,$7,$43,$B9,$A5
  DC.B $6B,$A8,$F5,$F5,$D,$2,$E7,$7B,$29,$5D,$A0,$E0,$23,$3C,$9,$99,$3B
  DC.B $BF,$40,$4C,$CC,$D1,$B0,$93,$D3,$E8,$5,$1C,$CE,$8E,$A6,$7E,$FA,$5
  DC.B $4D,$B3,$81,$53,$9D,$D,$1D,$10,$C1,$26,$0,$2E,$1C,$60,$64         *e6
  DC.B $80,$3D,$0,$60,$FA,$83,$C9,$A9,$45,$7A,$30,$BC,$35,$F0,$6C,$79,$7C,$90,$9E
  DC.B $EB,$8E,$FA,$5A,$43,$B4,$B7,$B5,$EC,$87,$DC,$D0,$F,$74,$B,$A8,$6B
  DC.B $AF,$80,$89,$C1,$DA,$1F,$8E,$65,$CA,$3A,$35,$71,$5D,$D6,$48,$47,$AA
  DC.B $2C,$24,$D6,$F0,$25,$6D,$9B,$62,$BD,$21,$21,$7,$11,$25,$9D         *e7
  DC.B $C0,$3D,$0,$60,$C,$C9,$95,$60,$67,$AA,$C5,$46,$DA,$11,$B8,$F5,$5E,$CA,$1F
  DC.B $A7,$62,$7A,$8A,$55,$B3,$DA,$D4,$4A,$60,$5,$4B,$D6,$DC,$F7,$9B,$E7
  DC.B $BC,$E1,$45,$13,$65,$88,$85,$39,$C2,$55,$84,$F6,$17,$C8,$4B,$C5,$F
  DC.B $7E,$DF,$D9,$97,$86,$D3,$B1,$EF,$D5,$B5,$C7,$F4,$BD,$FA,$8A         *e8
  DC.B $0,$3E,$0,$60,$B1,$DF,$50,$B,$74,$2B,$CF,$D4,$7B,$7C,$18,$56,$A,$E8,$28
  DC.B $62,$18,$77,$D6,$9B,$61,$B2,$F4,$82,$21,$C0,$D3,$D4,$AB,$57,$B1,$26
  DC.B $BC,$E1,$4D,$C0,$F9,$E1,$72,$BD,$B9,$CD,$31,$C0,$B5,$B1,$2C,$AF,$52
  DC.B $AA,$BC,$E1,$A9,$C2,$AF,$9C,$58,$1B,$85,$33,$F1,$5D,$C3,$56         *e9
  DC.B $40,$3E,$0,$60,$4F,$C4,$B8,$5E,$CC,$FC,$AA,$24,$80,$CE,$5E,$8B,$85,$91,$9F
  DC.B $8F,$35,$4D,$AB,$9C,$60,$3,$92,$53,$67,$70,$14,$BB,$32,$94,$6D,$DC
  DC.B $1B,$B4,$CA,$4E,$4A,$80,$69,$86,$D3,$86,$66,$2F,$63,$94,$8D,$A2,$F6
  DC.B $30,$A9,$1E,$AB,$D8,$C1,$69,$17,$D5,$8E,$CD,$74,$95,$95,$89         *ea
  DC.B $80,$3E,$0,$60,$45,$E9,$18,$EE,$C4,$B1,$2A,$7E,$48,$69,$2A,$9C,$CC,$39,$F9
  DC.B $8,$34,$46,$A1,$78,$93,$60,$C1,$96,$1A,$E7,$BE,$CB,$45,$A9,$57,$EA
  DC.B $16,$D2,$57,$F3,$FA,$FE,$FD,$69,$2D,$FA,$DF,$98,$8F,$48,$AE,$7A,$2C
  DC.B $25,$5E,$D6,$84,$CD,$2A,$D7,$A4,$55,$85,$2A,$8E,$D,$F1,$55         *eb
  DC.B $C0,$3E,$0,$60,$3C,$7C,$43,$34,$8A,$34,$8,$B7,$BE,$CC,$27,$AD,$53,$5B,$6B
  DC.B $2E,$49,$EB,$3E,$16,$D1,$C3,$9,$EB,$36,$1,$F1,$65,$AA,$F8,$5C,$82
  DC.B $5F,$6A,$45,$13,$D5,$0,$4A,$F5,$6F,$A4,$7D,$25,$B,$9,$26,$8D,$2A
  DC.B $35,$3A,$40,$EC,$25,$19,$BC,$88,$32,$1A,$8C,$D6,$B1,$A1,$5E         *ec
  DC.B $0,$3F,$0,$60,$14,$D1,$A4,$62,$AB,$12,$A4,$CA,$AB,$7C,$23,$A8,$94,$52,$41
  DC.B $4F,$75,$17,$B6,$6,$29,$51,$13,$35,$1,$E4,$1D,$A9,$2A,$8D,$21,$24
  DC.B $13,$2B,$28,$57,$BF,$A3,$2A,$22,$E3,$8E,$92,$82,$AE,$92,$84,$4E,$92
  DC.B $85,$A2,$99,$55,$D1,$4B,$4A,$8A,$66,$F2,$A0,$64,$11,$50,$C3         *ed
  DC.B $40,$3F,$0,$60,$C7,$AD,$1A,$6C,$D9,$6A,$DC,$EF,$85,$29,$10,$64,$C,$D9,$54
  DC.B $3C,$41,$92,$47,$4D,$39,$DF,$D2,$99,$E4,$A1,$B9,$FC,$75,$74,$6A,$F4
  DC.B $28,$5A,$63,$3D,$34,$9C,$D4,$CF,$C8,$A8,$64,$B0,$62,$E4,$B5,$B7,$4E
  DC.B $E,$28,$1C,$A4,$10,$DE,$7D,$98,$69,$2D,$68,$53,$ED,$2B,$A5         *ee
  DC.B $80,$3F,$0,$60,$BA,$3C,$83,$A1,$EF,$3E,$D2,$70,$29,$93,$1A,$7E,$30,$B4,$E9
  DC.B $2C,$10,$83,$6E,$1A,$DF,$BD,$22,$FF,$85,$96,$FF,$7B,$1B,$F5,$11,$46
  DC.B $7A,$8C,$F8,$49,$7,$48,$1A,$32,$D9,$EF,$1B,$9E,$FD,$74,$9F,$AD,$CC
  DC.B $5F,$E1,$63,$6E,$5E,$E9,$C0,$3E,$2B,$2B,$B8,$3,$6C,$C1,$77         *ef
  DC.B $C0,$3F,$0,$60,$CE,$A0,$A5,$E5,$7A,$FF,$A0,$D4,$44,$90,$1B,$8A,$4A,$B9,$C0
  DC.B $1A,$B4,$95,$11,$90,$2,$79,$C0,$26,$76,$0,$A3,$F7,$A1,$A5,$D9,$0
  DC.B $CB,$18,$3F,$73,$A9,$28,$D8,$B5,$25,$15,$4C,$A8,$60,$A,$3C,$29,$CE
  DC.B $9F,$B4,$13,$9B,$8A,$4A,$B4,$95,$1F,$7A,$18,$BB,$80,$64,$FC         *f0
  DC.B $0,$40,$0,$60,$1D,$18,$3F,$53,$A8,$2C,$FC,$A2,$2F,$FA,$9,$97,$64,$16,$7C
  DC.B $A,$8E,$C8,$2C,$B0,$C7,$52,$51,$67,$16,$66,$13,$38,$E6,$8E,$5A,$CB
  DC.B $91,$15,$5,$32,$A8,$E2,$80,$B8,$28,$79,$BC,$2F,$83,$2A,$2E,$E9,$63
  DC.B $B1,$D4,$94,$56,$E6,$82,$A2,$1D,$94,$BA,$CE,$D0,$C0,$BC,$A8         *f1
  DC.B $40,$40,$0,$60,$C1,$B1,$53,$2A,$A7,$54,$F5,$12,$70,$F8,$5C,$85,$E4,$FD,$E0
  DC.B $5A,$7,$77,$D5,$F0,$7E,$DA,$E7,$EC,$1E,$38,$36,$3,$A3,$BA,$1A,$71
  DC.B $C3,$46,$1D,$18,$16,$5,$89,$57,$6C,$A,$4E,$6,$EC,$A6,$55,$3,$54
  DC.B $53,$EF,$83,$F6,$9D,$68,$C9,$C5,$6C,$6E,$7D,$88,$CA,$B4,$AA         *f2
  DC.B $80,$40,$0,$60,$DE,$7,$DB,$3,$3,$72,$6,$D3,$EE,$FA,$BB,$5C,$C9,$60,$5E
  DC.B $E0,$9D,$DD,$4C,$93,$73,$E2,$70,$38,$8E,$AF,$20,$D9,$F0,$54,$93,$AC
  DC.B $D5,$27,$B1,$E7,$CA,$3A,$FF,$E4,$6A,$2D,$81,$91,$94,$41,$41,$E3,$10
  DC.B $B1,$19,$22,$1E,$1,$85,$87,$93,$24,$EA,$64,$9C,$15,$86,$E         *f3
  DC.B $C0,$40,$0,$60,$87,$5,$AF,$E9,$A,$97,$5,$A3,$11,$CB,$59,$76,$B,$22,$F2
  DC.B $B1,$D5,$11,$5C,$19,$9A,$22,$B1,$B8,$A8,$CA,$BA,$99,$AD,$2F,$FB,$6B
  DC.B $A6,$B1,$5C,$17,$6C,$15,$BE,$70,$1A,$B8,$32,$F6,$E6,$82,$AA,$83,$A4
  DC.B $DC,$91,$31,$59,$D,$80,$71,$75,$C3,$7D,$91,$5D,$9B,$8B,$99         *f4
  DC.B $0,$41,$0,$60,$63,$4A,$C9,$A5,$F2,$7,$E3,$23,$B0,$53,$C5,$AB,$8B,$86,$40
  DC.B $5B,$4F,$F9,$14,$80,$AA,$56,$15,$2A,$12,$22,$BF,$62,$BB,$E7,$F9,$2B
  DC.B $55,$4A,$25,$69,$A6,$22,$B4,$C5,$77,$3A,$43,$56,$BB,$38,$8E,$53,$FC
  DC.B $9D,$70,$9B,$A1,$54,$D0,$FB,$9D,$5F,$D0,$67,$DC,$31,$F5,$75         *f5
  DC.B $40,$41,$0,$60,$AC,$E0,$DF,$78,$91,$9,$9F,$88,$D4,$CE,$5D,$1D,$C5,$F3,$43
  DC.B $2D,$AF,$59,$3,$A,$53,$98,$98,$4C,$AA,$8D,$A7,$2F,$A7,$D7,$54,$44
  DC.B $A7,$AA,$F,$FC,$19,$6C,$24,$AD,$E9,$E5,$D3,$41,$31,$5F,$24,$E5,$FB
  DC.B $C7,$17,$C8,$2E,$D,$4D,$1C,$E5,$B4,$8A,$AB,$1E,$FA,$E6,$5         *f6
  DC.B $80,$41,$0,$60,$E9,$64,$E4,$39,$87,$BB,$8A,$88,$38,$37,$D,$FA,$6B,$4,$AA
  DC.B $9A,$33,$4B,$38,$E1,$E0,$49,$86,$3D,$FE,$54,$AD,$67,$30,$A3,$A0,$DA
  DC.B $1,$1,$63,$1F,$C4,$75,$F5,$FE,$FA,$9F,$8E,$AB,$25,$20,$8B,$D5,$6E
  DC.B $3A,$A5,$CD,$7F,$57,$C9,$B3,$48,$97,$39,$A7,$5,$AE,$C7,$37         *f7
  DC.B $C0,$41,$0,$60,$FD,$4D,$3E,$A6,$CB,$8B,$E0,$F7,$17,$CF,$D4,$FD,$CB,$C1,$C5
  DC.B $CB,$B5,$F5,$4A,$32,$39,$B7,$FF,$2F,$3C,$12,$5B,$9B,$B2,$9C,$B7,$26
  DC.B $70,$55,$18,$BC,$AC,$28,$49,$33,$14,$9C,$56,$57,$5,$86,$29,$65,$AD
  DC.B $F,$F2,$D7,$99,$38,$8D,$CB,$A3,$AA,$A7,$9A,$E7,$37,$FF,$15         *f8
  DC.B $0,$42,$0,$60,$E2,$41,$82,$3C,$64,$B,$5A,$90,$60,$8A,$4F,$B2,$A,$40,$C3
  DC.B $11,$42,$DC,$15,$57,$A9,$16,$EC,$EA,$45,$BA,$3A,$F2,$B0,$EA,$5F,$CE
  DC.B $1B,$A,$15,$BA,$D,$CB,$DD,$C1,$DD,$5C,$1D,$FA,$E0,$F2,$70,$2C,$37
  DC.B $67,$7,$92,$C1,$93,$B0,$6A,$2C,$15,$1E,$E5,$25,$46,$27,$5         *f9
  DC.B $40,$42,$0,$60,$96,$FB,$9E,$29,$DC,$6B,$B8,$32,$AA,$23,$C3,$DC,$1A,$F1,$1E
  DC.B $6B,$13,$F,$38,$D5,$82,$B3,$4,$15,$A1,$A0,$82,$B4,$58,$85,$11,$14
  DC.B $6D,$7E,$23,$D5,$EA,$1C,$9E,$A8,$B8,$3D,$54,$3C,$EB,$EB,$83,$D9,$58
  DC.B $2D,$8A,$81,$B7,$83,$39,$D2,$A4,$4,$E4,$CA,$13,$C5,$53,$9         *fa
  DC.B $80,$42,$0,$60,$48,$74,$DD,$CA,$5B,$76,$75,$E5,$61,$1E,$2,$93,$ED,$CB,$B5
  DC.B $E3,$CC,$1,$37,$60,$B6,$69,$CB,$83,$CD,$3A,$C9,$E9,$D5,$1C,$47,$9F
  DC.B $6F,$4E,$E5,$44,$79,$BA,$37,$69,$3E,$F1,$E4,$0,$C3,$47,$8F,$2B,$A4
  DC.B $A6,$A8,$3C,$CE,$91,$F3,$A5,$27,$D1,$E0,$29,$35,$E3,$CC,$DE         *fb
  DC.B $C0,$42,$0,$60,$3C,$BA,$94,$36,$DD,$24,$E3,$CE,$9E,$1D,$E7,$4D,$6D,$16,$DC
  DC.B $9C,$BC,$AC,$37,$33,$3F,$8E,$65,$7D,$2F,$46,$4B,$6E,$5D,$5E,$5A,$2
  DC.B $AA,$B,$43,$94,$D0,$12,$DB,$B3,$BC,$79,$39,$79,$58,$47,$9B,$95,$2D
  DC.B $BA,$38,$53,$60,$DC,$E4,$0,$BC,$E7,$20,$5E,$79,$40,$CC,$64         *fc
  DC.B $0,$43,$0,$60,$64,$54,$B6,$E5,$D8,$72,$A6,$28,$3C,$79,$73,$73,$33,$94,$6A
  DC.B $44,$B,$4A,$85,$50,$F2,$D,$48,$22,$56,$6F,$CF,$A,$B1,$DD,$2E,$D5
  DC.B $6,$E0,$D6,$3F,$61,$5B,$79,$8E,$66,$3B,$6D,$E2,$8A,$D5,$D3,$EE,$1E
  DC.B $35,$5,$A9,$8C,$50,$DE,$C,$3B,$5,$6E,$AA,$C0,$17,$6E,$E         *fd
  DC.B $40,$43,$0,$60,$45,$28,$D4,$16,$51,$55,$5A,$E,$EF,$69,$6D,$38,$4C,$47,$9B
  DC.B $3B,$C6,$A1,$B5,$37,$40,$4B,$AD,$55,$44,$22,$9D,$38,$79,$CE,$2A,$79
  DC.B $90,$AA,$5C,$53,$D5,$94,$6A,$57,$4B,$9A,$51,$A8,$77,$8F,$48,$37,$31
  DC.B $1E,$3D,$98,$E1,$2D,$1B,$27,$34,$59,$39,$A2,$96,$CA,$3C,$13         *fe
  DC.B $80,$43,$0,$60,$EA,$21,$1C,$35,$4,$43,$B1,$B1,$F9,$D9,$EA,$A4,$DD,$9D,$1E
  DC.B $AD,$3B,$B3,$B3,$D5,$93,$76,$74,$10,$4C,$B,$B1,$AB,$A8,$FB,$B3,$A7
  DC.B $D5,$79,$AE,$76,$2D,$69,$73,$A2,$BC,$EC,$CA,$97,$3A,$5C,$4F,$CF,$EF
  DC.B $97,$F4,$E7,$DB,$6D,$47,$F5,$FA,$32,$C8,$CE,$A8,$8A,$E4,$EF         *ff
  DC.B $C0,$43,$0,$60,$A0,$57,$BF,$51,$DC,$9D,$F6,$D5,$7B,$F5,$3,$AC,$AD,$2F,$6A
  DC.B $55,$4F,$95,$DF,$C1,$54,$7C,$AE,$FB,$6A,$C8,$39,$6B,$A,$AE,$67,$9A
  DC.B $7B,$D7,$C0,$8F,$5E,$E4,$B2,$F4,$CB,$24,$BF,$48,$82,$34,$BB,$5A,$81
  DC.B $68,$BB,$65,$E2,$3F,$3,$EB,$C,$F3,$2C,$F5,$EC,$6A,$AF,$B0         *100
  DC.B $0,$44,$0,$60,$D6,$CC,$2,$CE,$6B,$68,$60,$8C,$C0,$69,$94,$7F,$E8,$CA,$A0
  DC.B $B5,$5F,$4A,$D7,$9E,$B0,$13,$D7,$B6,$55,$F6,$2D,$5D,$2B,$5E,$AB,$E8
  DC.B $7C,$9A,$BE,$AB,$69,$8B,$EE,$2B,$0,$8B,$E6,$F5,$6A,$86,$A4,$1E,$AD
  DC.B $50,$D1,$F5,$57,$12,$4,$BC,$4F,$68,$95,$91,$EB,$DC,$F1,$EB         *101
  DC.B $40,$44,$0,$60,$E6,$C2,$BA,$5A,$A0,$5B,$57,$26,$AA,$EC,$7F,$2A,$25,$76,$E8
  DC.B $47,$3E,$34,$7A,$CF,$32,$8B,$57,$26,$AD,$8C,$92,$F,$93,$57,$34,$AF
  DC.B $26,$D1,$28,$B7,$C9,$CC,$85,$67,$5F,$16,$AD,$6A,$C0,$53,$9C,$AE,$9B
  DC.B $14,$47,$AF,$A4,$9F,$68,$3B,$94,$CC,$D2,$7E,$FE,$B9,$78,$97         *102
  DC.B $80,$44,$0,$60,$D0,$EF,$FE,$CA,$A8,$56,$1A,$EF,$99,$2E,$E0,$E7,$C7,$F5,$A0
  DC.B $FF,$AC,$B8,$34,$BC,$AB,$E9,$2C,$18,$76,$C,$8A,$11,$83,$B3,$8C,$94
  DC.B $AA,$AF,$F8,$A2,$D,$C1,$F9,$2B,$CB,$C5,$33,$5,$AE,$97,$F9,$6F,$5F
  DC.B $74,$97,$EB,$28,$99,$96,$A9,$A1,$B1,$FF,$3E,$B,$9E,$74,$D5         *103
  DC.B $C0,$44,$0,$60,$34,$EB,$DA,$C5,$5E,$9D,$9C,$4D,$13,$6A,$87,$AA,$81,$4A,$C4
  DC.B $D8,$6A,$1A,$BD,$60,$72,$D4,$FF,$AD,$31,$4E,$E5,$1F,$FA,$D3,$66,$52
  DC.B $D6,$9C,$B2,$EE,$D7,$6B,$FE,$8C,$FF,$F8,$6B,$ED,$54,$39,$6E,$5,$70
  DC.B $5C,$70,$56,$45,$E5,$65,$99,$A5,$54,$95,$3B,$72,$83,$59,$E7         *104
  DC.B $0,$45,$0,$60,$43,$69,$B1,$4E,$FF,$AC,$B2,$81,$97,$57,$4D,$8A,$6C,$57,$D0
  DC.B $F8,$36,$AC,$1C,$FB,$D3,$7F,$4F,$A3,$47,$CC,$A1,$AD,$69,$C8,$60,$D0
  DC.B $E9,$94,$25,$54,$16,$BE,$D9,$3B,$7,$2B,$7,$3A,$BA,$A,$B9,$4A,$17
  DC.B $33,$4A,$B5,$AA,$D6,$DA,$16,$5B,$5F,$42,$5E,$BE,$8F,$53,$F3         *105
  DC.B $40,$45,$0,$60,$B,$CC,$A9,$D9,$DB,$4F,$F4,$55,$F6,$42,$8F,$4D,$9,$76,$F9
  DC.B $5,$54,$15,$16,$2B,$57,$F4,$E5,$26,$54,$9C,$26,$4A,$29,$B4,$53,$28
  DC.B $36,$B7,$22,$E,$4B,$6C,$28,$D9,$E,$79,$60,$50,$EB,$E3,$67,$36,$94
  DC.B $3F,$75,$BC,$1B,$B5,$CA,$68,$D,$86,$8E,$AA,$82,$E8,$F5,$26         *106
  DC.B $80,$45,$0,$60,$3D,$2B,$90,$E5,$E4,$4F,$9A,$55,$7A,$95,$36,$9C,$25,$D,$65
  DC.B $99,$A5,$A3,$C4,$93,$6,$AF,$68,$92,$A6,$49,$27,$72,$D0,$43,$57,$D3
  DC.B $C2,$9B,$31,$A,$F8,$85,$36,$75,$68,$2E,$AC,$C0,$41,$A8,$BC,$29,$33
  DC.B $B5,$5D,$41,$F2,$A2,$E6,$A2,$EC,$7,$CA,$3A,$AE,$A6,$AF,$66         *107
  DC.B $C0,$45,$0,$60,$C5,$30,$78,$50,$3F,$3A,$44,$7C,$A8,$EA,$F6,$73,$34,$D8,$37
  DC.B $53,$A,$DB,$80,$50,$4F,$AB,$C7,$17,$82,$6D,$F9,$A6,$BA,$4,$CC,$3E
  DC.B $BF,$56,$69,$5E,$8,$5,$7B,$CA,$CC,$D2,$C,$54,$24,$94,$85,$9,$F
  DC.B $1C,$A6,$2D,$7F,$E5,$55,$68,$F4,$76,$E1,$FA,$DA,$C0,$29,$BC         *108
  DC.B $0,$46,$0,$60,$13,$37,$82,$7C,$BC,$E,$8,$82,$45,$88,$25,$43,$C1,$26,$EB
  DC.B $14,$C0,$93,$5C,$41,$29,$10,$41,$78,$82,$D6,$F2,$EB,$C9,$27,$37,$EA
  DC.B $A8,$22,$58,$74,$72,$47,$8E,$75,$8E,$B1,$5E,$5F,$E4,$3F,$6E,$7B,$5F
  DC.B $4F,$97,$90,$44,$B0,$9F,$1C,$FD,$3A,$CC,$69,$64,$75,$31,$75         *109
  DC.B $40,$46,$0,$60,$79,$61,$6,$AE,$47,$D2,$F0,$F1,$CD,$20,$6A,$A5,$89,$64,$B1
  DC.B $2F,$2,$25,$91,$68,$36,$69,$7A,$39,$47,$8E,$7A,$C2,$79,$61,$26,$D6
  DC.B $8E,$30,$A2,$59,$1D,$74,$DB,$89,$61,$3C,$73,$F4,$DE,$5E,$3A,$AE,$A3
  DC.B $CB,$F0,$26,$66,$5D,$D5,$22,$44,$BC,$D1,$FD,$9,$E2,$5E,$26         *10a
  DC.B $80,$46,$0,$60,$A9,$B,$CB,$23,$89,$64,$BF,$AC,$5C,$62,$5F,$F9,$AB,$D9,$95
  DC.B $78,$C7,$AB,$D9,$27,$61,$C6,$6C,$44,$72,$C1,$82,$4,$33,$DA,$B9,$17
  DC.B $CE,$91,$F9,$A2,$26,$86,$26,$35,$71,$89,$78,$77,$58,$61,$71,$89,$B4
  DC.B $D5,$FF,$BC,$15,$F2,$D3,$8A,$CB,$54,$C7,$E3,$5,$7B,$58,$E2         *10b
  DC.B $C0,$46,$0,$60,$B3,$9D,$52,$9B,$AA,$67,$82,$E7,$89,$66,$1D,$2C,$5C,$78,$E2
  DC.B $A4,$FC,$71,$59,$C5,$A,$99,$B5,$3B,$78,$82,$FD,$D2,$CC,$1E,$38,$A8
  DC.B $67,$1C,$54,$91,$BA,$82,$20,$BB,$5E,$9A,$8,$E7,$5A,$2F,$4A,$79,$E
  DC.B $5B,$13,$A7,$C,$95,$CA,$97,$A6,$71,$B5,$D3,$79,$25,$69,$CC         *10c
  DC.B $0,$47,$0,$60,$A4,$FC,$73,$2C,$E6,$3B,$62,$BF,$19,$F8,$FA,$A6,$8E,$32,$2A
  DC.B $1E,$6,$26,$9E,$31,$39,$AF,$C6,$7,$C,$A5,$B6,$7,$A9,$D9,$56,$22
  DC.B $2F,$EA,$CD,$44,$71,$61,$56,$9A,$1C,$C9,$73,$C6,$26,$81,$F5,$58,$E2
  DC.B $E6,$71,$89,$B4,$F4,$A1,$D0,$D5,$BB,$E1,$DC,$7C,$8A,$63,$B8         *10d
  DC.B $40,$47,$0,$60,$F9,$6D,$53,$DD,$2E,$F5,$3F,$5B,$12,$A0,$D0,$24,$D6,$80,$C0
  DC.B $19,$55,$33,$F1,$95,$A3,$46,$C0,$52,$DB,$A,$DF,$D2,$4F,$87,$58,$E3
  DC.B $2B,$E3,$13,$6B,$1,$4E,$D4,$F0,$50,$C6,$AC,$E7,$AA,$58,$47,$C9,$89
  DC.B $EF,$8C,$72,$29,$B5,$82,$2C,$BE,$AF,$88,$C2,$AB,$BA,$14,$41         *10e
  DC.B $80,$47,$0,$60,$41,$35,$43,$A4,$BC,$5D,$52,$54,$5F,$8C,$FD,$AB,$82,$93,$38
  DC.B $C5,$84,$1C,$60,$D0,$7E,$32,$9,$28,$AC,$5C,$C3,$57,$B,$C0,$C,$71
  DC.B $84,$93,$75,$8C,$D5,$A,$0,$18,$A5,$E3,$1A,$5,$22,$BA,$6,$41,$8C
  DC.B $AD,$F8,$B1,$50,$8F,$2F,$EE,$31,$34,$12,$2A,$21,$99,$30,$3F         *10f
  DC.B $C0,$47,$0,$60,$18,$17,$E3,$34,$20,$E2,$DC,$65,$E0,$A1,$BC,$1A,$76,$FA,$A1
  DC.B $50,$C8,$B5,$42,$31,$C6,$44,$24,$B6,$42,$B2,$C,$1A,$76,$26,$AF,$72
  DC.B $1E,$F8,$54,$D,$C8,$49,$1E,$D,$3A,$4A,$38,$C8,$B5,$58,$C4,$E6,$A4
  DC.B $B0,$56,$4,$FA,$BB,$AB,$4,$56,$CB,$CB,$C2,$F2,$41,$6A,$FC         *110
  DC.B $0,$48,$0,$60,$14,$A3,$56,$73,$44,$8C,$3B,$11,$4,$69,$DD,$F5,$AC,$47,$EB
  DC.B $E,$42,$CE,$50,$92,$A7,$AB,$EB,$E6,$91,$89,$2E,$F,$24,$D2,$F2,$36
  DC.B $7D,$6B,$AF,$3B,$21,$77,$CF,$5A,$50,$7C,$A7,$15,$A7,$90,$E1,$93,$3D
  DC.B $6C,$AA,$AD,$C7,$29,$97,$3D,$62,$C,$56,$99,$EB,$11,$1A,$CC         *111
  DC.B $40,$48,$0,$60,$1E,$47,$C,$9E,$2B,$63,$35,$4A,$1E,$49,$26,$79,$20,$C7,$CA
  DC.B $21,$4B,$C7,$92,$A5,$25,$6F,$C4,$F6,$AE,$1B,$E3,$11,$37,$BD,$34,$71
  DC.B $AF,$72,$A5,$45,$C,$1A,$A8,$FC,$95,$6F,$D5,$A7,$AC,$4C,$F,$69,$C8
  DC.B $32,$29,$59,$14,$A9,$DA,$A5,$D3,$C9,$41,$49,$39,$95,$B0,$3F         *112
  DC.B $80,$48,$0,$60,$39,$D7,$D1,$28,$77,$59,$99,$AB,$9B,$F1,$77,$C1,$A7,$67,$7E
  DC.B $73,$3D,$59,$1E,$AD,$C3,$54,$C7,$F2,$8A,$65,$5A,$E8,$E4,$FC,$5A,$F
  DC.B $CE,$68,$D5,$BB,$C7,$39,$DD,$59,$D,$58,$34,$8C,$18,$CE,$3C,$BA,$8B
  DC.B $F3,$62,$48,$E,$86,$C9,$5B,$13,$CE,$54,$B5,$5A,$B4,$73,$9B         *113
  DC.B $C0,$48,$0,$60,$5F,$9B,$9D,$1C,$E6,$84,$9D,$B9,$B3,$E8,$E7,$28,$FA,$AE,$1C
  DC.B $9B,$32,$AB,$1F,$B9,$CD,$DF,$9B,$F1,$26,$8A,$51,$55,$E6,$B4,$C3,$A2
  DC.B $D4,$34,$DA,$CF,$9D,$A9,$B3,$97,$C7,$39,$D8,$E7,$43,$F2,$56,$FD,$1E
  DC.B $D3,$96,$35,$CD,$73,$5B,$39,$66,$CE,$E3,$57,$EB,$E6,$6B,$D8         *114
  DC.B $0,$49,$0,$60,$87,$6E,$54,$A0,$8A,$55,$F3,$E4,$4D,$50,$EF,$C5,$30,$2D,$FA
  DC.B $3,$92,$B7,$25,$B7,$24,$82,$BD,$43,$C9,$5B,$9E,$8E,$F0,$D9,$5B,$54
  DC.B $56,$E6,$79,$2B,$93,$DA,$8F,$68,$AD,$CA,$AA,$7A,$11,$F1,$96,$E7,$AF
  DC.B $EC,$2F,$DA,$55,$33,$2D,$6,$A9,$4,$23,$34,$1F,$51,$8A,$DF         *115
  DC.B $40,$49,$0,$60,$8F,$A3,$73,$34,$26,$D2,$A9,$E2,$B4,$32,$D4,$64,$83,$B4,$E4
  DC.B $19,$6E,$D2,$29,$55,$56,$33,$CC,$24,$1E,$4E,$94,$A5,$92,$78,$8D,$67
  DC.B $2B,$84,$FC,$59,$B3,$26,$D7,$8A,$DC,$B2,$A5,$12,$35,$29,$4A,$EB,$34
  DC.B $38,$FC,$9A,$1F,$E4,$6A,$92,$C9,$3D,$8E,$D3,$A0,$9D,$A7,$6F         *116
  DC.B $80,$49,$0,$60,$5E,$64,$4D,$F6,$5B,$78,$15,$3B,$6,$4C,$EF,$64,$C5,$2D,$44
  DC.B $3B,$26,$30,$F2,$F0,$D7,$D4,$52,$3C,$AC,$15,$58,$40,$5,$75,$80,$7A
  DC.B $EF,$CE,$EA,$9F,$8F,$B3,$95,$95,$E2,$99,$F0,$64,$D2,$11,$4D,$AC,$49
  DC.B $F,$9B,$87,$2E,$54,$AD,$93,$18,$22,$75,$34,$C4,$32,$56,$1A         *117
  DC.B $C0,$49,$0,$60,$6D,$D5,$18,$20,$8A,$21,$86,$C8,$B1,$1A,$70,$B1,$24,$55,$96
  DC.B $1A,$70,$1,$86,$AF,$BC,$DF,$89,$F,$4E,$AA,$C3,$E8,$4E,$34,$DF,$DE
  DC.B $BA,$BC,$9D,$73,$7C,$88,$AE,$D3,$A0,$A8,$55,$4B,$F0,$92,$2B,$F9,$73
  DC.B $58,$6D,$70,$56,$A5,$F9,$93,$AE,$14,$D3,$75,$A3,$E4,$DD,$2D         *118
  DC.B $0,$4A,$0,$60,$88,$D8,$3C,$9B,$8E,$4E,$23,$2C,$6B,$DF,$A4,$56,$19,$F5,$C0
  DC.B $D,$18,$65,$EA,$B6,$C5,$5C,$46,$7E,$46,$72,$7E,$81,$D7,$E1,$24,$56
  DC.B $1B,$58,$C3,$3F,$1,$EF,$25,$D0,$20,$47,$C3,$93,$F9,$DF,$C9,$F9,$73
  DC.B $5E,$4,$64,$DA,$B2,$61,$3D,$B0,$97,$69,$CB,$57,$B2,$D8,$25         *119
  DC.B $40,$4A,$0,$60,$16,$90,$EE,$6C,$17,$69,$D0,$58,$67,$D7,$50,$AA,$96,$FB,$77
  DC.B $5D,$AD,$92,$82,$8F,$7,$F3,$A2,$6,$E6,$F9,$6,$E6,$E4,$6,$63,$25
  DC.B $22,$52,$D3,$96,$C1,$AB,$48,$30,$CF,$C7,$F3,$36,$88,$D7,$20,$B2,$9E
  DC.B $F4,$51,$3B,$88,$D7,$24,$4A,$AE,$B1,$DD,$5E,$1D,$CB,$59,$2A         *11a
  DC.B $80,$4A,$0,$60,$1A,$FB,$AC,$B,$D3,$1B,$CF,$51,$BE,$61,$2A,$B1,$F5,$5E,$A4
  DC.B $30,$BF,$E5,$56,$22,$45,$E4,$C8,$EC,$95,$55,$78,$40,$14,$B7,$27,$45
  DC.B $44,$5F,$FC,$45,$49,$57,$6,$5B,$72,$5F,$A7,$79,$95,$31,$B2,$61,$7D
  DC.B $D5,$74,$24,$75,$6F,$42,$BC,$E2,$12,$B5,$93,$8F,$B9,$C2,$F9         *11b
  DC.B $C0,$4A,$0,$60,$2F,$A9,$88,$AF,$4F,$2F,$2F,$11,$55,$39,$2E,$28,$8B,$ED,$86
  DC.B $71,$3F,$99,$53,$C,$EE,$75,$2F,$8D,$D,$9A,$28,$6C,$D1,$E,$23,$3E
  DC.B $9C,$BD,$38,$57,$2F,$4B,$F4,$3D,$D,$CB,$D3,$A5,$3A,$DF,$50,$AC,$66
  DC.B $98,$D1,$A1,$82,$9,$3E,$4D,$E8,$D1,$82,$20,$A4,$3C,$68,$C8         *11c
  DC.B $0,$4B,$0,$60,$9A,$25,$51,$1A,$2F,$B2,$35,$C0,$AA,$23,$44,$3A,$23,$79,$11
  DC.B $DC,$C4,$70,$10,$F1,$1D,$F6,$4E,$81,$30,$88,$EF,$10,$FC,$F,$77,$88
  DC.B $F6,$24,$43,$43,$62,$1,$D1,$C,$12,$20,$BB,$C4,$32,$4E,$20,$B1,$22
  DC.B $19,$BA,$22,$8E,$88,$66,$11,$4,$11,$11,$CE,$64,$40,$A8,$45         *11d
  DC.B $40,$4B,$0,$60,$5C,$1D,$10,$78,$99,$D9,$1D,$10,$2B,$B0,$FD,$20,$99,$88,$26
  DC.B $E8,$81,$E3,$10,$49,$11,$3,$ED,$11,$55,$11,$3,$99,$11,$7C,$88,$32
  DC.B $F1,$15,$5D,$A2,$4,$1C,$41,$43,$62,$15,$6A,$21,$F2,$22,$A0,$E2,$15
  DC.B $44,$45,$D7,$88,$50,$E2,$2B,$98,$8E,$47,$44,$51,$94,$10,$B3         *11e
  DC.B $80,$4B,$0,$60,$31,$15,$E3,$11,$66,$E1,$25,$4A,$C5,$45,$76,$BB,$A8,$8B,$6C
  DC.B $88,$B4,$3C,$55,$83,$A2,$2C,$1C,$45,$92,$A3,$51,$1D,$15,$67,$83,$FC
  DC.B $2B,$15,$A1,$FA,$55,$88,$75,$2E,$73,$22,$AC,$D5,$15,$63,$EC,$36,$93
  DC.B $75,$52,$B9,$2C,$55,$90,$71,$56,$4D,$D1,$56,$50,$62,$AF,$33         *11f
  DC.B $C0,$4B,$0,$60,$15,$77,$88,$DC,$9B,$71,$FE,$37,$41,$8E,$EE,$A3,$BB,$78,$A8
  DC.B $C3,$15,$26,$D1,$52,$67,$54,$C7,$A8,$6B,$6A,$39,$76,$C,$CD,$45,$7
  DC.B $60,$A4,$6C,$71,$5B,$4,$76,$A2,$E9,$5E,$3C,$9B,$1B,$8A,$BC,$70,$75
  DC.B $16,$F5,$8F,$48,$DA,$CE,$D2,$9B,$25,$71,$E2,$A1,$32,$D0,$85         *120
  DC.B $0,$4C,$0,$60,$5A,$10,$B3,$42,$60,$48,$2B,$3D,$26,$3C,$85,$6A,$82,$B3,$32
  DC.B $85,$79,$A4,$EC,$4A,$47,$54,$71,$EA,$6A,$2B,$18,$63,$B8,$38,$AC,$99
  DC.B $8C,$6A,$3D,$59,$FB,$63,$E5,$D5,$9C,$BB,$1A,$6B,$56,$61,$23,$4E,$D6
  DC.B $AC,$A0,$8F,$B4,$81,$DA,$B2,$D6,$A1,$23,$56,$5D,$74,$42,$9         *121
  DC.B $40,$4C,$0,$60,$F6,$40,$C6,$FA,$14,$7D,$11,$51,$12,$E6,$A4,$73,$5D,$C6,$2B
  DC.B $E4,$8A,$3B,$2A,$39,$0,$77,$43,$8C,$5E,$9D,$29,$58,$64,$A8,$B1,$E7
  DC.B $1A,$99,$8E,$A1,$55,$69,$D8,$DD,$CB,$3,$B9,$D6,$D0,$54,$68,$66,$C5
  DC.B $46,$C4,$DF,$87,$47,$B0,$39,$21,$B0,$3A,$1F,$EF,$87,$45,$9B         *122
  DC.B $80,$4C,$0,$60,$81,$35,$FC,$C,$7E,$D,$D7,$C1,$75,$C7,$17,$82,$CF,$C1,$96
  DC.B $F1,$F0,$4A,$D0,$ED,$DE,$17,$B,$5D,$E3,$EC,$BC,$77,$C3,$58,$AB,$C0
  DC.B $C4,$3E,$80,$14,$8F,$4,$9B,$9B,$5F,$8E,$91,$93,$10,$53,$4F,$1F,$3
  DC.B $8E,$90,$52,$A4,$5A,$8A,$DE,$E4,$DC,$85,$37,$29,$17,$BF,$A7         *123
  DC.B $C0,$4C,$0,$60,$49,$9E,$84,$55,$2B,$2,$C6,$E1,$EA,$B6,$54,$C2,$B2,$2D,$41
  DC.B $97,$BD,$A,$45,$B9,$B9,$21,$C,$D,$8,$58,$ED,$3,$BD,$43,$47,$39
  DC.B $74,$6E,$46,$48,$19,$C3,$20,$8D,$49,$B7,$6E,$D8,$60,$68,$B5,$27,$13
  DC.B $B9,$A9,$3A,$CD,$B0,$BD,$F2,$BB,$35,$67,$5E,$73,$43,$58,$4B         *124
  DC.B $0,$4D,$0,$60,$FA,$31,$BC,$17,$73,$C3,$89,$4B,$8D,$4E,$75,$98,$BC,$98,$3D
  DC.B $AA,$4C,$6C,$E0,$67,$C,$ED,$58,$4,$9C,$1B,$9B,$7E,$71,$DC,$98,$E3
  DC.B $3D,$DB,$46,$8B,$C2,$91,$53,$53,$45,$6A,$B4,$97,$93,$1C,$62,$3C,$19
  DC.B $CC,$A3,$AA,$8A,$A0,$37,$DD,$32,$8B,$17,$84,$82,$65,$80,$5E         *125
  DC.B $40,$4D,$0,$60,$65,$3F,$AF,$9,$96,$5D,$68,$6D,$64,$53,$FB,$90,$98,$A6,$8B
  DC.B $8B,$19,$4E,$B6,$DD,$20,$A8,$F0,$1E,$C0,$40,$4A,$8F,$9,$C5,$79,$DA
  DC.B $B1,$BE,$DA,$97,$83,$2,$6D,$DC,$BC,$25,$DB,$9,$7A,$1D,$A5,$E1,$9
  DC.B $68,$CD,$E7,$2B,$C2,$74,$5B,$9,$B2,$33,$D6,$AF,$9,$73,$D9         *126
  DC.B $80,$4D,$0,$60,$47,$3C,$AF,$C8,$13,$4B,$B4,$DF,$41,$F4,$A1,$57,$E4,$11,$6C
  DC.B $D6,$85,$3D,$44,$F0,$44,$8C,$1B,$EE,$4F,$F,$CE,$DB,$6D,$F7,$11,$AE
  DC.B $3C,$C7,$25,$97,$25,$DC,$47,$E7,$3C,$AF,$C8,$30,$9B,$E,$C1,$60,$C3
  DC.B $B6,$3B,$5,$83,$5C,$70,$6F,$B9,$48,$70,$6A,$28,$40,$25,$AA         *127
  DC.B $C0,$4D,$0,$60,$DF,$47,$66,$56,$A9,$9E,$17,$61,$53,$90,$85,$37,$58,$B1,$4
  DC.B $66,$78,$4E,$13,$33,$B7,$87,$6,$92,$C6,$37,$DA,$85,$71,$29,$70,$62
  DC.B $F,$D2,$6E,$1E,$2D,$1F,$A8,$60,$E9,$DC,$B0,$3C,$22,$BC,$68,$EE,$F1
  DC.B $A9,$4F,$19,$8E,$F1,$A8,$3B,$C6,$82,$41,$43,$35,$F0,$A1,$B4         *128
  DC.B $0,$4E,$0,$60,$18,$86,$FE,$62,$19,$26,$14,$36,$D8,$AA,$68,$46,$2A,$9B,$33
  DC.B $3B,$FF,$AA,$DF,$43,$6E,$62,$2E,$B1,$D1,$B0,$E5,$66,$B1,$95,$8C,$96
  DC.B $26,$29,$B0,$B3,$95,$0,$DC,$86,$8E,$D,$4B,$96,$13,$72,$C2,$6E,$42
  DC.B $3C,$D,$4D,$43,$5E,$1,$44,$78,$16,$84,$4D,$8C,$4F,$2E,$EA         *129
  DC.B $40,$4E,$0,$60,$84,$F2,$27,$9C,$E3,$C0,$D4,$C8,$57,$4A,$C6,$C2,$6E,$56,$1F
  DC.B $3F,$98,$EF,$37,$36,$42,$9B,$9,$B9,$54,$3D,$C4,$9A,$A3,$8F,$22,$68
  DC.B $95,$55,$8E,$E5,$35,$7F,$79,$D9,$E2,$A5,$3C,$E,$74,$5C,$6B,$A5,$C1
  DC.B $BE,$83,$6B,$F3,$88,$73,$D2,$83,$17,$E4,$4B,$B8,$D6,$80,$92         *12a
  DC.B $80,$4E,$0,$60,$95,$DD,$FC,$8B,$C8,$62,$2A,$82,$F1,$F9,$83,$B7,$56,$D2,$CC
  DC.B $D0,$B8,$4C,$D9,$16,$A1,$89,$7D,$7C,$0,$C5,$EA,$D9,$14,$4B,$6C,$B5
  DC.B $52,$85,$12,$31,$7,$82,$CC,$AD,$91,$44,$8C,$42,$C7,$82,$B1,$E0,$AC
  DC.B $4D,$C1,$A,$58,$F0,$5B,$7D,$AB,$6B,$C1,$60,$6C,$78,$2B,$11         *12b
  DC.B $C0,$4E,$0,$60,$31,$7E,$43,$E0,$C5,$51,$16,$43,$E9,$FE,$A8,$8B,$21,$F4,$AB
  DC.B $1E,$A,$CF,$4,$3B,$4,$E6,$0,$E8,$2E,$65,$A0,$1D,$5,$CC,$9A,$B3
  DC.B $C1,$55,$73,$84,$E1,$9D,$EA,$B0,$45,$3E,$D1,$6B,$64,$48,$6A,$92,$42
  DC.B $81,$31,$90,$E7,$E,$6A,$EC,$45,$9,$A3,$97,$4C,$DF,$9,$73         *12c
  DC.B $0,$4F,$0,$60,$E,$E0,$50,$50,$86,$A0,$4C,$64,$3A,$E,$75,$AB,$CE,$5A,$F3
  DC.B $34,$2E,$5,$26,$34,$74,$31,$FF,$C7,$1D,$BC,$11,$6C,$A1,$5E,$4E,$4E
  DC.B $75,$E1,$FE,$9E,$2C,$A2,$7,$5A,$2B,$CE,$A5,$EB,$C9,$CF,$CE,$EA,$D5
  DC.B $11,$9A,$1D,$4B,$36,$47,$FC,$8F,$3E,$5B,$C0,$27,$1C,$FC,$7B         *12d
  DC.B $40,$4F,$0,$60,$CF,$F,$F2,$75,$2E,$9A,$D0,$FF,$2C,$E7,$56,$73,$AA,$DF,$D6
  DC.B $50,$D9,$B2,$86,$A7,$96,$67,$AA,$A4,$DE,$BE,$F4,$9,$DF,$7D,$E8,$13
  DC.B $85,$F9,$6,$92,$BF,$20,$D8,$FE,$20,$D1,$EF,$10,$68,$3F,$10,$24,$FF
  DC.B $20,$48,$7F,$20,$4B,$41,$F2,$4,$B4,$7E,$40,$94,$1F,$24,$7F         *12e
  DC.B $80,$4F,$0,$60,$24,$32,$BB,$CA,$B7,$D0,$DC,$E5,$A1,$FE,$76,$37,$40,$49,$9D
  DC.B $8D,$8E,$E7,$33,$CC,$ED,$63,$71,$5D,$8D,$D8,$1B,$1D,$8D,$1E,$E8,$D2
  DC.B $9D,$1C,$A7,$45,$81,$37,$2B,$13,$72,$93,$3B,$B0,$18,$D3,$E4,$56,$64
  DC.B $5C,$92,$18,$D9,$24,$6F,$C9,$1E,$54,$C2,$E3,$94,$FD,$B3,$8E         *12f
  DC.B $C0,$4F,$0,$60,$16,$CC,$A1,$A4,$60,$98,$ED,$59,$F7,$37,$34,$53,$73,$72,$B7
  DC.B $2E,$5B,$73,$49,$7B,$51,$3,$92,$6E,$69,$19,$B9,$A7,$8D,$CF,$F4,$DC
  DC.B $E1,$1A,$AE,$4C,$35,$5B,$E8,$69,$18,$27,$38,$EA,$58,$A5,$A4,$4C,$52
  DC.B $D8,$98,$A5,$A2,$31,$4B,$41,$B0,$90,$9B,$92,$42,$C,$92,$16         *130
  DC.B $0,$50,$0,$60,$C6,$49,$B,$7C,$92,$14,$19,$24,$7F,$32,$DE,$43,$85,$97,$4A
  DC.B $EF,$A3,$30,$AF,$B2,$7F,$BF,$B2,$6A,$F,$12,$E3,$FD,$97,$17,$D9,$69
  DC.B $1B,$D9,$6C,$67,$D9,$68,$AF,$92,$D0,$FE,$4D,$2F,$93,$5A,$3F,$27,$7
  DC.B $F2,$6C,$B5,$5E,$1B,$55,$7C,$DA,$AA,$1B,$55,$BF,$69,$B8,$D9         *131
  DC.B $40,$50,$0,$60,$26,$DB,$F9,$36,$A1,$48,$6A,$E6,$D5,$73,$6A,$B9,$B0,$E0,$63
  DC.B $A5,$C7,$B0,$97,$15,$84,$B4,$89,$84,$B6,$35,$84,$B4,$54,$27,$68,$70
  DC.B $9E,$94,$27,$AD,$18,$4F,$C7,$9,$EC,$B0,$BB,$D4,$10,$B7,$CF,$62,$47
  DC.B $B9,$D9,$34,$DF,$9F,$1C,$EF,$C8,$B3,$BF,$A,$9D,$F8,$1C,$DF         *132
  DC.B $80,$50,$0,$60,$80,$66,$CE,$91,$DF,$27,$60,$7E,$4E,$8A,$F9,$3A,$3B,$C4,$9C
  DC.B $5E,$C9,$E0,$B5,$73,$6A,$B9,$B5,$5C,$DA,$AD,$FB,$73,$A8,$90,$9C,$FC
  DC.B $84,$BC,$FA,$25,$35,$7A,$A3,$6A,$C6,$D5,$8D,$87,$6,$3B,$E7,$36,$1F
  DC.B $A,$61,$F0,$36,$1F,$0,$B0,$FA,$6E,$87,$F6,$6,$1F,$D1,$50         *133
  DC.B $C0,$50,$0,$60,$FE,$8E,$C3,$E7,$16,$1F,$2C,$58,$5B,$96,$38,$5B,$93,$26,$12
  DC.B $3C,$BE,$25,$24,$B8,$B3,$BC,$9A,$13,$F9,$36,$4F,$E5,$3B,$73,$F8,$9F
  DC.B $2F,$10,$71,$3E,$46,$3,$F9,$14,$DF,$F2,$2C,$6F,$64,$52,$67,$64,$5C
  DC.B $EB,$1B,$56,$36,$AC,$6D,$63,$F6,$5E,$1E,$CD,$75,$BF,$57,$4F         *134
  DC.B $0,$51,$0,$60,$2A,$64,$E7,$71,$B5,$C6,$D7,$1B,$E,$0,$9D,$21,$A5,$84,$86
  DC.B $C6,$12,$27,$6,$1C,$4F,$61,$D8,$38,$87,$2E,$E,$72,$D3,$79,$CB,$51
  DC.B $B9,$CB,$49,$F3,$96,$B1,$96,$5C,$5C,$B2,$F0,$48,$7D,$DD,$59,$F2,$5E
  DC.B $92,$FD,$30,$3,$F4,$C8,$BC,$96,$87,$92,$D5,$F2,$7E,$3E,$A7         *135
  DC.B $40,$51,$0,$60,$EF,$D4,$E1,$F5,$38,$E7,$A9,$C6,$75,$34,$EB,$8D,$AE,$36,$B8
  DC.B $DA,$C3,$DA,$25,$8D,$C5,$D,$D8,$A1,$E5,$4A,$33,$71,$B5,$C6,$D7,$1B
  DC.B $E,$4A,$72,$60,$3,$4,$C8,$98,$25,$A0,$CA,$5A,$AC,$A7,$E3,$DA,$7E
  DC.B $FB,$4E,$1E,$D3,$8E,$76,$9C,$66,$D3,$4E,$D4,$34,$96,$A1,$AC         *136
  DC.B $80,$51,$0,$60,$D2,$47,$A2,$A2,$B9,$45,$50,$7D,$13,$F,$A2,$26,$F4,$5C,$2F
  DC.B $44,$E2,$F4,$4E,$FB,$B1,$31,$BB,$17,$3B,$B1,$73,$3B,$16,$7,$B1,$53
  DC.B $EE,$36,$B8,$DA,$E3,$6B,$15,$DA,$87,$B8,$C5,$FE,$C6,$10,$2A,$C6,$DC
  DC.B $6D,$71,$B5,$C6,$C9,$CA,$9D,$13,$B,$31,$13,$33,$17,$9,$98         *137
  DC.B $C0,$51,$0,$60,$9C,$4C,$C4,$EF,$B7,$13,$D,$B8,$B9,$DB,$8B,$9C,$DC,$58,$1D
  DC.B $C5,$4F,$D5,$15,$57,$54,$54,$54,$15,$85,$4E,$FB,$F,$38,$25,$25,$AF
  DC.B $43,$74,$AC,$49,$81,$CE,$DD,$2E,$8B,$D7,$13,$3A,$5A,$87,$4A,$10,$74
  DC.B $AE,$7B,$A5,$87,$9D,$14,$6D,$D1,$D6,$9D,$45,$2F,$3A,$34,$A9         *138
  DC.B $0,$52,$0,$60,$D4,$52,$FE,$F5,$14,$B2,$F2,$29,$2B,$D2,$5F,$A5,$5E,$45,$22
  DC.B $F2,$2F,$63,$A2,$3A,$34,$A8,$25,$36,$31,$3F,$34,$1C,$ED,$8C,$D3,$2F
  DC.B $3A,$46,$4C,$65,$73,$71,$23,$CD,$6,$E5,$18,$6E,$58,$1E,$39,$5F,$70
  DC.B $A6,$10,$5E,$42,$89,$79,$10,$EB,$C8,$5F,$AF,$48,$82,$C5,$E4         *139
  DC.B $40,$52,$0,$60,$38,$D7,$E2,$F6,$36,$A2,$68,$30,$34,$E0,$86,$68,$40,$32,$7
  DC.B $F1,$8C,$EB,$5C,$6E,$33,$AD,$69,$7C,$67,$5A,$CA,$30,$4E,$C0,$D5,$1F
  DC.B $1F,$AC,$BF,$8C,$25,$2C,$4C,$55,$88,$54,$96,$FD,$36,$92,$DF,$80,$66
  DC.B $8E,$8A,$6D,$D9,$E9,$B7,$30,$1C,$DB,$94,$13,$6E,$90,$E5,$DC         *13a
  DC.B $80,$52,$0,$60,$E3,$4B,$B9,$CB,$97,$73,$E5,$DD,$34,$B1,$D8,$D5,$49,$11,$52
  DC.B $44,$54,$91,$16,$4E,$22,$35,$40,$EE,$35,$2C,$EC,$6A,$4E,$AA,$B5,$22
  DC.B $AD,$49,$11,$52,$44,$59,$49,$22,$36,$99,$DB,$3C,$CE,$CC,$6,$CE,$CA
  DC.B $6,$76,$90,$E3,$D9,$C6,$8F,$67,$2E,$3D,$9F,$1E,$D3,$47,$B4         *13b
  DC.B $C0,$52,$0,$60,$1A,$8A,$DA,$3,$15,$B5,$35,$68,$E2,$DD,$82,$A4,$B7,$66,$9B
  DC.B $6A,$C9,$36,$FA,$89,$B7,$ED,$36,$FD,$C9,$B7,$B1,$52,$EF,$51,$25,$DF
  DC.B $20,$97,$7B,$82,$5D,$ED,$72,$EF,$8E,$E3,$6B,$8D,$AE,$36,$B0,$F6,$DF
  DC.B $0,$C7,$BE,$24,$4B,$BE,$7D,$AA,$63,$B8,$DA,$E3,$6B,$8D,$87         *13c
  DC.B $0,$53,$0,$60,$D8,$EA,$C8,$CE,$FA,$86,$77,$EC,$CE,$FD,$C6,$77,$B1,$51,$EF
  DC.B $51,$23,$DF,$20,$8F,$7B,$82,$3D,$ED,$71,$EF,$8E,$2B,$7C,$D1,$5A,$C1
  DC.B $42,$47,$B3,$E4,$E3,$92,$CF,$8D,$73,$6B,$49,$B3,$6B,$4A,$9B,$5A,$CB
  DC.B $36,$7E,$2C,$D9,$FE,$94,$B9,$BC,$C9,$73,$6C,$44,$B9,$B5,$3C         *13d
  DC.B $40,$53,$0,$60,$B9,$98,$64,$B9,$8D,$1B,$8D,$AE,$36,$B8,$DA,$C3,$DB,$32,$77
  DC.B $8F,$32,$4F,$97,$32,$7B,$2B,$56,$A4,$70,$B8,$DA,$E3,$61,$F6,$3B,$5A
  DC.B $4D,$67,$5A,$53,$3A,$D6,$2C,$E6,$35,$E,$66,$94,$79,$32,$E3,$C8,$8
  DC.B $8F,$22,$9E,$3C,$98,$64,$79,$4,$62,$64,$17,$13,$24,$E0,$D2         *13e
  DC.B $80,$53,$0,$60,$3D,$A6,$2B,$C9,$69,$E1,$E6,$C9,$3E,$79,$B2,$45,$26,$C9,$49
  DC.B $93,$64,$A4,$4D,$92,$B3,$97,$4D,$89,$74,$F6,$97,$4F,$3E,$5D,$35,$E6
  DC.B $5D,$3E,$37,$63,$6B,$1B,$58,$DA,$E1,$ED,$A2,$28,$1E,$89,$97,$44,$5
  DC.B $57,$6,$36,$63,$66,$36,$EF,$E3,$A9,$F,$9E,$8C,$41,$4A,$31         *13f
  DC.B $C0,$53,$0,$60,$10,$CA,$31,$10,$51,$88,$B6,$39,$1C,$E,$44,$C3,$91,$1E,$39
  DC.B $1B,$C8,$E4,$58,$D8,$92,$20,$84,$91,$4A,$FD,$23,$D1,$55,$8E,$4A,$2A
  DC.B $DE,$4D,$20,$9C,$9A,$41,$18,$D2,$F,$83,$48,$6,$1A,$42,$34,$59,$8
  DC.B $61,$64,$2C,$4B,$14,$78,$58,$A6,$C8,$B1,$4C,$65,$8D,$98,$D9         *140
  DC.B $0,$54,$0,$60,$8D,$9C,$3D,$A2,$90,$0,$71,$4A,$80,$B1,$4A,$8B,$5C,$5B,$1B
  DC.B $31,$B3,$1B,$77,$A3,$A4,$13,$B4,$64,$11,$A8,$C8,$3F,$51,$90,$C,$A3
  DC.B $21,$1A,$1C,$84,$30,$72,$16,$23,$86,$F0,$70,$F6,$43,$87,$8F,$12,$1E
  DC.B $F2,$24,$3B,$1D,$47,$2A,$EE,$AB,$C5,$D0,$7F,$62,$83,$F8,$9D         *141
  DC.B $40,$54,$0,$60,$DF,$3B,$95,$6C,$E9,$FD,$31,$CA,$EB,$BD,$2,$52,$98,$5F,$F1
  DC.B $BA,$F,$E2,$7B,$83,$AE,$8D,$2A,$63,$BF,$A1,$BB,$98,$6F,$DF,$1F,$8B
  DC.B $38,$D7,$D5,$95,$A5,$68,$BF,$9A,$14,$F6,$3C,$28,$53,$D0,$A4,$AB,$7F
  DC.B $6E,$4D,$85,$EF,$BA,$7C,$ED,$50,$7F,$E,$4C,$9B,$A0,$FD,$AD         *142
  DC.B $80,$54,$0,$60,$F7,$F5,$DF,$72,$E9,$EB,$A,$27,$72,$58,$74,$B8,$BF,$9D,$7F
  DC.B $DD,$32,$14,$15,$74,$F0,$E8,$14,$5F,$CF,$FD,$5F,$7F,$FF,$FF,$BD,$83
  DC.B $D5,$FF,$88,$31,$F,$FA,$BD,$BA,$6,$9F,$FE,$83,$7,$25,$EA,$56,$94
  DC.B $97,$9E,$FA,$77,$7F,$EC,$F,$C3,$ED,$54,$E6,$2F,$F6,$81,$51         *143
  DC.B $C0,$54,$0,$60,$BF,$A1,$CD,$F6,$BE,$42,$C6,$AA,$FD,$7E,$8B,$9D,$4,$3A,$8
  DC.B $74,$21,$D1,$E,$88,$74,$43,$84,$38,$43,$88,$71,$E,$21,$C4,$39,$E
  DC.B $43,$90,$E4,$38,$8,$20,$6A,$72,$39,$1,$F5,$33,$EA,$3F,$D0,$2F,$7A
  DC.B $C8,$42,$51,$56,$5A,$D0,$2F,$7A,$C8,$42,$51,$0,$0,$0,$0         *144
  DC.B $0,$55,$0,$60,$F0,$B4,$4,$9F,$18,$1C,$30,$4B,$1B,$88,$7,$2B,$5A,$D1,$2F
  DC.B $4C,$0,$23,$E3,$5E,$2E,$4E,$0,$2B,$11,$D1,$1,$23,$23,$80,$0,$25
  DC.B $2C,$4B,$1D,$80,$1,$24,$2C,$4D,$2C,$4B,$9D,$80,$2C,$4D,$F5,$80,$0
  DC.B $25,$5D,$80,$2B,$4D,$2B,$88,$1B,$19,$2B,$80,$0,$E0,$0,$24         *145
  DC.B $40,$55,$0,$60,$3,$23,$5B,$3,$1,$25,$6D,$7,$6B,$84,$20,$23,$ED,$5E,$26
  DC.B $4B,$6B,$40,$1B,$4,$1B,$14,$1,$25,$6D,$7,$3B,$60,$20,$23,$EF,$5E
  DC.B $21,$4B,$7B,$40,$1B,$4,$1B,$14,$3,$60,$20,$48,$68,$84,$1E,$48,$48
  DC.B $40,$28,$84,$1C,$48,$50,$40,$28,$84,$1A,$4D,$2A,$88,$1C,$49         *146
  DC.B $80,$55,$0,$60,$8,$88,$82,$42,$18,$D0,$1,$30,$8,$80,$31,$88,$1,$20,$40
  DC.B $7,$1,$84,$71,$88,$1,$84,$0,$2C,$2,$D0,$1,$23,$3,$84,$2,$E0
  DC.B $20,$23,$C1,$5E,$B1,$80,$20,$23,$C1,$5E,$C1,$5E,$31,$81,$11,$49,$9
  DC.B $68,$C9,$7,$C9,$F,$1,$84,$F,$48,$0,$23,$C0,$5E,$1,$21         *147
  DC.B $C0,$55,$0,$60,$49,$7,$48,$84,$F0,$BC,$70,$47,$D8,$28,$0,$40,$E4,$28,$0
  DC.B $40,$88,$29,$0,$40,$E2,$28,$0,$40,$E1,$BD,$FF,$FF,$AC,$A,$1,$0
  DC.B $E1,$BD,$0,$0,$D8,$27,$0,$40,$5A,$5A,$0,$0,$2,$60,$0,$0,$DA
  DC.B $27,$0,$40,$FC,$5,$1,$0,$6C,$1,$1,$0,$6C,$10,$9F,$E5         *148
  DC.B $0,$56,$0,$60,$B0,$10,$D1,$E1,$7,$0,$51,$E3,$17,$0,$0,$1A,$60,$10,$9F
  DC.B $E5,$B0,$20,$D1,$E1,$1,$20,$82,$E2,$B0,$20,$C1,$E1,$2,$18,$A0,$E1
  DC.B $21,$18,$A0,$E1,$A,$A,$51,$E3,$F,$0,$0,$1A,$44,$10,$9F,$E5,$F0
  DC.B $20,$D1,$E1,$C2,$37,$A0,$E1,$42,$36,$23,$E0,$1,$30,$3,$E2         *149
  DC.B $40,$56,$0,$60,$82,$20,$83,$E1,$B0,$20,$C1,$E1,$7,$30,$A0,$E3,$6,$3A,$83
  DC.B $E2,$2,$22,$A0,$E3,$B2,$32,$C2,$E1,$B0,$30,$D1,$E1,$B0,$32,$C2,$E1
  DC.B $B0,$10,$D1,$E1,$10,$20,$9F,$E5,$B6,$10,$C2,$E1,$E0,$DA,$FF,$EA,$D8
  DC.B $28,$0,$40,$AE,$A,$1,$0,$B0,$A,$1,$0,$88,$29,$0,$40         *14a
  DC.B $80,$56,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$80,$B4,$1,$1C,$42,$68,$0
  DC.B $20,$0,$2A,$15,$D0,$CB,$68,$8F,$68,$BB,$42,$0,$DD,$8B,$60,$1,$3B
  DC.B $CB,$60,$B,$68,$9A,$42,$2,$D1,$8,$60,$13,$1C,$1,$E0,$10,$68,$13
  DC.B $1C,$48,$60,$98,$79,$0,$28,$1,$D1,$80,$20,$98,$71,$18,$1C         *14b
  DC.B $C0,$56,$0,$60,$80,$BC,$70,$47,$80,$B4,$1,$68,$40,$68,$CA,$68,$1,$32,$CA
  DC.B $60,$CA,$68,$8B,$68,$9A,$42,$0,$DD,$8A,$60,$0,$23,$A,$68,$0,$2A
  DC.B $8,$D1,$4F,$68,$0,$2F,$1,$D0,$4A,$60,$6,$E0,$3,$60,$8,$60,$48
  DC.B $60,$2,$E0,$10,$60,$3,$60,$8,$60,$81,$79,$0,$29,$1,$D1         *14c
  DC.B $0,$57,$0,$60,$80,$21,$81,$71,$80,$BC,$70,$47,$1,$68,$40,$68,$CA,$68,$1
  DC.B $32,$CA,$60,$CA,$68,$8B,$68,$9A,$42,$0,$DD,$8A,$60,$A,$68,$0,$2A
  DC.B $8,$D1,$4B,$68,$0,$2B,$1,$D0,$4A,$60,$6,$E0,$0,$22,$2,$60,$8
  DC.B $60,$1,$E0,$4A,$68,$2,$60,$48,$60,$81,$79,$0,$29,$1,$D1         *14d
  DC.B $40,$57,$0,$60,$80,$21,$81,$71,$70,$47,$80,$B4,$6,$DF,$0,$6,$0,$E,$7
  DC.B $49,$87,$0,$7,$4A,$D1,$51,$1,$21,$6,$4A,$11,$54,$6,$48,$0,$68
  DC.B $B,$21,$4,$DF,$5,$48,$C0,$59,$80,$BC,$70,$47,$91,$1,$0,$40,$B4
  DC.B $53,$0,$40,$DC,$53,$0,$40,$AC,$28,$0,$40,$8C,$53,$0,$40         *14e
  DC.B $80,$57,$0,$60,$B0,$B4,$5,$6,$2D,$E,$C,$1C,$17,$1C,$82,$B0,$6,$DF,$0
  DC.B $6,$0,$E,$0,$94,$1,$97,$0,$2D,$1,$D1,$9,$49,$0,$E0,$9,$49
  DC.B $82,$0,$9,$4B,$99,$50,$69,$46,$8,$4B,$99,$50,$1,$22,$8,$49,$A
  DC.B $54,$8,$48,$0,$68,$B,$21,$4,$DF,$2,$B0,$B0,$BC,$70,$47         *14f
  DC.B $C0,$57,$0,$60,$81,$0,$0,$40,$3D,$0,$0,$40,$B4,$53,$0,$40,$8C,$53,$0
  DC.B $40,$DC,$53,$0,$40,$AC,$28,$0,$40,$B0,$B4,$7,$1C,$6,$DF,$0,$6
  DC.B $0,$E,$8,$49,$84,$0,$8,$4A,$11,$51,$8,$4D,$2F,$51,$1,$21,$7
  DC.B $4A,$11,$54,$7,$48,$0,$68,$B,$21,$4,$DF,$28,$59,$B0,$BC         *150
  DC.B $0,$58,$0,$60,$70,$47,$0,$0,$1,$0,$0,$40,$B4,$53,$0,$40,$8C,$53,$0
  DC.B $40,$DC,$53,$0,$40,$AC,$28,$0,$40,$7,$48,$0,$21,$82,$79,$0,$2A
  DC.B $3,$D0,$98,$30,$1,$31,$1E,$29,$F8,$DB,$1E,$29,$2,$DA,$80,$21,$81
  DC.B $71,$70,$47,$FE,$E7,$0,$0,$E8,$29,$0,$40,$9,$48,$0,$22         *151
  DC.B $40,$58,$0,$60,$0,$21,$83,$79,$0,$2B,$2,$D1,$1,$32,$5,$2A,$3,$DC,$98
  DC.B $30,$1,$31,$1E,$29,$F5,$DB,$5,$2A,$1,$DD,$1,$20,$70,$47,$0,$20
  DC.B $70,$47,$0,$0,$E8,$29,$0,$40,$0,$21,$81,$71,$70,$47,$0,$B5,$4
  DC.B $48,$5,$49,$B,$68,$5,$4A,$0,$21,$7,$F0,$2B,$FE,$8,$BC         *152
  DC.B $80,$58,$0,$60,$18,$47,$0,$0,$E8,$29,$0,$40,$B8,$3A,$0,$60,$D0,$11,$0
  DC.B $0,$B0,$B5,$35,$4F,$B8,$69,$11,$21,$49,$3,$1,$40,$15,$D0,$1,$22
  DC.B $52,$3,$2,$40,$31,$48,$32,$49,$7,$D0,$0,$68,$CA,$6B,$0,$21,$7
  DC.B $F0,$E,$FE,$1,$20,$40,$3,$6,$E0,$0,$68,$CA,$6B,$1,$21         *153
  DC.B $C0,$58,$0,$60,$7,$F0,$6,$FE,$1,$20,$40,$4,$38,$61,$78,$6A,$C0,$B,$48
  DC.B $D3,$28,$49,$D,$78,$28,$4C,$29,$48,$29,$4B,$0,$2D,$16,$D0,$0,$22
  DC.B $7D,$27,$FF,$0,$1,$2D,$1D,$D0,$2,$2D,$31,$D1,$1D,$7F,$2D,$11,$6D
  DC.B $8,$32,$D3,$1B,$7F,$5B,$8,$2F,$D2,$24,$68,$3,$68,$E3,$1A         *154
  DC.B $0,$59,$0,$60,$96,$2B,$1,$D3,$BB,$42,$1F,$D9,$A,$70,$26,$E0,$1A,$7F,$52
  DC.B $11,$52,$8,$22,$D3,$1A,$7F,$52,$10,$52,$8,$1E,$D2,$22,$68,$2,$60
  DC.B $1,$20,$13,$E0,$1D,$7F,$6D,$11,$6D,$8,$16,$D3,$1B,$7F,$5B,$10,$5B
  DC.B $8,$12,$D3,$24,$68,$3,$68,$E3,$1A,$96,$2B,$E4,$D3,$BB,$42         *155
  DC.B $40,$59,$0,$60,$E2,$D8,$4,$60,$2,$20,$1,$E0,$4,$60,$3,$20,$8,$70,$4
  DC.B $E0,$18,$7F,$0,$11,$40,$8,$0,$D3,$18,$7F,$1,$20,$80,$3,$9,$49
  DC.B $8,$60,$B0,$BC,$8,$BC,$18,$47,$0,$60,$0,$E0,$B4,$28,$0,$40,$AC
  DC.B $1,$1,$0,$54,$28,$0,$40,$50,$0,$1,$0,$FC,$27,$0,$40         *156
  DC.B $80,$59,$0,$60,$0,$80,$1,$E0,$10,$60,$0,$E0,$F0,$B5,$7,$1C,$15,$4E,$0
  DC.B $23,$F0,$5E,$15,$49,$C9,$5E,$44,$1A,$14,$4D,$1,$D5,$E8,$5E,$24,$18
  DC.B $0,$23,$E8,$5E,$41,$0,$3,$20,$7,$F0,$BA,$FD,$A0,$42,$4,$DA,$F
  DC.B $48,$1,$78,$1,$23,$19,$43,$1,$70,$0,$23,$E8,$5E,$1,$38         *157
  DC.B $C0,$59,$0,$60,$A0,$42,$C,$DD,$F0,$5E,$F1,$5E,$1,$30,$30,$80,$9,$48,$0
  DC.B $68,$47,$54,$F0,$5E,$E9,$5E,$88,$42,$1,$DB,$0,$20,$30,$80,$F0,$BC
  DC.B $8,$BC,$18,$47,$64,$0,$1,$0,$66,$0,$1,$0,$68,$0,$1,$0,$14
  DC.B $80,$1,$E0,$6C,$0,$1,$0,$0,$B5,$3,$48,$0,$68,$7,$F0         *158
  DC.B $0,$5A,$0,$60,$63,$FD,$80,$10,$8,$BC,$18,$47,$AC,$3A,$0,$60,$FF,$20,$8
  DC.B $49,$B,$78,$8,$4A,$11,$78,$8B,$42,$8,$D0,$48,$1C,$10,$70,$6,$48
  DC.B $40,$5C,$11,$78,$80,$29,$1,$D1,$0,$21,$11,$70,$70,$47,$0,$0,$8B
  DC.B $1,$1,$0,$8C,$1,$1,$0,$E8,$53,$0,$40,$90,$B5,$F,$48         *159
  DC.B $40,$5A,$0,$60,$0,$68,$7,$F0,$41,$FD,$4,$1C,$D,$48,$0,$23,$C0,$5E,$D
  DC.B $49,$C9,$5E,$47,$1A,$C,$48,$1,$D5,$C1,$5E,$7F,$18,$0,$23,$C1,$5E
  DC.B $3,$20,$7,$F0,$5D,$FD,$B8,$42,$4,$DD,$8,$48,$1,$78,$49,$8,$49
  DC.B $0,$1,$70,$20,$1C,$90,$BC,$8,$BC,$18,$47,$B0,$3A,$0,$60         *15a
  DC.B $80,$5A,$0,$60,$64,$0,$1,$0,$66,$0,$1,$0,$68,$0,$1,$0,$14,$80,$1
  DC.B $E0,$0,$B5,$8,$48,$0,$68,$80,$E,$C0,$6,$8,$D0,$6,$48,$C1,$6B
  DC.B $6,$4B,$19,$40,$C1,$63,$6,$48,$0,$68,$7,$F0,$D,$FD,$8,$BC,$18
  DC.B $47,$0,$0,$B0,$5,$1,$0,$8,$6,$1,$0,$1F,$FE,$FF,$FF         *15b
  DC.B $C0,$5A,$0,$60,$A4,$3A,$0,$60,$F0,$B5,$81,$B0,$34,$4E,$35,$4F,$F8,$60,$35
  DC.B $48,$19,$21,$9,$3,$8,$60,$64,$20,$3,$DF,$33,$4D,$E8,$1D,$FF,$30
  DC.B $7A,$30,$C0,$6D,$7,$F0,$F0,$FC,$E8,$1D,$F9,$30,$80,$6F,$7,$F0,$EB
  DC.B $FC,$EC,$1D,$79,$34,$60,$6B,$7,$F0,$E6,$FC,$0,$20,$A1,$6A         *15c
  DC.B $0,$5B,$0,$60,$7,$F0,$E4,$FC,$E8,$6A,$7,$F0,$DF,$FC,$28,$48,$0,$68,$7
  DC.B $F0,$DB,$FC,$F,$28,$3,$D1,$26,$4D,$26,$48,$0,$90,$5,$E0,$2,$F0
  DC.B $59,$F8,$2,$21,$78,$69,$4,$DF,$F5,$E7,$23,$48,$19,$21,$9,$3,$8
  DC.B $60,$A,$20,$3,$DF,$20,$6D,$7,$F0,$C6,$FC,$28,$68,$7,$F0         *15d
  DC.B $40,$5B,$0,$60,$C3,$FC,$0,$98,$0,$68,$80,$8,$1E,$D3,$2,$F0,$D9,$F8,$1
  DC.B $F0,$E1,$FC,$1A,$48,$0,$23,$C0,$56,$19,$49,$C9,$56,$88,$42,$2,$D1
  DC.B $30,$68,$0,$28,$2,$D0,$1,$21,$38,$68,$4,$DF,$15,$48,$1,$78,$15
  DC.B $4A,$10,$78,$81,$42,$4,$D0,$1,$30,$10,$70,$1,$21,$38,$68         *15e
  DC.B $80,$5B,$0,$60,$4,$DF,$1,$F0,$65,$F9,$D0,$E7,$10,$48,$0,$78,$0,$28,$CC
  DC.B $D0,$F,$48,$19,$21,$9,$3,$8,$60,$FE,$E7,$0,$0,$BC,$0,$1,$0
  DC.B $A4,$28,$0,$40,$0,$60,$EA,$80,$AC,$1,$1,$0,$F8,$3A,$0,$60,$0
  DC.B $3B,$0,$60,$84,$1,$1,$0,$0,$C0,$D4,$81,$8C,$0,$1,$0         *15f
  DC.B $C0,$5B,$0,$60,$8D,$0,$1,$0,$6C,$29,$0,$40,$6D,$29,$0,$40,$8A,$1,$1
  DC.B $0,$0,$0,$71,$82,$F0,$B5,$D,$49,$88,$60,$64,$20,$3,$DF,$C,$4E
  DC.B $C,$4D,$0,$20,$C0,$43,$5,$DF,$0,$27,$B,$49,$C8,$5D,$0,$28,$7
  DC.B $D0,$0,$20,$C8,$55,$BC,$0,$28,$59,$31,$59,$7,$F0,$66,$FC         *160
  DC.B $0,$5C,$0,$60,$28,$51,$1,$37,$A,$2F,$F0,$D3,$EB,$E7,$0,$0,$A4,$28,$0
  DC.B $40,$B4,$53,$0,$40,$8C,$53,$0,$40,$DC,$53,$0,$40,$F0,$B5,$18,$4D
  DC.B $68,$60,$64,$20,$3,$DF,$17,$48,$C4,$1D,$FF,$34,$7A,$34,$16,$4E,$C7
  DC.B $1D,$FF,$37,$FA,$37,$0,$20,$5,$DF,$0,$28,$3,$D1,$4,$20         *161
  DC.B $40,$5C,$0,$60,$3,$DF,$0,$20,$5,$DF,$0,$28,$12,$D1,$20,$6E,$7,$F0,$3C
  DC.B $FC,$78,$6C,$7,$F0,$39,$FC,$0,$F0,$81,$FB,$31,$78,$B,$4A,$10,$78
  DC.B $81,$42,$4,$D0,$1,$30,$10,$70,$0,$21,$28,$68,$4,$DF,$4,$20,$C0
  DC.B $8,$E0,$D3,$B8,$6C,$7,$F0,$27,$FC,$0,$F0,$6F,$FB,$DA,$E7         *162
  DC.B $80,$5C,$0,$60,$A4,$28,$0,$40,$AC,$1,$1,$0,$48,$29,$0,$40,$49,$29,$0
  DC.B $40,$F0,$B5,$E,$4E,$30,$60,$64,$20,$3,$DF,$D,$4D,$D,$4C,$0,$20
  DC.B $C0,$43,$5,$DF,$7,$1C,$40,$8,$A,$D3,$E0,$68,$7,$F0,$C,$FC,$28
  DC.B $68,$40,$8,$2,$D3,$A,$21,$70,$69,$4,$DF,$2,$23,$1F,$43         *163
  DC.B $C0,$5C,$0,$60,$B8,$8,$EC,$D3,$A0,$68,$7,$F0,$FF,$FB,$E8,$E7,$A4,$28,$0
  DC.B $40,$C0,$0,$1,$0,$2C,$4,$1,$0,$F0,$B5,$84,$B0,$26,$4F,$B8,$61
  DC.B $8,$21,$78,$69,$4,$DF,$64,$20,$3,$DF,$24,$48,$3,$90,$4,$68,$23
  DC.B $4B,$2,$93,$23,$48,$1,$90,$23,$49,$0,$91,$0,$20,$5,$DF         *164
  DC.B $0,$5D,$0,$60,$6,$1C,$A,$D1,$21,$48,$0,$88,$4,$28,$1,$D1,$64,$20,$0
  DC.B $E0,$5,$20,$3,$DF,$0,$20,$5,$DF,$6,$1C,$3,$98,$0,$68,$1,$1B
  DC.B $FF,$23,$F5,$33,$99,$42,$7,$D3,$0,$2D,$1,$D1,$1,$21,$0,$E0,$0
  DC.B $21,$D,$6,$2D,$E,$4,$1C,$30,$9,$4,$D3,$3,$21,$38,$68         *165
  DC.B $40,$5D,$0,$60,$4,$DF,$10,$20,$5,$DF,$70,$8,$A,$D3,$11,$4A,$B8,$69,$81
  DC.B $0,$2,$9B,$5A,$50,$1,$21,$F,$4A,$11,$54,$B,$21,$B8,$68,$4,$DF
  DC.B $B0,$9,$3,$D3,$1,$98,$0,$68,$7,$F0,$AE,$FB,$0,$99,$9,$68,$28
  DC.B $1C,$7,$F0,$AB,$FB,$C1,$E7,$A4,$28,$0,$40,$50,$0,$1,$0         *166
  DC.B $80,$5D,$0,$60,$B4,$53,$0,$40,$E8,$3A,$0,$60,$E4,$3A,$0,$60,$D8,$28,$0
  DC.B $40,$B1,$33,$0,$60,$DC,$53,$0,$40,$F0,$B5,$3,$27,$7F,$7,$94,$B0
  DC.B $0,$97,$B7,$49,$B7,$4A,$13,$92,$80,$32,$12,$92,$D1,$65,$B6,$49,$A
  DC.B $69,$0,$2A,$1,$D0,$48,$61,$0,$E0,$8,$61,$0,$27,$0,$23         *167
  DC.B $C0,$5D,$0,$60,$B2,$49,$11,$91,$3,$22,$FF,$21,$19,$20,$0,$26,$1,$31,$8
  DC.B $E0,$B,$AD,$EE,$54,$10,$3D,$EE,$54,$3,$AD,$EE,$54,$1,$33,$1B,$6
  DC.B $1B,$E,$E,$2B,$F4,$DB,$AA,$4A,$10,$92,$AA,$4D,$F,$95,$0,$20,$5
  DC.B $DF,$0,$28,$1,$D0,$2,$94,$C,$E0,$0,$2F,$3,$D1,$0,$23         *168
  DC.B $0,$5E,$0,$60,$2,$93,$D8,$43,$5,$E0,$20,$1C,$3,$DF,$3,$6,$1B,$E,$2
  DC.B $93,$0,$20,$5,$DF,$0,$28,$3E,$D0,$FF,$23,$1,$33,$98,$42,$37,$D0
  DC.B $20,$DC,$1,$28,$26,$D0,$2,$28,$2B,$D0,$4,$28,$33,$D1,$17,$20,$0
  DC.B $3,$41,$68,$38,$23,$DB,$43,$19,$40,$41,$60,$41,$68,$1,$23         *169
  DC.B $40,$5E,$0,$60,$9B,$3,$19,$43,$41,$60,$41,$68,$93,$4B,$19,$40,$41,$60,$1
  DC.B $68,$38,$23,$DB,$43,$19,$40,$28,$23,$19,$43,$1,$60,$19,$20,$B,$AB
  DC.B $98,$70,$18,$E0,$1,$23,$9B,$2,$98,$42,$1A,$D0,$DB,$0,$98,$42,$11
  DC.B $D1,$4D,$E0,$A,$20,$11,$99,$48,$70,$3,$20,$B,$AB,$18,$70         *16a
  DC.B $80,$5E,$0,$60,$9,$E0,$A,$20,$10,$99,$48,$72,$3,$20,$B,$AB,$58,$70,$2
  DC.B $E0,$2,$20,$D,$AB,$18,$70,$2,$9B,$0,$2B,$5F,$D1,$0,$24,$1,$20
  DC.B $9C,$E0,$12,$9A,$1,$20,$91,$6A,$7,$F0,$10,$FB,$7B,$48,$19,$21,$9
  DC.B $3,$8,$60,$7,$23,$DB,$1,$13,$9A,$D0,$18,$37,$22,$52,$1         *16b
  DC.B $C0,$5E,$0,$60,$0,$21,$83,$6B,$0,$20,$7,$F0,$5,$FB,$96,$20,$3,$DF,$74
  DC.B $48,$10,$23,$DB,$43,$1,$68,$19,$40,$AA,$22,$1,$60,$0,$9F,$71,$4B
  DC.B $F9,$18,$4A,$75,$55,$22,$5B,$8,$0,$9F,$FB,$18,$9A,$72,$A0,$22,$4A
  DC.B $75,$FF,$21,$C3,$14,$0,$9F,$FA,$1A,$11,$70,$10,$23,$1,$68         *16c
  DC.B $0,$5F,$0,$60,$19,$43,$1,$60,$9B,$1,$0,$9F,$F8,$18,$0,$78,$FF,$28,$FD
  DC.B $D1,$FE,$E7,$1,$98,$38,$40,$5C,$D0,$1,$28,$D,$D0,$2,$28,$B,$D0
  DC.B $4,$28,$D,$D0,$FF,$23,$1,$33,$98,$42,$52,$D1,$A,$20,$D,$AB,$18
  DC.B $70,$0,$26,$F,$9D,$4A,$E0,$20,$1C,$1,$F0,$8D,$FE,$48,$E0         *16d
  DC.B $40,$5F,$0,$60,$19,$20,$B,$AB,$98,$70,$7,$A8,$0,$5D,$FF,$23,$58,$40,$18
  DC.B $40,$1,$1C,$7,$A8,$1,$55,$2,$D0,$1,$20,$1,$E0,$41,$E0,$0,$20
  DC.B $C0,$7,$0,$C,$17,$22,$12,$3,$11,$68,$4B,$4B,$19,$40,$8,$43,$10
  DC.B $60,$2E,$E0,$28,$68,$C2,$78,$81,$78,$8A,$42,$14,$D0,$C1,$78         *16e
  DC.B $80,$5F,$0,$60,$1,$31,$C1,$70,$28,$68,$41,$78,$3,$29,$4,$D0,$4,$29,$B
  DC.B $D1,$0,$21,$81,$72,$3,$E0,$1,$78,$1,$31,$81,$72,$1,$21,$28,$68
  DC.B $1,$71,$28,$68,$C1,$79,$81,$71,$28,$68,$1,$79,$1,$29,$1C,$D0,$2
  DC.B $29,$A,$D1,$81,$79,$C2,$79,$91,$42,$6,$D1,$0,$21,$41,$71         *16f
  DC.B $C0,$5F,$0,$60,$28,$68,$2,$79,$2,$2A,$0,$D1,$1,$71,$4,$35,$1,$36,$10
  DC.B $2E,$D0,$D3,$60,$1C,$4,$6,$24,$E,$1,$98,$40,$0,$1,$90,$E,$2C
  DC.B $97,$DB,$0,$20,$FF,$24,$1,$21,$2F,$E0,$81,$7A,$1,$39,$81,$72,$28
  DC.B $68,$81,$7A,$0,$29,$E8,$D1,$2,$21,$1,$71,$1,$21,$28,$68         *170
  DC.B $0,$60,$0,$60,$41,$71,$28,$68,$81,$79,$1,$31,$81,$71,$28,$68,$41,$7A,$0
  DC.B $7A,$4,$DF,$DA,$E7,$2,$9B,$0,$2B,$C,$D0,$3A,$1C,$A,$40,$3,$D1
  DC.B $B,$AA,$12,$5C,$0,$2A,$5,$DD,$B,$AA,$12,$5C,$2,$9B,$D3,$18,$B
  DC.B $AA,$13,$54,$B,$AA,$12,$5C,$0,$2A,$2,$D0,$A2,$42,$0,$DA         *171
  DC.B $40,$60,$0,$60,$14,$1C,$1,$30,$0,$6,$0,$E,$49,$0,$E,$28,$E2,$DB,$0
  DC.B $27,$FF,$2C,$0,$D1,$CB,$E6,$0,$20,$1,$21,$D,$E0,$B,$AA,$12,$5C
  DC.B $A2,$42,$0,$D1,$F,$43,$A2,$42,$2,$DB,$13,$1B,$B,$AA,$13,$54,$1
  DC.B $30,$0,$6,$0,$E,$49,$0,$E,$28,$EF,$DB,$B7,$E6,$0,$0         *172
  DC.B $80,$60,$0,$60,$21,$A,$0,$40,$AC,$1,$1,$0,$A4,$28,$0,$40,$70,$56,$0
  DC.B $40,$50,$57,$0,$40,$F8,$28,$0,$40,$FF,$7F,$FF,$FF,$0,$80,$1A,$86
  DC.B $C,$80,$0,$E0,$40,$55,$0,$0,$B0,$B4,$7,$1C,$6,$DF,$0,$6,$0
  DC.B $E,$8,$49,$84,$0,$8,$4A,$11,$51,$8,$4D,$2F,$51,$1,$21         *173
  DC.B $C0,$60,$0,$60,$7,$4A,$11,$54,$7,$48,$80,$68,$B,$21,$4,$DF,$28,$59,$B0
  DC.B $BC,$70,$47,$0,$0,$D9,$1D,$0,$0,$B4,$53,$0,$40,$8C,$53,$0,$40
  DC.B $DC,$53,$0,$40,$A4,$28,$0,$40,$80,$B4,$7,$6,$3F,$E,$5,$4A,$51
  DC.B $68,$88,$7A,$43,$1C,$8B,$72,$51,$68,$40,$18,$C7,$72,$80,$BC         *174
  DC.B $0,$61,$0,$60,$70,$47,$0,$0,$E8,$28,$0,$40,$F0,$B5,$7,$1C,$4D,$4E,$4E
  DC.B $4D,$4E,$4C,$8D,$E0,$4E,$49,$9,$78,$CA,$7,$D2,$F,$3,$D1,$4D,$4B
  DC.B $19,$78,$5,$29,$4C,$DA,$4C,$4B,$19,$78,$49,$8,$19,$70,$0,$2A,$F
  DC.B $D0,$49,$4A,$11,$78,$80,$23,$19,$43,$11,$70,$47,$49,$A,$88         *175
  DC.B $40,$61,$0,$60,$1,$23,$5A,$40,$A,$80,$43,$4A,$11,$78,$8,$29,$4,$DA,$1
  DC.B $31,$1,$E0,$0,$21,$3F,$4A,$11,$70,$40,$49,$A,$88,$53,$8,$5,$D3
  DC.B $52,$8,$A,$80,$A,$88,$3E,$4B,$5A,$40,$0,$E0,$52,$8,$A,$80,$3C
  DC.B $4B,$1A,$78,$1,$32,$1A,$70,$1A,$78,$7,$2A,$53,$DD,$82,$8         *176
  DC.B $80,$61,$0,$60,$A,$D3,$2,$23,$DB,$43,$18,$40,$20,$60,$18,$C,$8,$80,$32
  DC.B $4A,$10,$78,$B1,$68,$7,$F0,$9A,$F9,$68,$68,$81,$7A,$FF,$29,$5,$DA
  DC.B $2D,$4A,$10,$78,$71,$68,$7,$F0,$91,$F9,$5,$E0,$0,$21,$81,$72,$3
  DC.B $23,$20,$68,$18,$43,$20,$60,$0,$21,$2A,$4B,$19,$70,$32,$E0         *177
  DC.B $C0,$61,$0,$60,$1A,$1C,$6,$29,$22,$D1,$80,$8,$20,$D2,$24,$49,$8,$88,$26
  DC.B $4B,$98,$42,$C,$D1,$68,$68,$81,$7A,$2,$39,$81,$72,$68,$68,$80,$7A
  DC.B $0,$28,$B,$DD,$21,$49,$8,$78,$1,$30,$8,$70,$6,$E0,$20,$49,$8
  DC.B $78,$1,$30,$8,$70,$0,$21,$68,$68,$81,$72,$3,$23,$20,$68         *178
  DC.B $0,$62,$0,$60,$18,$43,$0,$21,$20,$60,$17,$48,$1,$70,$A,$E0,$7,$29,$8
  DC.B $DB,$0,$21,$14,$48,$1,$70,$68,$68,$81,$72,$3,$23,$20,$68,$18,$43
  DC.B $20,$60,$0,$21,$11,$70,$A,$49,$8,$78,$40,$8,$8,$70,$1,$3F,$0
  DC.B $2F,$3,$D0,$20,$68,$41,$8,$0,$D2,$6B,$E7,$38,$1C,$F0,$BC         *179
  DC.B $40,$62,$0,$60,$8,$BC,$18,$47,$AC,$3,$1,$0,$E8,$28,$0,$40,$90,$1,$1
  DC.B $0,$97,$1,$1,$0,$96,$1,$1,$0,$98,$1,$1,$0,$9A,$1,$1,$0
  DC.B $8,$84,$0,$0,$99,$1,$1,$0,$85,$4F,$0,$0,$89,$1,$1,$0,$8E
  DC.B $1,$1,$0,$F0,$B5,$2F,$4F,$0,$24,$78,$68,$0,$28,$7,$D1         *17a
  DC.B $80,$62,$0,$60,$FF,$F7,$DC,$FA,$0,$28,$45,$D0,$FF,$F7,$5D,$FA,$78,$60,$84
  DC.B $72,$29,$48,$6,$78,$29,$4D,$2A,$4C,$3F,$E0,$3A,$7A,$0,$2A,$F,$D1
  DC.B $4A,$1C,$2,$80,$27,$4A,$51,$5C,$27,$4A,$11,$70,$0,$23,$C1,$5E,$FF
  DC.B $23,$81,$33,$99,$42,$1,$D3,$0,$21,$1,$80,$8,$20,$38,$72         *17b
  DC.B $C0,$62,$0,$60,$20,$68,$40,$8,$2,$D3,$38,$7A,$E9,$68,$1,$E0,$38,$7A,$29
  DC.B $69,$7,$F0,$FC,$F8,$38,$72,$18,$48,$0,$78,$86,$42,$1D,$D0,$78,$68
  DC.B $81,$7A,$C1,$71,$78,$68,$C1,$7A,$1,$72,$78,$68,$1,$7B,$41,$72,$2
  DC.B $20,$79,$68,$88,$72,$7A,$68,$14,$49,$1,$20,$FF,$F7,$40,$FA         *17c
  DC.B $0,$63,$0,$60,$13,$48,$1,$78,$1,$31,$1,$70,$0,$21,$79,$60,$3,$23,$20
  DC.B $68,$18,$43,$20,$60,$F0,$BC,$8,$BC,$18,$47,$E,$48,$0,$23,$C2,$5E
  DC.B $D,$48,$C1,$5E,$8A,$42,$B8,$D1,$3A,$7A,$0,$2A,$B5,$D1,$F0,$BC,$8
  DC.B $BC,$18,$47,$E8,$28,$0,$40,$89,$1,$1,$0,$AC,$3,$1,$0         *17d
  DC.B $40,$63,$0,$60,$90,$1,$1,$0,$A8,$6,$1,$0,$97,$1,$1,$0,$D8,$3B,$0
  DC.B $40,$F4,$28,$0,$40,$7C,$1,$1,$0,$7E,$1,$1,$0,$F0,$B5,$1,$25
  DC.B $83,$B0,$4B,$48,$2,$90,$4B,$4F,$8A,$E0,$2,$98,$FF,$F7,$34,$FA,$4
  DC.B $1C,$5E,$D0,$48,$49,$8,$78,$0,$90,$0,$20,$79,$6A,$7,$F0         *17e
  DC.B $80,$63,$0,$60,$A5,$F8,$5,$40,$45,$48,$46,$49,$8,$80,$0,$20,$45,$49,$8
  DC.B $70,$45,$49,$8,$70,$45,$49,$8,$70,$20,$7A,$B9,$69,$7,$F0,$96,$F8
  DC.B $20,$7A,$F9,$69,$7,$F0,$92,$F8,$5,$40,$60,$7A,$B9,$69,$7,$F0,$8D
  DC.B $F8,$60,$7A,$F9,$69,$7,$F0,$89,$F8,$28,$40,$0,$25,$6,$1C         *17f
  DC.B $C0,$63,$0,$60,$C,$E0,$60,$19,$1,$90,$C0,$7A,$B9,$69,$7,$F0,$7F,$F8,$1
  DC.B $98,$C0,$7A,$F9,$69,$7,$F0,$7A,$F8,$6,$40,$1,$35,$E0,$79,$A8,$42
  DC.B $EF,$DC,$2F,$4D,$28,$88,$C0,$43,$F9,$69,$7,$F0,$6F,$F8,$6,$40,$28
  DC.B $88,$0,$A,$C0,$43,$F9,$69,$7,$F0,$68,$F8,$30,$40,$5,$1C         *180
  DC.B $0,$64,$0,$60,$60,$7A,$2F,$28,$2,$D1,$7E,$21,$29,$48,$41,$70,$7E,$21,$28
  DC.B $48,$41,$70,$0,$26,$26,$49,$8,$88,$40,$8,$8,$80,$38,$6A,$7,$F0
  DC.B $53,$F8,$5,$40,$1,$36,$8,$2E,$F4,$DB,$FF,$20,$20,$4E,$70,$70,$7
  DC.B $E0,$28,$E0,$30,$88,$40,$8,$30,$80,$38,$6A,$7,$F0,$44,$F8         *181
  DC.B $40,$64,$0,$60,$5,$40,$19,$48,$0,$23,$C0,$56,$0,$28,$F3,$D1,$1,$2D,$F
  DC.B $D1,$14,$49,$9,$78,$17,$48,$0,$9A,$81,$54,$17,$48,$1,$78,$1,$31
  DC.B $1,$70,$A0,$79,$C0,$9,$B,$D2,$20,$1C,$FF,$F7,$FD,$F9,$7,$E0,$0
  DC.B $98,$9,$49,$8,$70,$0,$20,$2,$99,$22,$1C,$FF,$F7,$80,$F9         *182
  DC.B $80,$64,$0,$60,$1,$2D,$0,$D1,$71,$E7,$3,$B0,$F0,$BC,$8,$BC,$18,$47,$0
  DC.B $0,$B8,$3B,$0,$40,$AC,$3,$1,$0,$8B,$1,$1,$0,$FF,$FF,$0,$0
  DC.B $A2,$1,$1,$0,$9C,$1,$1,$0,$A0,$1,$1,$0,$A1,$1,$1,$0,$9E
  DC.B $1,$1,$0,$E8,$53,$0,$40,$DD,$0,$1,$0,$80,$B4,$7,$6         *183
  DC.B $C0,$64,$0,$60,$3F,$E,$B,$49,$A,$78,$B,$48,$0,$78,$10,$1A,$0,$D5,$80
  DC.B $30,$3,$1C,$0,$20,$7F,$2B,$8,$DA,$53,$1C,$B,$70,$6,$4B,$9F,$54
  DC.B $A,$78,$80,$2A,$0,$DB,$8,$70,$1,$20,$80,$BC,$70,$47,$0,$0,$8B
  DC.B $1,$1,$0,$8C,$1,$1,$0,$E8,$53,$0,$40,$90,$B5,$C,$1C         *184
  DC.B $0,$65,$0,$60,$7,$1C,$2,$DF,$0,$20,$0,$2F,$3,$D0,$B,$49,$8,$70,$B
  DC.B $49,$8,$70,$0,$2C,$C,$D0,$A,$49,$8,$70,$A,$49,$8,$70,$A,$4F
  DC.B $1,$E0,$FF,$F7,$A1,$F9,$38,$1C,$FF,$F7,$56,$F9,$0,$28,$F8,$D1,$1
  DC.B $DF,$90,$BC,$8,$BC,$18,$47,$95,$1,$1,$0,$94,$1,$1,$0         *185
  DC.B $40,$65,$0,$60,$8C,$1,$1,$0,$8B,$1,$1,$0,$B8,$3B,$0,$40,$80,$B5,$13
  DC.B $4F,$1,$E0,$FF,$F7,$89,$F9,$38,$1C,$FF,$F7,$3E,$F9,$0,$28,$F8,$D1
  DC.B $F,$4F,$1,$E0,$FF,$F7,$80,$F9,$38,$1C,$FF,$F7,$35,$F9,$0,$28,$F8
  DC.B $D1,$C,$4F,$1,$E0,$FF,$F7,$77,$F9,$38,$1C,$FF,$F7,$2C,$F9         *186
  DC.B $80,$65,$0,$60,$0,$28,$F8,$D1,$8,$4F,$1,$E0,$FF,$F7,$6E,$F9,$38,$1C,$FF
  DC.B $F7,$23,$F9,$0,$28,$F8,$D1,$80,$BC,$8,$BC,$18,$47,$B8,$3B,$0,$40
  DC.B $C8,$3B,$0,$40,$D8,$3B,$0,$40,$E8,$3B,$0,$40,$80,$B5,$6,$4F,$1
  DC.B $E0,$0,$F0,$53,$F8,$38,$1C,$FF,$F7,$E,$F9,$0,$28,$F8,$D1         *187
  DC.B $C0,$65,$0,$60,$80,$BC,$8,$BC,$18,$47,$0,$0,$D8,$3B,$0,$40,$F0,$B5,$21
  DC.B $4F,$0,$24,$0,$26,$3D,$1C,$F8,$1D,$39,$30,$41,$7C,$1,$29,$A,$D1
  DC.B $46,$74,$F8,$1D,$19,$30,$80,$78,$1,$28,$1,$D0,$2,$28,$2,$D1,$38
  DC.B $1C,$0,$F0,$D5,$F8,$1,$34,$54,$37,$6,$2C,$EB,$DB,$0,$24         *188
  DC.B $0,$66,$0,$60,$0,$27,$B,$20,$78,$43,$40,$19,$41,$7C,$C,$30,$0,$29,$A
  DC.B $D0,$81,$79,$C0,$79,$81,$42,$6,$D0,$0,$2F,$D,$D0,$1,$2F,$2,$D1
  DC.B $28,$1C,$0,$F0,$24,$FB,$1,$37,$2,$2F,$EA,$DB,$1,$34,$54,$35,$6
  DC.B $2C,$E5,$DB,$8,$4F,$5,$E0,$28,$1C,$0,$F0,$FA,$FA,$F2,$E7         *189
  DC.B $40,$66,$0,$60,$0,$F0,$6F,$F9,$38,$1C,$FF,$F7,$C7,$F8,$0,$28,$F8,$D1,$F0
  DC.B $BC,$8,$BC,$18,$47,$68,$54,$0,$40,$C8,$3B,$0,$40,$F0,$B5,$44,$7A
  DC.B $1,$26,$7,$1C,$0,$7A,$80,$8,$1F,$28,$2,$D1,$0,$F0,$80,$F8,$9
  DC.B $E0,$0,$F0,$41,$FB,$78,$71,$FF,$28,$4,$D0,$78,$79,$0,$F0         *18a
  DC.B $80,$66,$0,$60,$0,$FB,$5,$1C,$5,$D1,$38,$1C,$FF,$F7,$EE,$F8,$F0,$BC,$8
  DC.B $BC,$18,$47,$1,$20,$E9,$1D,$39,$31,$48,$74,$F8,$79,$2,$28,$36,$DB
  DC.B $10,$21,$C9,$43,$21,$40,$63,$29,$2B,$D0,$2F,$29,$29,$D0,$E8,$1D,$19
  DC.B $30,$80,$78,$0,$28,$2A,$D0,$20,$1C,$29,$1C,$0,$F0,$8D,$F9         *18b
  DC.B $C0,$66,$0,$60,$4,$1C,$87,$28,$24,$D0,$E4,$6,$E4,$E,$60,$8,$15,$D2,$60
  DC.B $9,$1D,$D2,$20,$1C,$29,$1C,$0,$F0,$E1,$F9,$4,$1C,$8B,$28,$17,$D0
  DC.B $3A,$1C,$11,$49,$1,$20,$FF,$F7,$4B,$F8,$10,$48,$1,$78,$1,$31,$1
  DC.B $70,$F1,$23,$1C,$40,$0,$26,$A,$E0,$F8,$79,$2,$28,$7,$D0         *18c
  DC.B $0,$67,$0,$60,$5,$E0,$2F,$29,$1,$D0,$63,$2C,$1,$D1,$2,$28,$0,$D0,$93
  DC.B $24,$1,$2E,$2,$D1,$38,$1C,$FF,$F7,$A7,$F8,$20,$1C,$29,$1C,$0,$F0
  DC.B $57,$F8,$F0,$BC,$8,$BC,$18,$47,$E8,$3B,$0,$40,$48,$29,$0,$40,$0
  DC.B $B5,$0,$21,$D,$4A,$14,$E0,$54,$20,$48,$43,$80,$18,$43,$79         *18d
  DC.B $40,$67,$0,$60,$0,$2B,$B,$D0,$C3,$1D,$19,$33,$9B,$78,$0,$2B,$6,$D1,$83
  DC.B $79,$1E,$2B,$3,$D1,$0,$F0,$1A,$FB,$8,$BC,$18,$47,$48,$1C,$1,$6
  DC.B $9,$E,$6,$29,$E8,$DB,$8,$BC,$18,$47,$0,$0,$68,$54,$0,$40,$80
  DC.B $B5,$0,$20,$9,$49,$1E,$22,$9,$E0,$54,$23,$43,$43,$5B,$18         *18e
  DC.B $80,$67,$0,$60,$9F,$79,$1F,$2F,$0,$D1,$9A,$71,$1,$30,$0,$6,$0,$E,$6
  DC.B $28,$F3,$DB,$FF,$F7,$CD,$FF,$80,$BC,$8,$BC,$18,$47,$68,$54,$0,$40
  DC.B $80,$B5,$7,$1C,$8,$E0,$38,$79,$39,$1C,$0,$F0,$84,$F9,$38,$79,$1
  DC.B $30,$40,$7,$40,$F,$38,$71,$38,$79,$39,$78,$88,$42,$4,$D0         *18f
  DC.B $C0,$67,$0,$60,$38,$1C,$0,$F0,$F8,$F8,$0,$28,$ED,$D1,$80,$BC,$8,$BC,$18
  DC.B $47,$B0,$B5,$2,$6,$12,$E,$E,$20,$F,$1C,$39,$49,$1,$38,$0,$6
  DC.B $0,$E,$B,$5C,$93,$42,$1,$D0,$0,$28,$F7,$D1,$A,$23,$58,$43,$34
  DC.B $49,$45,$18,$FC,$1D,$19,$34,$A0,$78,$40,$0,$28,$18,$40,$78         *190
  DC.B $0,$68,$0,$60,$A,$28,$56,$D2,$1,$A3,$1B,$5C,$5B,$0,$9F,$44,$52,$4,$F
  DC.B $1B,$37,$2C,$2F,$32,$52,$3E,$38,$1C,$0,$F0,$B8,$FA,$38,$1C,$0,$F0
  DC.B $EB,$FA,$2F,$20,$39,$1C,$0,$F0,$4F,$F8,$42,$E0,$38,$1C,$0,$F0,$E3
  DC.B $FA,$38,$1C,$0,$F0,$C2,$FA,$38,$1C,$0,$F0,$ED,$F9,$63,$20         *191
  DC.B $40,$68,$0,$60,$39,$1C,$A,$E0,$38,$1C,$0,$F0,$D7,$FA,$38,$1C,$0,$F0,$B6
  DC.B $FA,$38,$1C,$0,$F0,$E1,$F9,$73,$20,$39,$1C,$0,$F0,$35,$F8,$38,$1C
  DC.B $0,$F0,$68,$FA,$25,$E0,$1,$20,$39,$1C,$4,$E0,$11,$20,$39,$1C,$1
  DC.B $E0,$9,$20,$39,$1C,$0,$F0,$3E,$F8,$1A,$E0,$38,$1C,$0,$F0         *192
  DC.B $80,$68,$0,$60,$32,$F9,$38,$1C,$0,$F0,$82,$FA,$13,$E0,$38,$1C,$0,$F0,$78
  DC.B $FA,$38,$1C,$0,$F0,$C1,$F9,$38,$1C,$0,$F0,$90,$FA,$38,$1C,$0,$F0
  DC.B $AB,$FA,$38,$1C,$0,$F0,$46,$FA,$B8,$79,$1E,$28,$1,$D0,$FF,$F7,$3F
  DC.B $FF,$A0,$78,$40,$0,$28,$5C,$A0,$70,$B0,$BC,$8,$BC,$18,$47         *193
  DC.B $C0,$68,$0,$60,$3C,$27,$0,$40,$4A,$27,$0,$40,$90,$B5,$4,$6,$24,$E,$F
  DC.B $1C,$FE,$F7,$39,$FF,$0,$28,$B,$D0,$1,$21,$1,$72,$2F,$2C,$1,$D1
  DC.B $3,$21,$1,$72,$44,$72,$2,$21,$C1,$71,$B9,$79,$0,$F0,$2C,$FA,$90
  DC.B $BC,$8,$BC,$18,$47,$90,$B5,$4,$6,$24,$E,$F,$1C,$FE,$F7         *194
  DC.B $0,$69,$0,$60,$22,$FF,$0,$28,$A,$D0,$1,$21,$1,$72,$79,$78,$49,$1,$21
  DC.B $43,$41,$72,$2,$21,$C1,$71,$B9,$79,$0,$F0,$16,$FA,$90,$BC,$8,$BC
  DC.B $18,$47,$B0,$B5,$7,$1C,$0,$79,$0,$F0,$AB,$F9,$4,$1C,$4,$D0,$E5
  DC.B $1D,$19,$35,$A8,$78,$0,$28,$5,$D1,$38,$1C,$FE,$F7,$94,$FF         *195
  DC.B $40,$69,$0,$60,$B0,$BC,$8,$BC,$18,$47,$B8,$79,$40,$23,$18,$43,$B8,$71,$3
  DC.B $20,$38,$72,$20,$78,$41,$1C,$49,$7,$49,$F,$A2,$78,$91,$42,$6,$D1
  DC.B $38,$1C,$21,$1C,$0,$F0,$30,$FA,$B0,$BC,$8,$BC,$18,$47,$80,$0,$0
  DC.B $19,$47,$62,$20,$1C,$0,$F0,$1E,$F8,$0,$28,$13,$D0,$A8,$78         *196
  DC.B $80,$69,$0,$60,$1,$28,$1,$D0,$2,$28,$E,$D1,$20,$78,$21,$1C,$0,$F0,$93
  DC.B $F8,$20,$78,$41,$1C,$49,$7,$49,$F,$21,$71,$A1,$78,$81,$42,$2,$D1
  DC.B $20,$1C,$0,$F0,$F3,$F9,$20,$78,$1,$30,$40,$7,$40,$F,$20,$70,$B0
  DC.B $BC,$8,$BC,$18,$47,$1,$79,$80,$78,$81,$42,$9,$DA,$8,$31         *197
  DC.B $C0,$69,$0,$60,$8,$1A,$3,$28,$1,$DA,$1,$20,$0,$E0,$0,$20,$0,$6,$0
  DC.B $E,$70,$47,$8,$1A,$3,$28,$F8,$DA,$F5,$E7,$F0,$B5,$5,$6,$2D,$E
  DC.B $6C,$9,$F,$1C,$89,$78,$38,$78,$81,$42,$50,$D0,$38,$1C,$0,$F0,$C7
  DC.B $F9,$B8,$78,$39,$78,$88,$42,$8,$DD,$8C,$42,$3,$DC,$E2,$1D         *198
  DC.B $0,$6A,$0,$60,$1,$32,$14,$6,$24,$E,$8,$31,$9,$6,$9,$E,$A,$1A,$3
  DC.B $2A,$2,$DD,$C1,$1C,$9,$6,$9,$E,$8C,$42,$3A,$DC,$A0,$42,$38,$DC
  DC.B $0,$26,$F,$E0,$40,$7,$40,$F,$80,$0,$C0,$19,$40,$6A,$FE,$F7,$1B
  DC.B $FF,$B8,$78,$41,$1C,$B9,$70,$40,$7,$40,$F,$80,$0,$C0,$19         *199
  DC.B $40,$6A,$0,$60,$46,$62,$FE,$70,$B8,$78,$A0,$42,$EC,$D1,$B8,$78,$40,$7,$40
  DC.B $F,$B8,$70,$B8,$78,$39,$78,$88,$42,$11,$D0,$38,$1C,$0,$F0,$96,$F9
  DC.B $D,$E0,$38,$1C,$0,$F0,$BB,$F9,$0,$28,$13,$D0,$39,$78,$89,$0,$C9
  DC.B $19,$48,$62,$38,$78,$1,$30,$40,$7,$40,$F,$38,$70,$38,$78         *19a
  DC.B $80,$6A,$0,$60,$1,$30,$40,$7,$40,$F,$B9,$78,$88,$42,$EA,$D1,$2,$E0,$84
  DC.B $42,$0,$D0,$87,$25,$28,$1C,$F0,$BC,$8,$BC,$18,$47,$0,$6,$0,$E
  DC.B $42,$8,$4B,$78,$93,$42,$4,$D1,$5A,$1C,$52,$7,$52,$F,$4A,$70,$70
  DC.B $47,$8B,$20,$70,$47,$B0,$B5,$5,$6,$2D,$E,$A8,$0,$40,$18         *19b
  DC.B $C0,$6A,$0,$60,$44,$6A,$F,$1C,$0,$2C,$B,$D0,$38,$1C,$0,$F0,$77,$F9,$78
  DC.B $78,$40,$1,$69,$0,$8,$43,$60,$72,$B9,$79,$20,$1C,$0,$F0,$34,$F9
  DC.B $B0,$BC,$8,$BC,$18,$47,$B0,$B5,$84,$78,$7,$1C,$11,$E0,$A0,$0,$C0
  DC.B $19,$45,$6A,$78,$78,$40,$1,$61,$0,$8,$43,$68,$72,$60,$1C         *19c
  DC.B $0,$6B,$0,$60,$44,$7,$64,$F,$38,$1C,$0,$F0,$59,$F9,$B9,$79,$28,$1C,$0
  DC.B $F0,$1B,$F9,$60,$7,$40,$F,$39,$78,$88,$42,$3,$D0,$B8,$78,$20,$1A
  DC.B $3,$28,$E4,$D1,$F8,$78,$1,$30,$F8,$70,$B0,$BC,$8,$BC,$18,$47,$F0
  DC.B $B5,$5,$6,$2D,$E,$E,$6,$36,$E,$28,$1C,$17,$1C,$0,$F0         *19d
  DC.B $40,$6B,$0,$60,$53,$F8,$28,$1C,$0,$F0,$B8,$F8,$4,$1C,$23,$D0,$A7,$60,$A6
  DC.B $71,$0,$20,$4,$21,$9,$E0,$B,$22,$42,$43,$12,$19,$51,$73,$93,$7B
  DC.B $1,$33,$93,$73,$1,$30,$0,$6,$0,$E,$2,$28,$F3,$DB,$20,$1C,$0
  DC.B $F0,$52,$F8,$0,$20,$E1,$1D,$19,$31,$88,$70,$1,$20,$E1,$1D         *19e
  DC.B $80,$6B,$0,$60,$39,$31,$48,$74,$20,$1C,$0,$F0,$37,$F9,$A0,$79,$1F,$28,$4
  DC.B $D1,$FF,$F7,$CE,$FD,$F0,$BC,$8,$BC,$18,$47,$1E,$28,$3,$D0,$20,$1C
  DC.B $0,$F0,$F4,$F8,$F4,$E7,$0,$20,$E,$49,$11,$E0,$54,$22,$42,$43,$52
  DC.B $18,$53,$79,$0,$2B,$8,$D0,$AB,$42,$6,$D0,$93,$79,$1E,$2B         *19f
  DC.B $C0,$6B,$0,$60,$3,$D1,$20,$32,$92,$78,$0,$2A,$4,$D0,$1,$30,$0,$6,$0
  DC.B $E,$6,$28,$EB,$DB,$6,$28,$DD,$D1,$20,$1C,$0,$F0,$D7,$F8,$F0,$BC
  DC.B $8,$BC,$18,$47,$68,$54,$0,$40,$80,$B5,$0,$6,$0,$E,$0,$F0,$63
  DC.B $F8,$7,$1C,$D,$D0,$38,$1C,$0,$F0,$C2,$F8,$38,$1C,$0,$F0         *1a0
  DC.B $0,$6C,$0,$60,$DD,$F8,$38,$1C,$0,$F0,$8,$F8,$0,$20,$F9,$1D,$19,$31,$88
  DC.B $70,$78,$71,$80,$BC,$8,$BC,$18,$47,$80,$B5,$7,$1C,$0,$F0,$E8,$F9
  DC.B $0,$20,$38,$70,$78,$70,$B8,$70,$38,$71,$F8,$70,$80,$BC,$8,$BC,$18
  DC.B $47,$0,$B5,$1,$7C,$0,$29,$11,$D0,$C1,$7C,$1,$31,$C1,$74         *1a1
  DC.B $40,$6C,$0,$60,$C1,$1D,$19,$31,$89,$78,$0,$29,$B,$D0,$C1,$78,$3,$29,$2
  DC.B $DB,$1,$1C,$C3,$20,$1,$E0,$1,$1C,$A3,$20,$FF,$F7,$B9,$FD,$8,$BC
  DC.B $18,$47,$C1,$78,$4A,$1C,$C2,$70,$A,$29,$F1,$DA,$F3,$E7,$0,$B5,$81
  DC.B $7F,$1,$31,$81,$77,$1,$1C,$1,$20,$FF,$F7,$3C,$FE,$8,$BC         *1a2
  DC.B $80,$6C,$0,$60,$18,$47,$80,$B4,$2,$6,$12,$E,$0,$20,$0,$2A,$10,$D0,$0
  DC.B $21,$8,$4F,$8,$E0,$54,$20,$48,$43,$C0,$19,$43,$79,$93,$42,$4,$D0
  DC.B $1,$31,$9,$6,$9,$E,$6,$29,$F4,$DB,$6,$29,$0,$D1,$0,$20,$80
  DC.B $BC,$70,$47,$68,$54,$0,$40,$80,$B4,$2,$6,$12,$E,$0,$20         *1a3
  DC.B $C0,$6C,$0,$60,$0,$2A,$14,$D0,$0,$21,$B,$4F,$C,$E0,$54,$20,$48,$43,$C0
  DC.B $19,$43,$79,$93,$42,$1,$D0,$0,$2B,$1,$D1,$42,$71,$4,$E0,$1,$31
  DC.B $9,$6,$9,$E,$6,$29,$F0,$DB,$6,$29,$0,$D1,$0,$20,$80,$BC,$70
  DC.B $47,$0,$0,$68,$54,$0,$40,$80,$B4,$2,$6,$12,$E,$0,$20         *1a4
  DC.B $0,$6D,$0,$60,$B,$49,$B,$E0,$54,$23,$43,$43,$5B,$18,$5F,$79,$0,$2F,$2
  DC.B $D0,$9F,$79,$97,$42,$4,$D0,$1,$30,$0,$6,$0,$E,$6,$28,$F1,$DB
  DC.B $6,$28,$2,$D1,$FF,$20,$80,$BC,$70,$47,$58,$79,$80,$BC,$70,$47,$68
  DC.B $54,$0,$40,$0,$B5,$81,$68,$0,$29,$2,$D0,$40,$79,$6,$F0         *1a5
  DC.B $40,$6D,$0,$60,$C5,$FB,$8,$BC,$18,$47,$70,$47,$0,$B5,$9,$6,$9,$E,$0
  DC.B $22,$42,$71,$2,$7A,$92,$7,$92,$F,$89,$0,$11,$43,$1,$72,$1,$21
  DC.B $1,$71,$5,$49,$A,$78,$1,$32,$A,$70,$4,$49,$2,$1C,$1,$20,$FE
  DC.B $F7,$6,$FD,$8,$BC,$18,$47,$EA,$28,$0,$40,$B8,$3B,$0,$40         *1a6
  DC.B $80,$6D,$0,$60,$4,$21,$41,$73,$81,$7B,$1,$31,$81,$73,$70,$47,$0,$B5,$3C
  DC.B $21,$C,$30,$0,$F0,$9,$F8,$8,$BC,$18,$47,$0,$B5,$9,$21,$17,$30
  DC.B $0,$F0,$2,$F8,$8,$BC,$18,$47,$1,$70,$3,$21,$41,$70,$81,$78,$C2
  DC.B $78,$91,$42,$1,$D1,$1,$31,$81,$70,$70,$47,$4,$21,$1,$76         *1a7
  DC.B $C0,$6D,$0,$60,$41,$7E,$1,$31,$41,$76,$70,$47,$8A,$6C,$0,$2A,$1,$D1,$88
  DC.B $64,$1,$E0,$CA,$6C,$10,$60,$C8,$64,$0,$21,$1,$60,$70,$47,$1,$1C
  DC.B $80,$6C,$0,$22,$0,$28,$1,$D1,$10,$1C,$70,$47,$3,$68,$8B,$64,$0
  DC.B $2B,$FA,$D1,$CA,$64,$70,$47,$80,$B5,$7,$1C,$0,$F0,$F8,$F8         *1a8
  DC.B $0,$6E,$0,$60,$78,$79,$1,$28,$1,$D1,$FF,$F7,$A1,$FB,$80,$BC,$8,$BC,$18
  DC.B $47,$80,$B5,$0,$20,$2,$27,$B,$4A,$B,$49,$9,$68,$8,$E0,$54,$23
  DC.B $43,$43,$9B,$18,$19,$75,$D9,$77,$5F,$75,$20,$33,$1F,$70,$1,$30,$6
  DC.B $28,$F4,$DB,$5,$4A,$0,$21,$1,$20,$FF,$F7,$79,$FE,$80,$BC         *1a9
  DC.B $40,$6E,$0,$60,$8,$BC,$18,$47,$68,$54,$0,$40,$A8,$28,$0,$40,$F5,$1A,$0
  DC.B $40,$F0,$B5,$84,$B0,$5A,$4E,$F7,$1D,$39,$37,$38,$7B,$0,$28,$4,$D1
  DC.B $58,$48,$0,$68,$6,$F0,$30,$FB,$38,$73,$17,$20,$0,$3,$80,$68,$C0
  DC.B $9,$1,$D2,$1,$25,$0,$E0,$0,$25,$F8,$7B,$52,$4C,$53,$49         *1aa
  DC.B $80,$6E,$0,$60,$3,$91,$A8,$42,$2C,$D0,$FD,$73,$20,$68,$40,$6,$0,$F,$6
  DC.B $28,$26,$D1,$3,$99,$80,$31,$2,$91,$48,$6F,$6,$F0,$15,$FB,$2,$99
  DC.B $9,$6F,$6,$F0,$13,$FB,$0,$2D,$11,$D1,$49,$48,$1,$68,$0,$20,$6
  DC.B $F0,$C,$FB,$0,$20,$47,$49,$8,$80,$2,$99,$C8,$68,$6,$F0         *1ab
  DC.B $C0,$6E,$0,$60,$3,$FB,$11,$20,$0,$3,$1,$6A,$6B,$1F,$19,$40,$1,$62,$0
  DC.B $2D,$6,$D0,$1,$21,$B9,$73,$2,$20,$3E,$4A,$10,$80,$3E,$48,$1,$80
  DC.B $17,$20,$0,$3,$80,$68,$40,$C,$1,$D2,$1,$25,$0,$E0,$0,$25,$38
  DC.B $7B,$F,$28,$60,$D0,$D,$28,$2A,$D1,$0,$2D,$12,$D0,$78,$7B         *1ac
  DC.B $0,$6F,$0,$60,$1,$28,$25,$D0,$0,$F0,$9A,$FA,$34,$4A,$1E,$21,$2,$20,$FF
  DC.B $F7,$F,$FE,$1,$21,$79,$73,$20,$68,$31,$4B,$18,$40,$D,$23,$DB,$1
  DC.B $18,$43,$14,$E0,$78,$7B,$1,$28,$12,$D1,$2,$20,$FF,$F7,$5C,$FE,$0
  DC.B $20,$78,$73,$3,$99,$C8,$1D,$F9,$30,$0,$6A,$6,$F0,$C4,$FA         *1ad
  DC.B $40,$6F,$0,$60,$21,$68,$27,$4B,$19,$40,$0,$7,$0,$F,$C0,$1,$8,$43,$20
  DC.B $60,$0,$27,$24,$4C,$0,$2D,$19,$D0,$23,$48,$C0,$5D,$0,$28,$15,$D0
  DC.B $E8,$20,$78,$43,$1,$90,$20,$5C,$3,$28,$22,$D0,$0,$2F,$1,$D1,$3
  DC.B $20,$0,$E0,$4,$20,$1D,$4A,$1E,$21,$FF,$F7,$D9,$FD,$3,$21         *1ae
  DC.B $80,$6F,$0,$60,$1,$98,$21,$54,$70,$6C,$1,$30,$70,$64,$12,$E0,$E8,$21,$79
  DC.B $43,$0,$91,$60,$5C,$0,$28,$C,$D1,$0,$2F,$1,$D1,$3,$20,$0,$E0
  DC.B $4,$20,$FF,$F7,$21,$FE,$0,$20,$0,$99,$60,$54,$B0,$6C,$1,$30,$B0
  DC.B $64,$1,$37,$2,$2F,$CD,$DB,$4,$B0,$F0,$BC,$8,$BC,$18,$47         *1af
  DC.B $C0,$6F,$0,$60,$F4,$28,$0,$40,$F8,$3A,$0,$60,$3C,$0,$1,$0,$AC,$1,$1
  DC.B $0,$E0,$3A,$0,$60,$D8,$28,$0,$40,$DA,$28,$0,$40,$51,$1E,$0,$40
  DC.B $7F,$F8,$FF,$FF,$70,$56,$0,$40,$64,$29,$0,$40,$C9,$22,$0,$40,$F0
  DC.B $B5,$0,$24,$0,$26,$7,$1C,$A,$E0,$A0,$0,$C5,$19,$68,$6A         *1b0
  DC.B $0,$70,$0,$60,$0,$28,$2,$D0,$FE,$F7,$30,$FC,$6E,$62,$60,$1C,$4,$6,$24
  DC.B $E,$8,$2C,$F2,$DB,$1,$E0,$FE,$F7,$27,$FC,$38,$1C,$FF,$F7,$DF,$FE
  DC.B $0,$28,$F8,$D1,$F0,$BC,$8,$BC,$18,$47,$0,$0,$4,$4A,$11,$68,$88
  DC.B $7A,$43,$1C,$8B,$72,$11,$68,$40,$18,$C0,$7A,$70,$47,$0,$0         *1b1
  DC.B $40,$70,$0,$60,$44,$29,$0,$40,$2,$48,$0,$68,$C1,$79,$80,$7A,$8,$1A,$70
  DC.B $47,$44,$29,$0,$40,$F0,$B5,$82,$B0,$29,$4F,$38,$78,$0,$28,$4A,$D1
  DC.B $0,$26,$28,$4D,$28,$4C,$26,$E0,$25,$4F,$3E,$70,$28,$68,$6,$F0,$2B
  DC.B $FA,$38,$78,$0,$28,$2,$D1,$24,$4F,$2,$25,$20,$E0,$FE,$F7         *1b2
  DC.B $80,$70,$0,$60,$62,$FB,$39,$78,$C1,$71,$1,$21,$1,$71,$3B,$1C,$20,$4F,$19
  DC.B $78,$1,$39,$19,$70,$19,$78,$7A,$18,$92,$78,$41,$18,$CA,$72,$19,$78
  DC.B $0,$29,$F4,$DC,$2,$1C,$1,$20,$21,$1C,$FE,$F7,$69,$FB,$17,$49,$8
  DC.B $78,$1,$30,$8,$70,$FE,$F7,$C1,$FB,$0,$28,$D4,$D1,$DB,$E7         *1b3
  DC.B $C0,$70,$0,$60,$FE,$F7,$BC,$FB,$0,$28,$16,$D0,$69,$46,$1,$A8,$0,$F0,$DE
  DC.B $FA,$0,$28,$10,$D0,$FE,$F7,$37,$FB,$C5,$71,$1,$99,$1,$71,$C5,$72
  DC.B $0,$99,$1,$73,$2,$1C,$1,$20,$21,$1C,$FE,$F7,$49,$FB,$38,$78,$1
  DC.B $30,$38,$70,$E4,$E7,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0         *1b4
  DC.B $0,$71,$0,$60,$C4,$0,$1,$0,$D0,$3A,$0,$60,$C8,$3B,$0,$40,$F6,$28,$0
  DC.B $40,$EC,$5,$1,$0,$F0,$B5,$81,$B0,$14,$4E,$15,$4D,$15,$4C,$16,$49
  DC.B $0,$91,$1A,$E0,$0,$99,$F,$60,$78,$79,$1,$28,$8,$D0,$2,$28,$E
  DC.B $D0,$3,$28,$1,$D0,$4,$28,$C,$D1,$0,$F0,$AD,$FB,$9,$E0         *1b5
  DC.B $40,$71,$0,$60,$1,$23,$20,$68,$18,$43,$20,$60,$30,$68,$6,$F0,$BD,$F9,$1
  DC.B $E0,$0,$F0,$3A,$F8,$38,$1C,$FE,$F7,$87,$FB,$28,$1C,$FE,$F7,$3C,$FB
  DC.B $7,$1C,$DF,$D1,$1,$B0,$F0,$BC,$8,$BC,$18,$47,$8C,$3A,$0,$60,$E8
  DC.B $3B,$0,$40,$3C,$0,$1,$0,$44,$29,$0,$40,$1,$20,$C,$49         *1b6
  DC.B $80,$71,$0,$60,$8,$70,$C,$48,$28,$23,$1,$68,$19,$43,$1,$60,$A,$48,$0
  DC.B $68,$C0,$2,$C0,$F,$81,$1,$9,$48,$0,$23,$C2,$56,$53,$1C,$3,$70
  DC.B $7,$48,$81,$54,$7,$48,$1,$78,$1,$31,$1,$70,$70,$47,$0,$0,$55
  DC.B $28,$0,$40,$BC,$0,$1,$0,$40,$0,$1,$0,$8C,$0,$1,$0         *1b7
  DC.B $C0,$71,$0,$60,$BC,$5,$1,$0,$6C,$29,$0,$40,$90,$B5,$1F,$4C,$1F,$4F,$2B
  DC.B $E0,$42,$1C,$8A,$72,$39,$68,$40,$18,$C0,$7A,$C0,$28,$18,$D0,$8,$DC
  DC.B $24,$28,$12,$D0,$26,$28,$D,$D0,$33,$28,$1B,$D1,$0,$F0,$DA,$F8,$1A
  DC.B $E0,$C7,$28,$10,$D0,$CF,$28,$11,$D0,$D0,$28,$12,$D1,$0,$F0         *1b8
  DC.B $0,$72,$0,$60,$73,$F8,$11,$E0,$0,$F0,$3E,$F8,$E,$E0,$0,$F0,$F5,$F8,$B
  DC.B $E0,$8,$20,$0,$F0,$45,$F9,$7,$E0,$0,$F0,$10,$F9,$4,$E0,$0,$F0
  DC.B $1B,$F9,$1,$E0,$0,$F0,$14,$F8,$38,$68,$C2,$79,$1,$1C,$80,$7A,$12
  DC.B $1A,$0,$2A,$3,$DD,$0,$23,$E2,$5E,$0,$2A,$C8,$D0,$0,$20         *1b9
  DC.B $40,$72,$0,$60,$20,$80,$90,$BC,$8,$BC,$18,$47,$4C,$29,$0,$40,$44,$29,$0
  DC.B $40,$80,$B5,$7,$6,$3F,$E,$1,$20,$8,$49,$8,$80,$FE,$F7,$73,$FA
  DC.B $C2,$21,$C1,$72,$7,$73,$2,$21,$1,$71,$C1,$71,$4,$49,$2,$1C,$1
  DC.B $20,$FE,$F7,$85,$FA,$80,$BC,$8,$BC,$18,$47,$4C,$29,$0,$40         *1ba
  DC.B $80,$72,$0,$60,$C8,$3B,$0,$40,$80,$B5,$16,$4A,$10,$68,$C3,$79,$1,$1C,$80
  DC.B $7A,$18,$1A,$2,$28,$5,$DA,$26,$20,$FF,$F7,$DA,$FF,$80,$BC,$8,$BC
  DC.B $18,$47,$10,$48,$3,$7A,$0,$2B,$F8,$D1,$1,$23,$43,$80,$3,$72,$8B
  DC.B $7A,$5F,$1C,$8F,$72,$11,$68,$5B,$18,$DB,$7A,$3,$71,$8B,$7A         *1bb
  DC.B $C0,$72,$0,$60,$5F,$1C,$8F,$72,$11,$68,$59,$18,$C9,$7A,$81,$71,$81,$79,$80
  DC.B $23,$DB,$43,$19,$40,$C1,$71,$0,$21,$41,$71,$80,$BC,$8,$BC,$18,$47
  DC.B $44,$29,$0,$40,$4C,$29,$0,$40,$B0,$B5,$0,$21,$2B,$48,$2,$68,$D7
  DC.B $79,$13,$1C,$92,$7A,$BF,$1A,$2,$2F,$1,$DA,$D0,$20,$3F,$E0         *1bc
  DC.B $0,$73,$0,$60,$57,$1C,$9F,$72,$3,$68,$D2,$18,$D7,$7A,$9A,$7A,$54,$1C,$9C
  DC.B $72,$3,$68,$D2,$18,$D2,$7A,$5,$2A,$7,$D0,$6,$2A,$5,$D0,$99,$7A
  DC.B $4C,$1C,$9C,$72,$3,$68,$C9,$18,$C9,$7A,$3,$68,$DD,$79,$1C,$1C,$9B
  DC.B $7A,$ED,$1A,$8D,$42,$E1,$DB,$3,$2F,$DF,$D1,$18,$4F,$3,$2A         *1bd
  DC.B $40,$73,$0,$60,$9,$D0,$4,$2A,$21,$D0,$5,$2A,$23,$D0,$6,$2A,$D6,$D1,$A
  DC.B $20,$F8,$72,$7,$20,$F,$E0,$2,$29,$11,$D1,$1,$2D,$F,$DD,$59,$1C
  DC.B $A1,$72,$1,$68,$5A,$18,$D2,$7A,$FA,$72,$8A,$7A,$53,$1C,$8B,$72,$0
  DC.B $68,$10,$18,$C0,$7A,$B8,$72,$B0,$BC,$8,$BC,$18,$47,$26,$20         *1be
  DC.B $80,$73,$0,$60,$FF,$F7,$66,$FF,$B0,$BC,$8,$BC,$18,$47,$0,$29,$B6,$D1,$1
  DC.B $20,$0,$E0,$0,$20,$38,$73,$B0,$BC,$8,$BC,$18,$47,$44,$29,$0,$40
  DC.B $4C,$29,$0,$40,$0,$B5,$12,$48,$1,$68,$CB,$79,$A,$1C,$89,$7A,$5B
  DC.B $1A,$1,$2B,$17,$DD,$4B,$1C,$93,$72,$2,$68,$89,$18,$C9,$7A         *1bf
  DC.B $C0,$73,$0,$60,$1E,$23,$19,$40,$16,$29,$E,$D1,$91,$7A,$4B,$1C,$93,$72,$0
  DC.B $68,$8,$18,$C0,$7A,$D,$28,$6,$D1,$0,$21,$6,$48,$1,$72,$1,$21
  DC.B $41,$80,$8,$BC,$18,$47,$33,$20,$FF,$F7,$32,$FF,$8,$BC,$18,$47,$44
  DC.B $29,$0,$40,$4C,$29,$0,$40,$0,$B5,$E,$4A,$10,$68,$C3,$79         *1c0
  DC.B $0,$74,$0,$60,$1,$1C,$80,$7A,$1B,$1A,$0,$2B,$F,$DD,$43,$1C,$8B,$72,$11
  DC.B $68,$40,$18,$C0,$7A,$1,$7,$9,$F,$0,$9,$0,$7,$0,$F,$6,$4A
  DC.B $12,$68,$6,$F0,$55,$F8,$8,$BC,$18,$47,$24,$20,$FF,$F7,$10,$FF,$8
  DC.B $BC,$18,$47,$44,$29,$0,$40,$D4,$3A,$0,$60,$1,$21,$5,$48         *1c1
  DC.B $40,$74,$0,$60,$1,$73,$7,$21,$81,$72,$A,$21,$C1,$72,$0,$21,$1,$72,$14
  DC.B $21,$81,$73,$70,$47,$4C,$29,$0,$40,$0,$B5,$E,$4A,$10,$68,$C3,$79
  DC.B $1,$1C,$80,$7A,$1B,$1A,$1,$2B,$4,$DA,$CF,$20,$FF,$F7,$F0,$FE,$8
  DC.B $BC,$18,$47,$43,$1C,$8B,$72,$11,$68,$40,$18,$C0,$7A,$C1,$6         *1c2
  DC.B $80,$74,$0,$60,$C9,$E,$5,$4A,$2,$20,$FF,$F7,$53,$FB,$1,$20,$3,$49,$48
  DC.B $73,$8,$BC,$18,$47,$44,$29,$0,$40,$51,$1E,$0,$40,$4C,$29,$0,$40
  DC.B $80,$B5,$7,$6,$3F,$E,$FE,$F7,$4E,$F9,$0,$28,$F,$D0,$C1,$21,$C1
  DC.B $72,$9E,$21,$1,$73,$47,$73,$0,$21,$81,$73,$4,$21,$C1,$71         *1c3
  DC.B $C0,$74,$0,$60,$2,$21,$1,$71,$3,$49,$2,$1C,$1,$20,$FE,$F7,$59,$F9,$80
  DC.B $BC,$8,$BC,$18,$47,$C8,$3B,$0,$40,$0,$B5,$1,$20,$FF,$F7,$E0,$FF
  DC.B $17,$20,$0,$3,$80,$68,$80,$13,$C0,$7,$C0,$F,$C0,$43,$6,$49,$8
  DC.B $74,$6,$48,$1,$78,$1,$31,$1,$70,$5,$48,$1,$78,$1,$31         *1c4
  DC.B $0,$75,$0,$60,$1,$70,$8,$BC,$18,$47,$0,$0,$4C,$29,$0,$40,$F6,$28,$0
  DC.B $40,$6C,$29,$0,$40,$F0,$B5,$17,$24,$24,$3,$A0,$68,$80,$13,$C0,$7
  DC.B $C0,$F,$4A,$4F,$78,$74,$F8,$7B,$2,$26,$0,$25,$1,$28,$F,$D0,$2
  DC.B $28,$16,$D0,$3,$28,$22,$D1,$78,$7C,$0,$28,$22,$D0,$79,$7A         *1c5
  DC.B $40,$75,$0,$60,$1,$31,$9,$6,$9,$E,$79,$72,$BA,$7A,$91,$42,$1A,$DD,$12
  DC.B $E0,$78,$7C,$0,$28,$27,$D1,$FE,$73,$0,$21,$2,$20,$0,$F0,$78,$F8
  DC.B $1F,$E0,$78,$7C,$0,$28,$1E,$D0,$38,$7B,$0,$28,$3,$D0,$3,$20,$F8
  DC.B $73,$7D,$72,$15,$E0,$40,$21,$2,$20,$0,$F0,$69,$F8,$1,$20         *1c6
  DC.B $80,$75,$0,$60,$F8,$73,$E,$E0,$0,$28,$E,$D1,$78,$7A,$F9,$7A,$88,$42,$7
  DC.B $DD,$16,$21,$2,$20,$0,$F0,$5C,$F8,$56,$21,$2,$20,$0,$F0,$58,$F8
  DC.B $FE,$73,$78,$7C,$38,$74,$2,$23,$F8,$5E,$0,$28,$12,$DD,$1,$38,$0
  DC.B $4,$0,$14,$78,$80,$D,$D1,$38,$7A,$0,$28,$D,$D1,$20,$68         *1c7
  DC.B $C0,$75,$0,$60,$38,$23,$DB,$43,$18,$40,$28,$23,$18,$43,$20,$60,$7D,$71,$0
  DC.B $20,$C0,$43,$78,$80,$F0,$BC,$8,$BC,$18,$47,$B9,$79,$80,$20,$8,$40
  DC.B $A,$D1,$FA,$79,$1,$3A,$12,$6,$12,$E,$FA,$71,$4,$D1,$7D,$71,$80
  DC.B $23,$DB,$43,$19,$40,$F9,$71,$7A,$79,$14,$21,$8,$2A,$18,$D0         *1c8
  DC.B $0,$76,$0,$60,$50,$1C,$78,$71,$80,$20,$D0,$40,$3A,$79,$10,$40,$6,$D0,$20
  DC.B $68,$38,$23,$DB,$43,$18,$40,$8,$23,$18,$43,$5,$E0,$20,$68,$38,$23
  DC.B $DB,$43,$18,$40,$28,$23,$18,$43,$20,$60,$79,$80,$F0,$BC,$8,$BC,$18
  DC.B $47,$0,$28,$0,$D1,$79,$80,$20,$68,$38,$23,$DB,$43,$18,$40         *1c9
  DC.B $40,$76,$0,$60,$28,$23,$18,$43,$20,$60,$F0,$BC,$8,$BC,$18,$47,$4C,$29,$0
  DC.B $40,$90,$B4,$2,$38,$7,$1,$3F,$1A,$9,$4A,$13,$5C,$FF,$18,$9,$4C
  DC.B $E1,$55,$59,$1C,$11,$54,$13,$5C,$0,$21,$F,$2B,$0,$DB,$11,$54,$5
  DC.B $48,$2,$7B,$1,$32,$2,$73,$8,$1C,$90,$BC,$70,$47,$0,$0         *1ca
  DC.B $80,$76,$0,$60,$69,$29,$0,$40,$40,$58,$0,$40,$60,$29,$0,$40,$B0,$B4,$0
  DC.B $22,$11,$4B,$12,$4F,$BC,$5C,$9D,$5C,$AC,$42,$11,$D0,$93,$1C,$3,$60
  DC.B $10,$1,$80,$1A,$BB,$5C,$C0,$18,$D,$4B,$18,$5C,$8,$60,$B8,$5C,$1
  DC.B $30,$B8,$54,$B8,$5C,$F,$28,$5,$DB,$0,$20,$B8,$54,$2,$E0         *1cb
  DC.B $C0,$76,$0,$60,$1,$32,$3,$2A,$E6,$DB,$3,$2A,$2,$DA,$1,$20,$B0,$BC,$70
  DC.B $47,$0,$20,$B0,$BC,$70,$47,$0,$0,$69,$29,$0,$40,$66,$29,$0,$40
  DC.B $40,$58,$0,$40,$80,$B5,$18,$48,$0,$68,$5,$F0,$ED,$FE,$17,$4F,$38
  DC.B $78,$3,$28,$D,$D1,$78,$69,$0,$28,$3,$D0,$0,$21,$0,$20         *1cc
  DC.B $0,$77,$0,$60,$0,$F0,$26,$F8,$B8,$69,$0,$28,$3,$D0,$1,$21,$0,$20,$0
  DC.B $F0,$1F,$F8,$F8,$1D,$D9,$30,$0,$7A,$3,$28,$11,$D1,$F8,$1D,$79,$30
  DC.B $C0,$6F,$0,$28,$3,$D0,$0,$21,$1,$20,$0,$F0,$11,$F8,$F8,$1D,$F9
  DC.B $30,$0,$68,$0,$28,$3,$D0,$1,$21,$1,$20,$0,$F0,$8,$F8         *1cd
  DC.B $40,$77,$0,$60,$80,$BC,$8,$BC,$18,$47,$0,$0,$A0,$3A,$0,$60,$70,$56,$0
  DC.B $40,$F0,$B4,$E8,$22,$42,$43,$81,$B0,$4D,$4B,$D6,$18,$8A,$0,$B3,$18
  DC.B $CA,$1,$B2,$18,$1,$24,$1F,$1D,$5D,$69,$E8,$23,$58,$43,$28,$32,$47
  DC.B $4B,$C0,$18,$89,$0,$40,$18,$14,$30,$0,$90,$66,$E0,$64,$0         *1ce
  DC.B $80,$77,$0,$60,$4,$32,$20,$1C,$28,$40,$FA,$D0,$A5,$43,$10,$68,$C0,$5,$0
  DC.B $F,$0,$28,$5B,$DD,$10,$68,$3F,$49,$1,$40,$FF,$23,$20,$38,$E1,$33
  DC.B $18,$40,$8,$43,$10,$60,$40,$9,$0,$7,$59,$D1,$10,$68,$C0,$6,$C0
  DC.B $E,$12,$28,$5B,$D2,$2,$A3,$1B,$5C,$5B,$0,$9F,$44,$0,$1C         *1cf
  DC.B $C0,$77,$0,$60,$9,$11,$5B,$27,$5B,$5B,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$47
  DC.B $5B,$60,$19,$E1,$43,$38,$68,$8,$40,$38,$60,$0,$98,$3,$68,$19,$40
  DC.B $5,$E0,$38,$68,$20,$43,$38,$60,$0,$98,$1,$68,$A1,$43,$1,$60,$41
  DC.B $E0,$38,$68,$20,$40,$4,$D0,$FF,$23,$E1,$33,$10,$68,$18,$43         *1d0
  DC.B $0,$78,$0,$60,$43,$E0,$10,$68,$23,$4B,$18,$40,$20,$23,$18,$43,$3D,$E0,$10
  DC.B $68,$20,$4B,$18,$40,$FF,$23,$41,$33,$18,$43,$36,$E0,$38,$68,$20,$40
  DC.B $7,$D0,$11,$68,$C8,$6,$C0,$E,$80,$0,$30,$18,$40,$68,$0,$7,$6
  DC.B $E0,$11,$68,$C8,$6,$C0,$E,$80,$0,$30,$18,$40,$68,$0,$6         *1d1
  DC.B $40,$78,$0,$60,$0,$F,$14,$4B,$19,$40,$40,$1,$8,$43,$1E,$E0,$13,$E0,$38
  DC.B $68,$20,$40,$6,$D0,$10,$68,$F,$4B,$18,$40,$60,$23,$18,$43,$14,$E0
  DC.B $9,$E0,$10,$68,$B,$4B,$18,$40,$40,$23,$18,$43,$D,$E0,$2,$E0,$38
  DC.B $68,$60,$40,$38,$60,$0,$2D,$83,$D1,$1,$B0,$F0,$BC,$70,$47         *1d2
  DC.B $80,$78,$0,$60,$10,$68,$4,$4B,$18,$40,$A0,$23,$18,$43,$10,$60,$F0,$E7,$0
  DC.B $0,$70,$56,$0,$40,$1F,$FE,$FF,$FF,$F0,$B5,$7,$1C,$1C,$4D,$1D,$4C
  DC.B $29,$E0,$A8,$6F,$5,$F0,$10,$FE,$C0,$28,$1C,$D0,$7,$DC,$19,$28,$D
  DC.B $D0,$1A,$28,$1B,$D1,$3,$2F,$11,$D1,$0,$20,$10,$E0,$C7,$28         *1d3
  DC.B $C0,$78,$0,$60,$19,$D0,$CF,$28,$13,$D1,$38,$1C,$0,$F0,$9C,$F8,$13,$E0,$3
  DC.B $2F,$1,$D1,$0,$20,$0,$E0,$1,$20,$0,$F0,$B4,$F8,$B,$E0,$1,$20
  DC.B $0,$F0,$3A,$F9,$7,$E0,$38,$1C,$0,$F0,$6E,$F8,$3,$E0,$38,$1C,$31
  DC.B $1C,$0,$F0,$11,$F8,$E8,$6F,$5,$F0,$E6,$FD,$0,$28,$2,$D9         *1d4
  DC.B $0,$79,$0,$60,$20,$68,$0,$28,$CD,$D0,$0,$20,$20,$60,$F0,$BC,$8,$BC,$18
  DC.B $47,$2C,$3,$1,$0,$60,$29,$0,$40,$90,$B5,$C,$6,$24,$E,$7,$1C
  DC.B $1,$20,$9,$49,$8,$60,$FD,$F7,$E,$FF,$C2,$21,$C1,$72,$4,$73,$7
  DC.B $71,$2,$21,$C1,$71,$5,$49,$2,$1C,$1,$20,$FD,$F7,$20,$FF         *1d5
  DC.B $40,$79,$0,$60,$90,$BC,$8,$BC,$18,$47,$0,$0,$60,$29,$0,$40,$C8,$3B,$0
  DC.B $40,$80,$B5,$7,$6,$3F,$E,$38,$1C,$0,$F0,$36,$F8,$A,$20,$3,$2F
  DC.B $1,$D1,$0,$21,$0,$E0,$1,$21,$E8,$23,$59,$43,$12,$4A,$89,$18,$48
  DC.B $70,$9,$20,$40,$3,$1,$6A,$49,$B,$49,$3,$5,$23,$5B,$2         *1d6
  DC.B $80,$79,$0,$60,$19,$43,$1,$62,$1,$6A,$1,$23,$5B,$3,$19,$43,$1,$62,$17
  DC.B $20,$0,$3,$41,$68,$9,$4B,$19,$40,$41,$60,$1,$68,$DB,$43,$19,$43
  DC.B $1,$60,$7,$48,$1,$78,$1,$31,$1,$70,$6,$48,$1,$7B,$1,$31,$1
  DC.B $73,$80,$BC,$8,$BC,$18,$47,$70,$56,$0,$40,$FF,$FF,$FD,$FF         *1d7
  DC.B $C0,$79,$0,$60,$F6,$28,$0,$40,$60,$29,$0,$40,$80,$B5,$7,$6,$3F,$E,$FD
  DC.B $F7,$BA,$FE,$7,$71,$C1,$21,$C1,$72,$9D,$21,$1,$73,$9,$21,$41,$73
  DC.B $3,$2F,$1,$D1,$10,$21,$0,$E0,$20,$21,$81,$73,$4,$21,$C1,$71,$3
  DC.B $49,$2,$1C,$1,$20,$FD,$F7,$C3,$FE,$80,$BC,$8,$BC,$18,$47         *1d8
  DC.B $0,$7A,$0,$60,$C8,$3B,$0,$40,$90,$B5,$7,$6,$3F,$E,$C,$4C,$E0,$6F,$5
  DC.B $F0,$5B,$FD,$1,$28,$6,$D2,$CF,$21,$38,$1C,$FF,$F7,$7D,$FF,$90,$BC
  DC.B $8,$BC,$18,$47,$A0,$6F,$5,$F0,$4F,$FD,$C1,$6,$C9,$E,$4,$4A,$38
  DC.B $1C,$FF,$F7,$7D,$F8,$90,$BC,$8,$BC,$18,$47,$2C,$3,$1,$0         *1d9
  DC.B $40,$7A,$0,$60,$C9,$22,$0,$40,$F0,$B5,$E8,$23,$7,$1C,$58,$43,$81,$B0,$3E
  DC.B $49,$46,$18,$F5,$1D,$21,$35,$3D,$48,$0,$90,$C0,$6F,$5,$F0,$34,$FD
  DC.B $1,$28,$67,$D9,$0,$98,$80,$6F,$5,$F0,$2E,$FD,$0,$11,$4,$7,$24
  DC.B $F,$0,$98,$80,$6F,$5,$F0,$27,$FD,$1,$2C,$1C,$D0,$0,$2C         *1da
  DC.B $80,$7A,$0,$60,$1A,$D0,$3,$2C,$18,$D0,$6,$2C,$16,$D0,$7,$2C,$14,$D0,$8
  DC.B $2C,$12,$D0,$9,$2C,$10,$D0,$A,$2C,$E,$D0,$B,$2C,$C,$D0,$C,$2C
  DC.B $A,$D0,$D,$2C,$8,$D0,$E,$2C,$6,$D0,$0,$2F,$4A,$D0,$47,$E0,$19
  DC.B $21,$FF,$F7,$31,$FF,$3D,$E0,$0,$28,$1F,$DD,$31,$28,$1D,$DA         *1db
  DC.B $C0,$7A,$0,$60,$1,$38,$0,$6,$0,$E,$81,$0,$49,$19,$A,$68,$52,$9,$52
  DC.B $1,$E3,$6,$DB,$E,$1A,$43,$1E,$4B,$1A,$40,$20,$23,$1A,$43,$A,$60
  DC.B $1,$22,$20,$28,$2,$DA,$F1,$1D,$D,$31,$2,$E0,$20,$38,$F1,$1D,$11
  DC.B $31,$82,$40,$8,$68,$10,$43,$8,$60,$1B,$E0,$FC,$28,$19,$D0         *1dc
  DC.B $0,$7B,$0,$60,$FD,$28,$1B,$D1,$0,$20,$E1,$6,$C9,$E,$C,$E0,$2A,$68,$52
  DC.B $9,$52,$1,$A,$43,$E,$4B,$1A,$40,$20,$23,$1A,$43,$1,$30,$0,$6
  DC.B $0,$E,$2A,$60,$4,$35,$30,$28,$F0,$DB,$0,$20,$C0,$43,$70,$61,$8
  DC.B $48,$B0,$61,$1,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$2F,$1,$D0         *1dd
  DC.B $40,$7B,$0,$60,$4,$20,$B5,$E7,$3,$20,$B3,$E7,$70,$56,$0,$40,$2C,$3,$1
  DC.B $0,$1F,$FE,$FF,$FF,$FF,$FF,$0,$0,$F0,$B5,$E8,$23,$7,$1C,$58,$43
  DC.B $1A,$49,$40,$18,$C6,$1D,$15,$36,$19,$4D,$E8,$6F,$5,$F0,$AC,$FC,$1
  DC.B $28,$28,$D9,$A8,$6F,$5,$F0,$A7,$FC,$4,$1C,$A8,$6F,$5,$F0         *1de
  DC.B $80,$7B,$0,$60,$A3,$FC,$6,$2C,$14,$DB,$D,$2C,$12,$DC,$A1,$0,$89,$19,$18
  DC.B $39,$F0,$23,$DB,$43,$A,$68,$1A,$40,$F0,$23,$3,$40,$1A,$43,$12,$9
  DC.B $12,$1,$0,$7,$0,$F,$10,$43,$8,$60,$F0,$BC,$8,$BC,$18,$47,$0
  DC.B $2F,$1,$D0,$4,$20,$0,$E0,$3,$20,$19,$21,$FF,$F7,$AC,$FE         *1df
  DC.B $C0,$7B,$0,$60,$F0,$BC,$8,$BC,$18,$47,$0,$2F,$F6,$D0,$F3,$E7,$70,$56,$0
  DC.B $40,$2C,$3,$1,$0,$1D,$48,$41,$68,$1,$23,$5B,$3,$19,$43,$41,$60
  DC.B $41,$68,$1B,$1,$19,$43,$41,$60,$C1,$68,$1B,$9,$19,$43,$C1,$60,$C1
  DC.B $68,$1B,$1,$19,$43,$C1,$60,$C1,$69,$15,$4B,$19,$40,$C1,$61         *1e0
  DC.B $0,$7C,$0,$60,$C1,$69,$14,$4B,$19,$40,$C1,$61,$41,$69,$1,$23,$5B,$3,$19
  DC.B $43,$41,$61,$41,$69,$1B,$1,$19,$43,$41,$61,$9,$20,$40,$3,$1,$6A
  DC.B $49,$B,$49,$3,$5,$23,$5B,$2,$19,$43,$1,$62,$1,$6A,$1,$23,$5B
  DC.B $3,$19,$43,$1,$62,$17,$20,$0,$3,$41,$68,$5,$4B,$19,$40         *1e1
  DC.B $40,$7C,$0,$60,$41,$60,$1,$68,$DB,$43,$19,$43,$1,$60,$70,$47,$0,$60,$0
  DC.B $E0,$FF,$DF,$FF,$FF,$FF,$FF,$FD,$FF,$B0,$B4,$C1,$0,$9,$23,$5B,$3
  DC.B $CC,$18,$21,$68,$C2,$0,$D7,$18,$7A,$68,$F,$25,$2D,$6,$D,$40,$5
  DC.B $23,$5B,$6,$9D,$42,$1,$D1,$1,$23,$0,$E0,$0,$23,$1E,$4D         *1e2
  DC.B $80,$7C,$0,$60,$2B,$54,$B,$C,$1D,$6,$2D,$E,$FF,$23,$1B,$2,$B,$40,$1D
  DC.B $43,$9,$4,$FF,$23,$1B,$4,$19,$40,$29,$43,$13,$E,$1B,$6,$19,$43
  DC.B $E8,$23,$58,$43,$15,$4B,$C0,$18,$C1,$60,$11,$C,$9,$6,$9,$E,$FF
  DC.B $23,$1B,$2,$1A,$40,$11,$43,$1,$61,$2,$1D,$6,$CA,$40,$78         *1e3
  DC.B $C0,$7C,$0,$60,$0,$6,$D,$4,$1B,$2,$2B,$40,$18,$43,$FF,$23,$1B,$2,$B
  DC.B $40,$18,$43,$B,$C,$1B,$6,$1B,$E,$18,$43,$20,$61,$8,$E,$0,$6
  DC.B $11,$4,$FF,$23,$1B,$4,$19,$40,$8,$43,$19,$A,$11,$40,$8,$43,$78
  DC.B $61,$B0,$BC,$70,$47,$0,$0,$64,$29,$0,$40,$70,$56,$0,$40         *1e4
  DC.B $0,$7D,$0,$60,$F0,$B5,$8A,$B0,$2C,$48,$0,$78,$0,$28,$4F,$D0,$0,$27,$2
  DC.B $97,$2,$20,$2A,$4F,$9,$97,$28,$49,$49,$78,$8,$91,$0,$21,$E8,$23
  DC.B $2,$9F,$7B,$43,$26,$4C,$1B,$19,$DC,$68,$7,$94,$1B,$69,$6,$93,$7B
  DC.B $0,$5,$93,$3B,$6,$1B,$E,$4,$93,$7,$9B,$0,$93,$6,$9B         *1e5
  DC.B $40,$7D,$0,$60,$1,$93,$5,$9B,$5B,$18,$9B,$0,$3,$93,$9,$9F,$FB,$58,$8F
  DC.B $0,$6C,$46,$E4,$59,$63,$40,$1D,$1C,$17,$D0,$1,$23,$4F,$1,$0,$E0
  DC.B $5B,$0,$1,$37,$3F,$6,$3F,$E,$2E,$1C,$1E,$40,$F8,$D0,$5D,$40,$E
  DC.B $D1,$2,$28,$1E,$D1,$3,$98,$9,$9A,$14,$50,$4,$98,$3A,$1C         *1e6
  DC.B $80,$7D,$0,$60,$23,$40,$2,$D0,$40,$32,$12,$6,$12,$E,$1,$31,$1,$29,$D4
  DC.B $D0,$2,$9F,$1,$37,$2,$97,$1,$2F,$2,$D1,$8,$99,$0,$29,$BD,$D1
  DC.B $2,$28,$3,$DA,$3,$30,$11,$1C,$FF,$F7,$52,$FC,$A,$B0,$F0,$BC,$8
  DC.B $BC,$18,$47,$2,$20,$EB,$E7,$64,$29,$0,$40,$60,$56,$0,$40         *1e7
  DC.B $C0,$7D,$0,$60,$70,$56,$0,$40,$93,$63,$2F,$3F,$A3,$C3,$87,$8B,$15,$5,$11
  DC.B $9,$1,$0,$0,$8,$0,$1,$0,$1,$0,$1,$0,$1,$1,$9,$0,$1
  DC.B $0,$1,$0,$1,$0,$1,$0,$2,$1,$2,$1,$2,$1,$2,$1,$2,$0
  DC.B $3,$1,$3,$2,$3,$3,$3,$4,$3,$0,$1,$1,$4,$2,$4         *1e8
  DC.B $0,$7E,$0,$60,$3,$8,$4,$8,$0,$1,$0,$1,$0,$1,$3,$8,$4,$8,$0
  DC.B $8,$0,$1,$0,$1,$0,$1,$0,$1,$0,$8,$2,$7,$2,$8,$4,$7
  DC.B $4,$8,$0,$8,$3,$6,$4,$6,$3,$6,$4,$6,$0,$8,$3,$8,$4
  DC.B $8,$3,$8,$4,$8,$0,$8,$1,$6,$2,$6,$1,$6,$2,$6         *1e9
  DC.B $40,$7E,$0,$60,$0,$8,$1,$4,$2,$4,$1,$4,$2,$4,$0,$8,$1,$8,$2
  DC.B $8,$1,$8,$2,$8,$0,$8,$1,$5,$1,$5,$3,$5,$3,$5,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$94,$29,$0,$40,$0
  DC.B $0,$0,$0,$E0,$27,$0,$40,$0,$0,$0,$0,$0,$0,$0,$0         *1ea
  DC.B $80,$7E,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$4,$0,$6,$0,$8,$0,$A
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$3,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *1eb
  DC.B $C0,$7E,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$12,$80
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $3,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *1ec
  DC.B $0,$7F,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *1ed
  DC.B $40,$7F,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$24
  DC.B $B0,$7F,$0,$B2,$94,$DF,$D4,$0,$24,$B0,$71,$5,$B2,$DF,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *1ee
  DC.B $80,$7F,$0,$60,$74,$54,$0,$40,$7F,$54,$0,$40,$C8,$54,$0,$40,$D3,$54,$0
  DC.B $40,$1C,$55,$0,$40,$27,$55,$0,$40,$70,$55,$0,$40,$7B,$55,$0,$40
  DC.B $C4,$55,$0,$40,$CF,$55,$0,$40,$18,$56,$0,$40,$23,$56,$0,$40,$24
  DC.B $52,$0,$40,$2F,$52,$0,$40,$3A,$52,$0,$40,$45,$52,$0,$40         *1ef
  DC.B $C0,$7F,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$2,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF         *1f0
fw_ss4150hr2_end
