*FW4150HR3.S--------------------EDITION A05--04/01/08 11:02--CAMELON------------
	TTL	set_firmware_program
		SECTION ?fw_ss4150hr3
        XDEF    fw_ss4150hr3_start
        XDEF    fw_ss4150hr3_end
*************************************************************************
*       HISTORY
*
*  A02  14/12/99 E.E. Submitted file recieved from Craig French.
*  A03  22/12/99 E.E. Submitted file recieved from C.F. - no associated
*                     dpars
*  A04  19/01/00 E.E. File copied from Mantis webpage - bularo fixes 
*                     p.17864 and p.17869
*  A05  28/01/00 E.E. Downloaded from mantis webpage - bularo fixes
*                     p.17864 & p.17869
*  A06  07/03/00 E.E. Downloaded from mantis webpage - bularo fixes
*                     p.17889, p.17883, p.17892, p.17886
*  A07  20/04/00 E.E. 
*  A08  17/05/00 E.E. 
*  A09  17/05/00 E.E. Downloaded from mantis webpage - p.18022,p.18036
*
*  G1010
*  B02  25/05/00 E.E. Added changes from B01 to A09 to create B02
*  B03  31/05/00 E.E. Added changes from A10 to create B03
*  B05  07/07/00 E.E. Downloaded from Mantis webpage - p.18178, p.18036
*  B06  26/07/00 E.E.
*  B07  08/08/00 E.E. p.18347,p.18318,p.18294,p.18235,p.18106,p.18328,
*                     p.18082,p.18171,p.18293 - bularo fixes from Mantis
*                     webpage
*  B08  31/08/00 C.S. New version provided by Craig French Aug 31, 2000 to 
* 		      build on L36.0.5
*  B09  06/09/00 E.E. p.18364,p.18030,p.18369 bularo fixes from Mantis 
*  		      webpage
*  B10  07/09/00 E.E. new version by Craig French
*  B12  17/01/01 E.E. new main8.16 - fix for p.18420
*  B14  14/05/01 E.E. new main8.18 - check release notice
*  B15  21/05/01 E.E. Section def in wrong case.
*  B16  04/06/01 E.E. new main8.19 check release notice
*  B17  20/11/01 E.E. P.18926 fix from Ted Houghton
*
*************************************************************************
*
* Description
* ===========
* This file contains the firmware program for the SS4150 set. This data is
* accessed via a PASCAL pointer in handlers.pas. The first 3 bytes of the
* data below were added and are defined as below. The information in the
* this 3 byte header is contained here in order to avoid confusion when
* installing new firmware loads. The data size and version is maintained
* in these three bytes and therefore unique to this firware version.
*
* See DS.25 in SMS bularo 'Set Firmware Download' for more information
* on the SX200 download tool.
*
* This file is released from set firmware group and then compiled by
* Configuration Management into a SX200 load
*
* The tool used in the set firmware group is known as mantisfw.c 
*
*********************** FILE DATA FORMAT ************************
*   HEADER 3 bytes
*     byte1  software version (see MTS22 - Send Maintenance Data)
*                             (see NOTE below )
*     byte2  number of 66 byte lines to follow (high byte)
*     byte3  number of 66 byte lines to follow (low  byte)
*
*   FIRMWARE CODE 66 bytes per line (64 data + 2 or 4 addressing)
*   the choice between 16 (2 byte) or 32 (4 byte) bit addressing
*   is made when calling the mantisfw program.
* The remaining bytes are the actual code to be downloaded to 
* the set firmware.
*****************************************************************
*
* Maintenance Notes:
* ==================
* If your installing a new firmware version for the same set type/file
* name then you only have to update the data and header in this file.
* You do not have to update any other file. The 3-byte header info will
* tell the rest of the sx200 program about this data (size and version).
*
* If your installing firmware for a different set type that requires 
* different firmware then a new version of this file with a different name
* would have to be created. Also you must edit the files init.s, osinit.s
* and main.mak, sx200.mak files. Those file would have to be updated to
* include the new file name and pointers to the new firmware code.
* It is the  SECTION ?FW_SS4090   statement at the top of this
* file that acts as the label for locating this code. For example if you
* created a new file called fw4125.s then that statement would be
*   SECTION ?FW_SS4125  and dealt with in the make and init files.
*
* There must be enough room is the SECTION definition in sx200.mak and
* main.mak to handle the size of this firmware code without running
* into the next section.
*
* You must XDEF in OSINIT.C a pointer in this SECTION to this data .
* The current SW version is calculated in INIT.PAS from this data.
* The first byte of this file is the version of the firmware and is put
* in automatically by the srec_to_sx200.c reformat tool. It is extracted
* from the firmware data itself usually at byte number 16.
* Also the number of 64 bytes of code lines for writing to the set is
* automatically generated and placed in bytes 2 and 3 of the header.
*
*
*       NOTES: There are 2 information in the BYTE of the firmware rev:
*              - BIT6 to BIT8 = firmware stream (A .. H)
*              - BIT1 to BIT5 = firmware revision number (0 .. 31)
*
*              For example, firmware rev BYTE = $4A  equivalent to C.10
*
*              stream = C    revision number = 10
*               ___|___     _______|_______ 
*              /       \   /               \
*              B8  B7  B6  B5  B4  B3  B2  B1
*               0   1   0   0   1   0   1   0  = $4A
*
*
*************************************************************************
fw_ss4150hr3_start
  DC.B $AD,$01,$FE  * Header: version + num lines to follow (hi byte,lo byte)
  DC.B $0,$10,$0,$60,$5A,$0,$0,$0,$44,$7F,$0,$0,$A0,$54,$2D,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$5,$14,$0,$60,$0,$0,$0,$0,$B7,$2,$0,$0
  DC.B $1,$20,$3,$49,$8,$80,$3,$48,$1,$8B,$1,$31,$1,$83,$70,$47,$78
  DC.B $2B,$0,$40,$B0,$29,$0,$40,$0,$20,$3,$49,$8,$80,$3,$48         *1
  DC.B $40,$10,$0,$60,$1,$8B,$1,$31,$1,$83,$70,$47,$78,$2B,$0,$40,$B0,$29,$0
  DC.B $40,$B,$49,$4A,$68,$92,$9,$92,$1,$83,$6,$9B,$E,$1A,$43,$4A,$60
  DC.B $21,$28,$0,$DA,$20,$20,$3A,$28,$0,$DD,$3B,$20,$1F,$38,$40,$10,$4
  DC.B $49,$48,$80,$4,$48,$1,$8B,$1,$31,$1,$83,$70,$47,$0,$0         *2
  DC.B $80,$10,$0,$60,$FC,$5,$1,$0,$78,$2B,$0,$40,$B0,$29,$0,$40,$0,$B5,$1
  DC.B $1C,$5,$4A,$11,$80,$5,$49,$A,$8B,$1,$32,$A,$83,$4,$49,$89,$68
  DC.B $FE,$F7,$D0,$FF,$8,$BC,$18,$47,$78,$2B,$0,$40,$B0,$29,$0,$40,$B0
  DC.B $29,$0,$40,$3,$49,$48,$81,$3,$48,$1,$8B,$1,$31,$1,$83         *3
  DC.B $C0,$10,$0,$60,$70,$47,$0,$0,$78,$2B,$0,$40,$B0,$29,$0,$40,$80,$B4,$7
  DC.B $1C,$17,$49,$CA,$1D,$FF,$32,$7A,$32,$CB,$1D,$F9,$33,$15,$48,$80,$31
  DC.B $0,$2F,$16,$D0,$7,$68,$0,$2F,$9,$D1,$CF,$6B,$7,$60,$F,$6C,$47
  DC.B $60,$DF,$6B,$87,$60,$CF,$69,$7,$61,$57,$6A,$47,$61,$E,$48         *4
  DC.B $0,$11,$0,$60,$C8,$63,$E,$48,$8,$64,$E,$48,$D8,$63,$E,$48,$C8,$61,$E
  DC.B $48,$A,$E0,$7,$68,$0,$2F,$8,$D0,$CF,$63,$47,$68,$F,$64,$87,$68
  DC.B $DF,$63,$3,$69,$CB,$61,$40,$69,$50,$62,$80,$BC,$70,$47,$0,$0,$AC
  DC.B $1,$1,$0,$B0,$29,$0,$40,$21,$10,$0,$60,$39,$10,$0,$60         *5
  DC.B $40,$11,$0,$60,$8D,$10,$0,$60,$51,$10,$0,$60,$28,$A,$1,$0,$0,$20,$B
  DC.B $49,$8,$60,$B,$49,$8,$60,$B,$49,$8,$60,$B,$49,$8,$60,$B,$49
  DC.B $8,$60,$B,$49,$8,$60,$B,$4A,$B,$49,$A,$60,$8,$73,$48,$75,$88
  DC.B $61,$A,$48,$88,$60,$8,$1D,$8,$61,$70,$47,$24,$2A,$0,$40         *6
  DC.B $80,$11,$0,$60,$28,$2A,$0,$40,$2C,$2A,$0,$40,$30,$2A,$0,$40,$34,$2A,$0
  DC.B $40,$38,$2A,$0,$40,$90,$4A,$0,$60,$CC,$29,$0,$40,$84,$2B,$0,$40
  DC.B $B0,$B4,$3,$6,$1B,$E,$38,$48,$81,$69,$1,$31,$81,$61,$5,$7B,$1
  DC.B $27,$0,$22,$0,$2D,$E,$D0,$7C,$7,$1,$1D,$1,$2D,$25,$D0         *7
  DC.B $C0,$11,$0,$60,$2,$2D,$21,$D1,$45,$7D,$0,$2D,$39,$D1,$B,$70,$47,$75,$C1
  DC.B $89,$1,$31,$C1,$81,$43,$E0,$2D,$4D,$44,$7D,$2B,$55,$63,$1C,$43,$75
  DC.B $43,$7D,$2,$2B,$10,$DD,$83,$68,$1C,$88,$A1,$42,$C,$D1,$7,$73,$42
  DC.B $75,$7,$75,$19,$88,$49,$8,$C1,$75,$C0,$7D,$40,$0,$C1,$18         *8
  DC.B $0,$12,$0,$60,$40,$39,$C9,$8F,$5,$31,$19,$52,$B0,$BC,$70,$47,$47,$7D,$CB
  DC.B $55,$7B,$1C,$43,$75,$43,$7D,$2,$2B,$F6,$D1,$3,$69,$1B,$88,$C3,$81
  DC.B $42,$75,$C3,$89,$63,$84,$C7,$89,$1,$23,$9B,$3,$9F,$42,$1,$DB,$1
  DC.B $23,$0,$E0,$0,$23,$83,$75,$4A,$70,$2,$21,$20,$E0,$49,$19         *9
  DC.B $40,$12,$0,$60,$20,$39,$C9,$7F,$9,$2,$19,$43,$21,$84,$81,$7D,$0,$29,$5
  DC.B $D1,$41,$7D,$2,$29,$2,$DA,$1,$31,$41,$75,$0,$E0,$42,$75,$1,$7D
  DC.B $4B,$0,$84,$68,$E3,$5A,$84,$69,$A3,$42,$CD,$D1,$C3,$7D,$99,$42,$5
  DC.B $DA,$1,$31,$1,$75,$7,$73,$42,$75,$B0,$BC,$70,$47,$3,$21         *a
  DC.B $80,$12,$0,$60,$1,$73,$B0,$BC,$70,$47,$0,$0,$CC,$29,$0,$40,$84,$2B,$0
  DC.B $40,$2,$49,$A,$68,$10,$78,$1,$32,$A,$60,$70,$47,$CC,$29,$0,$40
  DC.B $F3,$B5,$81,$B0,$1,$98,$44,$1C,$F,$1C,$1C,$48,$4,$60,$0,$20,$0
  DC.B $F0,$42,$F8,$20,$1C,$1A,$4D,$E9,$1D,$79,$31,$A,$6E,$5C,$21         *b
  DC.B $C0,$12,$0,$60,$FE,$F7,$C2,$FE,$17,$49,$8,$60,$0,$20,$17,$49,$0,$91,$8
  DC.B $60,$16,$49,$8,$60,$1,$20,$0,$F0,$2F,$F8,$15,$48,$A,$23,$0,$22
  DC.B $41,$21,$6C,$6C,$FE,$F7,$B4,$FE,$0,$24,$8,$E0,$BB,$88,$FA,$88,$39
  DC.B $7A,$38,$68,$6E,$6C,$FE,$F7,$AF,$FE,$1,$34,$C,$37,$1,$98         *c
  DC.B $0,$13,$0,$60,$84,$42,$F3,$DB,$0,$99,$8,$68,$20,$30,$A,$49,$9,$68,$FE
  DC.B $F7,$99,$FE,$1,$B0,$FC,$BC,$8,$BC,$18,$47,$0,$0,$24,$1,$1,$0
  DC.B $AC,$1,$1,$0,$10,$1,$1,$0,$14,$1,$1,$0,$18,$1,$1,$0,$E8
  DC.B $58,$0,$0,$4,$48,$0,$60,$F0,$B5,$7,$1C,$81,$B0,$B,$4E         *d
  DC.B $40,$13,$0,$60,$33,$68,$B,$4D,$2A,$68,$B,$4C,$21,$68,$B,$48,$0,$90,$0
  DC.B $78,$0,$F0,$14,$F8,$38,$1C,$21,$1C,$2A,$1C,$33,$1C,$0,$F0,$1E,$F8
  DC.B $0,$98,$7,$70,$1,$B0,$F0,$BC,$8,$BC,$18,$47,$88,$0,$1,$0,$84
  DC.B $0,$1,$0,$80,$0,$1,$0,$E8,$29,$0,$40,$90,$B4,$1F,$1C         *e
  DC.B $80,$13,$0,$60,$C,$23,$43,$43,$4,$4C,$E1,$50,$43,$0,$18,$18,$80,$0,$0
  DC.B $19,$42,$60,$87,$60,$90,$BC,$70,$47,$C0,$2B,$0,$40,$90,$B4,$1F,$1C
  DC.B $C,$23,$43,$43,$6,$4C,$E3,$58,$B,$60,$43,$0,$18,$18,$80,$0,$0
  DC.B $19,$41,$68,$11,$60,$80,$68,$38,$60,$90,$BC,$70,$47,$0,$0         *f
  DC.B $C0,$13,$0,$60,$C0,$2B,$0,$40,$80,$B4,$0,$27,$D,$49,$0,$28,$5,$D1,$8
  DC.B $68,$82,$68,$2,$62,$8,$68,$87,$60,$8,$E0,$A,$68,$93,$68,$3,$40
  DC.B $8,$D0,$13,$62,$8,$68,$82,$68,$9A,$43,$82,$60,$8,$68,$C7,$60,$80
  DC.B $BC,$70,$47,$13,$1C,$52,$69,$A,$60,$D8,$60,$80,$BC,$70,$47         *10
  DC.B $0,$14,$0,$60,$14,$1,$1,$0,$F0,$B5,$81,$B0,$43,$48,$44,$49,$1,$60,$44
  DC.B $48,$4,$1C,$44,$4F,$F9,$1D,$79,$31,$C9,$6D,$FE,$F7,$13,$FE,$22,$1C
  DC.B $41,$49,$42,$48,$42,$4C,$23,$68,$FE,$F7,$10,$FE,$41,$4A,$42,$49,$42
  DC.B $48,$23,$68,$FE,$F7,$A,$FE,$41,$4A,$42,$49,$42,$48,$23,$68         *11
  DC.B $40,$14,$0,$60,$6,$1C,$FE,$F7,$3,$FE,$41,$4A,$15,$1C,$41,$48,$0,$90,$41
  DC.B $49,$B,$68,$0,$21,$FE,$F7,$FA,$FD,$3,$23,$1B,$2,$F8,$18,$0,$6B
  DC.B $FE,$F7,$EE,$FD,$4,$1C,$F8,$1D,$F9,$30,$0,$6A,$FE,$F7,$E8,$FD,$1
  DC.B $1C,$39,$48,$2,$68,$39,$4B,$1A,$40,$9,$7,$9,$F,$C9,$1         *12
  DC.B $80,$14,$0,$60,$11,$43,$1,$60,$0,$F0,$96,$F8,$35,$49,$8,$60,$35,$48,$3E
  DC.B $21,$0,$F0,$80,$F8,$0,$20,$FF,$F7,$4F,$FF,$0,$98,$42,$19,$1,$20
  DC.B $11,$1C,$33,$1C,$FF,$F7,$6A,$FF,$2F,$48,$30,$49,$8,$60,$9,$20,$2F
  DC.B $49,$8,$80,$A,$20,$2F,$49,$8,$70,$1,$20,$2E,$49,$8,$70         *13
  DC.B $C0,$14,$0,$60,$99,$2C,$18,$D0,$17,$20,$0,$3,$41,$68,$2C,$4B,$19,$40,$41
  DC.B $60,$1,$68,$19,$40,$1,$60,$1,$20,$FF,$F7,$2E,$FF,$80,$20,$28,$49
  DC.B $8,$80,$5,$23,$DB,$1,$F8,$18,$41,$69,$1,$20,$FE,$F7,$AA,$FD,$0
  DC.B $20,$FF,$F7,$21,$FF,$9B,$2C,$9,$D1,$22,$48,$9,$21,$0,$F0         *14
  DC.B $0,$15,$0,$60,$49,$F8,$21,$48,$21,$49,$8,$60,$2,$20,$21,$49,$8,$80,$1
  DC.B $B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$8,$80,$0,$E0,$64,$0,$0,$1
  DC.B $88,$1,$0,$0,$AC,$1,$1,$0,$44,$62,$0,$60,$2C,$9,$1,$0,$F0
  DC.B $47,$0,$60,$78,$2B,$0,$0,$CC,$63,$0,$60,$0,$0,$0,$40         *15
  DC.B $40,$15,$0,$60,$30,$1,$0,$0,$0,$0,$0,$60,$0,$7E,$0,$40,$F0,$2E,$0
  DC.B $0,$78,$2B,$0,$40,$F4,$47,$0,$60,$3C,$0,$1,$0,$7F,$F8,$FF,$FF
  DC.B $30,$0,$1,$0,$8C,$45,$0,$60,$20,$45,$0,$60,$34,$0,$1,$0,$38
  DC.B $0,$1,$0,$D8,$0,$1,$0,$DC,$0,$1,$0,$FF,$FF,$FF,$EF         *16
  DC.B $80,$15,$0,$60,$68,$0,$1,$0,$7C,$47,$0,$60,$C,$4A,$0,$60,$9C,$0,$1
  DC.B $0,$C8,$2A,$0,$40,$80,$B4,$6,$4A,$6,$E0,$0,$23,$C3,$5E,$9B,$0
  DC.B $47,$68,$D7,$50,$8,$30,$1,$39,$0,$29,$F6,$D1,$80,$BC,$70,$47,$AC
  DC.B $1,$1,$0,$0,$B5,$3,$20,$40,$7,$0,$F0,$23,$F8,$0,$21         *17
  DC.B $C0,$15,$0,$60,$C,$4A,$4,$E0,$43,$5C,$53,$54,$1,$31,$9,$6,$9,$E,$9
  DC.B $29,$F8,$DB,$0,$20,$6,$E0,$8,$A1,$9,$5C,$13,$18,$59,$72,$1,$30
  DC.B $0,$6,$0,$E,$B,$28,$F6,$DB,$0,$21,$11,$75,$10,$1C,$8,$BC,$18
  DC.B $47,$0,$0,$D8,$2B,$0,$40,$20,$20,$4D,$41,$49,$4E,$20,$39         *18
  DC.B $0,$16,$0,$60,$2E,$31,$32,$0,$1,$38,$41,$78,$1,$30,$42,$29,$FB,$D1,$41
  DC.B $78,$4F,$29,$F8,$D1,$81,$78,$4F,$29,$F5,$D1,$C1,$78,$54,$29,$F2,$D1
  DC.B $70,$47,$0,$0,$80,$B5,$F,$4F,$7A,$6B,$51,$1E,$79,$63,$0,$2A,$D
  DC.B $D1,$1,$1C,$0,$20,$FE,$F7,$5,$FD,$1,$23,$B8,$63,$D8,$42         *19
  DC.B $40,$16,$0,$60,$0,$D1,$FE,$E7,$78,$6C,$1,$30,$78,$64,$7,$20,$78,$63,$B9
  DC.B $6B,$8,$A,$1,$D3,$1,$20,$0,$E0,$0,$20,$49,$0,$B9,$63,$80,$BC
  DC.B $8,$BC,$18,$47,$F0,$29,$0,$40,$F3,$B5,$1,$25,$0,$24,$0,$26,$7
  DC.B $1C,$7,$E0,$38,$1C,$FF,$F7,$D5,$FF,$0,$28,$0,$D0,$2C,$43         *1a
  DC.B $80,$16,$0,$60,$6D,$0,$1,$36,$1,$99,$8E,$42,$F4,$DB,$20,$1C,$FC,$BC,$8
  DC.B $BC,$18,$47,$F0,$B4,$2,$20,$81,$B0,$1A,$4A,$1B,$49,$1B,$4F,$1,$26
  DC.B $4,$1C,$0,$D5,$1,$34,$64,$10,$43,$0,$D4,$52,$CE,$52,$1,$30,$B8
  DC.B $42,$F5,$DD,$1,$20,$16,$4A,$16,$49,$FF,$27,$39,$37,$43,$0         *1b
  DC.B $C0,$16,$0,$60,$D3,$52,$5C,$1C,$CC,$52,$1,$30,$B8,$42,$F8,$DD,$0,$21,$0
  DC.B $20,$11,$4C,$12,$4F,$12,$4D,$0,$95,$82,$0,$A1,$50,$43,$0,$FD,$5E
  DC.B $33,$1C,$AB,$40,$59,$18,$4B,$1E,$0,$9D,$AB,$50,$1,$30,$4,$28,$F2
  DC.B $DB,$1,$39,$B,$48,$81,$60,$10,$31,$C1,$60,$1,$B0,$F0,$BC         *1c
  DC.B $0,$17,$0,$60,$70,$47,$0,$0,$AC,$48,$0,$40,$90,$4D,$0,$40,$71,$2,$0
  DC.B $0,$C8,$43,$0,$40,$3A,$46,$0,$40,$A8,$43,$0,$40,$F0,$29,$0,$40
  DC.B $B8,$43,$0,$40,$F0,$29,$0,$40,$F0,$B4,$14,$4C,$14,$4A,$15,$4F,$15
  DC.B $4B,$40,$0,$1D,$5A,$4E,$0,$9E,$5B,$AD,$19,$10,$5E,$46,$0         *1d
  DC.B $40,$17,$0,$60,$9D,$53,$1,$28,$6,$D0,$41,$0,$51,$5E,$4D,$0,$79,$5F,$81
  DC.B $42,$0,$D1,$61,$5F,$1,$28,$EC,$D1,$19,$1C,$2,$23,$CA,$5E,$7D,$23
  DC.B $1B,$1,$9A,$42,$7,$D1,$9,$4A,$43,$0,$CF,$5E,$7F,$10,$CF,$52,$1
  DC.B $30,$90,$42,$F8,$DD,$F0,$BC,$70,$47,$0,$0,$3A,$46,$0,$40         *1e
  DC.B $80,$17,$0,$60,$AC,$48,$0,$40,$C8,$43,$0,$40,$90,$4D,$0,$40,$71,$2,$0
  DC.B $0,$F0,$B5,$C7,$1D,$FF,$37,$33,$37,$78,$0,$84,$B0,$27,$4E,$31,$5A
  DC.B $1,$31,$31,$52,$26,$4D,$2C,$5E,$1,$2C,$42,$D0,$60,$0,$25,$49,$9
  DC.B $5E,$B9,$42,$1,$D1,$24,$49,$9,$5E,$38,$1C,$FF,$F7,$B4,$FF         *1f
  DC.B $C0,$17,$0,$60,$60,$0,$1F,$49,$A,$5E,$0,$92,$51,$0,$1E,$4A,$53,$5E,$3
  DC.B $93,$A3,$42,$2,$D1,$1C,$4E,$75,$5E,$0,$E0,$3,$9D,$7A,$0,$2,$92
  DC.B $16,$4E,$B2,$5E,$6B,$0,$1,$93,$F3,$5E,$9A,$42,$1A,$DD,$15,$4A,$3
  DC.B $9B,$A3,$42,$2,$D1,$14,$4E,$77,$52,$0,$E0,$57,$52,$11,$5E         *20
  DC.B $0,$18,$0,$60,$B9,$42,$3,$D1,$15,$52,$10,$4E,$31,$5E,$1,$E0,$E,$4E,$35
  DC.B $52,$1,$9B,$B,$48,$C4,$52,$0,$9A,$2,$9B,$C2,$52,$28,$1C,$FF,$F7
  DC.B $83,$FF,$2F,$1C,$78,$0,$6,$49,$F,$5E,$78,$0,$C,$5E,$1,$2C,$C6
  DC.B $D1,$4,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$90,$4D,$0,$40         *21
  DC.B $40,$18,$0,$60,$AC,$48,$0,$40,$C8,$43,$0,$40,$3A,$46,$0,$40,$F0,$B5,$1
  DC.B $24,$7,$1C,$D,$4E,$D,$4D,$38,$1C,$FF,$F7,$E4,$FE,$0,$28,$2,$D0
  DC.B $60,$0,$34,$5E,$1,$E0,$60,$0,$2C,$5E,$FF,$23,$39,$33,$9C,$42,$F1
  DC.B $DD,$E0,$1F,$FF,$38,$33,$38,$7,$1C,$FF,$F7,$89,$FF,$38,$1C         *22
  DC.B $80,$18,$0,$60,$F0,$BC,$8,$BC,$18,$47,$0,$0,$3A,$46,$0,$40,$C8,$43,$0
  DC.B $40,$F3,$B5,$0,$24,$84,$B0,$FF,$F7,$FC,$FE,$38,$48,$38,$4F,$E3,$43
  DC.B $38,$63,$98,$42,$4,$D0,$37,$49,$3,$91,$37,$4A,$2,$92,$55,$E0,$FE
  DC.B $E7,$8E,$42,$F,$DA,$5,$99,$30,$1C,$FE,$F7,$C3,$FB,$B8,$6C         *23
  DC.B $C0,$18,$0,$60,$1,$30,$B8,$64,$20,$1C,$39,$6B,$E,$54,$F8,$68,$1,$34,$84
  DC.B $42,$44,$D1,$0,$24,$42,$E0,$E,$20,$F1,$1F,$FA,$39,$FE,$F7,$DC,$FB
  DC.B $5,$1C,$E,$21,$69,$43,$F0,$1F,$F7,$38,$41,$1A,$0,$91,$68,$0,$3
  DC.B $99,$9,$5E,$4,$98,$FF,$F7,$B7,$FE,$0,$99,$40,$18,$A9,$0         *24
  DC.B $0,$19,$0,$60,$2,$9A,$51,$58,$40,$18,$25,$1A,$26,$1C,$0,$2D,$1,$DA,$F8
  DC.B $68,$2D,$18,$0,$20,$17,$E0,$38,$6B,$40,$5D,$5,$99,$FE,$F7,$92,$FB
  DC.B $B8,$6C,$1,$30,$29,$1C,$B8,$64,$38,$6B,$42,$5C,$31,$1C,$42,$54,$F8
  DC.B $68,$1,$35,$1,$36,$86,$42,$0,$D1,$0,$26,$85,$42,$0,$D1         *25
  DC.B $40,$19,$0,$60,$0,$25,$1,$98,$1,$30,$1,$90,$0,$99,$88,$42,$E3,$DB,$0
  DC.B $99,$64,$18,$F8,$68,$84,$42,$1,$DB,$F8,$68,$24,$1A,$4,$98,$FF,$F7
  DC.B $75,$FF,$FF,$21,$1,$31,$6,$1C,$88,$42,$3,$D0,$7,$48,$0,$88,$4
  DC.B $28,$9E,$D0,$4,$B0,$FC,$BC,$8,$BC,$18,$47,$18,$3E,$0,$40         *26
  DC.B $80,$19,$0,$60,$F0,$29,$0,$40,$F0,$29,$0,$40,$A8,$43,$0,$40,$C8,$2A,$0
  DC.B $40,$17,$21,$9,$3,$88,$68,$40,$C,$F,$D2,$48,$68,$8,$4B,$18,$40
  DC.B $48,$60,$8,$68,$18,$40,$8,$60,$88,$68,$80,$14,$0,$7,$0,$F,$4A
  DC.B $68,$DB,$43,$1A,$43,$4A,$60,$70,$47,$F,$20,$70,$47,$0,$0         *27
  DC.B $C0,$19,$0,$60,$FF,$FF,$FD,$FF,$17,$21,$9,$3,$48,$68,$7,$4B,$18,$40,$48
  DC.B $60,$8,$68,$18,$40,$8,$60,$88,$68,$80,$14,$0,$7,$0,$F,$4A,$68
  DC.B $DB,$43,$1A,$43,$4A,$60,$70,$47,$FF,$FF,$FD,$FF,$80,$B5,$7,$1C,$0
  DC.B $D5,$1,$30,$40,$10,$E,$21,$8,$1A,$17,$21,$9,$3,$89,$68         *28
  DC.B $0,$1A,$0,$60,$89,$11,$C9,$7,$C9,$F,$1,$22,$51,$1A,$89,$0,$40,$1A,$4
  DC.B $49,$9,$68,$FE,$F7,$17,$FB,$3,$48,$7,$70,$80,$BC,$8,$BC,$18,$47
  DC.B $D4,$47,$0,$60,$A8,$1,$1,$0,$B0,$B4,$10,$4A,$15,$78,$C7,$0,$F
  DC.B $48,$C4,$59,$F0,$23,$9D,$43,$24,$7,$24,$F,$24,$1,$24,$6         *29
  DC.B $40,$1A,$0,$60,$24,$E,$2B,$1C,$23,$43,$13,$70,$38,$18,$40,$68,$10,$71,$7
  DC.B $29,$5,$D0,$8,$29,$7,$D1,$10,$78,$40,$8,$40,$0,$2,$E0,$10,$78
  DC.B $1,$23,$18,$43,$10,$70,$B0,$BC,$70,$47,$0,$0,$4,$80,$1,$E0,$D4
  DC.B $95,$0,$0,$0,$B5,$0,$28,$9,$D1,$8,$49,$9,$68,$8A,$6         *2a
  DC.B $80,$1A,$0,$60,$D2,$F,$1,$2A,$7,$D0,$9,$5,$C9,$F,$1,$29,$3,$D0,$4
  DC.B $49,$9,$68,$FE,$F7,$D7,$FA,$8,$BC,$18,$47,$0,$0,$40,$0,$1,$0
  DC.B $E4,$47,$0,$60,$B0,$B5,$18,$4F,$FC,$1D,$FF,$34,$7A,$34,$E0,$6F,$FE
  DC.B $F7,$C6,$FA,$4,$28,$9,$D2,$5,$23,$DB,$1,$F8,$18,$1,$69         *2b
  DC.B $C0,$1A,$0,$60,$C3,$20,$FE,$F7,$BF,$FA,$B0,$BC,$8,$BC,$18,$47,$0,$20,$0
  DC.B $27,$5,$2,$A0,$6F,$FE,$F7,$B4,$FA,$0,$6,$0,$E,$28,$43,$1,$37
  DC.B $4,$2F,$F5,$DB,$9,$49,$A,$4B,$98,$42,$2,$D1,$9,$48,$0,$88,$0
  DC.B $E0,$0,$68,$8,$60,$8,$48,$1,$23,$1B,$3,$1,$68,$19,$43         *2c
  DC.B $0,$1B,$0,$60,$1,$60,$B0,$BC,$8,$BC,$18,$47,$AC,$1,$1,$0,$CC,$0,$1
  DC.B $0,$FF,$FF,$FF,$4F,$C8,$2A,$0,$40,$BC,$0,$1,$0,$90,$B5,$44,$48
  DC.B $0,$68,$FE,$F7,$8D,$FA,$43,$4C,$20,$78,$0,$28,$10,$D0,$42,$4F,$BB
  DC.B $78,$0,$22,$41,$49,$42,$48,$2,$2B,$35,$D0,$C1,$2B,$1A,$D0         *2d
  DC.B $40,$1B,$0,$60,$C6,$2B,$8,$D0,$D7,$2B,$3,$D1,$43,$7A,$0,$2B,$1A,$D0,$42
  DC.B $72,$90,$BC,$8,$BC,$18,$47,$F8,$78,$7,$28,$A,$D0,$8,$28,$6,$D0
  DC.B $D,$28,$F5,$D1,$37,$48,$0,$68,$0,$F0,$76,$F8,$6,$E0,$AD,$20,$4
  DC.B $E0,$2,$20,$2,$E0,$38,$79,$2,$23,$18,$43,$38,$71,$90,$BC         *2e
  DC.B $80,$1B,$0,$60,$8,$BC,$18,$47,$30,$4A,$12,$68,$93,$D,$E1,$D2,$43,$68,$5B
  DC.B $8,$5B,$0,$43,$60,$52,$D,$1,$D3,$1,$22,$3E,$E0,$C8,$68,$FE,$F7
  DC.B $4F,$FA,$90,$BC,$8,$BC,$18,$47,$FB,$78,$65,$2B,$37,$D0,$13,$DC,$27
  DC.B $2B,$D,$D0,$6,$DC,$0,$2B,$2C,$D0,$25,$2B,$8,$D0,$26,$2B         *2f
  DC.B $C0,$1B,$0,$60,$C6,$D1,$5,$E0,$28,$2B,$3,$D0,$29,$2B,$1,$D0,$2A,$2B,$BF
  DC.B $D1,$0,$21,$D8,$1F,$1D,$38,$25,$E0,$69,$2B,$20,$D0,$6,$DC,$66,$2B
  DC.B $1D,$D0,$67,$2B,$1B,$D0,$68,$2B,$B2,$D1,$18,$E0,$6A,$2B,$16,$D0,$80
  DC.B $2B,$6,$D0,$C0,$2B,$AB,$D1,$14,$48,$1,$68,$14,$4B,$19,$40         *30
  DC.B $0,$1C,$0,$60,$1,$60,$22,$70,$13,$48,$1,$78,$20,$23,$59,$40,$1,$70,$90
  DC.B $BC,$8,$BC,$18,$47,$3,$68,$0,$2B,$9A,$D0,$2,$60,$BE,$E7,$1,$21
  DC.B $D8,$1F,$5D,$38,$2,$F0,$90,$F9,$90,$BC,$8,$BC,$18,$47,$0,$0,$C4
  DC.B $47,$0,$60,$C4,$0,$1,$0,$EC,$5,$1,$0,$2C,$2,$1,$0         *31
  DC.B $40,$1C,$0,$60,$3C,$2A,$0,$40,$30,$0,$1,$0,$40,$0,$1,$0,$A0,$0,$1
  DC.B $0,$FF,$FF,$FB,$FF,$DB,$0,$1,$0,$0,$E0,$1,$30,$1,$78,$2E,$29
  DC.B $FB,$D1,$C1,$1F,$19,$39,$8A,$7F,$30,$2A,$6,$DD,$A,$23,$5A,$43,$FF
  DC.B $3A,$E1,$3A,$12,$6,$12,$E,$0,$E0,$0,$22,$C9,$7F,$89,$18         *32
  DC.B $80,$1C,$0,$60,$34,$39,$A,$6,$12,$E,$81,$78,$30,$29,$8,$DB,$40,$78,$A
  DC.B $23,$58,$43,$FF,$38,$E1,$38,$0,$6,$0,$E,$8,$18,$0,$E0,$40,$78
  DC.B $30,$38,$0,$6,$0,$E,$1,$30,$0,$6,$0,$E,$51,$1,$8,$43,$0
  DC.B $6,$0,$E,$70,$47,$F0,$B5,$22,$48,$0,$68,$81,$7A,$8,$18         *33
  DC.B $C0,$1C,$0,$60,$C0,$7A,$21,$49,$5,$23,$DB,$1,$CE,$18,$CF,$1D,$FF,$37,$7A
  DC.B $37,$9,$28,$19,$D1,$B8,$6F,$FE,$F7,$B3,$F9,$B8,$6F,$FE,$F7,$B0,$F9
  DC.B $1A,$4D,$1B,$4C,$5,$28,$3,$D1,$60,$68,$40,$8,$40,$0,$7,$E0,$4
  DC.B $28,$19,$D1,$B8,$6F,$FE,$F7,$A3,$F9,$1,$23,$60,$68,$18,$43         *34
  DC.B $0,$1D,$0,$60,$60,$60,$0,$20,$E9,$68,$11,$E0,$A,$28,$14,$D1,$B8,$6F,$FE
  DC.B $F7,$97,$F9,$B8,$6F,$FE,$F7,$94,$F9,$4,$28,$5,$D1,$1,$20,$D,$49
  DC.B $8,$60,$F0,$BC,$8,$BC,$18,$47,$D0,$20,$31,$69,$FE,$F7,$8A,$F9,$F0
  DC.B $BC,$8,$BC,$18,$47,$8,$48,$0,$68,$FE,$F7,$81,$F9,$F0,$BC         *35
  DC.B $40,$1D,$0,$60,$8,$BC,$18,$47,$3C,$2B,$0,$40,$AC,$1,$1,$0,$2C,$2,$1
  DC.B $0,$3C,$2A,$0,$40,$60,$2B,$0,$40,$CC,$47,$0,$60,$0,$B5,$17,$28
  DC.B $11,$D0,$6,$DC,$14,$28,$E,$D0,$15,$28,$C,$D0,$16,$28,$E,$D1,$9
  DC.B $E0,$19,$28,$5,$D0,$2D,$28,$5,$D0,$D2,$28,$7,$D1,$0,$F0         *36
  DC.B $80,$1D,$0,$60,$13,$F8,$8,$BC,$18,$47,$1,$F0,$BD,$F8,$8,$BC,$18,$47,$1
  DC.B $C,$2,$D3,$1,$23,$DB,$3,$58,$40,$2,$49,$9,$68,$FE,$F7,$52,$F9
  DC.B $8,$BC,$18,$47,$D0,$47,$0,$60,$F0,$B5,$0,$24,$0,$25,$82,$B0,$22
  DC.B $48,$1,$90,$80,$6F,$FE,$F7,$43,$F9,$21,$4E,$F0,$70,$F0,$78         *37
  DC.B $C0,$1D,$0,$60,$20,$4F,$3,$28,$C,$D1,$1,$98,$80,$6F,$FE,$F7,$39,$F9,$1C
  DC.B $49,$8,$71,$6,$1C,$1,$98,$C0,$6F,$FE,$F7,$32,$F9,$B0,$42,$4,$D2
  DC.B $39,$69,$19,$48,$FE,$F7,$2E,$F9,$24,$E0,$F0,$1C,$14,$49,$88,$70,$70
  DC.B $1D,$0,$90,$1B,$E0,$5,$2C,$2,$DA,$11,$49,$8,$5D,$3,$E0         *38
  DC.B $0,$1E,$0,$60,$1,$98,$80,$6F,$FE,$F7,$1C,$F9,$B9,$69,$6,$1C,$FE,$F7,$1A
  DC.B $F9,$8,$E0,$5,$2D,$E4,$D0,$1,$20,$3,$DF,$B9,$69,$30,$1C,$FE,$F7
  DC.B $11,$F9,$1,$35,$1,$23,$D8,$42,$F3,$D0,$0,$25,$1,$34,$0,$98,$A0
  DC.B $42,$E0,$DC,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$2C,$3,$1,$0         *39
  DC.B $40,$1E,$0,$60,$46,$2A,$0,$40,$2C,$4,$1,$0,$D2,$80,$0,$0,$F0,$B5,$0
  DC.B $24,$7,$1C,$9,$4E,$9,$4D,$31,$5D,$1,$29,$2,$D1,$0,$2F,$0,$D1
  DC.B $0,$21,$7,$A0,$6A,$6C,$FE,$F7,$EF,$F8,$1,$34,$5,$2C,$F2,$DB,$F0
  DC.B $BC,$8,$BC,$18,$47,$0,$0,$48,$48,$0,$60,$2C,$4,$1,$0         *3a
  DC.B $80,$1E,$0,$60,$25,$63,$0,$0,$F0,$B5,$40,$4F,$B8,$69,$0,$28,$A,$D1,$3F
  DC.B $48,$0,$68,$FE,$F7,$D5,$F8,$0,$28,$34,$D0,$3D,$48,$0,$68,$FE,$F7
  DC.B $CF,$F8,$B8,$61,$3B,$48,$C0,$69,$FE,$F7,$CA,$F8,$1,$23,$5,$1C,$D8
  DC.B $42,$27,$D0,$FA,$7B,$0,$24,$0,$2A,$1E,$D0,$36,$49,$37,$48         *3b
  DC.B $C0,$1E,$0,$60,$1,$2A,$22,$D0,$2,$2A,$1D,$D1,$BB,$69,$DA,$79,$2E,$1C,$55
  DC.B $1C,$DD,$71,$BB,$69,$D2,$18,$D6,$72,$3A,$7C,$1,$3A,$12,$6,$12,$E
  DC.B $3A,$74,$F,$D1,$BA,$69,$3,$68,$0,$20,$FE,$F7,$AF,$F8,$BC,$61,$2B
  DC.B $48,$1,$78,$1,$31,$1,$70,$28,$E0,$12,$2D,$2,$D1,$1,$23         *3c
  DC.B $0,$1F,$0,$60,$FB,$73,$7C,$75,$F0,$BC,$8,$BC,$18,$47,$26,$4E,$7A,$7D,$B5
  DC.B $54,$13,$1C,$0,$2A,$2,$D1,$32,$78,$83,$2A,$17,$D1,$5A,$1C,$7A,$75
  DC.B $7A,$7D,$4,$2A,$EE,$D1,$B3,$78,$32,$1C,$4,$2B,$9,$D1,$53,$78,$3
  DC.B $2B,$6,$D1,$D3,$78,$1,$2B,$3,$D1,$1,$20,$FF,$F7,$86,$FF         *3d
  DC.B $40,$1F,$0,$60,$4,$E0,$53,$78,$46,$2B,$1,$DC,$3,$2B,$3,$DA,$FC,$73,$F0
  DC.B $BC,$8,$BC,$18,$47,$1,$23,$BD,$69,$2B,$71,$D2,$23,$BD,$69,$EB,$72
  DC.B $93,$78,$BD,$69,$2B,$73,$D3,$78,$BD,$69,$6B,$73,$3,$23,$BD,$69,$EB
  DC.B $71,$52,$78,$3,$3A,$12,$6,$12,$E,$3A,$74,$B2,$D0,$2,$20         *3e
  DC.B $80,$1F,$0,$60,$F8,$73,$F0,$BC,$8,$BC,$18,$47,$3C,$2A,$0,$40,$40,$48,$0
  DC.B $60,$38,$48,$0,$60,$2C,$4,$1,$0,$D0,$3D,$0,$40,$30,$48,$0,$60
  DC.B $E6,$2A,$0,$40,$4D,$2A,$0,$40,$F0,$B5,$6A,$48,$0,$23,$C0,$5E,$69
  DC.B $49,$C9,$5E,$88,$42,$1,$D0,$FF,$F7,$64,$FF,$17,$22,$12,$3         *3f
  DC.B $C0,$1F,$0,$60,$90,$68,$C0,$9,$1,$D2,$1,$20,$0,$E0,$0,$20,$0,$6,$0
  DC.B $E,$62,$4F,$7B,$7F,$62,$49,$0,$24,$62,$4D,$83,$42,$4C,$D0,$2B,$68
  DC.B $5B,$6,$1B,$F,$6,$2B,$1,$D0,$5,$2B,$44,$D1,$BB,$7F,$1,$2B,$1D
  DC.B $D1,$0,$28,$1B,$D1,$BC,$77,$56,$68,$5B,$3,$9E,$43,$56,$60         *40
  DC.B $0,$20,$0,$60,$16,$68,$1,$23,$5B,$3,$9E,$43,$16,$60,$57,$4E,$36,$78,$43
  DC.B $1F,$33,$40,$55,$4E,$33,$70,$55,$4E,$36,$68,$1,$23,$9B,$3,$9E,$43
  DC.B $33,$1C,$52,$4E,$33,$60,$E,$78,$80,$23,$9E,$43,$E,$70,$BB,$7F,$0
  DC.B $2B,$20,$D1,$0,$28,$1E,$D0,$1,$23,$BB,$77,$56,$68,$5B,$3         *41
  DC.B $40,$20,$0,$60,$9E,$43,$56,$60,$16,$68,$1,$23,$5B,$3,$33,$43,$13,$60,$46
  DC.B $4A,$16,$78,$4,$23,$33,$43,$13,$70,$44,$4A,$1,$23,$9B,$3,$16,$68
  DC.B $33,$43,$13,$60,$A,$78,$80,$23,$1A,$43,$A,$70,$A,$7B,$92,$8,$52
  DC.B $8,$0,$D3,$78,$77,$78,$77,$A,$7B,$92,$8,$52,$8,$0,$D3         *42
  DC.B $80,$20,$0,$60,$78,$77,$38,$7A,$2,$28,$1E,$DD,$39,$48,$0,$68,$39,$4A,$12
  DC.B $68,$80,$1A,$7D,$23,$1B,$1,$98,$42,$0,$D9,$3C,$72,$38,$7A,$3,$28
  DC.B $14,$D0,$4,$28,$19,$D0,$5,$28,$D,$D1,$8,$78,$40,$9,$40,$8,$9
  DC.B $D2,$38,$7F,$41,$1C,$39,$77,$5,$28,$4,$DD,$8,$21,$1,$20         *43
  DC.B $C0,$20,$0,$60,$FF,$F7,$B2,$FC,$3C,$72,$F0,$BC,$8,$BC,$18,$47,$7,$21,$3
  DC.B $20,$FF,$F7,$AA,$FC,$3C,$77,$4,$20,$38,$E0,$38,$7F,$1,$30,$0,$6
  DC.B $0,$E,$38,$77,$2,$28,$EE,$DD,$3C,$77,$23,$4E,$29,$E0,$23,$4A,$11
  DC.B $5C,$F2,$29,$1E,$D1,$1,$30,$38,$77,$28,$68,$40,$6,$0,$F         *44
  DC.B $0,$21,$0,$60,$5,$28,$2,$D1,$38,$7F,$2,$30,$38,$77,$38,$7F,$11,$1C,$12
  DC.B $18,$52,$78,$9,$5C,$1A,$A0,$73,$6C,$FD,$F7,$98,$FF,$38,$7F,$1,$30
  DC.B $38,$77,$28,$68,$40,$6,$0,$F,$6,$28,$7,$D1,$38,$7F,$2,$30,$38
  DC.B $77,$3,$E0,$14,$A0,$72,$6C,$FD,$F7,$86,$FF,$38,$7F,$1,$30         *45
  DC.B $40,$21,$0,$60,$38,$77,$38,$7F,$32,$28,$D2,$DB,$3C,$77,$5,$20,$38,$72,$F0
  DC.B $BC,$8,$BC,$18,$47,$64,$0,$1,$0,$66,$0,$1,$0,$3C,$2A,$0,$40
  DC.B $0,$80,$1,$E0,$3C,$0,$1,$0,$14,$80,$1,$E0,$14,$60,$0,$E0,$50
  DC.B $0,$1,$0,$EC,$29,$0,$40,$2C,$4,$1,$0,$4D,$48,$0,$60         *46
  DC.B $80,$21,$0,$60,$25,$63,$25,$63,$0,$0,$0,$0,$25,$63,$0,$0,$4,$48,$19
  DC.B $21,$9,$3,$8,$60,$3,$48,$0,$68,$D,$21,$4,$DF,$70,$47,$0,$0
  DC.B $0,$10,$27,$80,$A8,$2A,$0,$40,$0,$B5,$A,$1C,$1,$1C,$0,$20,$0
  DC.B $F0,$A,$F8,$8,$BC,$18,$47,$0,$B5,$A,$1C,$1,$1C,$1,$20         *47
  DC.B $C0,$21,$0,$60,$0,$F0,$2,$F8,$8,$BC,$18,$47,$90,$B5,$49,$7,$49,$F,$12
  DC.B $4F,$7,$23,$DB,$1,$3C,$68,$9C,$43,$23,$1C,$4C,$7,$64,$F,$E4,$1
  DC.B $1C,$43,$52,$7,$52,$F,$7,$23,$9B,$2,$9C,$43,$23,$1C,$54,$7,$64
  DC.B $F,$A4,$2,$23,$43,$3B,$60,$DB,$7,$1F,$F,$80,$23,$3B,$43         *48
  DC.B $0,$22,$0,$60,$19,$43,$12,$1,$A,$43,$5,$49,$4B,$6F,$0,$21,$FD,$F7,$1E
  DC.B $FF,$90,$BC,$8,$BC,$18,$47,$0,$0,$FC,$5,$1,$0,$AC,$1,$1,$0
  DC.B $80,$B5,$7,$6,$3F,$E,$9,$6,$9,$E,$38,$1C,$6,$4A,$12,$68,$FD
  DC.B $F7,$A,$FF,$5,$48,$0,$2F,$1,$D0,$5,$49,$0,$E0,$5,$49         *49
  DC.B $40,$22,$0,$60,$41,$67,$80,$BC,$8,$BC,$18,$47,$D8,$47,$0,$60,$AC,$2,$1
  DC.B $0,$51,$3,$0,$40,$44,$94,$0,$0,$F0,$B5,$0,$6,$0,$E,$82,$B0
  DC.B $73,$4E,$74,$49,$1,$91,$CF,$1D,$79,$37,$73,$4C,$73,$4D,$1,$28,$5D
  DC.B $D1,$0,$20,$30,$80,$20,$68,$41,$A,$1,$D2,$81,$A,$73,$D3         *4a
  DC.B $80,$22,$0,$60,$2,$23,$29,$68,$19,$43,$0,$3,$C0,$E,$40,$0,$29,$60,$6C
  DC.B $4E,$30,$5C,$1,$99,$CD,$1D,$F9,$35,$E9,$6E,$FD,$F7,$D3,$FE,$20,$68
  DC.B $0,$3,$C0,$E,$40,$0,$80,$19,$40,$78,$29,$6F,$FD,$F7,$CA,$FE,$FF
  DC.B $23,$1,$33,$20,$68,$18,$40,$62,$49,$0,$91,$9,$D0,$0,$99         *4b
  DC.B $C0,$22,$0,$60,$8,$68,$0,$7,$C0,$F,$0,$23,$1,$22,$4,$21,$7E,$68,$FD
  DC.B $F7,$C3,$FE,$20,$68,$81,$5,$C9,$F,$1,$29,$6F,$D1,$2,$21,$1,$40
  DC.B $59,$48,$25,$D0,$1,$68,$1,$20,$FD,$F7,$AC,$FE,$1,$99,$89,$6E,$0
  DC.B $20,$FD,$F7,$A7,$FE,$26,$20,$79,$69,$FD,$F7,$A3,$FE,$20,$68         *4c
  DC.B $0,$23,$0,$60,$80,$D,$3,$D3,$51,$48,$0,$68,$40,$8,$3,$D3,$50,$48,$0
  DC.B $68,$0,$28,$4,$D0,$3F,$68,$0,$23,$0,$22,$0,$21,$3,$E0,$3F,$68
  DC.B $0,$23,$0,$22,$1,$21,$4,$20,$FD,$F7,$98,$FE,$35,$E0,$5A,$E0,$1
  DC.B $68,$1,$20,$FD,$F7,$86,$FE,$1,$20,$A9,$68,$FD,$F7,$82,$FE         *4d
  DC.B $40,$23,$0,$60,$1,$25,$44,$48,$0,$88,$7,$28,$3,$D1,$2,$25,$1,$20,$0
  DC.B $F0,$AB,$FA,$78,$6C,$40,$4E,$B1,$68,$88,$42,$6,$D1,$2,$2D,$4,$D0
  DC.B $0,$20,$0,$F0,$A1,$FA,$0,$E0,$5E,$E0,$3,$2D,$2,$D0,$A8,$0,$30
  DC.B $58,$78,$64,$0,$99,$8,$68,$0,$5,$0,$F,$40,$0,$F9,$69         *4e
  DC.B $80,$23,$0,$60,$24,$30,$FD,$F7,$5F,$FE,$0,$23,$1,$22,$2,$21,$4,$20,$3D
  DC.B $68,$FD,$F7,$60,$FE,$F8,$6B,$FD,$F7,$53,$FE,$2,$22,$21,$68,$A,$40
  DC.B $17,$20,$0,$3,$0,$2A,$A,$D0,$89,$9,$8,$D3,$41,$68,$2B,$4B,$19
  DC.B $40,$41,$60,$1,$68,$DB,$43,$19,$43,$6,$E0,$7,$E0,$41,$68         *4f
  DC.B $C0,$23,$0,$60,$26,$4B,$19,$40,$41,$60,$1,$68,$19,$40,$1,$60,$2C,$E0,$0
  DC.B $20,$A9,$68,$FD,$F7,$37,$FE,$3F,$68,$0,$23,$1,$22,$2,$21,$0,$20
  DC.B $FD,$F7,$3C,$FE,$20,$E0,$38,$6C,$FD,$F7,$2A,$FE,$2,$23,$DB,$43,$28
  DC.B $68,$18,$40,$28,$60,$20,$68,$81,$5,$C9,$F,$1,$29,$C,$D1         *50
  DC.B $0,$24,$0,$60,$80,$8,$3,$D2,$0,$23,$1,$22,$3C,$68,$2,$E0,$0,$23,$0
  DC.B $22,$3C,$68,$2,$21,$0,$20,$FD,$F7,$1B,$FE,$19,$20,$40,$1,$30,$80
  DC.B $1,$20,$F9,$68,$FD,$F7,$E,$FE,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$40
  DC.B $1,$1,$0,$AC,$1,$1,$0,$40,$0,$1,$0,$3C,$0,$1,$0         *51
  DC.B $40,$24,$0,$60,$7C,$96,$0,$0,$44,$0,$1,$0,$F8,$47,$0,$60,$40,$2A,$0
  DC.B $40,$3C,$2A,$0,$40,$C8,$2A,$0,$40,$80,$48,$0,$60,$FF,$FF,$FF,$FB
  DC.B $F1,$B5,$3,$20,$88,$B0,$0,$90,$1,$90,$0,$20,$2,$90,$3,$90,$4
  DC.B $90,$F0,$48,$0,$68,$80,$7,$C0,$F,$1,$28,$3,$D1,$8,$B0         *52
  DC.B $80,$24,$0,$60,$F8,$BC,$8,$BC,$18,$47,$EC,$4D,$28,$68,$0,$7,$C0,$F,$EB
  DC.B $49,$7,$91,$89,$6E,$FD,$F7,$D6,$FD,$28,$68,$C1,$7,$C9,$F,$E8,$4C
  DC.B $E8,$4F,$9,$D1,$40,$9,$7,$D2,$20,$68,$0,$7,$C0,$F,$0,$23,$0
  DC.B $22,$7E,$68,$FD,$F7,$D0,$FD,$28,$68,$81,$9,$3E,$D3,$40,$23         *53
  DC.B $C0,$24,$0,$60,$18,$43,$28,$60,$40,$9,$A,$D3,$20,$68,$0,$7,$C0,$F,$0
  DC.B $23,$1,$22,$2,$21,$7E,$68,$FD,$F7,$BF,$FD,$38,$6C,$9,$E0,$20,$68
  DC.B $0,$7,$C0,$F,$0,$23,$1,$22,$0,$21,$7E,$68,$FD,$F7,$B4,$FD,$F8
  DC.B $6B,$FD,$F7,$A5,$FD,$1,$20,$1,$90,$32,$20,$39,$6A,$FD,$F7         *54
  DC.B $0,$25,$0,$60,$A1,$FD,$1,$20,$0,$90,$4,$90,$2,$90,$28,$68,$C0,$B,$2
  DC.B $D3,$20,$68,$0,$6,$1,$E0,$20,$68,$0,$5,$0,$F,$40,$0,$F9,$69
  DC.B $24,$30,$FD,$F7,$8F,$FD,$20,$68,$0,$7,$C0,$F,$0,$23,$1,$22,$2
  DC.B $21,$3E,$68,$1,$30,$FD,$F7,$8F,$FD,$2,$E0,$40,$23,$18,$43         *55
  DC.B $40,$25,$0,$60,$28,$60,$2,$21,$28,$68,$1,$40,$BF,$4A,$6,$92,$1C,$D0,$80
  DC.B $D,$C,$D3,$6,$9A,$10,$68,$40,$8,$8,$D2,$20,$68,$0,$7,$C0,$F
  DC.B $0,$23,$0,$22,$0,$21,$3E,$68,$1,$30,$7,$E0,$20,$68,$0,$7,$C0
  DC.B $F,$0,$23,$0,$22,$1,$21,$3E,$68,$1,$30,$FD,$F7,$6C,$FD         *56
  DC.B $80,$25,$0,$60,$1,$20,$4,$90,$0,$20,$1,$90,$28,$68,$41,$8,$22,$D3,$80
  DC.B $D,$3,$D3,$6,$9A,$10,$68,$40,$8,$3,$D3,$AC,$48,$0,$68,$0,$28
  DC.B $7,$D0,$20,$68,$0,$7,$C0,$F,$0,$23,$0,$22,$5,$21,$7E,$68,$6
  DC.B $E0,$20,$68,$0,$7,$C0,$F,$0,$23,$0,$22,$1,$21,$7E,$68         *57
  DC.B $C0,$25,$0,$60,$FD,$F7,$4A,$FD,$32,$20,$B9,$69,$FD,$F7,$3C,$FD,$1,$20,$4
  DC.B $90,$0,$20,$1,$90,$2,$22,$29,$68,$A,$40,$17,$20,$0,$3,$9C,$4B
  DC.B $5,$93,$0,$2A,$11,$D0,$89,$9,$F,$D3,$41,$68,$99,$4B,$19,$40,$41
  DC.B $60,$1,$68,$DB,$43,$19,$43,$1,$60,$5,$9B,$18,$68,$40,$8         *58
  DC.B $0,$26,$0,$60,$1,$D3,$5,$20,$D,$E0,$4,$20,$B,$E0,$41,$68,$91,$4B,$19
  DC.B $40,$41,$60,$1,$68,$19,$40,$1,$60,$5,$9B,$18,$68,$40,$8,$F2,$D3
  DC.B $7,$20,$7,$99,$9,$6E,$FD,$F7,$D,$FD,$28,$68,$41,$B,$3F,$D3,$0
  DC.B $B,$16,$D3,$20,$68,$0,$5,$0,$F,$40,$0,$F9,$69,$24,$30         *59
  DC.B $40,$26,$0,$60,$FD,$F7,$0,$FD,$20,$68,$0,$7,$C0,$F,$2,$21,$8,$1A,$1
  DC.B $23,$1,$22,$3E,$68,$FD,$F7,$0,$FD,$1,$20,$3,$90,$2,$90,$1,$90
  DC.B $6,$E0,$1,$23,$1,$22,$2,$21,$0,$20,$3E,$68,$FD,$F7,$F4,$FC,$28
  DC.B $68,$C0,$A,$11,$D3,$20,$68,$0,$7,$C0,$F,$2,$21,$8,$1A         *5a
  DC.B $80,$26,$0,$60,$1,$23,$1,$22,$7E,$68,$FD,$F7,$E7,$FC,$32,$20,$39,$6A,$FD
  DC.B $F7,$D9,$FC,$1,$20,$3,$90,$1,$90,$A,$E0,$20,$68,$0,$7,$C0,$F
  DC.B $2,$21,$8,$1A,$1,$23,$1,$22,$0,$21,$7E,$68,$FD,$F7,$D4,$FC,$3
  DC.B $98,$0,$28,$45,$D1,$1,$20,$3,$90,$1,$98,$0,$28,$20,$D0         *5b
  DC.B $C0,$26,$0,$60,$1,$28,$1E,$D1,$20,$68,$0,$7,$C0,$F,$2,$21,$8,$1A,$1
  DC.B $23,$0,$22,$3,$21,$3E,$68,$FD,$F7,$BF,$FC,$20,$68,$0,$7,$C0,$F
  DC.B $2,$21,$8,$1A,$1,$23,$0,$22,$3,$21,$7E,$68,$FD,$F7,$B4,$FC,$33
  DC.B $20,$79,$69,$FD,$F7,$A6,$FC,$2F,$20,$B9,$69,$FD,$F7,$A2,$FC         *5c
  DC.B $0,$27,$0,$60,$1F,$E0,$20,$68,$0,$7,$C0,$F,$2,$21,$8,$1A,$1,$23,$1
  DC.B $22,$3,$21,$3E,$68,$FD,$F7,$A0,$FC,$20,$68,$0,$7,$C0,$F,$2,$21
  DC.B $8,$1A,$1,$23,$1,$22,$3,$21,$7E,$68,$FD,$F7,$95,$FC,$33,$20,$F9
  DC.B $69,$FD,$F7,$87,$FC,$2F,$20,$39,$6A,$FD,$F7,$83,$FC,$0,$20         *5d
  DC.B $40,$27,$0,$60,$0,$90,$0,$98,$1,$28,$8,$D1,$43,$48,$0,$88,$7,$28,$4
  DC.B $D1,$2,$20,$0,$90,$1,$20,$0,$F0,$A7,$F8,$78,$6C,$3F,$4E,$B1,$68
  DC.B $88,$42,$5,$D1,$0,$98,$2,$28,$2,$D0,$0,$20,$0,$F0,$9C,$F8,$0
  DC.B $98,$3,$28,$3,$D0,$0,$98,$80,$0,$30,$58,$78,$64,$28,$68         *5e
  DC.B $80,$27,$0,$60,$80,$8,$A,$D3,$8,$98,$1,$28,$7,$D1,$20,$68,$0,$2,$0
  DC.B $17,$40,$0,$79,$69,$30,$30,$FD,$F7,$55,$FC,$28,$68,$81,$8,$15,$D3
  DC.B $8,$99,$0,$29,$12,$D1,$C0,$8,$8,$D3,$30,$20,$79,$69,$FD,$F7,$49
  DC.B $FC,$20,$68,$2A,$4B,$18,$40,$20,$60,$7,$E0,$20,$68,$0,$2         *5f
  DC.B $C0,$27,$0,$60,$0,$17,$40,$0,$79,$69,$30,$30,$FD,$F7,$3C,$FC,$28,$68,$41
  DC.B $8,$5,$D2,$80,$8,$3,$D2,$1,$20,$F9,$6F,$FD,$F7,$33,$FC,$2,$98
  DC.B $20,$4F,$0,$28,$7,$D1,$5,$9B,$58,$68,$80,$B,$3,$D2,$0,$20,$B9
  DC.B $68,$FD,$F7,$27,$FC,$4,$98,$1B,$49,$9,$68,$FD,$F7,$22,$FC         *60
  DC.B $0,$28,$0,$60,$3,$98,$1A,$49,$9,$68,$FD,$F7,$1D,$FC,$3,$98,$0,$28,$8
  DC.B $D1,$79,$68,$FD,$F7,$17,$FC,$5,$9B,$18,$68,$15,$4B,$18,$40,$5,$9B
  DC.B $18,$60,$2,$98,$0,$28,$3,$D0,$1,$20,$B9,$68,$FD,$F7,$A,$FC,$8
  DC.B $B0,$25,$E6,$3C,$0,$1,$0,$40,$0,$1,$0,$AC,$1,$1,$0         *61
  DC.B $40,$28,$0,$60,$44,$0,$1,$0,$2C,$2,$1,$0,$40,$2A,$0,$40,$3C,$2A,$0
  DC.B $40,$FC,$5,$1,$0,$FF,$FF,$FF,$FB,$C8,$2A,$0,$40,$80,$48,$0,$60
  DC.B $FF,$FF,$F,$FF,$AC,$2,$1,$0,$F8,$47,$0,$60,$FC,$47,$0,$60,$FF
  DC.B $FF,$FE,$FF,$0,$B5,$0,$29,$B,$D1,$0,$28,$9,$D1,$8,$4B         *62
  DC.B $80,$28,$0,$60,$1B,$68,$0,$2B,$2,$D0,$8,$23,$DB,$43,$1,$E0,$0,$23,$DB
  DC.B $43,$1A,$40,$49,$0,$3,$4B,$1B,$68,$FD,$F7,$D8,$FB,$8,$BC,$18,$47
  DC.B $5C,$2A,$0,$40,$1C,$48,$0,$60,$80,$B5,$B,$49,$8,$60,$B,$4F,$0
  DC.B $21,$0,$20,$3A,$6F,$FD,$F7,$C7,$FB,$9,$49,$9,$68,$C9,$7         *63
  DC.B $C0,$28,$0,$60,$9,$F,$8,$43,$0,$21,$2,$1C,$0,$20,$7B,$6F,$FD,$F7,$BE
  DC.B $FB,$80,$BC,$8,$BC,$18,$47,$0,$0,$5C,$2A,$0,$40,$AC,$1,$1,$0
  DC.B $FC,$5,$1,$0,$F0,$B4,$0,$21,$1D,$4F,$1E,$4C,$0,$29,$1,$D0,$1D
  DC.B $4F,$3F,$21,$20,$1C,$27,$E0,$F0,$23,$2B,$40,$E0,$2B,$13,$D0         *64
  DC.B $0,$29,$0,$60,$F0,$2B,$1E,$D1,$2B,$7,$1B,$F,$42,$78,$FF,$2A,$3,$D1,$A
  DC.B $1C,$1,$E0,$3A,$70,$1,$37,$5D,$1E,$2E,$6,$36,$E,$1D,$1C,$33,$1C
  DC.B $0,$2D,$F6,$D1,$1,$30,$E,$E0,$0,$29,$5,$D0,$2A,$7,$12,$F,$1
  DC.B $25,$95,$40,$2A,$6,$12,$E,$43,$78,$13,$43,$3B,$70,$1,$30         *65
  DC.B $40,$29,$0,$60,$0,$E0,$3D,$70,$1,$37,$1,$30,$5,$78,$FF,$2D,$D4,$D1,$48
  DC.B $1C,$28,$40,$3,$1C,$8,$1C,$19,$1C,$0,$28,$C7,$D0,$F0,$BC,$70,$47
  DC.B $50,$53,$0,$40,$BC,$49,$0,$60,$8C,$52,$0,$40,$0,$20,$1,$21,$49
  DC.B $7,$5,$4A,$8B,$78,$9B,$7,$9B,$F,$3,$2B,$2,$D0,$1,$30         *66
  DC.B $80,$29,$0,$60,$90,$42,$F7,$DB,$70,$47,$0,$0,$88,$13,$0,$0,$80,$B4,$0
  DC.B $20,$1,$21,$49,$7,$5,$4A,$8F,$78,$8,$23,$3B,$40,$8,$2B,$2,$D0
  DC.B $1,$30,$90,$42,$F7,$DB,$80,$BC,$70,$47,$0,$0,$88,$13,$0,$0,$F0
  DC.B $B5,$27,$4F,$B8,$6A,$FD,$F7,$43,$FB,$0,$26,$1,$24,$64,$7         *67
  DC.B $C0,$29,$0,$60,$26,$70,$B8,$6A,$FD,$F7,$3C,$FB,$26,$70,$B8,$6A,$FD,$F7,$38
  DC.B $FB,$24,$25,$A5,$70,$B8,$6A,$FD,$F7,$33,$FB,$B0,$20,$A0,$70,$FF,$F7
  DC.B $D5,$FF,$0,$24,$EE,$6,$0,$20,$30,$70,$FF,$F7,$CF,$FF,$1,$23,$1B
  DC.B $3,$1,$34,$9C,$42,$F6,$D3,$B2,$24,$B4,$70,$B8,$6A,$FD,$F7         *68
  DC.B $0,$2A,$0,$60,$1F,$FB,$B8,$6A,$FD,$F7,$1C,$FB,$0,$20,$30,$70,$B8,$6A,$FD
  DC.B $F7,$17,$FB,$10,$20,$30,$70,$B8,$6A,$FD,$F7,$12,$FB,$B5,$70,$B8,$6A
  DC.B $FD,$F7,$E,$FB,$B0,$20,$B0,$70,$FF,$F7,$B0,$FF,$0,$25,$0,$20,$30
  DC.B $70,$FF,$F7,$AB,$FF,$1,$23,$5B,$2,$1,$35,$9D,$42,$F6,$D3         *69
  DC.B $40,$2A,$0,$60,$B4,$70,$B8,$6A,$FD,$F7,$FC,$FA,$F0,$BC,$8,$BC,$18,$47,$0
  DC.B $0,$2C,$3,$1,$0,$B0,$B5,$5,$6,$2D,$E,$C,$6,$24,$E,$D,$4F
  DC.B $B8,$6A,$FD,$F7,$ED,$FA,$50,$20,$60,$43,$40,$19,$1,$23,$1B,$3,$C0
  DC.B $18,$5D,$4,$28,$70,$4,$1C,$B8,$6A,$FD,$F7,$E1,$FA,$20,$12         *6a
  DC.B $80,$2A,$0,$60,$28,$70,$B8,$6A,$FD,$F7,$DC,$FA,$24,$20,$A8,$70,$B0,$BC,$8
  DC.B $BC,$18,$47,$0,$0,$2C,$3,$1,$0,$B0,$B5,$5,$6,$2D,$E,$C,$6
  DC.B $24,$E,$A,$4F,$B8,$6A,$FD,$F7,$CB,$FA,$28,$1C,$1,$25,$6D,$7,$28
  DC.B $70,$B8,$6A,$FD,$F7,$C4,$FA,$60,$0,$28,$70,$B8,$6A,$FD,$F7         *6b
  DC.B $C0,$2A,$0,$60,$BF,$FA,$21,$20,$A8,$70,$B0,$BC,$8,$BC,$18,$47,$2C,$3,$1
  DC.B $0,$B0,$B5,$0,$6,$0,$E,$80,$38,$4,$6,$24,$E,$C,$4F,$B8,$6A
  DC.B $FD,$F7,$AE,$FA,$E0,$0,$7,$23,$9B,$2,$C0,$18,$1,$24,$64,$7,$20
  DC.B $70,$5,$1C,$B8,$6A,$FD,$F7,$A3,$FA,$28,$12,$20,$70,$B8,$6A         *6c
  DC.B $0,$2B,$0,$60,$FD,$F7,$9E,$FA,$24,$20,$A0,$70,$B0,$BC,$8,$BC,$18,$47,$0
  DC.B $0,$2C,$3,$1,$0,$F0,$B5,$0,$20,$29,$49,$8,$70,$D,$20,$40,$3
  DC.B $1,$68,$3E,$23,$DB,$43,$19,$40,$A,$23,$19,$43,$1,$60,$25,$4C,$E0
  DC.B $1D,$79,$30,$1,$6F,$8,$20,$FD,$F7,$84,$FA,$FF,$F7,$D2,$FE         *6d
  DC.B $40,$2B,$0,$60,$E5,$1D,$FF,$35,$7A,$35,$A8,$6A,$FD,$F7,$7A,$FA,$9C,$20,$1
  DC.B $27,$7F,$7,$B8,$70,$28,$6B,$FD,$F7,$73,$FA,$A,$22,$FF,$21,$6,$B4
  DC.B $3,$23,$1B,$2,$E0,$18,$5,$23,$4,$22,$4,$21,$84,$6B,$28,$20,$FD
  DC.B $F7,$6E,$FA,$80,$20,$2,$B0,$FF,$F7,$AA,$FF,$B0,$20,$B8,$70         *6e
  DC.B $80,$2B,$0,$60,$FF,$F7,$4,$FF,$0,$24,$0,$27,$E0,$0,$F,$49,$46,$18,$F0
  DC.B $5D,$1,$21,$49,$7,$8,$70,$FF,$F7,$F9,$FE,$1,$37,$8,$2F,$F6,$DB
  DC.B $1,$34,$23,$2C,$EF,$DB,$B2,$20,$7,$7,$B8,$70,$A8,$6A,$FD,$F7,$47
  DC.B $FA,$0,$21,$0,$20,$FF,$F7,$4D,$FF,$F0,$BC,$8,$BC,$18,$47         *6f
  DC.B $C0,$2B,$0,$60,$7C,$0,$1,$0,$AC,$1,$1,$0,$8C,$48,$0,$60,$0,$B5,$1
  DC.B $38,$80,$0,$3,$49,$8,$58,$3,$49,$0,$F0,$56,$F8,$8,$BC,$18,$47
  DC.B $A4,$49,$0,$60,$50,$53,$0,$40,$0,$B5,$1,$38,$80,$0,$3,$49,$8
  DC.B $58,$0,$21,$0,$F0,$48,$F8,$8,$BC,$18,$47,$A4,$49,$0,$60         *70
  DC.B $0,$2C,$0,$60,$0,$B5,$1,$38,$80,$0,$3,$49,$8,$58,$3,$49,$0,$F0,$3C
  DC.B $F8,$8,$BC,$18,$47,$A4,$49,$0,$60,$8C,$52,$0,$40,$90,$B5,$4,$6
  DC.B $24,$E,$8,$4F,$B8,$6A,$FD,$F7,$B,$FA,$20,$1C,$1,$24,$64,$7,$20
  DC.B $70,$B8,$6A,$FD,$F7,$4,$FA,$C0,$20,$A0,$70,$90,$BC,$8,$BC         *71
  DC.B $40,$2C,$0,$60,$18,$47,$0,$0,$2C,$3,$1,$0,$B0,$B5,$7,$1C,$D,$4C,$A0
  DC.B $6A,$FD,$F7,$F6,$F9,$38,$1C,$1,$27,$7F,$7,$0,$28,$6,$D0,$9F,$25
  DC.B $1,$28,$6,$D0,$2,$28,$A,$D1,$A7,$20,$3,$E0,$9C,$20,$B8,$70,$5
  DC.B $E0,$A0,$20,$B8,$70,$A0,$6A,$FD,$F7,$E2,$F9,$BD,$70,$B0,$BC         *72
  DC.B $80,$2C,$0,$60,$8,$BC,$18,$47,$2C,$3,$1,$0,$F0,$B5,$7,$1C,$0,$20,$82
  DC.B $B0,$0,$90,$C,$1C,$E,$1C,$2B,$49,$1,$91,$4B,$E0,$0,$2C,$2,$D0
  DC.B $30,$78,$1,$36,$0,$E0,$0,$20,$5,$6,$2D,$E,$38,$1C,$1,$37,$0
  DC.B $F0,$4A,$F8,$38,$23,$18,$40,$28,$43,$1,$99,$89,$6B,$FD,$F7         *73
  DC.B $C0,$2C,$0,$60,$C1,$F9,$1,$99,$88,$6A,$FD,$F7,$BB,$F9,$B0,$21,$1,$20,$40
  DC.B $7,$81,$70,$1,$25,$E,$E0,$FF,$F7,$59,$FE,$0,$2C,$2,$D0,$30,$78
  DC.B $1,$36,$0,$E0,$0,$20,$1,$21,$49,$7,$8,$70,$68,$1C,$5,$6,$2D
  DC.B $E,$1,$37,$D,$2D,$EE,$DB,$FF,$F7,$48,$FE,$B2,$20,$1,$7         *74
  DC.B $0,$2D,$0,$60,$88,$70,$0,$2C,$2,$D0,$30,$78,$1,$36,$0,$E0,$0,$20,$5
  DC.B $6,$2D,$E,$38,$1C,$1,$37,$0,$F0,$17,$F8,$40,$7,$40,$F,$28,$43
  DC.B $1,$99,$89,$6B,$FD,$F7,$8E,$F9,$0,$98,$1,$30,$0,$6,$0,$E,$0
  DC.B $90,$1A,$37,$0,$98,$E,$28,$B0,$DB,$2,$B0,$F0,$BC,$8,$BC         *75
  DC.B $40,$2D,$0,$60,$18,$47,$0,$0,$2C,$3,$1,$0,$B0,$B5,$7,$1C,$10,$4C,$A0
  DC.B $6A,$FD,$F7,$76,$F9,$1,$25,$6D,$7,$2F,$70,$A0,$6A,$FD,$F7,$70,$F9
  DC.B $38,$12,$28,$70,$A0,$6A,$FD,$F7,$6B,$F9,$24,$20,$A8,$70,$A0,$6A,$FD
  DC.B $F7,$66,$F9,$C5,$20,$A8,$70,$A0,$6A,$FD,$F7,$61,$F9,$2F,$78         *76
  DC.B $80,$2D,$0,$60,$A0,$6A,$FD,$F7,$5D,$F9,$38,$1C,$B0,$BC,$8,$BC,$18,$47,$0
  DC.B $0,$2C,$3,$1,$0,$FF,$B5,$7,$1C,$82,$B0,$4C,$4C,$20,$68,$4C,$49
  DC.B $1,$91,$CD,$1D,$79,$35,$0,$28,$8,$D1,$4A,$48,$2,$70,$0,$23,$C0
  DC.B $56,$10,$21,$2A,$6E,$FD,$F7,$47,$F9,$20,$60,$46,$49,$0,$91         *77
  DC.B $C0,$2D,$0,$60,$8,$68,$46,$4E,$46,$4C,$0,$28,$2D,$D1,$38,$1C,$45,$49,$8
  DC.B $70,$3,$99,$45,$48,$1,$70,$3,$99,$4F,$43,$27,$60,$5,$99,$43,$4F
  DC.B $39,$70,$0,$23,$C0,$56,$1,$21,$2A,$6E,$FD,$F7,$2D,$F9,$40,$49,$8
  DC.B $60,$0,$23,$F8,$56,$21,$68,$2A,$6E,$FD,$F7,$25,$F9,$0,$99         *78
  DC.B $0,$2E,$0,$60,$0,$23,$8,$60,$F9,$56,$23,$68,$59,$43,$A,$1C,$20,$21,$33
  DC.B $68,$FD,$F7,$1C,$F9,$20,$68,$C1,$8,$0,$23,$F8,$56,$2A,$6E,$FD,$F7
  DC.B $13,$F9,$34,$49,$8,$60,$7,$23,$DB,$1,$1,$99,$C8,$18,$40,$69,$FD
  DC.B $F7,$6,$F9,$E0,$6A,$0,$28,$11,$D1,$B,$98,$60,$86,$32,$23         *79
  DC.B $40,$2E,$0,$60,$E0,$5E,$1,$30,$80,$0,$E9,$6D,$FD,$F7,$FC,$F8,$32,$23,$E1
  DC.B $5E,$1,$31,$8A,$0,$E0,$62,$0,$21,$33,$68,$FD,$F7,$F7,$F8,$A0,$68
  DC.B $0,$28,$1B,$D1,$21,$4F,$0,$23,$F8,$56,$0,$28,$16,$DD,$C,$21,$2A
  DC.B $6E,$1,$30,$FD,$F7,$E8,$F8,$A0,$60,$0,$20,$1,$22,$FE,$21         *7a
  DC.B $80,$2E,$0,$60,$6,$E0,$43,$0,$A5,$68,$5D,$19,$69,$70,$A5,$68,$EA,$54,$1
  DC.B $30,$0,$23,$FD,$56,$6,$23,$6B,$43,$83,$42,$F2,$DC,$0,$20,$16,$4F
  DC.B $16,$49,$5,$24,$A,$68,$16,$49,$B,$23,$43,$43,$5B,$18,$85,$0,$ED
  DC.B $19,$2B,$63,$1A,$72,$5C,$72,$1,$30,$4,$28,$F4,$DB,$1,$F0         *7b
  DC.B $C0,$2E,$0,$60,$79,$F9,$2,$B0,$4,$B0,$F0,$BC,$8,$BC,$18,$47,$F4,$0,$1
  DC.B $0,$AC,$1,$1,$0,$EF,$0,$1,$0,$8,$1,$1,$0,$F4,$47,$0,$60
  DC.B $60,$2A,$0,$40,$EC,$0,$1,$0,$ED,$0,$1,$0,$F0,$0,$1,$0,$FC
  DC.B $0,$1,$0,$C,$1,$1,$0,$EC,$2A,$0,$40,$AC,$2A,$0,$40         *7c
  DC.B $0,$2F,$0,$60,$2C,$54,$0,$40,$F0,$B5,$7,$1C,$16,$4C,$0,$20,$6,$E0,$21
  DC.B $78,$8F,$42,$5,$D0,$1,$30,$0,$6,$0,$E,$8,$34,$5,$28,$F6,$D3
  DC.B $5,$28,$15,$D0,$20,$68,$0,$5,$0,$F,$1,$38,$5,$6,$2D,$E,$D
  DC.B $4E,$F0,$1D,$FF,$30,$7A,$30,$C0,$6F,$FD,$F7,$81,$F8,$A8,$42         *7d
  DC.B $40,$2F,$0,$60,$9,$D2,$5,$23,$DB,$1,$F1,$18,$9,$69,$38,$1C,$FD,$F7,$7A
  DC.B $F8,$F0,$BC,$8,$BC,$18,$47,$60,$68,$FD,$F7,$72,$F8,$F0,$BC,$8,$BC
  DC.B $18,$47,$0,$0,$38,$4A,$0,$60,$AC,$1,$1,$0,$80,$B4,$81,$6,$4A
  DC.B $F,$A,$49,$4A,$60,$12,$1,$9,$4B,$1B,$68,$9F,$58,$D2,$18         *7e
  DC.B $80,$2F,$0,$60,$F,$60,$53,$68,$8B,$60,$43,$7,$5B,$F,$1,$3B,$0,$6,$C0
  DC.B $F,$8,$61,$4B,$61,$D3,$60,$80,$BC,$70,$47,$0,$0,$14,$54,$0,$40
  DC.B $F4,$0,$1,$0,$80,$B4,$B,$6,$1B,$E,$12,$6,$12,$E,$81,$6,$4F
  DC.B $F,$7,$49,$1,$3B,$1,$3A,$8A,$60,$88,$C1,$8,$39,$42,$7         *7f
  DC.B $C0,$2F,$0,$60,$52,$F,$1,$3A,$0,$6,$C0,$F,$8,$61,$4A,$61,$80,$BC,$70
  DC.B $47,$14,$54,$0,$40,$70,$47,$70,$47,$90,$B4,$14,$48,$2,$69,$14,$49
  DC.B $1,$2A,$8,$D1,$42,$68,$13,$1,$A,$68,$9F,$18,$7F,$68,$87,$60,$D2
  DC.B $58,$2,$60,$A,$E0,$82,$68,$43,$68,$1B,$1,$F,$68,$DB,$19         *80
  DC.B $0,$30,$0,$60,$5A,$60,$42,$68,$3,$68,$12,$1,$F,$68,$BB,$50,$42,$68,$13
  DC.B $1,$A,$68,$99,$18,$8F,$68,$40,$69,$6,$4C,$27,$54,$D2,$58,$6,$4B
  DC.B $1A,$54,$49,$68,$5,$4A,$11,$54,$90,$BC,$70,$47,$14,$54,$0,$40,$F4
  DC.B $0,$1,$0,$72,$2A,$0,$40,$7A,$2A,$0,$40,$82,$2A,$0,$40         *81
  DC.B $40,$30,$0,$60,$80,$B4,$C,$49,$1,$23,$4A,$69,$DA,$42,$5,$D1,$0,$22,$2
  DC.B $60,$9,$4A,$0,$23,$D2,$56,$2,$E0,$2,$60,$4A,$69,$1,$32,$42,$60
  DC.B $8A,$68,$6,$4F,$0,$23,$FB,$56,$5A,$43,$9,$68,$51,$18,$81,$60,$80
  DC.B $BC,$70,$47,$14,$54,$0,$40,$F0,$0,$1,$0,$EC,$0,$1,$0         *82
  DC.B $80,$30,$0,$60,$F0,$B5,$7,$6,$3F,$E,$83,$B0,$68,$46,$FF,$F7,$D9,$FF,$0
  DC.B $98,$10,$4C,$11,$4A,$1,$25,$15,$E0,$2,$99,$6,$1C,$23,$68,$5E,$43
  DC.B $8B,$19,$D9,$10,$16,$68,$89,$19,$5E,$7,$76,$F,$2B,$1C,$B3,$40,$0
  DC.B $2F,$2,$D0,$E,$78,$33,$43,$2,$E0,$E,$78,$DB,$43,$33,$40         *83
  DC.B $C0,$30,$0,$60,$B,$70,$1,$30,$1,$99,$81,$42,$E6,$DC,$3,$B0,$F0,$BC,$8
  DC.B $BC,$18,$47,$0,$0,$60,$2A,$0,$40,$C,$1,$1,$0,$B0,$B5,$7,$6
  DC.B $3F,$E,$C,$6,$24,$E,$83,$B0,$68,$46,$FF,$F7,$A9,$FF,$0,$98,$10
  DC.B $4A,$11,$49,$7,$E0,$3,$1C,$15,$68,$6B,$43,$2,$9D,$5B,$19         *84
  DC.B $0,$31,$0,$60,$D,$68,$EF,$54,$1,$30,$1,$9B,$83,$42,$F4,$DC,$20,$1C,$B
  DC.B $49,$9,$6D,$FC,$F7,$97,$FF,$A,$48,$0,$23,$C0,$56,$42,$1E,$9,$49
  DC.B $8,$68,$82,$42,$1,$D9,$1,$30,$8,$60,$3,$B0,$B0,$BC,$8,$BC,$18
  DC.B $47,$0,$0,$60,$2A,$0,$40,$8,$1,$1,$0,$AC,$4,$1,$0         *85
  DC.B $40,$31,$0,$60,$EC,$0,$1,$0,$14,$54,$0,$40,$F0,$B5,$81,$B0,$23,$4E,$F5
  DC.B $1D,$FF,$35,$7A,$35,$A8,$6F,$FC,$F7,$73,$FF,$0,$AB,$18,$70,$0,$98
  DC.B $80,$6,$41,$F,$1E,$48,$0,$23,$C0,$56,$1E,$4C,$81,$42,$6,$DA,$0
  DC.B $98,$40,$7,$40,$F,$1C,$49,$C9,$56,$88,$42,$4,$DD,$4,$20         *86
  DC.B $80,$31,$0,$60,$21,$69,$FC,$F7,$5F,$FF,$24,$E0,$80,$23,$DB,$43,$0,$98,$18
  DC.B $40,$0,$90,$A8,$6F,$FC,$F7,$54,$FF,$7,$1C,$A8,$6F,$FC,$F7,$50,$FF
  DC.B $1,$1C,$EC,$D0,$11,$48,$0,$23,$C0,$56,$1,$30,$88,$42,$E6,$DB,$0
  DC.B $2F,$E4,$D0,$E,$48,$C0,$56,$87,$42,$E0,$DC,$7,$23,$DB,$1         *87
  DC.B $C0,$31,$0,$60,$F4,$18,$0,$98,$E3,$6C,$3A,$1C,$FC,$F7,$40,$FF,$E0,$6B,$FC
  DC.B $F7,$37,$FF,$1,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$AC,$1,$1,$0
  DC.B $EF,$0,$1,$0,$2C,$4,$1,$0,$F0,$0,$1,$0,$EC,$0,$1,$0,$ED
  DC.B $0,$1,$0,$80,$B4,$0,$6,$0,$E,$9,$6,$9,$E,$8,$4A         *88
  DC.B $0,$32,$0,$60,$52,$69,$8,$4B,$1B,$68,$5A,$43,$7,$4F,$0,$23,$FB,$56,$59
  DC.B $43,$51,$18,$8,$18,$5,$49,$9,$68,$8,$5C,$80,$BC,$70,$47,$0,$0
  DC.B $14,$54,$0,$40,$60,$2A,$0,$40,$EC,$0,$1,$0,$8,$1,$1,$0,$80
  DC.B $B4,$0,$6,$0,$E,$9,$6,$9,$E,$C,$4A,$52,$69,$C,$4B         *89
  DC.B $40,$32,$0,$60,$1B,$68,$5A,$43,$B,$4F,$0,$23,$FB,$56,$59,$43,$51,$18,$8
  DC.B $18,$C1,$10,$9,$4A,$12,$68,$51,$5C,$42,$7,$52,$F,$1,$20,$3,$1C
  DC.B $93,$40,$19,$40,$0,$D1,$0,$20,$80,$BC,$70,$47,$14,$54,$0,$40,$60
  DC.B $2A,$0,$40,$EC,$0,$1,$0,$C,$1,$1,$0,$0,$B5,$3,$20         *8a
  DC.B $80,$32,$0,$60,$0,$F0,$14,$F8,$8,$BC,$18,$47,$0,$B5,$2,$20,$0,$F0,$E
  DC.B $F8,$8,$BC,$18,$47,$0,$B5,$1,$20,$0,$F0,$8,$F8,$8,$BC,$18,$47
  DC.B $0,$B5,$0,$20,$0,$F0,$2,$F8,$8,$BC,$18,$47,$F0,$B5,$4,$1C,$87
  DC.B $B0,$35,$48,$6,$90,$80,$6F,$FC,$F7,$C2,$FE,$45,$1E,$33,$4F         *8b
  DC.B $C0,$32,$0,$60,$38,$68,$0,$90,$41,$19,$32,$4A,$0,$23,$D2,$56,$2,$3A,$91
  DC.B $42,$0,$D9,$15,$1A,$61,$8,$2,$D3,$0,$26,$1,$22,$2,$E0,$0,$22
  DC.B $D2,$43,$2E,$1C,$1,$92,$2,$21,$21,$40,$2A,$4C,$6,$D0,$6,$98,$80
  DC.B $6F,$FC,$F7,$A5,$FE,$3,$90,$0,$20,$B,$E0,$80,$19,$B9,$68         *8c
  DC.B $0,$33,$0,$60,$62,$6C,$FC,$F7,$A1,$FE,$3,$90,$38,$68,$B9,$68,$80,$19,$22
  DC.B $6C,$FC,$F7,$9A,$FE,$2,$90,$38,$68,$80,$19,$0,$26,$38,$60,$1E,$4A
  DC.B $5,$92,$1,$9A,$50,$1E,$4,$90,$1A,$E0,$38,$68,$B9,$68,$1,$9A,$80
  DC.B $18,$22,$6C,$FC,$F7,$88,$FE,$81,$B0,$0,$90,$38,$68,$B9,$68         *8d
  DC.B $40,$33,$0,$60,$2,$9A,$80,$18,$62,$6C,$FC,$F7,$7F,$FE,$0,$99,$1,$B0,$5
  DC.B $9A,$92,$6C,$FC,$F7,$79,$FE,$4,$98,$39,$68,$40,$18,$38,$60,$1,$36
  DC.B $AE,$42,$E2,$DB,$3,$98,$2,$99,$5,$9A,$92,$6C,$FC,$F7,$6C,$FE,$0
  DC.B $98,$40,$19,$1,$30,$38,$60,$E0,$6B,$FC,$F7,$61,$FE,$7,$B0         *8e
  DC.B $80,$33,$0,$60,$F0,$BC,$8,$BC,$18,$47,$0,$0,$2C,$3,$1,$0,$14,$54,$0
  DC.B $40,$EC,$0,$1,$0,$2C,$5,$1,$0,$AC,$4,$1,$0,$F0,$B5,$82,$B0
  DC.B $29,$48,$1,$90,$C4,$1D,$FF,$34,$7A,$34,$A0,$6F,$FC,$F7,$48,$FE,$7
  DC.B $1C,$A0,$6F,$FC,$F7,$44,$FE,$1,$1C,$24,$48,$13,$D0,$0,$2F         *8f
  DC.B $C0,$33,$0,$60,$11,$D0,$7A,$1E,$17,$6,$3F,$E,$1,$39,$9,$6,$9,$E,$C9
  DC.B $19,$A,$6,$12,$E,$0,$92,$1E,$49,$0,$23,$C9,$56,$8F,$42,$2,$DA
  DC.B $0,$9A,$8A,$42,$7,$DB,$1,$69,$9,$20,$FC,$F7,$2B,$FE,$2,$B0,$F0
  DC.B $BC,$8,$BC,$18,$47,$17,$4E,$17,$4C,$14,$E0,$0,$20,$A7,$60         *90
  DC.B $0,$34,$0,$60,$0,$25,$20,$60,$7,$E0,$0,$21,$20,$20,$B2,$6C,$FC,$F7,$1C
  DC.B $FE,$68,$1C,$5,$6,$2D,$E,$11,$48,$0,$23,$C0,$56,$85,$42,$F2,$DB
  DC.B $78,$1C,$7,$6,$3F,$E,$0,$98,$87,$42,$E7,$DD,$0,$20,$20,$60,$7
  DC.B $23,$DB,$1,$1,$98,$C0,$18,$C0,$6B,$FC,$F7,$1,$FE,$2,$B0         *91
  DC.B $40,$34,$0,$60,$F0,$BC,$8,$BC,$18,$47,$0,$0,$AC,$1,$1,$0,$2C,$4,$1
  DC.B $0,$ED,$0,$1,$0,$AC,$4,$1,$0,$14,$54,$0,$40,$EC,$0,$1,$0
  DC.B $F0,$B5,$82,$B0,$17,$48,$1,$90,$FF,$30,$81,$30,$80,$6F,$FC,$F7,$E7
  DC.B $FD,$4,$1C,$14,$48,$0,$90,$0,$68,$6,$6,$36,$E,$21,$18         *92
  DC.B $80,$34,$0,$60,$12,$4A,$0,$23,$D2,$56,$91,$42,$2,$D9,$10,$1A,$4,$6,$24
  DC.B $E,$0,$27,$F,$4D,$7,$E0,$0,$21,$20,$20,$AA,$6C,$FC,$F7,$D4,$FD
  DC.B $78,$1C,$7,$6,$3F,$E,$A7,$42,$F5,$DB,$0,$98,$6,$60,$7,$23,$DB
  DC.B $1,$1,$98,$C0,$18,$C0,$6B,$FC,$F7,$C2,$FD,$2,$B0,$F0,$BC         *93
  DC.B $C0,$34,$0,$60,$8,$BC,$18,$47,$AC,$1,$1,$0,$14,$54,$0,$40,$EC,$0,$1
  DC.B $0,$AC,$4,$1,$0,$0,$B5,$1,$20,$0,$F0,$8,$F8,$8,$BC,$18,$47
  DC.B $0,$B5,$0,$20,$0,$F0,$2,$F8,$8,$BC,$18,$47,$F1,$B5,$81,$B0,$16
  DC.B $48,$0,$90,$FF,$30,$81,$30,$80,$6F,$FC,$F7,$A1,$FD,$4,$1C         *94
  DC.B $0,$35,$0,$60,$13,$4D,$28,$68,$1,$19,$13,$4A,$0,$23,$D2,$56,$91,$42,$2
  DC.B $D9,$10,$1A,$4,$6,$24,$E,$0,$27,$F,$4E,$9,$E0,$1,$98,$31,$6D
  DC.B $FC,$F7,$90,$FD,$28,$68,$1,$30,$28,$60,$78,$1C,$7,$6,$3F,$E,$A7
  DC.B $42,$F3,$DB,$7,$23,$DB,$1,$0,$98,$C0,$18,$C0,$6B,$FC,$F7         *95
  DC.B $40,$35,$0,$60,$7F,$FD,$1,$B0,$F8,$BC,$8,$BC,$18,$47,$0,$0,$AC,$1,$1
  DC.B $0,$14,$54,$0,$40,$EC,$0,$1,$0,$AC,$4,$1,$0,$1,$21,$4,$48
  DC.B $40,$68,$0,$1,$3,$4A,$12,$68,$80,$18,$81,$60,$70,$47,$0,$0,$14
  DC.B $54,$0,$40,$F4,$0,$1,$0,$0,$21,$4,$48,$40,$68,$0,$1         *96
  DC.B $80,$35,$0,$60,$3,$4A,$12,$68,$80,$18,$81,$60,$70,$47,$0,$0,$14,$54,$0
  DC.B $40,$F4,$0,$1,$0,$90,$B5,$0,$20,$0,$F0,$A,$F9,$0,$20,$FD,$27
  DC.B $9,$49,$A,$4A,$6,$23,$4C,$69,$63,$43,$1B,$18,$5B,$0,$94,$68,$1B
  DC.B $19,$5F,$70,$1,$30,$6,$28,$F4,$DB,$48,$69,$0,$F0,$E6,$FA         *97
  DC.B $C0,$35,$0,$60,$90,$BC,$8,$BC,$18,$47,$0,$0,$14,$54,$0,$40,$60,$2A,$0
  DC.B $40,$90,$B5,$81,$B0,$21,$4C,$E0,$1D,$FF,$30,$7A,$30,$80,$6F,$FC,$F7
  DC.B $2F,$FD,$0,$AB,$18,$70,$0,$98,$80,$6,$40,$F,$1C,$49,$0,$23,$C9
  DC.B $56,$88,$42,$9,$DA,$0,$99,$49,$7,$49,$F,$19,$4A,$D2,$56         *98
  DC.B $0,$36,$0,$60,$91,$42,$2,$DC,$0,$99,$49,$7,$7,$D1,$5,$23,$DB,$1,$E0
  DC.B $18,$1,$69,$2C,$20,$FC,$F7,$16,$FD,$1C,$E0,$0,$27,$1,$1,$12,$48
  DC.B $2,$68,$57,$50,$0,$99,$89,$6,$49,$F,$9,$1,$0,$68,$8,$18,$47
  DC.B $60,$7,$23,$DB,$1,$E1,$18,$0,$98,$89,$6C,$FC,$F7,$2,$FD         *99
  DC.B $40,$36,$0,$60,$A,$48,$7,$61,$1,$20,$0,$F0,$B3,$F8,$0,$98,$40,$7,$40
  DC.B $F,$0,$F0,$E,$F8,$1,$B0,$90,$BC,$8,$BC,$18,$47,$AC,$1,$1,$0
  DC.B $EF,$0,$1,$0,$F0,$0,$1,$0,$F4,$0,$1,$0,$14,$54,$0,$40,$F0
  DC.B $B5,$6,$6,$36,$E,$0,$27,$81,$B0,$11,$49,$0,$91,$11,$4C         *9a
  DC.B $80,$36,$0,$60,$E0,$19,$20,$30,$0,$7F,$B0,$42,$12,$D1,$4,$21,$B,$20,$78
  DC.B $43,$0,$19,$41,$70,$81,$78,$1,$31,$81,$70,$B8,$0,$5,$19,$E8,$6A
  DC.B $0,$28,$5,$D0,$0,$99,$9,$68,$FC,$F7,$CC,$FC,$0,$20,$E8,$62,$1
  DC.B $37,$4,$2F,$E4,$DB,$1,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0         *9b
  DC.B $C0,$36,$0,$60,$34,$48,$0,$60,$2C,$54,$0,$40,$0,$B5,$81,$B0,$6,$48,$80
  DC.B $6F,$FC,$F7,$B6,$FC,$0,$AB,$18,$70,$0,$98,$40,$7,$40,$F,$FF,$F7
  DC.B $C7,$FF,$1,$B0,$8,$BC,$18,$47,$2C,$3,$1,$0,$F0,$B5,$83,$B0,$2C
  DC.B $4E,$F7,$1D,$FF,$37,$7A,$37,$B8,$6F,$FC,$F7,$A1,$FC,$4,$1C         *9c
  DC.B $0,$37,$0,$60,$B8,$6F,$FC,$F7,$9D,$FC,$5,$1C,$B8,$6F,$FC,$F7,$99,$FC,$1
  DC.B $1C,$38,$20,$20,$40,$C0,$8,$0,$6,$0,$16,$62,$7,$52,$F,$12,$6
  DC.B $12,$16,$0,$2D,$3,$D0,$0,$29,$1,$D0,$0,$28,$A,$D1,$5,$23,$DB
  DC.B $1,$F0,$18,$1,$69,$11,$20,$FC,$F7,$84,$FC,$3,$B0,$F0,$BC         *9d
  DC.B $40,$37,$0,$60,$8,$BC,$18,$47,$18,$4C,$63,$69,$1B,$6,$1B,$E,$0,$93,$1
  DC.B $39,$A1,$60,$0,$21,$0,$27,$1,$38,$21,$60,$2,$90,$50,$1E,$1,$90
  DC.B $1,$3D,$13,$E0,$2,$98,$60,$61,$38,$1C,$29,$1C,$FF,$F7,$42,$FD,$6
  DC.B $1C,$38,$1C,$29,$1C,$FF,$F7,$5B,$FD,$1,$1C,$1,$98,$60,$61         *9e
  DC.B $80,$37,$0,$60,$30,$1C,$FF,$F7,$AB,$FC,$78,$1C,$7,$6,$3F,$E,$7,$48,$0
  DC.B $23,$C0,$56,$87,$42,$E6,$DB,$0,$9B,$63,$61,$3,$B0,$F0,$BC,$8,$BC
  DC.B $18,$47,$0,$0,$AC,$1,$1,$0,$14,$54,$0,$40,$EC,$0,$1,$0,$F0
  DC.B $B5,$82,$B0,$1D,$49,$0,$28,$3,$D0,$0,$23,$C8,$56,$2,$38         *9f
  DC.B $C0,$37,$0,$60,$1,$E0,$0,$23,$C8,$56,$0,$6,$0,$E,$0,$90,$0,$24,$18
  DC.B $48,$1,$90,$3,$23,$1B,$2,$C6,$18,$16,$4F,$14,$E0,$0,$20,$BC,$60
  DC.B $0,$25,$38,$60,$7,$E0,$0,$21,$20,$20,$B2,$6C,$FC,$F7,$2C,$FC,$68
  DC.B $1C,$5,$6,$2D,$E,$10,$48,$0,$23,$C0,$56,$85,$42,$F2,$DB         *a0
  DC.B $0,$38,$0,$60,$60,$1C,$4,$6,$24,$E,$0,$98,$84,$42,$E7,$DB,$0,$20,$38
  DC.B $60,$B8,$60,$38,$61,$7,$23,$DB,$1,$1,$98,$C0,$18,$C0,$6B,$FC,$F7
  DC.B $F,$FC,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$ED,$0,$1,$0,$AC
  DC.B $1,$1,$0,$14,$54,$0,$40,$EC,$0,$1,$0,$F0,$B5,$0,$24         *a1
  DC.B $40,$38,$0,$60,$86,$B0,$56,$4A,$5,$92,$D,$E0,$B,$20,$60,$43,$5,$9A,$80
  DC.B $18,$1,$79,$0,$29,$3,$D1,$81,$78,$C0,$78,$81,$42,$4,$D0,$60,$1C
  DC.B $4,$6,$24,$E,$4,$2C,$EF,$DB,$4D,$48,$5,$23,$DB,$1,$C5,$18,$4
  DC.B $2C,$4E,$D0,$38,$23,$DB,$43,$0,$99,$19,$40,$49,$4A,$4,$92         *a2
  DC.B $80,$38,$0,$60,$52,$68,$52,$7,$52,$F,$D2,$0,$11,$43,$0,$91,$C9,$8,$C9
  DC.B $0,$4,$9A,$52,$69,$1,$32,$52,$7,$52,$F,$11,$43,$0,$91,$80,$23
  DC.B $DB,$43,$19,$40,$4,$9A,$12,$69,$D2,$7,$12,$E,$11,$43,$0,$91,$5B
  DC.B $10,$19,$40,$0,$91,$C6,$1D,$FF,$36,$7A,$36,$B0,$6F,$FC,$F7         *a3
  DC.B $C0,$38,$0,$60,$BF,$FB,$3,$90,$B0,$6F,$FC,$F7,$BB,$FB,$2,$90,$B0,$6F,$FC
  DC.B $F7,$B7,$FB,$1,$90,$34,$48,$0,$68,$FC,$F7,$B2,$FB,$7,$1C,$1,$20
  DC.B $F8,$72,$0,$A9,$9,$78,$39,$73,$4,$99,$89,$68,$9,$18,$79,$73,$4
  DC.B $99,$9,$68,$9,$18,$B9,$73,$3,$99,$F9,$73,$78,$71,$5,$20         *a4
  DC.B $0,$39,$0,$60,$F8,$71,$0,$20,$B8,$72,$F0,$6F,$FC,$F7,$9A,$FB,$1,$99,$88
  DC.B $42,$7,$D2,$13,$20,$29,$69,$FC,$F7,$95,$FB,$6,$B0,$F0,$BC,$8,$BC
  DC.B $18,$47,$0,$25,$10,$E0,$1,$99,$8D,$42,$4,$DA,$B0,$6F,$FC,$F7,$87
  DC.B $FB,$2,$1C,$0,$E0,$20,$22,$F8,$79,$41,$1C,$F9,$71,$C0,$19         *a5
  DC.B $40,$39,$0,$60,$C2,$72,$68,$1C,$5,$6,$2D,$E,$3,$99,$8D,$42,$EB,$DB,$5
  DC.B $E0,$B0,$6F,$FC,$F7,$75,$FB,$68,$1C,$5,$6,$2D,$E,$1,$99,$8D,$42
  DC.B $F6,$DB,$A0,$0,$5,$9A,$80,$18,$C7,$62,$2,$98,$83,$0,$18,$18,$B
  DC.B $21,$61,$43,$5,$9A,$50,$54,$3,$20,$5,$9A,$89,$18,$48,$70         *a6
  DC.B $80,$39,$0,$60,$88,$78,$1,$30,$88,$70,$4,$99,$48,$69,$5,$9A,$11,$19,$1
  DC.B $30,$20,$31,$8,$77,$6,$B0,$F0,$BC,$8,$BC,$18,$47,$2C,$54,$0,$40
  DC.B $AC,$1,$1,$0,$14,$54,$0,$40,$38,$48,$0,$60,$0,$B5,$5,$48,$80
  DC.B $6F,$FC,$F7,$45,$FB,$1,$22,$1,$1C,$14,$20,$0,$F0,$84,$FA         *a7
  DC.B $C0,$39,$0,$60,$8,$BC,$18,$47,$2C,$3,$1,$0,$F0,$B5,$84,$B0,$35,$49,$3
  DC.B $91,$C8,$1D,$FF,$30,$7A,$30,$2,$90,$80,$6F,$FC,$F7,$31,$FB,$5,$1C
  DC.B $2,$98,$80,$6F,$FC,$F7,$2C,$FB,$4,$1C,$2F,$4E,$FD,$2D,$5,$DC,$2
  DC.B $98,$C0,$6F,$FC,$F7,$24,$FB,$A0,$42,$3,$D2,$15,$20,$31,$69         *a8
  DC.B $0,$3A,$0,$60,$FC,$F7,$20,$FB,$A8,$0,$1,$90,$28,$49,$0,$91,$C9,$6A,$F
  DC.B $58,$0,$2F,$6,$D0,$31,$6D,$38,$1C,$FC,$F7,$14,$FB,$A0,$42,$0,$DA
  DC.B $0,$27,$0,$2F,$12,$D1,$3,$99,$80,$31,$C9,$6D,$60,$1C,$FC,$F7,$9
  DC.B $FB,$1,$99,$0,$9A,$D2,$6A,$50,$50,$FB,$43,$98,$42,$4,$D1         *a9
  DC.B $40,$3A,$0,$60,$15,$20,$31,$69,$FC,$F7,$FE,$FA,$27,$E0,$7,$1C,$0,$26,$6
  DC.B $E0,$2,$98,$80,$6F,$FC,$F7,$F4,$FA,$38,$70,$1,$36,$1,$37,$A6,$42
  DC.B $F6,$DB,$0,$20,$38,$70,$0,$27,$11,$4C,$12,$E0,$0,$20,$6,$22,$7A
  DC.B $43,$E,$49,$89,$68,$13,$18,$5B,$0,$5B,$18,$5B,$78,$AB,$42         *aa
  DC.B $80,$3A,$0,$60,$3,$D1,$38,$1C,$0,$F0,$82,$F8,$2,$E0,$1,$30,$6,$28,$F2
  DC.B $DB,$1,$37,$0,$23,$E0,$56,$87,$42,$E8,$DB,$4,$B0,$F0,$BC,$8,$BC
  DC.B $18,$47,$0,$0,$AC,$1,$1,$0,$2C,$4,$1,$0,$60,$2A,$0,$40,$F0
  DC.B $0,$1,$0,$F0,$B5,$83,$B0,$21,$48,$2,$90,$C4,$1D,$FF,$34         *ab
  DC.B $C0,$3A,$0,$60,$7A,$34,$A0,$6F,$FC,$F7,$BC,$FA,$F8,$23,$6,$1C,$18,$40,$C5
  DC.B $8,$28,$1C,$0,$F0,$87,$FA,$1B,$4F,$78,$69,$0,$90,$70,$7,$40,$F
  DC.B $41,$1E,$FF,$20,$6,$23,$79,$61,$59,$43,$49,$19,$49,$0,$16,$4A,$92
  DC.B $68,$89,$18,$20,$39,$C8,$77,$A0,$6F,$FC,$F7,$A1,$FA,$5,$1C         *ac
  DC.B $0,$3B,$0,$60,$3,$23,$1B,$2,$2,$98,$C1,$18,$1,$91,$8A,$6C,$0,$21,$20
  DC.B $20,$FC,$F7,$9A,$FA,$0,$26,$AE,$42,$3,$DA,$A0,$6F,$FC,$F7,$90,$FA
  DC.B $0,$E0,$20,$20,$1,$99,$8A,$6C,$0,$21,$FC,$F7,$8D,$FA,$1,$36,$C
  DC.B $2E,$F0,$DB,$0,$98,$78,$61,$3,$B0,$F0,$BC,$8,$BC,$18,$47         *ad
  DC.B $40,$3B,$0,$60,$AC,$1,$1,$0,$14,$54,$0,$40,$60,$2A,$0,$40,$80,$B5,$D
  DC.B $48,$80,$6F,$FC,$F7,$75,$FA,$FD,$27,$41,$7,$49,$F,$4A,$0,$52,$18
  DC.B $52,$0,$F8,$23,$18,$40,$C0,$8,$10,$18,$40,$0,$6,$4A,$92,$68,$80
  DC.B $18,$20,$38,$C7,$74,$48,$1E,$0,$F0,$8,$F8,$80,$BC,$8,$BC         *ae
  DC.B $80,$3B,$0,$60,$18,$47,$0,$0,$2C,$3,$1,$0,$60,$2A,$0,$40,$F0,$B5,$85
  DC.B $B0,$27,$49,$4,$91,$49,$69,$0,$91,$4,$99,$0,$27,$48,$61,$6,$21
  DC.B $41,$43,$3,$91,$23,$48,$2,$90,$23,$4C,$24,$4E,$4,$98,$40,$69,$6
  DC.B $23,$58,$43,$C0,$19,$40,$0,$A1,$68,$40,$18,$45,$78,$78,$1C         *af
  DC.B $C0,$3B,$0,$60,$1,$90,$0,$F0,$F,$FA,$FD,$2D,$14,$D0,$FE,$2D,$1C,$D0,$FF
  DC.B $2D,$24,$D0,$A8,$0,$E1,$6A,$F,$58,$0,$21,$20,$20,$B2,$6C,$FC,$F7
  DC.B $33,$FA,$0,$2F,$0,$D1,$16,$A7,$0,$25,$38,$78,$0,$28,$D,$D0,$1
  DC.B $37,$C,$E0,$0,$20,$3,$99,$C9,$19,$49,$0,$A2,$68,$50,$54         *b0
  DC.B $0,$3C,$0,$60,$2,$98,$0,$68,$0,$21,$4,$DF,$0,$27,$E5,$E7,$20,$20,$0
  DC.B $21,$B2,$6C,$FC,$F7,$19,$FA,$1,$35,$C,$2D,$E6,$DB,$1,$9F,$6,$2F
  DC.B $C4,$DB,$0,$98,$4,$99,$48,$61,$5,$B0,$F0,$BC,$8,$BC,$18,$47,$14
  DC.B $54,$0,$40,$AC,$2A,$0,$40,$60,$2A,$0,$40,$AC,$4,$1,$0         *b1
  DC.B $40,$3C,$0,$60,$20,$0,$0,$0,$80,$B5,$B,$48,$40,$69,$1,$23,$D8,$42,$5
  DC.B $D1,$9,$48,$1,$69,$18,$20,$FC,$F7,$F5,$F9,$1,$E0,$7,$49,$8,$70
  DC.B $7,$4F,$1,$21,$38,$68,$4,$DF,$0,$21,$38,$68,$4,$DF,$80,$BC,$8
  DC.B $BC,$18,$47,$14,$54,$0,$40,$2C,$4,$1,$0,$4,$1,$1,$0         *b2
  DC.B $80,$3C,$0,$60,$AC,$2A,$0,$40,$0,$B5,$82,$B0,$1E,$48,$80,$6F,$FC,$F7,$D8
  DC.B $F9,$0,$AB,$18,$70,$0,$98,$80,$6,$40,$F,$1B,$49,$2,$1,$48,$60
  DC.B $1A,$4B,$1B,$68,$D2,$18,$D2,$68,$1,$9B,$DB,$8,$DB,$0,$1,$32,$52
  DC.B $7,$52,$F,$1A,$43,$1,$92,$38,$23,$DB,$43,$1A,$40,$C0,$0         *b3
  DC.B $C0,$3C,$0,$60,$10,$43,$1,$90,$40,$23,$DB,$43,$18,$40,$1,$90,$80,$23,$DB
  DC.B $43,$18,$40,$1,$90,$4,$22,$E,$48,$82,$70,$1,$AA,$12,$78,$C2,$70
  DC.B $8A,$68,$1,$32,$2,$71,$9,$68,$1,$31,$41,$71,$0,$20,$9,$49,$8
  DC.B $70,$9,$48,$1,$23,$5B,$2,$1,$68,$19,$43,$1,$60,$2,$B0         *b4
  DC.B $0,$3D,$0,$60,$8,$BC,$18,$47,$2C,$3,$1,$0,$14,$54,$0,$40,$F4,$0,$1
  DC.B $0,$EC,$5,$1,$0,$C4,$0,$1,$0,$BC,$0,$1,$0,$F0,$B5,$82,$B0
  DC.B $31,$48,$1,$90,$C4,$1D,$FF,$34,$7A,$34,$A0,$6F,$FC,$F7,$88,$F9,$0
  DC.B $AB,$18,$70,$0,$98,$80,$6,$41,$F,$2C,$48,$0,$23,$C0,$56         *b5
  DC.B $40,$3D,$0,$60,$2B,$4F,$81,$42,$27,$DA,$0,$98,$40,$7,$40,$F,$29,$49,$C9
  DC.B $56,$88,$42,$20,$DC,$40,$23,$0,$98,$18,$40,$FE,$1D,$F9,$36,$0,$28
  DC.B $26,$D1,$E0,$6F,$FC,$F7,$6C,$F9,$2,$28,$14,$D3,$A0,$6F,$FC,$F7,$67
  DC.B $F9,$5,$1C,$A0,$6F,$FC,$F7,$63,$F9,$1,$1C,$B,$D0,$1E,$48         *b6
  DC.B $80,$3D,$0,$60,$0,$23,$C0,$56,$1,$30,$88,$42,$5,$DB,$0,$2D,$3,$D0,$1B
  DC.B $48,$C0,$56,$85,$42,$7,$DD,$2A,$20,$39,$69,$FC,$F7,$53,$F9,$2,$B0
  DC.B $F0,$BC,$8,$BC,$18,$47,$0,$98,$F3,$6C,$2A,$1C,$FC,$F7,$4E,$F9,$0
  DC.B $98,$0,$6,$C0,$F,$12,$4F,$38,$61,$38,$68,$0,$28,$B,$D9         *b7
  DC.B $C0,$3D,$0,$60,$44,$1E,$3C,$60,$3,$23,$1B,$2,$1,$98,$C0,$18,$0,$21,$82
  DC.B $6C,$20,$20,$FC,$F7,$39,$F9,$3C,$60,$F0,$6B,$FC,$F7,$31,$F9,$2,$B0
  DC.B $F0,$BC,$8,$BC,$18,$47,$0,$0,$AC,$1,$1,$0,$EF,$0,$1,$0,$2C
  DC.B $4,$1,$0,$F0,$0,$1,$0,$EC,$0,$1,$0,$ED,$0,$1,$0         *b8
  DC.B $0,$3E,$0,$60,$14,$54,$0,$40,$90,$B5,$8,$4C,$A0,$6F,$FC,$F7,$19,$F9,$7
  DC.B $1C,$A0,$6F,$FC,$F7,$15,$F9,$2,$1C,$2D,$20,$39,$1C,$0,$F0,$54,$F8
  DC.B $90,$BC,$8,$BC,$18,$47,$0,$0,$2C,$3,$1,$0,$F7,$B5,$4,$6,$24
  DC.B $E,$84,$B0,$0,$94,$0,$21,$1D,$4F,$3,$97,$1D,$4F,$2,$97         *b9
  DC.B $40,$3E,$0,$60,$1,$26,$1D,$4A,$1,$92,$26,$E0,$0,$20,$18,$E0,$3,$9F,$3C
  DC.B $68,$F,$1C,$67,$43,$0,$9C,$5C,$43,$3B,$19,$1B,$18,$2,$9F,$3F,$68
  DC.B $FA,$54,$DF,$10,$1,$9A,$12,$68,$D4,$5D,$5D,$7,$6D,$F,$33,$1C,$AB
  DC.B $40,$DB,$43,$23,$40,$D3,$55,$1,$30,$0,$6,$0,$E,$F,$4A         *ba
  DC.B $80,$3E,$0,$60,$0,$23,$D3,$56,$98,$42,$3,$DA,$6,$9A,$12,$5C,$0,$2A,$DD
  DC.B $D1,$48,$1C,$1,$6,$9,$E,$A,$48,$0,$23,$C0,$56,$81,$42,$D3,$DB
  DC.B $8,$48,$0,$68,$1,$21,$4,$DF,$4,$B0,$FE,$BC,$8,$BC,$18,$47,$60
  DC.B $2A,$0,$40,$8,$1,$1,$0,$C,$1,$1,$0,$EC,$0,$1,$0         *bb
  DC.B $C0,$3E,$0,$60,$F0,$0,$1,$0,$AC,$2A,$0,$40,$F0,$B5,$F8,$23,$B,$40,$DD
  DC.B $8,$AB,$18,$1,$3B,$82,$B0,$19,$4F,$6,$2B,$9,$DD,$1,$23,$DB,$3
  DC.B $18,$43,$5,$23,$DB,$1,$F9,$18,$9,$69,$FC,$F7,$AB,$F8,$20,$E0,$48
  DC.B $7,$40,$F,$1,$38,$4,$6,$24,$E,$6,$20,$60,$43,$80,$18         *bc
  DC.B $0,$3F,$0,$60,$0,$27,$46,$1E,$E,$48,$1,$90,$E,$4A,$0,$92,$C,$E0,$1
  DC.B $98,$80,$6F,$FC,$F7,$95,$F8,$F1,$19,$49,$0,$0,$9A,$92,$68,$89,$18
  DC.B $48,$70,$78,$1C,$7,$6,$3F,$E,$AF,$42,$F0,$DB,$20,$1C,$FF,$F7,$2D
  DC.B $FE,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$AC,$1,$1,$0         *bd
  DC.B $40,$3F,$0,$60,$2C,$3,$1,$0,$60,$2A,$0,$40,$B0,$B4,$21,$4A,$12,$68,$52
  DC.B $6,$12,$F,$6,$2A,$39,$D1,$1F,$4C,$22,$78,$6,$23,$5A,$43,$12,$18
  DC.B $53,$0,$1D,$4F,$BA,$68,$9B,$18,$20,$3B,$9D,$7F,$0,$2D,$2C,$D0,$0
  DC.B $29,$2,$D0,$2,$20,$98,$77,$23,$E0,$0,$21,$17,$4D,$0,$23         *be
  DC.B $80,$3F,$0,$60,$ED,$56,$1C,$E0,$6,$23,$4B,$43,$1B,$18,$5B,$0,$9B,$18,$20
  DC.B $3B,$9B,$7F,$2,$2B,$10,$D1,$1,$25,$6,$23,$59,$43,$9,$18,$49,$0
  DC.B $89,$18,$20,$39,$8D,$77,$21,$78,$59,$43,$8,$18,$40,$0,$B9,$68,$40
  DC.B $18,$20,$38,$85,$77,$4,$E0,$1,$31,$9,$6,$9,$E,$A9,$42         *bf
  DC.B $C0,$3F,$0,$60,$E0,$DB,$7,$48,$0,$68,$0,$21,$4,$DF,$B0,$BC,$70,$47,$0
  DC.B $0,$3C,$0,$1,$0,$4,$1,$1,$0,$60,$2A,$0,$40,$F0,$0,$1,$0
  DC.B $AC,$2A,$0,$40,$B0,$B5,$1,$25,$47,$1E,$E,$4C,$3,$20,$25,$61,$39
  DC.B $1C,$FC,$F7,$51,$F8,$D,$23,$59,$43,$2,$30,$A0,$60,$21,$60         *c0
  DC.B $0,$40,$0,$60,$6,$23,$60,$69,$58,$43,$C0,$19,$40,$0,$7,$49,$89,$68,$A
  DC.B $5C,$0,$2A,$4,$D1,$D,$54,$5,$48,$0,$68,$0,$21,$4,$DF,$B0,$BC
  DC.B $8,$BC,$18,$47,$14,$54,$0,$40,$60,$2A,$0,$40,$AC,$2A,$0,$40,$F0
  DC.B $B5,$81,$B0,$26,$48,$0,$90,$C7,$1D,$FF,$37,$7A,$37,$B8,$6F         *c1
  DC.B $40,$40,$0,$60,$FB,$F7,$FE,$FF,$4,$1C,$B8,$6F,$FB,$F7,$FA,$FF,$6,$1C,$B8
  DC.B $6F,$FB,$F7,$F6,$FF,$5,$1C,$1F,$48,$0,$68,$40,$6,$0,$F,$6,$28
  DC.B $1,$D0,$7,$2C,$E,$DC,$6,$28,$3,$D1,$B4,$2C,$A,$DC,$A2,$2C,$8
  DC.B $DB,$8,$2E,$6,$D1,$8,$2D,$4,$D1,$F8,$6F,$FB,$F7,$E0,$FF         *c2
  DC.B $80,$40,$0,$60,$8,$28,$7,$D2,$0,$98,$FF,$30,$FF,$30,$82,$30,$1,$69,$30
  DC.B $20,$FB,$F7,$D8,$FF,$10,$4E,$3,$21,$30,$68,$4,$DF,$8,$20,$5,$DF
  DC.B $39,$6C,$20,$1C,$FB,$F7,$CE,$FF,$0,$24,$8,$E0,$B8,$6F,$FB,$F7,$C7
  DC.B $FF,$B9,$6B,$FB,$F7,$C6,$FF,$60,$1C,$4,$6,$24,$E,$AC,$42         *c3
  DC.B $C0,$40,$0,$60,$F4,$DB,$4,$21,$30,$68,$4,$DF,$1,$B0,$F0,$BC,$8,$BC,$18
  DC.B $47,$AC,$1,$1,$0,$3C,$0,$1,$0,$AC,$2A,$0,$40,$F0,$B5,$16,$48
  DC.B $0,$68,$40,$6,$0,$F,$6,$28,$1B,$D1,$0,$27,$13,$4E,$14,$4D,$14
  DC.B $4C,$30,$78,$6,$23,$58,$43,$C0,$19,$40,$0,$A9,$68,$8,$5C         *c4
  DC.B $0,$41,$0,$60,$E1,$5D,$81,$42,$A,$D0,$E0,$55,$E0,$5D,$0,$28,$C,$D0,$1
  DC.B $28,$E,$D0,$2,$28,$2,$D1,$78,$1C,$FE,$F7,$72,$FD,$1,$37,$6,$2F
  DC.B $E7,$DB,$F0,$BC,$8,$BC,$18,$47,$78,$1C,$FE,$F7,$5D,$FD,$F5,$E7,$78
  DC.B $1C,$FE,$F7,$4B,$FD,$F1,$E7,$3C,$0,$1,$0,$4,$1,$1,$0         *c5
  DC.B $40,$41,$0,$60,$60,$2A,$0,$40,$6C,$2A,$0,$40,$F0,$B5,$0,$27,$82,$B0,$15
  DC.B $4E,$15,$48,$1,$90,$15,$48,$0,$90,$15,$4C,$1D,$E0,$B,$20,$78,$43
  DC.B $0,$19,$41,$79,$0,$29,$14,$D0,$82,$79,$C1,$79,$8A,$42,$10,$D0,$1
  DC.B $31,$C1,$71,$B8,$0,$5,$19,$EA,$6A,$1,$98,$3,$68,$1,$20         *c6
  DC.B $80,$41,$0,$60,$31,$1C,$FB,$F7,$63,$FF,$0,$20,$E8,$62,$0,$98,$0,$68,$0
  DC.B $21,$4,$DF,$78,$1C,$7,$6,$3F,$E,$4,$2F,$DF,$DB,$2,$B0,$F0,$BC
  DC.B $8,$BC,$18,$47,$F0,$3D,$0,$40,$30,$48,$0,$60,$94,$2A,$0,$40,$2C
  DC.B $54,$0,$40,$B0,$B4,$0,$20,$0,$21,$16,$4A,$11,$71,$16,$49         *c7
  DC.B $C0,$41,$0,$60,$9,$68,$49,$6,$B,$F,$20,$21,$6,$2B,$6,$D0,$A,$1C,$11
  DC.B $49,$9,$79,$52,$1A,$11,$4F,$12,$4B,$6,$E0,$20,$20,$11,$71,$F5,$E7
  DC.B $44,$1A,$3C,$54,$1A,$54,$1,$30,$80,$28,$F9,$DB,$0,$20,$D,$4A,$D1
  DC.B $1F,$19,$39,$C,$18,$65,$78,$C,$5C,$3D,$55,$10,$28,$3,$D2         *c8
  DC.B $0,$42,$0,$60,$14,$18,$64,$78,$15,$5C,$5C,$55,$2,$30,$20,$28,$F2,$D3,$B0
  DC.B $BC,$70,$47,$0,$0,$60,$2A,$0,$40,$3C,$0,$1,$0,$EC,$54,$0,$40
  DC.B $6C,$54,$0,$40,$80,$4A,$0,$60,$F0,$B5,$2,$6,$12,$E,$86,$B0,$0
  DC.B $92,$84,$B0,$57,$4D,$58,$48,$9,$90,$0,$68,$40,$6,$0,$F         *c9
  DC.B $40,$42,$0,$60,$6,$28,$1,$D0,$1,$20,$0,$E0,$0,$20,$0,$90,$0,$21,$3
  DC.B $91,$52,$49,$8,$91,$52,$4A,$7,$92,$52,$48,$6,$90,$52,$4A,$5,$92
  DC.B $6F,$E0,$0,$98,$0,$28,$4,$D1,$3,$99,$5,$9A,$52,$6B,$FB,$F7,$EB
  DC.B $FE,$4E,$48,$1,$78,$6,$98,$0,$68,$41,$43,$3,$9A,$4C,$48         *ca
  DC.B $80,$42,$0,$60,$0,$23,$C3,$56,$5A,$43,$8F,$18,$8,$99,$9,$68,$C9,$19,$2
  DC.B $91,$F9,$10,$7,$9A,$12,$68,$89,$18,$1,$91,$0,$26,$47,$E0,$78,$7
  DC.B $40,$F,$1,$21,$81,$40,$1,$98,$0,$78,$8,$40,$1,$D0,$1,$21,$0
  DC.B $E0,$0,$21,$2,$98,$0,$78,$18,$28,$2,$DB,$1F,$28,$0,$DC         *cb
  DC.B $C0,$42,$0,$60,$1,$21,$4,$9A,$0,$2A,$1,$D1,$1,$22,$0,$E0,$0,$22,$11
  DC.B $40,$8,$D0,$1,$A,$4,$D3,$6,$98,$0,$79,$20,$21,$8,$1A,$5,$E0
  DC.B $34,$49,$2,$E0,$1,$A,$1,$D2,$33,$49,$8,$5C,$4,$6,$24,$E,$0
  DC.B $98,$0,$28,$9,$D0,$28,$78,$84,$42,$B,$D0,$2C,$70,$3,$99         *cc
  DC.B $0,$43,$0,$60,$5,$9A,$52,$6B,$30,$1C,$FB,$F7,$9F,$FE,$5,$9A,$91,$6B,$20
  DC.B $1C,$FB,$F7,$98,$FE,$2,$98,$1,$30,$2,$90,$1,$35,$1,$37,$78,$7
  DC.B $2,$D1,$1,$98,$1,$30,$1,$90,$70,$1C,$6,$6,$36,$E,$20,$48,$0
  DC.B $23,$C0,$56,$86,$42,$B2,$DB,$3,$99,$48,$1C,$1,$6,$9,$E         *cd
  DC.B $40,$43,$0,$60,$3,$91,$3,$99,$1D,$48,$0,$23,$C0,$56,$81,$42,$89,$DB,$17
  DC.B $48,$7,$78,$DB,$43,$9F,$42,$0,$D1,$0,$27,$19,$48,$C0,$5D,$5,$9A
  DC.B $D1,$6B,$FB,$F7,$6F,$FE,$17,$4D,$E9,$5D,$17,$4C,$E0,$5D,$5,$9A,$52
  DC.B $6B,$FB,$F7,$69,$FE,$9,$98,$0,$68,$40,$6,$0,$F,$6,$28         *ce
  DC.B $80,$43,$0,$60,$3,$D1,$E9,$5D,$E0,$5D,$FE,$F7,$87,$FB,$A,$B0,$F0,$BC,$8
  DC.B $BC,$18,$47,$0,$0,$6C,$55,$0,$40,$3C,$0,$1,$0,$8,$1,$1,$0
  DC.B $C,$1,$1,$0,$60,$2A,$0,$40,$2C,$3,$1,$0,$4,$1,$1,$0,$EC
  DC.B $0,$1,$0,$6C,$54,$0,$40,$EC,$54,$0,$40,$ED,$0,$1,$0         *cf
  DC.B $C0,$43,$0,$60,$72,$2A,$0,$40,$82,$2A,$0,$40,$7A,$2A,$0,$40,$F0,$B5,$46
  DC.B $4E,$46,$4D,$47,$4C,$47,$4F,$38,$88,$2,$28,$44,$D0,$4,$28,$72,$D0
  DC.B $5,$28,$16,$D0,$7,$28,$F6,$D1,$20,$68,$81,$9,$F3,$D2,$41,$9,$F1
  DC.B $D2,$81,$8,$EF,$D2,$40,$8,$ED,$D2,$A,$23,$F8,$5E,$0,$28         *d0
  DC.B $0,$44,$0,$60,$E9,$D0,$8,$23,$F8,$5E,$B,$28,$5E,$DD,$0,$21,$79,$81,$39
  DC.B $81,$E1,$E7,$78,$88,$1,$30,$78,$80,$37,$49,$38,$48,$1,$80,$0,$23
  DC.B $C0,$5E,$89,$6,$48,$84,$20,$23,$C8,$5E,$0,$28,$D,$D1,$34,$48,$34
  DC.B $49,$8,$80,$0,$21,$34,$48,$1,$80,$7,$20,$38,$80,$1,$20         *d1
  DC.B $40,$44,$0,$60,$31,$68,$FB,$F7,$FF,$FD,$0,$21,$79,$80,$78,$88,$C8,$28,$C2
  DC.B $DD,$0,$21,$79,$80,$2,$20,$38,$80,$B8,$88,$5,$28,$0,$DD,$39,$80
  DC.B $1,$30,$B8,$80,$B7,$E7,$3,$20,$C0,$3,$41,$68,$F0,$23,$DB,$43,$19
  DC.B $40,$40,$23,$19,$43,$41,$60,$11,$20,$0,$3,$1,$6A,$20,$23         *d2
  DC.B $80,$44,$0,$60,$DB,$43,$19,$40,$1,$62,$1,$6A,$4,$23,$19,$43,$1,$62,$D
  DC.B $20,$40,$3,$1,$68,$1D,$4B,$19,$40,$40,$23,$19,$43,$1,$60,$17,$21
  DC.B $9,$3,$48,$68,$1A,$4B,$18,$40,$48,$60,$8,$68,$18,$40,$8,$60,$1
  DC.B $20,$3,$DF,$17,$21,$9,$3,$8,$68,$1,$23,$9B,$5,$18,$43         *d3
  DC.B $C0,$44,$0,$60,$8,$60,$4,$20,$B,$E0,$0,$E0,$B,$E0,$FC,$F7,$3F,$FE,$0
  DC.B $21,$79,$81,$10,$49,$10,$48,$2A,$68,$FB,$F7,$B6,$FD,$5,$20,$38,$80
  DC.B $79,$E7,$1,$30,$38,$81,$76,$E7,$24,$48,$0,$60,$20,$48,$0,$60,$40
  DC.B $0,$1,$0,$C8,$2A,$0,$40,$8,$60,$0,$0,$6C,$1,$1,$0         *d4
  DC.B $0,$45,$0,$60,$E1,$BD,$FF,$FF,$B0,$A,$1,$0,$AE,$A,$1,$0,$3F,$FC,$FF
  DC.B $FF,$FF,$FF,$BF,$FF,$A1,$11,$0,$60,$91,$12,$0,$60,$5,$14,$0,$60
  DC.B $E9,$5,$0,$40,$F4,$1,$C8,$0,$54,$0,$0,$0,$75,$5,$0,$40,$F4
  DC.B $1,$FA,$0,$54,$0,$0,$0,$1D,$4,$0,$40,$F4,$1,$2C,$1         *d5
  DC.B $40,$45,$0,$60,$54,$0,$0,$0,$2D,$5,$0,$40,$F4,$1,$5E,$1,$54,$0,$0
  DC.B $0,$F1,$6,$0,$40,$F4,$1,$90,$1,$54,$0,$0,$0,$F1,$6,$0,$40
  DC.B $2C,$1,$F4,$1,$54,$0,$0,$0,$19,$93,$0,$0,$40,$0,$20,$3,$54
  DC.B $0,$0,$0,$31,$6,$0,$40,$90,$1,$96,$0,$54,$0,$0,$0         *d6
  DC.B $80,$45,$0,$60,$CD,$43,$0,$60,$90,$1,$64,$0,$54,$0,$0,$0,$48,$0,$0
  DC.B $0,$91,$19,$0,$60,$23,$0,$0,$0,$61,$24,$0,$60,$22,$0,$0,$0
  DC.B $59,$22,$0,$60,$19,$0,$0,$0,$21,$22,$0,$60,$A2,$0,$0,$0,$1D
  DC.B $1B,$0,$60,$9F,$0,$0,$0,$B7,$1C,$0,$60,$A4,$0,$0,$0         *d7
  DC.B $C0,$45,$0,$60,$5D,$1D,$0,$60,$C,$0,$0,$0,$A1,$12,$0,$60,$10,$0,$0
  DC.B $0,$C5,$13,$0,$60,$16,$0,$0,$0,$ED,$21,$0,$40,$78,$0,$0,$0
  DC.B $CD,$B,$0,$40,$79,$0,$0,$0,$65,$E,$0,$40,$7E,$0,$0,$0,$11
  DC.B $1A,$0,$40,$7F,$0,$0,$0,$29,$1A,$0,$40,$81,$0,$0,$0         *d8
  DC.B $0,$46,$0,$60,$41,$A,$0,$40,$84,$0,$0,$0,$61,$A,$0,$40,$89,$0,$0
  DC.B $0,$25,$E,$0,$40,$8B,$0,$0,$0,$65,$3,$0,$40,$8F,$0,$0,$0
  DC.B $85,$17,$0,$40,$91,$0,$0,$0,$15,$F,$0,$40,$92,$0,$0,$0,$35
  DC.B $F,$0,$40,$A2,$0,$0,$0,$39,$1A,$0,$40,$A3,$0,$0,$0         *d9
  DC.B $40,$46,$0,$60,$19,$1B,$0,$40,$9,$0,$0,$0,$E9,$1,$0,$40,$7,$0,$0
  DC.B $0,$E1,$2,$0,$40,$A7,$0,$0,$0,$95,$3,$0,$40,$D1,$0,$0,$0
  DC.B $D7,$2F,$0,$60,$CE,$0,$0,$0,$95,$2D,$0,$60,$F2,$0,$0,$0,$6D
  DC.B $2F,$0,$60,$F3,$0,$0,$0,$A5,$2F,$0,$60,$CF,$0,$0,$0         *da
  DC.B $80,$46,$0,$60,$D5,$2F,$0,$60,$EF,$0,$0,$0,$D9,$2F,$0,$60,$D4,$0,$0
  DC.B $0,$81,$30,$0,$60,$D2,$0,$0,$0,$DD,$30,$0,$60,$D8,$0,$0,$0
  DC.B $49,$31,$0,$60,$F0,$0,$0,$0,$31,$32,$0,$60,$F1,$0,$0,$0,$F5
  DC.B $31,$0,$60,$D9,$0,$0,$0,$7D,$32,$0,$60,$DA,$0,$0,$0         *db
  DC.B $C0,$46,$0,$60,$89,$32,$0,$60,$DB,$0,$0,$0,$95,$32,$0,$60,$DC,$0,$0
  DC.B $0,$A1,$32,$0,$60,$DD,$0,$0,$0,$9D,$33,$0,$60,$DE,$0,$0,$0
  DC.B $61,$34,$0,$60,$DF,$0,$0,$0,$D5,$34,$0,$60,$E2,$0,$0,$0,$5D
  DC.B $35,$0,$60,$E3,$0,$0,$0,$79,$35,$0,$60,$EB,$0,$0,$0         *dc
  DC.B $0,$47,$0,$60,$D1,$35,$0,$60,$E6,$0,$0,$0,$3D,$38,$0,$60,$E7,$0,$0
  DC.B $0,$45,$3C,$0,$60,$E8,$0,$0,$0,$85,$3C,$0,$60,$E9,$0,$0,$0
  DC.B $1D,$3D,$0,$60,$EE,$0,$0,$0,$2D,$3E,$0,$60,$ED,$0,$0,$0,$31
  DC.B $40,$0,$60,$EA,$0,$0,$0,$C9,$36,$0,$60,$98,$0,$0,$0         *dd
  DC.B $40,$47,$0,$60,$8D,$21,$0,$60,$E4,$0,$0,$0,$ED,$36,$0,$60,$42,$0,$0
  DC.B $0,$75,$1A,$0,$60,$6B,$0,$0,$0,$65,$1C,$0,$40,$6A,$0,$0,$0
  DC.B $43,$1C,$0,$40,$9D,$0,$0,$0,$A5,$1A,$0,$60,$24,$0,$0,$0,$A9
  DC.B $21,$0,$60,$53,$0,$0,$0,$E9,$3,$0,$40,$6A,$0,$0,$0         *de
  DC.B $80,$47,$0,$60,$6D,$29,$0,$60,$6B,$0,$0,$0,$15,$2B,$0,$60,$6C,$0,$0
  DC.B $0,$B1,$29,$0,$60,$6D,$0,$0,$0,$55,$2A,$0,$60,$6E,$0,$0,$0
  DC.B $1D,$2C,$0,$60,$6F,$0,$0,$0,$49,$2C,$0,$60,$70,$0,$0,$0,$D1
  DC.B $2A,$0,$60,$3C,$0,$0,$0,$ED,$19,$0,$60,$1D,$0,$0,$0         *df
  DC.B $C0,$47,$0,$60,$75,$28,$0,$60,$39,$2B,$0,$0,$C5,$2D,$0,$0,$3D,$33,$0
  DC.B $0,$65,$31,$0,$0,$91,$90,$0,$0,$F9,$67,$0,$0,$AD,$71,$0,$0
  DC.B $F1,$12,$0,$0,$3D,$8F,$0,$0,$44,$94,$0,$0,$E1,$C,$0,$0,$65
  DC.B $1E,$0,$0,$31,$1E,$0,$0,$59,$6F,$0,$0,$89,$6F,$0,$0         *e0
  DC.B $0,$48,$0,$60,$D4,$86,$0,$0,$8,$3,$0,$0,$CD,$1B,$0,$40,$23,$1C,$0
  DC.B $40,$59,$21,$0,$40,$1D,$1B,$0,$60,$B9,$21,$0,$60,$75,$93,$0,$0
  DC.B $91,$18,$0,$60,$CD,$10,$0,$60,$29,$42,$0,$60,$49,$41,$0,$60,$DD
  DC.B $0,$0,$40,$C1,$1,$0,$40,$A3,$0,$0,$40,$C5,$19,$0,$60         *e1
  DC.B $40,$48,$0,$60,$99,$1,$0,$40,$A9,$1F,$0,$60,$12,$80,$3,$4,$1,$28,$1
  DC.B $24,$4D,$54,$4C,$34,$31,$F2,$35,$30,$32,$35,$5C,$5C,$5C,$5C,$4D,$69
  DC.B $74,$65,$6C,$20,$53,$53,$34,$31,$F2,$35,$30,$32,$35,$20,$52,$53,$32
  DC.B $33,$32,$20,$50,$68,$6F,$6E,$65,$F2,$39,$45,$41,$32,$29,$0         *e2
  DC.B $80,$48,$0,$60,$C4,$75,$0,$0,$C0,$80,$0,$0,$2D,$9,$1,$0,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$FF,$FF,$18,$1C,$1E,$1F,$1E,$1C,$18,$0,$3,$7,$F,$1F
  DC.B $F,$7,$3,$0,$0,$0,$1E,$1E,$1E,$1E,$0,$0,$A,$15,$19,$19,$15
  DC.B $13,$13,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *e3
  DC.B $C0,$48,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$8,$4,$0
  DC.B $12,$12,$12,$D,$0,$8,$14,$0,$18,$8,$8,$1C,$0,$4,$A,$0,$E
  DC.B $11,$11,$E,$0,$A,$0,$E,$11,$1F,$10,$E,$0,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$0,$0,$0,$FF,$FF,$0,$0,$0,$0,$4,$0,$1F         *e4
  DC.B $0,$49,$0,$60,$0,$4,$0,$0,$6,$9,$8,$1C,$8,$1D,$1A,$0,$0,$11,$A
  DC.B $4,$A,$11,$0,$0,$0,$0,$0,$6,$6,$0,$0,$0,$0,$A,$0,$C
  DC.B $4,$4,$E,$0,$0,$A,$0,$12,$12,$12,$D,$0,$1E,$21,$AA,$82,$92
  DC.B $AA,$BA,$44,$0,$0,$7C,$44,$54,$48,$44,$FE,$AA,$55,$AA,$55         *e5
  DC.B $40,$49,$0,$60,$AA,$55,$AA,$55,$0,$4,$15,$E,$15,$4,$0,$0,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$FF,$FF,$8,$14,$14,$8,$0,$0,$0,$0,$4,$2,$E,$1
  DC.B $F,$11,$F,$0,$4,$8,$E,$11,$1F,$10,$E,$0,$4,$2,$E,$11,$1F
  DC.B $10,$E,$0,$4,$A,$E,$11,$1F,$10,$E,$0,$4,$A,$0,$12         *e6
  DC.B $80,$49,$0,$60,$12,$12,$D,$0,$0,$E,$11,$10,$11,$E,$4,$E,$A,$0,$E
  DC.B $1,$F,$11,$F,$0,$A,$0,$E,$11,$11,$11,$E,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$88,$4,$0,$0,$95,$4,$0,$0,$A2,$4,$0,$0,$8
  DC.B $7,$0,$0,$15,$7,$0,$0,$22,$7,$0,$0,$0,$FC,$3F,$0         *e7
  DC.B $C0,$49,$0,$60,$1,$FC,$FF,$30,$E0,$2,$FC,$FF,$E5,$18,$E0,$2,$FC,$FF,$E5
  DC.B $18,$E0,$2,$FC,$FF,$E5,$18,$E0,$2,$FC,$FF,$E5,$18,$E0,$2,$FC,$FF
  DC.B $E5,$18,$E0,$2,$FC,$FF,$E5,$18,$E0,$2,$FC,$FF,$E5,$18,$E0,$2,$FC
  DC.B $FF,$E5,$18,$E0,$2,$FC,$FF,$E5,$18,$3,$FC,$FF,$38,$1,$FC         *e8
  DC.B $0,$4A,$0,$60,$3F,$30,$0,$FC,$3F,$20,$FF,$0,$31,$1E,$0,$0,$1F,$10,$0
  DC.B $80,$80,$80,$1E,$11,$16,$25,$26,$27,$1D,$24,$F,$28,$29,$2A,$1C,$23
  DC.B $D,$E,$13,$12,$1B,$22,$9,$A,$B,$C,$1A,$21,$5,$6,$7,$8,$19
  DC.B $20,$1,$2,$3,$4,$0,$0,$14,$2,$0,$0,$AD,$39,$0,$60         *e9
  DC.B $40,$4A,$0,$60,$15,$3,$0,$0,$C9,$39,$0,$60,$16,$3,$0,$0,$B5,$3A,$0
  DC.B $60,$17,$22,$0,$0,$4D,$3B,$0,$60,$2D,$4,$0,$0,$5,$3E,$0,$60
  DC.B $11,$EE,$10,$E1,$12,$EF,$13,$F5,$14,$86,$15,$FD,$16,$EC,$17,$EB,$18
  DC.B $DB,$19,$DB,$1A,$DF,$1B,$6F,$1C,$0,$1D,$2,$1E,$4,$1F,$6         *ea
  DC.B $80,$4A,$0,$60,$18,$A5,$19,$A2,$1A,$A2,$1B,$DF,$1C,$1,$1D,$3,$1E,$5,$1F
  DC.B $7,$43,$B9,$A5,$6B,$AC,$B5,$FD,$F8,$15,$79,$FE,$E6,$77,$80,$2,$47
  DC.B $48,$37,$76,$79,$3F,$E6,$37,$77,$59,$60,$67,$52,$0,$A1,$12,$D8,$1D
  DC.B $45,$9,$AC,$54,$7C,$71,$5,$44,$20,$D0,$AA,$C,$12,$3C,$2         *eb
  DC.B $C0,$4A,$0,$60,$E1,$68,$C,$9D,$92,$79,$19,$28,$AF,$C,$2D,$EC,$50,$BE,$5F
  DC.B $96,$B1,$3F,$E3,$50,$F6,$B2,$90,$54,$AD,$6A,$EC,$D9,$29,$57,$D4,$89
  DC.B $5C,$56,$72,$62,$70,$C0,$4D,$E0,$57,$4D,$22,$BF,$6,$2E,$1B,$80,$E1
  DC.B $78,$48,$45,$48,$4B,$58,$D6,$F4,$67,$CC,$B3,$8F,$CC,$21,$28         *ec
  DC.B $0,$4B,$0,$60,$86,$84,$4A,$A7,$6,$82,$82,$D,$AD,$88,$39,$57,$9A,$34,$23
  DC.B $41,$9A,$FF,$5,$77,$9E,$5,$89,$13,$4B,$97,$ED,$91,$57,$0,$2A,$42
  DC.B $9C,$EC,$42,$3B,$B6,$11,$9B,$CF,$26,$CB,$39,$9,$ED,$A,$E5,$AC,$D8
  DC.B $43,$21,$45,$87,$4D,$26,$37,$F8,$21,$B4,$EC,$FB,$A9,$4D,$41         *ed
  DC.B $40,$4B,$0,$60,$F7,$59,$E3,$91,$B,$3E,$54,$B0,$29,$F0,$73,$DA,$A5,$8D,$E8
  DC.B $1F,$10,$43,$27,$81,$5D,$17,$8F,$2A,$33,$B2,$63,$67,$84,$17,$4F,$20
  DC.B $C7,$3,$92,$E7,$81,$55,$9E,$D0,$9F,$28,$24,$69,$79,$45,$EA,$A3,$13
  DC.B $50,$A5,$81,$57,$7F,$93,$E3,$FD,$A0,$D1,$D4,$F9,$A7,$12,$CF         *ee
  DC.B $80,$4B,$0,$60,$53,$9D,$AA,$7B,$D4,$C2,$96,$A9,$9E,$A7,$7B,$6A,$90,$CC,$C8
  DC.B $D,$A7,$6B,$D4,$E1,$6D,$53,$76,$53,$4B,$AA,$98,$0,$39,$24,$F8,$5D
  DC.B $41,$54,$27,$57,$2F,$17,$51,$9A,$89,$E4,$52,$B8,$6,$98,$C4,$6A,$6A
  DC.B $B3,$F8,$B,$98,$D2,$7F,$1,$4E,$62,$CF,$FC,$7,$16,$63,$BF         *ef
  DC.B $C0,$4B,$0,$60,$1,$A3,$EC,$CF,$D4,$A,$EF,$4C,$60,$1C,$A,$32,$F5,$AB,$A3
  DC.B $79,$9F,$5C,$D4,$3B,$AE,$AD,$D,$11,$91,$F8,$CC,$D2,$27,$CB,$6D,$D5
  DC.B $7B,$8F,$E7,$F5,$E8,$72,$3F,$F3,$3F,$77,$5F,$38,$72,$28,$DA,$1C,$BF
  DC.B $D0,$E4,$51,$FE,$11,$75,$5F,$58,$4A,$BD,$91,$57,$28,$CA,$B7         *f0
  DC.B $0,$4C,$0,$60,$E1,$17,$21,$15,$44,$6,$F8,$91,$CC,$7C,$43,$52,$45,$1A,$4
  DC.B $CB,$F6,$D8,$17,$96,$2F,$96,$71,$7F,$52,$F2,$EE,$32,$D6,$A3,$2,$F2
  DC.B $E2,$0,$F8,$FE,$C8,$DC,$66,$41,$7D,$7F,$67,$D5,$F3,$A0,$2F,$EB,$97
  DC.B $D4,$DF,$37,$48,$36,$66,$79,$A7,$8B,$CC,$E,$D,$D6,$61,$22         *f1
  DC.B $40,$4C,$0,$60,$39,$A6,$FA,$CC,$B4,$7C,$9F,$5A,$C,$F3,$18,$8F,$D3,$3E,$DC
  DC.B $BF,$DE,$EE,$5F,$A9,$3E,$64,$15,$E1,$CF,$C4,$16,$95,$F9,$94,$D4,$A0
  DC.B $3C,$83,$B5,$67,$F9,$B1,$19,$90,$5C,$BC,$A1,$78,$5B,$1D,$F9,$95,$D9
  DC.B $1C,$DD,$3F,$73,$74,$8F,$4D,$D2,$B,$B9,$FD,$CD,$3C,$54,$EE         *f2
  DC.B $80,$4C,$0,$60,$61,$22,$6,$99,$1B,$86,$DE,$3D,$68,$CF,$CF,$96,$7F,$7D,$AE
  DC.B $AD,$1C,$69,$9C,$F9,$4A,$D8,$E3,$49,$8F,$9C,$F7,$DA,$EA,$C9,$49,$43
  DC.B $73,$AC,$75,$7C,$69,$33,$74,$82,$9A,$78,$9E,$66,$7E,$E6,$12,$37,$D
  DC.B $24,$C6,$36,$2D,$55,$5D,$70,$71,$A0,$72,$A2,$41,$55,$5E,$F2         *f3
  DC.B $C0,$4C,$0,$60,$D4,$8E,$5C,$83,$95,$9A,$AB,$7F,$A2,$A5,$90,$AC,$2D,$A4,$4C
  DC.B $10,$9D,$27,$70,$C1,$4,$D0,$D7,$BF,$89,$8A,$85,$A2,$AA,$87,$86,$34
  DC.B $38,$8B,$32,$1C,$6D,$FC,$E6,$E,$90,$4A,$5,$57,$AD,$8D,$EB,$7,$A4
  DC.B $CA,$C8,$B1,$43,$68,$BE,$D6,$BA,$F3,$34,$18,$17,$EF,$F5,$80         *f4
  DC.B $0,$4D,$0,$60,$F2,$83,$4E,$41,$BF,$4E,$C8,$2F,$BF,$F,$5,$A7,$CE,$60,$3D
  DC.B $7B,$7E,$DE,$1,$90,$67,$3D,$4E,$48,$5,$EF,$0,$59,$8D,$3,$8E,$8F
  DC.B $42,$F7,$24,$A,$92,$69,$B,$7E,$DD,$4D,$1F,$6E,$AF,$79,$E8,$68,$1C
  DC.B $76,$89,$3D,$53,$66,$B2,$7D,$7B,$7E,$F3,$9E,$B4,$7A,$17,$B5         *f5
  DC.B $40,$4D,$0,$60,$81,$4B,$9A,$44,$1A,$42,$9F,$A7,$F6,$82,$83,$C1,$E0,$9F,$5B
  DC.B $92,$2B,$9A,$2E,$3F,$24,$55,$27,$47,$DB,$AA,$F1,$56,$A2,$67,$49,$F1
  DC.B $CA,$95,$4C,$53,$D3,$BC,$FE,$6B,$D2,$29,$A7,$A,$2E,$43,$E3,$4A,$BB
  DC.B $91,$B3,$A1,$A1,$DB,$AB,$91,$9B,$97,$14,$77,$7F,$7F,$75,$1         *f6
  DC.B $80,$4D,$0,$60,$A2,$C7,$1,$4D,$9F,$BC,$F4,$7E,$9C,$62,$8D,$A4,$A4,$6B,$B8
  DC.B $90,$B2,$8B,$C1,$A3,$EE,$F8,$A4,$2F,$67,$90,$B8,$3C,$78,$36,$9,$1C
  DC.B $8F,$86,$A8,$78,$68,$C2,$38,$A2,$E0,$74,$3A,$23,$14,$56,$65,$19,$1B
  DC.B $BC,$F4,$83,$54,$EE,$8E,$52,$17,$99,$8B,$B3,$C5,$C8,$72,$32         *f7
  DC.B $C0,$4D,$0,$60,$17,$11,$95,$C,$A,$25,$1C,$D2,$8D,$6,$E5,$6,$D3,$47,$DD
  DC.B $F6,$CF,$29,$A,$2A,$28,$27,$7C,$BE,$52,$64,$64,$26,$65,$1E,$23,$AB
  DC.B $1A,$52,$8A,$7B,$66,$61,$74,$97,$10,$44,$14,$37,$C1,$8D,$FF,$42,$8D
  DC.B $8D,$F1,$16,$F1,$47,$36,$21,$63,$1B,$38,$87,$84,$30,$B1,$B8         *f8
  DC.B $0,$4E,$0,$60,$94,$99,$69,$49,$AC,$5C,$81,$48,$ED,$62,$DF,$22,$C3,$ED,$62
  DC.B $DD,$B1,$CA,$95,$42,$9E,$4E,$F3,$F8,$8A,$83,$C5,$2B,$F,$17,$44,$5
  DC.B $85,$EC,$B4,$B7,$E7,$BA,$C9,$11,$6C,$CF,$14,$E5,$E5,$3F,$48,$F5,$2F
  DC.B $E2,$91,$C,$8C,$DC,$BE,$FE,$E9,$22,$4C,$4C,$50,$D5,$37,$6B         *f9
  DC.B $40,$4E,$0,$60,$DA,$B8,$6F,$B1,$FB,$1F,$5E,$DC,$B0,$53,$FA,$14,$ED,$A0,$FC
  DC.B $D,$D3,$EF,$80,$A9,$D7,$B4,$6F,$E7,$D7,$83,$1B,$34,$73,$9F,$CC,$E7
  DC.B $0,$F1,$76,$B7,$EC,$80,$31,$B5,$FB,$39,$E9,$9D,$14,$BC,$5D,$93,$F6
  DC.B $46,$A4,$85,$7D,$8E,$F1,$55,$83,$19,$50,$44,$DD,$45,$51,$43         *fa
  DC.B $80,$4E,$0,$60,$EE,$4B,$BA,$28,$67,$DE,$18,$FA,$AF,$E6,$D6,$3D,$E0,$27,$E2
  DC.B $67,$DE,$3C,$6D,$6B,$EB,$D7,$BB,$67,$1B,$7D,$FA,$43,$A,$42,$34,$4C
  DC.B $20,$B5,$D8,$A4,$56,$52,$14,$8A,$83,$DE,$45,$73,$C,$7B,$D0,$92,$A9
  DC.B $29,$47,$22,$D9,$9E,$7E,$E9,$35,$AC,$19,$AF,$74,$DD,$63,$C6         *fb
  DC.B $C0,$4E,$0,$60,$73,$A8,$29,$EA,$A1,$FC,$6D,$4D,$AE,$96,$4E,$46,$A6,$82,$2
  DC.B $C2,$87,$6,$9B,$5A,$1B,$30,$F6,$7E,$BB,$14,$F3,$73,$40,$89,$30,$1F
  DC.B $C1,$E7,$3F,$36,$A7,$EB,$FE,$F6,$78,$40,$58,$1F,$81,$73,$85,$6,$3E
  DC.B $8E,$73,$FE,$94,$EF,$99,$FE,$9C,$FE,$D4,$E1,$E6,$11,$A1,$A7         *fc
  DC.B $0,$4F,$0,$60,$97,$11,$BC,$53,$B1,$5C,$DD,$D6,$33,$54,$C1,$D7,$BA,$DF,$5E
  DC.B $ED,$6A,$AE,$C4,$70,$71,$45,$62,$99,$CF,$51,$CD,$C8,$86,$29,$97,$62
  DC.B $4B,$4D,$CB,$F1,$CA,$94,$AD,$62,$A8,$7E,$F3,$F9,$80,$4A,$D2,$96,$9F
  DC.B $D7,$58,$B8,$62,$90,$AE,$36,$86,$2A,$CD,$2D,$31,$EB,$5F,$5E         *fd
  DC.B $40,$4F,$0,$60,$78,$E3,$29,$A9,$C3,$2,$FA,$24,$1A,$11,$E0,$5F,$FA,$53,$98
  DC.B $31,$5E,$C,$5F,$8E,$73,$98,$B7,$8A,$8F,$AC,$6B,$F,$16,$A6,$D7,$8B
  DC.B $53,$75,$DE,$7F,$32,$D3,$B4,$D6,$6D,$85,$AA,$9B,$9E,$B5,$D7,$AC,$7C
  DC.B $B6,$B1,$F7,$5A,$C7,$4B,$41,$61,$E5,$FA,$C7,$48,$52,$96,$29         *fe
  DC.B $80,$4F,$0,$60,$BB,$A,$70,$A3,$FA,$7A,$34,$C9,$4F,$1B,$43,$CA,$D5,$3C,$D8
  DC.B $A5,$2A,$E3,$C7,$5B,$EB,$1A,$B7,$8E,$DF,$13,$E,$22,$FD,$8A,$7E,$E0
  DC.B $82,$B4,$84,$10,$56,$86,$C4,$28,$C4,$51,$AB,$F7,$8F,$61,$E0,$92,$EE
  DC.B $1D,$63,$D8,$70,$F3,$A4,$5D,$63,$DD,$CA,$72,$7E,$81,$A9,$29         *ff
  DC.B $C0,$4F,$0,$60,$11,$29,$52,$2,$D5,$DD,$F7,$17,$1A,$25,$23,$4E,$AF,$16,$A6
  DC.B $D7,$DE,$7E,$63,$A9,$64,$BF,$23,$3A,$ED,$C7,$6C,$82,$6E,$29,$C9,$94
  DC.B $8A,$41,$E6,$11,$C,$31,$1E,$A3,$C7,$6A,$C1,$89,$FD,$3C,$76,$86,$32
  DC.B $1A,$5F,$B8,$EA,$B0,$C3,$4D,$C7,$52,$53,$66,$AC,$16,$35,$FC         *100
  DC.B $0,$50,$0,$60,$3D,$32,$9B,$1D,$4E,$4B,$F7,$1D,$BF,$71,$D5,$29,$43,$6F,$4E
  DC.B $E0,$1E,$9D,$FD,$F,$4D,$EC,$5A,$94,$BF,$79,$F9,$91,$96,$F4,$4C,$BF
  DC.B $C1,$88,$D0,$F1,$6A,$55,$2A,$92,$D6,$7E,$FE,$5B,$B2,$D3,$58,$C5,$B3
  DC.B $55,$EE,$3A,$AF,$79,$F9,$9A,$C,$B6,$2D,$9A,$D4,$29,$B0,$C8         *101
  DC.B $40,$50,$0,$60,$C8,$BE,$B,$CF,$8D,$5,$E7,$FA,$83,$31,$4E,$98,$B8,$B6,$55
  DC.B $6,$DA,$60,$A1,$B8,$EB,$32,$32,$DE,$F1,$AB,$64,$16,$95,$57,$4E,$F2
  DC.B $46,$BB,$33,$9F,$BD,$CD,$8E,$AA,$9F,$4F,$FD,$A9,$CD,$C1,$99,$51,$69
  DC.B $4D,$63,$DC,$AC,$E7,$1F,$22,$EE,$28,$BA,$1,$E5,$76,$C6,$72         *102
  DC.B $80,$50,$0,$60,$A6,$C,$54,$B6,$46,$B6,$47,$F1,$2A,$C0,$A,$19,$18,$D2,$E3
  DC.B $39,$6E,$2F,$BF,$41,$F5,$99,$1C,$89,$AC,$1A,$ED,$96,$9B,$19,$20,$98
  DC.B $E8,$9,$75,$4A,$A8,$85,$7E,$46,$7A,$8,$82,$66,$64,$2F,$48,$F,$7A
  DC.B $E3,$30,$48,$E5,$F7,$19,$3,$63,$BB,$E4,$4D,$76,$C7,$6A,$6B         *103
  DC.B $C0,$50,$0,$60,$7,$46,$A4,$B9,$A1,$25,$CD,$C,$5B,$8F,$5B,$B4,$F0,$8C,$E9
  DC.B $C8,$8D,$2A,$3B,$73,$5A,$25,$49,$BA,$6B,$A4,$B4,$EE,$9A,$D1,$19,$37
  DC.B $4D,$72,$9,$81,$D2,$A2,$89,$FE,$E9,$AF,$22,$F3,$5D,$A5,$7D,$2F,$35
  DC.B $2C,$87,$A5,$7E,$5E,$6B,$C,$4F,$CC,$EA,$6F,$3B,$F6,$D6,$B4         *104
  DC.B $0,$51,$0,$60,$FF,$D4,$E9,$74,$A6,$74,$91,$E8,$7A,$5C,$32,$63,$F5,$50,$41
  DC.B $A5,$C5,$53,$1F,$AA,$75,$3A,$B5,$DF,$40,$22,$9F,$2E,$94,$5,$3,$E5
  DC.B $D2,$A2,$A9,$43,$95,$38,$AB,$95,$D9,$7B,$7D,$E9,$C6,$FB,$E5,$3D,$BB
  DC.B $DF,$4B,$CF,$88,$82,$34,$EB,$A2,$81,$68,$EB,$AC,$4,$7E,$7         *105
  DC.B $40,$51,$0,$60,$D6,$A8,$D9,$AC,$DF,$3A,$C9,$F,$B1,$A0,$35,$90,$59,$DA,$1
  DC.B $90,$8C,$C0,$F4,$D7,$6E,$74,$BA,$1,$6B,$CB,$2,$61,$EB,$53,$6F,$9C
  DC.B $9A,$1E,$C7,$47,$2,$9E,$F5,$E5,$11,$6,$8B,$F1,$3E,$99,$CA,$B9,$38
  DC.B $9,$CD,$A9,$A,$A3,$44,$81,$B2,$A8,$D1,$BF,$8C,$C4,$81,$2F         *106
  DC.B $80,$51,$0,$60,$16,$3C,$CF,$E9,$BE,$75,$24,$DF,$36,$97,$A1,$97,$FA,$7C,$F4
  DC.B $1A,$17,$1B,$DC,$DF,$B3,$DD,$D1,$9C,$36,$35,$E6,$F7,$D1,$1D,$BE,$83
  DC.B $43,$D2,$F3,$20,$60,$D0,$F2,$47,$84,$DE,$27,$15,$4D,$2F,$D8,$7F,$8F
  DC.B $22,$DF,$A9,$F0,$2B,$56,$F4,$19,$3E,$BD,$F2,$81,$ED,$60,$72         *107
  DC.B $C0,$51,$0,$60,$C6,$DF,$99,$9F,$73,$72,$D1,$B5,$4B,$46,$E7,$A2,$36,$15,$85
  DC.B $EF,$CC,$88,$E4,$61,$E6,$E6,$E8,$FB,$9F,$FB,$22,$83,$BF,$28,$1C,$8D
  DC.B $2A,$46,$AE,$11,$82,$6C,$42,$12,$17,$B7,$38,$A2,$D,$C1,$72,$3C,$2F
  DC.B $3A,$92,$3A,$6,$F3,$D0,$6F,$94,$15,$E7,$FE,$89,$99,$D0,$9A         *108
  DC.B $0,$52,$0,$60,$5D,$BC,$F3,$32,$3A,$B9,$83,$42,$53,$CC,$35,$9E,$DF,$2F,$81
  DC.B $34,$59,$25,$29,$F0,$A,$70,$14,$42,$AA,$DC,$DA,$E,$3B,$37,$3E,$26
  DC.B $FC,$A1,$EF,$3C,$56,$C,$8A,$9C,$55,$35,$99,$EB,$B5,$DB,$9F,$1B,$73
  DC.B $C6,$C3,$16,$AE,$1A,$C,$BF,$D2,$3D,$D2,$3F,$FC,$9F,$CA,$3D         *109
  DC.B $40,$52,$0,$60,$17,$B3,$3D,$79,$13,$80,$F9,$43,$AA,$20,$C8,$BF,$6E,$7F,$AB
  DC.B $F7,$DB,$FA,$C,$8B,$FD,$F9,$41,$91,$76,$48,$C3,$DC,$19,$1F,$CD,$AD
  DC.B $71,$93,$FC,$A3,$D1,$79,$BD,$AE,$43,$40,$63,$29,$7E,$C6,$55,$29,$4B
  DC.B $EA,$BA,$32,$7A,$FB,$D6,$9D,$21,$71,$E4,$5F,$B1,$55,$A6,$F7         *10a
  DC.B $80,$52,$0,$60,$ED,$CB,$52,$BC,$79,$1A,$17,$27,$A6,$B0,$69,$2F,$CE,$8D,$E4
  DC.B $FE,$49,$F6,$6,$86,$F7,$66,$E5,$8F,$F7,$24,$EA,$76,$B7,$95,$B,$8E
  DC.B $EC,$E,$D0,$CA,$36,$D9,$27,$F9,$D8,$61,$D8,$C1,$F8,$CD,$BF,$91,$F9
  DC.B $40,$D9,$5,$49,$CA,$29,$19,$25,$2B,$DF,$B5,$39,$BE,$99,$1C         *10b
  DC.B $C0,$52,$0,$60,$8E,$24,$38,$BB,$F9,$47,$A2,$F6,$FA,$26,$91,$8E,$FD,$38,$FD
  DC.B $F9,$3C,$95,$7E,$9A,$89,$6C,$32,$EA,$73,$64,$BD,$E5,$52,$C6,$4D,$A1
  DC.B $1A,$96,$BB,$A9,$D6,$EA,$5A,$E5,$BC,$96,$5B,$6F,$33,$DF,$C8,$D4,$A5
  DC.B $29,$69,$7B,$42,$F8,$16,$FD,$79,$D,$B,$B9,$69,$7C,$B6,$18         *10c
  DC.B $0,$53,$0,$60,$27,$44,$6,$A5,$53,$46,$5A,$CD,$B,$E2,$5B,$C,$D,$22,$E4
  DC.B $3,$A2,$3E,$D6,$A,$55,$D4,$7E,$13,$13,$52,$D7,$46,$45,$E6,$B8,$DB
  DC.B $A8,$F9,$DE,$84,$A6,$A5,$4D,$E0,$65,$5E,$37,$A,$7E,$D1,$92,$ED,$D0
  DC.B $D0,$5,$9F,$C4,$E5,$8D,$28,$E3,$B7,$3E,$3D,$A6,$14,$EA,$6A         *10d
  DC.B $40,$53,$0,$60,$5B,$1A,$96,$A4,$D4,$D,$DD,$4A,$7E,$EA,$54,$B3,$52,$96,$FA
  DC.B $E3,$29,$4B,$37,$45,$75,$D1,$57,$37,$47,$D4,$D5,$F0,$F1,$15,$B9,$BF
  DC.B $82,$9,$C8,$A2,$6,$ED,$1,$55,$27,$D7,$3D,$74,$3C,$3F,$65,$76,$9B
  DC.B $C0,$1D,$15,$5D,$6E,$98,$A,$FA,$83,$D0,$35,$6F,$3A,$11,$51         *10e
  DC.B $80,$53,$0,$60,$4D,$6F,$69,$6C,$6B,$44,$E6,$68,$3,$80,$1E,$E5,$BA,$DF,$6E
  DC.B $B9,$8B,$AD,$EA,$C2,$CC,$F2,$D1,$2,$68,$A,$E8,$80,$6B,$4C,$7B,$42
  DC.B $96,$C7,$5D,$6F,$3C,$D9,$BB,$AD,$38,$A,$D4,$9,$AE,$6C,$B4,$8E,$35
  DC.B $C2,$75,$13,$11,$CB,$5F,$2E,$B9,$F1,$FD,$19,$EE,$B9,$A3,$D7         *10f
  DC.B $C0,$53,$0,$60,$D3,$5B,$E5,$D1,$EA,$AF,$F3,$9A,$E9,$F,$25,$B0,$C5,$57,$30
  DC.B $83,$2D,$86,$64,$EC,$15,$CD,$20,$C7,$2C,$8,$E1,$3,$16,$96,$C6,$95
  DC.B $CB,$5A,$B9,$35,$86,$B9,$98,$7B,$36,$E9,$1B,$3E,$A4,$25,$42,$28,$3D
  DC.B $86,$66,$B7,$8C,$68,$AD,$4D,$2D,$10,$C2,$28,$F0,$EE,$15,$A9         *110
  DC.B $0,$54,$0,$60,$C3,$DC,$A2,$FB,$98,$D6,$E2,$CB,$A0,$8D,$67,$CE,$68,$A,$D4
  DC.B $2D,$1,$55,$39,$B0,$7A,$86,$EB,$CA,$BA,$DC,$F5,$67,$14,$D0,$15,$50
  DC.B $5C,$5,$54,$2E,$1F,$56,$BA,$DC,$34,$D7,$62,$35,$88,$57,$F9,$61,$39
  DC.B $16,$A3,$F8,$CD,$9B,$3B,$EA,$2B,$79,$7,$9A,$87,$55,$B7,$B3         *111
  DC.B $40,$54,$0,$60,$CA,$1B,$25,$20,$A6,$89,$1B,$D0,$4A,$3C,$F3,$15,$9F,$32,$7
  DC.B $24,$78,$47,$12,$C0,$23,$8F,$B,$72,$73,$9C,$DB,$58,$5F,$73,$5E,$6D
  DC.B $8,$C3,$C0,$53,$CB,$50,$14,$D0,$13,$9B,$53,$46,$7A,$D6,$8E,$EB,$FE
  DC.B $F5,$18,$E7,$FD,$2E,$2F,$34,$AC,$BD,$EE,$0,$E8,$20,$29,$E5         *112
  DC.B $80,$54,$0,$60,$B8,$FD,$DB,$CD,$C,$80,$A7,$88,$79,$57,$FF,$1D,$0,$A2,$1B
  DC.B $80,$A1,$70,$43,$CB,$7A,$C9,$68,$EA,$27,$1F,$A1,$8,$EE,$4F,$2E,$3D
  DC.B $2,$90,$E3,$30,$2,$4D,$CC,$73,$6A,$4C,$34,$68,$CF,$5A,$DF,$47,$6C
  DC.B $9F,$A,$2D,$E6,$D4,$90,$14,$F1,$23,$3D,$7E,$86,$8E,$4,$96         *113
  DC.B $C0,$54,$0,$60,$C4,$92,$D7,$F8,$7C,$8A,$3,$20,$2B,$E8,$17,$D7,$4A,$29,$2D
  DC.B $85,$86,$15,$E7,$29,$5D,$1C,$11,$75,$3C,$97,$8E,$16,$4A,$89,$CD,$B5
  DC.B $A5,$B1,$9C,$99,$C2,$FE,$A5,$C0,$53,$CB,$47,$36,$9B,$25,$14,$BE,$C1
  DC.B $96,$C7,$42,$43,$5E,$6D,$51,$93,$75,$36,$D5,$8A,$0,$B,$E2         *114
  DC.B $0,$55,$0,$60,$A2,$2,$F7,$DF,$22,$BE,$36,$41,$3D,$40,$E7,$28,$C2,$A1,$14
  DC.B $86,$2,$9E,$59,$91,$53,$B,$64,$23,$39,$EB,$C7,$3D,$A7,$8F,$8B,$2F
  DC.B $E6,$8E,$4,$C6,$7A,$F2,$A5,$AE,$F0,$C8,$A5,$AF,$6B,$CF,$4F,$32,$5B
  DC.B $2B,$EA,$40,$8C,$F5,$E4,$92,$D8,$6B,$F,$7D,$7A,$1B,$82,$BC         *115
  DC.B $40,$55,$0,$60,$92,$33,$D7,$A5,$5E,$7A,$7F,$F9,$DA,$A,$D9,$2C,$1E,$8E,$74
  DC.B $55,$1A,$23,$BE,$FF,$A1,$73,$31,$AE,$AF,$78,$85,$5F,$CB,$62,$4C,$3A
  DC.B $35,$FC,$5E,$38,$D2,$1A,$A3,$F9,$33,$50,$E4,$41,$5F,$DA,$31,$D2,$EE
  DC.B $5B,$47,$50,$24,$D7,$5F,$2C,$8C,$F3,$19,$8F,$7F,$DF,$C7,$73         *116
  DC.B $80,$55,$0,$60,$A9,$3D,$61,$DC,$9B,$5F,$7B,$1B,$93,$C0,$B3,$6F,$C6,$53,$19
  DC.B $EF,$BC,$98,$75,$F9,$AE,$94,$1A,$EA,$CD,$B,$AB,$8F,$1A,$A,$99,$64
  DC.B $73,$8D,$2D,$8E,$A0,$1,$83,$D,$E6,$BC,$FE,$A,$AA,$99,$48,$87,$70
  DC.B $F0,$54,$F5,$DF,$7F,$A9,$C0,$8E,$F7,$4C,$AD,$AF,$8B,$D7,$62         *117
  DC.B $C0,$55,$0,$60,$B5,$EA,$34,$E0,$E4,$90,$D7,$8A,$A7,$36,$22,$7D,$5F,$8A,$DB
  DC.B $60,$EC,$D3,$9C,$54,$6F,$7F,$C1,$CD,$B6,$96,$D3,$A5,$BC,$B2,$5A,$2
  DC.B $8F,$D6,$CD,$BB,$E6,$9,$1C,$E4,$D3,$9B,$63,$96,$F1,$EF,$36,$23,$2D
  DC.B $A6,$96,$D5,$B2,$30,$4F,$10,$85,$C2,$63,$9A,$53,$90,$1F,$9         *118
  DC.B $0,$56,$0,$60,$27,$B2,$9C,$DA,$FE,$5A,$40,$DE,$6D,$8C,$E6,$91,$2F,$36,$C3
  DC.B $27,$E,$BE,$F8,$BC,$DA,$9B,$96,$97,$C1,$5A,$79,$EA,$7,$3D,$68,$E7
  DC.B $11,$E5,$A2,$AD,$F5,$FC,$90,$0,$68,$9B,$D1,$68,$7D,$22,$FE,$87,$3D
  DC.B $76,$F3,$C4,$6F,$3F,$12,$A,$C8,$A0,$EF,$75,$0,$95,$89,$8E         *119
  DC.B $40,$56,$0,$60,$7A,$81,$CF,$CB,$3C,$47,$E0,$F8,$74,$14,$4B,$5F,$A6,$BB,$A0
  DC.B $54,$C1,$D5,$E2,$74,$B,$CA,$3E,$A8,$82,$B0,$63,$9E,$92,$3B,$57,$34
  DC.B $15,$83,$EF,$3C,$74,$B7,$E9,$7D,$E2,$DC,$15,$95,$A3,$EB,$D,$BE,$F0
  DC.B $FF,$E2,$A3,$77,$AC,$7B,$C3,$47,$F0,$26,$92,$7F,$F4,$CF,$7D         *11a
  DC.B $80,$56,$0,$60,$E0,$8E,$F7,$4C,$7D,$69,$22,$6B,$87,$BC,$36,$31,$B9,$B0,$BA
  DC.B $2,$B5,$F4,$4E,$DB,$5F,$78,$71,$3B,$6D,$40,$AF,$EB,$F9,$95,$9A,$CA
  DC.B $2C,$7E,$B5,$F7,$9E,$F4,$B5,$DE,$F,$EF,$E8,$B2,$AB,$46,$37,$3D,$F7
  DC.B $81,$27,$93,$0,$1A,$62,$38,$BC,$B2,$D8,$EC,$B2,$19,$A2,$D3         *11b
  DC.B $C0,$56,$0,$60,$5C,$96,$BF,$A7,$6B,$EE,$50,$3B,$3A,$A2,$81,$9A,$72,$76,$E4
  DC.B $CF,$24,$36,$3B,$DF,$1C,$77,$BE,$57,$87,$A1,$BF,$3D,$E5,$2A,$1D,$F2
  DC.B $27,$9A,$48,$9E,$6B,$EC,$FA,$AF,$3C,$C0,$61,$73,$37,$8F,$A,$9D,$2D
  DC.B $AB,$DE,$AC,$B,$79,$8C,$A,$B5,$18,$59,$D0,$F0,$A2,$65,$B5         *11c
  DC.B $0,$57,$0,$60,$3D,$F3,$15,$A7,$9A,$9A,$F9,$A2,$B6,$51,$26,$A1,$AC,$5B,$7C
  DC.B $9E,$68,$1C,$17,$73,$31,$E0,$25,$9E,$6F,$4D,$EA,$A4,$11,$44,$0,$DE
  DC.B $7F,$E3,$78,$40,$3C,$FC,$19,$8D,$E0,$C,$C3,$31,$D9,$C4,$76,$E,$B6
  DC.B $A,$1E,$38,$5C,$6F,$5F,$94,$8F,$6D,$5F,$AE,$88,$47,$56,$8E         *11d
  DC.B $40,$57,$0,$60,$86,$E4,$77,$BE,$E7,$E2,$4C,$9A,$63,$65,$83,$DA,$98,$86,$8E
  DC.B $58,$19,$BD,$6B,$BD,$87,$AD,$45,$FE,$36,$6E,$1E,$87,$AC,$F9,$A0,$31
  DC.B $C8,$C9,$F9,$E6,$8B,$7C,$30,$D2,$79,$A3,$BC,$7F,$1E,$2E,$1F,$5F,$9E
  DC.B $3,$5F,$D2,$A3,$AB,$E4,$FC,$F3,$A,$D3,$CD,$10,$C5,$DE,$8         *11e
  DC.B $80,$57,$0,$60,$F0,$80,$89,$F0,$35,$86,$30,$35,$62,$D7,$E5,$AC,$6D,$EA,$C0
  DC.B $D4,$96,$47,$7B,$50,$FC,$97,$FD,$34,$56,$F2,$23,$BD,$F1,$CF,$34,$5B
  DC.B $D3,$6E,$42,$8F,$8A,$8F,$F6,$C5,$C3,$C7,$84,$4E,$8A,$D8,$99,$A4,$B8
  DC.B $99,$B4,$F0,$18,$A7,$F7,$26,$3D,$7D,$C,$D6,$29,$9,$8D,$0         *11f
  DC.B $C0,$57,$0,$60,$D4,$90,$64,$20,$39,$79,$38,$D1,$4E,$FF,$19,$A,$29,$BE,$35
  DC.B $DE,$51,$3F,$99,$A4,$D0,$C9,$DC,$5E,$A1,$DD,$99,$4D,$52,$37,$9,$89
  DC.B $BD,$25,$82,$65,$34,$C4,$E3,$23,$C,$47,$21,$A3,$D1,$D1,$BC,$79,$80
  DC.B $14,$FD,$1C,$CA,$F8,$9C,$67,$F1,$31,$CD,$E8,$35,$77,$46,$4         *120
  DC.B $0,$58,$0,$60,$92,$F,$4A,$65,$F2,$62,$F1,$EC,$3A,$1D,$16,$FA,$F,$78,$87
  DC.B $4C,$D1,$DB,$C7,$E4,$2D,$A3,$2D,$3F,$16,$AD,$89,$35,$BE,$2D,$F7,$46
  DC.B $19,$F1,$78,$73,$1A,$19,$4,$F4,$A6,$34,$36,$48,$32,$BB,$B2,$68,$76
  DC.B $4D,$1D,$EF,$8D,$F,$E5,$17,$D4,$70,$4F,$49,$F4,$1D,$1,$94         *121
  DC.B $40,$58,$0,$60,$5A,$94,$E2,$A7,$E0,$49,$9F,$4A,$29,$AF,$FA,$A8,$A2,$EE,$E8
  DC.B $B6,$1E,$6F,$36,$6A,$D2,$4F,$AB,$D7,$61,$E0,$9C,$A1,$E4,$40,$21,$FE
  DC.B $AF,$23,$14,$DF,$FD,$59,$66,$2A,$88,$6F,$FE,$A8,$78,$A3,$62,$F8,$F2
  DC.B $EE,$2E,$7C,$3F,$C7,$96,$63,$B1,$1F,$57,$C7,$90,$3,$C0,$E8         *122
  DC.B $80,$58,$0,$60,$F,$C7,$49,$3E,$14,$53,$E0,$1F,$F8,$7A,$EF,$81,$3,$F0,$F2
  DC.B $3F,$2,$49,$F0,$FB,$BE,$28,$FF,$C3,$EA,$F8,$3A,$E8,$A3,$A5,$DF,$C1
  DC.B $76,$1B,$D0,$77,$C1,$8A,$3A,$2F,$8E,$F8,$2F,$48,$66,$90,$7A,$BE,$F
  DC.B $77,$C1,$21,$F0,$72,$3F,$4,$B3,$F1,$6E,$FC,$12,$FF,$C5,$C5         *123
  DC.B $C0,$58,$0,$60,$F0,$65,$FC,$5B,$D1,$F0,$40,$7E,$4,$47,$C3,$65,$F8,$71,$7C
  DC.B $58,$F,$C3,$77,$E2,$E5,$FC,$30,$1F,$8B,$2F,$C3,$A1,$DF,$14,$69,$4
  DC.B $2F,$AB,$E2,$C8,$7C,$5F,$70,$92,$AA,$BD,$D5,$E,$D0,$3F,$15,$24,$F8
  DC.B $A8,$8F,$D5,$C7,$7C,$5E,$BB,$E2,$F2,$E1,$70,$3B,$F5,$58,$86         *124
  DC.B $0,$59,$0,$60,$78,$AA,$B2,$8C,$D3,$55,$6,$A1,$F4,$BF,$FA,$AC,$BF,$D5,$4B
  DC.B $23,$E2,$50,$54,$17,$CB,$FD,$57,$5B,$F5,$3D,$DF,$A8,$88,$FD,$4F,$57
  DC.B $EA,$48,$F,$12,$92,$C,$F1,$BA,$2F,$F7,$41,$FE,$E9,$3F,$D2,$43,$F4
  DC.B $F7,$7E,$9E,$AF,$D3,$AD,$FA,$4B,$7F,$4E,$5F,$F6,$E2,$FD,$11         *125
  DC.B $40,$59,$0,$60,$7F,$B6,$EF,$F7,$CB,$FE,$D1,$DF,$A2,$C,$6E,$FD,$F7,$F7,$97
  DC.B $E3,$77,$DA,$F4,$E4,$FD,$73,$F,$2D,$AA,$6D,$92,$B4,$92,$CB,$FC,$B4
  DC.B $39,$63,$1C,$58,$D5,$C5,$A3,$A9,$B5,$98,$F4,$E5,$8D,$BD,$36,$B2,$38
  DC.B $B,$D8,$69,$F2,$52,$D,$83,$73,$6C,$DE,$B4,$83,$9D,$59,$EB         *126
  DC.B $80,$59,$0,$60,$32,$73,$C1,$BD,$66,$E7,$3A,$5B,$D6,$4B,$73,$D9,$BD,$65,$6F
  DC.B $48,$8A,$DC,$5C,$CB,$54,$CE,$7A,$DC,$87,$A5,$D7,$AB,$82,$F4,$B,$27
  DC.B $DA,$99,$A6,$FD,$20,$DE,$82,$C6,$4E,$3,$2E,$BE,$F9,$E3,$1E,$24,$8E
  DC.B $AC,$A0,$C7,$B3,$9E,$92,$E1,$4E,$FA,$5F,$AA,$A7,$C4,$A7,$11         *127
  DC.B $C0,$59,$0,$60,$E1,$2C,$EE,$6,$3F,$BE,$54,$56,$C4,$71,$5A,$A0,$C7,$F1,$C4
  DC.B $6,$3F,$8F,$B1,$AD,$9C,$76,$3C,$EB,$4C,$33,$83,$36,$B6,$70,$A9,$AB
  DC.B $3A,$58,$3E,$29,$4E,$7C,$4D,$C5,$F1,$70,$5F,$3E,$57,$C5,$F8,$58,$3E
  DC.B $4F,$3B,$C6,$39,$C6,$EE,$2C,$18,$5F,$3C,$EE,$29,$E7,$9B,$3F         *128
  DC.B $0,$5A,$0,$60,$B7,$78,$1A,$D,$2C,$61,$CE,$C8,$C1,$85,$EB,$3D,$C0,$1A,$9
  DC.B $FB,$3C,$EF,$15,$8D,$CC,$30,$E5,$E8,$2E,$B7,$D6,$4F,$71,$B0,$F6,$E2
  DC.B $BF,$FD,$F4,$A2,$BD,$B9,$61,$AB,$19,$EF,$A,$BB,$5A,$7C,$15,$42,$BD
  DC.B $34,$37,$5E,$DB,$88,$9D,$E5,$CB,$13,$5,$8C,$A6,$95,$BA,$E8         *129
  DC.B $40,$5A,$0,$60,$2E,$AF,$CC,$56,$F2,$F5,$E3,$12,$4D,$37,$37,$4B,$77,$97,$22
  DC.B $30,$27,$B4,$D1,$83,$2F,$A5,$35,$39,$30,$14,$79,$EB,$42,$9C,$F5,$E0
  DC.B $CF,$E5,$7A,$EA,$79,$E1,$C0,$73,$C5,$A1,$BF,$37,$6C,$F8,$95,$E0,$6F
  DC.B $D9,$C3,$A7,$AF,$18,$92,$6B,$95,$61,$69,$B8,$32,$A,$EB,$4A         *12a
  DC.B $80,$5A,$0,$60,$6,$96,$4F,$5C,$EB,$D6,$78,$DC,$43,$F1,$D7,$DF,$E9,$A5,$17
  DC.B $3C,$1F,$96,$48,$AE,$81,$43,$7B,$E9,$76,$4A,$AF,$2D,$C0,$2E,$1,$DE
  DC.B $17,$3B,$BC,$B4,$32,$FB,$CB,$D6,$BE,$E4,$F2,$7B,$D7,$20,$63,$29,$F6
  DC.B $B2,$8B,$D3,$0,$E8,$10,$CE,$30,$C8,$9,$D0,$41,$9E,$DE,$CD         *12b
  DC.B $C0,$5A,$0,$60,$C6,$79,$F5,$FB,$3C,$14,$58,$45,$B7,$96,$D2,$16,$D3,$A9,$36
  DC.B $23,$2D,$95,$D8,$2E,$6C,$5A,$AF,$25,$BC,$4,$18,$FA,$D8,$B6,$53,$59
  DC.B $25,$3F,$60,$35,$CA,$21,$1D,$79,$4C,$9F,$17,$60,$35,$B6,$19,$D,$A1
  DC.B $D1,$B6,$B1,$BD,$7A,$6C,$F1,$67,$49,$D7,$AB,$5,$EB,$67,$98         *12c
  DC.B $0,$5B,$0,$60,$96,$D3,$8B,$69,$32,$3F,$4A,$3D,$80,$D5,$C0,$2C,$E7,$85,$69
  DC.B $37,$39,$42,$B4,$99,$86,$F5,$E9,$AF,$88,$DF,$E2,$10,$17,$11,$FD,$79
  DC.B $F4,$DB,$7F,$BC,$41,$B2,$5D,$84,$B1,$C6,$F3,$AA,$AA,$F7,$35,$31,$89
  DC.B $26,$9B,$4F,$3C,$46,$F2,$CD,$44,$C2,$2,$D9,$29,$6D,$31,$8E         *12d
  DC.B $40,$5B,$0,$60,$5E,$5F,$A5,$85,$60,$1A,$1A,$4D,$88,$E7,$8E,$59,$E6,$4F,$CF
  DC.B $37,$1C,$F3,$4A,$53,$CD,$DC,$4F,$32,$C5,$2C,$D2,$C1,$4B,$30,$94,$8E
  DC.B $60,$E9,$1C,$D7,$CA,$59,$8F,$23,$DB,$D9,$C8,$FD,$E1,$64,$70,$F2,$3F
  DC.B $BE,$54,$4E,$AF,$FD,$3A,$F,$89,$54,$32,$4A,$AA,$78,$DD,$5A         *12e
  DC.B $80,$5B,$0,$60,$F9,$6C,$E7,$E8,$DC,$50,$4D,$9B,$81,$3E,$59,$B9,$F2,$1B,$8B
  DC.B $27,$84,$5D,$FB,$AF,$30,$82,$CF,$B,$CB,$93,$62,$AD,$1A,$4F,$D2,$78
  DC.B $AD,$3B,$9E,$11,$73,$E3,$79,$8D,$BF,$33,$73,$D1,$F0,$3A,$52,$9E,$F4
  DC.B $BD,$2C,$3F,$33,$73,$FA,$F7,$2F,$9F,$78,$F3,$AD,$25,$E3,$ED         *12f
  DC.B $C0,$5B,$0,$60,$77,$12,$18,$EF,$31,$93,$16,$F3,$30,$4B,$D5,$86,$52,$DC,$EB
  DC.B $7F,$98,$CE,$32,$9F,$91,$12,$B6,$1D,$6C,$C,$D8,$A,$E6,$3B,$49,$8B
  DC.B $97,$DF,$75,$6F,$4D,$E5,$4F,$BB,$48,$AA,$27,$4D,$7D,$24,$D3,$52,$AB
  DC.B $7D,$D5,$DC,$7E,$6C,$79,$36,$E4,$5D,$5E,$22,$3E,$28,$5D,$4C         *130
  DC.B $0,$5C,$0,$60,$BA,$60,$42,$DB,$91,$75,$32,$E7,$3E,$9,$C7,$4,$E0,$DC,$10
  DC.B $A3,$8E,$B,$79,$AB,$4E,$CC,$8,$5E,$E3,$82,$70,$26,$5B,$E,$E7,$2B
  DC.B $3D,$C5,$9D,$D8,$B5,$EE,$2C,$EE,$C8,$3B,$C1,$3B,$C1,$E,$E1,$3D,$E
  DC.B $4C,$72,$B,$D0,$42,$E,$62,$F4,$10,$DD,$E0,$9F,$F9,$C2,$97         *131
  DC.B $40,$5C,$0,$60,$D1,$6B,$D8,$45,$8E,$EF,$37,$22,$BE,$7F,$F2,$16,$C4,$A2,$BE
  DC.B $EB,$63,$EC,$E2,$2D,$17,$32,$D7,$8A,$F4,$65,$31,$C0,$1D,$36,$21,$A1
  DC.B $F8,$14,$8B,$CC,$E5,$C9,$D0,$BE,$92,$C2,$77,$B5,$D4,$33,$19,$27,$DD
  DC.B $98,$32,$BF,$90,$DF,$87,$53,$24,$CC,$39,$16,$62,$E3,$36,$6C         *132
  DC.B $80,$5C,$0,$60,$5B,$FC,$D0,$3B,$F0,$EA,$65,$FD,$22,$B0,$5A,$17,$E,$28,$52
  DC.B $F2,$D6,$BA,$B4,$7B,$9B,$1F,$6E,$49,$E4,$4C,$39,$1F,$9A,$4D,$E2,$F8
  DC.B $72,$37,$73,$A7,$73,$A6,$FF,$5D,$21,$BA,$1D,$21,$90,$23,$B3,$D3,$F3
  DC.B $7A,$E7,$1B,$11,$7B,$9C,$6C,$49,$B8,$36,$A5,$9C,$1B,$50,$3C         *133
  DC.B $C0,$5C,$0,$60,$1B,$5C,$EE,$D,$A9,$3E,$D,$8A,$6E,$6D,$8B,$8E,$6D,$8B,$61
  DC.B $31,$8B,$15,$31,$88,$14,$C6,$4,$C,$52,$C5,$B1,$FD,$F2,$A2,$CA,$71
  DC.B $2D,$15,$BD,$30,$1,$A8,$AD,$E0,$62,$CA,$B,$22,$B8,$5E,$D2,$8A,$DE
  DC.B $99,$8,$84,$56,$FF,$63,$6F,$2A,$36,$F4,$23,$18,$8E,$C5,$35         *134
  DC.B $0,$5D,$0,$60,$58,$A6,$BA,$A,$68,$1D,$EC,$64,$5A,$4,$5E,$ED,$89,$43,$BB
  DC.B $63,$FC,$DB,$1C,$28,$BE,$7,$37,$53,$92,$3B,$A,$1B,$71,$5E,$86,$F3
  DC.B $A5,$62,$5E,$E,$FC,$E8,$3B,$D3,$8,$3B,$28,$90,$75,$3B,$CB,$1C,$3A
  DC.B $F8,$25,$3A,$82,$50,$24,$13,$91,$60,$9F,$6C,$7A,$39,$ED,$87         *135
  DC.B $40,$5D,$0,$60,$5A,$6A,$CE,$37,$AD,$DC,$48,$ED,$4E,$48,$ED,$47,$23,$B5,$CE
  DC.B $91,$DA,$93,$91,$D8,$A6,$EE,$D8,$BB,$DD,$B1,$6D,$5C,$62,$C5,$5C,$62
  DC.B $22,$B8,$C0,$82,$F0,$C4,$99,$7C,$C4,$7C,$7D,$62,$4E,$8,$44,$4E,$A
  DC.B $22,$80,$C3,$4E,$80,$D6,$92,$26,$F3,$A4,$4D,$E1,$54,$4D,$F3         *136
  DC.B $80,$5D,$0,$60,$89,$8D,$E6,$4C,$55,$A6,$2A,$75,$31,$32,$26,$2A,$5F,$FB,$D
  DC.B $BF,$E4,$DB,$FE,$9B,$7F,$1F,$B1,$4B,$E5,$C5,$2,$A6,$29,$63,$17,$1F
  DC.B $E9,$B7,$F4,$DB,$FA,$6D,$9D,$EC,$71,$AD,$79,$13,$5A,$A4,$4D,$E7,$52
  DC.B $26,$F0,$D9,$13,$7C,$F5,$C6,$F3,$2C,$55,$AC,$54,$EA,$C4,$C8         *137
  DC.B $C0,$5D,$0,$60,$B1,$52,$AF,$94,$45,$7C,$84,$4C,$91,$E3,$34,$72,$74,$CB,$22
  DC.B $24,$A6,$44,$94,$11,$26,$D4,$49,$BD,$12,$E7,$64,$8B,$86,$24,$5E,$7A
  DC.B $45,$FD,$69,$19,$CA,$91,$90,$CF,$F3,$6F,$F3,$6F,$F3,$6F,$43,$D8,$CC
  DC.B $4A,$B1,$91,$F4,$8C,$8A,$D1,$7F,$3C,$36,$F0,$DB,$C3,$6C,$EF         *138
  DC.B $0,$5E,$0,$60,$C7,$12,$9A,$49,$28,$49,$26,$D9,$24,$DF,$24,$B9,$F2,$C5,$C3
  DC.B $16,$2F,$D5,$62,$F5,$6B,$19,$CA,$B1,$90,$C5,$F3,$2C,$8B,$E7,$D1,$D9
  DC.B $23,$D7,$85,$27,$DF,$95,$13,$E5,$35,$13,$E0,$11,$3D,$4F,$44,$F4,$51
  DC.B $1B,$58,$90,$DB,$12,$1F,$3C,$90,$F8,$DD,$21,$F0,$A2,$43,$E9         *139
  DC.B $40,$5E,$0,$60,$3E,$1B,$78,$6D,$E1,$B7,$A7,$DA,$F3,$72,$D7,$D8,$A9,$5F,$78
  DC.B $45,$D3,$C8,$F8,$6D,$E1,$B7,$86,$D9,$FC,$27,$E,$53,$C9,$1C,$4,$91
  DC.B $A9,$F2,$46,$8C,$91,$B5,$8B,$D,$B1,$61,$F3,$CB,$F,$8D,$2C,$3E,$16
  DC.B $B0,$FA,$4A,$FD,$B2,$AF,$D8,$D5,$9E,$77,$77,$29,$F6,$E1,$11         *13a
  DC.B $80,$5E,$0,$60,$B1,$E5,$46,$C7,$84,$6D,$2B,$A3,$68,$F2,$36,$53,$92,$B2,$12
  DC.B $56,$6D,$4A,$CD,$6A,$56,$5D,$4A,$DC,$2F,$C3,$6F,$D,$BC,$36,$F4,$FB
  DC.B $19,$7A,$B1,$8C,$89,$18,$6E,$8B,$B7,$E3,$C3,$6F,$D,$BC,$36,$CF,$94
  DC.B $EB,$1F,$E4,$D8,$F1,$26,$D2,$BC,$9B,$47,$A4,$D9,$48,$B5,$90         *13b
  DC.B $C0,$5E,$0,$60,$96,$B3,$6A,$D6,$6B,$56,$B2,$EA,$D6,$E2,$D7,$ED,$C6,$BF,$6E
  DC.B $E7,$24,$78,$CF,$D9,$3C,$CE,$1D,$13,$28,$22,$64,$3A,$26,$1C,$54,$4C
  DC.B $91,$91,$32,$3E,$48,$12,$82,$40,$4D,$D2,$2,$76,$90,$1B,$D2,$7,$3B
  DC.B $E1,$B7,$86,$DE,$1B,$7A,$3B,$B7,$32,$C1,$7F,$89,$5,$E1,$17         *13c
  DC.B $0,$5F,$0,$60,$42,$78,$6D,$E1,$B7,$86,$D9,$F5,$38,$14,$24,$82,$1E,$48,$4
  DC.B $B2,$41,$20,$92,$8,$F9,$60,$4A,$B,$1,$37,$58,$9,$DA,$C0,$6F,$58
  DC.B $1C,$EA,$F8,$38,$75,$C0,$FF,$19,$AC,$45,$F9,$29,$11,$91,$61,$FA,$73
  DC.B $46,$D8,$19,$55,$2F,$A8,$DA,$BE,$EF,$F4,$28,$DB,$D6,$36,$D3         *13d
  DC.B $40,$5F,$0,$60,$B1,$B6,$44,$46,$D6,$38,$DB,$72,$46,$D5,$81,$75,$E5,$F1,$B7
  DC.B $94,$5D,$79,$2F,$BF,$1C,$BB,$BF,$1C,$3F,$65,$3F,$39,$5D,$B1,$C7,$DB
  DC.B $1D,$89,$FF,$46,$DE,$51,$9B,$6F,$47,$27,$CA,$A9,$7D,$41,$DE,$7B,$B7
  DC.B $87,$84,$1D,$AE,$E,$48,$F4,$AF,$7,$6F,$D8,$3B,$47,$B9,$F2         *13e
  DC.B $80,$5F,$0,$60,$F8,$4C,$B1,$C3,$B6,$22,$5E,$D8,$E,$ED,$8B,$87,$65,$2A,$BD
  DC.B $ED,$89,$7D,$DB,$1D,$89,$CB,$25,$55,$1C,$46,$62,$55,$F,$9D,$AB,$13
  DC.B $2F,$70,$14,$65,$EE,$11,$FB,$2F,$71,$58,$B2,$76,$33,$70,$D6,$5E,$E2
  DC.B $E4,$1B,$97,$58,$1D,$C2,$9D,$4F,$B,$E7,$C9,$E1,$6D,$E8,$85         *13f
  DC.B $C0,$5F,$0,$60,$81,$10,$8C,$B4,$42,$51,$68,$84,$88,$A2,$10,$4A,$90,$49,$71
  DC.B $20,$92,$88,$90,$49,$A4,$11,$14,$82,$37,$1F,$A4,$47,$E9,$11,$FA,$44
  DC.B $7A,$DC,$40,$7C,$2,$C1,$F2,$C9,$7,$C3,$38,$B1,$7F,$45,$5F,$E4,$47
  DC.B $F2,$23,$D0,$92,$3,$4,$90,$D9,$72,$43,$A2,$E4,$87,$11,$9C         *140
  DC.B $0,$60,$0,$60,$31,$2A,$C1,$CB,$8B,$7,$28,$D4,$1C,$8A,$D,$15,$D,$B8,$5C
  DC.B $36,$F5,$C3,$E7,$DF,$4E,$21,$6D,$62,$78,$B4,$51,$1F,$79,$44,$5F,$54
  DC.B $45,$8D,$11,$6C,$D1,$17,$46,$48,$5C,$4A,$90,$B0,$9A,$42,$E6,$A9,$B
  DC.B $8F,$24,$22,$BC,$36,$F0,$DB,$C3,$6F,$4F,$B0,$8D,$8A,$11,$6E         *141
  DC.B $40,$60,$0,$60,$24,$22,$CB,$17,$55,$E1,$B7,$86,$DE,$1B,$67,$C4,$77,$79,$9C
  DC.B $4E,$B3,$88,$39,$C4,$67,$38,$94,$65,$9,$12,$A8,$40,$9A,$84,$99,$50
  DC.B $91,$E5,$8,$A5,$C2,$22,$B8,$46,$A6,$48,$F0,$BD,$AD,$13,$C5,$5C,$79
  DC.B $11,$38,$AA,$22,$72,$91,$13,$BC,$11,$15,$32,$A2,$2B,$17,$48         *142
  DC.B $80,$60,$0,$60,$56,$28,$E1,$5D,$11,$C2,$B8,$6B,$85,$2,$B3,$85,$25,$6F,$86
  DC.B $DE,$1B,$78,$6D,$EF,$EC,$28,$C9,$42,$8F,$8E,$14,$78,$8B,$D7,$F8,$E1
  DC.B $E1,$B7,$86,$D9,$F6,$38,$4E,$2B,$38,$F9,$27,$1F,$7C,$9C,$5E,$59,$C5
  DC.B $8A,$54,$2C,$56,$A1,$74,$45,$B,$86,$A8,$70,$B9,$43,$CA,$D5         *143
  DC.B $C0,$60,$0,$60,$C3,$C7,$2E,$1D,$69,$92,$3C,$85,$96,$F,$D0,$A1,$66,$8E,$B3
  DC.B $AD,$1D,$79,$A3,$F1,$46,$8F,$C5,$68,$FD,$E3,$90,$70,$72,$8,$8E,$41
  DC.B $40,$72,$D,$C5,$C8,$21,$E7,$C3,$6F,$D,$BC,$36,$F7,$F6,$41,$96,$A9
  DC.B $6,$47,$20,$CA,$11,$6A,$F0,$DB,$C3,$6F,$D,$B3,$D8,$E1,$D6         *144
  DC.B $0,$61,$0,$60,$76,$71,$D7,$A7,$1F,$8C,$9C,$7E,$2C,$E3,$F7,$8A,$41,$C1,$49
  DC.B $44,$52,$54,$8A,$4B,$71,$52,$50,$F5,$72,$50,$B2,$E4,$B2,$C3,$24,$78
  DC.B $6A,$D,$7E,$35,$5C,$5A,$95,$F4,$B5,$2B,$D3,$52,$AC,$EB,$52,$AF,$DA
  DC.B $97,$95,$4E,$4F,$84,$39,$3E,$FD,$C3,$4F,$C7,$D,$2F,$2E,$1A         *145
  DC.B $40,$61,$0,$60,$5F,$8F,$D,$BC,$36,$F0,$DB,$DF,$D8,$68,$17,$28,$69,$32,$E1
  DC.B $A4,$B9,$16,$9C,$F0,$DB,$C3,$6F,$D,$B3,$D8,$E4,$DF,$59,$D3,$7A,$9D
  DC.B $35,$9D,$9D,$35,$FC,$E9,$F2,$A9,$49,$F0,$AA,$4F,$BF,$50,$DF,$E2,$86
  DC.B $EF,$2A,$1B,$BF,$B,$86,$EE,$D7,$D,$86,$FD,$EA,$EE,$36,$AF         *146
  DC.B $80,$61,$0,$60,$50,$DB,$DA,$1B,$4F,$AF,$41,$EA,$9B,$38,$3B,$CC,$F5,$5A,$EE
  DC.B $40,$95,$FE,$17,$DB,$82,$86,$D3,$F3,$F3,$AC,$8D,$3F,$E3,$BD,$A2,$63
  DC.B $23,$7C,$71,$F8,$36,$FC,$ED,$27,$59,$58,$66,$DA,$95,$E1,$8D,$2B,$C2
  DC.B $C7,$49,$B8,$63,$38,$5D,$C7,$27,$CC,$EA,$1B,$56,$32,$9B,$A1         *147
  DC.B $C0,$61,$0,$60,$A7,$5C,$77,$2D,$DE,$2E,$9C,$A3,$5B,$EB,$67,$C,$8E,$33,$6D
  DC.B $17,$77,$F5,$90,$A1,$D6,$1A,$32,$50,$33,$6D,$BB,$37,$DD,$DD,$DD,$EC
  DC.B $43,$7A,$EE,$85,$C1,$76,$EF,$5C,$32,$6,$9D,$DC,$83,$6,$2E,$EA,$EB
  DC.B $2C,$4F,$CD,$F9,$C4,$CF,$B9,$91,$6A,$B4,$E9,$79,$4E,$6D,$E5         *148
  DC.B $0,$62,$0,$60,$14,$4A,$6D,$14,$BB,$8B,$A1,$B,$F3,$1F,$F4,$C8,$B9,$90,$43
  DC.B $20,$86,$42,$19,$10,$C8,$86,$44,$32,$21,$82,$18,$21,$84,$30,$86,$10
  DC.B $C2,$18,$86,$21,$88,$60,$10,$E3,$66,$C9,$3E,$33,$66,$DB,$2E,$EC,$AB
  DC.B $B0,$AA,$7C,$A7,$11,$3B,$E8,$AB,$B0,$AA,$7C,$A7,$11,$3B,$E8         *149
  DC.B $40,$62,$0,$60,$0,$0,$0,$0,$F0,$B4,$4,$9F,$18,$1C,$30,$4B,$1B,$88,$7
  DC.B $2B,$5A,$D1,$2F,$4C,$0,$23,$E3,$5E,$2E,$4E,$0,$2B,$11,$D1,$1,$23
  DC.B $23,$80,$0,$25,$2C,$4B,$1D,$80,$1,$24,$2C,$4D,$2C,$4B,$9D,$80,$2C
  DC.B $4D,$F5,$80,$0,$25,$5D,$80,$2B,$4D,$2B,$88,$1B,$19,$2B,$80         *14a
  DC.B $80,$62,$0,$60,$0,$E0,$0,$24,$3,$23,$5B,$3,$1,$25,$6D,$7,$6B,$84,$20
  DC.B $23,$ED,$5E,$26,$4B,$6B,$40,$1B,$4,$1B,$14,$1,$25,$6D,$7,$3B,$60
  DC.B $20,$23,$EF,$5E,$21,$4B,$7B,$40,$1B,$4,$1B,$14,$3,$60,$20,$48,$68
  DC.B $84,$1E,$48,$48,$40,$28,$84,$1C,$48,$50,$40,$28,$84,$1A,$4D         *14b
  DC.B $C0,$62,$0,$60,$2A,$88,$1C,$49,$8,$88,$82,$42,$18,$D0,$1,$30,$8,$80,$31
  DC.B $88,$1,$20,$40,$7,$1,$84,$71,$88,$1,$84,$0,$2C,$2,$D0,$1,$23
  DC.B $3,$84,$2,$E0,$20,$23,$C1,$5E,$B1,$80,$20,$23,$C1,$5E,$C1,$5E,$31
  DC.B $81,$11,$49,$9,$68,$C9,$7,$C9,$F,$1,$84,$F,$48,$0,$23         *14c
  DC.B $0,$63,$0,$60,$C0,$5E,$1,$21,$49,$7,$48,$84,$F0,$BC,$70,$47,$C8,$2A,$0
  DC.B $40,$D2,$2A,$0,$40,$78,$2B,$0,$40,$D0,$2A,$0,$40,$E1,$BD,$FF,$FF
  DC.B $AC,$A,$1,$0,$E1,$BD,$0,$0,$C8,$29,$0,$40,$5A,$5A,$0,$0,$2
  DC.B $60,$0,$0,$CA,$29,$0,$40,$FC,$5,$1,$0,$6C,$1,$1,$0         *14d
  DC.B $40,$63,$0,$60,$6C,$10,$9F,$E5,$B0,$10,$D1,$E1,$7,$0,$51,$E3,$17,$0,$0
  DC.B $1A,$60,$10,$9F,$E5,$B0,$20,$D1,$E1,$1,$20,$82,$E2,$B0,$20,$C1,$E1
  DC.B $2,$18,$A0,$E1,$21,$18,$A0,$E1,$A,$A,$51,$E3,$F,$0,$0,$1A,$44
  DC.B $10,$9F,$E5,$F0,$20,$D1,$E1,$C2,$37,$A0,$E1,$42,$36,$23,$E0         *14e
  DC.B $80,$63,$0,$60,$1,$30,$3,$E2,$82,$20,$83,$E1,$B0,$20,$C1,$E1,$7,$30,$A0
  DC.B $E3,$6,$3A,$83,$E2,$2,$22,$A0,$E3,$B2,$32,$C2,$E1,$B0,$30,$D1,$E1
  DC.B $B0,$32,$C2,$E1,$B0,$10,$D1,$E1,$10,$20,$9F,$E5,$B6,$10,$C2,$E1,$E0
  DC.B $DA,$FF,$EA,$C8,$2A,$0,$40,$AE,$A,$1,$0,$B0,$A,$1,$0         *14f
  DC.B $C0,$63,$0,$60,$78,$2B,$0,$40,$0,$0,$0,$0,$0,$0,$0,$0,$0,$23,$42
  DC.B $68,$1,$1C,$0,$2A,$1,$D1,$18,$1C,$70,$47,$C8,$68,$1,$38,$C8,$60
  DC.B $8,$68,$82,$42,$3,$D1,$B,$60,$4B,$60,$10,$1C,$2,$E0,$10,$1C,$12
  DC.B $68,$4A,$60,$81,$79,$0,$29,$EE,$D1,$80,$21,$81,$71,$70,$47         *150
  DC.B $0,$64,$0,$60,$80,$B4,$1,$68,$40,$68,$CA,$68,$1,$32,$CA,$60,$0,$23,$A
  DC.B $68,$0,$2A,$8,$D1,$4F,$68,$0,$2F,$1,$D0,$4A,$60,$6,$E0,$3,$60
  DC.B $8,$60,$48,$60,$2,$E0,$10,$60,$3,$60,$8,$60,$81,$79,$0,$29,$1
  DC.B $D1,$80,$21,$81,$71,$80,$BC,$70,$47,$1,$68,$40,$68,$CA,$68         *151
  DC.B $40,$64,$0,$60,$1,$32,$CA,$60,$A,$68,$0,$2A,$8,$D1,$4B,$68,$0,$2B,$1
  DC.B $D0,$4A,$60,$6,$E0,$0,$22,$2,$60,$8,$60,$1,$E0,$4A,$68,$2,$60
  DC.B $48,$60,$81,$79,$0,$29,$1,$D1,$80,$21,$81,$71,$70,$47,$80,$B4,$6
  DC.B $DF,$0,$6,$0,$E,$7,$49,$87,$0,$7,$4A,$D1,$51,$1,$21         *152
  DC.B $80,$64,$0,$60,$6,$4A,$11,$54,$6,$48,$0,$68,$B,$21,$4,$DF,$5,$48,$C0
  DC.B $59,$80,$BC,$70,$47,$75,$1,$0,$40,$BC,$55,$0,$40,$E4,$55,$0,$40
  DC.B $9C,$2A,$0,$40,$94,$55,$0,$40,$B0,$B4,$5,$6,$2D,$E,$C,$1C,$17
  DC.B $1C,$82,$B0,$6,$DF,$0,$6,$0,$E,$0,$94,$1,$97,$0,$2D         *153
  DC.B $C0,$64,$0,$60,$1,$D1,$9,$49,$0,$E0,$9,$49,$82,$0,$9,$4B,$99,$50,$69
  DC.B $46,$8,$4B,$99,$50,$1,$22,$8,$49,$A,$54,$8,$48,$0,$68,$B,$21
  DC.B $4,$DF,$2,$B0,$B0,$BC,$70,$47,$6F,$0,$0,$40,$35,$0,$0,$40,$BC
  DC.B $55,$0,$40,$94,$55,$0,$40,$E4,$55,$0,$40,$9C,$2A,$0,$40         *154
  DC.B $0,$65,$0,$60,$B0,$B4,$7,$1C,$6,$DF,$0,$6,$0,$E,$8,$49,$84,$0,$8
  DC.B $4A,$11,$51,$8,$4D,$2F,$51,$1,$21,$7,$4A,$11,$54,$7,$48,$0,$68
  DC.B $B,$21,$4,$DF,$28,$59,$B0,$BC,$70,$47,$0,$0,$1,$0,$0,$40,$BC
  DC.B $55,$0,$40,$94,$55,$0,$40,$E4,$55,$0,$40,$9C,$2A,$0,$40         *155
  DC.B $40,$65,$0,$60,$7,$48,$0,$21,$82,$79,$0,$2A,$3,$D0,$98,$30,$1,$31,$1E
  DC.B $29,$F8,$DB,$1E,$29,$2,$DA,$80,$21,$81,$71,$70,$47,$FE,$E7,$0,$0
  DC.B $F0,$2B,$0,$40,$8,$48,$0,$22,$0,$21,$83,$79,$0,$2B,$4,$D1,$1
  DC.B $32,$5,$2A,$1,$DD,$1,$20,$70,$47,$98,$30,$1,$31,$1E,$29         *156
  DC.B $80,$65,$0,$60,$F3,$DB,$0,$20,$70,$47,$0,$0,$F0,$2B,$0,$40,$0,$21,$81
  DC.B $71,$70,$47,$0,$B5,$4,$48,$5,$49,$B,$68,$5,$4A,$0,$21,$7,$F0
  DC.B $3B,$FE,$8,$BC,$18,$47,$0,$0,$F0,$2B,$0,$40,$F4,$47,$0,$60,$D0
  DC.B $11,$0,$0,$B0,$B5,$35,$4F,$B8,$69,$11,$21,$49,$3,$1,$40         *157
  DC.B $C0,$65,$0,$60,$15,$D0,$1,$22,$52,$3,$2,$40,$31,$48,$32,$49,$7,$D0,$0
  DC.B $68,$CA,$6B,$0,$21,$7,$F0,$1E,$FE,$1,$20,$40,$3,$6,$E0,$0,$68
  DC.B $CA,$6B,$1,$21,$7,$F0,$16,$FE,$1,$20,$40,$4,$38,$61,$78,$6A,$C0
  DC.B $B,$48,$D3,$28,$49,$D,$78,$28,$4C,$29,$48,$29,$4B,$0,$2D         *158
  DC.B $0,$66,$0,$60,$16,$D0,$0,$22,$7D,$27,$FF,$0,$1,$2D,$1D,$D0,$2,$2D,$31
  DC.B $D1,$1D,$7F,$2D,$11,$6D,$8,$32,$D3,$1B,$7F,$5B,$8,$2F,$D2,$24,$68
  DC.B $3,$68,$E3,$1A,$96,$2B,$1,$D3,$BB,$42,$1F,$D9,$A,$70,$26,$E0,$1A
  DC.B $7F,$52,$11,$52,$8,$22,$D3,$1A,$7F,$52,$10,$52,$8,$1E,$D2         *159
  DC.B $40,$66,$0,$60,$22,$68,$2,$60,$1,$20,$13,$E0,$1D,$7F,$6D,$11,$6D,$8,$16
  DC.B $D3,$1B,$7F,$5B,$10,$5B,$8,$12,$D3,$24,$68,$3,$68,$E3,$1A,$96,$2B
  DC.B $E4,$D3,$BB,$42,$E2,$D8,$4,$60,$2,$20,$1,$E0,$4,$60,$3,$20,$8
  DC.B $70,$4,$E0,$18,$7F,$0,$11,$40,$8,$0,$D3,$18,$7F,$1,$20         *15a
  DC.B $80,$66,$0,$60,$80,$3,$9,$49,$8,$60,$B0,$BC,$8,$BC,$18,$47,$0,$60,$0
  DC.B $E0,$A4,$2A,$0,$40,$AC,$1,$1,$0,$44,$2A,$0,$40,$50,$0,$1,$0
  DC.B $EC,$29,$0,$40,$0,$80,$1,$E0,$10,$60,$0,$E0,$F0,$B5,$7,$1C,$15
  DC.B $4E,$0,$23,$F0,$5E,$15,$49,$C9,$5E,$44,$1A,$14,$4D,$1,$D5         *15b
  DC.B $C0,$66,$0,$60,$E8,$5E,$24,$18,$0,$23,$E8,$5E,$41,$0,$3,$20,$7,$F0,$CA
  DC.B $FD,$A0,$42,$4,$DA,$F,$48,$1,$78,$1,$23,$19,$43,$1,$70,$0,$23
  DC.B $E8,$5E,$1,$38,$A0,$42,$C,$DD,$F0,$5E,$F1,$5E,$1,$30,$30,$80,$9
  DC.B $48,$0,$68,$47,$54,$F0,$5E,$E9,$5E,$88,$42,$1,$DB,$0,$20         *15c
  DC.B $0,$67,$0,$60,$30,$80,$F0,$BC,$8,$BC,$18,$47,$64,$0,$1,$0,$66,$0,$1
  DC.B $0,$68,$0,$1,$0,$14,$80,$1,$E0,$6C,$0,$1,$0,$0,$B5,$3,$48
  DC.B $0,$68,$7,$F0,$73,$FD,$80,$10,$8,$BC,$18,$47,$E8,$47,$0,$60,$FF
  DC.B $20,$8,$49,$B,$78,$8,$4A,$11,$78,$8B,$42,$8,$D0,$48,$1C         *15d
  DC.B $40,$67,$0,$60,$10,$70,$6,$48,$40,$5C,$11,$78,$80,$29,$1,$D1,$0,$21,$11
  DC.B $70,$70,$47,$0,$0,$8B,$1,$1,$0,$8C,$1,$1,$0,$F0,$55,$0,$40
  DC.B $90,$B5,$F,$48,$0,$68,$7,$F0,$51,$FD,$4,$1C,$D,$48,$0,$23,$C0
  DC.B $5E,$D,$49,$C9,$5E,$47,$1A,$C,$48,$1,$D5,$C1,$5E,$7F,$18         *15e
  DC.B $80,$67,$0,$60,$0,$23,$C1,$5E,$3,$20,$7,$F0,$6D,$FD,$B8,$42,$4,$DD,$8
  DC.B $48,$1,$78,$49,$8,$49,$0,$1,$70,$20,$1C,$90,$BC,$8,$BC,$18,$47
  DC.B $EC,$47,$0,$60,$64,$0,$1,$0,$66,$0,$1,$0,$68,$0,$1,$0,$14
  DC.B $80,$1,$E0,$0,$B5,$8,$48,$0,$68,$80,$E,$C0,$6,$8,$D0         *15f
  DC.B $C0,$67,$0,$60,$6,$48,$C1,$6B,$6,$4B,$19,$40,$C1,$63,$6,$48,$0,$68,$7
  DC.B $F0,$1D,$FD,$8,$BC,$18,$47,$0,$0,$B0,$5,$1,$0,$8,$6,$1,$0
  DC.B $1F,$FE,$FF,$FF,$E0,$47,$0,$60,$F0,$B5,$81,$B0,$34,$4E,$35,$4F,$F8
  DC.B $60,$35,$48,$19,$21,$9,$3,$8,$60,$64,$20,$3,$DF,$33,$4D         *160
  DC.B $0,$68,$0,$60,$E8,$1D,$FF,$30,$7A,$30,$C0,$6D,$7,$F0,$0,$FD,$E8,$1D,$F9
  DC.B $30,$80,$6F,$7,$F0,$FB,$FC,$EC,$1D,$79,$34,$60,$6B,$7,$F0,$F6,$FC
  DC.B $0,$20,$A1,$6A,$7,$F0,$F4,$FC,$E8,$6A,$7,$F0,$EF,$FC,$28,$48,$0
  DC.B $68,$7,$F0,$EB,$FC,$F,$28,$3,$D1,$26,$4D,$26,$48,$0,$90         *161
  DC.B $40,$68,$0,$60,$5,$E0,$2,$F0,$6B,$F9,$2,$21,$78,$69,$4,$DF,$F5,$E7,$23
  DC.B $48,$19,$21,$9,$3,$8,$60,$A,$20,$3,$DF,$20,$6D,$7,$F0,$D6,$FC
  DC.B $28,$68,$7,$F0,$D3,$FC,$0,$98,$0,$68,$80,$8,$1E,$D3,$2,$F0,$E5
  DC.B $F9,$1,$F0,$B9,$FD,$1A,$48,$0,$23,$C0,$56,$19,$49,$C9,$56         *162
  DC.B $80,$68,$0,$60,$88,$42,$2,$D1,$30,$68,$0,$28,$2,$D0,$1,$21,$38,$68,$4
  DC.B $DF,$15,$48,$1,$78,$15,$4A,$10,$78,$81,$42,$4,$D0,$1,$30,$10,$70
  DC.B $1,$21,$38,$68,$4,$DF,$1,$F0,$6B,$F9,$D0,$E7,$10,$48,$0,$78,$0
  DC.B $28,$CC,$D0,$F,$48,$19,$21,$9,$3,$8,$60,$FE,$E7,$0,$0         *163
  DC.B $C0,$68,$0,$60,$BC,$0,$1,$0,$94,$2A,$0,$40,$0,$60,$EA,$80,$AC,$1,$1
  DC.B $0,$3C,$48,$0,$60,$44,$48,$0,$60,$84,$1,$1,$0,$0,$C0,$D4,$81
  DC.B $8C,$0,$1,$0,$8D,$0,$1,$0,$70,$2B,$0,$40,$71,$2B,$0,$40,$8A
  DC.B $1,$1,$0,$0,$0,$71,$82,$F0,$B5,$D,$49,$88,$60,$64,$20         *164
  DC.B $0,$69,$0,$60,$3,$DF,$C,$4E,$C,$4D,$0,$20,$C0,$43,$5,$DF,$0,$27,$B
  DC.B $49,$C8,$5D,$0,$28,$7,$D0,$0,$20,$C8,$55,$BC,$0,$28,$59,$31,$59
  DC.B $7,$F0,$76,$FC,$28,$51,$1,$37,$A,$2F,$F0,$D3,$EB,$E7,$0,$0,$94
  DC.B $2A,$0,$40,$BC,$55,$0,$40,$94,$55,$0,$40,$E4,$55,$0,$40         *165
  DC.B $40,$69,$0,$60,$F0,$B5,$18,$4D,$68,$60,$64,$20,$3,$DF,$17,$48,$C4,$1D,$FF
  DC.B $34,$7A,$34,$16,$4E,$C7,$1D,$FF,$37,$FA,$37,$0,$20,$5,$DF,$0,$28
  DC.B $3,$D1,$4,$20,$3,$DF,$0,$20,$5,$DF,$0,$28,$12,$D1,$20,$6E,$7
  DC.B $F0,$4C,$FC,$78,$6C,$7,$F0,$49,$FC,$0,$F0,$81,$FB,$31,$78         *166
  DC.B $80,$69,$0,$60,$B,$4A,$10,$78,$81,$42,$4,$D0,$1,$30,$10,$70,$0,$21,$28
  DC.B $68,$4,$DF,$4,$20,$C0,$8,$E0,$D3,$B8,$6C,$7,$F0,$37,$FC,$0,$F0
  DC.B $6F,$FB,$DA,$E7,$94,$2A,$0,$40,$AC,$1,$1,$0,$40,$2B,$0,$40,$41
  DC.B $2B,$0,$40,$F0,$B5,$E,$4E,$30,$60,$64,$20,$3,$DF,$D,$4D         *167
  DC.B $C0,$69,$0,$60,$D,$4C,$0,$20,$C0,$43,$5,$DF,$7,$1C,$40,$8,$A,$D3,$E0
  DC.B $68,$7,$F0,$1C,$FC,$28,$68,$40,$8,$2,$D3,$A,$21,$70,$69,$4,$DF
  DC.B $2,$23,$1F,$43,$B8,$8,$EC,$D3,$A0,$68,$7,$F0,$F,$FC,$E8,$E7,$94
  DC.B $2A,$0,$40,$C0,$0,$1,$0,$2C,$4,$1,$0,$F0,$B5,$84,$B0         *168
  DC.B $0,$6A,$0,$60,$26,$4F,$B8,$61,$8,$21,$78,$69,$4,$DF,$64,$20,$3,$DF,$24
  DC.B $48,$3,$90,$4,$68,$23,$4B,$2,$93,$23,$48,$1,$90,$23,$49,$0,$91
  DC.B $0,$20,$5,$DF,$6,$1C,$A,$D1,$21,$48,$0,$88,$4,$28,$1,$D1,$64
  DC.B $20,$0,$E0,$5,$20,$3,$DF,$0,$20,$5,$DF,$6,$1C,$3,$98         *169
  DC.B $40,$6A,$0,$60,$0,$68,$1,$1B,$FF,$23,$F5,$33,$99,$42,$7,$D3,$0,$2D,$1
  DC.B $D1,$1,$21,$0,$E0,$0,$21,$D,$6,$2D,$E,$4,$1C,$30,$9,$4,$D3
  DC.B $3,$21,$38,$68,$4,$DF,$10,$20,$5,$DF,$70,$8,$A,$D3,$11,$4A,$B8
  DC.B $69,$81,$0,$2,$9B,$5A,$50,$1,$21,$F,$4A,$11,$54,$B,$21         *16a
  DC.B $80,$6A,$0,$60,$B8,$68,$4,$DF,$B0,$9,$3,$D3,$1,$98,$0,$68,$7,$F0,$BE
  DC.B $FB,$0,$99,$9,$68,$28,$1C,$7,$F0,$BB,$FB,$C1,$E7,$94,$2A,$0,$40
  DC.B $50,$0,$1,$0,$BC,$55,$0,$40,$2C,$48,$0,$60,$28,$48,$0,$60,$C8
  DC.B $2A,$0,$40,$DD,$40,$0,$60,$E4,$55,$0,$40,$F0,$B5,$3,$27         *16b
  DC.B $C0,$6A,$0,$60,$7F,$7,$94,$B0,$0,$97,$B7,$49,$B7,$4A,$13,$92,$80,$32,$12
  DC.B $92,$D1,$65,$B6,$49,$A,$69,$0,$2A,$1,$D0,$48,$61,$0,$E0,$8,$61
  DC.B $0,$27,$0,$23,$B2,$49,$11,$91,$3,$22,$FF,$21,$19,$20,$0,$26,$1
  DC.B $31,$8,$E0,$B,$AD,$EE,$54,$10,$3D,$EE,$54,$3,$AD,$EE,$54         *16c
  DC.B $0,$6B,$0,$60,$1,$33,$1B,$6,$1B,$E,$E,$2B,$F4,$DB,$AA,$4A,$10,$92,$AA
  DC.B $4D,$F,$95,$0,$20,$5,$DF,$0,$28,$1,$D0,$2,$94,$C,$E0,$0,$2F
  DC.B $3,$D1,$0,$23,$2,$93,$D8,$43,$5,$E0,$20,$1C,$3,$DF,$3,$6,$1B
  DC.B $E,$2,$93,$0,$20,$5,$DF,$0,$28,$3E,$D0,$FF,$23,$1,$33         *16d
  DC.B $40,$6B,$0,$60,$98,$42,$37,$D0,$20,$DC,$1,$28,$26,$D0,$2,$28,$2B,$D0,$4
  DC.B $28,$33,$D1,$17,$20,$0,$3,$41,$68,$38,$23,$DB,$43,$19,$40,$41,$60
  DC.B $41,$68,$1,$23,$9B,$3,$19,$43,$41,$60,$41,$68,$93,$4B,$19,$40,$41
  DC.B $60,$1,$68,$38,$23,$DB,$43,$19,$40,$28,$23,$19,$43,$1,$60         *16e
  DC.B $80,$6B,$0,$60,$19,$20,$B,$AB,$98,$70,$18,$E0,$1,$23,$9B,$2,$98,$42,$1A
  DC.B $D0,$DB,$0,$98,$42,$11,$D1,$4D,$E0,$A,$20,$11,$99,$48,$70,$3,$20
  DC.B $B,$AB,$18,$70,$9,$E0,$A,$20,$10,$99,$48,$72,$3,$20,$B,$AB,$58
  DC.B $70,$2,$E0,$2,$20,$D,$AB,$18,$70,$2,$9B,$0,$2B,$5F,$D1         *16f
  DC.B $C0,$6B,$0,$60,$0,$24,$1,$20,$9C,$E0,$12,$9A,$1,$20,$91,$6A,$7,$F0,$20
  DC.B $FB,$7B,$48,$19,$21,$9,$3,$8,$60,$7,$23,$DB,$1,$13,$9A,$D0,$18
  DC.B $37,$22,$52,$1,$0,$21,$83,$6B,$0,$20,$7,$F0,$15,$FB,$96,$20,$3
  DC.B $DF,$74,$48,$10,$23,$DB,$43,$1,$68,$19,$40,$AA,$22,$1,$60         *170
  DC.B $0,$6C,$0,$60,$0,$9F,$71,$4B,$F9,$18,$4A,$75,$55,$22,$5B,$8,$0,$9F,$FB
  DC.B $18,$9A,$72,$A0,$22,$4A,$75,$FF,$21,$43,$14,$0,$9F,$FA,$1A,$11,$70
  DC.B $10,$23,$1,$68,$19,$43,$1,$60,$1B,$2,$0,$9F,$F8,$18,$0,$78,$FF
  DC.B $28,$FD,$D1,$FE,$E7,$1,$98,$38,$40,$5C,$D0,$1,$28,$D,$D0         *171
  DC.B $40,$6C,$0,$60,$2,$28,$B,$D0,$4,$28,$D,$D0,$FF,$23,$1,$33,$98,$42,$52
  DC.B $D1,$A,$20,$D,$AB,$18,$70,$0,$26,$F,$9D,$4A,$E0,$20,$1C,$1,$F0
  DC.B $A5,$FF,$48,$E0,$19,$20,$B,$AB,$98,$70,$7,$A8,$0,$5D,$FF,$23,$58
  DC.B $40,$18,$40,$1,$1C,$7,$A8,$1,$55,$2,$D0,$1,$20,$1,$E0         *172
  DC.B $80,$6C,$0,$60,$41,$E0,$0,$20,$C0,$7,$0,$C,$17,$22,$12,$3,$11,$68,$4B
  DC.B $4B,$19,$40,$8,$43,$10,$60,$2E,$E0,$28,$68,$C2,$78,$81,$78,$8A,$42
  DC.B $14,$D0,$C1,$78,$1,$31,$C1,$70,$28,$68,$41,$78,$3,$29,$4,$D0,$4
  DC.B $29,$B,$D1,$0,$21,$81,$72,$3,$E0,$1,$78,$1,$31,$81,$72         *173
  DC.B $C0,$6C,$0,$60,$1,$21,$28,$68,$1,$71,$28,$68,$C1,$79,$81,$71,$28,$68,$1
  DC.B $79,$1,$29,$1C,$D0,$2,$29,$A,$D1,$81,$79,$C2,$79,$91,$42,$6,$D1
  DC.B $0,$21,$41,$71,$28,$68,$2,$79,$2,$2A,$0,$D1,$1,$71,$4,$35,$1
  DC.B $36,$10,$2E,$D0,$D3,$60,$1C,$4,$6,$24,$E,$1,$98,$40,$0         *174
  DC.B $0,$6D,$0,$60,$1,$90,$E,$2C,$97,$DB,$0,$20,$FF,$24,$1,$21,$2F,$E0,$81
  DC.B $7A,$1,$39,$81,$72,$28,$68,$81,$7A,$0,$29,$E8,$D1,$2,$21,$1,$71
  DC.B $1,$21,$28,$68,$41,$71,$28,$68,$81,$79,$1,$31,$81,$71,$28,$68,$41
  DC.B $7A,$0,$7A,$4,$DF,$DA,$E7,$2,$9B,$0,$2B,$C,$D0,$3A,$1C         *175
  DC.B $40,$6D,$0,$60,$A,$40,$3,$D1,$B,$AA,$12,$5C,$0,$2A,$5,$DD,$B,$AA,$12
  DC.B $5C,$2,$9B,$D3,$18,$B,$AA,$13,$54,$B,$AA,$12,$5C,$0,$2A,$2,$D0
  DC.B $A2,$42,$0,$DA,$14,$1C,$1,$30,$0,$6,$0,$E,$49,$0,$E,$28,$E2
  DC.B $DB,$0,$27,$FF,$2C,$0,$D1,$CB,$E6,$0,$20,$1,$21,$D,$E0         *176
  DC.B $80,$6D,$0,$60,$B,$AA,$12,$5C,$A2,$42,$0,$D1,$F,$43,$A2,$42,$2,$DB,$13
  DC.B $1B,$B,$AA,$13,$54,$1,$30,$0,$6,$0,$E,$49,$0,$E,$28,$EF,$DB
  DC.B $B7,$E6,$0,$0,$1,$A,$0,$40,$AC,$1,$1,$0,$94,$2A,$0,$40,$68
  DC.B $58,$0,$40,$48,$59,$0,$40,$EC,$2A,$0,$40,$FF,$7F,$FF,$FF         *177
  DC.B $C0,$6D,$0,$60,$0,$80,$1A,$86,$C,$80,$0,$E0,$40,$55,$0,$0,$B0,$B4,$7
  DC.B $1C,$6,$DF,$0,$6,$0,$E,$8,$49,$84,$0,$8,$4A,$11,$51,$8,$4D
  DC.B $2F,$51,$1,$21,$7,$4A,$11,$54,$7,$48,$80,$68,$B,$21,$4,$DF,$28
  DC.B $59,$B0,$BC,$70,$47,$0,$0,$D9,$1D,$0,$0,$BC,$55,$0,$40         *178
  DC.B $0,$6E,$0,$60,$94,$55,$0,$40,$E4,$55,$0,$40,$94,$2A,$0,$40,$80,$B4,$7
  DC.B $6,$3F,$E,$5,$4A,$51,$68,$88,$7A,$43,$1C,$8B,$72,$51,$68,$40,$18
  DC.B $C7,$72,$80,$BC,$70,$47,$0,$0,$D8,$2A,$0,$40,$F0,$B5,$7,$1C,$4D
  DC.B $4E,$4E,$4D,$4E,$4C,$8D,$E0,$4E,$49,$9,$78,$CA,$7,$D2,$F         *179
  DC.B $40,$6E,$0,$60,$3,$D1,$4D,$4B,$19,$78,$5,$29,$4C,$DA,$4C,$4B,$19,$78,$49
  DC.B $8,$19,$70,$0,$2A,$F,$D0,$49,$4A,$11,$78,$80,$23,$19,$43,$11,$70
  DC.B $47,$49,$A,$88,$1,$23,$5A,$40,$A,$80,$43,$4A,$11,$78,$8,$29,$4
  DC.B $DA,$1,$31,$1,$E0,$0,$21,$3F,$4A,$11,$70,$40,$49,$A,$88         *17a
  DC.B $80,$6E,$0,$60,$53,$8,$5,$D3,$52,$8,$A,$80,$A,$88,$3E,$4B,$5A,$40,$0
  DC.B $E0,$52,$8,$A,$80,$3C,$4B,$1A,$78,$1,$32,$1A,$70,$1A,$78,$7,$2A
  DC.B $53,$DD,$82,$8,$A,$D3,$2,$23,$DB,$43,$18,$40,$20,$60,$18,$C,$8
  DC.B $80,$32,$4A,$10,$78,$B1,$68,$7,$F0,$AA,$F9,$68,$68,$81,$7A         *17b
  DC.B $C0,$6E,$0,$60,$FF,$29,$5,$DA,$2D,$4A,$10,$78,$71,$68,$7,$F0,$A1,$F9,$5
  DC.B $E0,$0,$21,$81,$72,$3,$23,$20,$68,$18,$43,$20,$60,$0,$21,$2A,$4B
  DC.B $19,$70,$32,$E0,$1A,$1C,$6,$29,$22,$D1,$80,$8,$20,$D2,$24,$49,$8
  DC.B $88,$26,$4B,$98,$42,$C,$D1,$68,$68,$81,$7A,$2,$39,$81,$72         *17c
  DC.B $0,$6F,$0,$60,$68,$68,$80,$7A,$0,$28,$B,$DD,$21,$49,$8,$78,$1,$30,$8
  DC.B $70,$6,$E0,$20,$49,$8,$78,$1,$30,$8,$70,$0,$21,$68,$68,$81,$72
  DC.B $3,$23,$20,$68,$18,$43,$0,$21,$20,$60,$17,$48,$1,$70,$A,$E0,$7
  DC.B $29,$8,$DB,$0,$21,$14,$48,$1,$70,$68,$68,$81,$72,$3,$23         *17d
  DC.B $40,$6F,$0,$60,$20,$68,$18,$43,$20,$60,$0,$21,$11,$70,$A,$49,$8,$78,$40
  DC.B $8,$8,$70,$1,$3F,$0,$2F,$3,$D0,$20,$68,$41,$8,$0,$D2,$6B,$E7
  DC.B $38,$1C,$F0,$BC,$8,$BC,$18,$47,$AC,$3,$1,$0,$D8,$2A,$0,$40,$90
  DC.B $1,$1,$0,$97,$1,$1,$0,$96,$1,$1,$0,$98,$1,$1,$0         *17e
  DC.B $80,$6F,$0,$60,$9A,$1,$1,$0,$8,$84,$0,$0,$99,$1,$1,$0,$85,$4F,$0
  DC.B $0,$89,$1,$1,$0,$8E,$1,$1,$0,$F0,$B5,$2F,$4F,$0,$24,$78,$68
  DC.B $0,$28,$7,$D1,$FF,$F7,$DE,$FA,$0,$28,$45,$D0,$FF,$F7,$5F,$FA,$78
  DC.B $60,$84,$72,$29,$48,$6,$78,$29,$4D,$2A,$4C,$3F,$E0,$3A,$7A         *17f
  DC.B $C0,$6F,$0,$60,$0,$2A,$F,$D1,$4A,$1C,$2,$80,$27,$4A,$51,$5C,$27,$4A,$11
  DC.B $70,$0,$23,$C1,$5E,$FF,$23,$81,$33,$99,$42,$1,$D3,$0,$21,$1,$80
  DC.B $8,$20,$38,$72,$20,$68,$40,$8,$2,$D3,$38,$7A,$E9,$68,$1,$E0,$38
  DC.B $7A,$29,$69,$7,$F0,$C,$F9,$38,$72,$18,$48,$0,$78,$86,$42         *180
  DC.B $0,$70,$0,$60,$1D,$D0,$78,$68,$81,$7A,$C1,$71,$78,$68,$C1,$7A,$1,$72,$78
  DC.B $68,$1,$7B,$41,$72,$2,$20,$79,$68,$88,$72,$7A,$68,$14,$49,$1,$20
  DC.B $FF,$F7,$42,$FA,$13,$48,$1,$78,$1,$31,$1,$70,$0,$21,$79,$60,$3
  DC.B $23,$20,$68,$18,$43,$20,$60,$F0,$BC,$8,$BC,$18,$47,$E,$48         *181
  DC.B $40,$70,$0,$60,$0,$23,$C2,$5E,$D,$48,$C1,$5E,$8A,$42,$B8,$D1,$3A,$7A,$0
  DC.B $2A,$B5,$D1,$F0,$BC,$8,$BC,$18,$47,$D8,$2A,$0,$40,$89,$1,$1,$0
  DC.B $AC,$3,$1,$0,$90,$1,$1,$0,$A8,$6,$1,$0,$97,$1,$1,$0,$E0
  DC.B $3D,$0,$40,$E4,$2A,$0,$40,$7C,$1,$1,$0,$7E,$1,$1,$0         *182
  DC.B $80,$70,$0,$60,$F0,$B5,$1,$25,$84,$B0,$4E,$48,$3,$90,$4E,$48,$2,$90,$4E
  DC.B $4F,$8F,$E0,$2,$98,$FF,$F7,$34,$FA,$4,$1C,$62,$D0,$3,$98,$0,$68
  DC.B $80,$8,$5F,$D3,$49,$49,$8,$78,$0,$90,$0,$20,$79,$6A,$7,$F0,$AF
  DC.B $F8,$5,$40,$46,$48,$47,$49,$8,$80,$0,$20,$46,$49,$8,$70         *183
  DC.B $C0,$70,$0,$60,$46,$49,$8,$70,$46,$49,$8,$70,$20,$7A,$B9,$69,$7,$F0,$A0
  DC.B $F8,$20,$7A,$F9,$69,$7,$F0,$9C,$F8,$5,$40,$60,$7A,$B9,$69,$7,$F0
  DC.B $97,$F8,$60,$7A,$F9,$69,$7,$F0,$93,$F8,$28,$40,$0,$25,$6,$1C,$C
  DC.B $E0,$60,$19,$1,$90,$C0,$7A,$B9,$69,$7,$F0,$89,$F8,$1,$98         *184
  DC.B $0,$71,$0,$60,$C0,$7A,$F9,$69,$7,$F0,$84,$F8,$6,$40,$1,$35,$E0,$79,$A8
  DC.B $42,$EF,$DC,$30,$4D,$28,$88,$C0,$43,$F9,$69,$7,$F0,$79,$F8,$6,$40
  DC.B $28,$88,$0,$A,$C0,$43,$F9,$69,$7,$F0,$72,$F8,$30,$40,$5,$1C,$60
  DC.B $7A,$2F,$28,$2,$D1,$7E,$21,$2A,$48,$41,$70,$7E,$21,$29,$48         *185
  DC.B $40,$71,$0,$60,$41,$70,$0,$26,$27,$49,$8,$88,$40,$8,$8,$80,$38,$6A,$7
  DC.B $F0,$5D,$F8,$5,$40,$1,$36,$8,$2E,$F4,$DB,$FF,$20,$21,$4E,$70,$70
  DC.B $8,$E0,$29,$E0,$19,$E0,$30,$88,$40,$8,$30,$80,$38,$6A,$7,$F0,$4D
  DC.B $F8,$5,$40,$19,$48,$0,$23,$C0,$56,$0,$28,$F3,$D1,$1,$2D         *186
  DC.B $80,$71,$0,$60,$F,$D1,$15,$49,$9,$78,$18,$48,$0,$9A,$81,$54,$17,$48,$1
  DC.B $78,$1,$31,$1,$70,$A0,$79,$C0,$9,$B,$D2,$20,$1C,$FF,$F7,$F6,$F9
  DC.B $7,$E0,$0,$98,$9,$49,$8,$70,$0,$20,$2,$99,$22,$1C,$FF,$F7,$7B
  DC.B $F9,$1,$2D,$0,$D1,$6C,$E7,$4,$B0,$F0,$BC,$8,$BC,$18,$47         *187
  DC.B $C0,$71,$0,$60,$84,$1,$1,$0,$C0,$3D,$0,$40,$AC,$3,$1,$0,$8B,$1,$1
  DC.B $0,$FF,$FF,$0,$0,$A2,$1,$1,$0,$9C,$1,$1,$0,$A0,$1,$1,$0
  DC.B $A1,$1,$1,$0,$9E,$1,$1,$0,$F0,$55,$0,$40,$DD,$0,$1,$0,$80
  DC.B $B4,$7,$6,$3F,$E,$B,$49,$A,$78,$B,$48,$0,$78,$10,$1A         *188
  DC.B $0,$72,$0,$60,$0,$D5,$80,$30,$3,$1C,$0,$20,$7F,$2B,$8,$DA,$53,$1C,$B
  DC.B $70,$6,$4B,$9F,$54,$A,$78,$80,$2A,$0,$DB,$8,$70,$1,$20,$80,$BC
  DC.B $70,$47,$0,$0,$8B,$1,$1,$0,$8C,$1,$1,$0,$F0,$55,$0,$40,$90
  DC.B $B5,$C,$1C,$7,$1C,$2,$DF,$0,$20,$0,$2F,$3,$D0,$B,$49         *189
  DC.B $40,$72,$0,$60,$8,$70,$B,$49,$8,$70,$0,$2C,$C,$D0,$A,$49,$8,$70,$A
  DC.B $49,$8,$70,$A,$4F,$1,$E0,$FF,$F7,$99,$F9,$38,$1C,$FF,$F7,$50,$F9
  DC.B $0,$28,$F8,$D1,$1,$DF,$90,$BC,$8,$BC,$18,$47,$95,$1,$1,$0,$94
  DC.B $1,$1,$0,$8C,$1,$1,$0,$8B,$1,$1,$0,$C0,$3D,$0,$40         *18a
  DC.B $80,$72,$0,$60,$80,$B5,$13,$4F,$1,$E0,$FF,$F7,$81,$F9,$38,$1C,$FF,$F7,$38
  DC.B $F9,$0,$28,$F8,$D1,$F,$4F,$1,$E0,$FF,$F7,$78,$F9,$38,$1C,$FF,$F7
  DC.B $2F,$F9,$0,$28,$F8,$D1,$C,$4F,$1,$E0,$FF,$F7,$6F,$F9,$38,$1C,$FF
  DC.B $F7,$26,$F9,$0,$28,$F8,$D1,$8,$4F,$1,$E0,$FF,$F7,$66,$F9         *18b
  DC.B $C0,$72,$0,$60,$38,$1C,$FF,$F7,$1D,$F9,$0,$28,$F8,$D1,$80,$BC,$8,$BC,$18
  DC.B $47,$C0,$3D,$0,$40,$D0,$3D,$0,$40,$E0,$3D,$0,$40,$F0,$3D,$0,$40
  DC.B $80,$B5,$6,$4F,$1,$E0,$0,$F0,$53,$F8,$38,$1C,$FF,$F7,$8,$F9,$0
  DC.B $28,$F8,$D1,$80,$BC,$8,$BC,$18,$47,$0,$0,$E0,$3D,$0,$40         *18c
  DC.B $0,$73,$0,$60,$F0,$B5,$21,$4F,$0,$24,$0,$26,$3D,$1C,$F8,$1D,$39,$30,$41
  DC.B $7C,$1,$29,$A,$D1,$46,$74,$F8,$1D,$19,$30,$80,$78,$1,$28,$1,$D0
  DC.B $2,$28,$2,$D1,$38,$1C,$0,$F0,$D5,$F8,$1,$34,$54,$37,$6,$2C,$EB
  DC.B $DB,$0,$24,$0,$27,$B,$20,$78,$43,$40,$19,$41,$7C,$C,$30         *18d
  DC.B $40,$73,$0,$60,$0,$29,$A,$D0,$81,$79,$C0,$79,$81,$42,$6,$D0,$0,$2F,$D
  DC.B $D0,$1,$2F,$2,$D1,$28,$1C,$0,$F0,$2A,$FB,$1,$37,$2,$2F,$EA,$DB
  DC.B $1,$34,$54,$35,$6,$2C,$E5,$DB,$8,$4F,$5,$E0,$28,$1C,$0,$F0,$0
  DC.B $FB,$F2,$E7,$0,$F0,$6D,$F9,$38,$1C,$FF,$F7,$C1,$F8,$0,$28         *18e
  DC.B $80,$73,$0,$60,$F8,$D1,$F0,$BC,$8,$BC,$18,$47,$70,$56,$0,$40,$D0,$3D,$0
  DC.B $40,$F0,$B5,$44,$7A,$1,$26,$7,$1C,$0,$7A,$80,$8,$1F,$28,$2,$D1
  DC.B $0,$F0,$80,$F8,$9,$E0,$0,$F0,$47,$FB,$78,$71,$FF,$28,$4,$D0,$78
  DC.B $79,$0,$F0,$6,$FB,$5,$1C,$5,$D1,$38,$1C,$FF,$F7,$E6,$F8         *18f
  DC.B $C0,$73,$0,$60,$F0,$BC,$8,$BC,$18,$47,$1,$20,$E9,$1D,$39,$31,$48,$74,$F8
  DC.B $79,$2,$28,$36,$DB,$10,$21,$C9,$43,$21,$40,$63,$29,$2B,$D0,$2F,$29
  DC.B $29,$D0,$E8,$1D,$19,$30,$80,$78,$0,$28,$2A,$D0,$20,$1C,$29,$1C,$0
  DC.B $F0,$8B,$F9,$4,$1C,$87,$28,$24,$D0,$E4,$6,$E4,$E,$60,$8         *190
  DC.B $0,$74,$0,$60,$15,$D2,$60,$9,$1D,$D2,$20,$1C,$29,$1C,$0,$F0,$DF,$F9,$4
  DC.B $1C,$8B,$28,$17,$D0,$3A,$1C,$11,$49,$1,$20,$FF,$F7,$45,$F8,$10,$48
  DC.B $1,$78,$1,$31,$1,$70,$F1,$23,$1C,$40,$0,$26,$A,$E0,$F8,$79,$2
  DC.B $28,$7,$D0,$5,$E0,$2F,$29,$1,$D0,$63,$2C,$1,$D1,$2,$28         *191
  DC.B $40,$74,$0,$60,$0,$D0,$93,$24,$1,$2E,$2,$D1,$38,$1C,$FF,$F7,$9F,$F8,$20
  DC.B $1C,$29,$1C,$0,$F0,$57,$F8,$F0,$BC,$8,$BC,$18,$47,$F0,$3D,$0,$40
  DC.B $40,$2B,$0,$40,$0,$B5,$0,$21,$D,$4A,$14,$E0,$54,$20,$48,$43,$80
  DC.B $18,$43,$79,$0,$2B,$B,$D0,$C3,$1D,$19,$33,$9B,$78,$0,$2B         *192
  DC.B $80,$74,$0,$60,$6,$D1,$83,$79,$1E,$2B,$3,$D1,$0,$F0,$20,$FB,$8,$BC,$18
  DC.B $47,$48,$1C,$1,$6,$9,$E,$6,$29,$E8,$DB,$8,$BC,$18,$47,$0,$0
  DC.B $70,$56,$0,$40,$80,$B5,$0,$20,$9,$49,$1E,$22,$9,$E0,$54,$23,$43
  DC.B $43,$5B,$18,$9F,$79,$1F,$2F,$0,$D1,$9A,$71,$1,$30,$0,$6         *193
  DC.B $C0,$74,$0,$60,$0,$E,$6,$28,$F3,$DB,$FF,$F7,$CD,$FF,$80,$BC,$8,$BC,$18
  DC.B $47,$70,$56,$0,$40,$80,$B5,$7,$1C,$8,$E0,$38,$79,$39,$1C,$0,$F0
  DC.B $82,$F9,$38,$79,$1,$30,$40,$7,$40,$F,$38,$71,$38,$79,$39,$78,$88
  DC.B $42,$4,$D0,$38,$1C,$0,$F0,$F6,$F8,$0,$28,$ED,$D1,$80,$BC         *194
  DC.B $0,$75,$0,$60,$8,$BC,$18,$47,$B0,$B5,$2,$6,$12,$E,$E,$20,$F,$1C,$38
  DC.B $49,$1,$38,$0,$6,$0,$E,$B,$5C,$93,$42,$1,$D0,$0,$28,$F7,$D1
  DC.B $A,$23,$58,$43,$33,$49,$45,$18,$FC,$1D,$19,$34,$A0,$78,$40,$0,$28
  DC.B $18,$40,$78,$A,$28,$53,$D2,$1,$A3,$1B,$5C,$5B,$0,$9F,$44         *195
  DC.B $40,$75,$0,$60,$4F,$4,$F,$1B,$37,$2C,$2F,$32,$4F,$3B,$38,$1C,$0,$F0,$BE
  DC.B $FA,$38,$1C,$0,$F0,$F1,$FA,$2F,$20,$39,$1C,$0,$F0,$4D,$F8,$3F,$E0
  DC.B $38,$1C,$0,$F0,$E9,$FA,$38,$1C,$0,$F0,$C8,$FA,$38,$1C,$0,$F0,$F3
  DC.B $F9,$63,$20,$39,$1C,$A,$E0,$38,$1C,$0,$F0,$DD,$FA,$38,$1C         *196
  DC.B $80,$75,$0,$60,$0,$F0,$BC,$FA,$38,$1C,$0,$F0,$E7,$F9,$73,$20,$39,$1C,$0
  DC.B $F0,$33,$F8,$38,$1C,$0,$F0,$6E,$FA,$22,$E0,$1,$20,$39,$1C,$4,$E0
  DC.B $11,$20,$39,$1C,$1,$E0,$9,$20,$39,$1C,$0,$F0,$3C,$F8,$17,$E0,$38
  DC.B $1C,$0,$F0,$30,$F9,$13,$E0,$38,$1C,$0,$F0,$81,$FA,$38,$1C         *197
  DC.B $C0,$75,$0,$60,$0,$F0,$CA,$F9,$38,$1C,$0,$F0,$99,$FA,$38,$1C,$0,$F0,$B4
  DC.B $FA,$38,$1C,$0,$F0,$4F,$FA,$B8,$79,$1E,$28,$1,$D0,$FF,$F7,$42,$FF
  DC.B $A0,$78,$40,$0,$28,$5C,$A0,$70,$B0,$BC,$8,$BC,$18,$47,$0,$0,$14
  DC.B $29,$0,$40,$22,$29,$0,$40,$90,$B5,$4,$6,$24,$E,$F,$1C         *198
  DC.B $0,$76,$0,$60,$FE,$F7,$35,$FF,$0,$28,$B,$D0,$1,$21,$1,$72,$2F,$2C,$1
  DC.B $D1,$3,$21,$1,$72,$44,$72,$2,$21,$C1,$71,$B9,$79,$0,$F0,$34,$FA
  DC.B $90,$BC,$8,$BC,$18,$47,$90,$B5,$4,$6,$24,$E,$F,$1C,$FE,$F7,$1E
  DC.B $FF,$0,$28,$A,$D0,$1,$21,$1,$72,$79,$78,$49,$1,$21,$43         *199
  DC.B $40,$76,$0,$60,$41,$72,$2,$21,$C1,$71,$B9,$79,$0,$F0,$1E,$FA,$90,$BC,$8
  DC.B $BC,$18,$47,$B0,$B5,$7,$1C,$0,$79,$0,$F0,$B3,$F9,$4,$1C,$4,$D0
  DC.B $E5,$1D,$19,$35,$A8,$78,$0,$28,$5,$D1,$38,$1C,$FE,$F7,$8E,$FF,$B0
  DC.B $BC,$8,$BC,$18,$47,$B8,$79,$40,$23,$18,$43,$B8,$71,$3,$20         *19a
  DC.B $80,$76,$0,$60,$38,$72,$20,$78,$41,$1C,$49,$7,$49,$F,$A2,$78,$91,$42,$6
  DC.B $D1,$38,$1C,$21,$1C,$0,$F0,$38,$FA,$B0,$BC,$8,$BC,$18,$47,$80,$0
  DC.B $0,$19,$47,$62,$20,$1C,$0,$F0,$1E,$F8,$0,$28,$13,$D0,$A8,$78,$1
  DC.B $28,$1,$D0,$2,$28,$E,$D1,$20,$78,$21,$1C,$0,$F0,$93,$F8         *19b
  DC.B $C0,$76,$0,$60,$20,$78,$41,$1C,$49,$7,$49,$F,$21,$71,$A1,$78,$81,$42,$2
  DC.B $D1,$20,$1C,$0,$F0,$FB,$F9,$20,$78,$1,$30,$40,$7,$40,$F,$20,$70
  DC.B $B0,$BC,$8,$BC,$18,$47,$1,$79,$80,$78,$81,$42,$9,$DA,$8,$31,$8
  DC.B $1A,$3,$28,$1,$DA,$1,$20,$0,$E0,$0,$20,$0,$6,$0,$E         *19c
  DC.B $0,$77,$0,$60,$70,$47,$8,$1A,$3,$28,$F8,$DA,$F5,$E7,$F0,$B5,$5,$6,$2D
  DC.B $E,$6C,$9,$F,$1C,$89,$78,$38,$78,$81,$42,$50,$D0,$38,$1C,$0,$F0
  DC.B $CF,$F9,$B8,$78,$39,$78,$88,$42,$8,$DD,$8C,$42,$3,$DC,$E2,$1D,$1
  DC.B $32,$14,$6,$24,$E,$8,$31,$9,$6,$9,$E,$A,$1A,$3,$2A         *19d
  DC.B $40,$77,$0,$60,$2,$DD,$C1,$1C,$9,$6,$9,$E,$8C,$42,$3A,$DC,$A0,$42,$38
  DC.B $DC,$0,$26,$F,$E0,$40,$7,$40,$F,$80,$0,$C0,$19,$40,$6A,$FE,$F7
  DC.B $15,$FF,$B8,$78,$41,$1C,$B9,$70,$40,$7,$40,$F,$80,$0,$C0,$19,$46
  DC.B $62,$FE,$70,$B8,$78,$A0,$42,$EC,$D1,$B8,$78,$40,$7,$40,$F         *19e
  DC.B $80,$77,$0,$60,$B8,$70,$B8,$78,$39,$78,$88,$42,$11,$D0,$38,$1C,$0,$F0,$9E
  DC.B $F9,$D,$E0,$38,$1C,$0,$F0,$C3,$F9,$0,$28,$13,$D0,$39,$78,$89,$0
  DC.B $C9,$19,$48,$62,$38,$78,$1,$30,$40,$7,$40,$F,$38,$70,$38,$78,$1
  DC.B $30,$40,$7,$40,$F,$B9,$78,$88,$42,$EA,$D1,$2,$E0,$84,$42         *19f
  DC.B $C0,$77,$0,$60,$0,$D0,$87,$25,$28,$1C,$F0,$BC,$8,$BC,$18,$47,$0,$6,$0
  DC.B $E,$42,$8,$4B,$78,$93,$42,$4,$D1,$5A,$1C,$52,$7,$52,$F,$4A,$70
  DC.B $70,$47,$8B,$20,$70,$47,$B0,$B5,$5,$6,$2D,$E,$A8,$0,$40,$18,$44
  DC.B $6A,$F,$1C,$0,$2C,$B,$D0,$38,$1C,$0,$F0,$7F,$F9,$78,$78         *1a0
  DC.B $0,$78,$0,$60,$40,$1,$69,$0,$8,$43,$60,$72,$B9,$79,$20,$1C,$0,$F0,$3C
  DC.B $F9,$B0,$BC,$8,$BC,$18,$47,$F0,$B5,$84,$78,$1,$25,$7,$1C,$1A,$E0
  DC.B $0,$2D,$6,$D0,$38,$1C,$0,$F0,$51,$F9,$F8,$78,$1,$30,$F8,$70,$0
  DC.B $25,$A0,$0,$C0,$19,$46,$6A,$78,$78,$40,$1,$61,$0,$8,$43         *1a1
  DC.B $40,$78,$0,$60,$70,$72,$60,$1C,$44,$7,$64,$F,$38,$1C,$0,$F0,$57,$F9,$B9
  DC.B $79,$30,$1C,$0,$F0,$19,$F9,$60,$7,$40,$F,$39,$78,$88,$42,$3,$D0
  DC.B $B8,$78,$20,$1A,$3,$28,$DB,$D1,$F0,$BC,$8,$BC,$18,$47,$F0,$B5,$5
  DC.B $6,$2D,$E,$E,$6,$36,$E,$28,$1C,$17,$1C,$0,$F0,$54,$F8         *1a2
  DC.B $80,$78,$0,$60,$28,$1C,$0,$F0,$B9,$F8,$4,$1C,$23,$D0,$A7,$60,$A6,$71,$0
  DC.B $20,$4,$21,$9,$E0,$B,$22,$42,$43,$12,$19,$51,$73,$93,$7B,$1,$33
  DC.B $93,$73,$1,$30,$0,$6,$0,$E,$2,$28,$F3,$DB,$20,$1C,$0,$F0,$53
  DC.B $F8,$0,$20,$E1,$1D,$19,$31,$88,$70,$1,$20,$E1,$1D,$39,$31         *1a3
  DC.B $C0,$78,$0,$60,$48,$74,$20,$1C,$0,$F0,$38,$F9,$A0,$79,$1F,$28,$4,$D1,$FF
  DC.B $F7,$C9,$FD,$F0,$BC,$8,$BC,$18,$47,$1E,$28,$3,$D0,$20,$1C,$0,$F0
  DC.B $F5,$F8,$F4,$E7,$0,$20,$F,$49,$11,$E0,$54,$22,$42,$43,$52,$18,$53
  DC.B $79,$0,$2B,$8,$D0,$AB,$42,$6,$D0,$93,$79,$1E,$2B,$3,$D1         *1a4
  DC.B $0,$79,$0,$60,$20,$32,$92,$78,$0,$2A,$4,$D0,$1,$30,$0,$6,$0,$E,$6
  DC.B $28,$EB,$DB,$6,$28,$DD,$D1,$20,$1C,$0,$F0,$D8,$F8,$F0,$BC,$8,$BC
  DC.B $18,$47,$0,$0,$70,$56,$0,$40,$80,$B5,$0,$6,$0,$E,$0,$F0,$63
  DC.B $F8,$7,$1C,$D,$D0,$38,$1C,$0,$F0,$C2,$F8,$38,$1C,$0,$F0         *1a5
  DC.B $40,$79,$0,$60,$DD,$F8,$38,$1C,$0,$F0,$8,$F8,$0,$20,$F9,$1D,$19,$31,$88
  DC.B $70,$78,$71,$80,$BC,$8,$BC,$18,$47,$80,$B5,$7,$1C,$0,$F0,$20,$FA
  DC.B $0,$20,$38,$70,$78,$70,$B8,$70,$38,$71,$F8,$70,$80,$BC,$8,$BC,$18
  DC.B $47,$0,$B5,$1,$7C,$0,$29,$11,$D0,$C1,$7C,$1,$31,$C1,$74         *1a6
  DC.B $80,$79,$0,$60,$C1,$1D,$19,$31,$89,$78,$0,$29,$B,$D0,$C1,$78,$3,$29,$2
  DC.B $DB,$1,$1C,$C3,$20,$1,$E0,$1,$1C,$A3,$20,$FF,$F7,$B3,$FD,$8,$BC
  DC.B $18,$47,$C1,$78,$4A,$1C,$C2,$70,$A,$29,$F1,$DA,$F3,$E7,$0,$B5,$81
  DC.B $7F,$1,$31,$81,$77,$1,$1C,$1,$20,$FF,$F7,$34,$FE,$8,$BC         *1a7
  DC.B $C0,$79,$0,$60,$18,$47,$80,$B4,$2,$6,$12,$E,$0,$20,$0,$2A,$10,$D0,$0
  DC.B $21,$8,$4F,$8,$E0,$54,$20,$48,$43,$C0,$19,$43,$79,$93,$42,$4,$D0
  DC.B $1,$31,$9,$6,$9,$E,$6,$29,$F4,$DB,$6,$29,$0,$D1,$0,$20,$80
  DC.B $BC,$70,$47,$70,$56,$0,$40,$80,$B4,$2,$6,$12,$E,$0,$20         *1a8
  DC.B $0,$7A,$0,$60,$0,$2A,$14,$D0,$0,$21,$B,$4F,$C,$E0,$54,$20,$48,$43,$C0
  DC.B $19,$43,$79,$93,$42,$1,$D0,$0,$2B,$1,$D1,$42,$71,$4,$E0,$1,$31
  DC.B $9,$6,$9,$E,$6,$29,$F0,$DB,$6,$29,$0,$D1,$0,$20,$80,$BC,$70
  DC.B $47,$0,$0,$70,$56,$0,$40,$80,$B4,$2,$6,$12,$E,$0,$20         *1a9
  DC.B $40,$7A,$0,$60,$B,$49,$B,$E0,$54,$23,$43,$43,$5B,$18,$5F,$79,$0,$2F,$2
  DC.B $D0,$9F,$79,$97,$42,$4,$D0,$1,$30,$0,$6,$0,$E,$6,$28,$F1,$DB
  DC.B $6,$28,$2,$D1,$FF,$20,$80,$BC,$70,$47,$58,$79,$80,$BC,$70,$47,$70
  DC.B $56,$0,$40,$0,$B5,$81,$68,$0,$29,$2,$D0,$40,$79,$6,$F0         *1aa
  DC.B $80,$7A,$0,$60,$C7,$FB,$8,$BC,$18,$47,$70,$47,$0,$B5,$9,$6,$9,$E,$0
  DC.B $22,$42,$71,$2,$7A,$92,$7,$92,$F,$89,$0,$11,$43,$1,$72,$1,$21
  DC.B $1,$71,$5,$49,$A,$78,$1,$32,$A,$70,$4,$49,$2,$1C,$1,$20,$FE
  DC.B $F7,$FA,$FC,$8,$BC,$18,$47,$DA,$2A,$0,$40,$C0,$3D,$0,$40         *1ab
  DC.B $C0,$7A,$0,$60,$4,$21,$41,$73,$81,$7B,$1,$31,$81,$73,$70,$47,$0,$B5,$3C
  DC.B $21,$C,$30,$0,$F0,$9,$F8,$8,$BC,$18,$47,$0,$B5,$9,$21,$17,$30
  DC.B $0,$F0,$2,$F8,$8,$BC,$18,$47,$1,$70,$3,$21,$41,$70,$81,$78,$C2
  DC.B $78,$91,$42,$1,$D1,$1,$31,$81,$70,$70,$47,$4,$21,$1,$76         *1ac
  DC.B $0,$7B,$0,$60,$41,$7E,$1,$31,$41,$76,$70,$47,$8A,$6C,$0,$2A,$1,$D1,$88
  DC.B $64,$1,$E0,$CA,$6C,$10,$60,$C8,$64,$0,$21,$1,$60,$70,$47,$1,$1C
  DC.B $80,$6C,$0,$22,$0,$28,$1,$D1,$10,$1C,$70,$47,$3,$68,$8B,$64,$0
  DC.B $2B,$FA,$D1,$CA,$64,$70,$47,$80,$B5,$7,$1C,$0,$F0,$30,$F9         *1ad
  DC.B $40,$7B,$0,$60,$78,$79,$1,$28,$1,$D1,$FF,$F7,$9B,$FB,$80,$BC,$8,$BC,$18
  DC.B $47,$80,$B4,$0,$20,$2,$27,$8,$4A,$8,$49,$9,$68,$8,$E0,$54,$23
  DC.B $43,$43,$9B,$18,$19,$75,$D9,$77,$5F,$75,$20,$33,$1F,$70,$1,$30,$6
  DC.B $28,$F4,$DB,$80,$BC,$70,$47,$70,$56,$0,$40,$98,$2A,$0,$40         *1ae
  DC.B $80,$7B,$0,$60,$F0,$B5,$86,$B0,$78,$4C,$60,$6D,$78,$49,$5,$91,$0,$28,$A
  DC.B $D1,$77,$4A,$0,$21,$1,$20,$FF,$F7,$6A,$FE,$FF,$20,$F5,$30,$5,$99
  DC.B $8,$60,$1,$20,$60,$65,$E7,$1D,$39,$37,$38,$7C,$0,$28,$4,$D1,$70
  DC.B $48,$0,$68,$6,$F0,$2A,$FB,$38,$74,$17,$20,$0,$3,$80,$68         *1af
  DC.B $C0,$7B,$0,$60,$C0,$9,$1,$D2,$1,$25,$0,$E0,$0,$25,$0,$2D,$2,$D1,$0
  DC.B $20,$60,$60,$7,$E0,$FF,$23,$60,$68,$F5,$33,$98,$42,$2,$DA,$1,$30
  DC.B $0,$25,$60,$60,$F8,$7C,$64,$4E,$64,$49,$4,$91,$A8,$42,$2A,$D0,$FD
  DC.B $74,$30,$68,$40,$6,$0,$F,$6,$28,$24,$D1,$4,$99,$80,$31         *1b0
  DC.B $0,$7C,$0,$60,$3,$91,$48,$6F,$6,$F0,$2,$FB,$3,$99,$9,$6F,$6,$F0,$0
  DC.B $FB,$0,$2D,$11,$D1,$5A,$48,$1,$68,$0,$20,$6,$F0,$F9,$FA,$0,$20
  DC.B $58,$49,$8,$80,$3,$99,$C8,$68,$6,$F0,$F0,$FA,$11,$20,$0,$3,$1
  DC.B $6A,$6B,$1F,$19,$40,$1,$62,$0,$2D,$4,$D0,$1,$20,$B8,$74         *1b1
  DC.B $40,$7C,$0,$60,$2,$20,$50,$49,$8,$80,$17,$20,$0,$3,$80,$68,$40,$C,$1
  DC.B $D2,$1,$25,$0,$E0,$0,$25,$38,$7C,$F,$28,$58,$D0,$D,$28,$2A,$D1
  DC.B $0,$2D,$12,$D0,$78,$7C,$1,$28,$25,$D0,$0,$F0,$51,$FB,$46,$4A,$1E
  DC.B $21,$2,$20,$FF,$F7,$FB,$FD,$1,$20,$78,$74,$30,$68,$43,$4B         *1b2
  DC.B $80,$7C,$0,$60,$18,$40,$D,$23,$DB,$1,$18,$43,$14,$E0,$78,$7C,$1,$28,$12
  DC.B $D1,$2,$20,$FF,$F7,$49,$FE,$0,$20,$78,$74,$4,$99,$C8,$1D,$F9,$30
  DC.B $0,$6A,$6,$F0,$B3,$FA,$31,$68,$38,$4B,$19,$40,$0,$7,$0,$F,$C0
  DC.B $1,$8,$43,$30,$60,$0,$2D,$7,$D0,$5,$99,$8,$68,$0,$28         *1b3
  DC.B $C0,$7C,$0,$60,$7,$D0,$1,$38,$5,$99,$8,$60,$4A,$E0,$FF,$20,$F5,$30,$5
  DC.B $99,$8,$60,$0,$27,$2E,$48,$2,$90,$2E,$4E,$0,$2D,$24,$D0,$2E,$48
  DC.B $C0,$5D,$0,$28,$20,$D0,$E8,$20,$78,$43,$1,$90,$30,$5C,$3,$28,$33
  DC.B $D0,$2,$98,$0,$68,$0,$28,$5,$D0,$0,$2F,$D,$D1,$27,$4A         *1b4
  DC.B $0,$7D,$0,$60,$1E,$21,$3,$20,$7,$E0,$0,$2F,$2,$D1,$3,$20,$1,$E0,$27
  DC.B $E0,$4,$20,$22,$4A,$1E,$21,$FF,$F7,$AA,$FD,$3,$21,$1,$98,$31,$54
  DC.B $A0,$6C,$1,$30,$A0,$64,$18,$E0,$E8,$21,$79,$43,$0,$91,$70,$5C,$3
  DC.B $28,$12,$D1,$2,$98,$0,$68,$0,$28,$3,$D0,$0,$2F,$6,$D1         *1b5
  DC.B $40,$7D,$0,$60,$3,$20,$2,$E0,$0,$2F,$FB,$D0,$4,$20,$FF,$F7,$ED,$FD,$0
  DC.B $20,$0,$99,$70,$54,$E0,$6C,$1,$30,$E0,$64,$1,$37,$2,$2F,$BC,$DB
  DC.B $6,$B0,$F0,$BC,$8,$BC,$18,$47,$E4,$2A,$0,$40,$64,$2B,$0,$40,$81
  DC.B $1B,$0,$40,$3C,$48,$0,$60,$3C,$0,$1,$0,$AC,$1,$1,$0         *1b6
  DC.B $80,$7D,$0,$60,$24,$48,$0,$60,$C8,$2A,$0,$40,$E1,$1F,$0,$40,$7F,$F8,$FF
  DC.B $FF,$60,$2B,$0,$40,$68,$58,$0,$40,$68,$2B,$0,$40,$59,$24,$0,$40
  DC.B $F0,$B5,$0,$24,$0,$26,$7,$1C,$A,$E0,$A0,$0,$C5,$19,$68,$6A,$0
  DC.B $28,$2,$D0,$FE,$F7,$EA,$FB,$6E,$62,$60,$1C,$4,$6,$24,$E         *1b7
  DC.B $C0,$7D,$0,$60,$8,$2C,$F2,$DB,$1,$E0,$FE,$F7,$E1,$FB,$38,$1C,$FF,$F7,$A7
  DC.B $FE,$0,$28,$F8,$D1,$F0,$BC,$8,$BC,$18,$47,$0,$0,$4,$4A,$11,$68
  DC.B $88,$7A,$43,$1C,$8B,$72,$11,$68,$40,$18,$C0,$7A,$70,$47,$0,$0,$3C
  DC.B $2B,$0,$40,$2,$48,$0,$68,$C1,$79,$80,$7A,$8,$1A,$70,$47         *1b8
  DC.B $0,$7E,$0,$60,$3C,$2B,$0,$40,$F0,$B5,$82,$B0,$30,$4F,$38,$78,$0,$28,$58
  DC.B $D1,$0,$26,$2F,$4D,$2F,$4C,$27,$E0,$2C,$4F,$3E,$70,$28,$68,$6,$F0
  DC.B $F5,$F9,$38,$78,$0,$28,$3,$D1,$2,$25,$2B,$4F,$2B,$4E,$20,$E0,$FE
  DC.B $F7,$1D,$FB,$39,$78,$C1,$71,$1,$21,$1,$71,$3B,$1C,$28,$4F         *1b9
  DC.B $40,$7E,$0,$60,$19,$78,$1,$39,$19,$70,$19,$78,$7A,$18,$92,$78,$41,$18,$CA
  DC.B $72,$19,$78,$0,$29,$F4,$DC,$2,$1C,$1,$20,$21,$1C,$FE,$F7,$24,$FB
  DC.B $1E,$49,$8,$78,$1,$30,$8,$70,$FE,$F7,$7C,$FB,$0,$28,$D3,$D1,$DA
  DC.B $E7,$FE,$F7,$77,$FB,$0,$28,$23,$D0,$69,$46,$1,$A8,$0,$F0         *1ba
  DC.B $80,$7E,$0,$60,$6F,$FB,$0,$28,$1D,$D0,$FE,$F7,$F2,$FA,$C5,$71,$1,$99,$1
  DC.B $71,$C5,$72,$0,$99,$1,$73,$39,$68,$0,$29,$9,$D0,$1,$99,$4,$29
  DC.B $6,$D1,$80,$23,$0,$99,$19,$43,$1,$73,$1,$99,$1,$39,$1,$71,$2
  DC.B $1C,$1,$20,$21,$1C,$FE,$F7,$F7,$FA,$30,$78,$1,$30,$30,$70         *1bb
  DC.B $C0,$7E,$0,$60,$D7,$E7,$2,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$0,$C4,$0,$1
  DC.B $0,$14,$48,$0,$60,$D0,$3D,$0,$40,$60,$2B,$0,$40,$E6,$2A,$0,$40
  DC.B $EC,$5,$1,$0,$F0,$B5,$81,$B0,$14,$4E,$15,$4D,$15,$4C,$16,$49,$0
  DC.B $91,$1A,$E0,$0,$99,$F,$60,$78,$79,$1,$28,$8,$D0,$2,$28         *1bc
  DC.B $0,$7F,$0,$60,$E,$D0,$3,$28,$1,$D0,$4,$28,$C,$D1,$0,$F0,$2F,$FC,$9
  DC.B $E0,$1,$23,$20,$68,$18,$43,$20,$60,$30,$68,$6,$F0,$77,$F9,$1,$E0
  DC.B $0,$F0,$BC,$F8,$38,$1C,$FE,$F7,$31,$FB,$28,$1C,$FE,$F7,$E8,$FA,$7
  DC.B $1C,$DF,$D1,$1,$B0,$F0,$BC,$8,$BC,$18,$47,$C8,$47,$0,$60         *1bd
  DC.B $40,$7F,$0,$60,$F0,$3D,$0,$40,$3C,$0,$1,$0,$3C,$2B,$0,$40,$1,$20,$C
  DC.B $49,$8,$70,$C,$48,$28,$23,$1,$68,$19,$43,$1,$60,$A,$48,$0,$68
  DC.B $C0,$2,$C0,$F,$81,$1,$9,$48,$0,$23,$C2,$56,$53,$1C,$3,$70,$7
  DC.B $48,$81,$54,$7,$48,$1,$78,$1,$31,$1,$70,$70,$47,$0,$0         *1be
  DC.B $80,$7F,$0,$60,$45,$2A,$0,$40,$BC,$0,$1,$0,$40,$0,$1,$0,$8C,$0,$1
  DC.B $0,$BC,$5,$1,$0,$70,$2B,$0,$40,$B0,$B5,$5,$6,$2D,$E,$C,$4F
  DC.B $38,$78,$41,$1C,$39,$70,$B,$4C,$1,$21,$62,$6B,$6,$F0,$32,$F9,$A1
  DC.B $6B,$28,$1C,$6,$F0,$2C,$F9,$38,$78,$13,$28,$1,$DD,$0,$20         *1bf
  DC.B $C0,$7F,$0,$60,$38,$70,$20,$20,$A1,$6B,$6,$F0,$23,$F9,$B0,$BC,$8,$BC,$18
  DC.B $47,$44,$2B,$0,$40,$2C,$3,$1,$0,$0,$7,$0,$F,$A,$28,$2,$DA
  DC.B $30,$23,$18,$43,$0,$E0,$37,$30,$0,$6,$0,$E,$70,$47,$80,$B5,$7
  DC.B $6,$3F,$E,$38,$9,$FF,$F7,$EF,$FF,$FF,$F7,$CD,$FF,$38,$1C         *1c0
  DC.B $0,$80,$0,$60,$FF,$F7,$EA,$FF,$FF,$F7,$C8,$FF,$80,$BC,$8,$BC,$18,$47,$90
  DC.B $B4,$0,$20,$6,$4F,$19,$22,$12,$3,$51,$4,$17,$60,$C,$78,$23,$A
  DC.B $2,$D3,$1,$30,$19,$28,$F8,$DB,$90,$BC,$70,$47,$0,$40,$9C,$80,$B0
  DC.B $B5,$23,$20,$3,$DF,$1,$25,$6F,$7,$3D,$70,$D,$20,$40,$3         *1c1
  DC.B $40,$80,$0,$60,$1,$68,$A9,$43,$1,$60,$1,$68,$3E,$23,$DB,$43,$19,$40,$18
  DC.B $23,$19,$43,$1,$60,$1,$68,$F,$4B,$19,$40,$40,$23,$19,$43,$1,$60
  DC.B $5,$20,$3,$DF,$38,$20,$38,$70,$5,$20,$3,$DF,$C,$20,$38,$70,$9
  DC.B $4C,$64,$20,$E1,$6C,$6,$F0,$CB,$F8,$3D,$70,$5,$20,$3,$DF         *1c2
  DC.B $80,$80,$0,$60,$6,$20,$38,$70,$C,$20,$21,$6F,$6,$F0,$C2,$F8,$B0,$BC,$8
  DC.B $BC,$18,$47,$0,$0,$3F,$FC,$FF,$FF,$2C,$2,$1,$0,$90,$B5,$1F,$4C
  DC.B $1F,$4F,$2B,$E0,$42,$1C,$8A,$72,$39,$68,$40,$18,$C0,$7A,$C0,$28,$18
  DC.B $D0,$8,$DC,$24,$28,$12,$D0,$26,$28,$D,$D0,$33,$28,$1B,$D1         *1c3
  DC.B $C0,$80,$0,$60,$0,$F0,$DA,$F8,$1A,$E0,$C7,$28,$10,$D0,$CF,$28,$11,$D0,$D0
  DC.B $28,$12,$D1,$0,$F0,$73,$F8,$11,$E0,$0,$F0,$3E,$F8,$E,$E0,$0,$F0
  DC.B $F5,$F8,$B,$E0,$8,$20,$0,$F0,$45,$F9,$7,$E0,$0,$F0,$10,$F9,$4
  DC.B $E0,$0,$F0,$1B,$F9,$1,$E0,$0,$F0,$14,$F8,$38,$68,$C2,$79         *1c4
  DC.B $0,$81,$0,$60,$1,$1C,$80,$7A,$12,$1A,$0,$2A,$3,$DD,$0,$23,$E2,$5E,$0
  DC.B $2A,$C8,$D0,$0,$20,$20,$80,$90,$BC,$8,$BC,$18,$47,$48,$2B,$0,$40
  DC.B $3C,$2B,$0,$40,$80,$B5,$7,$6,$3F,$E,$1,$20,$8,$49,$8,$80,$FE
  DC.B $F7,$9D,$F9,$C2,$21,$C1,$72,$7,$73,$2,$21,$1,$71,$C1,$71         *1c5
  DC.B $40,$81,$0,$60,$4,$49,$2,$1C,$1,$20,$FE,$F7,$AF,$F9,$80,$BC,$8,$BC,$18
  DC.B $47,$48,$2B,$0,$40,$D0,$3D,$0,$40,$80,$B5,$16,$4A,$10,$68,$C3,$79
  DC.B $1,$1C,$80,$7A,$18,$1A,$2,$28,$5,$DA,$26,$20,$FF,$F7,$DA,$FF,$80
  DC.B $BC,$8,$BC,$18,$47,$10,$48,$3,$7A,$0,$2B,$F8,$D1,$1,$23         *1c6
  DC.B $80,$81,$0,$60,$43,$80,$3,$72,$8B,$7A,$5F,$1C,$8F,$72,$11,$68,$5B,$18,$DB
  DC.B $7A,$3,$71,$8B,$7A,$5F,$1C,$8F,$72,$11,$68,$59,$18,$C9,$7A,$81,$71
  DC.B $81,$79,$80,$23,$DB,$43,$19,$40,$C1,$71,$0,$21,$41,$71,$80,$BC,$8
  DC.B $BC,$18,$47,$3C,$2B,$0,$40,$48,$2B,$0,$40,$B0,$B5,$0,$21         *1c7
  DC.B $C0,$81,$0,$60,$2B,$48,$2,$68,$D7,$79,$13,$1C,$92,$7A,$BF,$1A,$2,$2F,$1
  DC.B $DA,$D0,$20,$3F,$E0,$57,$1C,$9F,$72,$3,$68,$D2,$18,$D7,$7A,$9A,$7A
  DC.B $54,$1C,$9C,$72,$3,$68,$D2,$18,$D2,$7A,$5,$2A,$7,$D0,$6,$2A,$5
  DC.B $D0,$99,$7A,$4C,$1C,$9C,$72,$3,$68,$C9,$18,$C9,$7A,$3,$68         *1c8
  DC.B $0,$82,$0,$60,$DD,$79,$1C,$1C,$9B,$7A,$ED,$1A,$8D,$42,$E1,$DB,$3,$2F,$DF
  DC.B $D1,$18,$4F,$3,$2A,$9,$D0,$4,$2A,$21,$D0,$5,$2A,$23,$D0,$6,$2A
  DC.B $D6,$D1,$A,$20,$F8,$72,$7,$20,$F,$E0,$2,$29,$11,$D1,$1,$2D,$F
  DC.B $DD,$59,$1C,$A1,$72,$1,$68,$5A,$18,$D2,$7A,$FA,$72,$8A,$7A         *1c9
  DC.B $40,$82,$0,$60,$53,$1C,$8B,$72,$0,$68,$10,$18,$C0,$7A,$B8,$72,$B0,$BC,$8
  DC.B $BC,$18,$47,$26,$20,$FF,$F7,$66,$FF,$B0,$BC,$8,$BC,$18,$47,$0,$29
  DC.B $B6,$D1,$1,$20,$0,$E0,$0,$20,$38,$73,$B0,$BC,$8,$BC,$18,$47,$3C
  DC.B $2B,$0,$40,$48,$2B,$0,$40,$0,$B5,$12,$48,$1,$68,$CB,$79         *1ca
  DC.B $80,$82,$0,$60,$A,$1C,$89,$7A,$5B,$1A,$1,$2B,$17,$DD,$4B,$1C,$93,$72,$2
  DC.B $68,$89,$18,$C9,$7A,$1E,$23,$19,$40,$16,$29,$E,$D1,$91,$7A,$4B,$1C
  DC.B $93,$72,$0,$68,$8,$18,$C0,$7A,$D,$28,$6,$D1,$0,$21,$6,$48,$1
  DC.B $72,$1,$21,$41,$80,$8,$BC,$18,$47,$33,$20,$FF,$F7,$32,$FF         *1cb
  DC.B $C0,$82,$0,$60,$8,$BC,$18,$47,$3C,$2B,$0,$40,$48,$2B,$0,$40,$0,$B5,$E
  DC.B $4A,$10,$68,$C3,$79,$1,$1C,$80,$7A,$1B,$1A,$0,$2B,$F,$DD,$43,$1C
  DC.B $8B,$72,$11,$68,$40,$18,$C0,$7A,$1,$7,$9,$F,$0,$9,$0,$7,$0
  DC.B $F,$6,$4A,$12,$68,$5,$F0,$8D,$FF,$8,$BC,$18,$47,$24,$20         *1cc
  DC.B $0,$83,$0,$60,$FF,$F7,$10,$FF,$8,$BC,$18,$47,$3C,$2B,$0,$40,$18,$48,$0
  DC.B $60,$1,$21,$5,$48,$1,$73,$7,$21,$81,$72,$A,$21,$C1,$72,$0,$21
  DC.B $1,$72,$14,$21,$81,$73,$70,$47,$48,$2B,$0,$40,$0,$B5,$E,$4A,$10
  DC.B $68,$C3,$79,$1,$1C,$80,$7A,$1B,$1A,$1,$2B,$4,$DA,$CF,$20         *1cd
  DC.B $40,$83,$0,$60,$FF,$F7,$F0,$FE,$8,$BC,$18,$47,$43,$1C,$8B,$72,$11,$68,$40
  DC.B $18,$C0,$7A,$C1,$6,$C9,$E,$5,$4A,$2,$20,$FF,$F7,$88,$FA,$1,$20
  DC.B $3,$49,$48,$73,$8,$BC,$18,$47,$3C,$2B,$0,$40,$E1,$1F,$0,$40,$48
  DC.B $2B,$0,$40,$80,$B5,$7,$6,$3F,$E,$FE,$F7,$78,$F8,$0,$28         *1ce
  DC.B $80,$83,$0,$60,$F,$D0,$C1,$21,$C1,$72,$9E,$21,$1,$73,$47,$73,$0,$21,$81
  DC.B $73,$4,$21,$C1,$71,$2,$21,$1,$71,$3,$49,$2,$1C,$1,$20,$FE,$F7
  DC.B $83,$F8,$80,$BC,$8,$BC,$18,$47,$D0,$3D,$0,$40,$0,$B5,$1,$20,$FF
  DC.B $F7,$E0,$FF,$17,$20,$0,$3,$80,$68,$80,$13,$C0,$7,$C0,$F         *1cf
  DC.B $C0,$83,$0,$60,$C0,$43,$6,$49,$8,$74,$6,$48,$1,$78,$1,$31,$1,$70,$5
  DC.B $48,$1,$78,$1,$31,$1,$70,$8,$BC,$18,$47,$0,$0,$48,$2B,$0,$40
  DC.B $E6,$2A,$0,$40,$70,$2B,$0,$40,$F0,$B5,$17,$24,$24,$3,$A0,$68,$80
  DC.B $13,$C0,$7,$C0,$F,$4A,$4F,$78,$74,$F8,$7B,$2,$26,$0,$25         *1d0
  DC.B $0,$84,$0,$60,$1,$28,$F,$D0,$2,$28,$16,$D0,$3,$28,$22,$D1,$78,$7C,$0
  DC.B $28,$22,$D0,$79,$7A,$1,$31,$9,$6,$9,$E,$79,$72,$BA,$7A,$91,$42
  DC.B $1A,$DD,$12,$E0,$78,$7C,$0,$28,$27,$D1,$FE,$73,$0,$21,$2,$20,$0
  DC.B $F0,$78,$F8,$1F,$E0,$78,$7C,$0,$28,$1E,$D0,$38,$7B,$0,$28         *1d1
  DC.B $40,$84,$0,$60,$3,$D0,$3,$20,$F8,$73,$7D,$72,$15,$E0,$40,$21,$2,$20,$0
  DC.B $F0,$69,$F8,$1,$20,$F8,$73,$E,$E0,$0,$28,$E,$D1,$78,$7A,$F9,$7A
  DC.B $88,$42,$7,$DD,$16,$21,$2,$20,$0,$F0,$5C,$F8,$56,$21,$2,$20,$0
  DC.B $F0,$58,$F8,$FE,$73,$78,$7C,$38,$74,$2,$23,$F8,$5E,$0,$28         *1d2
  DC.B $80,$84,$0,$60,$12,$DD,$1,$38,$0,$4,$0,$14,$78,$80,$D,$D1,$38,$7A,$0
  DC.B $28,$D,$D1,$20,$68,$38,$23,$DB,$43,$18,$40,$28,$23,$18,$43,$20,$60
  DC.B $7D,$71,$0,$20,$C0,$43,$78,$80,$F0,$BC,$8,$BC,$18,$47,$B9,$79,$80
  DC.B $20,$8,$40,$A,$D1,$FA,$79,$1,$3A,$12,$6,$12,$E,$FA,$71         *1d3
  DC.B $C0,$84,$0,$60,$4,$D1,$7D,$71,$80,$23,$DB,$43,$19,$40,$F9,$71,$7A,$79,$14
  DC.B $21,$8,$2A,$18,$D0,$50,$1C,$78,$71,$80,$20,$D0,$40,$3A,$79,$10,$40
  DC.B $6,$D0,$20,$68,$38,$23,$DB,$43,$18,$40,$8,$23,$18,$43,$5,$E0,$20
  DC.B $68,$38,$23,$DB,$43,$18,$40,$28,$23,$18,$43,$20,$60,$79,$80         *1d4
  DC.B $0,$85,$0,$60,$F0,$BC,$8,$BC,$18,$47,$0,$28,$0,$D1,$79,$80,$20,$68,$38
  DC.B $23,$DB,$43,$18,$40,$28,$23,$18,$43,$20,$60,$F0,$BC,$8,$BC,$18,$47
  DC.B $48,$2B,$0,$40,$90,$B4,$2,$38,$7,$1,$3F,$1A,$9,$4A,$13,$5C,$FF
  DC.B $18,$9,$4C,$E1,$55,$59,$1C,$11,$54,$13,$5C,$0,$21,$F,$2B         *1d5
  DC.B $40,$85,$0,$60,$0,$DB,$11,$54,$5,$48,$2,$7D,$1,$32,$2,$75,$8,$1C,$90
  DC.B $BC,$70,$47,$0,$0,$6D,$2B,$0,$40,$38,$5A,$0,$40,$5C,$2B,$0,$40
  DC.B $B0,$B4,$0,$22,$11,$4B,$12,$4F,$BC,$5C,$9D,$5C,$AC,$42,$11,$D0,$93
  DC.B $1C,$3,$60,$10,$1,$80,$1A,$BB,$5C,$C0,$18,$D,$4B,$18,$5C         *1d6
  DC.B $80,$85,$0,$60,$8,$60,$B8,$5C,$1,$30,$B8,$54,$B8,$5C,$F,$28,$5,$DB,$0
  DC.B $20,$B8,$54,$2,$E0,$1,$32,$3,$2A,$E6,$DB,$3,$2A,$2,$DA,$1,$20
  DC.B $B0,$BC,$70,$47,$0,$20,$B0,$BC,$70,$47,$0,$0,$6D,$2B,$0,$40,$6A
  DC.B $2B,$0,$40,$38,$5A,$0,$40,$80,$B5,$18,$48,$0,$68,$5,$F0         *1d7
  DC.B $C0,$85,$0,$60,$25,$FE,$17,$4F,$38,$78,$3,$28,$D,$D1,$78,$69,$0,$28,$3
  DC.B $D0,$0,$21,$0,$20,$0,$F0,$26,$F8,$B8,$69,$0,$28,$3,$D0,$1,$21
  DC.B $0,$20,$0,$F0,$1F,$F8,$F8,$1D,$D9,$30,$0,$7A,$3,$28,$11,$D1,$F8
  DC.B $1D,$79,$30,$C0,$6F,$0,$28,$3,$D0,$0,$21,$1,$20,$0,$F0         *1d8
  DC.B $0,$86,$0,$60,$11,$F8,$F8,$1D,$F9,$30,$0,$68,$0,$28,$3,$D0,$1,$21,$1
  DC.B $20,$0,$F0,$8,$F8,$80,$BC,$8,$BC,$18,$47,$0,$0,$DC,$47,$0,$60
  DC.B $68,$58,$0,$40,$F0,$B4,$E8,$22,$42,$43,$81,$B0,$4D,$4B,$D6,$18,$8A
  DC.B $0,$B3,$18,$CA,$1,$B2,$18,$1,$24,$1F,$1D,$5D,$69,$E8,$23         *1d9
  DC.B $40,$86,$0,$60,$58,$43,$28,$32,$47,$4B,$C0,$18,$89,$0,$40,$18,$14,$30,$0
  DC.B $90,$66,$E0,$64,$0,$4,$32,$20,$1C,$28,$40,$FA,$D0,$A5,$43,$10,$68
  DC.B $C0,$5,$0,$F,$0,$28,$5B,$DD,$10,$68,$3F,$49,$1,$40,$FF,$23,$20
  DC.B $38,$E1,$33,$18,$40,$8,$43,$10,$60,$40,$9,$0,$7,$59,$D1         *1da
  DC.B $80,$86,$0,$60,$10,$68,$C0,$6,$C0,$E,$12,$28,$5B,$D2,$2,$A3,$1B,$5C,$5B
  DC.B $0,$9F,$44,$0,$1C,$9,$11,$5B,$27,$5B,$5B,$2E,$2E,$2E,$2E,$2E,$2E
  DC.B $2E,$2E,$47,$5B,$60,$19,$E1,$43,$38,$68,$8,$40,$38,$60,$0,$98,$3
  DC.B $68,$19,$40,$5,$E0,$38,$68,$20,$43,$38,$60,$0,$98,$1,$68         *1db
  DC.B $C0,$86,$0,$60,$A1,$43,$1,$60,$41,$E0,$38,$68,$20,$40,$4,$D0,$FF,$23,$E1
  DC.B $33,$10,$68,$18,$43,$43,$E0,$10,$68,$23,$4B,$18,$40,$20,$23,$18,$43
  DC.B $3D,$E0,$10,$68,$20,$4B,$18,$40,$FF,$23,$41,$33,$18,$43,$36,$E0,$38
  DC.B $68,$20,$40,$7,$D0,$11,$68,$C8,$6,$C0,$E,$80,$0,$30,$18         *1dc
  DC.B $0,$87,$0,$60,$40,$68,$0,$7,$6,$E0,$11,$68,$C8,$6,$C0,$E,$80,$0,$30
  DC.B $18,$40,$68,$0,$6,$0,$F,$14,$4B,$19,$40,$40,$1,$8,$43,$1E,$E0
  DC.B $13,$E0,$38,$68,$20,$40,$6,$D0,$10,$68,$F,$4B,$18,$40,$60,$23,$18
  DC.B $43,$14,$E0,$9,$E0,$10,$68,$B,$4B,$18,$40,$40,$23,$18,$43         *1dd
  DC.B $40,$87,$0,$60,$D,$E0,$2,$E0,$38,$68,$60,$40,$38,$60,$0,$2D,$83,$D1,$1
  DC.B $B0,$F0,$BC,$70,$47,$10,$68,$4,$4B,$18,$40,$A0,$23,$18,$43,$10,$60
  DC.B $F0,$E7,$0,$0,$68,$58,$0,$40,$1F,$FE,$FF,$FF,$F0,$B5,$7,$1C,$1C
  DC.B $4D,$1D,$4C,$29,$E0,$A8,$6F,$5,$F0,$48,$FD,$C0,$28,$1C,$D0         *1de
  DC.B $80,$87,$0,$60,$7,$DC,$19,$28,$D,$D0,$1A,$28,$1B,$D1,$3,$2F,$11,$D1,$0
  DC.B $20,$10,$E0,$C7,$28,$19,$D0,$CF,$28,$13,$D1,$38,$1C,$0,$F0,$A4,$F8
  DC.B $13,$E0,$3,$2F,$1,$D1,$0,$20,$0,$E0,$1,$20,$0,$F0,$BC,$F8,$B
  DC.B $E0,$1,$20,$0,$F0,$5E,$F9,$7,$E0,$38,$1C,$0,$F0,$6E,$F8         *1df
  DC.B $C0,$87,$0,$60,$3,$E0,$38,$1C,$31,$1C,$0,$F0,$11,$F8,$E8,$6F,$5,$F0,$1E
  DC.B $FD,$0,$28,$2,$D9,$20,$68,$0,$28,$CD,$D0,$0,$20,$20,$60,$F0,$BC
  DC.B $8,$BC,$18,$47,$2C,$3,$1,$0,$5C,$2B,$0,$40,$90,$B5,$C,$6,$24
  DC.B $E,$7,$1C,$1,$20,$9,$49,$8,$60,$FD,$F7,$38,$FE,$C2,$21         *1e0
  DC.B $0,$88,$0,$60,$C1,$72,$4,$73,$7,$71,$2,$21,$C1,$71,$5,$49,$2,$1C,$1
  DC.B $20,$FD,$F7,$4A,$FE,$90,$BC,$8,$BC,$18,$47,$0,$0,$5C,$2B,$0,$40
  DC.B $D0,$3D,$0,$40,$80,$B5,$7,$6,$3F,$E,$38,$1C,$0,$F0,$36,$F8,$A
  DC.B $20,$3,$2F,$1,$D1,$0,$21,$0,$E0,$1,$21,$E8,$23,$59,$43         *1e1
  DC.B $40,$88,$0,$60,$12,$4A,$89,$18,$48,$70,$9,$20,$40,$3,$1,$6A,$49,$B,$49
  DC.B $3,$5,$23,$5B,$2,$19,$43,$1,$62,$1,$6A,$1,$23,$5B,$3,$19,$43
  DC.B $1,$62,$17,$20,$0,$3,$41,$68,$9,$4B,$19,$40,$41,$60,$1,$68,$DB
  DC.B $43,$19,$43,$1,$60,$7,$48,$1,$78,$1,$31,$1,$70,$6,$48         *1e2
  DC.B $80,$88,$0,$60,$1,$7D,$1,$31,$1,$75,$80,$BC,$8,$BC,$18,$47,$68,$58,$0
  DC.B $40,$FF,$FF,$FD,$FF,$E6,$2A,$0,$40,$5C,$2B,$0,$40,$80,$B5,$7,$6
  DC.B $3F,$E,$FD,$F7,$E4,$FD,$7,$71,$C1,$21,$C1,$72,$9D,$21,$1,$73,$B
  DC.B $49,$49,$68,$0,$29,$1,$D0,$F,$21,$0,$E0,$A,$21,$41,$73         *1e3
  DC.B $C0,$88,$0,$60,$3,$2F,$1,$D1,$10,$21,$0,$E0,$20,$21,$81,$73,$4,$21,$C1
  DC.B $71,$4,$49,$2,$1C,$1,$20,$FD,$F7,$E7,$FD,$80,$BC,$8,$BC,$18,$47
  DC.B $5C,$2B,$0,$40,$D0,$3D,$0,$40,$90,$B5,$7,$6,$3F,$E,$C,$4C,$E0
  DC.B $6F,$5,$F0,$8B,$FC,$1,$28,$6,$D2,$CF,$21,$38,$1C,$FF,$F7         *1e4
  DC.B $0,$89,$0,$60,$75,$FF,$90,$BC,$8,$BC,$18,$47,$A0,$6F,$5,$F0,$7F,$FC,$C1
  DC.B $6,$C9,$E,$4,$4A,$38,$1C,$FE,$F7,$AA,$FF,$90,$BC,$8,$BC,$18,$47
  DC.B $2C,$3,$1,$0,$59,$24,$0,$40,$F0,$B5,$E8,$23,$7,$1C,$58,$43,$81
  DC.B $B0,$4B,$4E,$80,$19,$C5,$1D,$21,$35,$4A,$48,$0,$90,$C0,$6F         *1e5
  DC.B $40,$89,$0,$60,$5,$F0,$64,$FC,$1,$28,$60,$D9,$0,$98,$80,$6F,$5,$F0,$5E
  DC.B $FC,$0,$11,$4,$7,$24,$F,$0,$98,$80,$6F,$5,$F0,$57,$FC,$42,$49
  DC.B $49,$68,$0,$29,$C,$D0,$41,$6,$49,$E,$30,$29,$8,$DD,$30,$38,$0
  DC.B $6,$0,$E,$E8,$21,$1,$37,$79,$43,$89,$19,$CD,$1D,$21,$35         *1e6
  DC.B $80,$89,$0,$60,$1,$2C,$1C,$D0,$0,$2C,$1A,$D0,$3,$2C,$18,$D0,$6,$2C,$16
  DC.B $D0,$7,$2C,$14,$D0,$8,$2C,$12,$D0,$9,$2C,$10,$D0,$A,$2C,$E,$D0
  DC.B $B,$2C,$C,$D0,$C,$2C,$A,$D0,$D,$2C,$8,$D0,$E,$2C,$6,$D0,$0
  DC.B $2F,$52,$D0,$4F,$E0,$19,$21,$FF,$F7,$18,$FF,$45,$E0,$0,$28         *1e7
  DC.B $C0,$89,$0,$60,$24,$DD,$31,$28,$22,$DA,$1,$38,$0,$6,$0,$E,$81,$0,$49
  DC.B $19,$A,$68,$52,$9,$52,$1,$E3,$6,$DB,$E,$1A,$43,$23,$4B,$1A,$40
  DC.B $20,$23,$1A,$43,$A,$60,$1,$21,$20,$28,$4,$DA,$E8,$22,$7A,$43,$92
  DC.B $19,$14,$32,$4,$E0,$E8,$22,$7A,$43,$92,$19,$20,$38,$18,$32         *1e8
  DC.B $0,$8A,$0,$60,$81,$40,$10,$68,$8,$43,$10,$60,$1F,$E0,$1E,$E0,$FC,$28,$1C
  DC.B $D0,$FD,$28,$1E,$D1,$0,$20,$E1,$6,$C9,$E,$C,$E0,$2A,$68,$52,$9
  DC.B $52,$1,$A,$43,$11,$4B,$1A,$40,$20,$23,$1A,$43,$1,$30,$0,$6,$0
  DC.B $E,$2A,$60,$4,$35,$30,$28,$F0,$DB,$0,$20,$C0,$43,$E8,$21         *1e9
  DC.B $40,$8A,$0,$60,$79,$43,$89,$19,$48,$61,$A,$48,$88,$61,$1,$B0,$F0,$BC,$8
  DC.B $BC,$18,$47,$0,$2F,$1,$D0,$4,$20,$AD,$E7,$3,$20,$AB,$E7,$0,$0
  DC.B $68,$58,$0,$40,$2C,$3,$1,$0,$5C,$2B,$0,$40,$1F,$FE,$FF,$FF,$FF
  DC.B $FF,$0,$0,$F0,$B5,$E8,$23,$7,$1C,$58,$43,$81,$B0,$24,$49         *1ea
  DC.B $80,$8A,$0,$60,$0,$91,$40,$18,$C6,$1D,$15,$36,$22,$4D,$E8,$6F,$5,$F0,$BE
  DC.B $FB,$1,$28,$39,$D9,$A8,$6F,$5,$F0,$B9,$FB,$4,$1C,$A8,$6F,$5,$F0
  DC.B $B5,$FB,$6,$2C,$24,$DB,$D,$2C,$22,$DC,$A1,$0,$8A,$19,$18,$3A,$F0
  DC.B $23,$17,$68,$9F,$43,$3C,$1C,$7,$1C,$1F,$40,$3C,$43,$23,$9         *1eb
  DC.B $C0,$8A,$0,$60,$1B,$1,$0,$7,$0,$F,$3,$43,$13,$60,$13,$4A,$52,$68,$0
  DC.B $2A,$16,$D0,$0,$9A,$FF,$32,$5,$32,$89,$18,$18,$39,$F0,$23,$DB,$43
  DC.B $A,$68,$1A,$40,$3A,$43,$12,$9,$12,$1,$10,$43,$8,$60,$7,$E0,$0
  DC.B $2F,$1,$D0,$4,$20,$0,$E0,$3,$20,$19,$21,$FF,$F7,$76,$FE         *1ec
  DC.B $0,$8B,$0,$60,$1,$B0,$F0,$BC,$8,$BC,$18,$47,$0,$2F,$F5,$D0,$F2,$E7,$0
  DC.B $0,$68,$58,$0,$40,$2C,$3,$1,$0,$5C,$2B,$0,$40,$0,$20,$1F,$49
  DC.B $48,$60,$1F,$48,$41,$68,$1,$23,$5B,$3,$19,$43,$41,$60,$41,$68,$1B
  DC.B $1,$19,$43,$41,$60,$C1,$68,$1B,$9,$19,$43,$C1,$60,$C1,$68         *1ed
  DC.B $40,$8B,$0,$60,$1B,$1,$19,$43,$C1,$60,$C1,$69,$16,$4B,$19,$40,$C1,$61,$C1
  DC.B $69,$15,$4B,$19,$40,$C1,$61,$41,$69,$1,$23,$5B,$3,$19,$43,$41,$61
  DC.B $41,$69,$1B,$1,$19,$43,$41,$61,$9,$20,$40,$3,$1,$6A,$49,$B,$49
  DC.B $3,$5,$23,$5B,$2,$19,$43,$1,$62,$1,$6A,$1,$23,$5B,$3         *1ee
  DC.B $80,$8B,$0,$60,$19,$43,$1,$62,$17,$20,$0,$3,$41,$68,$7,$4B,$19,$40,$41
  DC.B $60,$1,$68,$DB,$43,$19,$43,$1,$60,$70,$47,$0,$0,$5C,$2B,$0,$40
  DC.B $0,$60,$0,$E0,$FF,$DF,$FF,$FF,$FF,$FF,$FD,$FF,$B0,$B4,$C1,$0,$9
  DC.B $23,$5B,$3,$CC,$18,$21,$68,$C2,$0,$D7,$18,$7A,$68,$F,$25         *1ef
  DC.B $C0,$8B,$0,$60,$2D,$6,$D,$40,$5,$23,$5B,$6,$9D,$42,$1,$D1,$1,$25,$0
  DC.B $E0,$0,$25,$18,$4B,$1D,$54,$E8,$23,$58,$43,$D,$1C,$16,$4B,$C0,$18
  DC.B $85,$73,$9,$A,$41,$73,$9,$A,$1,$73,$11,$A,$41,$74,$9,$A,$1
  DC.B $74,$9,$A,$C1,$73,$2,$1D,$6,$CA,$40,$78,$0,$6,$D,$4         *1f0
  DC.B $0,$8C,$0,$60,$FF,$23,$1B,$4,$2B,$40,$18,$43,$FF,$23,$1B,$2,$B,$40,$18
  DC.B $43,$B,$C,$1B,$6,$1B,$E,$18,$43,$20,$61,$8,$E,$0,$6,$11,$4
  DC.B $FF,$23,$1B,$4,$19,$40,$8,$43,$19,$A,$11,$40,$8,$43,$78,$61,$B0
  DC.B $BC,$70,$47,$68,$2B,$0,$40,$68,$58,$0,$40,$F0,$B5,$0,$27         *1f1
  DC.B $40,$8C,$0,$60,$0,$20,$0,$21,$23,$4D,$6A,$5C,$0,$2A,$28,$D0,$FF,$28,$26
  DC.B $D0,$0,$22,$E8,$23,$4B,$43,$20,$4E,$9B,$19,$9E,$18,$36,$7B,$0,$2E
  DC.B $13,$D0,$0,$28,$17,$D1,$1,$20,$9,$E0,$F4,$7,$E4,$F,$1,$2C,$7
  DC.B $D0,$74,$10,$26,$6,$36,$E,$1,$30,$0,$6,$0,$E,$9,$28         *1f2
  DC.B $80,$8C,$0,$60,$F3,$DB,$C0,$19,$0,$6,$0,$E,$C,$1C,$8,$37,$3F,$6,$3F
  DC.B $E,$1,$32,$6,$2A,$E1,$DB,$0,$27,$1,$31,$2,$29,$D3,$D3,$FF,$28
  DC.B $14,$D0,$E,$49,$8A,$7D,$90,$42,$10,$D0,$0,$28,$2,$D1,$8C,$69,$88
  DC.B $75,$7,$E0,$0,$2A,$9,$D1,$88,$75,$0,$6,$0,$E,$40,$22         *1f3
  DC.B $C0,$8C,$0,$60,$2,$43,$8C,$61,$E0,$1C,$11,$1C,$FF,$F7,$2C,$FC,$F0,$BC,$8
  DC.B $BC,$18,$47,$0,$0,$68,$2B,$0,$40,$68,$58,$0,$40,$5C,$2B,$0,$40
  DC.B $93,$63,$2F,$3F,$A3,$C3,$87,$8B,$15,$5,$11,$9,$1,$0,$0,$8,$0
  DC.B $1,$0,$1,$0,$1,$0,$1,$1,$9,$0,$1,$0,$1,$0,$1         *1f4
  DC.B $0,$8D,$0,$60,$0,$1,$0,$2,$1,$2,$1,$2,$1,$2,$1,$2,$0,$3,$1
  DC.B $3,$2,$3,$3,$3,$4,$3,$0,$1,$1,$4,$2,$4,$3,$8,$4,$8
  DC.B $0,$1,$0,$1,$0,$1,$3,$8,$4,$8,$0,$8,$0,$1,$0,$1,$0
  DC.B $1,$0,$1,$0,$8,$2,$7,$2,$8,$4,$7,$4,$8,$0,$8         *1f5
  DC.B $40,$8D,$0,$60,$3,$6,$4,$6,$3,$6,$4,$6,$0,$8,$3,$8,$4,$8,$3
  DC.B $8,$4,$8,$0,$8,$1,$6,$2,$6,$1,$6,$2,$6,$0,$8,$1,$4
  DC.B $2,$4,$1,$4,$2,$4,$0,$8,$1,$8,$2,$8,$1,$8,$2,$8,$0
  DC.B $8,$1,$5,$1,$5,$3,$5,$3,$5,$0,$0,$0,$0,$0,$0         *1f6
  DC.B $80,$8D,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $84,$2B,$0,$40,$0,$0,$0,$0,$D0,$29,$0,$40,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$4,$0,$6,$0         *1f7
  DC.B $C0,$8D,$0,$60,$8,$0,$A,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$3,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *1f8
  DC.B $0,$8E,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$12,$80,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$3,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *1f9
  DC.B $40,$8E,$0,$60,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *1fa
  DC.B $80,$8E,$0,$60,$0,$0,$24,$B0,$7F,$0,$B2,$94,$DF,$D4,$0,$24,$B0,$71,$5
  DC.B $B2,$DF,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$7C,$56,$0,$40,$87,$56,$0,$40         *1fb
  DC.B $C0,$8E,$0,$60,$D0,$56,$0,$40,$DB,$56,$0,$40,$24,$57,$0,$40,$2F,$57,$0
  DC.B $40,$78,$57,$0,$40,$83,$57,$0,$40,$CC,$57,$0,$40,$D7,$57,$0,$40
  DC.B $20,$58,$0,$40,$2B,$58,$0,$40,$2C,$54,$0,$40,$37,$54,$0,$40,$42
  DC.B $54,$0,$40,$4D,$54,$0,$40,$0,$0,$0,$0,$0,$0,$0,$0         *1fc
  DC.B $0,$8F,$0,$60,$0,$0,$0,$2,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
  DC.B $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0         *1fd
  DC.B $40,$8F,$0,$60,$0,$0,$0,$0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
  DC.B $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF         *1fe
fw_ss4150hr3_end

